<?php
class ControllerExtensionHbappsGoogleEcommerce extends Controller {
	
	protected $registry;
	private $error = array(); 
	
	public function __construct($registry) {
		$this->registry = $registry;
		if (version_compare(VERSION,'3.0.0.0','>=' )) {
			$this->hb_template_folder 		= 'oc3';
			$this->hb_extension_base 		= 'marketplace/extension';
			$this->hb_token_name 			= 'user_token';
			$this->hb_template_extension 	= '';
			$this->hb_extension_route 		= 'extension/hbapps';
		}else if (version_compare(VERSION,'2.2.0.0','<=' )) {
			$this->hb_template_folder 		= 'oc2';
			$this->hb_extension_base 		= 'extension/hbapps';
			$this->hb_token_name 			= 'token';
			$this->hb_template_extension 	= '.tpl';
			$this->hb_extension_route 		= 'hbapps';
		}else{
			$this->hb_template_folder 		= 'oc2';
			$this->hb_extension_base 		= 'extension/extension';
			$this->hb_token_name 			= 'token';
			$this->hb_template_extension 	= '';
			$this->hb_extension_route 		= 'extension/hbapps';
		}
		
		$this->hb_extension_version	= '3.0.2';
	}
	
	public function index() {   
		$data['extension_version'] = $this->hb_extension_version;
				
		if (isset($this->request->get['store_id'])){
			$data['store_id'] = (int)$this->request->get['store_id'];
		}else{
			$data['store_id'] = 0;
		}
		
		$this->load->language($this->hb_extension_route.'/google_ecommerce');
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/store');
		$data['stores'] = $this->model_setting_store->getStores();

		$this->load->model('setting/setting');
		
		$store_info = $this->model_setting_setting->getSetting('ga_ecom', $this->request->get['store_id']);
		
		//Save the settings if the user has submitted the admin form (ie if someone has pressed save).
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('ga_ecom', $this->request->post, $this->request->get['store_id']);	
			
			$this->session->data['success'] = $this->language->get('text_success');
			$this->response->redirect($this->url->link($this->hb_extension_route.'/google_ecommerce', $this->hb_token_name.'=' . $this->session->data[$this->hb_token_name].'&store_id='.$data['store_id'], true));
		}
		
		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		
		$text_strings = array(
				'heading_title','button_save','button_cancel'
		);
		
		foreach ($text_strings as $text) {
			$data[$text] = $this->language->get($text);
		}
	
 		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
  		$data['breadcrumbs'] = array();

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/dashboard', $this->hb_token_name.'=' . $this->session->data[$this->hb_token_name], true)
   		);
		
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link($this->hb_extension_base, $this->hb_token_name.'=' . $this->session->data[$this->hb_token_name] . '&type=hbapps', true)
		);

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link($this->hb_extension_route.'/google_ecommerce', $this->hb_token_name.'=' . $this->session->data[$this->hb_token_name].'&store_id='.$data['store_id'], true)
   		);
		
		$data['action'] = $this->url->link($this->hb_extension_route.'/google_ecommerce', $this->hb_token_name.'=' . $this->session->data[$this->hb_token_name].'&store_id='.$data['store_id'], true);
		
		$data['cancel'] = $this->url->link($this->hb_extension_base, $this->hb_token_name.'=' . $this->session->data[$this->hb_token_name] . '&type=hbapps', true);
		$data[$this->hb_token_name] = $this->session->data[$this->hb_token_name];
		$data['base_route'] = $this->hb_extension_route;
		
		$data['clear'] = $this->url->link($this->hb_extension_route.'/google_ecommerce/clear_logs', $this->hb_token_name.'=' . $this->session->data[$this->hb_token_name].'&store_id='.$data['store_id'], true);

		$this->load->model('localisation/currency');
		$data['currencies'] = $this->model_localisation_currency->getCurrencies();
		
		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();
		
		//Google Analytics Ecommerce
		$data['ga_ecom_tracking_code'] 		= (isset($store_info['ga_ecom_tracking_code']))? $store_info['ga_ecom_tracking_code'] : '';
		$data['ga_ecom_admin_tracking_code']= (isset($store_info['ga_ecom_admin_tracking_code']))? $store_info['ga_ecom_admin_tracking_code'] : '';
		$data['ga_ecom_measurement_id'] 	= (isset($store_info['ga_ecom_measurement_id']))? $store_info['ga_ecom_measurement_id'] : '';
		$data['ga_ecom_language_id'] 		= (isset($store_info['ga_ecom_language_id']))? $store_info['ga_ecom_language_id'] : $this->config->get('language_id');
		$data['ga_ecom_id'] 				= (isset($store_info['ga_ecom_id']))? $store_info['ga_ecom_id'] : 'product_id';
		$data['ga_ecom_currency'] 			= (isset($store_info['ga_ecom_currency']))? $store_info['ga_ecom_currency'] : $this->config->get('config_currency');
		$data['ga_ecom_user_tracking'] 		= isset($store_info['ga_ecom_user_tracking'])?$store_info['ga_ecom_user_tracking']:'';
		$data['ga_ecom_ip_match'] 			= isset($store_info['ga_ecom_ip_match'])?$store_info['ga_ecom_ip_match']:'';
		$data['ga_ecom_event_language'] 	= isset($store_info['ga_ecom_event_language'])?$store_info['ga_ecom_event_language']:'';
		
		$data['custom_dimensions'] = array('customer_id', 'payment_method', 'shipping_method', 'payment_city', 'payment_country', 'payment_zone', 'shipping_city', 'shipping_country', 'shipping_zone', 'affiliate_id','language_code','order_status');
		
		$data['ga_ecom_dimensions'] = isset($store_info['ga_ecom_dimensions'])? $store_info['ga_ecom_dimensions']:array();
		foreach ($data['custom_dimensions'] as $d) {
			$data['ga_ecom_d'][$d] = isset($store_info['ga_ecom_d_'.$d])? $store_info['ga_ecom_d_'.$d]:'';
		}
		
		$data['generate_custom_dimension_config'] = '';
		if (!empty($data['ga_ecom_dimensions'])) {
			foreach ($data['ga_ecom_dimensions'] as $dimension) {
				$custom_dimension_script[] = "'".$data['ga_ecom_d'][$dimension]."':'".$dimension."'";
			}

			$data['generate_custom_dimension_config'] .= "gtag('config', '".$data['ga_ecom_measurement_id']."', {'custom_map': {".implode(',', $custom_dimension_script)."}});\n";
			
		}
		
		//$data['generate_custom_dimension_config'] = htmlentities($data['generate_custom_dimension_config']);
		
		//Ads Conversion
		$data['ga_ecom_ads_conversion_status'] 	= (isset($store_info['ga_ecom_ads_conversion_status']))? $store_info['ga_ecom_ads_conversion_status'] : '';
		$data['ga_ecom_sale_conversion'] 		= (isset($store_info['ga_ecom_sale_conversion']))? $store_info['ga_ecom_sale_conversion'] : '';
		$data['ga_ecom_signup_conversion'] 		= (isset($store_info['ga_ecom_signup_conversion']))? $store_info['ga_ecom_signup_conversion'] : '';
		
		//facebook
		$data['ga_ecom_fb_px_status'] 	= (isset($store_info['ga_ecom_fb_px_status']))? $store_info['ga_ecom_fb_px_status'] : '';
		$data['ga_ecom_fb_px_id'] 		= (isset($store_info['ga_ecom_fb_px_id']))? $store_info['ga_ecom_fb_px_id'] : '';
		
		//logs
		$data['ga_ecom_debug_logs'] 		= (isset($store_info['ga_ecom_debug_logs']))? $store_info['ga_ecom_debug_logs'] : '';
				
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/hbapps/'.$this->hb_template_folder.'/google_ecommerce'.$this->hb_template_extension, $data));

	}
	
	public function logs(){
		if (!file_exists(DIR_LOGS . 'huntbee_ga_logs')) {
			mkdir(DIR_LOGS . 'huntbee_ga_logs', 0777, true);
		}

		$file = DIR_LOGS . 'huntbee_ga_logs/ga_logs.txt';
		if (file_exists($file)) {
			$data['log'] = file_get_contents($file, FILE_USE_INCLUDE_PATH, null);
		}else{
			$data['log'] = '';
		}
		$this->response->setOutput($this->load->view('extension/hbapps/'.$this->hb_template_folder.'/google_ecommerce_worklog'.$this->hb_template_extension, $data));
	}
	
	public function clear_logs() {
		if (isset($this->request->get['store_id'])){
			$data['store_id'] = (int)$this->request->get['store_id'];
		}else{
			$data['store_id'] = 0;
		}
		
		if (!$this->validate()) {
			$this->session->data['error'] = $this->language->get('error_permission');
		} else {
			$file = DIR_LOGS . 'huntbee_ga_logs/ga_logs.txt';

			$handle = fopen($file, 'w+');

			fclose($handle);

			$this->session->data['success'] = 'Success: You have successfully cleared your logs!';
		}

		$this->response->redirect($this->url->link($this->hb_extension_route.'/google_ecommerce', $this->hb_token_name.'=' . $this->session->data[$this->hb_token_name].'&store_id='.$data['store_id'], true));
	}
	
	public function ga_refund_block(){
		$order_id = (int)$this->request->get['order_id'];
		
		$data['products'] = array();
		$product_query = $this->db->query("SELECT * FROM `".DB_PREFIX."order_product` WHERE order_id = '".(int)$order_id."'");
		if ($product_query->rows){
			$products = $product_query->rows;
			foreach ($products as $product){
				$data['products'][] = array(
					'product_id'		=> $product['product_id'],
					'name'				=> $product['name']
				);
			}
		}
		
		$data['action'] = $this->url->link($this->hb_extension_route.'/google_ecommerce/send_info_to_ga', $this->hb_token_name.'=' . $this->session->data[$this->hb_token_name].'&order_id='.$order_id, true);
		$this->response->setOutput($this->load->view('extension/hbapps/'.$this->hb_template_folder.'/google_ecommerce_refund'.$this->hb_template_extension, $data));
	}
	
	public function send_info_to_ga(){
		$order_id = (int)$this->request->get['order_id'];
		
		$product = (int)$this->request->post['ga_refund_products'];
		if (isset($this->request->post['ga_refund_qty'])) {
			$qty = $this->request->post['ga_refund_qty'];
		}else{
			$qty = 1;
		}
		
		$this->load->model('sale/order');
		$order_info = $this->model_sale_order->getOrder($order_id);
		
		$this->load->model('setting/setting');

		$extn_info = $this->model_setting_setting->getSetting('ga_ecom', $order_info['store_id']);
		
		$ga_ecom_id = (isset($extn_info['ga_ecom_id']))? $extn_info['ga_ecom_id'] : 'product_id';
		$ga_ecom_tracking_code = (isset($extn_info['ga_ecom_tracking_code']))? $extn_info['ga_ecom_tracking_code'] : '';
		
		$ga_ecom_language_id = (isset($extn_info['ga_ecom_language_id']))? $extn_info['ga_ecom_language_id'] : '';

		if ($ga_ecom_language_id <> 0) {
			$language_id = $ga_ecom_language_id;
		}else{
			$language_id = $this->config->get('config_language_id');
		}
		
		$tracking_code  = '';
		
		if ($product == 0){
			$tracking_code .= "gtag('event', 'refund', ";
			$tracking_code .= '{ "transaction_id": "'.$order_id.'" });';
		}else{
			if ($ga_ecom_id == 'sku') {
				$id = $this->getProductSku($product);
			}else{
				$id = $product;
			}
			
			$product_query = $this->db->query("SELECT name FROM `".DB_PREFIX."product_description` WHERE language_id = '".(int)$language_id."' AND product_id = '".(int)$product."' LIMIT 1");
			$product_name = $product_query->row['name'];
			$tracking_code .= "gtag('event', 'refund', {";
			$tracking_code .= '"transaction_id": "'.$order_id.'", "items": [{"id": "'.$id.'", "name": "'.$product_name.'","list_name": "Admin Refund Page","quantity": '.$qty.'}]});';
		}
		
		echo '<!DOCTYPE html><html><head><meta charset="UTF-8"><title>Send Refund Info to GA</title><meta name="viewport" content="width=device-width, initial-scale=1"><link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css"><script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script><script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script><script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script><link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha384-wvfXpqpZZVQGK6TAh5PVlGOfQNHSoD2xbE+QkPxCAFlNEevoEH3Sl0sibVcOQVnN" crossorigin="anonymous">';
		echo html_entity_decode($ga_ecom_tracking_code);
		echo '</head><body>';
		echo '<script type="text/javascript">';
		echo $tracking_code;
		echo '</script>';
		echo '<div class="jumbotron text-center"><h1><i class="fa fa-check" aria-hidden="true"></i>&nbsp;Enhanced Ecommerce Refund tracking data sent to Google Analytics.</h1> <p>You can close this page now.</p></div>';
		echo '<footer class="footer">
      <div class="container">
        <span class="text-muted"><center>Powered by <a href="https://www.huntbee.com/">huntbee.com</a></center></span>
      </div>
    </footer></body></html>';

	}
	
	public function getProductSku($product_id){
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` WHERE product_id = '".(int)$product_id."' LIMIT 1");
		if ($query->row){
			if ($query->row['sku'] == '') {
				return 'Product ID: '.$product_id. ' - Model: '.$query->row['model'];
			}else {
				return $query->row['sku'];
			}
		} else {
			return $product_id;	
		}
	}
	
	private function validate() {
		if (!$this->user->hasPermission('modify', $this->hb_extension_route.'/google_ecommerce')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}	
	}
	
	public function install(){
		$this->db->query("DELETE FROM " . DB_PREFIX . "modification WHERE `code` = 'huntbee_analytics_ecommerce_ocmod'");
		
		if (version_compare(VERSION,'2.2.0.0','<' )) {
			$theme = $this->config->get('config_template');
		}else if (version_compare(VERSION,'3.0.0.0','>' )) {
			$theme = $this->config->get('config_theme');
		} else {
			$theme = $this->config->get('theme_default_directory');
		}
		
		
		if ($theme == 'journal2') {
			$template_name = 'journal2';
		}else if ($theme == 'journal3') {
			$template_name = 'journal3';
		}else{
			$template_name = 'default';
		}
		
		if ((version_compare(VERSION,'2.0.0.0','>=' )) and (version_compare(VERSION,'2.3.0.0','<' ))) {
			$ocmod_filename = 'ocmod_ga_ecommerce_'.$template_name.'_2000_2200.txt';
			$ocmod_name = 'Ecommerce Analytics PRO ['.$template_name.'] [2000-2200]';
		}else if ((version_compare(VERSION,'2.3.0.0','>=' )) and (version_compare(VERSION,'3.0.0.0','<' ))) {
			$ocmod_filename = 'ocmod_ga_ecommerce_'.$template_name.'_23xx.txt';
			$ocmod_name = 'Ecommerce Analytics PRO ['.$template_name.'] [23xx]';
		}else if (version_compare(VERSION,'3.0.0.0','>=' )) {
			$ocmod_filename = 'ocmod_ga_ecommerce_'.$template_name.'_3xxx.txt';
			$ocmod_name = 'Ecommerce Analytics PRO ['.$template_name.'] [3xxx]';
		}
		
		$ocmod_version = $this->hb_extension_version;
		$ocmod_code = 'huntbee_analytics_ecommerce_ocmod';	
		$ocmod_author = 'HuntBee OpenCart Services';
		$ocmod_link = 'https://www.huntbee.com';
		
		$file = DIR_APPLICATION . 'view/template/extension/hbapps/ocmod/'.$ocmod_filename;
		if (file_exists($file)) {
			$ocmod_xml = file_get_contents($file, FILE_USE_INCLUDE_PATH, null);
			$this->db->query("INSERT INTO " . DB_PREFIX . "modification SET code = '" . $this->db->escape($ocmod_code) . "', name = '" . $this->db->escape($ocmod_name) . "', author = '" . $this->db->escape($ocmod_author) . "', version = '" . $this->db->escape($ocmod_version) . "', link = '" . $this->db->escape($ocmod_link) . "', xml = '" . $this->db->escape($ocmod_xml) . "', status = '1', date_added = NOW()");
		}
		
		$data['success'] = 'This extension has been installed successfully';
	}
	
	public function uninstall(){
		$this->db->query("DELETE FROM " . DB_PREFIX . "modification WHERE `code` = 'huntbee_analytics_ecommerce_ocmod'");
		$data['success'] = 'This extension is uninstalled successfully';
	}
	
}
?>