<?php
class ControllerExtensionModuleTmdSkuupc extends Controller {
	private $error = array();
public function install()
	{
	$this->load->model('extension/tmd_skuupc');
	$this->model_extension_tmd_skuupc->install();
	}	
	public function uninstall()
	{
	$this->load->model('extension/tmd_skuupc');
	$this->model_extension_tmd_skuupc->uninstall();
	}
	public function index() {
		$this->load->language('extension/module/tmd_skuupc');

		$this->document->setTitle($this->language->get('heading_title1'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			
			if(isset($this->request->post['tmd_skuupc_status']))
			{
				$status=$this->request->post['tmd_skuupc_status'];
			}
			
			$postdata['module_tmd_skuupc_status']=$status;
			
			$this->model_setting_setting->editSetting('module_tmd_skuupc',$postdata);
			
			$this->model_setting_setting->editSetting('tmd_skuupc', $this->request->post);
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token']. '&type=module', true));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');

		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_enablesku'] = $this->language->get('entry_enablesku');
		$data['entry_enableupc'] = $this->language->get('entry_enableupc');
		$data['entry_skulabel'] = $this->language->get('entry_skulabel');
		$data['entry_upclabel'] = $this->language->get('entry_upclabel');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_module'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title1'),
			'href' => $this->url->link('extension/module/tmd_skuupc', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/module/tmd_skuupc', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], true);
		
		if (isset($this->request->post['tmd_skuupc_upc'])) {
			$data['tmd_skuupc_upc'] = $this->request->post['tmd_skuupc_upc'];
		} else {
			$data['tmd_skuupc_upc'] = $this->config->get('tmd_skuupc_upc');
		}
		
		if (isset($this->request->post['tmd_skuupc_sku'])) {
			$data['tmd_skuupc_sku'] = $this->request->post['tmd_skuupc_sku'];
		} else {
			$data['tmd_skuupc_sku'] = $this->config->get('tmd_skuupc_sku');
		}
		
		if (isset($this->request->post['tmd_skuupc_skulabel'])) {
			$data['tmd_skuupc_skulabel'] = $this->request->post['tmd_skuupc_skulabel'];
		} else {
			$data['tmd_skuupc_skulabel'] = $this->config->get('tmd_skuupc_skulabel');
		}
		
		if (isset($this->request->post['tmd_skuupc_upclabel'])) {
			$data['tmd_skuupc_upclabel'] = $this->request->post['tmd_skuupc_upclabel'];
		} else {
			$data['tmd_skuupc_upclabel'] = $this->config->get('tmd_skuupc_upclabel');
		}
		
		if (isset($this->request->post['tmd_skuupc_status'])) {
			$data['tmd_skuupc_status'] = $this->request->post['tmd_skuupc_status'];
		} else {
			$data['tmd_skuupc_status'] = $this->config->get('tmd_skuupc_status');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/tmd_skuupc', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/tmd_skuupc')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}
