<?php
class ControllerExtensionModuleXabandonedCarts extends Controller {
	private $error = array();
	private $data = array();

	public function __construct($registry) {
		parent::__construct($registry);
		$this->config->load('xtensions/xabandoned');		
		$this->module_token = $this->config->get('xabandoned_token') . '=' . $this->session->data[$this->config->get('xabandoned_token')];
		$this->data = $this->language->load($this->config->get('xabandoned_path'));
		$this->data['config_pfx'] = $this->xabandoned_config_pfx = $this->config->get('xabandoned_config_pfx');
		$this->data['module_path'] = $this->config->get('xabandoned_path');
		$this->setting_name = $this->config->get('xabandoned_setting');
		$this->load->model($this->config->get('xabandoned_path'));
		$this->module_model_object = $this->{$this->config->get('xabandoned_model')};
		$this->module_model_object->install();
		$this->view_extension = $this->config->get('xabandoned_view_extension');
		$this->back_button = $this->url->link($this->config->get('xabandoned_back_button'), $this->module_token, true);
		$this->data['module_token'] = $this->module_token;
		$this->document->addStyle($this->config->get('xabandoned_css_path').'module.css');
		$this->data['cancel'] = $this->back_button;
		$this->data['module_link'] = $this->url->link($this->config->get('xabandoned_path'), $this->module_token , true);
		$this->data['xmail_link'] = $this->url->link($this->config->get('xabandoned_path').'/mailTemplate', $this->module_token , true);
		$this->data['activity_link'] = $this->url->link($this->config->get('xabandoned_path').'/activity', $this->module_token , true);
		$this->version_two_point_one = $this->data['version_two_point_one'] = false;
		if(version_compare(VERSION, '2.2.0.0')<0){
			$this->version_two_point_one = $this->data['version_two_point_one'] = true;
		}
	}

	public function index() {
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('setting/setting');
		$this->load->model('setting/store');
		if (isset($this->request->get['store_id'])) {
			$this->data['store_id'] = $store_id = $this->request->get['store_id'];
		} else {
			$this->data['store_id'] = $store_id = 0;
		}
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting($this->setting_name, $this->request->post, $store_id);
			$this->session->data['success'] = $this->language->get('text_success');
			$this->response->redirect($this->url->link($this->config->get('xabandoned_path'), $this->module_token . '&store_id=' . $store_id, true));
		}
		
		$this->data['stores'] = $stores = $this->model_setting_store->getStores();
		$config_data = $this->model_setting_setting->getSetting($this->setting_name, $store_id);
		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->language->get('text_success');
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}		
		
		$this->load->model('localisation/language');		
		$this->data['languages'] = $this->model_localisation_language->getLanguages();		
		$this->data['action'] = $this->url->link($this->config->get('xabandoned_path'), $this->module_token . '&store_id=' . $store_id, true);
		// @formatter:off
		$this->breadcrumbs();
		$fields = array('status','minute','persistent_cart','persistent_login','logs','session_option','cookie_days','coupon_one','permanent_unsubscription','different_mail','dashboard','menubar','cookie_name','disabled_ips','disabled_user_agents');
		// @formatter:on		
		foreach ($fields as $field) {
			if (isset($this->request->post[$this->xabandoned_config_pfx . $field])) {
				$this->data[$field] = $this->request->post[$this->xabandoned_config_pfx . $field];
			} else {
				$this->data[$field] = isset($config_data[$this->xabandoned_config_pfx . $field]) ? $config_data[$this->xabandoned_config_pfx . $field] : '';
			}
		}
		
		if (isset($this->request->post[$this->xabandoned_config_pfx . 'mail'])) {
			$this->data['mail'] = $this->request->post[$this->xabandoned_config_pfx . 'mail'];
		} else {
			$this->data['mail'] = isset($config_data[$this->xabandoned_config_pfx . 'mail']) ? $config_data[$this->xabandoned_config_pfx . 'mail'] : array();
		}
		
		$this->data['xabandoned_version'] = $this->config->get('xabandoned_module_version');
		$this->data['store_path'] = $this->config->get('xabandoned_path');
		$this->data['coupons_sent'] = $this->module_model_object->getTotalCouponsSent();
		$this->data['coupons_used'] = $this->module_model_object->getTotalCouponsUsed();
		$this->data['coupons_sales']	=  $this->module_model_object->getTotalCouponsSales();
		$this->data['coupons_expired'] = $this->module_model_object->getTotalCouponsExpired();
		$this->data['total_activities'] = $this->module_model_object->getAllActivities();
		$this->data['unsubscribed_activity'] = $this->module_model_object->getUnsubscribedActivities();
		$this->data['unsubscribed_permanently'] = $this->module_model_object->getTotalUnsubscribedPermanently();
		$this->data['mails_sent'] = $this->module_model_object->getMailsSent();
		$this->data['mails_opened'] = $this->module_model_object->getMailsOpened();
		$this->data['sms_sent'] = $this->module_model_object->getSMSSent();
		$this->data['sms_clicked'] = $this->module_model_object->getSMSClicked();
		$this->data['curl_command'] = HTTP_CATALOG.'index.php?route='.$this->data['module_path'].'/deleteCron';
		$this->data['delete_cron']	= $this->module_model_object->getDeleteCronJob();
		
		$this->document->addScript('view/javascript/xabandonedcarts/jquery-cron/cron/jquery-cron.js');
		$this->document->addScript('view/javascript/xabandonedcarts/jquery-cron/gentleSelect/jquery-gentleSelect.js');
		$this->document->addStyle('view/javascript/xabandonedcarts/jquery-cron/cron/jquery-cron.css');
		$this->document->addStyle('view/javascript/xabandonedcarts/jquery-cron/gentleSelect/jquery-gentleSelect.css');
		
		$this->data['config_license'] = $this->model_setting_setting->getSetting($this->setting_name.'_activity');
		$this->data['xabandoned_version'] = $this->config->get('xabandoned_module_version');
		$this->data['xabandoned_module'] = $this->config->get('xabandoned_module');
		$this->data['xabandoned_support'] = $this->config->get('xabandoned_support');
		$this->data['xabandoned_docs'] = $this->config->get('xabandoned_docs');
		
		$this->log();
		$this->addHeaderFooterLeft();
		$this->response->setOutput($this->view('list', $this->data));
	}
	
	private function log(){
		$this->data['download'] = $this->url->link($this->config->get('xabandoned_path').'/download', $this->module_token, true);
		$this->data['clear'] = $this->url->link($this->config->get('xabandoned_path').'/clear', $this->module_token, true);

		$this->data['log'] = '';

		$file = DIR_LOGS . $this->config->get('xabandoned_log_file');

		if (file_exists($file)) {
			$size = filesize($file);

			if ($size >= 5242880) {
				$suffix = array(
					'B',
					'KB',
					'MB',
					'GB',
					'TB',
					'PB',
					'EB',
					'ZB',
					'YB'
				);

				$i = 0;

				while (($size / 1024) > 1) {
					$size = $size / 1024;
					$i++;
				}

				$this->data['log_warning'] = sprintf($this->language->get('error_log_warning'), basename($file), round(substr($size, 0, strpos($size, '.') + 4), 2) . $suffix[$i]);
			} else {
				$this->data['log'] = file_get_contents($file, FILE_USE_INCLUDE_PATH, null);
			}
		}
	}
	
	public function download() {
		$file = DIR_LOGS . $this->config->get('xabandoned_log_file');
		if (file_exists($file) && filesize($file) > 0) {
			$this->response->addheader('Pragma: public');
			$this->response->addheader('Expires: 0');
			$this->response->addheader('Content-Description: File Transfer');
			$this->response->addheader('Content-Type: application/octet-stream');
			$this->response->addheader('Content-Disposition: attachment; filename="' . $this->config->get('config_name') . '_' . date('Y-m-d_H-i-s', time()) . '_xabandoned_cart.log"');
			$this->response->addheader('Content-Transfer-Encoding: binary');
			$this->response->setOutput(file_get_contents($file, FILE_USE_INCLUDE_PATH, null));
		} else {
			$this->session->data['error'] = sprintf($this->language->get('error_warning'), basename($file), '0B');
			$this->response->redirect($this->url->link($this->config->get('xabandoned_path'), $this->module_token, true));
		}
	}
	
	public function clear() {
		if (!$this->user->hasPermission('modify', $this->config->get('xabandoned_path'))) {
			$json['error'] = $this->language->get('error_permission');
		} else {
			$file = DIR_LOGS . $this->config->get('xabandoned_log_file');
			$handle = fopen($file, 'w+');
			fclose($handle);
			$json['success'] = $this->language->get('text_clear_success');
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	// Activity
	public function activity() {
		$this->document->setTitle($this->language->get('activity_heading_title'));
		$this->document->addScript('view/javascript/xabandonedcarts/Chart.bundle.min.js');
		$filter_vars = array('customer','email','ip','date_start','date_end','last_step','store_id','abandoned_cart');
		$this->load->model('setting/store');
		$this->data['stores'][0] = 'Default';
		foreach ($this->model_setting_store->getStores() as $store){
			$this->data['stores'][$store['store_id']] = $store['name'];
		}
		foreach ($filter_vars as $filter){
			if (isset($this->request->get['filter_'.$filter])) {
				$filters['filter_'.$filter] = $this->request->get['filter_'.$filter];
			} else {
				$filters['filter_'.$filter] = null;
			}
		}
		if($filters['filter_abandoned_cart'] == null){
			$filters['filter_abandoned_cart'] = 'abandoned';
		}
		if($filters['filter_last_step'] == null){
			$filters['filter_last_step'] = '99';
		}
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		foreach ($filter_vars as $filter){
			if (isset($this->request->get['filter_'.$filter])) {
				$url .= '&filter_'.$filter.'=' . urlencode($this->request->get['filter_'.$filter]);
			}
		}
		if(!isset($this->request->get['filter_abandoned_cart'])){
			$url .= '&filter_abandoned_cart=abandoned';
		}
		
		if(!isset($this->request->get['filter_last_step'])){
			$url .= '&filter_last_step=99';
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		$this->data['activities'] = array();
		
		$filter_data = array_merge($filters,array('start' => ($page - 1) * $this->config->get('config_limit_admin'),'limit' => $this->config->get('config_limit_admin')));
		
		if (isset($this->request->get['store_id'])) {
			$store_id = $this->request->get['store_id'];
		} else {
			$store_id = 0;
		}
		
		$results = $this->module_model_object->getActivities($filter_data);
		$forchart = array('step1'=>0,'step2'=>0,'step3'=>0,'step4'=>0);
		$forchart = array_merge($forchart,$this->module_model_object->getActivitiesByStep($filter_data));
		$this->data['forchart'] = $forcharts =  implode(',', $forchart);
		$activity_total = $this->module_model_object->getTotalActivities($filter_data);
		$this->data['steps'] = $steps = array(
				'all'=> $this->language->get('text_any'),
				'0' => 'Not reached Checkout (0)',
				'1' => 'Step 1',
				'2' => 'Step 2',
				'3' => 'Step 3',
				'4' => 'Order Success (4)',
				'99' => 'Any But Not Placed an Order'
		);	
		foreach ($results as $result) {
			// @formatter:off
			if($result['full_telephone']){
				$result['telephone'] = $result['full_telephone'];
			}
			$comment = sprintf('<a href="customer_id=">' . $result['name'] . '</a>');			
			$find = array('customer_id=');			
			$replace = array($this->url->link('customer/customer/edit', $this->module_token . '&customer_id=' . $result['customer_id'], true));
			// @formatter:on
			if($result['date_modified']=='0000-00-00 00:00:00'){
				$result['duration'] = 'Not Recorded';
			}else{
				$seconds = strtotime($result['date_modified']) - strtotime($result['date_added']);
	
				$days    = floor($seconds / 86400);
				$hours   = floor(($seconds - ($days * 86400)) / 3600);
				$minutes = floor(($seconds - ($days * 86400) - ($hours * 3600))/60);
				$seconds = floor(($seconds - ($days * 86400) - ($hours * 3600) - ($minutes*60)));
				$duration = '';
				$duration .= $days?$days.' Days ':'';
				$duration .= $days || $hours?$hours.' Hrs ':'';
				$duration .= $days || $hours || $minutes?$minutes.' Mins ':'';
				$duration .= $days || $hours || $minutes || $seconds?$seconds.' Secs ':'';
				$result['duration'] = $duration;
			}
			$result['date_added'] = date($this->language->get('datetime_format'), strtotime($result['date_added']));
			$result['date_modified'] = ($result['date_modified']=='0000-00-00 00:00:00')?'Not recorded':date($this->language->get('datetime_format'), strtotime($result['date_modified']));
			
			
			$cart_count =  json_decode($result['cart'],true);
			if(empty($cart_count)){
				$result['cart'] = '0 product(s)';
				$result['count_less_one'] = 0;
			}else{
				$count = 0;
				$product_count = 0;
				$cart_products = array(); 
				if(isset($cart_count['products'])){
					foreach (json_decode($cart_count['products'],true) as $product){
						$count += $product['quantity'];
						$product_count++;
					}
				}
				if(isset($cart_count['vouchers'])){
					foreach (json_decode($cart_count['vouchers'],true) as $voucher){
						$count += 1;
						$product_count++;
					}
				}
				if(!$count){
					$result['cart'] = $count. ' product(s)';
					$result['count_less_one'] = $product_count;
				}else{
					$result['count_less_one'] = $product_count-1;
					$result['cart'] = $this->getCart(json_decode($cart_count['products'],true), json_decode($cart_count['vouchers'],true),true);
				}
				
			}
			
			$result['info'] = $this->url->link($this->config->get('xabandoned_path').'/activityinfo', $this->module_token . '&activity_code=' . $result['activity_session_code'] . $url, true);
			$result['quickview'] = $this->url->link($this->config->get('xabandoned_path').'/activityinfo', $this->module_token . '&activity_code=' . $result['activity_session_code'] . '&quickview=1' . $url, true);
			
			$result['last_step_text'] = $result['last_step'];
			$this->data['activities'][] = $result;
		}
		
		$this->data['activity_heading_title'] = $this->language->get('activity_heading_title');
		
		$this->data['button_filter'] = $this->language->get('button_filter');
		
		$url = '';
		
		foreach ($filter_vars as $filter){
			if (isset($this->request->get['filter_'.$filter])) {
				$url .= '&filter_'.$filter.'=' . urlencode($this->request->get['filter_'.$filter]);
			}
		}
		if(!isset($this->request->get['filter_abandoned_cart'])){
			$url .= '&filter_abandoned_cart=abandoned';
		}
		if(!isset($this->request->get['filter_last_step'])){
			$url .= '&filter_last_step=99';
		}
		$this->data['text_filter_abandoned'] = array('all'=>$this->language->get('text_all_activities'),'abandoned'=>$this->language->get('text_only_abandoned'));
		$pagination = new Pagination();
		$pagination->total = $activity_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = HTTPS_SERVER . "index.php?route=".$this->config->get('xabandoned_path')."/activity&" . $this->module_token . $url . "&page={page}";
		
		$this->data['pagination'] = $pagination->render();
		
		$this->data['results'] = sprintf($this->language->get('text_pagination'), ($activity_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($activity_total - $this->config->get('config_limit_admin'))) ? $activity_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $activity_total, ceil($activity_total / $this->config->get('config_limit_admin')));
		
		$this->data += $filters;
		$this->data['delete'] = $this->url->link($this->config->get('xabandoned_path').'/deleteActivity', $this->module_token, true);
		if(isset($this->session->data['xactivity_delete_success'])){
			$this->data['xactivity_delete_success'] = $this->session->data['xactivity_delete_success'];
			unset($this->session->data['xactivity_delete_success']);
		}else{
			$this->data['xactivity_delete_success'] = '';
		}
		
		$this->breadcrumbs(array(array('text' => $this->language->get('activity_heading_title'),'href' => $this->url->link($this->config->get('xabandoned_path') . '/activity', $this->module_token, true))));
		$this->addHeaderFooterLeft();
		$this->response->setOutput($this->view('activity', $this->data));
	}
	
	public function deleteActivity() {
		$json = array();
		if(!isset($this->request->post['selected'])){
			$json['error'] = $this->language->get('error_no_activity');
		}

		if (!$json && $this->validate()) {
			foreach ($this->request->post['selected'] as $activity_session_code) {
				$this->module_model_object->deleteActivity($activity_session_code);
			}
			$json['success'] = true;
			$this->session->data['xactivity_delete_success'] = $this->language->get('text_delete_success');
		}else if(!$json){
			$json['error'] = $this->language->get('error_permission');
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function activityinfo() {
		$this->data['activity_code'] = $this->request->get['activity_code'];
		$this->document->setTitle($this->language->get('activity_heading_title'));
		if (isset($this->request->get['filter_customer'])) {
			$filter_customer = $this->request->get['filter_customer'];
		} else {
			$filter_customer = null;
		}
		
		if (isset($this->request->get['filter_ip'])) {
			$filter_ip = $this->request->get['filter_ip'];
		} else {
			$filter_ip = null;
		}
		
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = '';
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['filter_customer'])) {
			$url .= '&filter_customer=' . urlencode($this->request->get['filter_customer']);
		}
		
		if (isset($this->request->get['filter_ip'])) {
			$url .= '&filter_ip=' . $this->request->get['filter_ip'];
		}
		
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		if (isset($this->request->get['activity_code'])) {
			$activity_code = $this->request->get['activity_code'];
		} else {
			$activity_code = '';
		}
		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->language->get('text_success');
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		$activity_order = $this->module_model_object->getActivity($activity_code);
		$activity_info = $this->module_model_object->getDetailedActivity($activity_code);
		$this->name = $this->getCustomer($activity_order);
		if ($activity_order) {
			$steps = array(
				'0' => 'Not reached Checkout',
				'1' => 'Account Step 1',
				'2' => 'Address Step 2',
				'3' => 'Payment Step 3',
				'4' => 'Order Placed successfully' 
			);	
			$this->data['last_step'] = $steps[$activity_order['last_step']];
			$this->data['shipping_method'] = $activity_order['shipping_method'];
			$this->data['payment_method'] = $activity_order['payment_method'];
			$this->data['date_added'] = date($this->language->get('datetime_format'), strtotime($activity_order['date_added']));
			$this->data['name'] = $this->name;
			$this->data['email'] = $activity_order['email'];
			$this->data['telephone'] = ((isset($activity_order['full_telephone']) && $activity_order['full_telephone'])?$activity_order['full_telephone']:$activity_order['telephone']);
			$this->data['language'] = $activity_order['language_code'];
			$this->data['currency'] = $activity_order['currency_code'];
			$this->data['order_total'] = $activity_order['order_total'];
			$this->data['ip'] = $activity_order['ip'];
			$this->data['user_agent'] = $activity_order['user_agent'];
			$this->data['step'] = $activity_order['last_step'];			
			$this->data['payment_address'] = $activity_order['payment_address'];
			$this->data['shipping_address'] = $activity_order['shipping_address'];
			$cart_data = json_decode($activity_order['cart'], true);
			$products = (isset($cart_data['products']) ? json_decode($cart_data['products'], true) : array());
			$vouchers = (isset($cart_data['vouchers']) ? json_decode($cart_data['vouchers'], true) : array());
			$totals = (isset($activity_order['totals']) ? json_decode($activity_order['totals'], true) : array());
			$this->data['cart'] = $this->getCart($products, $vouchers);
			$this->data['mail_templates'] = array();
			$result_mail_templates = $this->module_model_object->getMailStatusTemplates();
			foreach ($result_mail_templates as $result) {
				$this->data['mail_templates'][] = array(
					'template_id' => $result['template_id'],
					'title' => $result['title'] 
				);
			}
			if(($products || $vouchers) && $activity_order['email'] && $this->data['step']!=4 && !$activity_order['unsubscribe'] && !$this->module_model_object->getTotalUnsubscribedPermanently($activity_order['email'])){
				$this->data['mail'] = true;				
			}else{
				$this->data['mail'] = false;
			}
			$this->data['totals'] = array();
			
			foreach ($totals as $total) {
				$this->data['totals'][] = array(
					'title' => $total['title'],
					'text' => $total['text'] 
				);
			}
			
			if ($activity_order['customer_id']) {
				$this->data['customer'] = $this->url->link('customer/customer/edit', $this->module_token . '&customer_id=' . $activity_order['customer_id'], true);
			} else {
				$this->data['customer'] = '';
			}
			
			if ($activity_order['store_id'] == 0) {
				$this->data['store_id'] = 0;
				$this->data['store_name'] = $this->config->get('config_name');
				$this->data['store_url'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;
			} else {
				$this->load->model('setting/store');
				$store = $this->model_setting_store->getStore($activity_order['store_id']);
				if ($store) {
					$this->data['store_id'] = $store['store_id'];
					$this->data['store_name'] = $store['name'];
					$this->data['store_url'] = $store['url'];
				} else {
					$this->data['store_id'] = 0;
					$this->data['store_name'] = '';
					$this->data['store_url'] = '';
				}
			}
			$this->data['activities'] = array();
			foreach ($activity_info as $activity) {
				$this->data['activities'][] = $this->event($activity, $activity_order);
			}
			
			$this->data['reminders']  = $this->module_model_object->getRemindersByActivity($activity_code);
			$this->data['remindersSMS']  = $this->module_model_object->getRemindersByActivitySMS($activity_code);
			
			if (!isset($this->request->get['quickview'])) {
				$this->breadcrumbs(array(array('text' => $this->language->get('activity_heading_title'),'href' => $this->url->link($this->config->get('xabandoned_path') . '/activity', $this->module_token, true)),array('text' => $activity_code,'href' => $this->url->link($this->config->get('xabandoned_path') . '/activityinfo&activity_code='.$activity_code, $this->module_token, true))));
				$this->addHeaderFooterLeft();
				$this->data['quickview'] = false;
			} else {
				$this->data['quickview'] = true;
			}
			$this->response->setOutput($this->view('activity_info', $this->data));
		} else {
			return new Action('error/not_found');
		}
	}

	private function event($event,$activity_order) {
		$message = '';
		if (isset($event['data'])) {
			$event_data = json_decode($event['data'], true);
		} else {
			$event_data = array();
		}
		switch ($event['key']) {
			case 'add_address_successful':
			case 'address_deleted':
			case 'edit_address_successful':
			case 'edit_address_unsuccessful':
			case 'add_guest_payment_address_unsuccessful':
			case 'add_guest_shipping_address_unsuccessful':
			case 'saddress_changed':
			case 'address_changed':
			case 'add_address_unsuccessful':
			case 'login_attempt_unsuccessful':
			case 'registration_unsuccessful':
			case 'guest_step1_unsuccessful':
			case 'social_login':
			case 'social_login_registration_unsuccesful':
			case 'guest_step1_successful':
			case 'add_guest_payment_address_successful':
			case 'add_guest_shipping_address_successful':
			case 'social_login_registration_successful':
			case 'social_login_logged_in':
			case 'registration_successful':
			case 'registration_successful_pending_approval':
			case 'social_login_registration_successful_pending_approval':
			case 'order_comment_added':
			case 'no_shipping_method':
			case 'no_payment_method':
			case 'error_minimum_warning':
			case 'error_stock_warning':	
				$message = $this->name . sprintf($this->language->get('text_' . $event['key']), $this->processData($event_data));
				$activity['page'] = $event['referer'];
				break;
			case 'referred_from_mail':
				$message = $this->name . sprintf($this->language->get('text_' . $event['key']), $this->url->link($this->config->get('xabandoned_path') . '/activityinfo&activity_code='.$event_data[$event['key']], $this->module_token, true),$event_data[$event['key']]);
				$activity['page'] = $event['page'];
				break;
			case 'persistent_logged_in':
				$message = $this->name . sprintf($this->language->get('text_' . $event['key']), $this->url->link('customer/customer/edit', $this->module_token . '&customer_id='.$event_data[$event['key']], true),$event_data[$event['key']]);
				$activity['page'] = $event['page'];
				break;	
			case 'cart_added':	
			case 'cart_edited':
			case 'cart_product_removed':
			case 'cart_product_moved_to_wishlist':
				$message = $this->name . sprintf($this->language->get('text_' . $event['key']), $event['xcustomer_activity_id']);
				$activity['cart_generic'] = sprintf($this->language->get('text_cart_generic'), $event['xcustomer_activity_id'],$this->processData($event_data));
				$activity['page'] = $event['referer'];
				break;
			case 'coupon_success':
			case 'coupon_invalid':
			case 'voucher_success':
			case 'voucher_invalid':
			case 'reward_success':
			case 'reward_more_than_products':
			case 'reward_more_than_capacity':
			case 'currency_changed':
			case 'language_changed':	
				$message = $this->name . sprintf($this->language->get('text_' . $event['key']), $event_data[$event['key']]);
				$activity['page'] = $event['referer'];
				break;
			case 'order_success':	
				$message = $this->name . sprintf($this->language->get('text_' . $event['key']), $this->url->link('sale/order/info&order_id='.$activity_order['order_id'],$this->data['module_token'],true));
				$activity['page'] = $event['page'];
				break;	
			case 'coupon_blank':
			case 'coupon_removed':
			case 'voucher_blank':
			case 'voucher_removed':
			case 'reward_blank':
			case 'reward_removed':
			case 'entered_step_1':
			case 'entered_step_2':
			case 'entered_guest_step_2':
			case 'entered_step_3':
				$message = $this->name . sprintf($this->language->get('text_' . $event['key']), $event_data[$event['key']]);
				$activity['page'] = $event['referer'];
				break;
			case 'payment_method_changed':
				$message = $this->name . sprintf($this->language->get('text_' . $event['key']), $event_data[$event['key']]['title'], $event_data[$event['key']]['code']);
				$activity['page'] = $event['referer'];
				break;
			case 'shipping_method_changed':
				$message = $this->name . sprintf($this->language->get('text_' . $event['key']), $event_data[$event['key']]['title'], $event_data[$event['key']]['code'], $event_data[$event['key']]['text']);
				$activity['page'] = $event['referer'];
				break;
			case 'login_attempt_successful':
			case 'address_same':
			case 'address_different':
			case 'persistent_cart':	
				$message = $this->name . $this->language->get('text_' . $event['key']);
				$activity['page'] = $event['referer'];
				break;
		}
		switch ($event['key']) {
			case 'persistent_cart':				
				$activity['page'] = $event['page'];
				break;
		}
		$activity['message'] = $message;
		$activity['date_added'] = date($this->language->get('datetime_format'), strtotime($event['date_added']));
		$activity['ip'] = $event['ip'];
		return $activity;
	}

	private function processData($event_data) {
		$post = '';
		$error = '';
		$extra = '';
		$social_login = '';
		$cart = '';
		foreach ($event_data as $datakey => $data) {
			if ($datakey == 'post') {
				$posts[] = "<ul class='list-unstyled text-muted'><li>Post Data</li><li><ul>";
				foreach ($data as $key => $value) {
					if (is_array($value)) {
						ob_start();
						print_r($value);
						$value = ob_get_clean();
					}
					$posts[] = "<li class='text-info'><b>" . $key . "</b> - " . $value . "</li>";
				}
				$posts[] = "</ul></li></ul>";
				$post = implode('', $posts);
			} else if ($datakey == 'error') {
				$errors[] = "<ul class='list-unstyled text-muted'><li>Errors</li><li><ul>";
				foreach ($data as $key => $value) {
					if (is_array($value)) {
						ob_start();
						print_r($value);
						$value = ob_get_clean();
					}
					$errors[] = "<li class='text-warning'><b>" . $key . "</b> - " . $value . "</li>";
				}
				$errors[] = "</ul></li></ul>";
				$error = implode('', $errors);
			} else if (in_array($datakey, array(
				'social_login',
				'social_login_logged_in' 
			))) {
				$social_logins[] = "<ul class='list-unstyled text-muted'><li>Social Login</li><li><ul>";
				foreach ($data as $key => $value) {
					if (is_array($value)) {
						ob_start();
						print_r($value);
						$value = ob_get_clean();
					}
					$social_logins[] = "<li class='text-info'><b>" . $key . "</b> - " . $value . "</li>";
				}
				$social_logins[] = "</ul></li></ul>";
				$social_login = implode('', $social_logins);
			} else if (in_array($datakey, array(
				'cart_product_removed',
				'cart_added',
				'cart_edited',
				'cart_product_moved_to_wishlist' 
			))) {
				$cart = $this->getCart(isset($data['products'])?json_decode($data['products'], true):array(), isset($data['products'])?json_decode($data['vouchers'], true):array(), true);
			} else {
				ob_start();
				print_r($data);
				$extra = ob_get_clean();
				$extra = "<ul class='list-unstyled text-muted'><li class='text-info'><b>" . $datakey . "</b> - " . $extra . "</li></ul>";
			}
		}
		return $extra . $post . $error . $social_login . $cart;
	}

	public function sendMailToCustomer() {
		$json = array();
		if(!$this->validate()){
			$json['error'] = $this->error['warning'];
		}
		if(!$json && !isset($this->request->get['activity_code']) || !isset($this->request->get['template_id'])){
			$json['error'] = 'No Activity or template selected!';
		}
		if(!$json){
			$activity_info = $this->module_model_object->getActivity($this->request->get['activity_code']);
			if(!$activity_info){
				$json['error'] = 'Activity records not found!';
			}
			$template = $this->module_model_object->getMailTemplate($this->request->get['template_id']);
			if(!$json && !$template){
				$json['error'] = 'Mail template not found!';
			}
			if(!$json && !$template['status']){
				$json['error'] = 'Mail template not activated!';
			}
		}
		if(!$json){
			$cart_data = json_decode($activity_info['cart'], true);
			$products = (isset($cart_data['products']) ? json_decode($cart_data['products'], true) : array());
			$vouchers = (isset($cart_data['vouchers']) ? json_decode($cart_data['vouchers'], true) : array());
		}
		if(!$json && (!$products && !$vouchers)){
			$json['error'] = "There are no products or vouchers in user's abandonedcart!";
		}
		if (!$json && ($activity_info['unsubscribe'] || $this->module_model_object->getTotalUnsubscribedPermanently($activity_info['email']))){
			$json['error'] = 'The user has unsubscribed from this activity or all activities!';
		}
		if(!$json){
			if($template['is_sms']){
				$json = $this->sms($json,$template,$activity_info,$products,$vouchers);
			}else{
				$json = $this->email($json,$template,$activity_info,$products,$vouchers);
			}			
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));	
	}
	
	private function sms($json,$template,$activity_info,$products,$vouchers){
		$sanitize = $this->sanitize($activity_info['telephone'],$activity_info['country_code'],$activity_info['full_telephone']);
		if(empty($sanitize)){
			$json['error'] = 'Number format is not correct, do not send an sms';
			return $json;
		}else{
			$activity_info['telephone'] = $sanitize['telephone'];
			$activity_info['country_code'] = $sanitize['country_code'];
			$activity_info['full_telephone'] = $sanitize['full_telephone'];
		}
		$language = new Language($activity_info['language_code']);
		$language->load($activity_info['language_code']);
		$this->data = array_merge($this->data,$language->load($this->config->get('xabandoned_path')));
		$message = html_entity_decode($template['language'][$activity_info['language_code']]['sms_body']);
		$this->data['products'] = array();
		$this->load->model('setting/setting');
		$this->load->model('tool/image');
		$this->load->model('catalog/product');
		$store_name = $activity_info['store_name']?$activity_info['store_name']:$this->config->get('config_name');
		$store_url = $activity_info['store_url']?$activity_info['store_url']:$this->config->get('config_url');		
					
		// Generate Coupon
		$coupon_id = 0;
		$discount_code = '';
		if ($template['discount_type']) {
			$cart_products = array();
			foreach ($products as $product) {
				$cart_products[] = $product['product_id'];
			}					
			$discount_code = $this->module_model_object->generateCouponCode();
			if($this->config->get($this->xabandoned_config_pfx.'coupon_one')){
				$coupon_data = $this->module_model_object->getSentCouponSMS($activity_info['activity_session_code'],$template['template_id']);
				if($coupon_data){
					$discount_code = $coupon_data['code'];
					$coupon_id = $coupon_data['coupon_id'];
				}
			}
			$time_end = time() + $template['validity'] * 24 * 60 * 60;
			$coupon_data = array(
				'name' => 'Xtensions Abandoned Cart - ' . $activity_info['email'] . '',
				'code' => $discount_code,
				'discount' => $template['discount'],
				'type' => $template['discount_type'],
				'total' => $template['amount'],
				'logged' => $template['customer_login'],
				'shipping' => $template['shipping'],
				'coupon_product' => $template['discount_product'] ? $cart_products : array(),
				'date_start' => date('Y-m-d', time()),
				'date_end' => date('Y-m-d', $time_end),
				'uses_total' => '1',
				'uses_customer' => '1',
				'status' => '1',
				'email'=>$activity_info['email']
				//'language_id'=>isset($template['language'][$activity_info['language_code']]['language_id'])?$template['language'][$activity_info['language_code']]['language_id']:1
			);
			if($coupon_id){
				$this->module_model_object->editCoupon($coupon_id,$coupon_data);
			}else{
				$coupon_id = $this->module_model_object->addCoupon($coupon_data);
			}
		}
		
		$this->db->query("INSERT " . DB_PREFIX . "xtensions_activity_to_telephone SET activity_session_code = '" . $this->db->escape($activity_info['activity_session_code']) . "', template_id = '". (int)$this->request->get['template_id'] ."', coupon_id = '". (int)$coupon_id ."', coupon_code = '" . $this->db->escape($discount_code) . "', date_added = NOW()");
		$activity_daily_mail_id = $this->db->getLastId();
		$this->db->query("INSERT " . DB_PREFIX . "xtensions_activity_daily_telephone SET activity_session_code = '" . $this->db->escape($activity_info['activity_session_code']) . "', store_id = '". (int)$activity_info['store_id'] ."', template_id = '". (int)$template['template_id'] ."', telephone = '" . $this->db->escape($activity_info['telephone']) . "', country_code = '" . $this->db->escape($activity_info['country_code']) . "', full_telephone = '" . $this->db->escape($activity_info['full_telephone']) . "', date_added = NOW()");				
		$activity_mail_id = $this->db->getLastId();
		
		// Convert Patterns and Send Mail
		$static = array();
		$converters = array(
			'firstname',
			'lastname',
			'restore_link',
			'discount_code',
			'discount_value',
			'total_amount',
			'date_end',
			'unsubscribe_link',
			'store_name',
			'store_link' 
		);
		foreach ($converters as $converter) {
			$static[$converter] = '{' . $converter . '}';
		}
		$with = array();
		$with['firstname'] = $activity_info['firstname'];
		$with['lastname'] = $activity_info['lastname'];
		$with['restore_link'] = $store_url . 'index.php?route=' . $this->config->get('xabandoned_path') . '/r&a=' . $activity_info['activity_session_code'] . '&t=' . $activity_mail_id;
		$with['discount_code'] = $template['discount_type'] ? $discount_code : '';
		$with['discount_value'] = ($template['discount_type'] =='P'? $template['discount'].'%' : ($template['discount_type']=='F' ? $this->currency->format($template['discount'],$activity_info['currency_code']) : ''));
		$with['total_amount'] = $template['discount_type'] ? $this->currency->format($template['amount'],$activity_info['currency_code']) : '';
		$with['date_end'] = $template['discount_type'] ? date('jS F Y', strtotime("+".$template['validity']." days")) : '';
		$with['unsubscribe_link'] = $store_url . 'index.php?route=' . $this->config->get('xabandoned_path') . '/u&a=' . $activity_info['activity_session_code'];
		$with['store_name'] = $store_name;
		$with['store_link'] = $store_url;		
		$sms_body = str_replace($static, $with, $message);			
		$sms = array(
			'telephone' => $activity_info['telephone'],
			'country_code' => $activity_info['country_code'],
			'full_telephone' => $activity_info['full_telephone'],
			'sms' => $sms_body,
			'sms_template_id' => isset($template['language'][$activity_info['language_code']]['sms_template_id'])?$template['language'][$activity_info['language_code']]['sms_template_id']:'',
			'store_id' => $activity_info['store_id'],
			'store_name'=>$store_name,
			'config_pfx'=>$this->xabandoned_config_pfx,
			'code'		=> $activity_info['activity_session_code'],
			'coupon_id' => $coupon_id,
			'coupon_code' => $discount_code,
			'event'		=> 'xabcart',
			'channel'  => 'transactional',
		);
		$send = $this->module_model_object->sms($sms);
		if(isset($send['success'])){
			$json['success'] = 'SMS has been sent successfully!';			
		}else{
			$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_to_telephone WHERE activity_mail_id = '" . (int)$activity_mail_id . "'");
			$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_daily_telephone WHERE activity_mail_id = '" . (int)$activity_daily_mail_id . "'");
			$json['error'] = 'SMS has errored, with Error: '. $send['error'];
		}
		return $json;
	}
	
	public function sanitize($telephone,$country_code,$full_telephone){
		if($country_code.' '.$telephone != $full_telephone){
			$telephone_number = explode(" ",$telephone,2);
			if(count($telephone_number) >= 2){
				if(isset($telephone_number[0]) && isset($telephone_number[1])){
					if($country_code != $telephone_number[0]){
						return array();
					}
					$telephone = $telephone_number[1];				
				}
			}
		}		
		$telephone = preg_replace('/\D/', '',preg_replace('/^0+/','',$telephone));
		return array('telephone'=>$telephone,'country_code'=>$country_code, 'full_telephone' => $country_code . ' ' . $telephone);
	}
	
	private function email($json,$template,$activity_info,$products,$vouchers){
		$language = new Language($activity_info['language_code']);
		$language->load($activity_info['language_code']);
		$this->data = array_merge($this->data,$language->load($this->config->get('xabandoned_path')));
		$message = html_entity_decode($template['language'][$activity_info['language_code']]['subject_description']);
		$this->data['products'] = array();
		$this->load->model('setting/setting');
		$this->load->model('tool/image');
		$this->load->model('catalog/product');
		$store_name = $activity_info['store_name']?$activity_info['store_name']:$this->config->get('config_name');
		$store_url = $activity_info['store_url']?$activity_info['store_url']:$this->config->get('config_url');
		foreach ($products as $product) {
			$product_info = $this->model_catalog_product->getProduct($product['product_id']);
			$product_info['image'] = $this->model_tool_image->resize($product_info['image'], $template['width'], $template['height']);
			$product_info['quantity'] = $product['quantity'];
			$product_info['price'] = $product['price_formatted'];
			$product_info['total'] = $product['total_formatted'];
			$product_info['url'] = $store_url.'index.php?route=product/product&product_id='.$product['product_id'];
			$this->data['products'][] = $product_info;
		}
		foreach ($vouchers as $voucher) {
			$product_info = array();
			$product_info['name'] = $voucher['description'];
			$product_info['model'] = '';
			$product_info['image'] = $this->model_tool_image->resize('catalog/xtensions/giftcard.jpg', $template['width'], $template['height']);
			$product_info['quantity'] = 1;
			$product_info['price'] = $voucher['amount_formatted'];
			$product_info['total'] = $voucher['amount_formatted'];
			$this->data['products'][] = $product_info;
		}
		$cart_content = $this->load->view($this->config->get('xabandoned_mail_file').$this->config->get('xabandoned_view_extension'),$this->data);
					
		// Generate Coupon
		$coupon_id = 0;
		$discount_code = '';
		if ($template['discount_type']) {
			$cart_products = array();
			foreach ($products as $product) {
				$cart_products[] = $product['product_id'];
			}					
			$discount_code = $this->module_model_object->generateCouponCode();
			if($this->config->get($this->xabandoned_config_pfx.'coupon_one')){
				$coupon_data = $this->module_model_object->getSentCoupon($activity_info['activity_session_code'],$template['template_id']);
				if($coupon_data){
					$discount_code = $coupon_data['code'];
					$coupon_id = $coupon_data['coupon_id'];
				}
			}
			$time_end = time() + $template['validity'] * 24 * 60 * 60;
			$coupon_data = array(
				'name' => 'Xtensions Abandoned Cart - ' . $activity_info['email'] . '',
				'code' => $discount_code,
				'discount' => $template['discount'],
				'type' => $template['discount_type'],
				'total' => $template['amount'],
				'logged' => $template['customer_login'],
				'shipping' => $template['shipping'],
				'coupon_product' => $template['discount_product'] ? $cart_products : array(),
				'date_start' => date('Y-m-d', time()),
				'date_end' => date('Y-m-d', $time_end),
				'uses_total' => '1',
				'uses_customer' => '1',
				'status' => '1',
				'email'=>$activity_info['email']
				//'language_id'=>isset($template['language'][$activity_info['language_code']]['language_id'])?$template['language'][$activity_info['language_code']]['language_id']:1			
			);
			if($coupon_id){
				$this->module_model_object->editCoupon($coupon_id,$coupon_data);
			}else{
				$coupon_id = $this->module_model_object->addCoupon($coupon_data);
			}
		}
		
		// Convert Patterns and Send Mail
		$static = array();
		$converters = array(
			'firstname',
			'lastname',
			'cart_content',
			'restore_link',
			'discount_code',
			'discount_value',
			'total_amount',
			'date_end',
			'unsubscribe_link',
			'store_name',
			'store_link' 
		);
		foreach ($converters as $converter) {
			$static[$converter] = '{' . $converter . '}';
		}
		$with = array();
		$with['firstname'] = $activity_info['firstname'];
		$with['lastname'] = $activity_info['lastname'];
		$with['cart_content'] = $cart_content;
		$with['restore_link'] = $store_url . 'index.php?route=' . $this->config->get('xabandoned_path') . '/restoreUserCart&activity_session_code=' . $activity_info['activity_session_code'];
		$with['discount_code'] = $template['discount_type'] ? $discount_code : '';
		$with['discount_value'] = ($template['discount_type'] =='P'? $template['discount'].'%' : ($template['discount_type']=='F' ? $this->currency->format($template['discount'],$activity_info['currency_code']) : ''));
		$with['total_amount'] = $template['discount_type'] ? $this->currency->format($template['amount'],$activity_info['currency_code']) : '';
		$with['date_end'] = $template['discount_type'] ? date('jS F Y', strtotime("+".$template['validity']." days")) : '';
		$with['unsubscribe_link'] = $store_url . 'index.php?route=' . $this->config->get('xabandoned_path') . '/unsubscribeLink&activity_session_code=' . $activity_info['activity_session_code'];
		$with['store_name'] = $store_name;
		$with['store_link'] = $store_url;
		$HTMLMail = str_replace($static, $with, $message);
		$patterns_subject = array();
		$patterns_subject[0] = '{firstname}';
		$patterns_subject[1] = '{lastname}';
		$replacements_subject = array();
		$replacements_subject[0] = $activity_info['firstname'];
		$replacements_subject[1] = $activity_info['lastname'];
		$HTMLSubject = str_replace($patterns_subject, $replacements_subject, $template['language'][$activity_info['language_code']]['subject_title']);
		$mail = array(
			'email' => $activity_info['email'],
			'message' => $HTMLMail,
			'subject' => $HTMLSubject,
			'store_id' => $activity_info['store_id'],
			'store_name'=>$store_name,
			'config_pfx'=>$this->xabandoned_config_pfx,
			'setting_name'=>$this->setting_name,
			'code'		=> $activity_info['activity_session_code'],
			'coupon_id' => $coupon_id,
			'coupon_code' => $discount_code,
		);
		$this->db->query("INSERT " . DB_PREFIX . "xtensions_activity_to_mail SET activity_session_code = '" . $this->db->escape($mail['code']) . "', template_id = '". (int)$this->request->get['template_id'] ."', coupon_id = '". (int)$mail['coupon_id'] ."', coupon_code = '" . $this->db->escape($mail['coupon_code']) . "', date_added = NOW()");
		$activity_mail_id = $this->db->getLastId();
		$mail['message'] .= '<img style="display:none;" src="'. $store_url . 'index.php?route=' . $this->config->get('xabandoned_path') . '/image&activity_mail_id=' . $activity_mail_id .'" />'; 
		if($this->module_model_object->mail($mail)){
			$json['success'] = 'Mail has been sent successfully!'; 
		}else{
			$json['error'] = 'Mail could not be sent. Check email settings!';	
		}
		return $json;
	}

	public function getCart($products, $vouchers, $all = false) {
		$this->data['all'] = $all;
		$this->data['products'] = array();
		$this->load->model('tool/upload');
		$this->load->model('catalog/product');
		$this->load->model('tool/image');
		foreach ($products as $product) {
			$option_data = array();
			
			$options = $product['option'];
			
			foreach ($options as $option) {
				if (!isset($option['type'])) {
					foreach ($option as $checkoption){
						$option_data[] = array(
							'name' => $checkoption['name'],
							'value' => $checkoption['value'],
							'type' => $checkoption['type'] 
						);
					}
				}
				else if ($option['type'] != 'file') {
					$option_data[] = array(
						'name' => $option['name'],
						'value' => $option['value'],
						'type' => $option['type'] 
					);
				} else {
					$upload_info = $this->model_tool_upload->getUploadByCode($option['value']);
					
					if ($upload_info) {
						$option_data[] = array(
							'name' => $option['name'],
							'value' => $upload_info['name'],
							'type' => $option['type'],
							'href' => $this->url->link('tool/upload/download', $this->module_token . '&code=' . $upload_info['code'], true) 
						);
					}
				}
			}
			$product_info = $this->model_catalog_product->getProduct($product['product_id']);
			if (is_file(DIR_IMAGE . $product_info['image'])) {
				$image = $this->model_tool_image->resize($product_info['image'], 50, 50);
			} else {
				$image = $this->model_tool_image->resize('no_image.png', 50, 50);
			}
			if($product_info){
				$this->data['products'][] = array(
					'product_id' => $product['product_id'],
					'image' => $image,
					'name' => $product['name'],
					'model' => $product['model'],
					'option' => $option_data,
					'quantity' => $product['quantity'],
					'price' => $product['price_formatted'],
					'total' => $product['total_formatted'],
					'href' => $this->url->link('catalog/product/edit', $this->module_token . '&product_id=' . $product['product_id'], true) 
				);
			}
		}
		
		$this->data['vouchers'] = array();
		if (is_file(DIR_IMAGE . 'catalog/xtensions/giftcard.jpg')) {
			$image = $this->model_tool_image->resize('catalog/xtensions/giftcard.jpg', 50, 50);
		} else {
			$image = $this->model_tool_image->resize('no_image.png', 50, 50);
		}
		foreach ($vouchers as $voucher) {
			$this->data['vouchers'][] = array(
				'image' => $image,
				'description' => $voucher['description'],
				'amount' => $voucher['amount_formatted'] 
			);
		}
		return $this->view('activity_cart', $this->data);
	}

	private function getCustomer($activity_order) {
		// @formatter:off
		if ($activity_order['customer_id']) {
			$customer = vsprintf($this->language->get('text_customer'), array('customer_id' => $activity_order['customer_id'],'name' => $activity_order['name']));
		} else {
			$customer = vsprintf($this->language->get('text_guest'), array('name' => (trim($activity_order['name']) ? $activity_order['name'] : 'Guest')));
		}
		
		$find = array('customer_id=','order_id=');
		$replace = array($this->url->link('customer/customer/edit', $this->module_token . '&customer_id=', true),$this->url->link('sale/order/info', $this->module_token . '&order_id=', true));
		// @formatter:on
		return str_replace($find, $replace, $customer);
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', $this->config->get('xabandoned_path'))) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		return !$this->error;
	}

	protected function validateCookieName() {
		if ((utf8_strlen($this->request->post[$this->xabandoned_config_pfx.'cookie_name']) < 10) || (utf8_strlen($this->request->post[$this->xabandoned_config_pfx.'cookie_name']) > 64)) {
			$this->error['cookie_name'] = $this->language->get('error_cookie_name');
		}
		
		return !$this->error;
	}

	// Mail Template
	public function mailTemplate() {
		$this->document->setTitle($this->language->get('mail_heading_title'));
		$this->getListMailTemplate();
	}

	public function addMailTemplate() {
		$this->document->setTitle($this->language->get('mail_heading_title'));
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateFormMailTemplate()) {
			$template_id = $this->module_model_object->addMailTemplate($this->request->post);
			$this->session->data['success'] = $this->language->get('text_success_cron');
			
			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}
			
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->response->redirect($this->url->link($this->config->get('xabandoned_path') . '/editMailTemplate&template_id='.$template_id, $this->module_token . $url, true));
		}
		
		$this->getFormMailTemplate();
	}

	public function editMailTemplate() {
		$this->document->setTitle($this->language->get('mail_heading_title'));
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateFormMailTemplate()) {
			$this->cronJob();
			$this->module_model_object->editMailTemplate($this->request->get['template_id'], $this->request->post);
			$this->session->data['success'] = $this->language->get('text_mail_form_success');
			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}
			
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->response->redirect($this->url->link($this->config->get('xabandoned_path') . '/mailTemplate', $this->module_token . $url, true));
		}
		
		$this->getFormMailTemplate();
	}
	
	private function cronJob(){
		$stores[0] = array('store_id'=> 0, 'name'=>'Default','curl_command'=>'/usr/bin/curl '.HTTP_CATALOG.'index.php?route='.$this->config->get('xabandoned_path').'/cron\\&template_id='.$this->request->get['template_id']);
		$this->load->model('setting/store');
		foreach ($this->model_setting_store->getStores() as $store){
			$store['curl_command'] = '/usr/bin/curl '.$store['url'].'index.php?route='.$this->config->get('xabandoned_path').'/cron\\&template_id='.$this->request->get['template_id'];
			$stores[$store['store_id']] = $store;
		}
		
		if (function_exists('shell_exec')) {
			$templateJobs = $this->module_model_object->getCronJobs($this->request->get['template_id']);
			$systemJobs = shell_exec('crontab -l');
			$systemJobsArray = explode(PHP_EOL, $systemJobs);
			foreach ($systemJobsArray as $key=>$value){
				if(empty($value)){
					unset($systemJobsArray[$key]);
				}
			}
			if($systemJobsArray){				
				foreach ($templateJobs as $key=>$job){
					foreach ($stores as $store){
						if(isset($job[$store['store_id']])){
							$command = $job[$store['store_id']].' ' .$store['curl_command'];
							foreach ($systemJobsArray as $key=>$value){
								if($command == $value){
									unset($systemJobsArray[$key]);
								}
							}
						}
					}
				}
			}
		
			if(isset($this->request->post['cron_jobs_enable'])){
				foreach ($this->request->post['cron_jobs_enable'] as $store_id => $valuekey){
					foreach ($valuekey as $key){
						if(isset($this->request->post['cron_jobs'][$store_id][$key])){
							$systemJobsArray[] = $this->request->post['cron_jobs'][$store_id][$key].' '.$stores[$store_id]['curl_command'];
						}
					}
				}
			}
			$systemJobsArray[] = '';
			$cron_jobs = implode(PHP_EOL, $systemJobsArray);
			file_put_contents('/tmp/crontab.txt', $cron_jobs.PHP_EOL);
			exec('crontab -r');
			exec('crontab /tmp/crontab.txt');
        }
	}

	public function deleteMailTemplate() {
		$this->document->setTitle($this->language->get('mail_heading_title'));
		if (isset($this->request->post['selected']) && $this->validate()) {
			foreach ($this->request->post['selected'] as $template_id) {
				$this->module_model_object->deleteMailTemplate($template_id);
			}
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$url = '';
			
			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}
			
			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$this->response->redirect($this->url->link($this->config->get('xabandoned_path') . '/mailTemplate', $this->module_token . $url, true));
		}
		
		$this->getListMailTemplate();
	}

	protected function getListMailTemplate() {
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'dd.name';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		// @formatter:off
		$this->breadcrumbs(array(array('text' => $this->language->get('mail_heading_title'),'href' => $this->url->link($this->config->get('xabandoned_path') . '/mailTemplate', $this->module_token, true))));
		// @formatter:on
		
		$this->data['add'] = $this->url->link($this->config->get('xabandoned_path') . '/addMailTemplate', $this->module_token . $url, true);
		$this->data['delete'] = $this->url->link($this->config->get('xabandoned_path') . '/deleteMailTemplate', $this->module_token . $url, true);
		
		$this->data['templates'] = array();
		
		$template_total = $this->module_model_object->getTotalXmailTemplates();
		
		$results = $this->module_model_object->getMailTemplates();
		
		foreach ($results as $result) {
			$this->data['templates'][] = array(
				'template_id' => $result['template_id'],
				'title' => $result['title'],
				'status' => $result['status'],				
				'is_sms' => $result['is_sms'],
				'edit' => $this->url->link($this->config->get('xabandoned_path') . '/editMailTemplate', $this->module_token . '&template_id=' . $result['template_id'] . $url, true) 
			);
		}
		
		$this->data['mail_heading_title'] = $this->language->get('mail_heading_title');
		
		$this->data['button_add'] = $this->language->get('button_add');
		$this->data['button_edit'] = $this->language->get('button_edit');
		$this->data['button_delete'] = $this->language->get('button_delete');
		
		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		
		if (isset($this->request->post['selected'])) {
			$this->data['selected'] = (array)$this->request->post['selected'];
		} else {
			$this->data['selected'] = array();
		}
		
		$url = '';
		
		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		$this->data['sort_name'] = $this->url->link($this->config->get('xabandoned_path'), $this->module_token . '&sort=dd.name' . $url, true);
		$this->data['sort_date_added'] = $this->url->link($this->config->get('xabandoned_path'), $this->module_token . '&sort=d.date_added' . $url, true);
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		$pagination = new Pagination();
		$pagination->total = $template_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link($this->config->get('xabandoned_path') . '/mailTemplate', $this->module_token . $url . '&page={page}', true);
		
		$this->data['pagination'] = $pagination->render();
		
		$this->data['results'] = sprintf($this->language->get('text_pagination'), ($template_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($template_total - $this->config->get('config_limit_admin'))) ? $template_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $template_total, ceil($template_total / $this->config->get('config_limit_admin')));
		
		$this->data['sort'] = $sort;
		$this->data['order'] = $order;
		
		$this->addHeaderFooterLeft();
		$this->data['xabandoned_carts_link'] = $this->url->link($this->config->get('xabandoned_path'), $this->module_token, true);
		$this->response->setOutput($this->view('mail_list', $this->data));
	}

	protected function getFormMailTemplate() {
		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];			
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}
		$this->document->addScript('view/javascript/xabandonedcarts/jquery-cron/cron/jquery-cron-min.js');
		$this->document->addScript('view/javascript/xabandonedcarts/jquery-cron/gentleSelect/jquery-gentleSelect.js');
		$this->document->addStyle('view/javascript/xabandonedcarts/jquery-cron/cron/jquery-cron.css');
		$this->document->addStyle('view/javascript/xabandonedcarts/jquery-cron/gentleSelect/jquery-gentleSelect.css');
		$this->data['mail_heading_title'] = $this->language->get('mail_heading_title');
		
		$this->data['text_form'] = !isset($this->request->get['template_id']) ? $this->language->get('text_mail_add') : $this->language->get('text_mail_edit');
		$this->data['text_loading'] = $this->language->get('text_loading');
		
		$this->data['entry_name'] = $this->language->get('entry_name');
		$this->data['entry_filename'] = $this->language->get('entry_filename');
		$this->data['entry_mask'] = $this->language->get('entry_mask');
		
		$this->data['help_filename'] = $this->language->get('help_filename');
		$this->data['help_mask'] = $this->language->get('help_mask');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		$this->data['button_upload'] = $this->language->get('button_upload');
		$this->data['config_currency'] = $this->config->get('config_currency');
		
		foreach (array('warning','subject','sms_body','title','first_mail','next_mails','maximum_mails','maximum_time','max_mail_per_day_per_email') as $key){
			if (isset($this->error[$key])) {
				$this->data['error_'.$key] = $this->error[$key];
			} else {
				$this->data['error_'.$key]  = '';
			}
		}
		
		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		if (!isset($this->request->get['template_id'])) {
			$this->data['action'] = $this->url->link($this->config->get('xabandoned_path') . '/addMailTemplate', $this->module_token . $url, true);
		} else {
			$this->data['action'] = $this->url->link($this->config->get('xabandoned_path') . '/editMailTemplate', $this->module_token . '&template_id=' . $this->request->get['template_id'] . $url, true);
		}
		// @formatter:off
		
		$this->breadcrumbs(array(array('text' => $this->language->get('mail_heading_title'),'href' => $this->url->link($this->config->get('xabandoned_path') . '/mailTemplate', $this->module_token, true)),array('text' => $this->data['text_form'],'href' => $this->data['action'])));
		// @formatter:on
		$this->data['cancel'] = $this->url->link($this->config->get('xabandoned_path') . '/mailTemplate', $this->module_token . $url, true);
		
		$this->load->model('localisation/language');
		
		$this->data['languages'] = $this->model_localisation_language->getLanguages();
		
		if (isset($this->request->get['template_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$template_info = $this->module_model_object->getMailTemplate($this->request->get['template_id']);
		}
		
		if (isset($this->request->get['template_id'])) {
			$this->data['template_id'] = $this->request->get['template_id'];
		} else {
			$this->data['template_id'] = 0;
		}
		
		if (isset($this->request->post['template_description'])) {
			$this->data['template_description'] = $this->request->post['template_description'];
		} elseif (isset($this->request->get['template_id'])) {
			$this->data['template_description'] = $this->module_model_object->getMailTemplateDescriptions($this->request->get['template_id']);
		} else {
			$this->data['template_description'] = array();
		}
		
		if (isset($this->request->post['cron_jobs'])) {
			foreach ($this->request->post['cron_jobs'] as $key=>$sort_orders){
				foreach ($sort_orders as $sort_order=>$command){
					$this->data['cron_jobs'][$sort_order][$key] = $command;
					$this->data['cron_jobs'][$sort_order]['value'] = $command;
				}
			}
		} elseif (isset($this->request->get['template_id'])) {
			$this->data['cron_jobs'] = $this->module_model_object->getCronJobs($this->request->get['template_id']);
		} else {
			$this->data['cron_jobs'] = array();
		}
		if(isset($this->request->get['template_id'])){
			$this->data['curl_command'] = '/usr/bin/curl '.HTTPS_CATALOG.'index.php?route='.$this->config->get('xabandoned_path').'/cron\\\&template_id='.$this->request->get['template_id'];
			$this->data['template_id'] = $this->request->get['template_id'];
			$this->load->model('setting/store');
			$stores = array();
			foreach ($this->model_setting_store->getStores() as $store){
				$store['curl_command'] = '/usr/bin/curl '.$store['url'].'index.php?route='.$this->config->get('xabandoned_path').'/cron\\\&template_id='.$this->request->get['template_id'];
				$stores[] = $store;
			}
			$this->data['stores'] = array_merge(array(array('store_id'=> 0, 'name'=>'Default','curl_command'=>'/usr/bin/curl '.HTTP_CATALOG.'index.php?route='.$this->config->get('xabandoned_path').'/cron\\\&template_id='.$this->request->get['template_id'])),$stores);
		}else{
			$this->data['template_id'] = 0;
		}
		$fields =  array('status','title','first_mail','first_mail_duration','next_mails','next_mail_duration','maximum_time','maximum_time_duration','maximum_mails','max_mail_per_day_per_email','discount_type','discount','amount','validity','width','height','customer_login','shipping','discount_product','is_sms');
		foreach($fields as $field){
			if (isset($this->request->post[$field])) {
				$this->data[$field] = $this->request->post[$field];
			} elseif (!empty($template_info)) {
				$this->data[$field] = $template_info[$field];
			} else {
				$this->data[$field] = '';
			}
		}
		$this->data['logo'] = HTTP_CATALOG.'image/'.$this->config->get('config_logo');
		$this->data['default_template'] = $this->view('example_mail', $this->data);
		$this->addHeaderFooterLeft();
		$this->response->setOutput($this->view('mail_form', $this->data));
	}
	
	public function deleteStatsByCron(){
		$json = array();
		if(!$this->validate()){
			$json['error'] = $this->error['warning'];
		}
		if(!$json){
			$curl_command = '/usr/bin/curl '.HTTP_CATALOG.'index.php?route='.$this->config->get('xabandoned_path').'/deleteCron';
			if (function_exists('shell_exec')) {
				$systemJobs = shell_exec('crontab -l');
				$systemJobsArray = explode(PHP_EOL, $systemJobs);
				
				foreach ($systemJobsArray as $key=>$value){
					if(empty($value)){
						unset($systemJobsArray[$key]);
					}
				}
				
				if($systemJobsArray){
					$deleteCron = $this->module_model_object->getDeleteCronJob();
					$commands = array();
					if(isset($deleteCron['job'])){
						$commands[] = $deleteCron['job'] . " " . $curl_command;
					}
					if(isset($deleteCron['full_command'])){
						$commands[] = $deleteCron['full_command'];
					}
					if(!empty($commands)){
						foreach ($systemJobsArray as $key=>$value){
							if(in_array($value, $commands)){
								unset($systemJobsArray[$key]);
							}
						}	
					}
				}		
				if(isset($this->request->post['delete_cron']['status'])){
					$systemJobsArray[] = $this->request->post['delete_cron']['job'].' ' .$curl_command;
					$this->request->post['delete_cron']['full_command'] = $this->request->post['delete_cron']['job'].' ' .$curl_command;
				}
				$systemJobsArray[] = '';
				$cron_jobs = implode(PHP_EOL, $systemJobsArray);
				file_put_contents('/tmp/crontab.txt', $cron_jobs.PHP_EOL);
				exec('crontab -r');
				exec('crontab /tmp/crontab.txt');				
				$this->module_model_object->saveDeleteCronJob($this->request->post);
				$json['success'] = 'Settings Saved!';
	        }else{
	        	$this->module_model_object->saveDeleteCronJob($this->request->post);
	        	$json['error'] = 'No Shell Access. Add or Remove(if added already), the cronjob manually';
	        }
		}
        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function deleteStats(){
		$json = array();
		if(!$this->validate()){
			$json['error'] = $this->error['warning'];
		}
		if(!$json && !isset($this->request->get['method'])){
			$json['error'] = 'Somethings not right!'; 
		}
		if(!$json){
			if($this->request->get['method'] == 'deleteActivitiesByFilter'){
				$json = $this->module_model_object->{$this->request->get['method']}(array('days'=>$this->request->post['delete_days'],'criteria'=>$this->request->post['delete_criteria']));
			}else{
				$json = $this->module_model_object->{$this->request->get['method']}();
			}
			
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	protected function validateFormMailTemplate() {
		$this->validate();
		// @formatter:off
		foreach ($this->request->post['template_description'] as $language_id => $value) {
			if($this->request->post['is_sms']){
				if ((utf8_strlen($value['sms_body']) < 3) || (utf8_strlen($value['sms_body']) > 500)) {
					$this->error['sms_body'][$language_id] = $this->language->get('error_sms_body');
				}
			}else{
				if ((utf8_strlen($value['subject']) < 3) || (utf8_strlen($value['subject']) > 64)) {
					$this->error['subject'][$language_id] = $this->language->get('error_subject');
				}
			}
		}
		
		if ((utf8_strlen($this->request->post['title']) < 3) || (utf8_strlen($this->request->post['title']) > 64)) {
			$this->error['title'] = $this->language->get('error_title');
		}
		
		foreach (array('first_mail','next_mails','maximum_mails','maximum_time','max_mail_per_day_per_email') as $key){
			if (filter_var($this->request->post[$key], FILTER_VALIDATE_INT, array("options" => array("min_range"=>0, "max_range"=>99999999999))) === false){
				$this->error[$key] = $this->language->get('error_integor');
			}
		}
		// @formatter:on
		return !$this->error;
	}

	public function install() {
		$this->load->model('setting/setting');
		if (version_compare(VERSION, '2.2.0.0') >= 0) {
			$installed = $this->model_setting_setting->getSettingValue($this->setting_name . '_activity_installed');
		} else {
			$installed = $this->getXSettingValue($this->setting_name . '_activity_installed');
		}
		if (!$installed) {
			$data[$this->setting_name . '_activity_installed'] = 1;
			$this->model_setting_setting->editSetting($this->setting_name . '_activity', $data);
			$arrContextOptions = array(
				"ssl" => array(
					"verify_peer" => false,
					"verify_peer_name" => false 
				) 
			);
			$request = array(
				'email' => $this->config->get('config_email'),
				'store' => HTTP_CATALOG,
				'module' => $this->config->get('xabandoned_module'),
				'module_title' => $this->config->get('xabandoned_module_title'),
				'module_version' => $this->config->get('xabandoned_module_version'),
				'oc_version' => VERSION 
			);
			@file_get_contents($this->config->get('xabandoned_support') . 'modsupport?' . http_build_query($request), false, stream_context_create($arrContextOptions));
		}	
	}

	public function getXSettingValue($key, $store_id = 0) {
		$query = $this->db->query("SELECT value FROM " . DB_PREFIX . "setting WHERE store_id = '" . (int)$store_id . "' AND `key` = '" . $this->db->escape($key) . "'");
		if ($query->num_rows) {
			return $query->row['value'];
		} else {
			return null;
		}
	}	
	
	public function license() {
		$fields = array(
			'activation_code',
			'license_code',
			'date_support',
			'user_name' 
		);
		foreach ($fields as $field) {
			$data[$this->setting_name . '_activity_' . $field] = isset($this->request->get[$field]) ? $this->request->get[$field] : '';
		}
		$this->load->model('setting/setting');
		if (version_compare(VERSION, '2.2.0.0') >= 0) {
			$installed = $this->model_setting_setting->getSettingValue($this->setting_name . '_activity_installed');
		} else {
			$installed = $this->getXSettingValue($this->setting_name . '_activity_installed');
		}
		if ($installed) {
			$data[$this->setting_name . '_activity_installed'] = 1;
		} else {
			$data[$this->setting_name . '_activity_installed'] = 0;
		}
		$this->load->model('setting/setting');
		$this->model_setting_setting->editSetting($this->setting_name . '_activity', $data);
		$json['success'] = 'Domain verified';
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	private function breadcrumbs($data=array()){		
		$this->data['breadcrumbs'][] = array('text' => $this->language->get('text_home'),'href' => $this->url->link('common/dashboard', $this->module_token, true));
		$this->data['breadcrumbs'][] = array('text' => $this->language->get('text_extension'),'href' => $this->back_button);
		$this->data['breadcrumbs'][] = array('text' => $this->language->get('heading_title'),'href' => $this->url->link($this->config->get('xabandoned_path'), '&' . $this->module_token , true));

		foreach($data as $link){
			$this->data['breadcrumbs'][] = array('text'=>$link['text'],'href'=>$link['href']);
		}
	}
	
	private function addHeaderFooterLeft(){
		$this->data['header'] = $this->load->controller('common/header');
		$this->data['column_left'] = $this->load->controller('common/column_left');
		$this->data['footer'] = $this->load->controller('common/footer');
	}
	
	private function view($template,$data){
		return $this->load->view($this->config->get('xabandoned_view').'/'.$template.$this->view_extension,$data);
	}
	
	public function autocomplete() {
		$json = array();

		if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_email'])) {
			if (isset($this->request->get['filter_name'])) {
				$filter_name = $this->request->get['filter_name'];
			} else {
				$filter_name = '';
			}

			if (isset($this->request->get['filter_email'])) {
				$filter_email = $this->request->get['filter_email'];
			} else {
				$filter_email = '';
			}
			
			$filter_data = array(
				'filter_name'  => $filter_name,
				'filter_email' => $filter_email,
				'start'        => 0,
				'limit'        => 5
			);

			$results = $this->module_model_object->getActivities($filter_data,0);

			foreach ($results as $result) {
				$json[] = array(
					'name'  => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
					'email' => $result['email']
				);
			}
		}
		$json = array_map("unserialize", array_unique(array_map("serialize", $json)));

		$sort_order = array();

		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['name'];
		}

		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function menus($referer = array()) {
		if(isset($referer['data'])){
			$this->load->language('common/column_left');
		}else{
			$this->load->language('common/menu');
		}
		$data = array();
		if ($this->user->hasPermission('access', $this->config->get('xabandoned_path')) && $this->config->get($this->xabandoned_config_pfx.'menubar')) {
			$xabandoned_totals = $this->module_model_object->getTotalActivities(array('filter_last_step' => '99','filter_abandoned_cart' => 'abandoned'));
			$xmodule_token = $this->config->get('xabandoned_token') . '=' . $this->session->data[$this->config->get('xabandoned_token')];
			$labels = $xabandoned_totals ? "label label-danger" : "label label-success";
			
			$xabanoned_carts[] = array(
				'name' => 'Settings',
				'href' => $this->url->link($this->config->get('xabandoned_path'), $xmodule_token, true),
				'children' => array() 
			);
			
			$xabanoned_carts[] = array(
				'name' => 'Abandoned Carts <span class="' . $labels . '">' . $xabandoned_totals . '</span>',
				'href' => $this->url->link($this->config->get('xabandoned_path') . '/activity', $xmodule_token, true),
				'children' => array() 
			);
			
			$xabanoned_carts[] = array(
				'name' => 'Mail Templates',
				'href' => $this->url->link($this->config->get('xabandoned_path') . '/mailTemplate', $xmodule_token, true),
				'children' => array() 
			);
			
			if ($xabanoned_carts) {
				$menu = array(
					'id' => 'menu-xabandoned_carts',
					'icon' => 'fa fa-sign-out fa-fw',
					'name' => 'X Abandoned Carts <span class="' . $labels . '">' . $xabandoned_totals . '</span>',
					'href' => '',//$this->url->link($this->config->get('xabandoned_path') . '/activity', $xmodule_token, true),
					'children' => $xabanoned_carts 
				);
				if(isset($referer['data'])){
					//opencart 2.3 and above
					$referer['data']['menus'][] = $menu;
					return ;
				}else{
					$data['xabmenus'][] = $menu;
				}
			}
			return $this->view('menu', $data);
		}		
		return '';
	}
}
