<?php

		$data['tabs'][] = array(
			'id'		=> 'tab_readme',
			'title'		=> $this->language->get('tab_readme')
		);

		$data['tabs'][] = array(
			'id'		=> 'tab_general',
			'title'		=> $this->language->get('tab_general')
		);

		$data['tabs'][] = array(
			'id'		=> 'tab_debug',
			'title'		=> $this->language->get('tab_debug')
		);

		$data['tabs'][] = array(
			'id'		=> 'tab_support',
			'title'		=> $this->language->get('tab_support')
		);

$readme = <<<EOF
How to setup your Moneris Account:
=====================
1. First setup a test account. To activate test mode, Moneris offers test accounts to use. 
Be aware that if another store is using one of the accounts, you will need to try a different account.

For US Accounts:
	STORE ID	USERNAME 	PASSWORD
	monusqa002 	DemoUser 	password

For Canada Accounts:
	STORE ID	USERNAME 	PASSWORD
	store1 		DemoUser 	password
	store2 		DemoUser 	password
	store3 		DemoUser 	password
	
	
You can login to the test moneris admin area with the username and password fields here:
https://esqa.moneris.com/mpg/index.php

2. click on "Admin->Hosted Config"
3. Click the "Generate a Version3 Configuration" button
4. You are directed to a page with a ps_store_id and hpp_key.
You will enter both of those in the opencart admin configuration
5. Choose Transaction Type: Purchase
6. Choose Response Method: "Sent to your server as a POST"
7. Set Approved URL: 
	For the CA account:
		If using OpenCart: http://yoursite.com/catalog/controller/payment/moneris_hosted_ca_callback.php
		If using Mijo or Ace Shop:  http://yoursite.com/components/com_mijoshop/opencart/catalog/controller/payment/moneris_hosted_ca_callback.php
	For the US account:
		If using OpenCart: http://yoursite.com/catalog/controller/payment/moneris_hosted_callback.php
		If using Mijo or Ace Shop:  http://yoursite.com/components/com_mijoshop/opencart/catalog/controller/payment/moneris_hosted_callback.php
8. Set the same as above for the Declined URL (and Cancel URL if exists)
9. Check "Use Enhanced Cancel"
10. Save

In test mode, Use 4242424242424242 as the credit card number with any valid exp date and name.
NOTE: Transactions in the test environment should not exceed $10.00.

Transactions in test mode do not validate the same as they do in production.
eSelect uses a "Penny Code" system that changes the result based on the cent value of the order

If the cart total is : $1.00 it will approve everything
If the cart total is : $1.01 it will give "call for auth"
If the cart total is : $1.05 it will give "declined"
etc.
The included Simulator_Penny_Value_Responses_ca.pdf guide in the docs folder has a different response for each cent value.
Once you finish testing, do the same for production mode, using the same url values

EOF;

		$data['fields'][] = array(
			'tab'			=> 'tab_readme',
			'entry'			=> 'Readme:',
			'type'			=> 'label',
			'name'			=> '',
			'value'			=> nl2br($readme),
			'help'			=> ($this->language->get('help_readme') != 'help_readme' ? $this->language->get('help_readme') : ''),
			'tooltip'		=> ($this->language->get('tooltip_readme') != 'tooltip_readme' ? $this->language->get('tooltip_readme') : '')
		);		
		
		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_status'),
			'type'			=> 'select',
			'name' 			=> 'status',
			'value' 		=> (isset($this->request->post['status'])) ? $this->request->post['status'] : $this->config->get($classname . '_status'),
			'required' 		=> false,
			'options'		=> array(
				'0' => $this->language->get('text_disabled'),
				'1' => $this->language->get('text_enabled')
			),
			'help'			=> ($this->language->get('help_status') != 'help_status' ? $this->language->get('help_status') : ''),
			'tooltip'		=> ($this->language->get('tooltip_status') != 'tooltip_status' ? $this->language->get('tooltip_status') : '')
		);

		foreach ($languages as $language_id => $language_name) {
			$data['fields'][] = array(
				'tab'			=> 'tab_general',
				'entry' 		=> '[ ' . $language_name . ' ] ' . $this->language->get('entry_title'),
				'type'			=> 'text',
				'size'			=> '20',
				'name' 			=> 'title_' . $language_id,
				'value' 		=> ((isset($this->request->post['title_' . $language_id])) ? $this->request->post['title_' . $language_id] : $this->config->get($classname . '_title_' . $language_id) ? $this->config->get($classname . '_title_' . $language_id) : ucwords(str_replace(array('-','_','.'), " ", $classname))),
				'required' 		=> false,
				'help'			=> ($this->language->get('help_title') != 'help_title' ? $this->language->get('help_title') : ''),
				'tooltip'		=> ($this->language->get('tooltip_title') != 'tooltip_title' ? $this->language->get('tooltip_title') : '')
			);
		}

		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_country'),
			'type'			=> 'select',
			'name' 			=> 'country',
			'value' 		=> (isset($this->request->post['country'])) ? $this->request->post['country'] : $this->config->get($classname . '_country'),
			'required' 		=> false,
			'options'		=> array(
				'CA' => 'CA',
				'US' => 'US'
			),
			'help'			=> ($this->language->get('help_country') != 'help_country' ? $this->language->get('help_country') : ''),
			'tooltip'		=> ($this->language->get('tooltip_country') != 'tooltip_country' ? $this->language->get('tooltip_country') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_test'),
			'type'			=> 'select',
			'name' 			=> 'test',
			'value' 		=> (isset($this->request->post['test'])) ? $this->request->post['test'] : $this->config->get($classname . '_test'),
			'required' 		=> false,
			'options'		=> array(
				'0' => $this->language->get('text_no'),
				'1' => $this->language->get('text_yes')
			),
			'help'			=> ($this->language->get('help_test') != 'help_test' ? $this->language->get('help_test') : ''),
			'tooltip'		=> ($this->language->get('tooltip_test') != 'tooltip_test' ? $this->language->get('tooltip_test') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_mid'),
			'type'			=> 'text',
			'name' 			=> 'mid',
			'value' 		=> (isset($this->request->post['mid'])) ? $this->request->post['mid'] : $this->config->get($classname . '_mid'),
			'required' 		=> true,
			'help'			=> ($this->language->get('help_mid') != 'help_mid' ? $this->language->get('help_mid') : ''),
			'tooltip'		=> ($this->language->get('tooltip_mid') != 'tooltip_mid' ? $this->language->get('tooltip_mid') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_key'),
			'type'			=> 'text',
			'name' 			=> 'key',
			'value' 		=> (isset($this->request->post['key'])) ? $this->request->post['key'] : $this->config->get($classname . '_key'),
			'required' 		=> true,
			'help'			=> ($this->language->get('help_key') != 'help_key' ? $this->language->get('help_key') : ''),
			'tooltip'		=> ($this->language->get('tooltip_key') != 'tooltip_key' ? $this->language->get('tooltip_key') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_iframe'),
			'type'			=> 'select',
			'name' 			=> 'iframe',
			'value' 		=> (isset($this->request->post['iframe'])) ? $this->request->post['iframe'] : $this->config->get($classname . '_iframe'),
			'required' 		=> false,
			'options'		=> array(
				'0' => $this->language->get('text_no'),
				'1' => $this->language->get('text_yes')
			),
			'help'			=> ($this->language->get('help_iframe') != 'help_iframe' ? $this->language->get('help_iframe') : ''),
			'tooltip'		=> ($this->language->get('tooltip_iframe') != 'tooltip_iframe' ? $this->language->get('tooltip_iframe') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_preload'),
			'type'			=> 'select',
			'name' 			=> 'preload',
			'value' 		=> (isset($this->request->post['preload'])) ? $this->request->post['preload'] : $this->config->get($classname . '_preload'),
			'required' 		=> false,
			'options'		=> array(
				'0' => $this->language->get('text_no'),
				'1' => $this->language->get('text_yes')
			),
			'help'			=> ($this->language->get('help_preload') != 'help_preload' ? $this->language->get('help_preload') : ''),
			'tooltip'		=> ($this->language->get('tooltip_preload') != 'tooltip_preload' ? $this->language->get('tooltip_preload') : '')
		);
		
		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_total'),
			'type'			=> 'text',
			'name' 			=> 'total',
			'value' 		=> (isset($this->request->post['total'])) ? $this->request->post['total'] : $this->config->get($classname . '_total'),
			'required' 		=> false,
			'help'			=> ($this->language->get('help_total') != 'help_total' ? $this->language->get('help_total') : ''),
			'tooltip'		=> ($this->language->get('tooltip_total') != 'tooltip_total' ? $this->language->get('tooltip_total') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_max_total'),
			'type'			=> 'text',
			'name' 			=> 'max_total',
			'value' 		=> (isset($this->request->post['max_total'])) ? $this->request->post['max_total'] : $this->config->get($classname . '_max_total') ? $this->config->get($classname . '_max_total') : '2000',
			'required' 		=> false,
			'help'			=> ($this->language->get('help_max_total') != 'help_max_total' ? $this->language->get('help_max_total') : ''),
			'tooltip'		=> ($this->language->get('tooltip_max_total') != 'tooltip_max_total' ? $this->language->get('tooltip_max_total') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_supported_currencies'),
			'type'			=> 'scrollbox',
			'name' 			=> 'supported_currencies[]',
			'value' 		=> explode(',', (isset($this->request->post['supported_currencies'])) ? $this->request->post['supported_currencies'] : $this->config->get($classname . '_supported_currencies') ? $this->config->get($classname . '_supported_currencies') : ''),
			'required' 		=> false,
			'options'		=> $currencies,
			'help'			=> ($this->language->get('help_supported_currencies') != 'help_supported_currencies' ? $this->language->get('help_supported_currencies') : ''),
			'tooltip'		=> ($this->language->get('tooltip_supported_currencies') != 'tooltip_supported_currencies' ? $this->language->get('tooltip_supported_currencies') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_default_currency'),
			'type'			=> 'select',
			'name' 			=> 'default_currency',
			'value' 		=> (isset($this->request->post['default_currency'])) ? $this->request->post['default_currency'] : $this->config->get($classname . '_default_currency'),
			'required' 		=> false,
			'options'		=> $currencies,
			'help'			=> ($this->language->get('help_default_currency') != 'help_default_currency' ? $this->language->get('help_default_currency') : ''),
			'tooltip'		=> ($this->language->get('tooltip_default_currency') != 'tooltip_default_currency' ? $this->language->get('tooltip_default_currency') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_order_status'),
			'type'			=> 'select',
			'name' 			=> 'order_status_id',
			'value' 		=> (isset($this->request->post['order_status_id'])) ? $this->request->post['order_status_id'] : $this->config->get($classname . '_order_status_id'),
			'required' 		=> false,
			'options'		=> $order_statuses,
			'help'			=> ($this->language->get('help_order_status') != 'help_order_status' ? $this->language->get('help_order_status') : ''),
			'tooltip'		=> ($this->language->get('tooltip_order_status') != 'tooltip_order_status' ? $this->language->get('tooltip_order_status') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry' 		=> $this->language->get('entry_geo_zone'),
			'type'			=> 'select',
			'name' 			=> 'geo_zone_id',
			'value' 		=> (isset($this->request->post['geo_zone_id'])) ? $this->request->post['geo_zone_id'] : $this->config->get($classname . '_geo_zone_id'),
			'required' 		=> false,
			'options'		=> $geo_zones,
			'help'			=> ($this->language->get('help_geo_zone') != 'help_geo_zone' ? $this->language->get('help_geo_zone') : ''),
			'tooltip'		=> ($this->language->get('tooltip_geo_zone') != 'tooltip_geo_zone' ? $this->language->get('tooltip_geo_zone') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_general',
			'entry'			=> $this->language->get('entry_sort_order'),
			'type'			=> 'text',
			'name'			=> 'sort_order',
			'value'			=> (isset($this->request->post['sort_order'])) ? $this->request->post['sort_order'] : $this->config->get($classname . '_sort_order'),
			'required'		=> false,
			'help'			=> ($this->language->get('help_sort_order') != 'help_sort_order' ? $this->language->get('help_sort_order') : ''),
			'tooltip'		=> ($this->language->get('tooltip_sort_order') != 'tooltip_sort_order' ? $this->language->get('tooltip_sort_order') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_debug',
			'entry' 		=> $this->language->get('entry_debug'),
			'type'			=> 'select',
			'name' 			=> 'debug',
			'value' 		=> (isset($this->request->post['debug'])) ? $this->request->post['debug'] : $this->config->get($classname . '_debug'),
			'required' 		=> false,
			'options'		=> array(
				'0' => $this->language->get('text_disabled'),
				'1' => $this->language->get('text_enabled')
			),
			'help'			=> ($this->language->get('help_debug') != 'help_debug' ? $this->language->get('help_debug') : ''),
			'tooltip'		=> ($this->language->get('tooltip_debug') != 'tooltip_debug' ? $this->language->get('tooltip_debug') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_debug',
			'entry'			=> $this->language->get('entry_debug_file'),
			'type'			=> 'label',
			'name'			=> '',
			'value'			=> DIR_LOGS . $classname . '_debug.txt',
			'help'			=> ($this->language->get('help_debug_file') != 'help_debug_file' ? $this->language->get('help_debug_file') : ''),
			'tooltip'		=> ($this->language->get('tooltip_debug_file') != 'tooltip_debug_file' ? $this->language->get('tooltip_debug_file') : '')
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_debug',
			'entry'			=> '',
			'type'			=> 'textarea',
			'cols'			=> '160',
			'rows'			=> '100',
			'name'			=> '',
			'value'			=> (file_exists(DIR_LOGS . $classname . '_debug.txt')) ? file_get_contents(DIR_LOGS . $classname . '_debug.txt') : 'empty'
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_support',
			'entry'			=> 'Troubleshooting Info: ',
			'type'			=> 'label',
			'name'			=> 'troubleshooting',
			'value'			=> '',
			'help'			=> '',
			'tooltip'		=> ''
		);

		$data['fields'][] = array(
			'tab'			=> 'tab_support',
			'entry'			=> 'Support Info:',
			'type'			=> 'label',
			'name'			=> 'support',
			'value'			=> 'For support questions, contact me at qphoria@gmail.com or on skype: taqmobile',
			'help'			=> '',
			'tooltip'		=> ''
		);

?>