<?php
class ControllerExtensionSitemapRobots extends Controller {
	private $error = array();

	public function index() {
		$labels = $this->load->language('extension/sitemap/robots');
		
		foreach ($labels as $label_key => $label) {
		        $data[$label_key] = $label;
                }

		$this->document->setTitle($this->language->get('text_edit'));

		$this->load->model('setting/setting');
		
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			if (empty($this->request->post['robots_status']['status']) || ($this->request->post['robots_status']['status'] == 0)) {
                                $this->model_setting_setting->editSettingValue('robots', 'robots_status', 0, $this->request->get['store_id']);
                        } else {
			        $this->model_setting_setting->editSetting('robots', $this->request->post, $this->request->get['store_id']);
                        }

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=sitemap', true));
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=sitemap', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/sitemap/robots', 'user_token=' . $this->session->data['user_token'] . '&store_id=' . $this->request->get['store_id'], true)
		);

		$data['action'] = $this->url->link('extension/sitemap/robots', 'user_token=' . $this->session->data['user_token'] . '&store_id=' . $this->request->get['store_id'], true);
		
		$data['clear_action'] = str_replace('&amp;', '&', $this->url->link('extension/sitemap/robots/clear_cache', 'user_token=' . $this->session->data['user_token'] . '&store_id=' . $this->request->get['store_id'], true));
		
		$data['delete_robots'] = str_replace('&amp;', '&', $this->url->link('extension/sitemap/robots/delete_robots', 'user_token=' . $this->session->data['user_token'] . '&store_id=' . $this->request->get['store_id'], true));

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=sitemap', true);
		
		$data['user_token'] = $this->session->data['user_token'];
		
		// Check robots.txt exists
		if (is_file(dirname(DIR_APPLICATION) . '/robots.txt')) {
			$data['error_warning'] = $this->language->get('error_robots');
		}
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
				
		$data['settings'] = json_decode($this->model_setting_setting->getSettingValue('robots_status', $this->request->get['store_id']), true);
		
		if (isset($data['settings']['status'])) {
                        $data['status'] = $data['settings']['status'];
                } else {
                        $data['status'] = false;
                }

                if (isset($data['settings']['rules'])) {
                        $data['rules'] = $data['settings']['rules'];
                } else {
                        $data['rules'] = <<<EOS
User-agent: *
Allow: /
Disallow: /login
Disallow: /create-account
Disallow: /forgot-password
Disallow: /my-account
Disallow: /address-book
Disallow: /wishlist
Disallow: /order-history
Disallow: /downloads
Disallow: /recurring
Disallow: /reward-points
Disallow: /return
Disallow: /transactions
Disallow: /newsletter
Disallow: /edit-account
Disallow: /change-password
Disallow: /logout
Disallow: /request-return
Disallow: /gift-vouchers
Disallow: /compare-products
Disallow: /search
Disallow: /contact-us
Disallow: /shopping-cart
Disallow: /checkout
Disallow: /affiliates
Disallow: /create-affiliate-account
Disallow: /affiliate-login
Disallow: /affiliate-transactions
Disallow: /affiliate-tracking-code
Disallow: /affiliate-payment-options
Disallow: /edit-affiliate-account
Disallow: /change-affiliate-password
Disallow: /affiliate-logout
Disallow: /affiliate-forgot-password
Disallow: /success
Disallow: /admin
Disallow: /system
Disallow: *?sort=*
Disallow: *&sort=*
Disallow: *route=account
Disallow: *route=affiliate
Disallow: *route=checkout
Disallow: *search
Disallow: *?sort=*
Disallow: *&sort=*
Disallow: *?order=*
Disallow: *&order=*
Disallow: *?limit=*
Disallow: *&limit=*
Disallow: /index.php?route=product/compare
Disallow: /index.php?route=checkout/*
Disallow: /index.php?route=common/maintenance
Disallow: /index.php?route=common/cart
Disallow: /index.php?route=account/*
Disallow: /index.php?route=information/contact

EOS;
                }
		
		if (isset($data['settings']['cache_expire'])) {
                        $data['cache_expire'] = $data['settings']['cache_expire'];
                } else {
                        $data['cache_expire'] = '3600';
                }
		
		if (isset($data['settings']['cache_type'])) {
                        $data['cache_type'] = $data['settings']['cache_type'];
                } else {
                        $data['cache_type'] = 'file';
                }
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/sitemap/robots', $data));
	}
	
	
	public function clear_cache() {
	        $this->load->model('setting/setting');
	        $data['settings'] = json_decode($this->model_setting_setting->getSettingValue('robots_status', $this->request->get['store_id']), true);
	        $this->registry->set('cache', new Cache($data['settings']['cache_type'], $data['settings']['cache_expire']));
	        $json = array();
	        $cache = 'robots_rules_store'.(int)$this->request->get['store_id'];	        
		        if ($this->cache->get($cache)) {
			        $this->cache->delete($cache);
			}
	        $json['cached'] = array($cache => (bool)$this->cache->get($cache));
	        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function delete_robots() {
	        $this->load->language('extension/sitemap/robots');
	        $json = array();
	        $file = dirname(DIR_APPLICATION).'/robots.txt';
	        $file_copy = dirname(DIR_APPLICATION).'/robots.backup.txt.'.mt_rand();
	        if (!is_file($file) || (!is_writable($file) || !is_readable($file))) {      
                        $json['error'] = $this->language->get('robots_error_perms');
                } 
                if (!$json['error']) {
	                if (copy($file, $file_copy) && unlink($file)) {
                                $json['success'] = $this->language->get('robots_success_backup');
                        } else {
                                $json['error'] = $this->language->get('robots_error_perms_copy');
                        }
	        }
	        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/sitemap/robots')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
                if ($this->request->post['robots_status']['status']) {
                
		        if (empty($this->request->post['robots_status']['rules'])) {
			        $this->error['warning'] = $this->language->get('error_data_rules');
		        }
		        
		        if ($this->request->post['robots_status']['cache_expire'] < 3600) {
		                $this->error['warning'] = $this->language->get('error_expire_less');
		        }
		        
		        if (isset($this->request->post['robots_status']['cache_type']) && !in_array($this->request->post['robots_status']['cache_type'], array("file","mem","apc"), true)) {
                        $this->error['warning'] = $this->language->get('error_cache_types');
                        }
                        
                        if (is_file(dirname(DIR_APPLICATION) . '/robots.txt')) {
			        $this->error['warning'] = $this->language->get('error_robots');
		        } 
		}

		return !$this->error;
	}
}
