<?php
class ModelExtensionCustomercart extends Model {
	public function getStoreCartCustomers($data = array()) {
		if (!empty($data['filter_notify_order'])) {
			$sql = "SELECT * FROM " . DB_PREFIX . "storecart_order WHERE `email` !=''";
		}else{
			$sql = "SELECT * FROM " . DB_PREFIX . "storecart WHERE `email` !=''";
		}
		
		if (!empty($data['filter_customer'])) {
			$sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
		}
		
		if (!empty($data['filter_email'])) {
			$sql .= " AND email LIKE '%" . $this->db->escape($data['filter_email']) . "%'";
		}
		
		if (!empty($data['filter_notify']) && !is_null($data['filter_notify'])) {
			$sql .= " AND email_notify LIKE '%" . $this->db->escape($data['filter_notify']) . "%'";
		}
		
		$sort_data = array(
			'date_added',
		);

		$sql .= " GROUP BY `email`";
		
		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY date_added";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		// echo $sql; die();
		
		$query = $this->db->query($sql);

		// print_r($query->rows); die();
		
		
		return $query->rows;
  }
	
	public function getTotalStoreCartCustomers($data = array()){ 
			
			$sql = "show table status where name='".DB_PREFIX . "storecart_order'";
			$query = $this->db->query($sql);
			if(empty($query->row))
			{
				
					$this->load->model('extension/store_cart');
					$this->model_extension_store_cart->install();
			}
	
		if (!empty($data['filter_notify_order'])) {
			$sql = "SELECT * FROM " . DB_PREFIX . "storecart_order WHERE `email` !='' ";
		}else{
			$sql = "SELECT * FROM " . DB_PREFIX . "storecart WHERE `email` !='' ";
		}
		
		if (!empty($data['filter_customer'])) {
			$sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['filter_customer']) . "%'";
		}
		
		if (!empty($data['filter_email'])) {
			$sql .= " AND email LIKE '%" . $this->db->escape($data['filter_email']) . "%'";
		}
		
		if (isset($data['filter_notify']) && !is_null($data['filter_notify'])) {
			$sql .= " AND email_notify LIKE '%" . $this->db->escape($data['filter_notify']) . "%'";
		}
		
		$sql .= " GROUP BY `email`";
		
		$query = $this->db->query($sql);

		return $query->num_rows;
  }
	
	public function getStoreCartsByEmail($data = array()) { 	
		if (!empty($data['filter_notify_order'])) {
			$sql = "SELECT `email_notify`, `product_id`, `option`, `date_added`, `quantity`  FROM " . DB_PREFIX . "storecart_order WHERE LCASE(email) = '". $this->db->escape(utf8_strtolower($data['email'])) ."'";
		}else{
			$sql = "SELECT `email_notify`, `product_id`, `option`, `date_added`, `quantity`  FROM " . DB_PREFIX . "storecart WHERE LCASE(email) = '". $this->db->escape(utf8_strtolower($data['email'])) ."'";
		}
		
		if (isset($data['filter_notify']) && !is_null($data['filter_notify'])) {
			$sql .= " AND email_notify LIKE '%" . $this->db->escape($data['filter_notify']) . "%'";
		}
		
		 $sql .= "ORDER BY date_added DESC";
		
		$query = $this->db->query($sql);

		return $query->rows;
  }
	
	public function getOneStoreCartsByEmail($email){ 	
		$sql = "SELECT * FROM " . DB_PREFIX . "storecart WHERE LCASE(email) = '". $this->db->escape(utf8_strtolower($email)) ."' ORDER BY date_added DESC LIMIT 0,1";
		
		$query = $this->db->query($sql);

		return $query->row;
  }
	
	public function updateNotifyByEmail($email) {
		$count_email_notify = 1 ;
		$this->db->query("UPDATE " . DB_PREFIX . "storecart SET email_notify = '1', count_email_notify = (count_email_notify + " . (int)$count_email_notify . ") WHERE LCASE(email) = '". $this->db->escape(utf8_strtolower($email)) ."'");
	}
	
	/// New work  start ///
	public function deletestorecart($storecart_id){ 	
		$this->db->query("delete FROM " . DB_PREFIX . "storecart where storecart_id='".$storecart_id."'");
	}
  
	public function deletecart($product_id, $customer_id, $email){ 	
		$this->db->query("delete FROM " . DB_PREFIX . "storecart WHERE product_id = '".$product_id."' AND customer_id='".$customer_id."'");
		$this->db->query("delete FROM " . DB_PREFIX . "cart WHERE product_id = '".$product_id."' AND customer_id='".$customer_id."'");
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "abandonecart_coupon WHERE email='".$this->db->escape($email)."'");
		if(!empty($query->row)){
			$this->db->query("DELETE FROM " . DB_PREFIX . "coupon WHERE coupon_id = '" . (int)$query->row['coupon_id'] . "'");
		}
		$this->db->query("delete FROM " . DB_PREFIX . "abandonecart_coupon WHERE email='".$this->db->escape($email)."'");
	}
  
	public function getguestvalue($data){
		
		$sql="SELECT sum(s.quantity*p.price) as total, p.tax_class_id FROM " .DB_PREFIX. "storecart s left join `" .DB_PREFIX. "product` p on p.product_id=s.product_id where type<>''";
		if(isset($data['type']))
		{
			$sql .=" and type='".$this->db->escape($data['type'])."'";
		}
		
		$query=$this->db->query($sql);
		if(isset($query->row['total']))
		{	
			return $query->row['total'];
			
		}
		
	}
	
	
	
	public function getusecoupon(){
		$sql = "SELECT COUNT(*) as total FROM ".DB_PREFIX."coupon_history";
		$query = $this->db->query($sql);

		return $query->row['total']; 
	}
	
	
/**/
	public function InsertNotifyByEmail($cart_id, $storecart_id, $customer_id, $email) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "order_emailnotify SET cart_id = '".(int)$cart_id."', storecart_id = '".(int)$storecart_id."', customer_id='".(int)$customer_id."' ,email = '".$email."', email_notify = 1, date_added=NOW()");
		
	}
	
	public function getStoreId($customer_id){ 	
		$sql = "SELECT store_id FROM " . DB_PREFIX . "storecart WHERE customer_id = '". (int)$customer_id ."'";
		
		$query = $this->db->query($sql);

		return $query->row['store_id'];
	}
	
	public function getabandonecattvalue($data){
		$sql="SELECT * FROM " .DB_PREFIX. "storecart";
		$query=$this->db->query($sql);
		$value = 0;
		foreach($query->rows as $row){
			if($row['type'] == 'customer'){
				$query1 = $this->db->query("SELECT * FROM " . DB_PREFIX ."product WHERE product_id= '".$row['product_id']."' ");
				$value += $query1->row['price'];
			} if($query->row['type'] == 'guest'){
				$query2 = $this->db->query("SELECT * FROM " . DB_PREFIX ."product WHERE product_id= '".$row['product_id']."' ");
				$value += $query1->row['price'];
			}
		}
		return $value;
	}
	
	public function getTotalCustomer($data){
		
		$sql="SELECT COUNT(*) as total FROM " .DB_PREFIX. "storecart where type<>''";
		
		if(isset($data['type'])) {
			$sql .=" and type='".$this->db->escape($data['type'])."'";
		}
		
		$query=$this->db->query($sql);
		if(isset($query->row['total']))
		{
			return $query->row['total'];
		}
	}
	
	public function genratecoupon($storecart_id) {
		$code=rand(0000, 9999);
		$configdata = $this->config->get('crownjob_stores');
		$customer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "storecart WHERE storecart_id='".(int)$storecart_id."'");
		
		if(isset($customer_query->row['store_id'])){
			$store_id = $customer_query->row['store_id'];
		} else {
			$store_id = 0;
		}
		
		
		if (!empty($configdata[$store_id]['coupondiscount'])) {
			$coupondiscount = $configdata[$store_id]['coupondiscount'];
		}else{
			$coupondiscount =0;
		}

		if (!empty($configdata[$store_id]['coupondatestart'])) {
			$coupondatestart = $configdata[$store_id]['coupondatestart'];
		}else{
			$coupondatestart =0;
		}


		if (!empty($configdata[$store_id]['coupondateend'])) {
			$coupondateend = $configdata[$store_id]['coupondateend'];
		}else{
			$coupondateend =0;
		}
		
		$coupondiscount 	= $coupondiscount;
		$coupondatestart 	= $coupondatestart;
		$coupondateend 		= $coupondateend;
		
		if ($customer_query->row['email']) {
			
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "abandonecart_coupon WHERE email='".$customer_query->row['email']."'");
			
			if($query->row['email'] != $customer_query->row['email']){
				$this->db->query("INSERT INTO " . DB_PREFIX . "coupon SET name='customer coupon', date_start = '".$coupondatestart."',date_end = '".$coupondateend."', code='".$code."',discount = '".$coupondiscount."',status='1',type='P', date_added=NOW()");
				$coupon_id = $this->db->getLastId();			
				$this->db->query("INSERT INTO " . DB_PREFIX . "abandonecart_coupon SET email='".$this->db->escape($customer_query->row['email'])."',coupon_id='".$coupon_id."'");
			}
			
		}
	}
	
	public function getCoupon($email){
		$sql = "SELECT * FROM ".DB_PREFIX."abandonecart_coupon abc LEFT JOIN " .DB_PREFIX. "coupon c ON (abc.coupon_id = c.coupon_id) WHERE abc.email ='".$email."' order by date_added DESC";
		$query = $this->db->query($sql);

		return $query->row; 
	}
	
	public function getnotifyhistory($customer_id){
		$sql = "SELECT *, oe.date_added  FROM ".DB_PREFIX."order_emailnotify oe LEFT JOIN ".DB_PREFIX."customer c ON (oe.customer_id = c.customer_id) WHERE oe.customer_id='".$customer_id."'";
		$query = $this->db->query($sql);

		return $query->rows; 
	}
	
	public function getProOption($product_id, $product_option_id){
		$query = $this->db->query("SELECT po.product_option_id, po.option_id, od.name, o.type FROM " . DB_PREFIX . "product_option po LEFT JOIN `" . DB_PREFIX . "option` o ON (po.option_id = o.option_id) LEFT JOIN " . DB_PREFIX . "option_description od ON (o.option_id = od.option_id) WHERE po.product_option_id = '" . (int)$product_option_id . "' AND po.product_id = '" . (int)$product_id . "' AND od.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		return $query->row; 
	}
	
	public function getProOptionvalue($product_id, $product_option_id, $value){
		$query = $this->db->query("SELECT pov.option_value_id, ovd.name, pov.quantity, pov.subtract, pov.price, pov.price_prefix, pov.points, pov.points_prefix, pov.weight, pov.weight_prefix FROM " . DB_PREFIX . "product_option_value pov LEFT JOIN " . DB_PREFIX . "option_value ov ON (pov.option_value_id = ov.option_value_id) LEFT JOIN " . DB_PREFIX . "option_value_description ovd ON (ov.option_value_id = ovd.option_value_id) WHERE pov.product_id = '" . (int)$product_id . "' AND pov.product_option_value_id = '" . (int)$value . "' AND pov.product_option_id = '" . (int)$product_option_id . "' AND ovd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
		return $query->row; 
	}
	
}	
