<?php
class ModelExtensionModuleXabandonedCarts extends Model {

	public function getActivities($data = array()) {
		$sql = "SELECT *, CONCAT(xao.firstname, ' ', xao.lastname) AS name FROM " . DB_PREFIX . "xtensions_activity_order xao";
		
		$sql .= $this->makeFilter($data);
		
		$sql .= " ORDER BY xao.date_modified DESC, xao.date_added DESC";
		
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}
			
			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}
			
			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getTotalActivities($data = array()) {
		$sql = "SELECT COUNT(DISTINCT xao.activity_session_code) AS total FROM " . DB_PREFIX . "xtensions_activity_order xao";
		
		$sql .= $this->makeFilter($data);
		
		$sql .= " ORDER BY xao.date_modified DESC, xao.date_added DESC";
		
		$query = $this->db->query($sql);

		return $query->row['total'];
	}
	
	private function makeFilter($data=array()){
		$sql = '';
		$implode = array();
		
		if (!empty($data['filter_date_start'])) {
			$implode[] = "DATE(xao.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
		}
		
		if (!empty($data['filter_date_end'])) {
			$implode[] = "DATE(xao.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
		}
		
		if (!empty($data['filter_customer'])) {
			$implode[] = "xao.name LIKE '" . $this->db->escape($data['filter_customer']) . "'";
		}
		
		if (!empty($data['filter_email'])) {
			$implode[] = "xao.email LIKE '" . $this->db->escape($data['filter_email']) . "%'";
		}
		
		if (!empty($data['filter_ip'])) {
			$implode[] = "xao.ip LIKE '" . $this->db->escape($data['filter_ip']) . "'";
		}
		
		if (isset($data['filter_last_step']) && $data['filter_last_step']!=null && $data['filter_last_step']!='all') {
			if($data['filter_last_step'] == '99'){
				$implode[] = "xao.last_step <> '4'";
			}else{
				$implode[] = "xao.last_step = '" . $this->db->escape($data['filter_last_step']) . "'";
			}
		}
		
		if (!empty($data['filter_store_id'])) {
			$implode[] = "xao.store_id = '" . (int)$data['filter_store_id'] . "'";
		}
		
		if (empty($data['filter_abandoned_cart']) || $data['filter_abandoned_cart']=='abandoned') {
			$implode[] = "xao.cart <> ''";
		}
		
		
		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}
		
		return $sql;
	}
	
	public function getActivitiesByStep($data){
		$data = array();
		$sql = "SELECT last_step, COUNT(*) as total FROM `" . DB_PREFIX . "xtensions_activity_order` xao";
		$sql .= $this->makeFilter($data);
		$sql .= ' GROUP BY xao.last_step ORDER BY xao.last_step ASC';
		$query = $this->db->query($sql);
		foreach ($query->rows as $row){
			$data['step'.$row['last_step']] = $row['total'];
		}
		return $data;
	}

	public function getActivity($activity_code) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "xtensions_activity_order xao WHERE activity_session_code = '" . $this->db->escape($activity_code) . "'");
		
		if ($query->num_rows) {
			return $query->row;
		}
		return null;
	}

	public function getDetailedActivity($activity_code) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "xtensions_activity_step_by_step WHERE activity_session_code = '" . $this->db->escape($activity_code) . "' ORDER BY xcustomer_activity_id DESC");
		
		return $query->rows;
	}

	public function deleteActivity($activity_code){
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_to_mail WHERE activity_session_code = '" . $this->db->escape($activity_code) . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_step_by_step WHERE activity_session_code = '" . $this->db->escape($activity_code) . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_order WHERE activity_session_code = '" . $this->db->escape($activity_code) . "'");
	}
	
	public function deleteActivitiesByFilter($data){
		$sql = "SELECT `activity_session_code` AS total FROM `" . DB_PREFIX . "xtensions_activity_order`"; 
		$where =" WHERE (DATE(date_added) <= date_sub(DATE(now()), INTERVAL " . (int)$data['days'] . " DAY))";
		if($data['criteria'] == 'blank'){
			$where .= " AND ( cart IS NULL OR cart = '' OR last_step = 4 ) ";
		}
		$sql .= $where;
		$this->db->query("DELETE FROM `" . DB_PREFIX . "xtensions_activity_to_mail` WHERE `activity_session_code` IN ( " . $sql . " )");
		$this->db->query("DELETE FROM `" . DB_PREFIX . "xtensions_activity_step_by_step` WHERE `activity_session_code` IN ( " . $sql . " )");
		$this->db->query("DELETE FROM `" . DB_PREFIX . "xtensions_activity_order`".$where);
		return array('success' => $this->language->get('success_activities_deleted'),'total'=>$this->getAllActivities(),'abandoned'=>$this->getTotalActivities(array('filter_last_step' => '99','filter_abandoned_cart' => 'abandoned')));
	}
	
	// Xtensions Mail Template
	public function addMailTemplate($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "xtensions_activity_mail_template SET shipping = '" . (int)$data['shipping'] . "', customer_login = '" . (int)$data['customer_login'] . "', status = '" . (int)$data['status'] . "', is_sms = '" . (int)$data['is_sms'] . "', title = '" . $this->db->escape($data['title']) . "', first_mail = '" . (int)$data['first_mail'] . "', first_mail_duration = '" . (int)$data['first_mail_duration'] . "', next_mails = '" . (int)$data['next_mails'] . "', next_mail_duration = '" . (int)$data['next_mail_duration'] . "', maximum_mails = '" . (int)$data['maximum_mails'] . "', maximum_time = '" . (int)$data['maximum_time'] . "', maximum_time_duration = '" . (int)$data['maximum_time_duration'] . "', max_mail_per_day_per_email = '" . (int)$data['max_mail_per_day_per_email'] . "', discount = '" . (int)$data['discount'] . "', discount_type = '" . $this->db->escape($data['discount_type']) . "', amount = '" . (int)$data['amount'] . "', validity = '" . (int)$data['validity'] . "', discount_product = '" . (int)$data['discount_product'] . "', width = '" . $this->db->escape($data['width']) . "', height = '" . $this->db->escape($data['height']) . "'");
		
		$template_id = $this->db->getLastId();
		
		foreach ($data['template_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "xtensions_activity_mail_template_description SET template_id = '" . (int)$template_id . "', language_id = '" . (int)$language_id . "', subject_title = '" . $this->db->escape($value['subject']) . "', subject_description = '" . $this->db->escape($value['description']) . "', sms_body = '" . $this->db->escape($value['sms_body']) . "', sms_template_id = '" . $this->db->escape($value['sms_template_id']) . "'");
		}
		
		if(isset($data['cron_jobs_enable'])){
			foreach ($data['cron_jobs_enable'] as $store_id => $valuekey) {
				foreach ($valuekey as $key) {
					if(isset($data['cron_jobs'][$store_id][$key])){
						$this->db->query("INSERT INTO " . DB_PREFIX . "xtensions_activity_mail_to_cron SET template_id = '" . (int)$template_id . "', store_id = '" . (int)$store_id . "', sort_order = '" . (int)$key . "', value = '" . $this->db->escape($data['cron_jobs'][$store_id][$key]) . "'");
					}
				}	
			}
		}
		
		return $template_id;
	}

	public function editMailTemplate($template_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "xtensions_activity_mail_template SET shipping = '" . (int)$data['shipping'] . "', customer_login = '" . (int)$data['customer_login'] . "', status = '" . (int)$data['status'] . "', is_sms = '" . (int)$data['is_sms'] . "', title = '" . $this->db->escape($data['title']) . "', first_mail = '" . (int)$data['first_mail'] . "', first_mail_duration = '" . (int)$data['first_mail_duration'] . "', next_mails = '" . (int)$data['next_mails'] . "', next_mail_duration = '" . (int)$data['next_mail_duration'] . "', maximum_mails = '" . (int)$data['maximum_mails'] . "', maximum_time = '" . (int)$data['maximum_time'] . "', maximum_time_duration = '" . (int)$data['maximum_time_duration'] . "', max_mail_per_day_per_email = '" . (int)$data['max_mail_per_day_per_email'] . "', discount = '" . (int)$data['discount'] . "', discount_type = '" . $this->db->escape($data['discount_type']) . "', amount = '" . (int)$data['amount'] . "', validity = '" . (int)$data['validity'] . "', discount_product = '" . (int)$data['discount_product'] . "', width = '" . $this->db->escape($data['width']) . "', height = '" . $this->db->escape($data['height']) . "' WHERE template_id = '" . (int)$template_id . "'");
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_mail_template_description WHERE template_id = '" . (int)$template_id . "'");
		
		foreach ($data['template_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "xtensions_activity_mail_template_description SET template_id = '" . (int)$template_id . "', language_id = '" . (int)$language_id . "', subject_title = '" . $this->db->escape($value['subject']) . "', subject_description = '" . $this->db->escape($value['description']) . "', sms_body = '" . $this->db->escape($value['sms_body']) . "', sms_template_id = '" . $this->db->escape($value['sms_template_id']) . "'");
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_mail_to_cron WHERE template_id = '" . (int)$template_id . "'");
		
		if(isset($data['cron_jobs_enable'])){
			foreach ($data['cron_jobs_enable'] as $store_id => $valuekey) {
				foreach ($valuekey as $key) {
					if(isset($data['cron_jobs'][$store_id][$key])){
						$this->db->query("INSERT INTO " . DB_PREFIX . "xtensions_activity_mail_to_cron SET template_id = '" . (int)$template_id . "', store_id = '" . (int)$store_id . "', sort_order = '" . (int)$key . "', value = '" . $this->db->escape($data['cron_jobs'][$store_id][$key]) . "'");
					}
				}	
			}
		}
	}

	public function getCronJobs($template_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "xtensions_activity_mail_to_cron WHERE template_id = '" . (int)$template_id . "' ORDER BY sort_order ASC");
		$jobs = array();
		foreach ($query->rows as $result) {
			$jobs[$result['sort_order']][$result['store_id']] = $result['value'];
			$jobs[$result['sort_order']]['value'] = $result['value'];
		}
		return $jobs;
	}
	
	public function deleteMailTemplate($template_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_mail_template WHERE template_id = '" . (int)$template_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_to_mail WHERE template_id = '" . (int)$template_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_mail_to_cron WHERE template_id = '" . (int)$template_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_mail_template_description WHERE template_id = '" . (int)$template_id . "'");
	}

	public function getMailTemplate($template_id) {
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "xtensions_activity_mail_template xamt WHERE xamt.template_id = '" . (int)$template_id . "'");
		if($query->num_rows){
			$data = $query->row;
			$query = $this->db->query("SELECT  xamtd.*, l.code FROM " . DB_PREFIX . "xtensions_activity_mail_template_description xamtd  LEFT JOIN `" . DB_PREFIX . "language` l ON xamtd.`language_id` = l.`language_id` WHERE xamtd.template_id = '" . (int)$template_id . "'");
			$language =  array();
			foreach ($query->rows as $row){
				if($row['code']){
					$language[$row['code']] = $row;
				}
			}
			$data = array_merge($data,array('language'=>$language));
			return $data;
		}
		return array();
	}

	public function getMailTemplates() {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "xtensions_activity_mail_template d LEFT JOIN " . DB_PREFIX . "xtensions_activity_mail_template_description dd ON (d.template_id = dd.template_id) WHERE dd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY dd.template_id DESC");
		return $query->rows;
	}

	public function getMailStatusTemplates() {		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "xtensions_activity_mail_template WHERE `status` = '1' ORDER BY title ");
		return $query->rows;
	}

	public function getMailTemplateDescriptions($template_id) {
		$template_description_data = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "xtensions_activity_mail_template_description WHERE template_id = '" . (int)$template_id . "'");
		
		foreach ($query->rows as $result) {
			$template_description_data[$result['language_id']] = array(
				'subject' => $result['subject_title'],
				'description' => $result['subject_description'],
				'sms_body' => $result['sms_body'],
				'sms_template_id' => $result['sms_template_id'],
			);
		}
		
		return $template_description_data;
	}

	public function getTotalXmailTemplates() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "xtensions_activity_mail_template_description WHERE language_id = '" . (int)$this->config->get('config_language_id') . "'");
		return $query->row['total'];
	}	
	
	public function getRemindersByActivity($activity_code){
		$query = $this->db->query("SELECT xatm.*, c.coupon_id, xamt.template_id, xamt.title AS template FROM `" . DB_PREFIX . "xtensions_activity_to_mail` xatm LEFT OUTER JOIN `" . DB_PREFIX . "xtensions_activity_mail_template` xamt ON xatm.template_id = xamt.template_id LEFT OUTER JOIN " . DB_PREFIX . "coupon c ON xatm.coupon_id = c.coupon_id WHERE xatm.activity_session_code = '" . $this->db->escape($activity_code) . "' ORDER BY xatm.date_added DESC");
		
		return $query->rows;
	}
	
	public function getRemindersByActivitySMS($activity_code){
		$query = $this->db->query("SELECT xatm.*, c.coupon_id, xamt.template_id, xamt.title AS template FROM `" . DB_PREFIX . "xtensions_activity_to_telephone` xatm LEFT OUTER JOIN `" . DB_PREFIX . "xtensions_activity_mail_template` xamt ON xatm.template_id = xamt.template_id LEFT OUTER JOIN " . DB_PREFIX . "coupon c ON xatm.coupon_id = c.coupon_id WHERE xatm.activity_session_code = '" . $this->db->escape($activity_code) . "' ORDER BY xatm.date_added DESC");
		
		return $query->rows;
	}
	
	public function generateCouponCode() {
		$coupon = token(10);
		$coupon_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "coupon` WHERE code='" . $this->db->escape($coupon) . "'");
			
		if ($coupon_query->num_rows) {
			return $this->generateCouponCode();
		}else{
			return $coupon;
		}
	}
	
	public function deleteUnsubscibedActivity(){
		$query = $this->db->query("SELECT activity_session_code FROM `" . DB_PREFIX . "xtensions_activity_order` WHERE `unsubscribe` = 1");
		foreach ($query->rows as $row){
			$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_to_mail WHERE `activity_session_code` = '" . $this->db->escape($row['activity_session_code']) . "'");
			$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_step_by_step WHERE `activity_session_code` = '" . $this->db->escape($row['activity_session_code']) . "'");
			$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_order WHERE `activity_session_code` = '" . $this->db->escape($row['activity_session_code']) . "'");
		}
		return array('success' => $this->language->get('success_unsubscribed_deleted'));
	}
	
	public function deleteAllActivities(){
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_to_mail");
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_step_by_step");
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_order");
		return array('success' => $this->language->get('success_activities_deleted'));
	}

	public function deleteExpiredCoupons(){
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "coupon` WHERE `date_end` < now()");
		foreach ($query->rows as $row){
			$this->db->query("DELETE FROM `" . DB_PREFIX . "coupon_category` WHERE `coupon_id` = '" . $row['coupon_id'] . "'");
			$this->db->query("DELETE FROM `" . DB_PREFIX . "coupon_product` WHERE `coupon_id` = '" . $row['coupon_id'] . "'");
			$this->db->query("DELETE FROM `" . DB_PREFIX . "coupon` WHERE `coupon_id` = '" . $row['coupon_id'] . "'");
		}
		return array('success' => $this->language->get('success_coupons_deleted'));
	}
	
	public function getMailsSent(){
		$query = $this->db->query("SELECT count(*) as total FROM `" . DB_PREFIX . "xtensions_activity_to_mail`");
		return $query->row['total'];
	}
	
	public function getSMSSent(){
		$query = $this->db->query("SELECT count(*) as total FROM `" . DB_PREFIX . "xtensions_activity_to_telephone`");
		return $query->row['total'];
	}
	
	public function getMailsOpened(){
		$query = $this->db->query("SELECT count(*) as total FROM `" . DB_PREFIX . "xtensions_activity_to_mail` WHERE opened > 0");
		return $query->row['total'];
	}
	
	public function getSMSClicked(){
		$query = $this->db->query("SELECT count(*) as total FROM `" . DB_PREFIX . "xtensions_activity_to_telephone` WHERE clicked > 0");
		return $query->row['total'];
	}
	
	public function getAllActivities($data=array()){
		$sql = "SELECT count(*) as total FROM `" . DB_PREFIX . "xtensions_activity_order` xao";
		if(!empty($data)){
			$sql .= $this->makeFilter($data);
		}
		$query = $this->db->query($sql);
		return $query->row['total'];
	}
	
	public function getUnsubscribedActivities(){
		$query = $this->db->query("SELECT count(*) as total FROM `" . DB_PREFIX . "xtensions_activity_order` WHERE `unsubscribe` = 1");
		return $query->row['total'];
	}
	
	public function getTotalCouponsExpired(){
		$query = $this->db->query("SELECT count(*) as total FROM `" . DB_PREFIX . "coupon` WHERE `date_end` < now()");
		return $query->row['total'];
	}
	
	public function getTotalCouponsSent(){
		$query = $this->db->query("SELECT count(DISTINCT coupon_id) as total FROM  `" . DB_PREFIX . "xtensions_activity_to_mail`");
		return $query->row['total'];
	}
	
	public function getTotalCouponsUsed(){
		$query = $this->db->query("SELECT count(DISTINCT(ch.coupon_id)) as total FROM `" . DB_PREFIX . "coupon_history` ch JOIN  `" . DB_PREFIX . "xtensions_activity_to_mail` xatm ON ch.`coupon_id` = xatm.`coupon_id`");
		return $query->row['total'];
	}
	
	public function getTotalCouponsSales(){
		$query = $this->db->query("SELECT sum(o.total) AS sales FROM `" . DB_PREFIX . "coupon_history` ch JOIN  `" . DB_PREFIX . "xtensions_activity_to_mail` xatm ON ch.`coupon_id` = xatm.`coupon_id` JOIN `" . DB_PREFIX . "order` o ON ch.order_id = o.order_id AND o.order_status_id <> ''");		
		return $query->row['sales']==null?0:$query->row['sales'];		
	}
	
	public function getTotalUnsubscribedPermanently($email = '') {
		$sql = "SELECT count(*) as total  FROM `" . DB_PREFIX . "xtensions_activity_unsubscription`";
		if($email){
			$sql .= " WHERE email = '" . $this->db->escape($email) . "'";
		}
		$query = $this->db->query($sql);
		return $query->row['total'];
	}
	
	public function getSentCoupon($activity_code,$template_id){
		$query = $this->db->query("SELECT c.* FROM `" . DB_PREFIX . "coupon` c JOIN `" . DB_PREFIX . "xtensions_activity_to_mail` xatm ON c.`coupon_id` = xatm.`coupon_id` WHERE `activity_session_code` = '" . $this->db->escape($activity_code) . "' AND `template_id` = '" . (int)$template_id . "' AND xatm.coupon_id <> '0' ORDER BY xatm.`date_added` DESC LIMIT 1");
		if($query->num_rows){
			return $query->row;
		}
		return array();
	}
	
	public function getSentCouponSMS($activity_code,$template_id){
		$query = $this->db->query("SELECT c.* FROM `" . DB_PREFIX . "coupon` c JOIN `" . DB_PREFIX . "xtensions_activity_to_telephone` xatm ON c.`coupon_id` = xatm.`coupon_id` WHERE `activity_session_code` = '" . $this->db->escape($activity_code) . "' AND `template_id` = '" . (int)$template_id . "' AND xatm.coupon_id <> '0' ORDER BY xatm.`date_added` DESC LIMIT 1");
		if($query->num_rows){
			return $query->row;
		}
		return array();
	}
	
	public function addCoupon($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "coupon SET name = '" . $this->db->escape($data['name']) . "', code = '" . $this->db->escape($data['code']) . "', discount = '" . (float)$data['discount'] . "', type = '" . $this->db->escape($data['type']) . "', total = '" . (float)$data['total'] . "', logged = '" . (int)$data['logged'] . "', shipping = '" . (int)$data['shipping'] . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "', uses_total = '" . (int)$data['uses_total'] . "', uses_customer = '" . (int)$data['uses_customer'] . "', status = '" . (int)$data['status'] . "', date_added = NOW()");

		$coupon_id = $this->db->getLastId();

		if (isset($data['coupon_product'])) {
			foreach ($data['coupon_product'] as $product_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "coupon_product SET coupon_id = '" . (int)$coupon_id . "', product_id = '" . (int)$product_id . "'");
			}
		}	
		if(file_exists(DIR_CONFIG.'xtensions/xlcoupon.php')){
			$check_table = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "xlcoupon'");
			if($check_table->num_rows){
				$this->db->query("SET SQL_MODE = ''");
				$this->db->query("INSERT INTO " . DB_PREFIX . "xlcoupon SET coupon_id = '" . (int)$coupon_id . "', display_checkout_list = 1, email = '" . $this->db->escape($data['email']) . "'");				
			}
			$check_table = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "xlcoupon_description'");
			if($check_table->num_rows){
				$this->load->model('localisation/language');		
				foreach ($this->model_localisation_language->getLanguages() as $language){
					$this->db->query("SET SQL_MODE = ''");
					$this->db->query("INSERT INTO " . DB_PREFIX . "xlcoupon_description SET coupon_id = '" . (int)$coupon_id . "', language_id = '" . (int)$language['language_id'] . "'");
				}
			}
		}
		return $coupon_id;
	}
	
	public function sms($data) {		
		if(file_exists(DIR_CONFIG.'xtensions/xsmspro.php')){
			$this->load->config('xtensions/xsmspro');
			$required_fields = array('country_code','full_telephone','telephone','channel','sms','event','sms_template_id');
			$fields = array();
			foreach ($required_fields as $key){
				if(isset($data[$key]) && $data[$key]){
					$fields[$key] = $data[$key];
				}else{
					$fields[$key] = $key == 'channel'?'trasactional':'';
				}
			}						
			if(isset($fields['country_code'])){
				$ccs = $this->config->get($this->config->get('xsmspro_config_pfx').'country_code');
				if(trim($ccs)){
					$country_codes = explode(',', $ccs);
					if(!in_array($fields['country_code'], $country_codes)){
						return array('error'=>'SMS can not be sent to this country code!','country_code_not_permitted'=>true);
					}
				}
			}			
			$telephone = $fields['telephone'];
			$country_code = $fields['country_code']?str_replace('+', '', $fields['country_code']):'';
			require_once DIR_SYSTEM.'library/xtensions/xtensionssms.php';
			$platform = new XtensionsSms($this->registry);
			$channel = $this->config->get($this->config->get('xsmspro_config_pfx').$fields['channel'].'_channel');		
			$platform->setAdaptor($this->config->get($this->config->get('xsmspro_config_pfx').'gateway_'.$channel));
			$platform->setChannel($channel);
			$pd = $this->config->get($this->config->get('xsmspro_config_pfx').'gateway_'.$channel.'_param');
			$param_data = $pd[$this->config->get($this->config->get('xsmspro_config_pfx').'gateway_'.$channel)];
			if(isset($fields['sms_template_id']) && $fields['sms_template_id'] && isset($fields['event']) && $fields['event'] && !isset($param_data[$fields['event'].'_template_id'])){
				$param_data[$fields['event'].'_template_id'] = $fields['sms_template_id'];
			}
			if($platform->action('send',array('number'=>$telephone,'country_code'=>$country_code,'params'=>$param_data,'message'=>$fields['sms'],'event'=>$fields['event'],'otp'=>''))){
				return array('success'=> true);
			}else{
				array('error'=>'SMS could not be sent. Check logs!');
			}
			 
		}
		return array('error'=>'SMS plugin is not installed!');
	}
	
	public function mail($data = array()) {
		$this->load->model('setting/setting');
		$store_config_data = $this->model_setting_setting->getSetting('config', $data['store_id']);
		$config_data = $this->model_setting_setting->getSetting($data['setting_name'], $data['store_id']);
		if(!isset($config_data[$data['config_pfx'].'different_mail']) || (isset($config_data[$data['config_pfx'].'different_mail']) && !$config_data[$data['config_pfx'].'different_mail'])){
			if (version_compare(VERSION, '3.0.0.0') >= 0) {
				$mail = new Mail($this->config->get('config_mail_engine'));
			} else {
				$mail = new Mail();
				$mail->protocol = $this->config->get('config_mail_protocol');
			}
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
			$mail->smtp_username = $this->config->get('config_mail_smtp_username');
			$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
			$mail->smtp_port = $this->config->get('config_mail_smtp_port');
			$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
			$mail->setFrom($store_config_data['config_email']);
		}else{
			if (version_compare(VERSION, '3.0.0.0') >= 0) {
				$mail = new Mail($config_data[$data['config_pfx'].'mail']['protocol']);
			} else {
				$mail = new Mail();
				$mail->protocol = $config_data[$data['config_pfx'].'mail']['protocol'];
			}
			$mail->parameter = $config_data[$data['config_pfx'].'mail']['parameter'];
			$mail->smtp_hostname = $config_data[$data['config_pfx'].'mail']['hostname'];
			$mail->smtp_username = $config_data[$data['config_pfx'].'mail']['username'];
			$mail->smtp_password = html_entity_decode($config_data[$data['config_pfx'].'mail']['password'], ENT_QUOTES, 'UTF-8');
			$mail->smtp_port = $config_data[$data['config_pfx'].'mail']['port'];
			$mail->smtp_timeout = $config_data[$data['config_pfx'].'mail']['timeout'];
			$mail->setFrom($config_data[$data['config_pfx'].'mail']['email']);
		}
		$mail->setTo($data['email']);		
		$mail->setSender(html_entity_decode($data['store_name'], ENT_QUOTES, 'UTF-8'));
		$mail->setSubject(html_entity_decode($data['subject'], ENT_QUOTES, 'UTF-8'));
		$mail->setHtml($data['message']);
		$mail->send();
		
		if ($mail){
			return true;			
		}
		return false;
	}
	
	public function editCoupon($coupon_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "coupon SET name = '" . $this->db->escape($data['name']) . "', discount = '" . (float)$data['discount'] . "', type = '" . $this->db->escape($data['type']) . "', total = '" . (float)$data['total'] . "', logged = '" . (int)$data['logged'] . "', shipping = '" . (int)$data['shipping'] . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "', uses_total = '" . (int)$data['uses_total'] . "', uses_customer = '" . (int)$data['uses_customer'] . "', status = '" . (int)$data['status'] . "', date_added = NOW() WHERE coupon_id = '" . (int)$coupon_id . "'" );

		$this->db->query("DELETE FROM " . DB_PREFIX . "coupon_product WHERE coupon_id = '" . (int)$coupon_id . "'");

		if (isset($data['coupon_product'])) {
			foreach ($data['coupon_product'] as $product_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "coupon_product SET coupon_id = '" . (int)$coupon_id . "', product_id = '" . (int)$product_id . "'");
			}
		}
		
		if(file_exists(DIR_CONFIG.'xtensions/xlcoupon.php')){
			$check_table = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "xlcoupon'");
			if($check_table->num_rows){
				$this->db->query("DELETE FROM " . DB_PREFIX . "xlcoupon WHERE coupon_id = '" . (int)$coupon_id . "'");
				$this->db->query("SET SQL_MODE = ''");
				$this->db->query("INSERT INTO " . DB_PREFIX . "xlcoupon SET coupon_id = '" . (int)$coupon_id . "', display_checkout_list = 1, email = '" . $this->db->escape($data['email']) . "'");				
			}
			$check_table = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "xlcoupon_description'");
			if($check_table->num_rows){
				$this->db->query("DELETE FROM " . DB_PREFIX . "xlcoupon_description WHERE coupon_id = '" . (int)$coupon_id . "'");
				$this->load->model('localisation/language');		
				foreach ($this->model_localisation_language->getLanguages() as $language){
					$this->db->query("SET SQL_MODE = ''");
					$this->db->query("INSERT INTO " . DB_PREFIX . "xlcoupon_description SET coupon_id = '" . (int)$coupon_id . "', language_id = '" . (int)$language['language_id'] . "'");
				}
			}
		}

		return $coupon_id;
	}
	
	public function getDeleteCronJob(){
		$data = array('days'=>15,'criteria'=>'blank','status'=>0,'job'=>'0 7 * * *','delete_cron_status'=>0);
		$query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "xtensions_activity_extras` WHERE `key` = 'delete_cron_status' LIMIT 1");
		if($query->num_rows){
			$data['delete_cron_status'] = $query->row['value'];
		}
		$query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "xtensions_activity_extras` WHERE `key` = 'delete_cron' LIMIT 1");
		if($query->num_rows){
			$data = array_merge($data,json_decode($query->row['value'], true));
		}
		return $data;
	}
	
	public function saveDeleteCronJob($data){
		$this->db->query("DELETE FROM `" . DB_PREFIX . "xtensions_activity_extras` WHERE `key` = 'delete_cron'");
		$this->db->query("DELETE FROM `" . DB_PREFIX . "xtensions_activity_extras` WHERE `key` = 'delete_cron_status'");
		if(isset($data['delete_cron']['status'])){
			$this->db->query("INSERT INTO " . DB_PREFIX . "xtensions_activity_extras SET store_id = '0', `key` = 'delete_cron_status', `value` = '1', serialized = '0'");
		}else{
			$this->db->query("INSERT INTO " . DB_PREFIX . "xtensions_activity_extras SET store_id = '0', `key` = 'delete_cron_status', `value` = '0', serialized = '0'");
		}
		$this->db->query("INSERT INTO " . DB_PREFIX . "xtensions_activity_extras SET store_id = '0', `key` = 'delete_cron', `value` = '" . $this->db->escape(json_encode($data['delete_cron'], true)) . "', serialized = '1'");
	}
	
	public function install() {
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_order` (
						  `activity_session_code` varchar(64) NOT NULL,
						  `order_id` int(11) DEFAULT '0',
						  `firstname` varchar(32) NOT NULL,
						  `lastname` varchar(32) NOT NULL,
						  `name` varchar(96) NOT NULL,
						  `email` varchar(96) NOT NULL,
						  `telephone` varchar(32) NOT NULL DEFAULT '',
						  `cart` text,
						  `last_step` tinyint(3) NOT NULL,
						  `currency_code` varchar(3) NOT NULL,
						  `language_code` varchar(5) NOT NULL,
						  `order_total` varchar(32) NOT NULL DEFAULT '',
						  `date_added` datetime NOT NULL,
						  `customer_id` int(11) NOT NULL DEFAULT '0',
						  `ip` varchar(40) NOT NULL,
						  `store_id` int(11) NOT NULL DEFAULT '0',
						  `store_name` varchar(255) NOT NULL DEFAULT '',
						  `store_url` varchar(255) NOT NULL DEFAULT '',
						  `totals` text,
						  `payment_method` varchar(128) NOT NULL,
						  `shipping_method` varchar(128) NOT NULL,
						  `user_agent` varchar(255) NOT NULL,
						  `payment_address` text NOT NULL,
						  `shipping_address` text NOT NULL,
						  `last_mail_sent` datetime NOT NULL,
						  `unsubscribe` tinyint(1) NOT NULL DEFAULT '0',
						  `page` text,
						  PRIMARY KEY (`activity_session_code`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_step_by_step` (
						  `xcustomer_activity_id` int(11) NOT NULL AUTO_INCREMENT,
						  `customer_id` int(11) NOT NULL,
						  `key` varchar(64) NOT NULL,
						  `data` text NOT NULL,
						  `ip` varchar(40) NOT NULL,
						  `page` text,
						  `date_added` datetime NOT NULL,
						  `activity_session_code` varchar(64) NOT NULL,
						  `referer` text,
						  PRIMARY KEY (`xcustomer_activity_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_mail_template` (
						  `template_id` int(11) NOT NULL AUTO_INCREMENT,
						  `status` tinyint(1) NOT NULL,
						  `title` varchar(225) NOT NULL,
						  `first_mail` int(11) NOT NULL,
						  `next_mails` int(11) NOT NULL,
						  `maximum_mails` int(11) NOT NULL,
						  `first_mail_duration` int(11) NOT NULL,
						  `next_mail_duration` int(11) NOT NULL,
						  `shipping` tinyint(1) NOT NULL,
						  `customer_login` tinyint(1) NOT NULL,
						  `discount_type` char(1) NOT NULL,
						  `discount` int(11) NOT NULL,
						  `amount` int(11) NOT NULL,
						  `validity` int(11) NOT NULL,
						  `discount_product` tinyint(1) NOT NULL,
						  `width` int(11) NOT NULL,
						  `height` int(11) NOT NULL,
						  PRIMARY KEY (`template_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_mail_template_description` (
						  `template_id` int(11) NOT NULL,
						  `language_id` int(11) NOT NULL,
						  `subject_title` varchar(255) NOT NULL,
						  `subject_description` text NOT NULL,
						  PRIMARY KEY (`template_id`,`language_id`),
						  KEY `subject_title` (`subject_title`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_mail_to_cron` (
						  `template_cron_id` int(11) NOT NULL AUTO_INCREMENT,
						  `template_id` int(11) NOT NULL,
						  `sort_order` int(3) NOT NULL DEFAULT '0',
						  `value` varchar(64) DEFAULT NULL,
						  `store_id` int(11) NOT NULL DEFAULT '0',
						  PRIMARY KEY (`template_cron_id`),
						  KEY `template_id` (`template_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_to_mail` (
						  `activity_mail_id` int(11) NOT NULL AUTO_INCREMENT,
						  `activity_session_code` varchar(64) NOT NULL,
						  `template_id` int(11) NOT NULL,
						  `coupon_id` int(11) NOT NULL DEFAULT '0',
						  `coupon_code` varchar(20) NOT NULL,
						  `opened` int(11) NOT NULL DEFAULT '0',
						  `date_added` datetime NOT NULL,
						  PRIMARY KEY (`activity_mail_id`),
						  KEY `activity_session_code` (`activity_session_code`),
						  KEY `template_id` (`template_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_unsubscription` (
						  `email_id` int(11) NOT NULL AUTO_INCREMENT,
						  `email` varchar(96) NOT NULL,
						  `date_added` datetime NOT NULL,
						  PRIMARY KEY (`email_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_extras` (
						  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
						  `store_id` INT(11) NOT NULL DEFAULT '0',
						  `key` VARCHAR(64) NOT NULL,
						  `value` LONGTEXT NOT NULL,
						  `serialized` TINYINT(4) NOT NULL,
						  PRIMARY KEY (`setting_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_daily_email` (
						  `activity_mail_id` int(11) NOT NULL AUTO_INCREMENT,
						  `activity_session_code` varchar(64) NOT NULL,
						  `store_id` int(11) NOT NULL,
						  `email` varchar(96) NOT NULL,
						  `template_id` int(11) NOT NULL,
						  `date_added` datetime NOT NULL,
						  PRIMARY KEY (`activity_mail_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_daily_telephone` (
						  `activity_mail_id` INT(11) NOT NULL AUTO_INCREMENT,
						  `activity_session_code` VARCHAR(64) NOT NULL,
						  `store_id` INT(11) NOT NULL,
						  `telephone` VARCHAR(96) NOT NULL,
						  `country_code` VARCHAR(10) NOT NULL,
						  `full_telephone` VARCHAR(40) NOT NULL,
						  `template_id` INT(11) NOT NULL,
						  `date_added` DATETIME NOT NULL,
						  PRIMARY KEY (`activity_mail_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_to_telephone` (
						  `activity_mail_id` int(11) NOT NULL AUTO_INCREMENT,
						  `activity_session_code` varchar(64) NOT NULL,
						  `template_id` int(11) NOT NULL,
						  `coupon_id` int(11) NOT NULL DEFAULT '0',
						  `coupon_code` varchar(20) NOT NULL,
						  `date_added` datetime NOT NULL,
						  `clicked` int(11) NOT NULL DEFAULT '0',
						  PRIMARY KEY (`activity_mail_id`),
						  KEY `activity_session_code` (`activity_session_code`),
						  KEY `template_id` (`template_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->upgrade();
	}
	
	public function upgrade(){	
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_order' AND COLUMN_NAME = 'date_modified'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_order` ADD COLUMN (`date_modified` datetime NOT NULL)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_order' AND COLUMN_NAME = 'referer'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_order` ADD COLUMN (`referer` TEXT)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_mail_template' AND COLUMN_NAME = 'maximum_time'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_mail_template` ADD COLUMN (`maximum_time` INT(11) NOT NULL)");
		}	
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_mail_template' AND COLUMN_NAME = 'maximum_time_duration'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_mail_template` ADD COLUMN (`maximum_time_duration` INT(11) NOT NULL)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_mail_template' AND COLUMN_NAME = 'max_mail_per_day_per_email'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_mail_template` ADD COLUMN (`max_mail_per_day_per_email` INT(11) NOT NULL DEFAULT 1)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_order' AND COLUMN_NAME = 'country_code'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_order` ADD COLUMN (`country_code` varchar(10) NOT NULL)");
		}		
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_order' AND COLUMN_NAME = 'full_telephone'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_order` ADD COLUMN (`full_telephone` varchar(40) NOT NULL)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_mail_template' AND COLUMN_NAME = 'is_sms'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_mail_template` ADD COLUMN (`is_sms` tinyint(1) NOT NULL)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_mail_template_description' AND COLUMN_NAME = 'sms_body'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_mail_template_description` ADD COLUMN (`sms_body` text NOT NULL)");
		}		
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_mail_template_description' AND COLUMN_NAME = 'sms_template_id'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_mail_template_description` ADD COLUMN (`sms_template_id` VARCHAR(128) NOT NULL)");
		}
	}
}
