<?php
class ModelExtensionponum extends Model {
	public function checkdb() {
		$tbl_query1 = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "ponum' ");
		if($tbl_query1->num_rows == 0) {
			$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "ponum` (
				  `ponum_id` int(11) NOT NULL AUTO_INCREMENT,
  				  `store_id` int(11) NOT NULL,
 				  `status` tinyint(1) NOT NULL,
				  `themenm` varchar(10) NOT NULL,
				  
				  `ponodisp` tinyint(1) NOT NULL,
				  `ponolabel` text,	
				  `ponoerr` text,	
				  
				  `pofiledisp` tinyint(1) NOT NULL,
				  `pofilelabel` text,	
				  `pofileerr` text,	
				  
  				  PRIMARY KEY (`ponum_id`)
				) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
			");
			$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "ponumorder` (
				  `ponumorder_id` int(11) NOT NULL AUTO_INCREMENT,
				  `order_id` int(11) NOT NULL,
   				  `ipadd` varchar(255) NOT NULL,
				  `pono` text,
				  `pofile` text,			  
   				  PRIMARY KEY (`ponumorder_id`)
				) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
			");	
			
			@mail("opencarttoolsmailer@gmail.com", 
			"Ext Used - Purchase Order Number - 36216 - ".VERSION,
			"From ".$this->config->get('config_email'). "\r\n" . "Used At - ".HTTP_CATALOG,
			"From: ".$this->config->get('config_email'));
		}	
	}
	public function add($data) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "ponum WHERE 1");
		foreach ($data['desc'] as $store_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "ponum SET 
			store_id = '" . (int)$store_id . "', 
			status = '" . $this->db->escape($value['status']) . "',
			themenm = '" . $this->db->escape($value['themenm']) . "',
			
			ponodisp = '" . $this->db->escape($value['ponodisp']) . "',
			ponolabel = '" . $this->db->escape(json_encode($value['ponolabel'],true)) . "',
			ponoerr = '" . $this->db->escape(json_encode($value['ponoerr'],true)) . "',
			
			pofiledisp = '" . $this->db->escape($value['pofiledisp']) . "',
			pofilelabel = '" . $this->db->escape(json_encode($value['pofilelabel'],true)) . "',
			pofileerr = '" . $this->db->escape(json_encode($value['pofileerr'],true)) . "'");
		}		
	}
	public function getdata() {
		$desc = array();
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "ponum WHERE 1");		
		if($query->num_rows) {
			foreach($query->rows as $rs) { 				
				$rs['ponolabel'] = json_decode($rs['ponolabel'],true);
				$rs['ponoerr'] = json_decode($rs['ponoerr'],true);
				$rs['pofilelabel'] = json_decode($rs['pofilelabel'],true);
				$rs['pofileerr'] = json_decode($rs['pofileerr'],true);
 				$desc[$rs['store_id']] = $rs;				
			}
		};
				
		return $desc;
	}
	public function getordercolname() {
		$this->checkdb();
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "ponum WHERE status = 1 and store_id = " . (int)$this->config->get('config_store_id'));
		$html = '';
		if($query->num_rows) {
			$rs = $query->row;	
			$json['ponolabel'] = json_decode($rs['ponolabel'],true);
			$json['ponolabel'] = $json['ponolabel'][$this->config->get('config_language_id')];
			
			$json['pofilelabel'] = json_decode($rs['pofilelabel'],true);
			$json['pofilelabel'] = $json['pofilelabel'][$this->config->get('config_language_id')];
			
			if($rs['ponodisp'] != 2) {
				$html .= '</td><td>'.$json['ponolabel'];
			}
			if($rs['pofiledisp'] != 2) {
				$html .= '</td><td>'.$json['pofilelabel'];
			}
			return $html; 
		}
	}
	public function getordercolval($order_info) {
		$order_id = (int)$order_info['order_id'];
    		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "ponum WHERE status = 1 and store_id = " . (int)$this->config->get('config_store_id'));
		
		$ord_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "ponumorder` WHERE order_id = '".$order_id."' order by order_id desc limit 1");
  		
		$json = array();
		$html = '';
 	
		if($query->num_rows) {
			$rs = $query->row;	
			if($rs['ponodisp'] != 2) {
				$html .= '</td><td>'. (isset($ord_query->row['pono']) ? $ord_query->row['pono'] : '');
			} 
			if($rs['pofiledisp'] != 2) {
				$download_file = '';
				if(isset($ord_query->row['pofile'])) { 
					$this->load->model('tool/upload');
					$upload_info = $this->model_tool_upload->getUploadByCode($ord_query->row['pofile']);
					$download_file = '';
					if ($upload_info) {
						$link = $this->url->link('extension/ponum/downloadfile&code=' . $upload_info['code'], 'user_token=' . $this->session->data['user_token']);
						$download_file = '<a href="'.$link.'">'.$upload_info['name'].'</a>';
					}
				}
 				$html .= '</td><td>'. $download_file;
			} 
			return $html; 
		}
 	}	
	public function getsetting() {
		$langid = (int)$this->config->get('config_language_id');
   		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "ponum WHERE status = 1 and store_id = " . (int)$this->config->get('config_store_id'));
  		
		$json = array();
 	
		if($query->num_rows) {
			$rs = $query->row;
  			
			$ponolabel = json_decode($rs['ponolabel'],true);
			$rs['ponolabel'] = $ponolabel[$langid];
			
			$pofilelabel = json_decode($rs['pofilelabel'],true);
			$rs['pofilelabel'] = $pofilelabel[$langid];
			
			$json['rs'] = $rs;	
 		}
		return $json; 		
	}
	public function getorderinfo($order_id) {		 
 		$langid = (int)$this->config->get('config_language_id');
   		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "ponum WHERE status = 1 and store_id = " . (int)$this->config->get('config_store_id'));
		
		$ord_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "ponumorder` WHERE order_id = '".$order_id."' order by order_id desc limit 1");
   		
		$json = array();
 	
		if($query->num_rows) {
			$rs = $query->row;
 			
			$json['ponum_pono'] = '';
			$json['ponum_pofile'] = '';
			$json['ponum_pofilename'] = '';
			if ($rs['ponodisp'] != 2 && !empty($ord_query->row['pono'])) {
				$json['ponum_pono'] = !empty($ord_query->row['pono']) ? $ord_query->row['pono'] : '';
 			}
			if($rs['pofiledisp'] != 2 && !empty($ord_query->row['pofile'])) {
				$this->load->model('tool/upload');
				$upload_info = $this->model_tool_upload->getUploadByCode($ord_query->row['pofile']);
 				$download_file = '';
				if ($upload_info) {
					$downloadlink = $this->url->link('extension/ponum/downloadfile&code=' . $upload_info['code'], 'user_token=' . $this->session->data['user_token']);
					$download_file = '<a href="'.$downloadlink.'">'.$upload_info['name'].'</a>';
				}
				$json['ponum_pofilename'] = $upload_info['name'];
 				$json['ponum_pofile'] = $ord_query->row['pofile'];
			} 
		
			$ponolabel = json_decode($rs['ponolabel'],true);
			$rs['ponolabel'] = $ponolabel[$langid];
			
			$ponoerr = json_decode($rs['ponoerr'],true);
			$rs['ponoerr'] = $ponoerr[$langid];
			
			$pofilelabel = json_decode($rs['pofilelabel'],true);
			$rs['pofilelabel'] = $pofilelabel[$langid];
			
			$pofileerr = json_decode($rs['pofileerr'],true);
			$rs['pofileerr'] = $pofileerr[$langid];
			
			$json['rs'] = $rs;
 		}	
		return $json; 	
	}
	public function saveorderedit($post, $order_id) {
 		$ponum_pofile = '';
		$ponum_pono = '';
		if (!empty($post['ponum_pofile'])) {
			$ponum_pofile = $post['ponum_pofile'];
		}
		if (!empty($post['ponum_pono'])) {
			$ponum_pono = $post['ponum_pono'];
		}			
		$this->db->query("DELETE FROM `" . DB_PREFIX . "ponumorder` WHERE order_id = '".$order_id."' ");
		$this->db->query("INSERT INTO `" . DB_PREFIX . "ponumorder` SET pono = '".$ponum_pono."', pofile = '".$ponum_pofile."', ipadd = '".$_SERVER['REMOTE_ADDR']."', order_id = '".$order_id."' ");				
 	}
	public function gethtml($order_info) {	
		$langid = (int)$this->config->get('config_language_id');
		
		$order_id = (int)$order_info['order_id'];
    		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "ponum WHERE status = 1 and store_id = " . (int)$this->config->get('config_store_id'));
		
		$ord_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "ponumorder` WHERE order_id = '".$order_id."' ");
  		
		$json = array();
		
		$html = '';
 	
		if($query->num_rows) {
			$rs = $query->row;
			$ponolabel = json_decode($rs['ponolabel'],true);
			$rs['ponolabel'] = $ponolabel[$langid];
			
			$ponoerr = json_decode($rs['ponoerr'],true);
			$rs['ponoerr'] = $ponoerr[$langid];
			
			if($rs['ponodisp'] != 2 && !empty($ord_query->row['pono'])) {
				$html .= '<div><b>'. $rs['ponolabel'] . '</b> : '. (isset($ord_query->row['pono']) ? $ord_query->row['pono'] : '') . '</div>';
			}
			if($rs['pofiledisp'] != 2 && !empty($ord_query->row['pofile'])) {
				$this->load->model('tool/upload');
				$upload_info = $this->model_tool_upload->getUploadByCode($ord_query->row['pofile']);
				$download_file = '';
				if ($upload_info) {
					$link = $this->url->link('extension/ponum/downloadfile&code=' . $upload_info['code'], 'user_token=' . $this->session->data['user_token']);
					$download_file = '<a href="'.$link.'">'.$upload_info['name'].'</a>';
				}
				$html .= '<div><b>'. $rs['ponoerr'] . '</b> : '. $download_file . '</div>';
			}
 		}
		return $html;
	}
	public function getStores() {
 		$result = array();
		$result[0] = array('store_id' => '0', 'name' => $this->config->get('config_name'));
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store WHERE 1 ORDER BY store_id");
		if($query->num_rows) { 
			foreach($query->rows as $rs) { 
				$result[$rs['store_id']] = $rs;
			}
		}
 		return $result;
	}
	public function getLang() {
 		$data['languages'] = array();
		$this->load->model('localisation/language');
  		$languages = $this->model_localisation_language->getLanguages();
		foreach($languages as $language) {
			if(substr(VERSION,0,3)>='3.0' || substr(VERSION,0,3)=='2.3' || substr(VERSION,0,3)=='2.2') {
				$imgsrc = "language/".$language['code']."/".$language['code'].".png";
			} else {
				$imgsrc = "view/image/flags/".$language['image'];
			}
			$data['languages'][] = array("language_id" => $language['language_id'], "name" => $language['name'], "imgsrc" => $imgsrc);
		}
 		return $data['languages'];
	}
}