var ponum = {	
	'geturlparam': function(name) {
		var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.href);
	    return (results) ? results[1] || 0 : '';
	},
	'saveorderedit': function() {
		user_token = ponum.geturlparam('user_token');
		order_id = decodeURIComponent(ponum.geturlparam('order_id'));
		$.ajax({
			url: 'index.php?route=extension/ponum/saveorderedit&user_token='+user_token+'&order_id=' + order_id,
			type: 'post',
			data: $('input[name*="ponum_pono"], input[name*="ponum_pofilename"], input[name*="ponum_pofile"]'),
			dataType: 'json',
			success: function(json) { 
				alert('saved !');
			}			
		});
	},
	'validation': function() {
		$('.ponoerr, .pofileerr').hide().closest('td').removeClass('has-error');
 	
		if($('input[name*="ponum_pono"]').length && ($('input[name*="ponum_pono"]').val() == '' || $('input[name*="ponum_pono"]').val() == null || $('input[name*="ponum_pono"]').val().trim().length <= 3)) {
			$('.ponoerr').show().closest('td').addClass('has-error');
			return 1;
  		} 
		if($('input[name*="ponum_pofilename"]').length && ($('input[name*="ponum_pofilename"]').val() == '' || $('input[name*="ponum_pofilename"]').val() == null || $('input[name*="ponum_pofilename"]').val().trim().length <= 2)) {
 			$('.pofileerr').show().closest('td').addClass('has-error');
			return 1;
 		} 
		return 0; 		
 	},
	'initjson': function() {
		user_token = ponum.geturlparam('user_token');
 		order_id = decodeURIComponent(ponum.geturlparam('order_id'));
 		$.ajax({
			url: 'index.php?route=extension/ponum/getorderinfo&user_token='+user_token+'&order_id=' + order_id,
			dataType: 'json',
			success: function(json) { 
				if(json) {
					$('.main_ponum').remove();
					var html = '';
					html += '<div class="main_ponum">';
					html += '<table class="table table_ponum">';
					if(json['rs']['ponodisp'] != 2) {
						html += '<tr>';
						html += '<td>';
						html += '<label class="control-label">' + json['rs']['ponolabel'] + '</label>';
						html += '<input type="text" name="ponum_pono" class="form-control" value="' + json['ponum_pono'] + '"/>';
						html += '<div class="ponoerr">' + json['rs']['ponoerr'] + '</div>';
						html += '</td>';
						html += '</tr>';
					}
					if(json['rs']['pofiledisp'] != 2) {
						html += '<tr>';
						html += '<td>';
						html += '<label class="control-label">' + json['rs']['pofilelabel'] + '</label>';
						html += '<div class="input-group"> <input type="text" name="ponum_pofilename" id="input-ponum_pofilename" class="form-control" value="' + json['ponum_pofilename'] + '"/> <input type="hidden" name="ponum_pofile" value="' + json['ponum_pofile'] + '" id="input-ponum_pofile" /><span class="input-group-btn"> <button type="button" id="button-ponum_pofile" class="btn btn-primary"><i class="fa fa-upload"></i></button> </span> </div>';
						html += '<div class="pofileerr">' + json['rs']['pofileerr'] + '</div>';
						html += '</td>';
						html += '</tr>';			
					}
					html += '<tr>';
						html += '<td>';
						html += '&nbsp;';
						html += '<a class="btn btn-primary btnsaveponum"><i class="fa fa-save"></i></a>';
						html += '</td>';
					html += '</tr>';
					html += '</table>';
					html += '</div>';
									
					$('.panel-default').eq(0).append(html);		
					
					$(document).delegate('button[id*="button-ponum_pofile"]', 'click', function() {
						var node = this;
						$('#form-pofile').remove();
						$('body').prepend('<form enctype="multipart/form-data" id="form-pofile" style="display: none;"><input type="file" name="file" /></form>');
						$('#form-pofile input[name=\'file\']').trigger('click');
						if (typeof pofiletimer != 'undefined') {
							clearInterval(pofiletimer);
						}
						pofiletimer = setInterval(function() {
							if ($('#form-pofile input[name=\'file\']').val() != '') {
								user_token = ponum.geturlparam('user_token');
								clearInterval(pofiletimer);
								$.ajax({
									url: 'index.php?route=extension/ponum/upload&user_token='+user_token,
									type: 'post',
									dataType: 'json',
									data: new FormData($('#form-pofile')[0]),
									cache: false,
									contentType: false,
									processData: false,
									beforeSend: function() {
										$(node).button('loading');
									},
									complete: function() {
										$(node).button('reset');
									},
									success: function(json) {
										$(node).closest('td').find('.alert').remove();
										if (json['error']) {
											$(node).closest('td').find('.input-group').after('<div class="alert alert-warning">' + json['error'] + '</div>');
										}
										if (json['success']) {
											$(node).closest('td').find('.input-group').after('<div class="alert alert-success">' + json['success'] + '</div>');
											setTimeout(function(){ $(node).closest('td').find('.alert').remove(); }, 1000);
											$('#input-ponum_pofile').val(json['code']);
											$('#input-ponum_pofilename').val(json['filename']);
										}
 									},
									error: function(xhr, ajaxOptions, thrownError) {
										alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
									}
								});
							}
						}, 500);
					});			
				}
			} 
		});
	}
}
$(document).ready(function() {
	ponum.initjson();
});
$(document).delegate(".btnsaveponum", 'click', function() {
	if(ponum.validation() == 0) {
		ponum.saveorderedit();
	}
});