var objSmartFlexible = (function($) {
    return {
        depthPadding: 20,
        custom_packages_next_id: 1,
        custom_envelopes_next_id: 1,
        shipping_category_next_id: 1,
        total_promo: 0,
        total_holidays: 0,
        total_adjustment_rules: 0,
        holidays: {},
        params: {},
        tabsLinks: null,
        faqAdded: false,
        servicesPromise: $.Deferred().resolve(),
        customPackageTypes: [{
            selector: '#custom_packages_holder',
            settingKey: 'custom_packages',
            getPrefix: function() {return objSmartFlexible.params.composedId.fixed;}
        }, {
            selector: '#custom_envelopes_holder',
            settingKey: 'custom_envelopes',
            getPrefix: function() {return objSmartFlexible.params.composedId.expandable;}
        }],
        init: function(params) {
            this.params = params;
            this.addEqualConfigListener();
            this.addStoreIdListener();
            this.addUserIdListener();
            this.addPackerListener();
            this.addLabelListener();
            this.addInvoiceListener();
            this.addLabelFormatListener();
            this.addPostcodeListener();
            this.addImportSettingsListener();
            this.addHolidayListener();
            this.addInsuranceListener();
            this.addSignatureListener();
            this.addMeasurementSystemListener();
            this.addCountryListener();
            this.addBillingSameListener();
            this.addBillingCountryListener();
            this.addFallbackProductCountryListener();
            this.customPackageTypes.forEach(function(params) {
                $(params.selector).on('change', 'input', this.updateShippingCategoryPackages.bind(this));
            }, this);
            this.createProductsTreeIndex();
            this.addSharedSettingsListener();
        },
        initForVersion1: function() {
            var tabs = $('#tabs');
            this.tabsLinks = tabs.find('a');
            if (this.tabsLinks.length) {
                this.tabsLinks.tabs();
            }
            this.tabsLinks.click(function (e) {
                e.preventDefault();
                objSmartFlexible.handleTabChange(e);
            });
            tabs.find('a[href="#' + window.location.hash.substr(2) + '"]').trigger('click');
            this.highlightTabsWithError();
        },
        initForVersion2: function() {
            this.tabsLinks = $('.nav-tabs a');
            this.tabsLinks.click(function (e) {
                e.preventDefault();
                $(this).tab('show');
            });
            this.tabsLinks.on('shown.bs.tab', objSmartFlexible.handleTabChange);
            if ($().tab) {
                $('.nav-tabs a[href="#' + window.location.hash.substr(2) + '"]').tab('show');
            }
            this.highlightTabsWithError();
        },
        initForVersion3: function() {
            this.initForVersion2(); // same
        },
        handleTabChange: function(e) {
            var tabId = $(e.target).attr("href").substr(1);
            window.location.hash = '!' + tabId;
            if (!objSmartFlexible.faqAdded && tabId === 'tab-faq') {
                $('#tab-faq').append($('<iframe id="faq" src="' + objSmartFlexible.params.faqUrl + '"></iframe>'));
                objSmartFlexible.faqAdded = true;
            }
        },
        createProductsTreeIndex: function() {
            this.params.indexedCategories = {};
            this.params.indexedProducts = {};
            var pass = function(arr) {
                if (Array.isArray(arr)) {
                    arr.forEach(function (cat) {
                        objSmartFlexible.params.indexedCategories[cat.category_id] = cat.title;
                        if (cat.products && Array.isArray(cat.products)) {
                            cat.products.forEach(function (prod) {
                                objSmartFlexible.params.indexedProducts[prod.product_id] = prod.title;
                            });
                        }
                        pass(cat.categories);
                    })
                }
            };
            pass(this.params.productsTree);
        },
        licenseClose: function() {
            document.cookie = this.params.licenseCookie + '=true; expires=Fri, 31 Dec 9999 23:59:59 GMT';
            $('#license').hide();
        },
        highlightTabsWithError: function() {
            $('.tab-pane').each(function() {
                if ($(this).has('span.error, p.text-danger').length) {
                    objSmartFlexible.tabsLinks.filter('[href="#' + this.id + '"]').addClass('_has-error');
                } else {
                    objSmartFlexible.tabsLinks.filter('[href="#' + this.id + '"]').removeClass('_has-error');
                }
            });
        },
        sortNumbers: function(a, b) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        },
        inter: function(v) {
            return parseInt(v, 10);
        },
        options: function(data, keyField, valueField, selected) {
            return data.map(function(row) {
                if (row.type === 'optgroup') {
                    return '<optgroup label="' + row.label + '">' +
                        objSmartFlexible.options(row.options, keyField, valueField, selected) + '</optgroup>';
                }
                var isSelected = Array.isArray(selected) ? (selected.indexOf(row[keyField]) !== -1) :
                    (row[keyField] === selected);
                return '<option value="' + row[keyField] + '"' + (isSelected ? ' selected' : '') + '>' +
                    row[valueField] + '</option>';
            }).join('\n');
        },
        appendHTML: function(target, holderElement, html) {
            if (target) {
                var holder = document.createElement(holderElement);
                holder.innerHTML = html;
                target.appendChild(holder);
            }
        },
        moveElementTo: function(element, newParent, cb) {
            var eold = $(element);
            var enew = eold.clone().appendTo(newParent);
            enew.css('visibility', 'hidden'); // hold the place
            var newOffset = enew.offset();
            var oldOffset = eold.offset();
            var etemp = eold.clone().appendTo('body');
            etemp
                .css('position', 'absolute')
                .css('left', oldOffset.left)
                .css('top', oldOffset.top)
                .css('zIndex', 1000);
            eold.hide();
            etemp.animate({'top': newOffset.top, 'left': newOffset.left}, 'slow', function() {
                enew.css('visibility', 'visible');
                eold.remove();
                etemp.remove();
                cb();
            });
        },
        addCustomPackage: function(length, width, height, max_load, tare, id) {
            var name = this.params.customPackages;
            var center = this.params.center;
            var package_id = id ? id : this.custom_packages_next_id;
            this.custom_packages_next_id = Math.max(package_id, this.custom_packages_next_id) + 1;
            var html =
                '<td class="' + center + '">' + package_id + '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + package_id + '][length]"' +
                '       value="' + length + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + package_id + '][width]"' +
                '       value="' + width + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + package_id + '][height]"' +
                '       value="' + height + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + package_id + '][max_load]"' +
                '       value="' + (max_load != '0' ? max_load : '') + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + package_id + '][tare]"' +
                '       value="' + (tare != '0' ? tare : '') + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       type="hidden"' +
                '       name="' + name + '[' + package_id + '][package_id]"' +
                '       value="' + package_id + '"/>' +
                '   <a href="#" onclick="objSmartFlexible.removeCustomPackage(this); return false;">' +
                this.params.textRemovePackage +
                '   </a>' +
                '</td>';
            this.appendHTML(document.getElementById('custom_packages_holder'), 'tr', html);
            $('input[name="' + name + '[' + package_id + '][length]' + '"], ' +
                'input[name="' + name + '[' + package_id + '][width]' + '"], ' +
                'input[name="' + name + '[' + package_id + '][height]' + '"]'
            ).on('change', this.handleCustomBoxChange);
            this.handleCustomBoxChange.call(
                $('input[name="' + name + '[' + package_id + '][length]' + '"]')
            );
            this.scheduleShippingCategoryPackageUpdate();
        },
        addCustomEnvelope: function(length, width, max_height, max_load, tare, id) {
            var name = this.params.customEnvelopes;
            var center = this.params.center;
            var envelope_id = id ? id : this.custom_envelopes_next_id;
            this.custom_envelopes_next_id = Math.max(envelope_id, this.custom_envelopes_next_id) + 1;
            var html =
                '<td class="' + center + '">' + envelope_id + '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + envelope_id + '][length]"' +
                '       value="' + length + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + envelope_id + '][width]"' +
                '       value="' + width + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + envelope_id + '][max_height]"' +
                '       value="' + (max_height != '0' ? max_height : '') + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + envelope_id + '][max_load]"' +
                '       value="' + (max_load != '0' ? max_load : '') + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + envelope_id + '][tare]"' +
                '       value="' + (tare != '0' ? tare : '') + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       type="hidden"' +
                '       name="' + name + '[' + envelope_id + '][envelope_id]"' +
                '       value="' + envelope_id + '"/>' +
                '   <a href="#" onclick="objSmartFlexible.removeCustomPackage(this); return false;">' +
                this.params.textRemovePackage +
                '   </a>' +
                '</td>';
            this.appendHTML(document.getElementById('custom_envelopes_holder'), 'tr', html);
            $('input[name="' + name + '[' + envelope_id + '][length]' + '"], ' +
                'input[name="' + name + '[' + envelope_id + '][width]' + '"]'
            ).on('change', this.handleCustomEnvelopeChange);
            this.handleCustomEnvelopeChange.call(
                $('input[name="' + name + '[' + envelope_id + '][length]' + '"]')
            );
            this.scheduleShippingCategoryPackageUpdate();
        },
        removeCustomPackage: function(link) {
            var target = $(link).parents('tr')[0];
            target.remove();
            this.scheduleShippingCategoryPackageUpdate();
        },
        updateShippingCategoryPackages: function() {
            var fragment = document.createDocumentFragment();
            fragment.appendChild($('<label><input type="checkbox" value="' + objSmartFlexible.params.composedId.any +
                '" />&nbsp;<strong>Any</strong></label>')[0]);
            var standardGroup = $('<div><label><strong>Standard</strong></label></div>');
            $('#standard-boxes-checked').find('.standard-box').each(function() {
                var box = $(this);
                var lwh = box.find('.standard-box__dimensions').text().replace(/[^\d\s,\.]/g, ' ').replace(/\s+/g, ' ').trim().split(' ').join('×');
                $('<label><input type="checkbox" value="' +
                    [
                        objSmartFlexible.params.extensionName,
                        objSmartFlexible.params.composedId.standard,
                        box.data('id')
                    ].join(objSmartFlexible.params.composedId.separator) +
                    '">&nbsp;' + box.find('.standard-box__title').text() + ' (' + lwh + ')' + '</label>').appendTo(standardGroup);
            });
            fragment.appendChild(standardGroup[0]);
            this.customPackageTypes.forEach(function(params) {
                var group = $('<div><label><strong>' + $(params.selector).parents('.form-group, tr').find('label').text() + '</strong></label></div>');
                $(params.selector).find('tr').each(function() {
                    var row = $(this);
                    var packageId = row.find('td:nth-child(1)').text();
                    var optionId = [
                        parseInt(
                            $('input[name="' + objSmartFlexible.params.extensionName +
                            '_shared_settings[' + params.settingKey + ']"').val()
                        ) ? objSmartFlexible.params.composedId.shared : objSmartFlexible.params.extensionName,
                        params.getPrefix(), packageId
                    ].join(objSmartFlexible.params.composedId.separator);
                    var lwh = [
                        row.find('td:nth-child(2) input').val() || '?',
                        row.find('td:nth-child(3) input').val() || '?',
                        row.find('td:nth-child(4) input').val() || '?'
                    ];
                    $('<label><input type="checkbox" value="' + optionId + '" />&nbsp;' +
                        '#' + packageId + ' (' + lwh.join('×') + ')' + '</label>').appendTo(group);
                });
                fragment.appendChild(group[0]);
            });
            $('#shipping-categories').find('.shipping-category__packages').each(function() {
                var jqSelect = $(this);
                var id = jqSelect.data('id');
                var values = jqSelect.find('input:checked').map(function(i, input) {
                    return $(input).val();
                }).toArray();
                while (this.firstChild) {
                    this.removeChild(this.firstChild);
                }
                var cloned = fragment.cloneNode(true);
                cloned.querySelectorAll('input').forEach(function(input) {
                    input.name = objSmartFlexible.params.shippingCategories + '[' + id + '][packages][]';
                    input.checked = values.indexOf(input.value) > -1;
                });
                this.appendChild(cloned);
            });
        },
        scheduleShippingCategoryPackageUpdate: function(callback) {
            if (this._shippingCategoryPackageUpdateTimer) {
                if (callback) {
                    this._shippingCategoryPackageUpdateCallbacks.push(callback);
                }
                return;
            }
            this._shippingCategoryPackageUpdateCallbacks = callback ? [callback] : [];
            this._shippingCategoryPackageUpdateTimer = setTimeout((function() {
                this._shippingCategoryPackageUpdateTimer = null;
                this.updateShippingCategoryPackages();
                this._shippingCategoryPackageUpdateCallbacks.forEach(function(callback) {
                    callback();
                });
                this._shippingCategoryPackageUpdateCallbacks = [];
            }).bind(this));
        },
        addShippingCategory: function(name, shipTogether, packageIds, incCategories, incProducts) {
            var shippingCategoryId = this.shipping_category_next_id;
            this.shipping_category_next_id++;
            var namePrefix = this.params.shippingCategories + '[' + shippingCategoryId + ']';
            var category = $([
                '<div class="shipping-category">',
                '   <div class="shipping-category__collapsed">',
                '       <a href="javascript:void(0)" class="shipping-category__title">' + name + '</a>',
                '       <a href="javascript:void(0)" class="shipping-category__remove"></a>',
                '   </div>',
                '   <div class="shipping-category__details">',
                '       <label class="shipping-category__field">',
                '           <input name="' + namePrefix + '[name]" class="form-control shipping-category__name" />',
                '       </label>',
                '       <label class="shipping-category__field">',
                '           <input type="checkbox" name="' + namePrefix + '[ship_together]" value="1"',
                '           class="shipping-category__ship-together" />' + this.params.textShippingCategoryShipTogether,
                '       </label>',
                '       <div class="shipping-category__conditions">',
                '           <div class="shipping-category__packages" data-id="' + shippingCategoryId + '"></div>',
                '           <div class="shipping-category__foreign-packages"></div>',
                '           <div class="shipping-category__notes">',
                '               <div class="shipping-category__summary"></div>',
                '               <a href="javascript:void(0)" class="btn btn-info shipping-category__more"></a>',
                '           </div>',
                '       </div>',
                '       <div class="shipping-category__buttons">',
                '           <a href="javascript:void(0)" class="btn btn-default shipping-category__close"></a>',
                '       </div>',
                '   </div>',
                '   <div class="shipping-category__tree">',
                '       <div class="shipping-category__tree-controls">',
                '           <input class="form-control shipping-category__search" />',
                '           <a href="javascript:void(0)" class="btn btn-default shipping-category__less"></a>',
                '       </div>',
                '       <input type="hidden" name="' + namePrefix + '[categories]" value="' + incCategories.join(',') + '" />',
                '       <input type="hidden" name="' + namePrefix + '[products]" value="' + incProducts.join(',') + '" />',
                '       <div class="shipping-category__tree-scrollable"></div>',
                '   </div>',
                '</div>'
            ].join(''));
            category.find('.shipping-category__title').click(function() {
                $('.shipping-category__details').hide();
                $('.shipping-category__collapsed').show();
                category.find('.shipping-category__collapsed').hide();
                category.find('.shipping-category__details').show();
            });
            category.find('.shipping-category__close').text('Close').click(function() { // todo
                category.find('.shipping-category__details').hide();
                category.find('.shipping-category__collapsed').show();
            });
            var generateSummaryNotes = function() {
                var jqCat = category.find('input[name*="[categories]"]');
                var jqProd = category.find('input[name*="[products]"]');
                var categoriesSelected = jqCat.val() ? jqCat.val().split(',').map(objSmartFlexible.inter) : [];
                var productsSelected = jqProd.val() ? jqProd.val().split(',').map(objSmartFlexible.inter) : [];
                var productsSelectedHtml = '';
                var categoriesSelectedHtml = '';
                if (productsSelected.length > 0) {
                    productsSelectedHtml = '<label>Products (' + productsSelected.length + ')</label>' +
                        productsSelected.slice(0, 5).map(function(pid) {
                            return '<div>' + objSmartFlexible.params.indexedProducts[pid] + '</div>';
                        }).join('');
                }
                if (categoriesSelected.length > 0) {
                    categoriesSelectedHtml = '<label>Categories (' + categoriesSelected.length + ')</label>' +
                        categoriesSelected.slice(0, 5).map(function(cid) {
                            return '<div>' + objSmartFlexible.params.indexedCategories[cid] + '</div>';
                        }).join('');
                }
                var isEmpty = productsSelected.length + categoriesSelected.length === 0;
                category.find('.shipping-category__summary').html(
                    isEmpty ? '<div><strong>No products selected</strong></div>' : productsSelectedHtml + categoriesSelectedHtml
                ).parent().toggleClass('_empty', isEmpty).find('.shipping-category__more').text(isEmpty ? 'Detailed selection' : 'Select products');
            };
            generateSummaryNotes();
            category.find('.shipping-category__more').click(function() {
                var jqSelect = category.find('.shipping-category__tree');
                jqSelect.show().css('display', 'flex');
                var jqCategories = jqSelect.find('input[name*="[categories]"]');
                var jqProducts = jqSelect.find('input[name*="[products]"]');
                var selectedCategories = jqCategories.val().split(',').map(objSmartFlexible.inter);
                var selectedProducts = jqProducts.val().split(',').map(objSmartFlexible.inter);
                var renderSubTree = function(array, depth) {
                    return array.map(function(treeCategory) {
                        var isChecked = selectedCategories.indexOf(treeCategory.category_id) !== -1;
                        return '<label class="_category" style="padding-left: ' +
                        depth * objSmartFlexible.depthPadding + 'px"><input type="checkbox" ' +
                        (isChecked ? 'checked' : '') + ' data-id="' + treeCategory.category_id + '">&nbsp;' +
                        treeCategory.title + '</label>' +
                        treeCategory.products.map(function(treeProduct) {
                            var isChecked = selectedProducts.indexOf(treeProduct.product_id) !== -1;
                            return '<label class="_product" style="padding-left: ' + (depth + 1) *
                            objSmartFlexible.depthPadding + 'px"><input type="checkbox" ' +
                            (isChecked ? 'checked' : '') + ' data-id="' + treeProduct.product_id + '">&nbsp;' +
                            treeProduct.title + '</label>';
                        }).join('') + renderSubTree(treeCategory.categories, depth + 1);
                    }).join('');
                };
                var scrollable = jqSelect.find('.shipping-category__tree-scrollable').append(
                    renderSubTree(objSmartFlexible.params.productsTree, 0)
                );
                var uniqueInputsId = function(elements) {
                    var uniqueIds = [];
                    elements.each(function() {
                        if (uniqueIds.indexOf($(this).data('id')) === -1) {
                            uniqueIds.push($(this).data('id'));
                        }
                    });
                    return uniqueIds;
                };
                scrollable.find('._category input').click(function() {
                    jqCategories.val(uniqueInputsId(scrollable.find('._category input:checked')));
                });
                scrollable.find('._product input').click(function() {
                    jqProducts.val(uniqueInputsId(scrollable.find('._product input:checked')));
                });
            });
            category.find('.shipping-category__search').prop('placeholder', 'Search').keyup(function() { // todo
                var searchText = $(this).val().toLowerCase().trim();
                var labels = category.find('.shipping-category__tree-scrollable label');
                if (searchText.length > 0) {
                    labels = labels.removeClass('_selected').filter(function (i, label) {
                        return $(label).text().toLowerCase().indexOf(searchText) > -1; // todo: search by words
                    }).addClass('_selected');
                    if (labels.length > 0) {
                        var offsetTop = labels[0].offsetTop;
                        $('.shipping-category__tree-scrollable').stop().animate({
                            scrollTop: offsetTop + 'px'
                        }, 600);
                    }
                } else {
                    labels.removeClass('_selected');
                }
            });
            category.find('.shipping-category__less').text('Close').click(function() { // todo
                category.find('.shipping-category__tree').hide();
                category.find('.shipping-category__tree-scrollable').html(null);
                generateSummaryNotes();
            });
            category.find('.shipping-category__remove')
                .text(this.params.textRemoveShippingCategory)
                .click(function() {
                    category.remove();
                });
            category.find('.shipping-category__name').val(name).on('change', function() {
                $(this).val($(this).val() ? $(this).val() : name);
                category.find('.shipping-category__title').text($(this).val());
            });
            category.find('.shipping-category__ship-together').prop('checked', shipTogether);
            category.find('.shipping-category__categories div').click(function() {
                category.find('.shipping-category__categories div').removeClass('_selected');
                $(this).addClass('_selected');
                category.find('.shipping-category__products').hide();
                category.find('#shipping-category__products_' + $(this).data('id')).show();
            });
            this.scheduleShippingCategoryPackageUpdate(function() {
                // check native
                var addedNative = [];
                category.find('.shipping-category__packages input').each(function(i, input) {
                    var jqInput = $(input);
                    jqInput.prop('checked', packageIds.indexOf(jqInput.val()) > -1);
                    addedNative.push(jqInput.val());
                });
                // add foreign
                // todo: show foreign (quantity) ?
                var foreignPackages = category.find('.shipping-category__foreign-packages');
                var addedForeign = [];
                packageIds.filter(function(id) {
                    return addedNative.indexOf(id) === -1;
                }).forEach(function(id) {
                    foreignPackages.append('<input type="hidden" name="' + namePrefix + '[packages][]" value="' + id + '"/>');
                    addedForeign.push(id);
                });
            });
            category.appendTo('#shipping-categories');
        },
        addPromo: function(min_cost, length, width, height, weight) {
            var name = this.params.promo;
            var center = this.params.center;
            this.total_promo++;
            var promo_id = this.total_promo;
            var html =
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + promo_id + '][min_cost]"' +
                '       value="' + min_cost + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + promo_id + '][length]"' +
                '       value="' + length + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + promo_id + '][width]"' +
                '       value="' + width + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + promo_id + '][height]"' +
                '       value="' + height + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       name="' + name + '[' + promo_id + '][weight]"' +
                '       value="' + weight + '"' +
                '       class="form-control small-number" />' +
                '</td>' +
                '<td class="' + center + '">' +
                '   <input' +
                '       type="hidden"' +
                '       name="' + name + '[' + promo_id + '][promo_id]"' +
                '       value="' + promo_id + '" />' +
                '   <a href="#" onclick="objSmartFlexible.removePromo(this); return false;">' +
                        this.params.textRemovePromo +
                '   </a>' +
                '</td>';
            this.appendHTML(document.getElementById('promo_holder'), 'tr', html);
        },
        removePromo: function(link) {
            var target = $(link).parents('tr')[0];
            target.remove();
        },
        addStandardBox: function(id, title, image, size, weight, checked) {
            var name = this.params.standardPackages;
            var path = this.params.imagesPath;
            var html =
                '<div' +
                '   id="standard-box-' + id + '"' +
                '   data-id="' + id + '"' +
                '   class="standard-box"' +
                '   onclick="objSmartFlexible.checkStandardBox(this);">' +
                '   <div class="standard-box__image-holder">' +
                '       <img src="' + path + '/' + image + '" />' +
                '       <div class="standard-box__checker' + (checked ? ' _checked' : '') + '">' +
                '           <input' +
                '               name="' + name + '[' + id + ']"' +
                '               type="hidden"' +
                '               value="' + (checked ? '1' : '0') + '" />' +
                '       </div>' +
                '   </div>' +
                '   <div class="standard-box__caption">' +
                '       <div class="standard-box__title">' + title + '</div>' +
                '       <div class="standard-box__dimensions">' + size + '</div>' +
                '       <div class="standard-box__weight">' + weight + '</div>' +
                '   </div>' +
                '</div>';
            var target = checked ? $('#standard-boxes-checked') : $('#standard-boxes-unchecked');
            target.append(html);
        },
        addHoliday: function(month, day) {
            if (this.holidays[month] === undefined) {
                this.holidays[month] = [];
            }
            if (this.holidays[month].indexOf(day) !== -1) {
                return;
            }
            this.holidays[month].push(day);
            this.holidays[month].sort(this.sortNumbers);
            this.showHolidays(month);
        },
        applyFieldInactivity: function(input) {
            if ($(input).val() === '') {
                $(input).parents('.adjustment-rule__field').addClass('_inactive');
            } else {
                $(input).parents('.adjustment-rule__field').removeClass('_inactive');
            }
        },
        applyMasterCheckbox: function(checkbox) {
            if (checkbox.checked) {
                $(checkbox).parents('.adjustment-rule__master').next('.adjustment-rule__row').removeClass('_hidden');
            } else {
                $(checkbox).parents('.adjustment-rule__master').next('.adjustment-rule__row').addClass('_hidden')
                    .find('input').val('');
            }
        },
        addAdjustmentRule: function(data) {
            this.servicesPromise.then(function() {
                var compareOperators = [
                    {key: '', value: ''},
                    {key: 'gt', value: '&gt;'},
                    {key: 'gte', value: '&gt;='},
                    {key: 'eq', value: '='},
                    {key: 'lte', value: '&lt;='},
                    {key: 'lt', value: '&lt;'}
                ];
                var currency = $('input[name*="rate_adj_fix"]').parent().find('span').text();
                var rateCondition = {};
                var totalCondition = {};
                var selectedServices = [''];
                var percentAction = {};
                var fixedAction = {};
                var grouping = {};
                if (data.condition && data.condition.conditions && data.actions) {
                    rateCondition = data.condition.conditions.filter(function(condition) {
                        return condition.type === 'comparison' && condition.argument === 'rate';
                    }).pop() || {};
                    totalCondition = data.condition.conditions.filter(function(condition) {
                        return condition.type === 'comparison' && condition.argument === 'total';
                    }).pop() || {};
                    var servicesCondition = data.condition.conditions.filter(function(condition) {
                        return condition.type === 'services';
                    }).pop() || {};
                    percentAction = data.actions.filter(function(action) {
                        return action.type === 'ratePercent';
                    }).pop() || {};
                    fixedAction = data.actions.filter(function(action) {
                        return action.type === 'rateFixed';
                    }).pop() || {};
                    grouping = data.grouping || {};
                    selectedServices = servicesCondition.services ? servicesCondition.services : [''];
                }
                var services = [{key: '', value: 'Any'}];
                var servicesTopLevelArray = $.makeArray($('.services .services__service'));
                servicesTopLevelArray.forEach(function(s) {
                    var column = $(s).parents('td')[0];
                    $.makeArray($(column).find('.services__group')).forEach(function(g) {
                        services.push({
                            type: 'optgroup',
                            label: (servicesTopLevelArray.length > 1 ? (s.innerText.replace(/ Services/i, '') + ': ') : '') +
                                g.innerText,
                            options: $.makeArray($(g).nextUntil('.services__group', '.checkbox')).map(function(o) {
                                return {
                                    type: 'option',
                                    key: $(o).find('input[type=checkbox]')[0].name.split(/[\[\]]/)[1],
                                    value: o.innerText
                                };
                            })
                        });
                    });
                });
                var name = objSmartFlexible.params.adjustmentRules;
                objSmartFlexible.total_adjustment_rules++;
                var html =
                    '<div class="adjustment-rule"><div class="adjustment-rule__label">' +
                    'If all conditions are satisfied</div>' +
                    '<div class="adjustment-rule__row"><div class="adjustment-rule__col">' +
                    '<div class="adjustment-rule__field">' +
                    '<label class="adjustment-rule__caption" for="adjustment-rule__rate_' + objSmartFlexible.total_adjustment_rules + '">' +
                    'Rate Shipping Price</label>' +
                    '<div class="adjustment-rule__input"><select name="' + name + '[' + objSmartFlexible.total_adjustment_rules + '][rate_operator]" class="adjustment-rule__select">' +
                    objSmartFlexible.options(compareOperators, 'key', 'value', rateCondition.operator ? rateCondition.operator : '') +
                    '</select>&#32;<div class="adjustment-rule__group"><div class="input-group small-number">' +
                    '<input name="' + name + '[' + objSmartFlexible.total_adjustment_rules + '][rate]" id="adjustment-rule__rate_' + objSmartFlexible.total_adjustment_rules + '" class="form-control" value="' + (rateCondition.value ? rateCondition.value : '') + '">' +
                    '<span class="input-group-addon">' + currency + '</span></div></div>' +
                    '</div></div>' +
                    '<div class="adjustment-rule__field">' +
                    '<label class="adjustment-rule__caption" for="adjustment-rule__total_' + objSmartFlexible.total_adjustment_rules + '">' +
                    'Order Total</label>' +
                    '<div class="adjustment-rule__input"><select name="' + name + '[' + objSmartFlexible.total_adjustment_rules + '][total_operator]" class="adjustment-rule__select">' +
                    objSmartFlexible.options(compareOperators, 'key', 'value', totalCondition.operator ? totalCondition.operator : '') +
                    '</select>&#32;<div class="adjustment-rule__group"><div class="input-group small-number">' +
                    '<input name="' + name + '[' + objSmartFlexible.total_adjustment_rules + '][total]" id="adjustment-rule__total_' + objSmartFlexible.total_adjustment_rules + '" class="form-control" value="' + (totalCondition.value ? totalCondition.value : '') + '">' +
                    '<span class="input-group-addon">' + currency + '</span></div></div>' +
                    '</div><div class="adjustment-rule__hint">' +
                    'Total price of all ordered items, does not include shipping and other costs.' +
                    '</div></div></div><div class="adjustment-rule__col"><div class="adjustment-rule__field">' +
                    '<label class="adjustment-rule__caption" for="adjustment-rule__services_' + objSmartFlexible.total_adjustment_rules + '">' +
                    $('a[href="#tab-ext-services"]').text() + '</label>' +
                    '<div class="adjustment-rule__input">' +
                    '<select name="' + name + '[' + objSmartFlexible.total_adjustment_rules + '][services][]" class="adjustment-rule__multiselect" multiple id="adjustment-rule__services_' + objSmartFlexible.total_adjustment_rules + '">' +
                    objSmartFlexible.options(services, 'key', 'value', selectedServices) +
                    '</select></div>' +
                    '<div class="adjustment-rule__hint">Use SHIFT / CTRL (or CMD) keys to select multiple items.</div>' +
                    '</div></div></div><div class="adjustment-rule__label">Apply adjustments</div>' +
                    '<div class="adjustment-rule__row"><div class="adjustment-rule__col">' +
                    '<div class="adjustment-rule__field">' +
                    '<label class="adjustment-rule__caption" for="adjustment-rule__fixed_' + objSmartFlexible.total_adjustment_rules + '">' +
                    'Set Fixed Rate Adjustment</label><div class="adjustment-rule__input">' +
                    '<div class="input-group small-number">' +
                    '<input name="' + name + '[' + objSmartFlexible.total_adjustment_rules + '][fixed]" id="adjustment-rule__fixed_' + objSmartFlexible.total_adjustment_rules + '" class="form-control" value="' + (fixedAction.value ? fixedAction.value : '') + '" onkeyup="objSmartFlexible.applyFieldInactivity(this)">' +
                    '<span class="input-group-addon">' + currency + '</span>' +
                    '</div></div><div class="adjustment-rule__hint">' +
                    'Increase shipping price by this value. Negative numbers are supported.' +
                    '</div></div></div><div class="adjustment-rule__col">' +
                    '<div class="adjustment-rule__field">' +
                    '<label class="adjustment-rule__caption" for="adjustment-rule__percent_' + objSmartFlexible.total_adjustment_rules + '">' +
                    'Set Rate Adjustment by %</label>' +
                    '<div class="adjustment-rule__input"><div class="input-group small-number">' +
                    '<input name="' + name + '[' + objSmartFlexible.total_adjustment_rules + '][percent]" id="adjustment-rule__percent_' + objSmartFlexible.total_adjustment_rules + '" class="form-control" value="' + (percentAction.value ? percentAction.value : '') + '" onkeyup="objSmartFlexible.applyFieldInactivity(this)">' +
                    '<span class="input-group-addon">%</span>' +
                    '</div></div><div class="adjustment-rule__hint">' +
                    'Increase shipping price by this percent. Negative numbers are supported.' +
                    '</div></div></div></div><div class="adjustment-rule__label">Grouping</div>' +
                    '<div class="adjustment-rule__master"><label class="adjustment-rule__caption">' +
                    '<input type="checkbox" ' + (grouping.title ? 'checked' : '') + ' onclick="objSmartFlexible.applyMasterCheckbox(this)" id="adjustment-rule__grouping_' + objSmartFlexible.total_adjustment_rules + '"> Group matched rates under a single title</label></div>' +
                    '<div class="adjustment-rule__row">' +
                    '<div class="adjustment-rule__col"><div class="adjustment-rule__field">' +
                    '<label class="adjustment-rule__caption" for="adjustment-rule__group_' + objSmartFlexible.total_adjustment_rules + '">Rate Title</label>' +
                    '<div class="adjustment-rule__input"><input name="' + name + '[' + objSmartFlexible.total_adjustment_rules + '][group]" id="adjustment-rule__group_' + objSmartFlexible.total_adjustment_rules + '" class="form-control" value="' + (grouping.title ? grouping.title : '') + '"></div>' +
                    '</div></div><div class="adjustment-rule__col adjustment-rule__hint">When multiple rates are grouped under a single title, the cheapest one should be picked in order to generate labels.</div></div>' +
                    '<a class="btn btn-default adjustment-rule__remove" href="#" onclick="this.parentNode.parentNode.removeChild(this.parentNode); return false">' +
                    'Remove This Rule</a>' +
                    '</div>';
                var btn = $('.adjustment-rule__add')[0];
                var div = document.createElement('div');
                div.innerHTML = html;
                btn.parentNode.insertBefore(div.firstChild, btn);
                objSmartFlexible.applyFieldInactivity($('#adjustment-rule__fixed_' + objSmartFlexible.total_adjustment_rules)[0]);
                objSmartFlexible.applyFieldInactivity($('#adjustment-rule__percent_' + objSmartFlexible.total_adjustment_rules)[0]);
                objSmartFlexible.applyMasterCheckbox($('#adjustment-rule__grouping_' + objSmartFlexible.total_adjustment_rules)[0]);
            });
        },
        showHolidays: function (month) {
            var name = this.params.processingHolidays;
            var target = $('#holidays_' + month);
            if (this.holidays[month].length > 0) {
                target.addClass('_active');
            } else {
                target.removeClass('_active');
            }
            target = $('#holidays_' + month + ' > .holidays__list');
            target.find('.holidays__item').remove();
            target.find('input').remove();
            var groups = [];
            var lastDay = null;
            var html = '';
            this.holidays[month].forEach(function(day) {
                this.total_holidays++;
                html += '<input ' +
                    '   type="hidden"' +
                    '   name="' + name + '[' + this.total_holidays + '][0]" ' +
                    '   value="' + month + '" />' +
                    '<input ' +
                    '   type="hidden"' +
                    '   name="' + name + '[' + this.total_holidays + '][1]" ' +
                    '   value="' + day + '" />';
                if (day - lastDay === 1 && lastDay !== null) {
                    groups[groups.length - 1].push(day);
                } else {
                    groups.push([day]);
                }
                lastDay = day;
            }, this);
            target.append(html);
            groups.forEach(function(group) {
                var firstDay = group[0];
                var lastDay = group[group.length - 1];
                target.append('<div class="holidays__item">' +
                    (firstDay === lastDay ? firstDay : firstDay + '&ndash;' + lastDay) +
                    '</div>');
            });
        },
        validateHolidays: function(frm, month) {
            var source = $(frm).find('input').val();
            var holidays = source.split(',');
            holidays = holidays.map(objSmartFlexible.inter).filter(function(v) {
                return (v >= 1) && (v <= 31);
            });
            this.holidays[month] = [];
            if (holidays.length > 0) {
                holidays.forEach(function(day) {
                    this.addHoliday(month, day);
                }, this);
                return;
            }
            this.showHolidays(month);
        },
        importHolidays: function() {
            /* https://gist.github.com/mattn/1438183 */
            var cal = encodeURIComponent($('select.google-holidays').val());
            var key = 'AIzaSyB_Ze7RT4a2gz6l188iLCUo4Z0S8uSg0OY';
            $.ajax({
                type: 'GET',
                url: 'https://www.googleapis.com/calendar/v3/calendars/' + cal + '/events?key=' + key,
                dataType: 'json',
                success: function(response) {
                    if (!response.items) {
                        return;
                    }
                    response.items.forEach(function(item) {
                        var dateParts = item.start.date.split('-');
                        if (parseInt(dateParts[0], 10) === (new Date()).getFullYear()) {
                            this.addHoliday(parseInt(dateParts[1], 10), parseInt(dateParts[2], 10));
                        }
                    }, this);
                }.bind(this),
                error: function(response) {
                    alert(
                        response.responseJSON.error.errors[0].message + ': ' +
                        response.responseJSON.error.errors[0].reason
                    );
                }
            });
        },
        clearHolidays: function() {
            for(var i = 1; i <= 12; i++) {
                this.holidays[i] = [];
                this.showHolidays(i);
            }
        },
        checkStandardBox: function(div) {
            var checker = $(div).find('.standard-box__checker')[0];
            var input = $(checker).find('input');
            if ($(checker).hasClass('_checked')) {
                $(checker).removeClass('_checked');
                input.attr('value', 0);
                this.moveElementTo(div, $('#standard-boxes-unchecked'), this.updateShippingCategoryPackages.bind(this));
            } else {
                $(checker).addClass('_checked');
                input.attr('value', 1);
                this.moveElementTo(div, $('#standard-boxes-checked'), this.updateShippingCategoryPackages.bind(this));
            }
        },
        addSharedSettingsListener: function() {
            var saver = function(jqSelect, value, cb) {
                var keys = jqSelect.data('keys');
                var data = {
                    route: objSmartFlexible.params.currentRoute + '/sharesetting',
                    keys: keys,
                    value: value,
                    store_id: objSmartFlexible.params.storeId
                };
                data[objSmartFlexible.params.tokenName] = objSmartFlexible.params.token;
                $.ajax({
                    url: objSmartFlexible.params.entryPoint,
                    data: data,
                    success: function(newValue) {
                        jqSelect.toggleClass('_shared', newValue);
                        jqSelect.find('input').val(newValue);
                        render.call(jqSelect);
                        cb(newValue);
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + (xhr.responseText ? xhr.responseText :
                            'Request was terminated'));
                    },
                    dataType: 'json'
                });
            };
            var render = function() {
                var jqSelect = $(this);
                var isShared = jqSelect.hasClass('_shared');
                var settingName = jqSelect.parent().find('label,p:first-child')
                    .clone().children().remove().end().text().trim();
                var confirmForm = jqSelect.find('.shared-setting__confirm').html('');
                jqSelect.find('> a')
                    .text('⚯ ' + (isShared ? 'Shared setting' : 'Share this setting')) // todo
                    .click(function() {
                        confirmForm.show().css('display', 'flex');
                    });
                confirmForm.append(
                    $('<div></div>').append(
                        $('<strong></strong>').text(
                            (isShared ? 'Unshare setting' : 'Share setting') + // todo
                            ' «' + settingName + '»'
                        )
                    ),
                    $('<div>Choose the action with setting value:</div>'), // todo
                    $('<a href="javascript:void(0)"></a>')
                        .text(isShared ? 'Keep value' : 'Override shared setting') // todo
                        .addClass('btn btn-primary').click(function() {
                            confirmForm.hide();
                            saver(jqSelect, isShared ? 0 : 1, function(newValue) {
                                var keys = jqSelect.data('keys');
                                keys.forEach(function(key) {
                                    // custom packages/envelopes affects shipping categories
                                    var customPackagesTypeIndex = objSmartFlexible.customPackageTypes.map(function(type) {
                                        return type.settingKey;
                                    }).indexOf(key);
                                    if (customPackagesTypeIndex !== -1) {
                                        var customPackagesType = objSmartFlexible.customPackageTypes[customPackagesTypeIndex];
                                        $('#shipping-categories input[name*="[packages]"]').each(function(){
                                            var input = $(this);
                                            var idComponents = input.val().split(objSmartFlexible.params.composedId.separator);
                                            if (
                                                (idComponents.length === 3) &&
                                                (idComponents[1] === customPackagesType.getPrefix())
                                            ) { // package of shared/unshared custom type
                                                input.val([
                                                    newValue ? objSmartFlexible.params.composedId.shared : objSmartFlexible.params.extensionName,
                                                    idComponents[1], idComponents[2]
                                                ].join(objSmartFlexible.params.composedId.separator));
                                            }
                                        });
                                    }
                                });
                                $('form#smart_flexible').submit();
                            });
                        }),
                    $('<a href="javascript:void(0)"></a>')
                        .text(isShared ? 'Clean value' : 'Load shared setting') // todo
                        .addClass('btn btn-default').click(function() {
                            confirmForm.hide();
                            saver(jqSelect, isShared ? 0 : 1, function() {
                                window.location.href = window.location.origin + window.location.pathname +
                                (window.location.search ? window.location.search : '?') + '&rnd=' + Math.random() +
                                window.location.hash;
                            });
                        }),
                    $('<a href="javascript:void(0)">Cancel</a>')
                        .addClass('btn btn-default').click(function(e) {
                            confirmForm.hide();
                        })
                );
            };
            $('.shared-setting').each(render);
        },
        addEqualConfigListener: function() {
            var name = this.params.equalConfig;
            var options = $('input[name="' + name + '"]');
            options.on('change', function(e) {
                var form = e.target.form;
                $(form).append('<input type="hidden" name="equal_config_changed" value="1">');
                form.submit();
            });
        },
        addStoreIdListener: function() {
            var options = $('#equal-config .dropdown-menu li a'); // v2-v3
            options.click(function() {
                window.location = objSmartFlexible.params.entryPoint + '&route=' +
                    objSmartFlexible.params.currentRoute + '&' + objSmartFlexible.params.tokenName + '=' +
                    objSmartFlexible.params.token + '&store_id=' + $(this).data('value') + window.location.hash;
                return false;
            });
            var select = $('#equal-config select'); // v1
            select.change(function() {
                window.location = objSmartFlexible.params.entryPoint + '&route=' +
                objSmartFlexible.params.currentRoute + '&' + objSmartFlexible.params.tokenName + '=' +
                objSmartFlexible.params.token + '&store_id=' + $(this).val() + window.location.hash;
                return false;
            });
        },
        addUserIdListener: function() {
            var name = this.params.userId;
            var input = $('input[name="' + name + '"]');
            if (this.params.methodsDependOnUserId) {
                this.fetchServicesByUser();
                input.on('change', this.fetchServicesByUser);
            }
            if (this.params.hasWebhookApi) {
                this.mountWebhook();
                input.on('change', this.mountWebhook);
            }
        },
        addPackerListener: function() {
            var name = this.params.packer;
            var select = $('select[name="' + name + '"]');
            select.on('change', this.handlePackerChange);
            this.handlePackerChange.call(select);
        },
        addLabelListener: function() {
            var name = this.params.label;
            var options = $('input[name="' + name + '"]');
            options.on('change', this.handleLabelChange);
            this.handleLabelChange.call(options);
        },
        addInvoiceListener: function() {
            var name = this.params.invoice;
            var options = $('input[name="' + name + '"]');
            options.on('change', this.handleInvoiceChange);
            this.handleInvoiceChange.call(options);
        },
        addLabelFormatListener: function() {
            var name = this.params.labelFormat;
            var select = $('select[name="' + name + '"]');
            select.on('change', this.handleLabelFormatChange);
            this.handleLabelFormatChange.call(select);
        },
        addPostcodeListener: function() {
            var name = this.params.postcode;
            var input = $('input[name="' + name + '"]');
            input.on('change', this.handlePostcodeChange);
            this.handlePostcodeChange.call(input);
        },
        addImportSettingsListener: function() {
            var link = $('#import-settings');
            var uploader = $('#upload');
            link.click(function() {
                alert('Just drag and drop the settings file on this link');
            });
            link.on('dragover', function(e) {
                e.preventDefault();
                e.stopPropagation();
                $(this).addClass('_hover');
            });
            link.on('dragleave', function(e) {
                e.preventDefault();
                e.stopPropagation();
                $(this).removeClass('_hover');
            });
            link.on('drop', function(e) {
                e.preventDefault();
                e.stopPropagation();
                $(this).removeClass('_hover');
                var file = e.originalEvent.dataTransfer.files[0];
                uploader.find('input[name="source"]').prop('files', e.originalEvent.dataTransfer.files);
                uploader.css('display', 'flex');
            });
            uploader.find('#upload__cancel').on('click', function() {
                uploader.hide();
            });
        },
        addHolidayListener: function() {
            var _obj = this;
            $('.holidays__month').click(function(e) {
                var edit = $('.holidays__edit');
                e.stopPropagation();
                edit.remove();
                var month = parseInt(this.id.match(/\d+/), 10);
                if (_obj.holidays[month] === undefined) {
                    _obj.holidays[month] = [];
                }
                $(this).append('<div class="holidays__edit">' +
                '<input value="' + _obj.holidays[month].join(',') + '" placeholder="1,2,15,...">' +
                '<button>OK</button>' +
                '</div>');
                var editInput = $('.holidays__edit input');
                editInput.focus();
                if (editInput[0].setSelectionRange) {
                    editInput[0].setSelectionRange(editInput.val().length, editInput.val().length);
                }
                edit.click(function(e) {
                    e.stopPropagation();
                });
                $('.holidays__edit button').click(function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    $('.holidays__edit').remove();
                    _obj.validateHolidays(this.parentNode, month);
                });
            });
        },
        addInsuranceListener: function() {
            var name = this.params.insurance;
            var options = $('input[name="' + name + '"]');
            options.on('change', this.handleInsuranceChange);
            this.handleInsuranceChange.call(options);
        },
        addSignatureListener: function() {
            var name = this.params.signature;
            var options = $('input[name="' + name + '"]');
            options.on('change', this.handleSignatureChange);
            this.handleSignatureChange.call(options);
        },
        proceedHide: function(whatToHide, hideOn) {
            var source = this;
            if ($(this).is('input[type="radio"]')) {
                source = $(this).filter(':checked');
            }
            whatToHide.map(function(obj) {
                var isMustBeHidden = false;
                if (Array.isArray(hideOn)) {
                    isMustBeHidden = hideOn.indexOf($(source).val()) > -1;
                } else {
                    isMustBeHidden = $(source).val() === hideOn;
                }
                if (isMustBeHidden) {
                    $(obj).hide();
                } else {
                    $(obj).show();
                }
            }.bind(this));
        },
        addMeasurementSystemListener: function() {
            var name = this.params.measurementSystem;
            var target = $('select[name="' + name + '"]');
            target.data('oldValue', target.val());
            target.on('change', function(e) {
                var form = e.target.form;
                $(form).append(
                    '<input type="hidden" name="measurement_system_old" value="' +
                    target.data('oldValue') + '">'
                );
                $(form).append('<input type="hidden" name="measurement_system_changed" value="1">');
                form.submit();
            });
        },
        addCountryListener: function() {
            this.fetchZones();
            var select = $('select[name="' + this.params.countryId + '"]');
            select.on('change', this.fetchZones);
            if (this.params.methodsDependOnShipperCountry) {
                this.fetchServicesByCountry();
                select.on('change', this.fetchServicesByCountry);
            }
        },
        addFallbackProductCountryListener: function() {
            this.fetchFallbackProductZones();
            var select = $('select[name="' + this.params.fallbackProductCountry + '"]');
            select.on('change', this.fetchFallbackProductZones);
        },
        addBillingSameListener: function() {
            var name = this.params.billingSame;
            var options = $('input[name="' + name + '"]');
            options.on('change', this.handleBillingSameChange);
            this.handleBillingSameChange.call(options);
        },
        addBillingCountryListener: function() {
            this.fetchBillingZones();
            var select = $('select[name="' + this.params.billingCountryId + '"]');
            select.on('change', this.fetchBillingZones);
        },
        handleBillingSameChange: function() {
            var hideOn = '1';
            var country_id = objSmartFlexible.params.billingCountryId;
            var zone_id = objSmartFlexible.params.billingZoneId;
            var city = objSmartFlexible.params.billingCity;
            var postcode = objSmartFlexible.params.billingPostcode;
            var address = objSmartFlexible.params.billingAddress;
            var whatToHide = [
                $('select[name="' + country_id + '"]').parents('.form-group, tr'),
                $('select[name="' + zone_id + '"]').parents('.form-group, tr'),
                $('input[name="' + city + '"]').parents('.form-group, tr'),
                $('input[name="' + postcode + '"]').parents('.form-group, tr'),
                $('textarea[name="' + address + '"]').parents('.form-group, tr'),
            ];
            objSmartFlexible.proceedHide.call(this, whatToHide, hideOn);
        },
        handlePackerChange: function() {
            // 3d
            var hideOn = [
              objSmartFlexible.params.packerIndividual,
              objSmartFlexible.params.packerWeightBased,
              objSmartFlexible.params.packerBoxMaker
            ];
            var whatToHide = [
                $('#standard-boxes-checked').parents('.form-group, tr'),
                $('#custom_packages_holder').parents('.form-group, tr'),
                $('#custom_envelopes_holder').parents('.form-group, tr'),
                $('#promo_holder').parents('.form-group, tr'),
                $('#shipping-categories').parents('.form-group, tr'),
                $('input[name="' + objSmartFlexible.params.fallbackPacker + '"]').parents('.checkbox')
            ];
            objSmartFlexible.proceedHide.call(this, whatToHide, hideOn);
            // individual
            hideOn = [
              objSmartFlexible.params.packer3dPacker,
              objSmartFlexible.params.packerWeightBased,
              objSmartFlexible.params.packerBoxMaker
            ];
            whatToHide = [
                $('input[name="' + objSmartFlexible.params.individualTare + '"]').parents('.form-group, tr')
            ];
            objSmartFlexible.proceedHide.call(this, whatToHide, hideOn);
            // weight based
            hideOn = [
              objSmartFlexible.params.packer3dPacker,
              objSmartFlexible.params.packerIndividual,
              objSmartFlexible.params.packerBoxMaker
            ];
            whatToHide = [
                $('input[name="' + objSmartFlexible.params.weightBasedLimit + '"]').parents('.form-group, tr'),
                $('input[name*="' + objSmartFlexible.params.weightBasedFakedBox + '"]').parents('.form-group, tr'),
            ];
            objSmartFlexible.proceedHide.call(this, whatToHide, hideOn);
            // box maker
            hideOn = [
              objSmartFlexible.params.packer3dPacker,
              objSmartFlexible.params.packerWeightBased,
              objSmartFlexible.params.packerIndividual
            ];
            whatToHide = [
              $('input[name*="' + objSmartFlexible.params.boxMakerLength + '"]').parents('.form-group, tr'),
              $('input[name="' + objSmartFlexible.params.boxMakerWidth + '"]').parents('.form-group, tr'),
              $('input[name="' + objSmartFlexible.params.boxMakerWeightLimit + '"]').parents('.form-group, tr'),
              $('input[name="' + objSmartFlexible.params.boxMakerMargin + '"]').parents('.form-group, tr')
            ];
            objSmartFlexible.proceedHide.call(this, whatToHide, hideOn);
        },
        handleLabelChange: function() {
            var hideOn = objSmartFlexible.params.labelDisabled;
            var label_format = objSmartFlexible.params.labelFormat;
            var tracking = objSmartFlexible.params.tracking;
            var trackingNotify = objSmartFlexible.params.trackingNotify;
            var country_id = objSmartFlexible.params.countryId;
            var zone_id = objSmartFlexible.params.zoneId;
            var city = objSmartFlexible.params.city;
            var address = objSmartFlexible.params.address;
            var postcode_dub = objSmartFlexible.params.postcodeDub;
            var sender_name = objSmartFlexible.params.senderName;
            var sender_company = objSmartFlexible.params.senderCompany;
            var sender_telephone = objSmartFlexible.params.senderTelephone;
            var fallback_country = objSmartFlexible.params.fallbackProductCountry;
            var fallback_zone = objSmartFlexible.params.fallbackProductZone;
            var fallback_hs_code = objSmartFlexible.params.fallbackProductHsCode;
            var balance_min = objSmartFlexible.params.balanceMin;
            var balance_inc = objSmartFlexible.params.balanceInc;
            var invoice = objSmartFlexible.params.invoice;
            var webhook = '#webhook-status, #webhook-url';
            var tab = $('#tab-ext-labels');
            var whatToHide = [
                $('select[name="' + label_format + '"]').parents('.form-group, tr'),
                $('select[name="' + tracking + '"]').parents('.form-group, tr'),
                $(tab).find('input[name="' + trackingNotify + '"]').parents('.form-group, tr'),
                $(tab).find('select[name="' + country_id + '"]').parents('.form-group, tr'),
                $(tab).find('select[name="' + zone_id + '"]').parents('.form-group, tr'),
                $(tab).find('input[name="' + city + '"]').parents('.form-group, tr'),
                $(tab).find('textarea[name="' + address + '"]').parents('.form-group, tr'),
                $(tab).find('input[name="' + postcode_dub + '"]').parents('.form-group, tr'),
                $(tab).find('input[name="' + sender_name + '"]').parents('.form-group, tr'),
                $(tab).find('input[name="' + sender_company + '"]').parents('.form-group, tr'),
                $(tab).find('input[name="' + sender_telephone + '"]').parents('.form-group, tr'),
                $(tab).find('select[name="' + fallback_country + '"]').parents('.form-group, tr'),
                $(tab).find('select[name="' + fallback_zone + '"]').parents('.form-group, tr'),
                $(tab).find('input[name="' + fallback_hs_code + '"]').parents('.form-group, tr'),
                $(tab).find('input[name="' + balance_min + '"]').parents('.form-group, tr'),
                $(tab).find('input[name="' + balance_inc + '"]').parents('.form-group, tr'),
                $(tab).find('input[name="' + invoice + '"]').parents('.form-group, tr'),
                $(tab).find(webhook).parents('.form-group, tr')
            ];
            objSmartFlexible.proceedHide.call(this, whatToHide, hideOn);
            hideOn = objSmartFlexible.params.labelManually;
            var tracking_immediately = objSmartFlexible.params.trackingImmediately;
            whatToHide = [
                $('option[value="' + tracking_immediately + '"]')
            ];
            objSmartFlexible.proceedHide.call(this, whatToHide, hideOn);
        },
        handleInvoiceChange: function() {
            var hideOn = '0';
            var paperless = objSmartFlexible.params.paperless;
            var whatToHide = [
                $('input[name="' + paperless + '"]').parents('.form-group, tr')
            ];
            objSmartFlexible.proceedHide.call(this, whatToHide, hideOn);
        },
        handleLabelFormatChange: function() {
            var hideOn = objSmartFlexible.params.labelOriginal;
            var pdf_converter = objSmartFlexible.params.pdfConverter;
            var whatToHide = [
                $('select[name="' + pdf_converter + '"]').parents('.form-group, tr')
            ];
            objSmartFlexible.proceedHide.call(this, whatToHide, hideOn);
        },
        handlePostcodeChange: function() {
            var name = objSmartFlexible.params.postcodeDub;
            $('input[name="' + name + '"]').val($(this).val());
        },
        handleCustomBoxChange: function() {
            var measureName = objSmartFlexible.params.measurementSystem;
            var row = $(this).parents('tr')[0];
            var data = {
                route: objSmartFlexible.params.currentRoute + '/tareofcustompackagefixed',
                length: $(row).find('input[name*="length"]').val(),
                width: $(row).find('input[name*="width"]').val(),
                height: $(row).find('input[name*="height"]').val(),
                measurement_system: $('select[name="' + measureName + '"]').val()
            };
            data[objSmartFlexible.params.tokenName] = objSmartFlexible.params.token;
            var handlerSuccess = function(tare) {
                $(row).find('input[name*="tare"]').attr('placeholder', tare);
            };
            var handlerError = function() {
                $(row).find('input[name*="tare"]').attr('placeholder', '');
            };
            $.ajax({
                url: objSmartFlexible.params.entryPoint,
                data: data,
                success: handlerSuccess,
                error: handlerError,
                dataType: 'text'
            });
        },
        handleCustomEnvelopeChange: function() {
            var measureName = objSmartFlexible.params.measurementSystem;
            var row = $(this).parents('tr')[0];
            var data = {
                route: objSmartFlexible.params.currentRoute + '/tareofcustompackageexpandable',
                length: $(row).find('input[name*="length"]').val(),
                width: $(row).find('input[name*="width"]').val(),
                measurement_system: $('select[name="' + measureName + '"]').val()
            };
            data[objSmartFlexible.params.tokenName] = objSmartFlexible.params.token;
            var handlerSuccess = function(tare) {
                $(row).find('input[name*="tare"]').attr('placeholder', tare);
            };
            var handlerError = function() {
                $(row).find('input[name*="tare"]').attr('placeholder', '');
            };
            $.ajax({
                url: objSmartFlexible.params.entryPoint,
                data: data,
                success: handlerSuccess,
                error: handlerError,
                dataType: 'text'
            });
        },
        handleInsuranceChange: function() {
            var whatToHide = [
                $('input[name="' + objSmartFlexible.params.insuranceFrom + '"]').parent(),
                $('#insurance_from_help')
            ];
            objSmartFlexible.proceedHide.call(this, whatToHide, objSmartFlexible.params.insuranceDisabled);
        },
        handleSignatureChange: function() {
            var whatToHide = [
                $('input[name="' + objSmartFlexible.params.signatureType + '"]').parent(),
                $('input[name="' + objSmartFlexible.params.proofOfAge + '"]').parent(),
                $('#signature-option-text')
            ];
            var hideOn = [objSmartFlexible.params.signatureNotRequired, objSmartFlexible.params.serviceDefault];
            objSmartFlexible.proceedHide.call(this, whatToHide, hideOn);
        },
        fetchServicesByCountry: function() {
            objSmartFlexible.servicesPromise = $.get(
                objSmartFlexible.params.entryPoint + '&route=' + objSmartFlexible.params.currentRoute +
                '/services&' + objSmartFlexible.params.tokenName + '=' + objSmartFlexible.params.token +
                '&country_id=' + $('select[name="' + objSmartFlexible.params.countryId + '"]').val() + '&store_id=' +
                objSmartFlexible.params.storeId, {},
                function(response) {
                    $('table.services').parent().html(response);
                }
            ).fail(function(xhr) {
                $('table.services').html('<tr><td><p class="error text-danger">' + xhr.responseText +
                '</p></td></tr>');
            });
        },
        fetchServicesByUser: function() {
            var userId = $('input[name="' + objSmartFlexible.params.userId + '"]');
            objSmartFlexible.servicesPromise = $.get(objSmartFlexible.params.entryPoint +
                '&route=' + objSmartFlexible.params.currentRoute + '/services&' + objSmartFlexible.params.tokenName +
                '=' + objSmartFlexible.params.token + (userId.length ? ('&user_id=' + userId.val()) : '') +
                '&store_id=' + objSmartFlexible.params.storeId, {},
                function(response, status) {
                    userId.parent().find('.error, .text-danger').remove();
                    $('table.services').parent().html(response);
                    objSmartFlexible.highlightTabsWithError();
                }
            ).fail(function(xhr) {
                userId.parent().find('.error, .text-danger').remove();
                $('table.services').html('<tr><td><p class="error text-danger">' + xhr.responseText +
                    '</p></td></tr>');
                userId.parent().append('<p class="error text-danger">' + xhr.responseText + '</p>');
                objSmartFlexible.highlightTabsWithError();
            });
        },
        mountWebhook: function() {
            var state = $('#webhook-status').removeClass();
            var userId = $('input[name="' + objSmartFlexible.params.userId + '"]');
            state.text('processing...');
            $.get(objSmartFlexible.params.entryPoint + '&route=' + objSmartFlexible.params.currentRoute +
                '/mountWebhook&' + objSmartFlexible.params.tokenName + '=' + objSmartFlexible.params.token +
                (userId.length ? ('&user_id=' + userId.val()) : ''), {},
                function(response, status) {
                    state.text(response.message);
                    state.toggleClass('error text-danger', response.error);
                }
            ).fail(function(xhr) {
                state.text(xhr.responseText);
                state.addClass('error text-danger');
            });
        },
        fetchZones: function() {
            $('select[name="' + objSmartFlexible.params.zoneId + '"]').parent().load(
                objSmartFlexible.params.entryPoint + '&route=' + objSmartFlexible.params.currentRoute +
                '/zone&' + objSmartFlexible.params.tokenName + '=' + objSmartFlexible.params.token + '&country_id=' +
                $('select[name="' + objSmartFlexible.params.countryId + '"]').val() + '&store_id=' +
                objSmartFlexible.params.storeId,
                function(response, status) {
                    if (status == 'error') {
                        $(this).html('');
                    }
                }
            );
        },
        fetchFallbackProductZones: function() {
            $('select[name="' + objSmartFlexible.params.fallbackProductZone + '"]').parent().load(
                objSmartFlexible.params.entryPoint + '&route=' + objSmartFlexible.params.currentRoute +
                '/fallbackproductzone&' + objSmartFlexible.params.tokenName + '=' + objSmartFlexible.params.token +
                '&country_id=' + $('select[name="' + objSmartFlexible.params.fallbackProductCountry + '"]').val() +
                '&store_id=' + objSmartFlexible.params.storeId,
                function(response, status) {
                    if (status == 'error') {
                        $(this).html('');
                    }
                }
            );
        },
        fetchBillingZones: function() {
            $('select[name="' + objSmartFlexible.params.billingZoneId + '"]').parent().load(
                objSmartFlexible.params.entryPoint + '&route=' + objSmartFlexible.params.currentRoute +
                '/billingzone&' + objSmartFlexible.params.tokenName + '=' + objSmartFlexible.params.token +
                '&country_id=' + $('select[name="' + objSmartFlexible.params.billingCountryId + '"]').val() +
                '&store_id=' + objSmartFlexible.params.storeId,
                function(response, status) {
                    if (status == 'error') {
                        $(this).html('');
                    }
                }
            );
        },
        fixDocumentHeight: function() { // Opera 12.16 fix
            var holder = $('#label');
            var img = holder.find('img');
            if (img.height() > holder.height()) {
                img.css('height', '100%');
            }
        },
        printFrame: function(id, fallbackUrl) {
            var frame = $('#document')[0];
            var fwindow = frame.contentWindow;
            fwindow.focus();
            try {
                fwindow.print();
            } catch (e) {
                alert('Your browser does not allow to print a window frame. ' +
                'So, press Cmd+P (Mac) or Ctrl+P (Windows) after closing this message');
                window.location = fallbackUrl;
            }
        },
        requestLabels: function(url, button) {
            var originalText = $(button).text();
            $(button).text('Requesting...').attr('disabled', true);
            var handleError = function(xhr, ajaxOptions, thrownError) {
                alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + (xhr.responseText ? xhr.responseText :
                    'Request was terminated'));
                $(button).text(originalText).attr('disabled', false);
            };
            var addHistory = function(entry, token, orderId, statusId, notify, comment, override, tokenName) {
                $.ajax({
                    url: entry + '&route=api/order/history&' + tokenName + '=' + token +
                    '&order_id=' + orderId,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        order_status_id: statusId,
                        notify: notify,
                        comment: comment,
                        override: override
                    },
                    success: function(json) {
                        if (json.error) {
                            alert(json.error);
                            $(button).text(originalText).attr('disabled', false);
                        }
                        if (json.success) {
                            window.location.reload(-1);
                        }
                    },
                    error: handleError
                });
            };
            var getToken = function(entry, key, username, password, cb) {
                $.ajax({
                    url: entry + '&route=api/login',
                    type: 'POST',
                    data: {
                        key: key,
                        username: username,
                        password: password
                    },
                    dataType: 'json',
                    success: function(json) {
                        if (json.error) {
                            if (json.error.key) {
                                alert(json.error.key);
                            }
                            if (json.error.ip) {
                                alert(json.error.ip)
                            }
                            $(button).text(originalText).attr('disabled', false);
                        }
                        if (json.token || json.cookie) {
                            $(button).text('Logging...');
                            cb(json.token);
                        } else {
                            alert('token or cookie expected');
                        }
                    },
                    error: handleError
                });
            };
            $.ajax({
                url: url,
                type: 'GET',
                dataType: 'json',
                success: function(json) {
                    if (json.error) {
                        alert(json.error);
                        $(button).text(originalText).attr('disabled', false);
                    }
                    if (json.next === 'redirect') {
                        window.location.reload(-1);
                    } else if (json.next === 'ajax') {
                        if (json.api_key || json.api_token || (json.api_username && json.api_password)) {
                            if (json.entry && json.order_id && json.history) {
                                var finalAction = function (token) {
                                    addHistory(
                                        json.entry, token, json.order_id, json.history.order_status_id,
                                        json.history.notify, json.history.comment, json.history.override,
                                        json.api_token ? 'api_token' : 'token'
                                    );
                                };
                                if (json.api_token) {
                                    finalAction(json.api_token);
                                } else {
                                    $(button).text('Token...');
                                    getToken(
                                        json.entry, json.api_key, json.api_username, json.api_password, finalAction
                                    );
                                }
                            } else {
                                alert('entry, order or history information missing');
                            }
                        } else {
                            alert('api credentials missing');
                        }
                    }
                },
                error: handleError
            });
        },
        getPackagingMapApplication: function() {
            /**
             * @author mrdoob / http://mrdoob.com/
             */
            return {
                Player: function() {
                    var loader = new THREE.ObjectLoader();
                    var raycaster = new THREE.Raycaster();
                    var camera, scene, renderer;
                    var box, mouse = {
                        x: 0, y: 0, isDown: false,
                        downX: 0, downY: 0,
                        rotatedY: 0, rotatedZ: 0,
                        vector: new THREE.Vector2()
                    };
                    var descriptor = $('#description');
                    this.dom = document.createElement('div');
                    this.width = 500;
                    this.height = 500;
                    this.load = function(json) {
                        try {
                            renderer = new THREE.WebGLRenderer({antialias: true});
                        } catch (e) {
                            descriptor.html(
                                '<strong>Error loading WebGL Renderer.</strong><br>' +
                                'Please read <a href="https://superuser.com/a/836833">this manual</a> ' +
                                'to solve this problem.<br><br>' +
                                'Original error message:<br>' +
                                '<em>' + e + '</em>'
                            ).show();
                            return false;
                        }
                        renderer.setClearColor(0x000000);
                        renderer.setPixelRatio(window.devicePixelRatio);
                        if (json.project.gammaInput) { renderer.gammaInput = true; }
                        if (json.project.gammaOutput) { renderer.gammaOutput = true; }
                        if (json.project.shadows) { renderer.shadowMap.enabled = true; }
                        this.dom.appendChild(renderer.domElement);
                        this.setScene(loader.parse(json.scene));
                        this.setCamera(loader.parse(json.camera));
                        box = scene.getObjectByName('Box');
                        document.addEventListener('mousemove', function(event) {
                            mouse.x = event.clientX;
                            mouse.y = event.clientY;
                            if (mouse.isDown) {
                                var rotateZ = mouse.rotatedZ + (mouse.downY - mouse.y) / 120;
                                var rotateY = mouse.rotatedY - (mouse.downX - mouse.x) / 120;
                                box.rotation.y = rotateY;
                                box.rotation.z = rotateZ;
                            }
                            mouse.vector.x = (mouse.x / window.innerWidth) * 2 - 1;
                            mouse.vector.y = -(mouse.y / window.innerHeight) * 2 + 1;
                            raycaster.setFromCamera(mouse.vector, camera);
                            var intersects = raycaster.intersectObjects(box.children);
                            if (intersects.length > 0 && !mouse.isDown) {
                                descriptor.html(intersects[0].object.userData.description);
                                descriptor.css('left', mouse.x + 'px');
                                descriptor.css('top', mouse.y + 'px');
                                descriptor.show();
                            } else {
                                descriptor.hide();
                            }
                        }, false);
                        document.body.addEventListener('mousedown', function(event) {
                            mouse.isDown = true;
                            mouse.downX = event.clientX;
                            mouse.downY = event.clientY;
                            mouse.rotatedY = box.rotation.y;
                            mouse.rotatedZ = box.rotation.z;
                        }, false);
                        document.body.addEventListener('mouseup', function(event) {
                            mouse.isDown = false;
                        }, false);
                        return true;
                    };

                    this.setCamera = function(value) {
                        camera = value;
                        camera.aspect = this.width / this.height;
                        camera.updateProjectionMatrix();
                        camera.lookAt(scene.position);
                    };

                    this.setScene = function(value) {
                        scene = value;
                    };

                    this.setSize = function(width, height) {
                        this.width = width;
                        this.height = height;
                        if (camera) {
                            camera.aspect = this.width / this.height;
                            camera.updateProjectionMatrix();
                        }
                        if (renderer) {
                            renderer.setSize(width, height);
                        }
                    };

                    var prevTime, request;
                    function animate(time) {
                        setTimeout(function() {
                            request = requestAnimationFrame(animate);
                            renderer.render(scene, camera);
                        }, 100);
                        prevTime = time;
                    }

                    this.play = function() {
                        request = requestAnimationFrame(animate);
                        prevTime = performance.now();
                    };

                    this.stop = function() {
                        cancelAnimationFrame(request);
                    };

                    this.dispose = function() {
                        var totalChildren = this.dom.children.length;
                        for (var i = 0; i < totalChildren; i++) {
                            this.dom.removeChild(this.dom.firstChild);
                        }
                        renderer.dispose();
                        camera = undefined;
                        scene = undefined;
                        renderer = undefined;
                    };
                }
            };
        }
    }
})(jQuery);
