<?php

class ControllerExtensionCron extends Controller {

	public function index() {

		if($this->config->get('crownjob_status')) {
			$this->load->language('extension/store_cart');
			$this->load->model('extension/store_cart');
			$this->load->model('extension/store_cart_products');
			$this->load->model('tool/image');
			$this->load->model('tool/upload');
			$data['text_image'] = $this->language->get('text_image');
			$data['text_price'] = $this->language->get('text_price');
			$data['text_total'] = $this->language->get('text_total');
			$data['text_product'] = $this->language->get('text_product');
			$data['text_model'] = $this->language->get('text_model');
			$data['text_quantity'] = $this->language->get('text_quantity');
			
			
			$storecart_crownjob_info = $this->model_extension_store_cart->geStoreCartCrownjob();
			if($this->config->get('crownjob_status')) {
				$unnotify_customers = $this->model_extension_store_cart->getStoreCartCustomers();
				if(!empty($unnotify_customers)) {
					$total_customers =0;
					foreach($unnotify_customers as $unnotify_customer) {
						$total_customers++;
						$storecart_info = $this->model_extension_store_cart->getOneStoreCartsByEmail($unnotify_customer['email']);
						
						$configdata = $this->config->get('crownjob_stores');
						$store_id = $this->model_extension_store_cart->getStoreId($storecart_info['storecart_id']);
						
						if (!empty($configdata[$store_id]['storecart_template_id'])) {
							$template_id = $configdata[$store_id]['storecart_template_id'];
						}else{
							$template_id =0;
						}

						if (!empty($configdata[$store_id]['cartimage_height'])) {
							$cartimage_height = $configdata[$store_id]['cartimage_height'];
						}else{
							$cartimage_height ='50px';
						}

						if (!empty($configdata[$store_id]['cartimage_width'])) {
							$cartimage_width = $configdata[$store_id]['cartimage_width'];
						}else{
							$cartimage_width ='50px';
						}

						if (!empty($configdata[$store_id]['duration'])) {
							$duration = $configdata[$store_id]['duration'];
						}else{
							$duration ='2';
						}

						if (!empty($configdata[$store_id]['emailgoes'])) {
							$emailgoes = $configdata[$store_id]['emailgoes'];
						}else{
							$emailgoes ='0';
						}
						
						$mailinfo = $this->model_extension_store_cart->getMailTemplate($template_id,$unnotify_customer['language_id']);
						/* Update 30  march */
						$this->load->model('localisation/language');
						$language_info = $this->model_localisation_language->getLanguage($unnotify_customer['language_id']);
						$language = new Language($language_info['code']);
						$language->load($language_info['code']);
						$language->load('extension/store_cart');
						$data['text_image'] = $language->get('text_image');
						$data['text_product'] = $language->get('text_product');
						$data['text_quantity'] = $language->get('text_quantity');
						$data['text_price'] = $language->get('text_price');
						$data['text_total'] = $language->get('text_total');
						$data['text_model'] = $language->get('text_model');
						/* Update 30  march */
						
						if($storecart_info && $mailinfo) {
							$couponinfo = $this->model_extension_store_cart->genratecoupon($storecart_info['storecart_id']);
							$find = array(
								'{store}',
								'{logo}',
								'{firstname}',
								'{lastname}',
								'{email}',
								'{telephone}',
								'{customer_id}',
								'{cart}',
								'{couponname}',
								'{couponcode}',
								'{coupondiscount}',
								'{coupondate_start}',
								'{coupondate_end}',
								'{type}',
								'{date_added}',
								'{grabnowlink}',
							);
							
							$carts_products = $this->model_extension_store_cart_products->getStoreCcartProducts($storecart_info['email']);
							
							$data['products'] = array();
							
							foreach($carts_products as $product) {

								if ($product['image']) {
									$image = $this->model_tool_image->resize($product['image'], $cartimage_width, $cartimage_height);
								} else {
									$image = '';
								}

								$option_data = array();
								foreach ($product['option'] as $option) {
									if ($option['type'] != 'file') {
										$value = $option['value'];
									} else {
										$upload_info = $this->model_tool_upload->getUploadByCode($option['value']);
										if ($upload_info) {
											$value = $upload_info['name'];
										} else {
											$value = '';
										}
									}

									$option_data[] = array(
										'name'  => $option['name'],
										'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value),
										'type'  => $option['type']
									);
								}
								
								// Display prices
								if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
									$price = $this->currency->format($this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')),$this->session->data['currency']);
								} else {
									$price = false;
								}

								// Display prices
								if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
									$total = $this->currency->format($this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')) * $product['quantity'],$this->session->data['currency']);
								} else {
									$total = false;
								}

								$coupon_info = $this->model_extension_store_cart->getCoupon($storecart_info['email']);
						if(!empty($coupon_info['name'])){
							$data['couponname'] = $coupon_info['name'];
						} else {
							$data['couponname'] = '';
						}
						
						
						if(!empty($coupon_info['code'])){
							$data['couponcode'] = $coupon_info['code'];
						} else {
							$data['couponcode'] = '';
						}
						
						if(!empty($coupon_info['discount'])){
							$data['coupondiscount'] = $coupon_info['discount'];
						} else {
							$data['coupondiscount'] = '';
						}
						
						if(!empty($coupon_info['date_start'])){
							$data['coupondate_start'] = $coupon_info['date_start'];
						} else {
							$data['coupondate_start'] = '';
						}
						
						if(!empty($coupon_info['date_end'])){
							$data['coupondate_end'] = $coupon_info['date_end'];
						} else {
							$data['coupondate_end'] = '';
						}
						
						
								$data['products'][] = array(
									'cart_id'   => $product['cart_id'],
									'thumb'     => $image,
									'name'      => $product['name'],
									'model'     => $product['model'],
									'option'    => $option_data,
									'recurring' => ($product['recurring'] ? $product['recurring']['name'] : ''),
									'quantity'  => $product['quantity'],
									'price'     => $price,
									'total'     => $total,
								);
								
								$cart_product = $product['name'];
							}
						
							if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/extension/customer_cart_products')) {
								$cart_html = $this->load->view($this->config->get('config_template') . '/template/extension/customer_cart_products', $data);
							} else {
								$cart_html = $this->load->view('extension/customer_cart_products', $data);
							}
							
							$replace = array(
								'store'     					=> $this->config->get('config_name'),
								'logo'      					=> "<img src='". HTTP_SERVER . 'image/' . $this->config->get('config_logo')."'/>",
								'firstname' 					=> $storecart_info['firstname'],
								'lastname' 	 					=> $storecart_info['lastname'],
								'email'           	  => $storecart_info['email'],
								'telephone' 					=> $storecart_info['telephone'],
								'customer_id' 				=> $storecart_info['customer_id'],
								'cart'					 			=> $cart_html,
								'couponname'					=> $data['couponname'],
								'couponcode'					=> $data['couponcode'],
								'coupondiscount'				=> $data['coupondiscount'],
								'coupondate_start'				=> $data['coupondate_start'],	
								'coupondate_end'				=> $data['coupondate_end'],
								'type' 								=> ucfirst($storecart_info['type']),
								'date_added' 					=> date($this->language->get('date_format_short'), strtotime($storecart_info['date_added'])),
								'grabnowlink' 	=> $this->url->link('extension/grabnow'). '&storecart_id='. base64_encode($storecart_info['storecart_id']),
							);
						$subject = str_replace($find, $replace, $mailinfo['subject']);

						$message = str_replace($find, $replace, $mailinfo['message']);
						
							$dayofreturn = $duration;
							$orderdate   = date('Y-m-d', strtotime($storecart_info['date_added']));
							$datesss     = strtotime("+".$dayofreturn." Day ", strtotime($orderdate));
							$expirydate  = date("Y-m-d", $datesss);
							$currentdate = date("Y-m-d");
							
							$i = 0;
							if(!empty($emailgoes)){
								$mail = $emailgoes;
							} else {
								$mail = 0;
							}
							
							$intmail = (int)$mail;
							$mailstatus = true;
							
							if($storecart_info['count_email_notify'] != 0 && $storecart_info['count_email_notify'] > $emailgoes){ 
								$mailstatus = false; 
							} 
							if($mailstatus && $currentdate > $expirydate){
								$mailstatus = false; 
							}
							if($mailstatus){
								$this->load->model('setting/setting');
								$from = $this->model_setting_setting->getSettingValue('config_email', $store_id);
								$storename = $this->model_setting_setting->getSettingValue('config_name', $store_id);
		
								if (!$from) {
									$from = $this->config->get('config_email');
								}
								
								if (!$storename) {
									$storename = $this->config->get('config_name');
								}
								
								$mail = new Mail($this->config->get('config_mail_engine'));
								$mail->parameter = $this->config->get('config_mail_parameter');
								$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
								$mail->smtp_username = $this->config->get('config_mail_smtp_username');
								$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
								$mail->smtp_port = $this->config->get('config_mail_smtp_port');
								$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
								
								$mail->setTo($storecart_info['email']);
								$mail->setFrom($from);
								$mail->setSender(html_entity_decode($storename, ENT_QUOTES, 'UTF-8'));
								$mail->setSubject($subject);
								$mail->setHtml(html_entity_decode($message));
								if(!empty($data['products'])) {
									$mail->send();
									$this->model_extension_store_cart->updateNotifyByEmail($storecart_info['email']);
								}
							}
						}
						
						if($storecart_info['telephone']){
							$crownjoburl = $this->config->get('crownjob_url');
							$crownjobsmsstatus =  $this->config->get('crownjob_smsstatus');
							$crownjobmethod =  $this->config->get('crownjob_smsmethod');
							
							if(isset($mailinfo['smsmessage'])){
								$smsmsg = $mailinfo['smsmessage'];
							} else {
								$smsmsg = '';
							}
							
							$cart_product = '';
							$smsmessage = strip_tags(html_entity_decode($smsmsg, ENT_QUOTES, 'UTF-8'));
							
							if(!empty($crownjobsmsstatus == 1 && $crownjobmethod == 1)){
								$find = array(
									'{store}',
									'{firstname}',
									'{lastname}',
									'{email}',
									'{telephone}',
									'{customer_id}',
									'{cart}',
									'{type}',
									'{date_added}',
									'{grabnowlink}',
								);

								$replace = array(
									'store'     					=> $this->config->get('config_name'),
									'logo'      					=> "<img src='". HTTP_SERVER . 'image/' . $this->config->get('config_logo')."'/>",
									'firstname' 					=> $storecart_info['firstname'],
									'lastname' 	 					=> $storecart_info['lastname'],
									'email'           	  			=> $storecart_info['email'],
									'telephone' 					=> $storecart_info['telephone'],
									'customer_id' 					=> $storecart_info['customer_id'],
									'cart'					 		=> $cart_product,
									'type' 							=> ucfirst($storecart_info['type']),
									'date_added' 					=> date($this->language->get('date_format_short'), strtotime($storecart_info['date_added'])),
								);
								
								$smsmessage = str_replace(array("\r\n", "\r", "\n"), '', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '', trim(str_replace($find, $replace, $smsmessage)))); 
								$dltid = $this->config->get('crownjob_dltid');	
									$find = array(
										'{mobileno}',
										'{message}',
										'{dltid}',
										'&amp;'
									);
								
									$replace = array(
										'mobileno' =>$storecart_info['telephone'],
										'message' =>$smsmessage,
										///new////
										'dltid' =>$dltid,
										///new////
										'&amp;' =>'&'
									);
											
								$format = str_replace(array("\r\n", "\r", "\n"), '', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '', trim(str_replace($find, $replace, $crownjoburl)))); 
										
						 	
								$url = $format;
								$ch = curl_init($url);
								curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
								curl_setopt($ch,CURLOPT_SSL_VERIFYPEER, 3);
								$curl_scraped_page = curl_exec($ch);
								curl_close($ch);
								//$this->log->write('Mobile No-'.$this->customer->getTelephone() . 'Message:-'.$format);
							}
						}
					}
					$this->model_extension_store_cart->updateStoreCartCrownJobTime();
				}
			}
			if(isset($total_customers)) {
				echo $total_customers.' Email Send!';
			}else{
				echo '0 Email Send!';
			}
		}else{
			echo 'Status Disabled!';
		}
	}
}
	