<?php
//-----------------------------------------
// Author: Qphoria@gmail.com
// Web: http://www.OpenCartGuru.com/
//-----------------------------------------
class ControllerExtensionPaymentMonerisAPI3Dv2 extends Controller {

	private $name = '';
	protected $errors = array();

//=====================================================================

	public function index() {

		# Generic Init
		$extension_type 			= 'extension/payment';
		$classname 					= str_replace('vq2-' . basename(DIR_APPLICATION) . '_' . strtolower(get_parent_class($this)) . '_' . str_replace('/', '_', $extension_type) . '_', '', basename(__FILE__, '.php'));
		$data['classname'] 			= $classname;
		$data['extension_type'] 	= $extension_type;
		$data 						= array_merge($data, $this->load->language($extension_type . '/' . $classname));

		# Order Info
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		# Error Check
		$data['error'] = (isset($this->session->data['error'])) ? $this->session->data['error'] : NULL;
		unset($this->session->data['error']);

		# Form Fields
		$data['action'] 			= 'index.php?route='.$extension_type.'/'.$classname.'/send';
		$data['form_method'] 		= 'post';
		$data['fields']   			= array();

		### START SPECIFIC DATA ###


		# Data Fields array - Could be included from external file
		$card_types['visa'] = 'Visa';
		$card_types['mastercard'] = 'MasterCard';
		$card_types['amex'] = 'American Express';
		$card_types['discover'] = 'Discover';

		$data['fields'][] = array(
			'entry'			=> $this->language->get('entry_card_type'),
			'type'			=> 'select',
			'name'			=> 'card_type',
			'value'			=> '',
			'param'			=> 'style="width:200px;display:inline-block;"',
			'required'		=> '1',
			'options'		=> $card_types,
			'help'			=> '',
		);

		$data['fields'][] = array(
			'entry'			=> $this->language->get('entry_card_name'),
			'type'			=> 'text',
			'placeholder' 	=> 'First Last',
			'name'			=> 'card_name',
			'value'			=> '',
			'size'			=> '50',
			'param'			=> 'style="width:200px;"',
			'required'		=> '1',
			'validate'  	=> ''
		);

		$data['fields'][] = array(
			'entry'			=> $this->language->get('entry_card_num'),
			'type'			=> 'text',
			'placeholder' 	=> 'xxxx-xxxx-xxxx-xxxx',
			'name'			=> 'card_num',
			'value'			=> '',
			'size'			=> '50',
			'param'			=> 'style="width:200px;"',
			'required'		=> '1',
			'validate'  	=> 'creditcard'
		);

		$months = array();
		for($i=1;$i<=12;$i++) {
			$months[sprintf("%02d", $i)] = sprintf("%02d", $i);
		}

		$data['fields'][] = array(
			'entry'			=> $this->language->get('entry_card_exp'),
			'type'			=> 'select',
			'name'			=> 'card_mon',
			'value'			=> '',
			'param'			=> 'style="width:95px;display:inline-block;"',
			'required'		=> '1',
			'no_close'		=> '1',
			'options'		=> $months,
			'help'			=> '/',
		);

		$years = array();
		for($i=0;$i<=10;$i++) {
			$years[date('Y', strtotime('+'.$i.'year'))] = date('Y', strtotime('+'.$i.'year'));
		}

		$data['fields'][] = array(
			'entry'			=> '/',
			'type'			=> 'select',
			'name'			=> 'card_year',
			'value'			=> '',
			'param'			=> 'style="width:95px;display:inline-block;"',
			'required'		=> '1',
			'no_open'		=> '1',
			'options'		=> $years,
			'validate'		=> 'expiry'
		);

		$data['fields'][] = array(
			'entry'			=> $this->language->get('entry_card_cvv'),
			'type'			=> 'text',
			'placeholder' 	=> '3 to 4 digit code',
			'name'			=> 'card_cvv',
			'value'			=> '',
			'size'			=> '50',
			'param'			=> 'style="width:95px;"',
			'required'		=> '1',
		);

		$test_accounts = array(
			'store1',
			'store2',
			'store3',
			'store5',
			'monusqa002'
		);

		// Currency based override
		$c = $this->session->data['currency'];
		$all_settings = $this->db->query("SELECT `key`, `value` FROM " . DB_PREFIX . "setting WHERE code = '" . $classname . "'");
		foreach ($all_settings->rows as $row) {
			if (strpos($row['key'], "_$c") !== false) {
				$this->config->set(str_replace("_$c", "", $row['key']), $row['value']);
			}
		}

		$data['testmode'] 		= (in_array($this->config->get($classname . '_mid'), $test_accounts)) ? TRUE : FALSE;

		### END SPECIFIC DATA ###

		# Compatibility
		if (version_compare(VERSION, '2.2', '>=')) { // v2.2.x Compatibility
			if (version_compare(VERSION, '3.0', '>=')) { // v3.x Compatibility to support twig and tpl files
				$template_file = (DIR_TEMPLATE . str_replace('theme_', '', $this->config->get('config_theme')) . '/template/' . $extension_type . '/' .$classname.'.twig');
				if (is_file($template_file)) {
					return $this->load->view($extension_type . '/' .$classname, $data);
				} else {
					$temp_file = ('/template/' . $extension_type . '/'. $classname . '.tpl');
					if (file_exists(DIR_TEMPLATE . str_replace('theme_', '', $this->config->get('config_theme')) . $temp_file)) {
						$template_file = (DIR_TEMPLATE . str_replace('theme_', '', $this->config->get('config_theme')) . $temp_file);
					} else {
						$template_file = (DIR_TEMPLATE . 'default' . $temp_file);
					}
					extract($data);
					ob_start();
					if (class_exists('VQMod')) { require(VQMod::modCheck(modification($template_file), $template_file)); } else { require(modification($template_file)); }
					return ob_get_clean();
				}
			} else { // v2.2.x Compatibility
				return $this->load->view($extension_type . '/'. $classname, $data);
			}
		} elseif (version_compare(VERSION, '2.0', '>=')) { // v2.0.x Compatibility
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/' . $extension_type . '/'. $classname . '.tpl')) {
				return $this->load->view($this->config->get('config_template') . '/template/' . $extension_type . '/'. $classname . '.tpl', $data);
			} else {
				return $this->load->view('default/template/' . $extension_type . '/'. $classname . '.tpl', $data);
			}
		} elseif (version_compare(VERSION, '2.0', '<')) {  // 1.5.x Backwards Compatibility
			$this->data = array_merge($this->data, $data);
			$this->id 	= 'extension/payment';
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/' . $classname . '.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/payment/' . $classname . '.tpl';
			} else {
				$this->template = 'default/template/payment/' . $classname . '.tpl';
			}
        	$this->render();
		}
	}

//  FAIL =====================================================================

	private function fail($msg = false) {
		$failurl = $this->url->link('checkout/cart');
		if (!$msg) { $msg = (!empty($this->session->data['error']) ? $this->session->data['error'] : 'Unknown Error'); }
		echo '<html><head><script type="text/javascript">';
		echo 'alert("'.addslashes($msg).'");';
		echo 'window.location="' . $failurl . '";';
		echo '</script></head></html>';
		exit;
	}

//  SEND  =====================================================================

	public function send() {
				
		# Generic Init
		$extension_type = 'extension/payment';
		$classname = str_replace('vq2-' . basename(DIR_APPLICATION) . '_' . strtolower(get_parent_class($this)) . '_' . str_replace('/', '_', $extension_type) . '_', '', basename(__FILE__, '.php'));
		$data['classname'] = $classname;
		$data = array_merge($data, $this->load->language($extension_type . '/' . $classname));
				
		$json = array();

		# Card Check
		$errornumber = '';
		$errortext = '';
		if (!$this->checkCreditCard ($_POST['card_num'], $_POST['card_type'], $_POST['card_cvv'], $_POST['card_mon'], $_POST['card_year'], $errornumber, $errortext)) {
			$json['error'] = $errortext;
			$this->response->addHeader('Content-Type: application/json');
			$this->response->setOutput(json_encode($json));
			return;
		}

		// Moneris doesn't properly prevent accidental double clicks so try to prevent double payments here.
		if (isset($this->session->data['moneris_api_last_submit'])) {
			$time_passed = round(microtime(true) * 1000) - $this->session->data['moneris_api_last_submit'];
			if ($time_passed < 10000) {
				$json['error'] = "Current transaction is processing...";
				$this->response->addHeader('Content-Type: application/json');
				$this->response->setOutput(json_encode($json));
				return;
			} else {
				$this->session->data['moneris_api_last_submit'] = round(microtime(true) * 1000);
			}
		} else {
			$this->session->data['moneris_api_last_submit'] = round(microtime(true) * 1000);
		}

		# Order Info
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		### START SPECIFIC DATA ###

		// Currency based override
		$c = $currency = $this->session->data['currency'];
		$all_settings = $this->db->query("SELECT `key`, `value` FROM " . DB_PREFIX . "setting WHERE code = '" . $classname . "'");
		foreach ($all_settings->rows as $row) {
			if (strpos($row['key'], "_$c") !== false) {
				$this->config->set(str_replace("_$c", "", $row['key']), $row['value']);
			}
		}

		$amount = (string)number_format(str_replace(array(','), '', $this->currency->format($order_info['total'], $currency, FALSE, FALSE)), 2, '.', '');

		$store_id 		= trim($this->config->get($classname . '_mid'));
		$api_token 		= trim($this->config->get($classname . '_key'));
		$orderId 		= $this->session->data['order_id'];
		$crypt			= '7'; // default

		$subDigits = 2; // 0 means all 4 or 2 means just the last 2

		//if ($this->config->get($classname . '_country') == 'US') {
		if (strpos($this->config->get($classname . '_mid'), 'monus') !== false) {
			$country = 'US';
		} else { //CA
			$country = 'CA';
		}

		$test_accounts = array(
			'store1',
			'store2',
			'store3',
			'store5',
			'monusqa002'
		);
		$testmode 		= (in_array($this->config->get($classname . '_mid'), $test_accounts)) ? TRUE : FALSE;

		$xdata = array(
			'order_id' => 'tmp-'.$orderId,
			'card_num' => $_POST['card_num'],
			'amount' => $amount,
			'card_cvv' => $_POST['card_cvv'],
			'testmode' => $testmode,
			'expiry' => (substr($_POST['card_year'], $subDigits).$_POST['card_mon']), //YYMM
			'cavv' => '',
			'crypt' => $crypt,
			'country' => $country
		);
		

		$clientOrderId = "";
		$cvdavscheck = "";
		$CCMessage = "";

		// Start mpgClasses universal method
		require DIR_SYSTEM . 'library/payment/moneris/mpgClasses3Dv2.php';

        $showVerify3dResponseError = false;

		// This is ignored when 3D Secure setting is turned off
		if ($this->config->get($classname . '_threeDS')) {
			$verify3d = $this->check3DEnrollment($xdata);

			if ($verify3d->getMpiMessage() == 'Y') {
				//$vbvInLineForm = $verify3d->getMpiInLineForm();
				//$json['html'] = $vbvInLineForm;
				$json = array();
				$json['ACSURL'] = $verify3d->getMpiAcsUrl();
				$json['PaReq'] = $verify3d->getMpiPaReq();
				$json['MD'] = $verify3d->getMpiMD();
				$json['TermUrl'] = $verify3d->getMpiTermUrl();
				
				$this->response->addHeader('Content-Type: application/json');
				$this->response->setOutput(json_encode($json));
				$this->response->output();
				exit();
			} elseif ($verify3d->getMpiMessage() == 'U') { // Unable to verify
				// merchant assumes liability for charge back if continuing (usu. corporate cards)
				$crypt='7';
				if ($this->config->get($classname . '_threeDS_failed_redirect')) {
					//$this->response->redirect($this->config->get($classname . '_threeDS_failed_redirect'));
					$json['success'] = str_replace("&amp;", "&", $this->config->get($classname . '_threeDS_failed_redirect'));
					$this->response->addHeader('Content-Type: application/json');
					$this->response->setOutput(json_encode($json));
					return;
				}
			} else { // N (not enrolled)
				// merchant is not liable for chargeback (attempt was made but card holder is not enrolled)
				$crypt='6';
				if ($showVerify3dResponseError) {
                    $json['error'] = $verify3d->getMpiMessage();
                    $this->response->addHeader('Content-Type: application/json');
                    $this->response->setOutput(json_encode($json));
                    return;
                } elseif ($this->config->get($classname . '_threeDS_not_enrolled_redirect')) {
					//$this->response->redirect($this->config->get($classname . '_threeDS_not_enrolled_redirect'));
					$json['success'] = str_replace("&amp;", "&", $this->config->get($classname . '_threeDS_not_enrolled_redirect'));
					$this->response->addHeader('Content-Type: application/json');
					$this->response->setOutput(json_encode($json));
					return;
				}
			}
		}
		
		$message = '';
		
		// Do AVS/CVD check - Run an Auth only to check for AVS/CVD result
		if ($this->config->get($classname . '_efraud')) {
			
			$payment_type = 'card_verification';
						
			$custId 		= $order_info['customer_id'];
			
			$txnArray=array(
				'type'					=> $payment_type,
				'order_id'				=> 'tmp-'.$order_info['order_id'],
				'cust_id'				=> $custId,
				'pan'					=> $xdata['card_num'],
				'crypt_type' 			=> '7',
				'expdate'				=> $xdata['expiry'] //YYMM
			);

			$avsArray = array(
				'avs_street_number' => preg_replace("/[^\d]/", "", $order_info['payment_address_1']),
				'avs_street_name'	=> trim(preg_replace("/[\d]/", "", $order_info['payment_address_1'])),
				'avs_zipcode' 		=> $order_info['payment_postcode']
			);

			$cvdArray = array(
				'cvd_indicator' => '1',
				'cvd_value' => $xdata['card_cvv']
			);

			$mpgTxn = new mpgTransaction($txnArray);
			
			//$mpgAvsInfo = new mpgAvsInfo ($avsArray);
			//$mpgCvdInfo = new mpgCvdInfo ($cvdArray);
			
			
			if ($this->config->get($classname . '_efraud')) {
				$mpgTxn->setCvdInfo($cvdArray);
				$mpgTxn->setAvsInfo($avsArray);
				//$mpgTxn->setCvdInfo($mpgAvsInfo);
				//$mpgTxn->setAvsInfo($mpgCvdInfo);
			}

			$mpgRequest = new mpgRequest($mpgTxn);
			$mpgRequest->setProcCountryCode($country); //"CA" for sending transaction to Canadian environment
			if ($testmode) {
				$mpgRequest->setTestMode(true);
			}

			if ($this->config->get($classname . '_debug')) {
				$mpgHttpPost  	= new mpgHttpsPost($store_id,$api_token,$mpgRequest, DIR_LOGS . $classname . '_debug.txt');
			} else {
				$mpgHttpPost  	= new mpgHttpsPost($store_id,$api_token,$mpgRequest, False);
			}
			$mpgResponse	= $mpgHttpPost->getMpgResponse();
			$responseCode	= $mpgResponse->getResponseCode();
			
			// Debug
			if ($this->config->get($classname . '_debug')) {
				file_put_contents(DIR_LOGS . $classname . '_debug.txt', 'card_verification' . "\r\nmpgResponse = " . print_r($mpgResponse,1) . "\r\n responseCode = $responseCode \r\n----------------\r\n", FILE_APPEND);
			}
			
			$ReferenceNum = $mpgResponse->getReferenceNum();
			$AuthCode = $mpgResponse->getAuthCode();
			$ISO = $mpgResponse->getISO();
			$captureCardType = $mpgResponse->getCardType();
			$TransType = $mpgResponse->getTransType();
			$TxnNumber = $mpgResponse->getTxnNumber();
			
			//TESTING 
			/*
			echo "1===IN-AAAA<br>";
			echo "2===".$orderId."<br>";
			echo "3===".$_POST['card_num']."<br>";
			echo "4===".$_POST['card_cvv']."<br>";
			echo "5===".$amount."<br>";
			echo "6===".$testmode."<br>";
			//echo "ReceiptId===".$ReceiptId."<br>";
			echo "captureCardType===".$captureCardType."<br>";			
			echo "responseCode===".$responseCode."<br>";
			echo "cvd===".$cvdResultCode."<br>";			
			echo "avs===".$avsResultCode."<br>";			
			echo "cavvResultCode===".$cavvResultCode."<br>";			
			echo "ISO===".$ISO."<br>";			
			//echo '<pre>'; print_r($capturePayment); echo '</pre>';	
			*/

			//echo "cvd===".$cvdResultCode."<br>";			
			//echo "avs===".$avsResultCode."<br>";		

			// DO ALL AVS AND CVD CHECKS HERE -  Save and Send Msg
			$json['error'] = false;
			$cvdavscheck = "";
			$clientOrderId = "";
			$CCMessage = "";
			if (empty($responseCode) || $responseCode >= 50) {
				$json['error'] = $mpgResponse->getMessage();
				$CCMessage = "Improper Response Code";
			} else {
				
				$cvdResultCode = preg_replace('/[0-9]+/', '', $mpgResponse->getCvdResultCode() );
				$avsResultCode = $mpgResponse->getAvsResultCode();
										
				// 1. CVV Check
				if ($cvdResultCode == "M" ) {
					$cvdavscheck = "S";
				} else if ($cvdResultCode == "Y") {
					if ($captureCardType == "AX") 				
						$cvdavscheck = "S";
					else
						$cvdavscheck = "N";
				} else if ($cvdResultCode == "P") {
					$cvdavscheck = "N";
				} else {
					$cvdavscheck = "F";
				}
		
				// 2. Address Check - only if CVV is good
				if ($cvdavscheck == "S") {
					// Y - good for all
					if ($avsResultCode != "Y") {
						if ($avsResultCode == "A" || $avsResultCode == "N" || $avsResultCode == "Z") {
							$cvdavscheck = "F";
						} else if ($avsResultCode == "R" || $avsResultCode == "U") {
							$cvdavscheck = "N";
						} else {
							// Visa
							if ($captureCardType == "V") {
								if ($avsResultCode == "D" || $avsResultCode == "M") {
									$cvdavscheck = "S";
								} else if ($avsResultCode == "B" || $avsResultCode == "C" || $avsResultCode == "P") {
									$cvdavscheck = "I";
								} else  {
									$cvdavscheck = "N";
								}
							}
							// Mastercard /Discover
							else if ($captureCardType == "M" || $captureCardType == "NO") {
								if ($avsResultCode == "T") {
									$cvdavscheck = "F";
								} else  {
									$cvdavscheck = "N";
								}
							}
							// Amex
							else if ($captureCardType == "AX") {
								if ($avsResultCode == "M") {
									$cvdavscheck = "S";
								} else if ($avsResultCode == "E" || $avsResultCode == "F" || $avsResultCode == "L" || $avsResultCode == "O") {
									$cvdavscheck = "F";
								} else  {
									$cvdavscheck = "N";
								}
							} else  {
									$cvdavscheck = "N";
							} // end if - CC type
						}
					} // end Y check - all good
				} // end address check


				// Do Fail Message
				if ($cvdavscheck == "F") {
                    $CCMessage = "Name, Address, or CVV code is incorrect.";
				    $json['error'] = $CCMessage;
				} else if ($cvdavscheck == "I") {
					$CCMessage = "Address is in an Invalid Format.";
                    $json['error'] = $CCMessage;
				} else if ($cvdavscheck == "N") {
					$CCMessage = "Transaction Not Processed. Address did not match. Try Again or disable eFraud checks.";
                    $json['error'] = $CCMessage;
				}
			} // end if responsecode < 50
				
			if ($cvdavscheck == "S") {
				// Get Client Order ID on Success
				$CCMessage = "Success";
				$newOrderPrefix = substr(str_shuffle(str_repeat("ABCDEFGHIJKLMNOPQRSTUVWYZ123456789", 2)), 0, 8);
				$clientOrderId = $newOrderPrefix."-".$orderId;
			} 
			$this->session->data['clientOrderId'] = $clientOrderId;		
			
			// AVS/CVD Fail 
			if ($json['error']) {
				$this->response->addHeader('Content-Type: application/json');
				$this->response->setOutput(json_encode($json));
				return;
			}
		}		
	
//For testing only
//$json['error'] = 'stop here before capture';
//$this->response->addHeader('Content-Type: application/json');
//$this->response->setOutput(json_encode($json));
//return;
		
		
		//Capture the payment
		$capturePayment	= $this->capturePayment($xdata);
		$responseCode = $capturePayment->getResponseCode();
		$message = $capturePayment->getMessage();
		//exit('--- ' . $responseCode . ' --- ' . $message . ' ---');
		
		$ReferenceNum = $capturePayment->getReferenceNum();
		$AuthCode = $capturePayment->getAuthCode();
		$ISO = $capturePayment->getISO();
		$captureCardType = $capturePayment->getCardType();
		$responseCode = $capturePayment->getResponseCode();
		$TransType = $capturePayment->getTransType();
		$TxnNumber = $capturePayment->getTxnNumber();
		$cvdResultCode = preg_replace('/[0-9]+/', '', $capturePayment->getCvdResultCode() );
		$avsResultCode = $capturePayment->getAvsResultCode();
		$cavvResultCode = $capturePayment->getCavvResultCode();

/*
		$this->db->query("UPDATE " . DB_PREFIX . "order SET 
			clientOrderId = '" . $this->db->escape($clientOrderId) . "', 
			ReferenceNum = '" . $this->db->escape($ReferenceNum) . "',  
			CardType = '" . $this->db->escape($captureCardType) . "',  
			ResponseCode = '" . (int)$responseCode . "',  
			ISO = '" . $this->db->escape($ISO) . "',  
			AuthCode = '" . $this->db->escape($AuthCode) . "',  
			TransType = '" . (int)$TransType . "',  
			TxnNumber = '" . $this->db->escape($TxnNumber) . "',  
			cvdResult = '" . $this->db->escape($cvdResultCode) . "',  
			avsResult  = '" . $this->db->escape($avsResultCode) . "',  
			cavvResult = '" . $this->db->escape($cavvResultCode) . "', 
			CCMessage = '" . $this->db->escape($CCMessage) . "' 
			WHERE order_id = '" . (int)$orderId . "'");				
*/
		
		if ($responseCode == 'null' || empty($responseCode) || $responseCode > 50) {
			$json['error'] = $capturePayment->getMessage();
		} else {
			$json['success'] = $this->url->link('checkout/success');
		}		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));

	}

//  3D SECURE STUFF ================================================================

	private function check3DEnrollment($data = array()) {

		# Generic Init
		$extension_type = 'extension/payment';
		$classname = str_replace('vq2-' . basename(DIR_APPLICATION) . '_' . strtolower(get_parent_class($this)) . '_' . str_replace('/', '_', $extension_type) . '_', '', basename(__FILE__, '.php'));
		$store_id 		= trim($this->config->get($classname . '_mid'));
		$api_token 		= trim($this->config->get($classname . '_key'));
		
		if ($this->config->get($classname . '_country') == 'US') {
			$country = 'US';
            $payment_type = 'us_cavv_purchase';
		} else { //CA
			$country = 'CA';
            $payment_type = 'cavv_purchase';
		}
		
		$xid =sprintf("%'920d", rand());
		$HTTP_ACCEPT = getenv("HTTP_ACCEPT");
		$HTTP_USER_AGENT = getenv("HTTP_USER_AGENT");
        $payment_type = 'txn'; // for testing
		$data['amount'] = '1.00';
		$txnArray=array(
			'type'					=> $payment_type,
			'xid'					=> $xid,
			'amount'				=> $data['amount'],
			'pan'					=> $data['card_num'],
			'expdate'				=> $data['expiry'], //YYMM
			'merchantUrl'			=> $this->url->link($extension_type . '/' . $classname . '/acsReturn', '', 'SSL'),
			'accept'				=> $HTTP_ACCEPT,
			'userAgent'				=> $HTTP_USER_AGENT,
			'MD'					=> "pan=" . $data['card_num'] . "&amp;country=" . $data['country'] . "&amp;order_id=" . $data['order_id'] . "&amp;testmode=" . $data['testmode'] . "&amp;cvv=" . $data['card_cvv'] . "&amp;expiry=". $data['expiry'] . "&amp;amount=" . $data['amount'] . "&amp;xid=" . $xid
		);

		$mpgTxn = new mpgTransaction($txnArray);

		$mpgRequest = new mpgRequest($mpgTxn);
		$mpgRequest->setProcCountryCode($country); //"CA" for sending transaction to Canadian environment
		if ($data['testmode']) {
			$mpgRequest->setTestMode(true);
		}

		if ($this->config->get($classname . '_debug')) {
			$mpgHttpPost  	= new mpgHttpsPost($store_id,$api_token,$mpgRequest, DIR_LOGS . $classname . '_debug.txt');
		} else {
			$mpgHttpPost  	= new mpgHttpsPost($store_id,$api_token,$mpgRequest, False);
		}
		$mpgResponse	= $mpgHttpPost->getMpgResponse();
		$responseCode	= $mpgResponse->getResponseCode();

		// Debug
		if ($this->config->get($classname . '_debug')) {
			file_put_contents(DIR_LOGS . $classname . '_debug.txt', __FUNCTION__ . "\r\nmpgResponse = " . print_r($mpgResponse,1) . "\r\n responseCode = $responseCode \r\n----------------\r\n", FILE_APPEND);
		}

		return $mpgResponse;
	}

	public function acsReturn() {
	
		# Generic Init
		$extension_type = 'extension/payment';
		$classname = str_replace('vq2-' . basename(DIR_APPLICATION) . '_' . strtolower(get_parent_class($this)) . '_' . str_replace('/', '_', $extension_type) . '_', '', basename(__FILE__, '.php'));
		
		// Currency based override
		$c = $currency = $this->session->data['currency'];
		$all_settings = $this->db->query("SELECT `key`, `value` FROM " . DB_PREFIX . "setting WHERE code = '" . $classname . "'");
		foreach ($all_settings->rows as $row) {
			if (strpos($row['key'], "_$c") !== false) {
				$this->config->set(str_replace("_$c", "", $row['key']), $row['value']);
			}
		}
		
		$store_id 		= trim($this->config->get($classname . '_mid'));
		$api_token 		= trim($this->config->get($classname . '_key'));
		
		// Debug
		if ($this->config->get($classname . '_debug')) {
			file_put_contents(DIR_LOGS . $classname . '_debug.txt', __FUNCTION__ . "\r\n-------\r\nGET: " . print_r($_GET,1) . "\r\nPOST: " . print_r($_POST,1) . "\r\n", FILE_APPEND);
		}
		
		// MPI stuff
		$PaRes = $_POST['PaRes'];
		$MD = $_POST['MD'];
		$txnArray=array(
			'type' => 'acs',
			'PaRes' => $PaRes,
			'MD' => $MD
		);
		
		parse_str($MD, $mdarr);
		
		$testmode = $mdarr['testmode'];
		$country = $mdarr['country'];
		
		// Start mpgClasses universal method
		require DIR_SYSTEM . 'library/payment/moneris/mpgClasses3Dv2.php';

		$mpgTxn = new mpgTransaction($txnArray);

		$mpgRequest = new mpgRequest($mpgTxn);
		$mpgRequest->setProcCountryCode($country); //"CA" for sending transaction to Canadian environment
		if ($testmode) {
			$mpgRequest->setTestMode(true);
		}

		if ($this->config->get($classname . '_debug')) {
			$mpgHttpPost  	= new mpgHttpsPost($store_id,$api_token,$mpgRequest, DIR_LOGS . $classname . '_debug.txt');
		} else {
			$mpgHttpPost  	= new mpgHttpsPost($store_id,$api_token,$mpgRequest, False);
		}
		$mpgResponse	= $mpgHttpPost->getMpgResponse();
		$responseCode	= $mpgResponse->getResponseCode();

		// Debug
		if ($this->config->get($classname . '_debug')) {
			file_put_contents(DIR_LOGS . $classname . '_debug.txt', __FUNCTION__ . "\r\nmpgResponse = " . print_r($mpgResponse,1) . "\r\n responseCode = $responseCode \r\n----------------\r\n", FILE_APPEND);
		}		
		
		$xdata = array(
			'order_id' => $mdarr['order_id'],
			'card_num' => $mdarr['pan'],
			'amount' => $mdarr['amount'],
			'card_cvv' => $mdarr['cvv'],
			'testmode' => $mdarr['testmode'],
			'country' => $mdarr['country'],
			'expiry' => $mdarr['expiry'], //YYMM
			'cavv' => $mpgResponse->getMpiCavv(),
			'crypt' => $mpgResponse->getMpiEci()
		);

//TESTING 
/*
$t1=$mpgResponse->getMpiCavv();
$t2=$mpgResponse->getMpiEci();
echo "1===IN-BBBB<br>";
echo "2===".$mdarr['cvv']."<br>";
echo "3===".$t1."<br>";
echo "4===".$t2."<br>";
echo "5===".$mdarr['pan']."<br>";
echo "6===".$mdarr['order_id']."<br>";
echo '<pre>'; print_r($xdata); echo '</pre>';
exit;
*/
		
		//Capture the payment
		//if ($mpgResponse->getMpiSuccess() == 'true') {
		if ($mpgResponse->getMpiMessage() == 'Y') {
			$capturePayment	= $this->capturePayment($xdata);
			$responseCode = $capturePayment->getResponseCode();
			if ($capturePayment->getResponseCode() < 50) {
				$this->response->redirect($this->url->link('checkout/success'));
			} else {
				$this->session->data['error'] = $capturePayment->getMessage();
				$this->response->redirect($this->url->link('checkout/cart', '', true));
			}
		} else { // N
			$this->session->data['error'] = '3D Secure Verification Failed. Please try again.';
			$this->response->redirect($this->url->link('checkout/cart', '', true));
		}
	}

//  capturePayment  ================================================================

	private function capturePayment($data = array()) {

		# Generic Init
		$extension_type = 'extension/payment';
		$classname = str_replace('vq2-' . basename(DIR_APPLICATION) . '_' . strtolower(get_parent_class($this)) . '_' . str_replace('/', '_', $extension_type) . '_', '', basename(__FILE__, '.php'));
		$store_id 		= trim($this->config->get($classname . '_mid'));
		$api_token 		= trim($this->config->get($classname . '_key'));

		# Order Info
        $data['order_id'] = str_replace('tmp-', '', $data['order_id']);
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($data['order_id']);

		$custId 		= $order_info['customer_id'];
		$testmode = $data['testmode'];
		$country  = $data['country'];
		
		### START SPECIFIC DATA ###

		// Currency based override
		$c = $currency = $this->session->data['currency'];
		$all_settings = $this->db->query("SELECT `key`, `value` FROM " . DB_PREFIX . "setting WHERE code = '" . $classname . "'");
		foreach ($all_settings->rows as $row) {
			if (strpos($row['key'], "_$c") !== false) {
				$this->config->set(str_replace("_$c", "", $row['key']), $row['value']);
			}
		}

		$amount = (string)number_format(str_replace(array(','), '', $this->currency->format($order_info['total'], $currency, FALSE, FALSE)), 2, '.', '');

		if ($this->config->get($classname . '_country') == 'US') { // US
			if ($this->config->get($classname . '_efraud')) {
				if ($this->config->get($classname . '_txntype') == 'auth') {
					$payment_type = 'cavv_preauth';
				} else {
					$payment_type = 'cavv_purchase';
				}
			} else {
				if ($this->config->get($classname . '_txntype') == 'auth') {
					$payment_type = 'cavv_preauth';
				} else {
					$payment_type = 'cavv_purchase';
				}
			}
		} else { //  Non-US
			if ($this->config->get($classname . '_efraud')) {
				if ($this->config->get($classname . '_txntype') == 'auth') {
					$payment_type = 'preauth';
				} else {
					$payment_type = 'purchase';
				}
			} else {
				if ($this->config->get($classname . '_txntype') == 'auth') {
					$payment_type = 'preauth';
				} else {
					$payment_type = 'purchase';
				}
			}
		}

		// Remove cavv prefix is not a cavv based purchase
		if (!$data['cavv']) {
			$payment_type = str_replace('cavv_', '', $payment_type);
		}

		$txnArray=array(
			'type'					=> $payment_type,
			'order_id'				=> 'tmp-'.$order_info['order_id'],
			'cust_id'				=> $custId,
			'amount'				=> $amount,
			'pan'					=> $data['card_num'],
			'expdate'				=> $data['expiry'], //YYMM
			'cavv'					=> $data['cavv'],
			'crypt_type'			=> $data['crypt']
		);

		$billing = array (
			'first_name' 		=> $order_info['payment_firstname'],
			'last_name'			=> $order_info['payment_lastname'],
			'company_name'		=> $order_info['payment_lastname'],
			'address'			=> trim($order_info['payment_address_1'] . ' ' . $order_info['payment_address_2']),
			'city'				=> $order_info['payment_city'],
			'province'			=> $order_info['payment_zone'],
			'postal_code'		=> $order_info['payment_postcode'],
			'country'			=> $order_info['payment_iso_code_2'],
			'phone_number'		=> $order_info['telephone'],
			'fax'				=> isset($order_info['fax']) ? $order_info['fax'] : '',
			'tax1'				=> 0,
			'tax2'				=> 0,
			'tax3'				=> 0,
			'shipping_cost'		=> 0
		);

		$shipping = array (
			'first_name' 		=> $order_info['shipping_firstname'],
			'last_name'			=> $order_info['shipping_lastname'],
			'company_name'		=> $order_info['shipping_lastname'],
			'address'			=> trim($order_info['shipping_address_1'] . ' ' . $order_info['shipping_address_2']),
			'city'				=> $order_info['shipping_city'],
			'province'			=> $order_info['shipping_zone'],
			'postal_code'		=> $order_info['shipping_postcode'],
			'country'			=> $order_info['shipping_iso_code_2'],
			'phone_number'		=> $order_info['telephone'],
			'fax'				=>  isset($order_info['fax']) ? $order_info['fax'] : '',
			'tax1'				=> 0,
			'tax2'				=> 0,
			'tax3'				=> 0,
			'shipping_cost'		=> 0
		);

		$avsArray = array(
			'avs_street_number' => preg_replace("/[^\d]/", "", $order_info['payment_address_1']),
			'avs_street_name'	=> trim(preg_replace("/[\d]/", "", $order_info['payment_address_1'])),
			'avs_zipcode' 		=> $order_info['payment_postcode']
		);

		$cvdArray = array(
			'cvd_indicator' => '1',
			'cvd_value' => $data['card_cvv']
		);

		$mpgCustInfo = new mpgCustInfo();
		$mpgCustInfo->setEmail($order_info['email']);
		$mpgCustInfo->setInstructions('');

		$itemArray = array(
			'name' => 'Store Purchase',
			'quantity' => '1',
			'product_code' => '---',
			'extended_amount' => '0.00'
		);
		$mpgCustInfo->setItems($itemArray);
		$mpgCustInfo->setBilling($billing);
		$mpgCustInfo->setShipping($shipping);

		$mpgTxn = new mpgTransaction($txnArray);
		$mpgTxn->setCustInfo($mpgCustInfo);

		if ($this->config->get($classname . '_efraud')) {
			$mpgTxn->setCvdInfo($cvdArray);
			$mpgTxn->setAvsInfo($avsArray);
		}

		$mpgRequest = new mpgRequest($mpgTxn);
		$mpgRequest->setProcCountryCode($country); //"CA" for sending transaction to Canadian environment
		if ($testmode) {
			$mpgRequest->setTestMode(true);
		}

		if ($this->config->get($classname . '_debug')) {
			$mpgHttpPost  	= new mpgHttpsPost($store_id,$api_token,$mpgRequest, DIR_LOGS . $classname . '_debug.txt');
		} else {
			$mpgHttpPost  	= new mpgHttpsPost($store_id,$api_token,$mpgRequest, False);
		}
		$mpgResponse	= $mpgHttpPost->getMpgResponse();
		$responseCode	= $mpgResponse->getResponseCode();

		// Debug
		if ($this->config->get($classname . '_debug')) {
			file_put_contents(DIR_LOGS . $classname . '_debug.txt', __FUNCTION__ . "\r\nmpgResponse = " . print_r($mpgResponse,1) . "\r\n responseCode = $responseCode \r\n----------------\r\n", FILE_APPEND);
		}
		
		if ($responseCode != 'null' && (int)$responseCode < 50) { //approved
			if (version_compare(VERSION, '2.0', '>=')) { // v20x
				if ($this->config->get($classname . '_efraud')) {
					$avsCode 		= $mpgResponse->getAvsResultCode();
					$cvsCode 		= $mpgResponse->getCvdResultCode();

					if ($avsCode) {
						$this->model_checkout_order->addOrderHistory($order_info['order_id'], $this->config->get('config_order_status_id'), '', true);
					} else {
						$this->model_checkout_order->addOrderHistory($order_info['order_id'], $this->config->get($classname . '_order_status_id'), '', true);
					}
				} else {
					$this->model_checkout_order->addOrderHistory($order_info['order_id'], $this->config->get($classname . '_order_status_id'), '', true);
				}
			} else { //v15x
				$this->model_checkout_order->confirm($order_info['order_id'], $this->config->get($classname . '_order_status_id'), '');
				$this->model_checkout_order->update($order_info['order_id'], $this->config->get($classname . '_order_status_id'), print_r($mpgResponse->responseData,1), FALSE);
			}
		}

		return $mpgResponse;
	}

//  CHECK  CC  =====================================================================

	private function checkCreditCard ($cardnumber, $cardtype, $cvv, $expMon, $expYear, &$errornumber, &$errortext) {

		// Define the cards we support. You may add additional card types.

		//  Name:      As in the selection box of the form - must be same as user's
		//  Length:    List of possible valid lengths of the card number for the card
		//  prefixes:  List of possible prefixes for the card
		//  cvv_length:  Valid cvv code length for the card
		//  luhn Boolean to say whether there is a check digit

		// Don't forget - all but the last array definition needs a comma separator!

		$cards = array(
			array ('name' => 'amex',
				  'length' => '15',
				  'prefixes' => '34,37',
				  'cvv_length' => '4',
				  'luhn' => true
				 ),
			array ('name' => 'diners',
				  'length' => '14,16',
				  'prefixes' => '36,38,54,55',
				  'cvv_length' => '3',
				  'luhn' => true
				 ),
			array ('name' => 'discover',
				  'length' => '16',
				  'prefixes' => '6011,622,64,65',
				  'cvv_length' => '3',
				  'luhn' => true
				 ),
			array ('name' => 'jcb',
				  'length' => '16',
				  'prefixes' => '35',
				  'cvv_length' => '3',
				  'luhn' => true
				 ),
			array ('name' => 'maestro',
				  'length' => '12,13,14,15,16,18,19',
				  'prefixes' => '5018,5020,5038,6304,6759,6761,6762,6763',
				  'cvv_length' => '3',
				  'luhn' => true
				 ),
			array ('name' => 'mastercard',
				  'length' => '16',
				  'prefixes' => '51,52,53,54,55,22,23,24,25,26,27',
				  'cvv_length' => '3',
				  'luhn' => true
				 ),
			array ('name' => 'solo',
				  'length' => '16,18,19',
				  'prefixes' => '6334,6767',
				  'cvv_length' => '3',
				  'luhn' => true
				 ),
			array ('name' => 'switch',
				  'length' => '16,18,19',
				  'prefixes' => '4903,4905,4911,4936,564182,633110,6333,6759',
				  'cvv_length' => '3',
				  'luhn' => true
				 ),
			array ('name' => 'visa',
				  'length' => '16',
				  'prefixes' => '4',
				  'cvv_length' => '3',
				  'luhn' => true
				 ),
			array ('name' => 'visa_electron',
				  'length' => '16',
				  'prefixes' => '417500,4917,4913,4508,4844',
				  'cvv_length' => '3',
				  'luhn' => true
				 ),
			array ('name' => 'laser',
				  'length' => '16,17,18,19',
				  'prefixes' => '6304,6706,6771,6709',
				  'cvv_length' => '3',
				  'luhn' => true
				 )
		);


		$ccErrorNo = 0;
		$ccErrors[0] = $this->language->get('error_card_type');
		$ccErrors[1] = $this->language->get('error_card_num');
		$ccErrors[2] = $this->language->get('error_card_cvv');
		$ccErrors[3] = $this->language->get('error_card_exp');

		// Establish card type
		$cardType = -1;
		for ($i=0; $i<sizeof($cards); $i++) {

			// See if it is this card (ignoring the case of the string)
			if (strtolower($cardtype) == strtolower($cards[$i]['name'])) {
				$cardType = $i;
				break;
			}
		}

		// If card type not found, report an error
		if ($cardType == -1) {
			$errornumber = 0;
			$errortext = $ccErrors[$errornumber];
			return false;
		}

		// Ensure that the user has provided a credit card number
		if (strlen($cardnumber) == 0)  {
			$errornumber = 1;
			$errortext = $ccErrors[$errornumber];
			return false;
		}

		// Remove any spaces from the credit card number
		$cardNo = str_replace (array(' ', '-'), '', $cardnumber);

		// Check that the number is numeric and of the right sort of length.
		if (!preg_match("/^[0-9]{13,19}$/", $cardNo))  {
			$errornumber = 1;
			$errortext = $ccErrors[$errornumber];
			return false;
		}

		// Remove any spaces or non-numerics from the expiry date fields
		$expMon = preg_replace('/[^0-9]/', '', $expMon);
		$expYear = preg_replace('/[^0-9]/', '', $expYear);

		// Check expiry length
		if (strlen($expMon) != 2 || strlen($expYear) != 4) {
			$errornumber = 3;
			$errortext = $ccErrors[$errornumber];
			return false;
		}

		// Check the expiry date
		/* Get timestamp of midnight on day after expiration month. */
		$exp_ts = mktime(0, 0, 0, $expMon + 1, 1, $expYear);

		$cur_ts = time();
		/* Don't validate for dates more than 10 years in future. */
		$max_ts = $cur_ts + (10 * 365 * 24 * 60 * 60);

		if ($exp_ts < $cur_ts || $exp_ts > $max_ts) {
			$errornumber = 3;
			$errortext = $ccErrors[$errornumber];
			return false;
		}

		// Now check the modulus 10 check digit - if required
		if ($cards[$cardType]['luhn']) {
			$checksum = 0;                                  // running checksum total
			$mychar = "";                                   // next char to process
			$j = 1;                                         // takes value of 1 or 2

			// Process each digit one by one starting at the right
			for ($i = strlen($cardNo) - 1; $i >= 0; $i--) {

				// Extract the next digit and multiply by 1 or 2 on alternative digits.
				$calc = $cardNo[$i] * $j;

				// If the result is in two digits add 1 to the checksum total
				if ($calc > 9) {
					$checksum = $checksum + 1;
					$calc = $calc - 10;
				}

				// Add the units element to the checksum total
				$checksum = $checksum + $calc;

				// Switch the value of j
				if ($j ==1) {$j = 2;} else {$j = 1;};
			}

			// All done - if checksum is divisible by 10, it is a valid modulus 10.
			// If not, report an error.
			if ($checksum % 10 != 0) {
				$errornumber = 1;
				$errortext = $ccErrors[$errornumber];
				return false;
			}
		}

		// The following are the card-specific checks we undertake.

		// Load an array with the valid prefixes for this card
		$prefix = explode(',', $cards[$cardType]['prefixes']);

		// Now see if any of them match what we have in the card number
		$PrefixValid = false;
		for ($i=0; $i<sizeof($prefix); $i++) {
			$exp = '/^' . $prefix[$i] . '/';
			if (preg_match($exp,$cardNo)) {
				$PrefixValid = true;
				break;
			}
		}

		// If it isn't a valid prefix there's no point at looking at the length
		if (!$PrefixValid) {
			$errornumber = 1;
			$errortext = $ccErrors[$errornumber];
			return false;
		}

		// See if the length is valid for this card
		$LengthValid = false;
		$lengths = explode(',', $cards[$cardType]['length']);
		for ($j=0; $j<sizeof($lengths); $j++) {
			if (strlen($cardNo) == $lengths[$j]) {
				$LengthValid = true;
				break;
			}
		}

		// See if all is OK by seeing if the length was valid.
		if (!$LengthValid) {
			$errornumber = 1;
			$errortext = $ccErrors[$errornumber];
			return false;
		}

		$cvv_length = $cards[$cardType]['cvv_length'];
		if (strlen($cvv) != $cvv_length) {
			$errornumber = 2;
			$errortext = $ccErrors[$errornumber];
			return false;
		}

		// The credit card is in the required format.
		return true;
	}
}
?>