<?php

class ControllerExtensionPaymentMonerisHostedCA extends Controller {

	protected $errors = array();

	public function index() {

		# Generic Init
		$extension_type 			= 'extension/payment';
		$classname 					= str_replace('vq2-' . basename(DIR_APPLICATION) . '_' . strtolower(get_parent_class($this)) . '_' . str_replace('/', '_', $extension_type) . '_', '', basename(__FILE__, '.php'));
		$data['classname'] 			= $classname;
		$data 						= array_merge($data, $this->load->language($extension_type . '/' . $classname));
		$storename = html_entity_decode(($this->config->get('config_name')) ? $this->config->get('config_name') : $this->config->get('config_store'), ENT_COMPAT, 'UTF-8');

		# Order Info
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		# Error Check
		$data['error'] = (isset($this->session->data['error'])) ? $this->session->data['error'] : NULL;
		unset($this->session->data['error']);

		$data['use_iframe'] = $this->config->get($classname . '_iframe');

		# Check for supported currency, otherwise convert to ISK.
		$supported_currencies = explode(",", $this->config->get($classname . '_supported_currencies'));
		if (in_array($order_info['currency_code'], $supported_currencies)) {
			$currency = $order_info['currency_code'];
		} else {
			$currency = $this->config->get($classname . '_default_currency');
		}

		$amount = number_format($this->currency->format($order_info['total'], $currency, FALSE, FALSE),2, '.', '');
		$cancelurl 		= $this->url->link($extension_type . '/' . $classname . '/cancel', '', 'SSL');
		$successurl 	= $this->url->link($extension_type . '/' . $classname . '/success', '', 'SSL');
		$callbackurl 	= $this->url->link($extension_type . '/' . $classname . '/callback', '', 'SSL');


		// Mijo Support
		if (strpos(DIR_SYSTEM, 'mijo') !== false) {
			$cancelurl = str_replace('route', 'option=com_mijoshop&format=raw&tmpl=component&route', $cancelurl);
			$successurl = str_replace('route', 'option=com_mijoshop&format=raw&tmpl=component&route', $successurl);
			$callbackurl = str_replace('route', 'option=com_mijoshop&format=raw&tmpl=component&route', $callbackurl);
		}

		// As of 2015-09-07, Authnet no longer supports ? and & in their relay response urls
		// Must use a redirect script instead
		$callbackurl 	= HTTPS_SERVER . $classname . '_callback.php';

		# Get Total
		$total = $order_info['total'];

		# Get Tax Total
		$tax_total = 0;
		$hst_total = 0;
		$gst_total = 0;
		$pst_total = 0;
		$taxes = $this->cart->getTaxes();
		foreach ($taxes as $key => $value) {
			$tax_total += $value;
		}
		file_put_contents(DIR_LOGS . 'moneris-tax-ids.txt', print_r($taxes,1) . $gst_total);

		# Get Shipping Total
		$shipping_total = 0;
		if ($this->cart->hasShipping() && isset($this->session->data['shipping_method']) && isset($this->session->data['shipping_method']['cost'])) {
			$shipping_total = $this->session->data['shipping_method']['cost'];

			// Shipping Tax Breakdown for PST/GST/HST. v1513+ Only
			if (method_exists($this->tax, 'getRates')) {
				$tax_rates = $this->tax->getRates($this->session->data['shipping_method']['cost'], $this->session->data['shipping_method']['tax_class_id']);
				file_put_contents(DIR_LOGS . 'moneris-tax-rates.txt', print_r($tax_rates,1));
				foreach ($tax_rates as $tax_rate) {
					if (strpos(strtolower($tax_rate['name']), 'pst') !== false) {
						$pst_total += $taxes[$tax_rate['tax_rate_id']];
					} elseif (strpos(strtolower($tax_rate['name']), 'gst') !== false) {
						$gst_total += $taxes[$tax_rate['tax_rate_id']];
					} else {
						$hst_total += $taxes[$tax_rate['tax_rate_id']];
					}
				}
			}
		}

		$sequence = rand(1, 1000);
		$xlogin = trim($this->config->get($classname . '_mid'));
        $xtxnkey = trim($this->config->get($classname . '_key'));

        $data['fields'] = array();
		if ($this->config->get($classname . '_country') == 'US') {
			$data['fields']['hpp_id'] 			= trim($this->config->get($classname . '_mid'));
			$data['fields']['hpp_key']					= trim($this->config->get($classname . '_key'));
			$data['fields']['amount'] 			= $this->currency->format($order_info['total'], $currency, FALSE, FALSE);
			$data['fields']['order_no'] 				= $this->session->data['order_id'] . '_' . time();
			$data['fields']['client_email'] 				= $order_info['email'];
			$data['fields']['cust_id']					= ($order_info['customer_id']);

			# itemize products
			$sum = 0;
			$i = 1;
			foreach ($this->cart->getProducts() as $product) {
				$data['fields']['li_id' . $i]				= 	$product['model'];
				$data['fields']['li_description' . $i]		= 	$product['name'];
				$data['fields']['li_quantity' . $i]		= 	$product['quantity'];
				$data['fields']['li_price' . $i]			= 	number_format($this->currency->format($product['price'], $currency, FALSE, FALSE), 2, '.', '');
				//$data['fields']['subtotal' . $i]		= 	number_format($this->currency->format($product['price'], $currency, FALSE, FALSE) * $product['quantity'], 2, '.', '');
				$sum += $product['price'] * $product['quantity'];
				$i++;
			}

			# Calculate remaining total for rounding issues and discounts
			$remaining_total = $total - $shipping_total - $tax_total - $sum;
			$shipping_total += $remaining_total; // added as handling


			$data['fields']['li_shipping']			= $this->currency->format($shipping_total, $currency, FALSE, FALSE);
			$data['fields']['li_taxes']					= $this->currency->format($tax_total, $currency, FALSE, FALSE);


			$data['fields']['note']						= (sprintf("Order #%s from $storename", $order_info['order_id']));
			$data['fields']['od_bill_firstname']			= ($order_info['payment_firstname']);
			$data['fields']['od_bill_lastname']			= ($order_info['payment_lastname']);
			$data['fields']['od_bill_company']		= ($order_info['payment_company']);
			$data['fields']['od_bill_address']			= ($order_info['payment_address_1'] . ' ' . $order_info['payment_address_2']);
			$data['fields']['od_bill_city']				= ($order_info['payment_city']);
			$data['fields']['od_bill_state']	= ($order_info['payment_zone_code']);
			$data['fields']['od_bill_zipcode'] 		= ($order_info['payment_postcode']);
			$data['fields']['od_bill_country'] 			= ($order_info['payment_country']);
			$data['fields']['od_bill_phone']				= ($order_info['telephone']);
			$data['fields']['od_bill_fax']				= ($order_info['fax']);

			if ($this->cart->hasShipping()) {
				$data['fields']['od_ship_firstname']		= ($order_info['shipping_firstname']);
				$data['fields']['od_ship_lastname']		= ($order_info['shipping_lastname']);
				$data['fields']['od_ship_company']	= ($order_info['shipping_company']);
				$data['fields']['od_ship_address']		= ($order_info['shipping_address_1'] . ' ' . $order_info['shipping_address_2']);
				$data['fields']['od_ship_city']			= ($order_info['shipping_city']);
				$data['fields']['od_ship_state']	= ($order_info['shipping_zone_code']);
				$data['fields']['od_ship_zipcode'] 	= ($order_info['shipping_postcode']);
				$data['fields']['od_ship_country'] 		= ($order_info['shipping_country']);
				$data['fields']['od_ship_phone']			= ($order_info['telephone']);
				$data['fields']['od_ship_fax']				= ($order_info['fax']);
			}

		} else {
			$data['fields']['ps_store_id'] 				= trim($this->config->get($classname . '_mid'));
			$data['fields']['hpp_key']					= trim($this->config->get($classname . '_key'));
			$data['fields']['charge_total'] 			= $amount;
			$data['fields']['order_id'] 				= $order_info['order_id'] . '_' . time();
			$data['fields']['lang'] 					= 'en-ca'; //en-ca or fr-ca
			$data['fields']['email']					= ($order_info['email']);


			# itemize products
			$sum = 0;
			$i = 1;
			foreach ($this->cart->getProducts() as $product) {
				$data['fields']['id' . $i]				= 	$product['model'];
				$data['fields']['description' . $i]		= 	$product['name'];
				$data['fields']['quantity' . $i]		= 	$product['quantity'];
				$data['fields']['price' . $i]			= 	number_format($this->currency->format($product['price'], $currency, FALSE, FALSE), 2, '.', '');
				$data['fields']['subtotal' . $i]		= 	number_format($this->currency->format($product['price'], $currency, FALSE, FALSE) * $product['quantity'], 2, '.', '');
				$sum += $product['price'] * $product['quantity'];
				$i++;
			}

			# Calculate remaining total for rounding issues and discounts
			$remaining_total = $total - $shipping_total - $tax_total - $hst_total - $pst_total - $gst_total - $sum;
			$shipping_total += $remaining_total; // added as handling


			$data['fields']['shipping_cost']			= $this->currency->format($shipping_total, $currency, FALSE, FALSE);

			if ($pst_total) {
				$data['fields']['pst']					= $this->currency->format($pst_total, $currency, FALSE, FALSE);
			}
			if ($gst_total) {
				$data['fields']['gst']					= $this->currency->format($gst_total, $currency, FALSE, FALSE);
			}
			if ($hst_total) {
				$data['fields']['hst']					= $this->currency->format($hst_total, $currency, FALSE, FALSE);
			}

			$data['fields']['cust_id']					= ($order_info['customer_id']);
			$data['fields']['email']					= ($order_info['email']);
			$data['fields']['note']						= (sprintf("Order #%s from $storename", $order_info['order_id']));
			$data['fields']['bill_first_name']			= ($order_info['payment_firstname']);
			$data['fields']['bill_last_name']			= ($order_info['payment_lastname']);
			$data['fields']['bill_company_name']		= ($order_info['payment_company']);
			$data['fields']['bill_address_one']			= ($order_info['payment_address_1'] . ' ' . $order_info['payment_address_2']);
			$data['fields']['bill_city']				= ($order_info['payment_city']);
			$data['fields']['bill_state_or_province']	= ($order_info['payment_zone_code']);
			$data['fields']['bill_postal_code'] 		= ($order_info['payment_postcode']);
			$data['fields']['bill_country'] 			= ($order_info['payment_country']);
			$data['fields']['bill_phone']				= ($order_info['telephone']);

			if ($this->cart->hasShipping()) {
				$data['fields']['ship_first_name']		= ($order_info['shipping_firstname']);
				$data['fields']['ship_last_name']		= ($order_info['shipping_lastname']);
				$data['fields']['ship_company_name']	= ($order_info['shipping_company']);
				$data['fields']['ship_address_one']		= ($order_info['shipping_address_1'] . ' ' . $order_info['shipping_address_2']);
				$data['fields']['ship_city']			= ($order_info['shipping_city']);
				$data['fields']['ship_state_or_province']	= ($order_info['shipping_zone_code']);
				$data['fields']['ship_postal_code'] 	= ($order_info['shipping_postcode']);
				$data['fields']['ship_country'] 		= ($order_info['shipping_country']);
				$data['fields']['ship_phone']			= ($order_info['telephone']);
			}
		}
		//$data['fields']['note'] 						= $order_info['comment'];

		if ($this->config->get($classname . '_test')) {
    		if ($this->config->get($classname . '_country') == 'US') {
				$data['action'] = 'https://esplusqa.moneris.com/DPHPP/index.php'; // US
			} else {
				$data['action'] = 'https://esqa.moneris.com/HPPDP/index.php'; // CA
			}
		} else {
			if ($this->config->get($classname . '_country') == 'US') {
				$data['action'] = 'https://esplus.moneris.com/DPHPP/index.php'; // US
			} else {
				$data['action'] = 'https://www3.moneris.com/HPPDP/index.php'; // CA
			}
		}
		
		// If using preload, no optional params are supported.
		if ($this->config->get($classname . '_preload')) {
			if (isset($this->data)) { $data = $this->data; }
			$preload_response = $this->getPreloadTicket($this->data, $this->config->get($classname . '_country'));
			if ($preload_response['error']) {
				$this->session->data['error'] = $preload_response['error'];
			} else {
				$data['fields'] = array();
				$data['fields']['hpp_id'] 					= trim($this->config->get($classname . '_mid')); // returned but same as ps_store_id
				$data['fields']['ticket']					= $preload_response['ticket'];
				$data['fields']['hpp_preload'] 				= '';
				if (isset($this->data)) { $this->data['fields'] = $data['fields']; }
			}
		}
		

		$data['testmode'] 		= $this->config->get($classname . '_test');

		$data['error'] 			=(isset($this->session->data['error'])) ? $this->session->data['error'] : NULL;
		unset($this->session->data['error']);

		// Debug
		if ($this->config->get($classname . '_debug')) { file_put_contents(DIR_LOGS . $classname . '_debug.txt', __FUNCTION__ . "\r\n$classname FIELDS: " . print_r($data['fields'],1) . "\r\n"); }


		# Compatibility
		if (version_compare(VERSION, '2.2', '>=')) { // v2.2.x Compatibility
			if (version_compare(VERSION, '3.0', '>=')) { // v3.x Compatibility to support twig and tpl files
				$template_file = (DIR_TEMPLATE . str_replace('theme_', '', $this->config->get('config_theme')) . '/template/' . $extension_type . '/' .$classname.'.twig');
				if (is_file($template_file)) {
					return $this->load->view($extension_type . '/' .$classname, $data);
				} else {
					$temp_file = ('/template/' . $extension_type . '/'. $classname . '.tpl');
					if (file_exists(DIR_TEMPLATE . str_replace('theme_', '', $this->config->get('config_theme')) . $temp_file)) {
						$template_file = (DIR_TEMPLATE . str_replace('theme_', '', $this->config->get('config_theme')) . $temp_file);
					} else {
						$template_file = (DIR_TEMPLATE . 'default' . $temp_file);
					}
					extract($data);
					ob_start();
					if (class_exists('VQMod')) { require(VQMod::modCheck(modification($template_file), $template_file)); } else { require(modification($template_file)); }
					return ob_get_clean();
				}
			} else { // v2.2.x Compatibility
				return $this->load->view($extension_type . '/'. $classname, $data);
			}
		} elseif (version_compare(VERSION, '2.0', '>=')) { // v2.0.x Compatibility
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/' . $extension_type . '/'. $classname . '.tpl')) {
				return $this->load->view($this->config->get('config_template') . '/template/' . $extension_type . '/'. $classname . '.tpl', $data);
			} else {
				return $this->load->view('default/template/' . $extension_type . '/'. $classname . '.tpl', $data);
			}
		} elseif (version_compare(VERSION, '2.0', '<')) {  // 1.5.x Backwards Compatibility
			$this->data = array_merge($this->data, $data);
			$this->id 	= 'extension/payment';
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/' . $classname . '.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/payment/' . $classname . '.tpl';
			} else {
				$this->template = 'default/template/payment/' . $classname . '.tpl';
			}
        	$this->render();
		}
	}
	
	private function getPreloadTicket($data, $country) {

		$url = $data['action'];
		
		if ($country == 'US') {
			$hpp_id = $data['fields']['hpp_id'];
			$hpp_key = $data['fields']['hpp_key'];
			$amount =	$data['fields']['amount'];
			$order_no = $data['fields']['order_no'];
			$dataToSend = "hpp_id=$hpp_id&hpp_key=$hpp_key&amount=$amount&order_no=$order_no&hpp_preload=0";
		} else { //CA
			$store_id = $data['fields']['ps_store_id'];
			$hpp_key = $data['fields']['hpp_key'];
			$charge_total =	$data['fields']['charge_total'];
			$order_id = $data['fields']['order_id'];
			$dataToSend = "ps_store_id=$store_id&hpp_key=$hpp_key&charge_total=$charge_total&order_id=$order_id&hpp_preload=";
		}	
		
		$retval = array();		
				
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $dataToSend);
		curl_setopt($ch, CURLOPT_TIMEOUT, 15);
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla');
		curl_setopt($ch, CURLOPT_REFERER, "https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
		
		$response = curl_exec($ch);
		file_put_contents(DIR_LOGS . 'moneris_hpp_preload.txt', "REQUEST: $dataToSend\r\nRESPONSE: $response");
		curl_close($ch);

		$retval['error'] = false;
		
		if (!$response) {
			$retval['error'] = "Error preloading page";
		} else {
			$xmlString = new SimpleXMLElement($response);
			$ticket = $xmlString->ticket;
			$order_id = $xmlString->order_id;
			$response_code = $xmlString->response_code;

			if ($response_code < 50) {
				$retval['ticket'] = $ticket;
			} else {
				$retval['error'] = "Incorrect Response Code ($response_code) for Preload";
			}
		}		
		return $retval;		
	}

	private function fail($msg = false) {
		$failurl = $this->url->link('checkout/cart');
		// Mijo Support
		if (strpos(DIR_SYSTEM, 'mijo') !== false) {
			$failurl = str_replace('route', 'option=com_mijoshop&format=raw&tmpl=component&route', $failurl);
		}
		if (!$msg) { $msg = (!empty($this->session->data['error']) ? $this->session->data['error'] : 'Unknown Error'); }
		echo '<html><head><script type="text/javascript">';
		echo 'alert("'.addslashes($msg).'");';
		echo 'window.location="' . $failurl . '";';
		echo '</script></head></html>';
		exit;
	}

	public function callback() {
		# Generic Init
		$extension_type 			= 'extension/payment';
		$classname 					= str_replace('vq2-' . basename(DIR_APPLICATION) . '_' . strtolower(get_parent_class($this)) . '_' . str_replace('/', '_', $extension_type) . '_', '', basename(__FILE__, '.php'));
		$data['classname'] 			= $classname;
		$data 						= array_merge($data, $this->load->language($extension_type . '/' . $classname));

		// Debug
		if ($this->config->get($classname . '_debug')) { file_put_contents(DIR_LOGS . $classname . '_debug.txt', __FUNCTION__ . "\r\n$classname GET: " . print_r($_GET,1) . "\r\n" . "$classname POST: " . print_r($_POST,1) . "\r\n", FILE_APPEND); }

		if (isset($this->request->get['result']) && $this->request->get['result'] == '914') {
			$this->session->data['error'] = $this->language->get('error_canceled');
			$this->fail();
		}

		// Error scenario doesn't return order id so catch it here
		if (!isset($this->request->get['response_order_id']) && !isset($_REQUEST['order_no'])) {
			if (isset($this->request->get['message'])) {
				$this->session->data['error'] = $this->request->get['message'];
			} else {
				$this->session->data['error'] = $this->language->get('error_invalid');
			}
            $this->fail();
		}

		if (isset($_REQUEST['order_no'])) {
			$order_id = $_REQUEST['order_no'];
			$country = 'US';
		} elseif (isset($_REQUEST['response_order_id'])) {
			$order_id = $_REQUEST['response_order_id'];
			$country = 'CA';
		} else {
			$order_id = 0;
		}

		$order_id = explode("_", $order_id);
		$order_id = reset($order_id);

	  	$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($order_id);

		// If there is no order info then fail.
		if (!$order_info) {
			$this->session->data['error'] = $this->language->get('error_no_order');
			$this->fail();
		}

		// Carry Some params to result page
		unset($this->session->data['transaction_params']);
		$transaction_params = '<h3>Transaction Details:</h3>';
		$ignore_params = array('PHPSESSID', 'display', 'route', 'language', 'option', 'Itemid', 'mijoshop_store_id');
		$include_params = array('charge_total', 'amount', 'trans_name', 'txn_date', 'ref_num', 'auth_code', 'timestamp', 'txn_time', 'bank_approval_code', 'txn_num', 'response_code', 'iso_code', 'message', 'bank_transaction_id', 'cardholder', 'order_no');
		foreach ($_REQUEST as $k => $v) {
			if (!empty($ignore_params) && in_array($k, $ignore_params)) { continue; }
			if (!empty($include_params) && !in_array($k, $include_params)) { continue; }
			$transaction_params .= ucwords($k) . ": $v <br/>";
		}
		$this->session->data['transaction_params'] = $transaction_params;
		$message = print_r($transaction_params, 1);

		if (isset($this->request->get['result'])) {

			switch((int)$this->request->get['result']) {
				case 1:
					if (version_compare(VERSION, '2.0', '>=')) { // v20x
						$this->model_checkout_order->addOrderHistory($order_id, $this->config->get('config_order_status_id'), $order_info['comment'], true);
						$this->model_checkout_order->addOrderHistory($order_id, $this->config->get($classname . '_order_status_id'), FALSE, false);
					} else { //v15x
						$this->model_checkout_order->confirm($order_id, $this->config->get('config_order_status_id'), $order_info['comment']);
						$this->model_checkout_order->update($order_id, $this->config->get($classname . '_order_status_id'), FALSE, FALSE);
					}

					$successurl = $this->url->link('checkout/success', '', 'SSL');
					// Mijo Support
					if (strpos(DIR_SYSTEM, 'mijo') !== false) {
						$successurl = str_replace('route', 'option=com_mijoshop&format=raw&tmpl=component&route', $successurl);
					}
					$relayhtml  = '<html><head><base target="_top"><script language="Javascript">parent.location="'. $successurl . '"</script>';
					$relayhtml .= '</head><body><a href="'.$successurl.'">--></a></body></html>';
					print $relayhtml;
					exit();
					break;
				case 0:
					if (isset($this->request->get['message'])) {
						$this->session->data['error'] = $this->request->get['message'];
					} else {
						$this->session->data['error'] = $this->language->get('error_declined');
					}
					break;
				default:
					if (isset($this->request->get['message'])) {
						$this->session->data['error'] = $this->request->get['message'];
					} else {
						$this->session->data['error'] = $this->language->get('error_invalid');
					}
			}
		} else {
			if (isset($this->request->get['message'])) {
				$this->session->data['error'] = $this->request->get['message'];
			} else {
				$this->session->data['error'] = $this->language->get('error_invalid');
			}
		}
		$this->fail();
	}
}
?>