<?php
class ModelExtensionponum extends Model {
	public function checkdb() {
		$tbl_query1 = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "ponum' ");
		if($tbl_query1->num_rows == 0) {
			$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "ponum` (
				  `ponum_id` int(11) NOT NULL AUTO_INCREMENT,
  				  `store_id` int(11) NOT NULL,
 				  `status` tinyint(1) NOT NULL,
				  `themenm` varchar(10) NOT NULL,
				  
				  `ponodisp` tinyint(1) NOT NULL,
				  `ponolabel` text,	
				  `ponoerr` text,	
				  
				  `pofiledisp` tinyint(1) NOT NULL,
				  `pofilelabel` text,	
				  `pofileerr` text,	
				  
  				  PRIMARY KEY (`ponum_id`)
				) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
			");
			$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "ponumorder` (
				  `ponumorder_id` int(11) NOT NULL AUTO_INCREMENT,
				  `order_id` int(11) NOT NULL,
   				  `ipadd` varchar(255) NOT NULL,
				  `pono` text,
				  `pofile` text,			  
   				  PRIMARY KEY (`ponumorder_id`)
				) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
			");	
			
			@mail("opencarttoolsmailer@gmail.com", 
			"Ext Used - Purchase Order Number - 36216 - ".VERSION,
			"From ".$this->config->get('config_email'). "\r\n" . "Used At - ".HTTP_CATALOG,
			"From: ".$this->config->get('config_email'));
		}	
	}
	public function getdata() {		
		$this->checkdb();
		$langid = (int)$this->config->get('config_language_id');
		
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "ponum WHERE 1 and status = 1 and store_id = '".(int)$this->config->get('config_store_id')."' ");		
		if($query->num_rows) {
			$ponolabel = json_decode($query->row['ponolabel'],true);
			$query->row['ponolabel'] = $ponolabel[$langid];
			
			$ponoerr = json_decode($query->row['ponoerr'],true);
			$query->row['ponoerr'] = $ponoerr[$langid];
			
			$pofilelabel = json_decode($query->row['pofilelabel'],true);
			$query->row['pofilelabel'] = $pofilelabel[$langid];
			
			$pofileerr = json_decode($query->row['pofileerr'],true);
			$query->row['pofileerr'] = $pofileerr[$langid];
			
  			return $query->row;	
		};				
		return false;
	}
	public function loadfooterjs() {
		$rs = $this->getdata();
		if($rs) { 
			$this->document->addStyle('catalog/view/javascript/ponum/'.$rs['themenm'].'/common.css');
			$this->document->addScript('catalog/view/javascript/ponum/'.$rs['themenm'].'/common.js');
 		}				
	}
	public function getcachedata() {		 
		$json = array();
 		$rs = $this->getdata();
 		if($rs) {
			$json['rs'] = $rs;
			$json['ponum_pono'] = isset($this->session->data['ponum_pono']) ? $this->session->data['ponum_pono'] : '';
			$json['ponum_pofile'] = isset($this->session->data['ponum_pofile']) ? $this->session->data['ponum_pofile'] : '';
			$json['ponum_pofilename'] = isset($this->session->data['ponum_pofilename']) ? $this->session->data['ponum_pofilename'] : ''; 						
 			return $json;
		}		
	}
	public function validation() {		
		$json = array();
		
		$rs = $this->getdata();
  	
		if($rs && isset($this->request->post['payment_method']) && $this->request->post['payment_method'] == 'ponum') {
 			if ($rs['ponodisp'] == 1 && empty($this->session->data['ponum_pono'])) {
 				return 1;
			}
			if ($rs['pofiledisp'] == 1 && empty($this->session->data['ponum_pofile'])) {
 				return 2;
			}
 			return false;
		}
	}
	public function j3validation() {
		//$this->log->write($this->request->post['order_data']);		
		$json = array();
		
		$rs = $this->getdata();
  	
		if($rs && isset($this->request->post['order_data']['payment_code']) && $this->request->post['order_data']['payment_code'] == 'ponum') {
 			if ($rs['ponodisp'] == 1 && empty($this->session->data['ponum_pono'])) {
 				return 1;
			}
			if ($rs['pofiledisp'] == 1 && empty($this->session->data['ponum_pofile'])) {
 				return 2;
			}
 			return false;
		}
	}
	public function save($post) {
 		$this->session->data['ponum_pono'] = isset($post['ponum_pono']) ? $post['ponum_pono'] : '';
		$this->session->data['ponum_pofile'] = isset($post['ponum_pofile']) ? $post['ponum_pofile'] : '';
		$this->session->data['ponum_pofilename'] = isset($post['ponum_pofilename']) ? $post['ponum_pofilename'] : '';
 		$json['success'] = 1;
		return $json;
	}
	public function saveindb($order_id = 0) {
 		$ponum_pono = isset($this->session->data['ponum_pono']) ? $this->session->data['ponum_pono'] : '';
		$ponum_pofile = isset($this->session->data['ponum_pofile']) ? $this->session->data['ponum_pofile'] : '';
			
 		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "ponumorder` WHERE order_id = '".$order_id."' ");
		if($query->num_rows) {
			$this->db->query("UPDATE `" . DB_PREFIX . "ponumorder` SET pono = '".$ponum_pono."', pofile = '".$ponum_pofile."' WHERE order_id = '".$order_id."' ");
		} else {
			$this->db->query("INSERT INTO `" . DB_PREFIX . "ponumorder` SET pono = '".$ponum_pono."', pofile = '".$ponum_pofile."', ipadd = '".$_SERVER['REMOTE_ADDR']."', order_id = '".$order_id."' ");				
		}
 	}
	public function gethtml($order_id = 0) {
 		$json = array();
		$html = '';
		
		$rs = $this->getdata();
   	
		if($rs) {
			$ord_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "ponumorder` WHERE order_id = '".$order_id."' order by order_id desc limit 1");
 			
			if($ord_query->row) {
 				$json['ponolabel'] = $rs['ponolabel'];
				$json['pofilelabel'] = $rs['pofilelabel'];
				
				if($rs['ponodisp'] != 2 && !empty($ord_query->row['pono'])) {
					$html .= '<div style="color:#000; font-weight:normal"><b>'. $rs['ponolabel'] . '</b> : '. $ord_query->row['pono'] . '</div>';
				}
				if($rs['pofiledisp'] != 2 && !empty($ord_query->row['pofile'])) {
					$this->load->model('tool/upload');
					$upload_info = $this->model_tool_upload->getUploadByCode($ord_query->row['pofile']);
 					$download_file = '';
					if ($upload_info) {
						$link = $this->url->link('extension/ponum/downloadfile&code=' . $upload_info['code']);
						$download_file = '<a href="'.$link.'">'.$upload_info['name'].'</a>';
					}
 					$html .= '<div style="color:#000; font-weight:normal"><b>'. $rs['pofilelabel'] . '</b> : '. $download_file . '</div>';
				}
  			}
		}
		
		return $html; 
	}
}