<?php
class LogTrimmer {
	private $config;

	public function __construct($registry) {
		$this->config = $registry->get('config');
	}

	public function trim() {
		if (!$this->config->get('module_antropy_logtrim_status')) return [ 'trimmed'=>[], 'errors'=>[] ];

		$which_files = $this->config->get('module_antropy_logtrim_which_files');

		switch ($this->config->get('module_antropy_logtrim_which_files')) {
			case 'all':
				$files = glob(DIR_LOGS . '*');
				break;

			case 'log':
				$files = glob(DIR_LOGS . '*.log');
				break;
		}

		if (empty($files)) {
			return [ 'trimmed'=>[], 'errors'=>[] ];
		}

		$size_threshold = (float)$this->config->get('module_antropy_logtrim_size_threshold') * 1024*1024;
		$leave_lines = (int)$this->config->get('module_antropy_logtrim_leave_lines');

		$trimmed = [];
		$errors = [];

		foreach ($files as $file) if (filesize($file) > $size_threshold) {
			try {
				if ($leave_lines === 0) {
					unlink($file);
				} else {
					self::trimFile($file, $leave_lines);
				}
				$trimmed []= str_replace(DIR_LOGS, '', $file);
			} catch (Exception $e) {
				$errors[str_replace(DIR_LOGS, '', $file)] = $e->getMessage();
			}
		}

		return ['trimmed'=>$trimmed, 'errors'=>$errors ];
	}

	public static function trimFile($file, $lines=500, $newfile=null) {
		if (!file_exists($file)) {
			throw new Exception('the file `'.$file.'` does not exist');
		}

		if (!isset($newfile)) {
			$newfile = $file; // overwrite in-place
		}

		$trimmed_contents = self::readLastLines($file, $lines);

		$result = file_put_contents($newfile, $trimmed_contents);
		if ($result===false) {
			throw new Exception('failed to write trimmed file `'.$newfile.'`: '.error_get_last());
		}
	}

	// https://stackoverflow.com/a/55634720
	public static function readLastLines($filename, $num) {
		$file = new \SplFileObject($filename, 'r');
		$file->seek(PHP_INT_MAX);
		$last_line = $file->key();
		$lines = new \LimitIterator($file, max($last_line - $num, 0), $last_line);
		$arr = iterator_to_array($lines);
		return implode('',$arr);
	}
}