<?php

namespace Sezzle\Services;

use Sezzle\Config;
use Sezzle\HttpClient\ClientService;
use Sezzle\HttpClient\Exception\InvalidRequest;
use Sezzle\Model\Order\Capture;

/**
 * Class CaptureService
 * @package Sezzle\Services
 */
class CaptureService
{
    /**
     * @var ClientService
     */
    private $clientService;

    public function __construct(
        ClientService $clientService
    ) {
        $this->clientService = $clientService;
    }

    /**
     * Capture Payment
     *
     * @param string $orderUUID
     * @param array $payload
     * @return Capture
     * @throws InvalidRequest
     */
    public function capturePayment($orderUUID, array $payload)
    {
        $response = $this->clientService->sendRequest(
            Config::HTTP_POST,
            sprintf(Config::CAPTURE_RESOURCE, $orderUUID),
            $payload
        );
        return Capture::fromArray($response["body"]);
    }
}
