<?php

namespace Sezzle\Services;

use Sezzle\Config;
use Sezzle\HttpClient\ClientService;
use Sezzle\HttpClient\Exception\InvalidRequest;

/**
 * Class ConfigService
 * @package Sezzle\Services
 */
class ConfigService
{
    /**
     * @var ClientService
     */
    private $clientService;

    public function __construct(
        ClientService $clientService
    ) {
        $this->clientService = $clientService;
    }

    /**
     * Send config
     *
     * @param array $payload
     * @return bool
     * @throws InvalidRequest
     */
    public function sendConfig(array $payload)
    {
        $response = $this->clientService->sendRequest(
            Config::HTTP_POST,
            Config::CONFIG_RESOURCE,
            $payload
        );

        return isset($response['status_code']) && $response['status_code'] === strval(http_response_code(204));
    }
}
