<?php

namespace Sezzle\Services;

use Sezzle\Config;
use Sezzle\HttpClient\ClientService;
use Sezzle\HttpClient\Exception\InvalidRequest;
use Sezzle\Model\Order\Refund;

/**
 * Class CaptureService
 * @package Sezzle\Services
 */
class RefundService
{
    /**
     * @var ClientService
     */
    private $clientService;

    public function __construct(
        ClientService $clientService
    ) {
        $this->clientService = $clientService;
    }

    /**
     * Refund Payment
     *
     * @param string $orderUUID
     * @param array $payload
     * @return Refund
     * @throws InvalidRequest
     */
    public function refundPayment($orderUUID, array $payload)
    {
        $response = $this->clientService->sendRequest(
            Config::HTTP_POST,
            sprintf(Config::REFUND_RESOURCE, $orderUUID),
            $payload
        );
        return Refund::fromArray($response["body"]);
    }
}
