<?php
class ControllerExtensionDashboardXabandonedCarts extends Controller {
	private $error = array();
	private $data = array();

	public function __construct($registry) {
		parent::__construct($registry);
		$this->config->load('xtensions/xabandoned');		
		$this->module_token = $this->config->get('xabandoned_token') . '=' . $this->session->data[$this->config->get('xabandoned_token')];
		$this->data += $this->language->load($this->config->get('xabandoned_path'));
		$this->data = $this->language->load($this->config->get('xabandoned_dashboard_path'));
		$this->data['config_pfx'] = $this->xabandoned_dashboard_config_pfx = $this->config->get('xabandoned_dashboard_config_pfx');
		$this->data['module_path'] = $this->config->get('xabandoned_path');
		$this->data['dashboard_path'] = $this->config->get('xabandoned_dashboard_path');
		$this->setting_name = $this->config->get('xabandoned_dashboard_setting');
		$this->load->model($this->config->get('xabandoned_path'));
		$this->module_model_object = $this->{$this->config->get('xabandoned_model')};
		$this->view_extension = $this->config->get('xabandoned_view_extension');
		$this->back_button = $this->url->link($this->config->get('xabandoned_dashboard_back_button'), $this->module_token, true);
		$this->data['module_token'] = $this->module_token;
		$this->data['cancel'] = $this->back_button;
		$this->version_two_point_one = $this->data['version_two_point_one'] = false;
		if(version_compare(VERSION, '2.2.0.0')<0){
			$this->version_two_point_one = $this->data['version_two_point_one'] = true;
		}
	}

	public function index() {
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('setting/setting');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting($this->setting_name, $this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');
			$this->response->redirect($this->back_button);
		}
		$config_data = $this->model_setting_setting->getSetting($this->setting_name);
		$fields = array('status','width','sort_order');
		// @formatter:on		
		foreach ($fields as $field) {
			if (isset($this->request->post[$this->xabandoned_dashboard_config_pfx . $field])) {
				$this->data[$field] = $this->request->post[$this->xabandoned_dashboard_config_pfx . $field];
			} else {
				$this->data[$field] = isset($config_data[$this->xabandoned_dashboard_config_pfx . $field]) ? $config_data[$this->xabandoned_dashboard_config_pfx . $field] : '';
			}
		}

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		$this->breadcrumbs();	

		$this->data['action'] = $this->url->link($this->data['dashboard_path'], '&' . $this->module_token , true);
		$this->data['columns'][] = 12;
		$this->addHeaderFooterLeft();
		$this->response->setOutput($this->view('xabandoned_carts_form', $this->data));
	}
	
	public function dashboard(){	
		if(version_compare(VERSION, '2.2.0.0')<=0 && !$this->config->get($this->config->get('xabandoned_config_pfx').'dashboard')){
			return '';
		}
		$this->document->addScript('view/javascript/xabandonedcarts/Chart.bundle.min.js');
		$this->data['store_path'] = $this->config->get('xabandoned_path');
		$this->data['coupons_sent'] = $this->module_model_object->getTotalCouponsSent();
		$this->data['coupons_used'] = $this->module_model_object->getTotalCouponsUsed();
		$this->data['coupons_sales']	=  $this->module_model_object->getTotalCouponsSales();
		$this->data['coupons_expired'] = $this->module_model_object->getTotalCouponsExpired();
		$this->data['total_activities'] = $this->module_model_object->getAllActivities(array('filter_last_step'=>'all','filter_abandoned_cart'=>'abandoned'));
		$this->data['unsubscribed_activity'] = $this->module_model_object->getUnsubscribedActivities();
		$this->data['unsubscribed_permanently'] = $this->module_model_object->getTotalUnsubscribedPermanently();
		$this->data['mails_sent'] = $this->module_model_object->getMailsSent();
		$this->data['mails_opened'] = $this->module_model_object->getMailsOpened();
		$this->data['module_link'] = $this->url->link($this->data['module_path'], $this->module_token, true);
		$forchart = array('step0'=>0,'step1'=>0,'step2'=>0,'step3'=>0,'step4'=>0);
		$forchart = array_merge($forchart,$this->module_model_object->getActivitiesByStep(array('filter_last_step'=>'all','filter_abandoned_cart'=>'abandoned')));
		$this->data['forchart'] = implode(',', $forchart);
		return $this->view('xabandoned_carts_info', $this->data);
	}
	
	private function breadcrumbs($data=array()){	
		$this->data['breadcrumbs'][] = array('text' => $this->language->get('text_home'),'href' => $this->url->link('common/dashboard', $this->module_token, true));
		$this->data['breadcrumbs'][] = array('text' => $this->language->get('text_extension'),'href' => $this->back_button);
		$this->data['breadcrumbs'][] = array('text' => $this->language->get('heading_title'),'href' => $this->url->link($this->data['dashboard_path'], '&' . $this->module_token , true));

		foreach($data as $link){
			$this->data['breadcrumbs'][] = array('text'=>$link['text'],'href'=>$link['href']);
		}
	}
	
	private function addHeaderFooterLeft(){
		$this->data['header'] = $this->load->controller('common/header');
		$this->data['column_left'] = $this->load->controller('common/column_left');
		$this->data['footer'] = $this->load->controller('common/footer');
	}
	
	private function view($template,$data){
		return $this->load->view($this->config->get('xabandoned_dashboard_view').'/'.$template.$this->view_extension,$data);
	}
	
	private function validate(){
		if (!$this->user->hasPermission('modify', $this->data['dashboard_path'])) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}
