<?php
class ControllerExtensionModuleAntropyLogtrim extends Controller {
	private $error = [];

	public function index() {
		$this->load->language('extension/module/antropy_logtrim');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('module_antropy_logtrim', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token='.$this->session->data['user_token'] . '&type=module', true));
		}

		foreach ([
			'warning',
			'size_threshold',
			'leave_lines',
		] as $error_key) {
			if (isset($this->error[$error_key])) {
				$data['error_'.$error_key] = $this->error[$error_key];
			} else {
				$data['error_'.$error_key] = '';
			}
		}

		$data['breadcrumbs'] = [
			[	'text' => $this->language->get('text_home'),
				'href' => $this->url->link('common/dashboard', 'user_token='.$this->session->data['user_token'], true)
			],
			[	'text' => $this->language->get('text_extension'),
				'href' => $this->url->link('marketplace/extension', 'user_token='.$this->session->data['user_token'] . '&type=module', true)
			],
			[	'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('extension/module/antropy_logtrim', 'user_token='.$this->session->data['user_token'], true)
			]
		];

		$data['action'] = $this->url->link('extension/module/antropy_logtrim', 'user_token='.$this->session->data['user_token'], true);
		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token='.$this->session->data['user_token'] . '&type=module', true);

		foreach ([
			'status', 'which_files', 'size_threshold', 'leave_lines', 'cron_authkey',
		] as $key) {
			if (isset($this->request->post['module_antropy_logtrim_'.$key])) {
				$data['module_antropy_logtrim_'.$key] = $this->request->post['module_antropy_logtrim_'.$key];
			} else {
				$data['module_antropy_logtrim_'.$key] = $this->config->get('module_antropy_logtrim_'.$key);
			}
		}

		$data['options_which_files'] = [
			'log' => $this->language->get('text_files_log'),
			'all' => $this->language->get('text_files_all'),
		];

		$data['HTTPS_CATALOG'] = HTTPS_CATALOG;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/antropy_logtrim', $data));
	}

	protected function validate() {
		return true;
	}

	// install/uninstall //

	public function install() {
		$this->load->model('setting/setting');

		foreach ([
			'status'         => 1,
			'which_files'    => 'log',
			'size_threshold' => 5,
			'leave_lines'    => 100,
			'cron_authkey'   => token(32),
		] as $key=>$value) {
			$defaults['module_antropy_logtrim_'.$key] = $value;
		}

		$this->model_setting_setting->editSetting('module_antropy_logtrim', $defaults);
	}

	public function uninstall() {
		$this->load->model('setting/setting');

		$this->model_setting_setting->deleteSetting('module_antropy_logtrim');
	}
}