<?php
class ControllerExtensionponum extends Controller {
	private $error = array();  
	private $modpath = 'extension/ponum';
	private $modtpl = 'extension/ponum.tpl';
	private $modssl = 'SSL';
	private $user_token_str = '';
	public function __construct($registry) {
		parent::__construct($registry);
 		
		if(substr(VERSION,0,3)>='3.0' || substr(VERSION,0,3)=='2.3') { 
 			$this->modpath = 'extension/ponum';
 			$this->modtpl = 'extension/ponum';
  		} else if(substr(VERSION,0,3)=='2.2') {
 			$this->modtpl = 'extension/ponum';
		} 
		 
		if(substr(VERSION,0,3)>='3.0') { 
 			$this->token_str = 'user_token=' . $this->session->data['user_token'];
		} else {
			$this->token_str = 'token=' . $this->session->data['token'];
		}
		
		if(substr(VERSION,0,3)>='3.0' || substr(VERSION,0,3)=='2.3' || substr(VERSION,0,3)=='2.2') { 
			$this->modssl = true;
		} 
 	} 

	public function index() {
		$data = $this->load->language($this->modpath);

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model($this->modpath);
		
		$this->model_extension_ponum->checkdb();
		
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', $this->token_str, $this->modssl)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link($this->modpath, $this->token_str, $this->modssl)
		);
		
		if(substr(VERSION,0,3)>='3.0') { 
 			$data['user_token'] = $this->session->data['user_token']; 
		} else {
			$data['token'] = $this->session->data['token'];
		}
		
		$data['action'] = $this->url->link($this->modpath, $this->token_str, $this->modssl);
		$data['cancel'] = $this->url->link('common/dashboard', $this->token_str, $this->modssl);
		
		$data['stores'] = $this->model_extension_ponum->getStores();
		$data['languages'] = $this->model_extension_ponum->getLang();
 		 
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$this->session->data['success'] = $this->language->get('text_success');
			$this->model_extension_ponum->add($this->request->post);
		}
 		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
 			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}
		
 		$rs = $this->model_extension_ponum->getdata();
    		 
		if (isset($this->request->post['desc'])) {
			$data['desc'] = $this->request->post['desc'];
		} elseif ($rs) {
			$data['desc'] = $rs;
 		} else {
			$data['desc'] = array();
			
			foreach($data['stores'] as $store_id => $storedata) {
				$ponolabel = array();
				$ponoerr = array();
				$pofilelabel = array();
				$pofileerr = array();
				
				foreach($data['languages'] as $language) {					
					$ponolabel[$language['language_id']] = 'PO Number';
					$ponoerr[$language['language_id']] = 'PO Number is invalid';
					$pofilelabel[$language['language_id']] = 'PO File';
					$pofileerr[$language['language_id']] = 'PO file is invalid';
				}
				
				$data['desc'][$store_id] = array(
					'status' => 0,
					'themenm' => 'def',
					'ponodisp' => 0,
 					'pofiledisp' => 0,
					'ponolabel' => $ponolabel,
					'ponoerr' => $ponoerr,
					'pofilelabel' => $pofilelabel,
					'pofileerr' => $pofileerr,
  				);
			}
			//print_r($data['desc']);exit;
 		} 
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view($this->modtpl, $data));
	}
	public function getsetting() {
		$json = array();
		$this->load->model('extension/ponum');
		$json = $this->model_extension_ponum->getsetting();
 		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json,true));	
	}
	public function getorderinfo() {
		$json = array();
		$this->load->model('extension/ponum');
		if(!empty($this->request->get['order_id'])) { 
			$json = $this->model_extension_ponum->getorderinfo($this->request->get['order_id']);
		}
 		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json,true));	
	}
	public function saveorderedit() {
		$json = array();
		$this->load->model('extension/ponum');
		if(!empty($this->request->get['order_id'])) { 
			$json = $this->model_extension_ponum->saveorderedit($this->request->post, $this->request->get['order_id']);
		}
 		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json,true));	
	}
	public function upload() {
		$this->load->language($this->modpath);

		$json = array();

		if (!empty($this->request->files['file']['name']) && is_file($this->request->files['file']['tmp_name'])) {
			// Sanitize the filename
			$filename = basename(preg_replace('/[^a-zA-Z0-9\.\-\s+]/', '', html_entity_decode($this->request->files['file']['name'], ENT_QUOTES, 'UTF-8')));

			// Validate the filename length
			if ((utf8_strlen($filename) < 3) || (utf8_strlen($filename) > 64)) {
				$json['error'] = $this->language->get('error_filename');
			}

			// Allowed file extension types
			$allowed = array();

			$extension_allowed = preg_replace('~\r?\n~', "\n", $this->config->get('config_file_ext_allowed'));

			$filetypes = explode("\n", $extension_allowed);

			foreach ($filetypes as $filetype) {
				$allowed[] = trim($filetype);
			}

			if (!in_array(strtolower(substr(strrchr($filename, '.'), 1)), $allowed)) {
				$json['error'] = $this->language->get('error_filetype');
			}

			// Allowed file mime types
			$allowed = array();

			$mime_allowed = preg_replace('~\r?\n~', "\n", $this->config->get('config_file_mime_allowed'));

			$filetypes = explode("\n", $mime_allowed);

			foreach ($filetypes as $filetype) {
				$allowed[] = trim($filetype);
			}

			if (!in_array($this->request->files['file']['type'], $allowed)) {
				$json['error'] = $this->language->get('error_filetype');
			}

			// Check to see if any PHP files are trying to be uploaded
			$content = file_get_contents($this->request->files['file']['tmp_name']);

			if (preg_match('/\<\?php/i', $content)) {
				$json['error'] = $this->language->get('error_filetype');
			}

			// Return any upload error
			if ($this->request->files['file']['error'] != UPLOAD_ERR_OK) {
				$json['error'] = $this->language->get('error_upload_' . $this->request->files['file']['error']);
			}
		} else {
			$json['error'] = $this->language->get('error_upload');
		}

		if (!$json) {
			$file = $filename . '.' . user_token(32);

			move_uploaded_file($this->request->files['file']['tmp_name'], DIR_UPLOAD . $file);

			// Hide the uploaded file name so people can not link to it directly.
			$this->load->model('tool/upload');

			$json['code'] = $this->model_tool_upload->addUpload($filename, $file);
			
			$json['filename'] = $filename;

			$json['success'] = $this->language->get('text_upload');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	public function downloadfile() {
		$this->load->model('tool/upload');

		$code = 0;
		if (isset($this->request->get['code'])) {
			$code = $this->request->get['code'];
		}

		$upload_info = $this->model_tool_upload->getUploadByCode($code);

		if ($upload_info) {
			$file = DIR_UPLOAD . $upload_info['filename'];
			$mask = basename($upload_info['name']);

			if (!headers_sent()) {
				if (is_file($file)) {
					header('Content-Type: application/octet-stream');
					header('Content-Description: File Transfer');
					header('Content-Disposition: attachment; filename="' . ($mask ? $mask : basename($file)) . '"');
					header('Content-Transfer-Encoding: binary');
					header('Expires: 0');
					header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
					header('Pragma: public');
					header('Content-Length: ' . filesize($file));
					readfile($file, 'rb');
					exit;
				} else {
					exit('Error: Could not find file ' . $file . '!');
				}
			} else {
				exit('Error: Headers already sent out!');
			}
		} 
	}
	protected function validateForm() {
		if (!$this->user->hasPermission('modify', $this->modpath)) {
			$this->error['warning'] = $this->language->get('error_permission');
		}		
		return !$this->error;
	}
}
