<?php
class ControllerExtensionStorecart extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/store_cart');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/store_cart');
		$this->load->model('setting/store');
		
		$this->load->model('extension/customer_cart');
		
		$this->load->model('extension/coupons');
		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
		
			$this->model_setting_setting->editSetting('crownjob', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/store_cart', 'user_token=' . $this->session->data['user_token'], true));
		}
		
		$data['heading_title'] = $this->language->get('heading_title');
		
		if(!empty($this->request->get['customer_id'])) {
			$customer_id = $this->request->get['customer_id'];
		}else{
			$customer_id = 0;
		}
		
		$data['stores'] = array();
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/store_cart', 'user_token=' . $this->session->data['user_token'], true)
		);
		
		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}
		
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		if (isset($this->error['error_keynotfound'])) {
				$data['error_keynotfound'] = $this->error['error_keynotfound'];
			} else {
				$data['error_keynotfound'] = '';
			} 	
		
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_view'] = $this->language->get('text_view');
		
		$data['text_product'] = $this->language->get('text_product');
		$data['text_email_notify'] = $this->language->get('text_email_notify');
		$data['text_unuse_coupon'] = $this->language->get('text_unuse_coupon');
		$data['text_coupon'] = $this->language->get('text_coupon');
		$data['text_order'] = $this->language->get('text_order');
		$data['text_customer'] = $this->language->get('text_customer');
		$data['text_notify_customer_order'] = $this->language->get('text_notify_customer_order');
		$data['text_crownjob'] = $this->language->get('text_crownjob');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		
		$data['entry_mail_template'] = $this->language->get('entry_mail_template');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_period'] = $this->language->get('entry_period');
		
		$data['button_save'] = $this->language->get('button_save');
		
		$data['cronurl'] = HTTP_CATALOG . 'index.php?route=extension/cron';
		
		if (isset($this->error['crownjob_period'])) {
			$data['error_crownjob_period'] = $this->error['crownjob_period'];
		} else {
			$data['error_crownjob_period'] = '';
		}
		
		if (isset($this->error['crownjob_template'])) {
			$data['error_crownjob_template'] = $this->error['crownjob_template'];
		} else {
			$data['error_crownjob_template'] = '';
		}
		/* new code */
		if (isset($this->error['crownjob_cartimage_width'])) {
			$data['error_store_cartimage'] = $this->error['crownjob_cartimage_width'];
		} else {
			$data['error_store_cartimage'] = '';
		}
		
		if (isset($this->error['crownjob_cartimage_width'])) {
			$data['error_store_cartimage'] = $this->error['crownjob_cartimage_width'];
		} else {
			$data['error_store_cartimage'] = array();
		}
		
		/* new code */
		
		if (isset($this->request->post['crownjob_stores'])) {
			$data['crownjob_stores'] = $this->request->post['crownjob_stores'];
		} else if (!empty($this->config->get('crownjob_stores'))) {
			$data['crownjob_stores'] = $this->config->get('crownjob_stores');
		}else {
			$data['crownjob_stores'] = array();
		}
		
		$data['action'] = $this->url->link('extension/store_cart', 'user_token=' . $this->session->data['user_token'], true);
		$data['user_token'] = $this->session->data['user_token'];
		if (isset($this->request->post['crownjob_storecart_template_id'])) {
			$data['crownjob_storecart_template_id'] = $this->request->post['crownjob_storecart_template_id'];
		} else {
			$data['crownjob_storecart_template_id'] = $this->config->get('crownjob_storecart_template_id');
		}	
		
		if (isset($this->request->post['crownjob_period'])) {
			$data['crownjob_period'] = $this->request->post['crownjob_period'];
		} else {
			$data['crownjob_period'] = $this->config->get('crownjob_period');
		}
		
		if (isset($this->request->post['crownjob_status'])) {
			$data['crownjob_status'] = $this->request->post['crownjob_status'];
		} else {
			$data['crownjob_status'] = $this->config->get('crownjob_status');
		}
		
		if (isset($this->request->post['crownjob_smsstatus'])) {
			$data['crownjob_smsstatus'] = $this->request->post['crownjob_smsstatus'];
		} else {
			$data['crownjob_smsstatus'] = $this->config->get('crownjob_smsstatus');
		}
		
		if (isset($this->request->post['crownjob_dltid'])) {
			$data['crownjob_dltid'] = $this->request->post['crownjob_dltid'];
		} else {
			$data['crownjob_dltid'] = $this->config->get('crownjob_dltid');
		}


		if (isset($this->request->post['crownjob_duration'])) {
			$data['crownjob_duration'] = $this->request->post['crownjob_duration'];
		} else {
			$data['crownjob_duration'] = $this->config->get('crownjob_duration');
		}
		
		if (isset($this->request->post['crownjob_emailgoes'])) {
			$data['crownjob_emailgoes'] = $this->request->post['crownjob_emailgoes'];
		} else {
			$data['crownjob_emailgoes'] = $this->config->get('crownjob_emailgoes');
		}
		
		if (isset($this->request->post['crownjob_coupondiscount'])) {
			$data['crownjob_coupondiscount'] = $this->request->post['crownjob_coupondiscount'];
		} else {
			$data['crownjob_coupondiscount'] = $this->config->get('crownjob_coupondiscount');
		}
		
		if (isset($this->request->post['crownjob_coupondatestart'])) {
			$data['crownjob_coupondatestart'] = $this->request->post['crownjob_coupondatestart'];
		} else {
			$data['crownjob_coupondatestart'] = $this->config->get('crownjob_coupondatestart');
		}
		
		if (isset($this->request->post['crownjob_coupondateend'])) {
			$data['crownjob_coupondateend'] = $this->request->post['crownjob_coupondateend'];
		} else {
			$data['crownjob_coupondateend'] = $this->config->get('crownjob_coupondateend');
		}
		
		if (isset($this->request->post['crownjob_smsmethod'])) {
			$data['crownjob_smsmethod'] = $this->request->post['crownjob_smsmethod'];
		} else {
			$data['crownjob_smsmethod'] = $this->config->get('crownjob_smsmethod');
		}
		
		if (isset($this->request->post['crownjob_url'])) {
			$data['crownjob_url'] = $this->request->post['crownjob_url'];
		} else {
			$data['crownjob_url'] = $this->config->get('crownjob_url');
		}
		
		if (isset($this->request->post['crownjob_key'])) {
			$data['crownjob_key'] = $this->request->post['crownjob_key'];
		} else {
			$data['crownjob_key'] = $this->config->get('crownjob_key');
		}
		
		if (isset($this->request->post['crownjob_secretkey'])) {
			$data['crownjob_secretkey'] = $this->request->post['crownjob_secretkey'];
		} else {
			$data['crownjob_secretkey'] = $this->config->get('crownjob_secretkey');
		}
		
		if (isset($this->request->post['crownjob_masterkey'])) {
			$data['crownjob_masterkey'] = $this->request->post['crownjob_masterkey'];
		} else {
			$data['crownjob_masterkey'] = $this->config->get('crownjob_masterkey');
		}
		
		/* new code */
		$data['entry_image_cart'] = $this->language->get('entry_image_cart');
		$data['entry_width'] = $this->language->get('entry_width');
		$data['entry_height'] = $this->language->get('entry_height');
		
		if (isset($this->request->post['crownjob_cartimage_width'])) {
			$data['crownjob_cartimage_width'] = $this->request->post['crownjob_cartimage_width'];
		} else {
			$data['crownjob_cartimage_width'] = $this->config->get('crownjob_cartimage_width');
		}
		
		if (isset($this->request->post['crownjob_cartimage_height'])) {
			$data['crownjob_cartimage_height'] = $this->request->post['crownjob_cartimage_height'];
		} else {
			$data['crownjob_cartimage_height'] = $this->config->get('crownjob_cartimage_height');
		}
		/* new code */
		$this->load->model('extension/mail_template');
		
		$data['storecart_templates'] = $this->model_extension_mail_template->getMailTemplates();
		
		$data['periods'] = array();
		$data['periods'][] = array(
			'id'      	=> '1 hour',
			'name'      => $this->language->get('text_hourly'),
		);
		$data['periods'][] = array(
			'id'      	=> '1 day',
			'name'      => $this->language->get('text_daily'),
		);
		
		$data['periods'][] = array(
			'id'      	=> '7 day',
			'name'      => $this->language->get('text_weekly'),
		);
		
		$data['periods'][] = array(
			'id'      	=> '1 month',
			'name'      => $this->language->get('text_monthly'),
		);
		
		$url = '';

		$data['product_link'] = $this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['customer_cart_link'] = $this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['customer_cart_notify_link'] = $this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'] . '&filter_notify=1', true);
		$data['customer_cart_notify_completed_link'] = $this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'] . '&filter_notify_order=1', true);
		$data['coupon_link'] = $this->url->link('extension/coupons', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['unuse_coupon_link'] = $this->url->link('extension/customer_cart', 'user_token=' . $this->session->data['user_token'] . $url, true);
		
		// Total All Products
		$data['total_storecart_products'] = $this->model_extension_store_cart->getTotalStorecartProducts();
		
		
		// Total Carts Group BY email
		$data['total_abandoned_carts'] = $this->model_extension_customer_cart->getTotalStoreCartCustomers();
		
		// Total Notify Carts Group BY email
		$filter_data = array(
			'filter_notify'  => 1,
		);
		$data['total_email_notify'] = $this->model_extension_customer_cart->getTotalStoreCartCustomers($filter_data);
		
		
		// Total Notify Orders Customers Group BY email
		$filter_data = array(
			'filter_notify_order'  => 1,
		);
		$data['total_notify_orders_customers'] = $this->model_extension_customer_cart->getTotalStoreCartCustomers($filter_data);		
		
		// Total Coupons
		$filter_data = array(
			'filter_notify_order'  => 1,
		);
		$data['total_used_coupons'] = $this->model_extension_store_cart->getTotalUseCoupons();
		
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['store_cart_menu'] = $this->load->controller('extension/store_cart_menu');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/store_cart', $data));
	}
	
	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/store_cart')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		foreach ($this->request->post['crownjob_stores'] as $store_id => $value) {
			if (empty($value['storecart_template_id'])) {
				$this->error['crownjob_template'][$store_id] = $this->language->get('error_crownjob_template');
			}

			if (empty($value['cartimage_width']) || empty($value['cartimage_height'])) {
				$this->error['crownjob_cartimage_width'][$store_id] = $this->language->get('error_store_cartimage');
			}
	//echo'<pre>';print_r($value['cartimage_width']);die();
		}
		/* new code */
		$key=$this->config->get('moduledata_abandonedcart_key');
			if (empty(trim($key))) {			
				 $this->error['warning'] ='Module will Work after add License key!';
			}
		
		return !$this->error;
	}
}
