<?php
class ControllerExtensionModuleGoogleEcommerce extends Controller {
	public function get_product_info() {
		if (isset($this->request->get['product_id'])){
			$product_id = (int)$this->request->get['product_id'];			
			$list_name = '';
			
			if (isset($_SERVER['HTTP_REFERER'])) {
				$referrer = parse_url($_SERVER['HTTP_REFERER']);
				if (isset($referrer['query'])) {
					parse_str($referrer['query'], $get);
				}
				if (isset($get['route'])) {
					$path_route = $get['route'];
					$path_route = explode('/',$path_route);
					$page_type = $path_route[0];
					$list_name = ucfirst($page_type).' Page';
				}else if (isset($referrer['path'])) { 
					$keywords = explode('/',$referrer['path']);
					$keyword = end($keywords);
					
					if (version_compare(VERSION,'3.0.0.0','<' )) {
						$query = $this->db->query("SELECT `query` FROM ".DB_PREFIX."url_alias WHERE keyword = '".$this->db->escape($keyword)."' LIMIT 1");
					}else{
						$query = $this->db->query("SELECT `query` FROM ".DB_PREFIX."seo_url WHERE keyword = '".$this->db->escape($keyword)."' LIMIT 1");
					}
					
					if ($query->row) {
						$page_type = $query->row['query'];
						$page_type = explode('=',$page_type);
						$page_type = $page_type[0];
						$page_type = str_replace('_id', '', $page_type);
						$list_name = ucfirst($page_type).' Page';
					}else{
					    $list_name = ucfirst($keyword);
					}
				}
			}	
			
			if ($list_name == '') {
			    $list_name = 'Home Page';
			}		
			
			$this->session->data['ga_ec_listname_product_'.$product_id] = $list_name;
			
			$this->load->model('extension/module/google_ecommerce');
			$this->load->model('catalog/product');
			
			$ga_ecom_id = ($this->config->get('ga_ecom_id'))? $this->config->get('ga_ecom_id') : 'product_id';
			$ga_ecom_currency 		= (isset($extn_info['ga_ecom_currency']))? $extn_info['ga_ecom_currency'] : $this->config->get('config_currency');
			$ga_ecom_language_id 	= (isset($extn_info['ga_ecom_language_id']))? $extn_info['ga_ecom_language_id'] : '0';
			
			if ($ga_ecom_language_id <> 0) {
				$language_id = $ga_ecom_language_id;
			}else{
				$language_id = $this->config->get('config_language_id');
			}

			$product_info = $this->model_catalog_product->getProduct($product_id);
			
			if ($ga_ecom_id == 'sku') {
				$id 	= $this->model_extension_module_google_ecommerce->getProductSku($product_info['product_id']);
			} else {
				$id 	= $product_info['product_id'];
			}
			
			$product_name	 	= $this->model_extension_module_google_ecommerce->getProductName($product_info['product_id'], $language_id);
			$brand				= $this->model_extension_module_google_ecommerce->getProductBrand($product_info['product_id']);
			$category			= $this->model_extension_module_google_ecommerce->getProductCategory($product_info['product_id'], $language_id);
			
			if ((float)$product_info['special']) {
				$price = $this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax'));
			} else {
				$price = $this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax'));
			}
			
			$ga_parameters = array(
				'id'		=> 	$id,
				'name'		=>	$product_name,
				'list_name'	=>	$list_name,
				'brand'		=>	$brand,
				'category'	=>	$category,
				'price'		=>  $price
			);

			$fb_parameters = array(
				'content_name'		=> 	$product_name,
				'content_category'	=>	$category,
				'content_ids'		=>	array($id),
				'content_type'		=>	'product',
				'currency'			=>	$ga_ecom_currency,
				'value'				=>  $price
			);
			
			$json['product_info'] = $ga_parameters;

			$this->model_extension_module_google_ecommerce->addlog('Select Content / Add to Cart / Remove from Cart');
			$this->model_extension_module_google_ecommerce->addlog('+ GTAG - '.json_encode($json['product_info']));

			if ($this->config->get('ga_ecom_fb_px_status')){
				$json['pixel_info'] = $fb_parameters;
				$this->model_extension_module_google_ecommerce->addlog('+ PIXEL - '.json_encode($json['pixel_info']));
			}
		}else{
			$json['error'] = 'Product ID not mentioned';
		}
		
		if (isset($this->request->server['HTTP_ORIGIN'])) {
			$this->response->addHeader('Access-Control-Allow-Origin: ' . $this->request->server['HTTP_ORIGIN']);
			$this->response->addHeader('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
			$this->response->addHeader('Access-Control-Max-Age: 1000');
			$this->response->addHeader('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));	
	}
	
	public function select_item() {
		if (isset($this->request->get['product_id'])){
			$product_id = (int)$this->request->get['product_id'];			
			$list_name = (isset($this->request->get['list_name']))? $this->request->get['list_name'] : 'Undefined';
			$list_id = strtolower($list_name);
			$list_id = str_replace(' ','_',$list_id);
			
			$this->load->model('extension/module/google_ecommerce');
			$this->load->model('catalog/product');
			
			$ga_ecom_id = ($this->config->get('ga_ecom_id'))? $this->config->get('ga_ecom_id') : 'product_id';
			$ga_ecom_currency 		= (isset($extn_info['ga_ecom_currency']))? $extn_info['ga_ecom_currency'] : $this->config->get('config_currency');
			$ga_ecom_language_id 	= (isset($extn_info['ga_ecom_language_id']))? $extn_info['ga_ecom_language_id'] : '0';
			
			if ($ga_ecom_language_id <> 0) {
				$language_id = $ga_ecom_language_id;
			}else{
				$language_id = $this->config->get('config_language_id');
			}

			$product_info = $this->model_catalog_product->getProduct($product_id);
			
			if ($ga_ecom_id == 'sku') {
				$id 	= $this->model_extension_module_google_ecommerce->getProductSku($product_info['product_id']);
			} else {
				$id 	= $product_info['product_id'];
			}
			
			$product_name	 	= $this->model_extension_module_google_ecommerce->getProductName($product_info['product_id'], $language_id);
			$brand				= $this->model_extension_module_google_ecommerce->getProductBrand($product_info['product_id']);
			$category			= $this->model_extension_module_google_ecommerce->getProductCategory($product_info['product_id'], $language_id);
			
			if ((float)$product_info['special']) {
				$price = $this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax'));
			} else {
				$price = $this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax'));
			}
			
			$ga_parameters = array(
				'item_id'		=> 	$id,
				'item_name'		=>	$product_name,
				'quantity'      => 1,
				'item_brand'	=>	$brand,
				'item_category'	=>	$category,
				'price'		    =>  $price,
				'item_list_name'=>  $list_name,
				'item_list_id'	=>  $list_id,
				'currency'  	=> $ga_ecom_currency
			);
			
			$json['product_info'] = $ga_parameters;

			$this->model_extension_module_google_ecommerce->addlog('Select Item');
			$this->model_extension_module_google_ecommerce->addlog('+ GTAG - '.json_encode($json['product_info']));

		}else{
			$json['error'] = 'Product ID not mentioned';
		}
		
		if (isset($this->request->server['HTTP_ORIGIN'])) {
			$this->response->addHeader('Access-Control-Allow-Origin: ' . $this->request->server['HTTP_ORIGIN']);
			$this->response->addHeader('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
			$this->response->addHeader('Access-Control-Max-Age: 1000');
			$this->response->addHeader('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));	
	}
	
	public function build_checkout_progress() {
		$this->load->model('extension/module/google_ecommerce');

		if (isset($this->request->post['step'])){
			$step = ' - '.$this->request->post['step'];
		}else{
			$step = '';
		}

		$item_data = array();
		$ga_ecom_id = ($this->config->get('ga_ecom_id'))? $this->config->get('ga_ecom_id') : 'product_id';
		$ga_ecom_currency = ($this->config->get('ga_ecom_currency'))? $this->config->get('ga_ecom_currency') : $this->config->get('config_currency');
		$ga_ecom_language_id = ($this->config->get('ga_ecom_language_id'))? $this->config->get('ga_ecom_language_id') : '0';

		if ($ga_ecom_language_id <> 0) {
			$language_id = $ga_ecom_language_id;
		}else{
			$language_id = $this->config->get('config_language_id');
		}

		$products = $this->cart->getProducts();
		
		if ($products) {
			foreach ($products as $product) {
				$product_id = $product['product_id'];
				
				if (isset($this->session->data['ga_ec_listname_product_'.$product_id])){
					$list_name = $this->session->data['ga_ec_listname_product_'.$product_id];
				}else{
					$list_name = 'Checkout Page';
				}
				
				$item_data[] = array(
						'id'			=> ($ga_ecom_id == 'sku')? $this->getProductSku($product['product_id']) : $product['product_id'],
						'name'			=> $this->model_extension_module_google_ecommerce->getProductName($product['product_id'], $language_id),
						'list_name'		=> $list_name,
						'brand'			=> $this->model_extension_module_google_ecommerce->getProductBrand($product['product_id']),
						'category'		=> $this->model_extension_module_google_ecommerce->getProductCategory($product['product_id'], $language_id),
						'quantity'		=> (float)$product['quantity'],
						'price'			=> number_format($product['price'], 2, '.', '')
					);
			}
		}
		
		$json['success'] = $item_data;

		$this->model_extension_module_google_ecommerce->addlog('CHECKOUT STEPS'.$step);
		$this->model_extension_module_google_ecommerce->addlog('+ GTAG - '.json_encode($json['success']));
		
		if (isset($this->request->server['HTTP_ORIGIN'])) {
			$this->response->addHeader('Access-Control-Allow-Origin: ' . $this->request->server['HTTP_ORIGIN']);
			$this->response->addHeader('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
			$this->response->addHeader('Access-Control-Max-Age: 1000');
			$this->response->addHeader('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));	

	}
}
?>