<?php
//==============================================================================
// MailChimp Integration Pro v2022-9-21
// 
// Author: Clear Thinking, LLC
// E-mail: johnathan@getclearthinking.com
// Website: http://www.getclearthinking.com
// 
// All code within this file is copyright Clear Thinking, LLC.
// You may not copy or reuse code within this file without written permission.
//==============================================================================

//namespace Opencart\Catalog\Controller\Extension\MailchimpIntegration\Module;
//class MailchimpIntegration extends \Opencart\System\Engine\Controller {

class ControllerExtensionModuleMailchimpIntegration extends Controller {
	
	private $type = 'module';
	private $name = 'mailchimp_integration';
	
	//==============================================================================
	// popup()
	//==============================================================================
	public function popup(&$route = '', &$input = array(), &$output = array()) {
		$prefix = (version_compare(VERSION, '3.0', '<')) ? '' : $this->type . '_';
		if (!$this->config->get($prefix . $this->name . '_modules_popup')) return;
		
		$popup = $this->index(true);
		
		if (version_compare(VERSION, '4.0', '<')) {
			return $popup;
		} else {
			$output .= $popup;
		}
	}
	
	//==============================================================================
	// index()
	//==============================================================================
	public function index($popup = false) {
		$data['settings'] = $this->getSettings();
		$data['type'] = $this->type;
		$data['name'] = $this->name;
		
		$data['popup'] = ($popup && $data['settings']['modules_popup']);
		if (empty($_COOKIE[$this->name . '_popup']) && $data['popup'] == 'auto') {
			$cookie_length = (!empty($data['settings']['modules_popup_cookie'])) ? time() + 60*60*24*(int)$data['settings']['modules_popup_cookie'] : 0;
			setcookie($this->name . '_popup', 'triggered', $cookie_length, '/');
			$data['trigger_popup'] = true;
		}
		
		$data = array_merge($data, $this->load->language('account/address'));
		$data = array_merge($data, $this->load->language('account/edit'));
		$data['language'] = (isset($this->session->data['language'])) ? $this->session->data['language'] : $this->config->get('config_language');
		
		if (empty($data['settings']['status'])) {
			return;
		}
		
		if (empty($data['settings']['apikey']) || empty($data['settings']['listid'])) {
			return '<span style="color: red">You must fill in your API Key, and choose a list to sync with in the List Settings tab, before the module will work.</span>';
		}
		
		// Set customer data
		$data['email'] = $this->customer->getEmail();
		$data['subscribed'] = $this->customer->getNewsletter();
		
		// Load library
		$address_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "address WHERE address_id = " . (int)$this->customer->getAddressId());
		$address = (!empty($address_query->row)) ? $address_query->row : array();
		
		$mailchimp_integration = $this->loadMailchimp();
		$data['settings']['listid'] = $mailchimp_integration->determineList(array('customer_group_id' => (int)$this->customer->getGroupId()), $address);
		
		// Check for module lists choice
		if (!empty($data['settings']['modules_lists']) && empty($data['settings']['interest_groups'])) {
			if (empty($this->session->data['mailchimp_lists'])) {
				$this->session->data['mailchimp_lists'] = array();
				$this->session->data['mailchimp_subscribed_lists'] = array();
				
				foreach ($mailchimp_integration->getLists() as $list) {
					$this->session->data['mailchimp_lists'][$list['id']] = $list['name'];
					if (!empty($data['email'])) {
						$member_info = $mailchimp_integration->getMemberInfo($list['id'], $data['email']);
						if (!empty($member_info)) {
							$this->session->data['mailchimp_subscribed_lists'][] = $list['id'];
						}
					}
				}
				
				asort($this->session->data['mailchimp_lists']);
			}
			
			$data['mailchimp_lists'] = $this->session->data['mailchimp_lists'];
			$data['subscribed_lists'] = $this->session->data['mailchimp_subscribed_lists'];
		}
		
		// Check for interest groups
		$route = (!empty($this->request->get['route'])) ? $this->request->get['route'] : '';
		$display_routes = str_replace(array(' ', "\n", '%'), '', $data['settings']['display_routes']);
		$eligible_route = false;
		
		foreach (explode(',', $display_routes) as $display_route) {
			if (empty($display_route)) continue;
			if (strpos($route, $display_route) !== false) {
				$eligible_route = true;
			}
		}
		
		if (!empty($data['settings']['interest_groups']) && (empty($data['settings']['display_routes']) || $eligible_route)) {
			if (empty($this->session->data['mailchimp_interest_groups'])) {
				$this->session->data['mailchimp_interest_groups'] = $mailchimp_integration->getInterestGroups($data['settings']['listid']);
				$this->session->data['mailchimp_interests'] = array();
				
				$member_info = $mailchimp_integration->getMemberInfo($data['settings']['listid'], $data['email']);
				
				if ($this->customer->isLogged()) {
					foreach ($this->session->data['mailchimp_interest_groups'] as $interest_group) {
						foreach ($interest_group['interests'] as $interest) {
							if (!empty($member_info['interests'][$interest['id']])) {
								$this->session->data['mailchimp_interests'][$interest_group['id']][] = $interest['name'];
							}
						}
					}
				}
			}
			$data['interest_groups'] = $this->session->data['mailchimp_interest_groups'];
			$data['interests'] = $this->session->data['mailchimp_interests'];
		} else {
			$data['interest_groups'] = array();
			$data['interests'] = array();
		}
		
		// Set country/zone data
		$this->load->model('localisation/country');
		$data['countries'] = $this->model_localisation_country->getCountries();
		$data['country_id'] = $this->config->get('config_country_id');
		$data['zone_id'] = $this->config->get('config_zone_id');
		
		// Render
		$theme = (version_compare(VERSION, '2.2', '<')) ? $this->config->get('config_template') : $this->config->get('theme_default_directory');
		$template = (file_exists(DIR_TEMPLATE . $theme . '/template/extension/' . $this->type . '/' . $this->name . '.twig')) ? $theme : 'default';
		
		if (version_compare(VERSION, '4.0', '<')) {
			$template_file = DIR_TEMPLATE . $template . '/template/extension/' . $this->type . '/' . $this->name . '.twig';
		} elseif (defined('DIR_EXTENSION')) {
			$template_file = DIR_EXTENSION . $this->name . '/catalog/view/template/' . $this->type . '/' . $this->name . '.twig';
		}
		
		if (is_file($template_file)) {
			extract($data);
			
			ob_start();
			if (version_compare(VERSION, '4.0', '<')) {
				require(class_exists('VQMod') ? \VQMod::modCheck(modification($template_file)) : modification($template_file));
			} else {
				require(class_exists('VQMod') ? \VQMod::modCheck($template_file) : $template_file);
			}
			$output = ob_get_clean();
			
			if (version_compare(VERSION, '4.0', '>=')) {
				$output = str_replace($settings['extension_route'] . '/', $settings['extension_route'] . '|', $output);
			}
			
			return $output;
		} else {
			return 'Error loading template file: ' . $template_file;
		}
	}
	
	//==============================================================================
	// getZones()
	//==============================================================================
	public function getZones() {
		$this->load->model('localisation/zone');
		$zones = $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']);
		echo json_encode($zones);
	}
	
	//==============================================================================
	// subscribe()
	//==============================================================================
	public function subscribe() {
		if (empty($this->request->post)) return;
		
		$this->session->data['mailchimp_signup_email'] = $this->request->post['email'];
		
		$customer_id = 0;
		$customer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE email = '". $this->db->escape($this->request->post['email']) . "'");
		
		if ($customer_query->num_rows) {
			$customer_id = $customer_query->row['customer_id'];
			$this->request->post['customer_id'] = $customer_id;
		}
		if (isset($this->request->post['address'])) {
			$this->request->post['address_1'] = $this->request->post['address'];
			unset($this->request->post['address']);
		}
		if (isset($this->request->post['country'])) {
			$this->request->post['country_id'] = $this->request->post['country'];
		}
		if (isset($this->request->post['zone'])) {
			$this->request->post['zone_id'] = $this->request->post['zone'];
		}
		
		$data = array_merge($this->request->post, array('newsletter' => 1));
		$mailchimp_integration = $this->loadMailchimp();
		$error = $mailchimp_integration->send($data);
		
		if (!$error && $customer_id && empty($customer_query->row['newsletter'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "customer SET newsletter = 1 WHERE customer_id = " . $customer_id);
		}
		
		echo str_replace('Use PUT to insert or update list members.', '', $error);
	}
	
	//==============================================================================
	// webhook()
	//==============================================================================
	public function webhook() {
		if (!isset($this->request->post['type']) || !isset($this->request->post['data'])) {
			echo 'The MailChimp Integration webhook is working.';
			if (!isset($this->request->get['key'])) {
				echo ' However, no key is set. This is required for the webhook data to be processed properly.';
			}
			return;
		}
		
		if ($this->request->get['key'] != md5($this->config->get('config_encryption'))) {
			$prefix = (version_compare(VERSION, '3.0', '<')) ? '' : $this->type . '_';
			if ($this->config->get($prefix . $this->name . '_testing_mode')) {
				$this->log->write(strtoupper($this->name) . ' WEBHOOK ERROR: webhook URL key ' . $this->request->get['key'] . ' does not match required key ' . md5($this->config->get('config_encryption')) . ' for action "' . $this->request->post['type'] . '" for e-mail address ' . $this->request->post['data']['email']);
			}
			return;
		}
		
		$mailchimp_integration = $this->loadMailchimp();
		$mailchimp_integration->webhook($this->request->post['type'], $this->request->post['data']);
	}
	
	//==============================================================================
	// getSettings()
	//==============================================================================
	private function getSettings() {
		// extension-specific, to work with list IDs and interest group IDs
		$code = (version_compare(VERSION, '3.0', '<')) ? $this->name : $this->type . '_' . $this->name;
		
		$settings = array();
		$settings_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "setting WHERE `code` = '" . $this->db->escape($code) . "' ORDER BY `key` ASC");
		
		foreach ($settings_query->rows as $setting) {
			$value = $setting['value'];
			if ($setting['serialized']) {
				$value = (version_compare(VERSION, '2.1', '<')) ? unserialize($setting['value']) : json_decode($setting['value'], true);
			}
			$settings[str_replace($code . '_', '', $setting['key'])] = $value;
		}
		
		if (version_compare(VERSION, '4.0', '<')) {
			$settings['extension_route'] = 'extension/' . $this->type . '/' . $this->name;
		} else {
			$settings['extension_route'] = 'extension/' . $this->name . '/' . $this->type . '/' . $this->name;
		}
		
		return $settings;
	}
	
	//==============================================================================
	// loadMailchimp()
	//==============================================================================
	private function loadMailchimp() {
		if (version_compare(VERSION, '2.1', '<')) {
			$this->load->library($this->name);
		} elseif (version_compare(VERSION, '4.0', '>=')) {
			require_once(DIR_EXTENSION . $this->name . '/system/library/' . $this->name . '.php');
		}
		
		return new \MailChimp_Integration($this->registry);
	}
	
	//==============================================================================
	// Event hooks
	//==============================================================================
	public function send(&$route = '', &$input = array(), &$output = array()) {
		if (!$this->config->get($this->type . '_' . $this->name . '_status')) return;
		
		$data = array();
		
		if ($route == 'account/customer/addCustomer') {
			$data = array_merge($input[0], array('customer_id' => $output, 'customer_newsletter' => 0));
		} elseif ($route == 'account/customer/editCustomer') {
			$data = array_merge($input[1], array('newsletter' => 1, 'customer_id' => $input[0]));
		} elseif ($route == 'account/customer/editNewsletter') {
			$data = array('newsletter' => $input[0], 'customer_id' => $this->customer->getId(), 'customer_newsletter' => 0);
		} elseif ($route == 'account/address/addAddress') {
			$address = $this->db->query("SELECT * FROM " . DB_PREFIX . "address WHERE customer_id = " . (int)$this->customer->getId() . " AND `default` = 1")->row;
			if (!empty($address) && $this->customer->getNewsletter()) {
				$data = array_merge($address, array('newsletter' => 1, 'customer_id' => $this->customer->getId()));
			}
		} elseif ($route == 'account/address/editAddress') {
			$address = $this->db->query("SELECT * FROM " . DB_PREFIX . "address WHERE customer_id = " . (int)$this->customer->getId() . " AND `default` = 1")->row;
			if (!empty($address) && $this->customer->getNewsletter()) {
				$data = array_merge($address, array('newsletter' => 1, 'customer_id' => $this->customer->getId()));
			}
		}
		
		if ($data) {
			$mailchimp_integration = $this->loadMailchimp();
			$mailchimp_integration->send($data);
		}
	}
	
	public function setCookies(&$route = '', &$input = array()) {
		$settings = $this->getSettings();
		if (!$settings['status'] || !$settings['ecommerce']) return;
		
		if (isset($this->request->get['mc_cid'])) {
			setcookie('mc_cid', $this->request->get['mc_cid'], time() + 60*60*24 * $settings['cookietime'], '/');
		}
		if (isset($this->request->get['mc_eid'])) {
			setcookie('mc_eid', $this->request->get['mc_eid'], time() + 60*60*24 * $settings['cookietime'], '/');
		}
	}
	
	public function sendOrder(&$route = '', &$input = array(), &$output = array()) {
		$settings = $this->getSettings();
		if (!$settings['status'] || !$settings['ecommerce']) return;
		
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($input[0]);
		
		$mailchimp_integration = $this->loadMailchimp();
		$mailchimp_integration->sendOrder($order_info, $settings['ordertype']);
		
		$mailchimp_integration->deleteCart($order_info['email']);
		$mailchimp_integration->deleteOrder($order_info);
	}
	
	public function deleteOrder(&$route = '', &$input = array()) {
		$settings = $this->getSettings();
		if (!$settings['status'] || !$settings['ecommerce']) return;
		
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($input[0]);
		
		$mailchimp_integration = $this->loadMailchimp();
		$mailchimp_integration->deleteOrder($order_info);
	}
	
	public function sendCart(&$route = '', &$input = array(), &$output = array()) {
		$settings = $this->getSettings();
		if (!$settings['status'] || !$settings['ecommerce']) return;
		
		if ($this->customer->isLogged()) {
			$customer_id = (int)$this->customer->getId();
		} elseif (!empty($this->session->data['mailchimp_signup_email'])) {
			$customer_id = $this->session->data['mailchimp_signup_email'];
		} elseif (!empty($this->session->data['guest']['email'])) {
			$customer_id = $this->session->data['guest']['email'];
		} else {
			return;
		}
		
		$mailchimp_integration = $this->loadMailchimp();
		$mailchimp_integration->sendCart($this->cart, $customer_id);
	}
	
	public function buildCart(&$route = '', &$input = array()) {
		if (empty($this->request->get['c'])) return;
		
		$settings = $this->getSettings();
		if (!$settings['status'] || !$settings['ecommerce']) return;
		
		foreach ($this->request->get['c'] as $product) {
			$quantity = (!empty($product['q'])) ? $product['q'] : 1;
			$options = (!empty($product['o'])) ? $product['o'] : array();
			$recurring = (!empty($product['r'])) ? $product['r'] : 0;
			$this->cart->add($product['p'], $quantity, $options, $recurring);
		}
	}
	
	public function sendEvent(&$route = '', &$input = array(), &$output = array()) {
		$settings = $this->getSettings();
		if (!$settings['status']) return;
		
		if ($route == 'account/wishlist|add' && $settings['event_added_to_wishlist'] && !empty($this->request->post['product_id'])) {
			$this->load->model('catalog/product');
			$product_info = $this->model_catalog_product->getProduct((int)$this->request->post['product_id']);
			
			$event_name = 'added_to_wishlist';
			$event_data = array(
				'name'			=> $product_info['name'],
				'product_id'	=> $product_info['product_id'],
				'product_url'	=> $this->url->link('product/product', 'product_id=' . $product_info['product_id']),
			);
		} elseif ($route == 'product/product' && $settings['event_product_viewed'] && !empty($this->request->get['product_id'])) {
			$this->load->model('catalog/product');
			$product_info = $this->model_catalog_product->getProduct((int)$this->request->get['product_id']);
			
			$event_name = 'product_viewed';
			$event_data = array(
				'name'			=> $product_info['name'],
				'product_id'	=> $product_info['product_id'],
				'product_url'	=> $this->url->link('product/product', 'product_id=' . $product_info['product_id']),
			);
		} elseif ($route == 'catalog/product/getTotalProducts' && $settings['event_search_performed'] && !empty($input[0]['filter_name'])) {
			$event_name = 'search_performed';
			$event_data = array(
				'search'		=> $this->request->get['search'],
				'results'		=> (string)$output,
			);
		} else {
			return;
		}
		
		$mailchimp_integration = $this->loadMailchimp();
		$mailchimp_integration->triggerEvent($event_name, $event_data);
	}
}
?>