<?php
class ControllerExtensionModuleXabandonedCarts extends Controller {
	public $data = array();

	public function __construct($registry) {
		parent::__construct($registry);
		$this->config->load('xtensions/xabandoned');
		$this->data = $this->language->load($this->config->get('xabandoned_path'));
		$this->data['config_pfx'] = $this->xabandoned_config_pfx = $this->config->get('xabandoned_config_pfx');
		$this->load->model($this->config->get('xabandoned_path'));
		$this->module_model_object = $this->{$this->config->get('xabandoned_model')};
		$this->view_path = $this->config->get('xabandoned_view');
		$this->view_extension = $this->config->get('xabandoned_view_extension');
		$this->back_button = $this->url->link($this->config->get('xabandoned_back_button'), $this->module_token, true);
		$this->data['module_token'] = $this->module_token;
		$this->logger = new Log($this->config->get('xabandoned_log_file'));
		$this->version_two_point_one = $this->data['version_two_point_one'] = false;
		if(version_compare(VERSION, '2.2.0.0')<0){
			$this->version_two_point_one = $this->data['version_two_point_one'] = true;
		}
	}
	
	public function index(){
		return '';
	}

	public function cron() {
		$this->logging('Running Cron Job');
		if (!isset($this->request->get['template_id'])) {
			$this->logging('No Template defined');
			return;
		}
		$template = $this->module_model_object->getTemplate($this->request->get['template_id']);
		if (!$template || !$template['status']) {
			$this->logging('No Template found or status is not enabled for template id ' .$this->request->get['template_id']);
			return;
		}
		
		if($template['is_sms']){
			$this->sms($template);
		}else{
			$this->email($template);
		}
	}

	private function email($template) {	
		$this->module_model_object->deleteDailySentLogs();
		$this->load->model('setting/setting');
		$this->load->model('tool/image');
		$this->load->model('catalog/product');
		$this->language->load('product/product');
		$total_mails = 0;
		if ($this->config->get($this->xabandoned_config_pfx .'status')) {
			$current_time = $this->module_model_object->getCurrentTime();
			$activities = $this->module_model_object->getActivities($this->config->get('config_store_id'));
			$sent = array();
			foreach ($activities as $activity_info) {
				$cart_data = json_decode($activity_info['cart'], true);
				$products = (isset($cart_data['products']) ? json_decode($cart_data['products'], true) : array());
				$vouchers = (isset($cart_data['vouchers']) ? json_decode($cart_data['vouchers'], true) : array());
				// Do not send an email if no products or vouchers are in cart, or email is not present or user has unsubscribed from this or all activities like this!
				if ((!$products && !$vouchers) || ($activity_info['last_step'] == 4) || !filter_var($activity_info['email'], FILTER_VALIDATE_EMAIL) || in_array($activity_info['email'], $sent) || $activity_info['unsubscribe'] || $this->module_model_object->hasUnsubscribedPermanently($activity_info['email'])) {
					continue;
				}
				// Do not send an email if maximum number of reminders per email per store per template are sent already!
				if($template['max_mail_per_day_per_email']){					
					$mails = $this->module_model_object->getTotalSentPerEmailToday($activity_info['email'],$template['template_id'],$activity_info['store_id']);
					if($mails['total'] >= $template['max_mail_per_day_per_email']){
						// Do not send an email if maximum number of reminders per email per store per template are sent already!
						$sent[] = $activity_info['email'];
						continue;
					}else if(($current_time - strtotime($mails['last_email_today'])) < ($template['next_mails']*$template['next_mail_duration'])){
						// Do not send an email if last email sent to user has not reached the next email waiting time!
						$sent[] = $activity_info['email'];
						continue;
					}
				}
				// Do not send an email if maximum number of reminders are sent already!
				if($template['maximum_mails'] && $this->module_model_object->getTotalSent($activity_info['activity_session_code'],$template['template_id']) >= $template['maximum_mails']){
					// Do not send an email to earlier record of this emails.
					$sent[] = $activity_info['email'];
					continue;
				}
				// Do not send an email if it the first mail duration is not yet completed!
				if(($current_time - strtotime($activity_info['date_modified']?$activity_info['date_modified']:$activity_info['date_added'])) < ($template['first_mail']*$template['first_mail_duration'])){
					// Do not send an email to earlier record of this emails.
					$sent[] = $activity_info['email'];
					continue;
				}
				// Do not send an email if last activity is older than specified maximum number of days on template! 
				if($template['maximum_time'] && ($current_time - strtotime($activity_info['date_modified']?$activity_info['date_modified']:$activity_info['date_added'])) > ($template['maximum_time']*$template['maximum_time_duration'])){
					// Do not send an email to earlier record of this emails.
					$sent[] = $activity_info['email'];
					continue;
				}
				$last_mail = $this->module_model_object->getLastEmailTime($activity_info['activity_session_code'],$template['template_id']);
				// Do not send an email if last mail is sent before then it can be sent as set in the next mail duration!
				if($last_mail && (($current_time - $last_mail) < ($template['next_mails']*$template['next_mail_duration']))){
					// Do not send an email to earlier record of this emails.
					$sent[] = $activity_info['email'];
					continue;
				}
				$language = new Language($activity_info['language_code']);
				$language->load($activity_info['language_code']);
				$this->data = array_merge($this->data,$language->load($this->config->get('xabandoned_path')));
				$message = html_entity_decode($template['language'][$activity_info['language_code']]['subject_description']);
				$this->data['products'] = array();
				$store_name = $activity_info['store_name']?$activity_info['store_name']:$this->config->get('config_name');
				$store_url = $activity_info['store_url']?$activity_info['store_url']:$this->config->get('config_url');
				foreach ($products as $product) {
					$product_info = $this->model_catalog_product->getProduct($product['product_id']);
					$product_info['image'] = $this->model_tool_image->resize($product_info['image'], $template['width'], $template['height']);
					$product_info['quantity'] = $product['quantity'];
					$product_info['price'] = $product['price_formatted'];
					$product_info['total'] = $product['total_formatted'];
					$product_info['url'] = $store_url.'index.php?route=product/product&product_id='.$product['product_id'];
					$this->data['products'][] = $product_info;
				}
				foreach ($vouchers as $voucher) {
					$product_info = array();
					$product_info['name'] = $voucher['description'];
					$product_info['model'] = '';
					$product_info['image'] = $this->model_tool_image->resize('catalog/xtensions/giftcard.jpg', $template['width'], $template['height']);
					$product_info['quantity'] = 1;
					$product_info['price'] = $voucher['amount_formatted'];
					$product_info['total'] = $voucher['amount_formatted'];
					$this->data['products'][] = $product_info;
				}
				if($this->version_two_point_one){
					if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/'.$this->config->get('xabandoned_mail_file').$this->config->get('xabandoned_view_extension'))) {
						$cart_content =  $this->load->view($this->config->get('config_template') . '/template/'.$this->config->get('xabandoned_mail_file').$this->config->get('xabandoned_view_extension'), $this->data);
					} else {
						$cart_content =  $this->load->view('default/template/'.$this->config->get('xabandoned_mail_file').$this->config->get('xabandoned_view_extension'), $this->data);
					}
				}else{
					$cart_content = $this->load->view($this->config->get('xabandoned_mail_file'),$this->data);
				}
				
				// Generate Coupon
				$coupon_id = 0;
				$discount_code = '';
				if ($template['discount_type']) {
					$cart_products = array();
					foreach ($products as $product) {
						$cart_products[] = $product['product_id'];
					}					
					$discount_code = $this->module_model_object->generateCouponCode();
					if($this->config->get($this->xabandoned_config_pfx .'coupon_one')){
						$coupon_data = $this->module_model_object->getSentCoupon($activity_info['activity_session_code'],$template['template_id']);
						if($coupon_data){
							$discount_code = $coupon_data['code'];
							$coupon_id = $coupon_data['coupon_id'];
						}
					}
					$time_end = time() + $template['validity'] * 24 * 60 * 60;
					$coupon_data = array(
						'name' => 'Xtensions Abandoned Cart - ' . $activity_info['email'] . '',
						'code' => $discount_code,
						'discount' => $template['discount'],
						'type' => $template['discount_type'],
						'total' => $template['amount'],
						'logged' => $template['customer_login'],
						'shipping' => $template['shipping'],
						'coupon_product' => $template['discount_product'] ? $cart_products : array(),
						'date_start' => date('Y-m-d', time()),
						'date_end' => date('Y-m-d', $time_end),
						'uses_total' => '1',
						'uses_customer' => '1',
						'status' => '1',
						'email'=>$activity_info['email']
						//'language_id'=>isset($template['language'][$activity_info['language_code']]['language_id'])?$template['language'][$activity_info['language_code']]['language_id']:1					
					);
					if($coupon_id){
						$this->module_model_object->editCoupon($coupon_id,$coupon_data);
					}else{
						$coupon_id = $this->module_model_object->addCoupon($coupon_data);
					}
				}
				
				// Convert Patterns and Send Mail
				$static = array();
				$converters = array(
					'firstname',
					'lastname',
					'cart_content',
					'restore_link',
					'discount_code',
					'discount_value',
					'total_amount',
					'date_end',
					'unsubscribe_link',
					'store_name',
					'store_link' 
				);
				foreach ($converters as $converter) {
					$static[$converter] = '{' . $converter . '}';
				}
				$with = array();
				$with['firstname'] = $activity_info['firstname'];
				$with['lastname'] = $activity_info['lastname'];
				$with['cart_content'] = $cart_content;
				$with['restore_link'] = $store_url . 'index.php?route=' . $this->config->get('xabandoned_path') . '/restoreUserCart&activity_session_code=' . $activity_info['activity_session_code'];
				$with['discount_code'] = $template['discount_type'] ? $discount_code : '';
				$with['discount_value'] = ($template['discount_type'] =='P'? $template['discount'].'%' : ($template['discount_type']=='F' ? $this->currency->format($template['discount'],$activity_info['currency_code']) : ''));
				$with['total_amount'] = $template['discount_type'] ? $this->currency->format($template['amount'],$activity_info['currency_code']) : '';
				$with['date_end'] = $template['discount_type'] ? date('jS F Y', strtotime("+".$template['validity']." days")) : '';
				$with['unsubscribe_link'] = $store_url . 'index.php?route=' . $this->config->get('xabandoned_path') . '/unsubscribeLink&activity_session_code=' . $activity_info['activity_session_code'];
				$with['store_name'] = $store_name;
				$with['store_link'] = $store_url;
				$HTMLMail = str_replace($static, $with, $message);
				$patterns_subject = array();
				$patterns_subject[0] = '{firstname}';
				$patterns_subject[1] = '{lastname}';
				$replacements_subject = array();
				$replacements_subject[0] = $activity_info['firstname'];
				$replacements_subject[1] = $activity_info['lastname'];
				$HTMLSubject = str_replace($patterns_subject, $replacements_subject, $template['language'][$activity_info['language_code']]['subject_title']);
				$mail = array(
					'email' => $activity_info['email'],
					'message' => $HTMLMail,
					'subject' => $HTMLSubject,
					'store_id' => $activity_info['store_id'],
					'store_name'=>$store_name,
					'config_pfx'=>$this->xabandoned_config_pfx,
					'code'		=> $activity_info['activity_session_code'],
					'coupon_id' => $coupon_id,
					'coupon_code' => $discount_code,
				);				
				$this->db->query("INSERT " . DB_PREFIX . "xtensions_activity_daily_email SET activity_session_code = '" . $this->db->escape($mail['code']) . "', store_id = '". (int)$activity_info['store_id'] ."', template_id = '". (int)$this->request->get['template_id'] ."', email = '" . $this->db->escape($activity_info['email']) . "', date_added = NOW()");
				$activity_daily_mail_id = $this->db->getLastId();
				$this->db->query("INSERT " . DB_PREFIX . "xtensions_activity_to_mail SET activity_session_code = '" . $this->db->escape($mail['code']) . "', template_id = '". (int)$this->request->get['template_id'] ."', coupon_id = '". (int)$mail['coupon_id'] ."', coupon_code = '" . $this->db->escape($mail['coupon_code']) . "', date_added = NOW()");
				$activity_mail_id = $this->db->getLastId();
				$mail['message'] .= '<img style="display:none;" src="'. $store_url . 'index.php?route=' . $this->config->get('xabandoned_path') . '/image&activity_mail_id=' . $activity_mail_id .'&activity_code=' . $mail['code'] .'" />'; 
				if($this->module_model_object->mail($mail)){
					$this->logging('Mail sent to ' .$activity_info['email'].' - '.$activity_info['activity_session_code']);
					$sent[] = $activity_info['email'];
					$total_mails++;
				}else{
					$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_daily_email WHERE activity_mail_id = '" . (int)$activity_daily_mail_id . "'");
					$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_to_mail WHERE activity_mail_id = '" . (int)$activity_mail_id . "'");
				}
			}
			$this->logging('Total Mails sent on Template - '. $template['title'] .'(' .$total_mails . ')');
		}else{
			$this->logging('Module is not enabled');
		}
	}
	
	private function sms($template){
		$this->module_model_object->deleteDailySentLogs();
		$this->load->model('setting/setting');		
		$this->load->model('catalog/product');
		$this->language->load('product/product');
		$total_sms = 0;
		if ($this->config->get($this->xabandoned_config_pfx .'status')) {
			$current_time = $this->module_model_object->getCurrentTime();
			$activities = $this->module_model_object->getActivities($this->config->get('config_store_id'));
			$sent = array();
			foreach ($activities as $activity_info) {
				$sanitize = $this->sanitize($activity_info['telephone'],$activity_info['country_code'],$activity_info['full_telephone']);
				if(empty($sanitize)){
					// Number format is not correct, do not send an sms
					continue;
				}else{
					$activity_info['telephone'] = $sanitize['telephone'];
					$activity_info['country_code'] = $sanitize['country_code'];
					$activity_info['full_telephone'] = $sanitize['full_telephone'];
				}
				$cart_data = json_decode($activity_info['cart'], true);
				$products = (isset($cart_data['products']) ? json_decode($cart_data['products'], true) : array());
				$vouchers = (isset($cart_data['vouchers']) ? json_decode($cart_data['vouchers'], true) : array());
				// Do not send an sms if no products or vouchers are in cart, or telephone is not present or user has unsubscribed from this or all activities like this!
				if ((!$products && !$vouchers) || ($activity_info['last_step'] == 4) || (!$activity_info['full_telephone']) || in_array($activity_info['full_telephone'], $sent) || $activity_info['unsubscribe'] || $this->module_model_object->hasUnsubscribedPermanently($activity_info['email'])) {
					continue;
				}
				// Do not send an sms if maximum number of reminders per sms per store per template are sent already!
				if($template['max_mail_per_day_per_email']){					
					$mails = $this->module_model_object->getTotalSentPerTelephoneToday($activity_info['full_telephone'],$template['template_id'],$activity_info['store_id']);
					if($mails['total'] >= $template['max_mail_per_day_per_email']){
						// Do not send an sms if maximum number of reminders per sms per store per template are sent already!
						$sent[] = $activity_info['full_telephone'];
						continue;
					}else if(($current_time - strtotime($mails['last_email_today'])) < ($template['next_mails']*$template['next_mail_duration'])){
						// Do not send an sms if last sms sent to user has not reached the next sms waiting time!
						$sent[] = $activity_info['full_telephone'];
						continue;
					}
				}
				// Do not send an sms if maximum number of reminders are sent already!
				if($template['maximum_mails'] && $this->module_model_object->getTotalSentTelephone($activity_info['activity_session_code'],$template['template_id']) >= $template['maximum_mails']){
					// Do not send an sms to earlier record of this sms.
					$sent[] = $activity_info['full_telephone'];
					continue;
				}
				// Do not send an sms if it the first sms duration is not yet completed!
				if(($current_time - strtotime($activity_info['date_modified']?$activity_info['date_modified']:$activity_info['date_added'])) < ($template['first_mail']*$template['first_mail_duration'])){
					// Do not send an sms to earlier record of this sms.
					$sent[] = $activity_info['full_telephone'];
					continue;
				}
				// Do not send an sms if last activity is older than specified maximum number of days on template! 
				if($template['maximum_time'] && ($current_time - strtotime($activity_info['date_modified']?$activity_info['date_modified']:$activity_info['date_added'])) > ($template['maximum_time']*$template['maximum_time_duration'])){
					// Do not send an sms to earlier record of this sms.
					$sent[] = $activity_info['full_telephone'];
					continue;
				}
				$last_mail = $this->module_model_object->getLastTelephoneTime($activity_info['activity_session_code'],$template['template_id']);
				// Do not send an sms if last sms is sent before then it can be sent as set in the next sms duration!
				if($last_mail && (($current_time - $last_mail) < ($template['next_mails']*$template['next_mail_duration']))){
					// Do not send an sms to earlier record of this sms.
					$sent[] = $activity_info['full_telephone'];
					continue;
				}
				$language = new Language($activity_info['language_code']);
				$language->load($activity_info['language_code']);
				$this->data = array_merge($this->data,$language->load($this->config->get('xabandoned_path')));
				$message = html_entity_decode($template['language'][$activity_info['language_code']]['sms_body']);
				$store_name = $activity_info['store_name']?$activity_info['store_name']:$this->config->get('config_name');
				$store_url = $activity_info['store_url']?$activity_info['store_url']:$this->config->get('config_url');				
				
				// Generate Coupon
				$coupon_id = 0;
				$discount_code = '';
				if ($template['discount_type']) {
					$cart_products = array();
					foreach ($products as $product) {
						$cart_products[] = $product['product_id'];
					}					
					$discount_code = $this->module_model_object->generateCouponCode();
					if($this->config->get($this->xabandoned_config_pfx .'coupon_one')){
						$coupon_data = $this->module_model_object->getSentCouponSMS($activity_info['activity_session_code'],$template['template_id']);
						if($coupon_data){
							$discount_code = $coupon_data['code'];
							$coupon_id = $coupon_data['coupon_id'];
						}
					}
					$time_end = time() + $template['validity'] * 24 * 60 * 60;
					$coupon_data = array(
						'name' => 'Xtensions Abandoned Cart - ' . $activity_info['full_telephone'] . '',
						'code' => $discount_code,
						'discount' => $template['discount'],
						'type' => $template['discount_type'],
						'total' => $template['amount'],
						'logged' => $template['customer_login'],
						'shipping' => $template['shipping'],
						'coupon_product' => $template['discount_product'] ? $cart_products : array(),
						'date_start' => date('Y-m-d', time()),
						'date_end' => date('Y-m-d', $time_end),
						'uses_total' => '1',
						'uses_customer' => '1',
						'status' => '1',
						'email'=>$activity_info['email']
						//'language_id'=>isset($template['language'][$activity_info['language_code']]['language_id'])?$template['language'][$activity_info['language_code']]['language_id']:1					
					);
					if($coupon_id){
						$this->module_model_object->editCoupon($coupon_id,$coupon_data);
					}else{
						$coupon_id = $this->module_model_object->addCoupon($coupon_data);
					}
				}
				
				// Convert Patterns and Send Mail
				$static = array();
				$converters = array(
					'firstname',
					'lastname',
					'restore_link',
					'discount_code',
					'discount_value',
					'total_amount',
					'date_end',
					'unsubscribe_link',
					'store_name',
					'store_link' 
				);
				foreach ($converters as $converter) {
					$static[$converter] = '{' . $converter . '}';
				}
				$this->db->query("INSERT " . DB_PREFIX . "xtensions_activity_to_telephone SET activity_session_code = '" . $this->db->escape($activity_info['activity_session_code']) . "', template_id = '". (int)$this->request->get['template_id'] ."', coupon_id = '". (int)$coupon_id ."', coupon_code = '" . $this->db->escape($discount_code) . "', date_added = NOW()");
				$activity_daily_mail_id = $this->db->getLastId();
				$this->db->query("INSERT " . DB_PREFIX . "xtensions_activity_daily_telephone SET activity_session_code = '" . $this->db->escape($activity_info['activity_session_code']) . "', store_id = '". (int)$activity_info['store_id'] ."', template_id = '". (int)$this->request->get['template_id'] ."', telephone = '" . $this->db->escape($activity_info['telephone']) . "', country_code = '" . $this->db->escape($activity_info['country_code']) . "', full_telephone = '" . $this->db->escape($activity_info['full_telephone']) . "', date_added = NOW()");				
				$activity_mail_id = $this->db->getLastId();
				$with = array();
				$with['firstname'] = $activity_info['firstname'];
				$with['lastname'] = $activity_info['lastname'];
				$with['restore_link'] = $store_url . 'index.php?route=' . $this->config->get('xabandoned_path') . '/r&a=' . $activity_info['activity_session_code'] . '&t=' . $activity_mail_id;
				$with['discount_code'] = $template['discount_type'] ? $discount_code : '';
				$with['discount_value'] = ($template['discount_type'] =='P'? $template['discount'].'%' : ($template['discount_type']=='F' ? $this->currency->format($template['discount'],$activity_info['currency_code']) : ''));
				$with['total_amount'] = $template['discount_type'] ? $this->currency->format($template['amount'],$activity_info['currency_code']) : '';
				$with['date_end'] = $template['discount_type'] ? date('jS F Y', strtotime("+".$template['validity']." days")) : '';
				$with['unsubscribe_link'] = $store_url . 'index.php?route=' . $this->config->get('xabandoned_path') . '/u&a=' . $activity_info['activity_session_code'];
				$with['store_name'] = $store_name;
				$with['store_link'] = $store_url;
				$sms_body = str_replace($static, $with, $message);				
				$sms = array(
					'telephone' => $activity_info['telephone'],
					'country_code' => $activity_info['country_code'],
					'full_telephone' => $activity_info['full_telephone'],
					'sms' => $sms_body,
					'sms_template_id'=>isset($template['language'][$activity_info['language_code']]['sms_template_id'])?$template['language'][$activity_info['language_code']]['sms_template_id']:'',
					'store_id' => $activity_info['store_id'],
					'store_name'=>$store_name,
					'config_pfx'=>$this->xabandoned_config_pfx,
					'code'		=> $activity_info['activity_session_code'],
					'coupon_id' => $coupon_id,
					'coupon_code' => $discount_code,
					'event'		=> 'xabcart',
					'channel'  => 'transactional',
				);
				$send = $this->module_model_object->sms($sms);
				if(isset($send['success'])){
					$this->logging('SMS sent to ' .$activity_info['full_telephone'].' - '.$activity_info['activity_session_code']);
					$sent[] = $activity_info['full_telephone'];
					$total_sms++;
				}else{
					if(isset($send['country_code_not_permitted'])){
						$sent[] = $activity_info['full_telephone'];	
					}
					$this->logging('SMS could not be sent to ' .$activity_info['full_telephone'].' - '.$activity_info['activity_session_code'] .'! Error Message: '.$send['error']);
					$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_daily_telephone WHERE activity_mail_id = '" . (int)$activity_daily_mail_id . "'");
					$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_to_telephone WHERE activity_mail_id = '" . (int)$activity_mail_id . "'");
				}			
			}
			$this->logging('Total SMSes sent on Template - '. $template['title'] .'(' .$total_sms . ')');
		}
	}
	
	private function logging($message){
		$this->config->get($this->xabandoned_config_pfx .'logs')?$this->logger->write($message):null;
	}

	public function unsubscribeLink() {
		$this->data['breadcrumbs'] = array();
		$this->document->setTitle($this->language->get('text_unsubscribe'));

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$this->data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_unsubscribe'),
			'href' => $this->url->link($this->config->get('xabandoned_path').'/unsubscribeLink', 'activity_session_code='.$this->request->get['activity_session_code'])
		);
		$this->data['heading_title'] = $this->language->get('text_unsubscribe');	
		$this->data['permanent_unsubscription'] = $permanent_unsubscription = false;
		if($this->config->get($this->xabandoned_config_pfx .'permanent_unsubscription')){
			$this->data['permanent_unsubscription'] = $permanent_unsubscription = true;
		}
		
		if(!isset($this->request->get['activity_session_code'])){
			$this->data['text_message'] =  $this->language->get('text_nothing_unsubscribe');
		}else {
			$activity = $this->module_model_object->activityInfo($this->request->get['activity_session_code']);
			if(!$activity){
				$this->data['text_message'] = $this->language->get('text_nothing_unsubscribe');
			} else {
				if($permanent_unsubscription && isset($this->request->get['permanent'])){
					if($this->module_model_object->hasUnsubscribedPermanently($activity['email'])){
						$this->data['text_message'] = $this->language->get('text_already_unsubscribed_permanently');
					}else{
						$this->data['text_message'] = $this->language->get('text_unsubscribed_permanently');
						$this->module_model_object->unsubscribePermanently($activity['email']);
					}
					$this->data['is_permanent'] = true;
					$this->data['heading_title'] = $this->language->get('text_remove_permanentlty');
					$this->data['breadcrumbs'][] = array(
						'text' => $this->language->get('text_remove_permanentlty'),
						'href' => $this->url->link($this->config->get('xabandoned_path').'/unsubscribeLink', 'activity_session_code='.$this->request->get['activity_session_code'].'&permanent=1')
					);
				}else{
					if($activity['unsubscribe']){
						$this->data['text_message'] = $this->language->get('text_already_unsubscribe');
					} else{				
						$this->data['text_message'] = $this->language->get('text_success_unsubscribe');
						$this->module_model_object->unsubscribe();
					}
				}
			}
		}
		$this->data['button_continue'] = $this->language->get('button_continue');
		$this->data['continue'] = $this->url->link('common/home');
		$this->data['permanent'] = $this->url->link($this->config->get('xabandoned_path').'/unsubscribeLink', 'activity_session_code='.$this->request->get['activity_session_code'].'&permanent=1');
		$this->data['column_left'] = $this->load->controller('common/column_left');
		$this->data['column_right'] = $this->load->controller('common/column_right');
		$this->data['content_top'] = $this->load->controller('common/content_top');
		$this->data['content_bottom'] = $this->load->controller('common/content_bottom');
		$this->data['footer'] = $this->load->controller('common/footer');
		$this->data['header'] = $this->load->controller('common/header');
		
		if($this->version_two_point_one){
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/'.$this->view_path.'/unsubscribe'.$this->config->get('xabandoned_view_extension'))) {
				$this->response->setOutput($this->load->view($this->config->get('config_template') . '/template/'.$this->view_path.'/unsubscribe'.$this->config->get('xabandoned_view_extension'), $this->data));
			} else {
				$this->response->setOutput($this->load->view('default/template/'.$this->view_path.'/unsubscribe'.$this->config->get('xabandoned_view_extension'), $this->data));
			}
		}else{
			$this->response->setOutput($this->load->view($this->view_path.'/unsubscribe', $this->data));
		}
		
	}
	
	public function restorePersistentCart($data=array()){
		if($this->config->get($this->xabandoned_config_pfx .'status') && ($this->config->get($this->xabandoned_config_pfx .'persistent_cart') || $this->config->get($this->xabandoned_config_pfx .'persistent_login'))){
			$activity_session_code = $data['activity_session_code'];
			$activity_info = $this->module_model_object->activityInfo($activity_session_code);
			if($activity_info){				
				if($this->config->get($this->xabandoned_config_pfx .'persistent_login') && !$this->customer->isLogged() && $activity_info['customer_id'] && $activity_info['email']){
					$this->customer->login($activity_info['email'],'',true);
					if($this->customer->isLogged()){
						// We need to refresh the user's cart as it ran before the execution of this code, and so user's cart was not recorded from login.
						$this->cart->__construct($this->registry);
						$this->xtensions_checkout->addEventActivity(array('persistent_logged_in'),true);
						return ;	
					}					
				}
				if($this->config->get($this->xabandoned_config_pfx .'persistent_cart') && $activity_info['last_step'] != '4'){
					$cart_data = json_decode($activity_info['cart'], true);
					if ($cart_data) {
						$cart_product = (isset($cart_data['products']) ? json_decode($cart_data['products'], true) : array());
						$cart_vouchers = (isset($cart_data['vouchers']) ? json_decode($cart_data['vouchers'], true) : array());
						if(!empty($cart_product)){
							$this->load->model('catalog/product');
							$this->xtensions_checkout->addEventActivity(array('persistent_cart'),true);
							foreach ($cart_product as $product) {
								if($activity_info['date_modified'] ==='0000-00-00 00:00:00'){
									$this->cart->add($product['product_id'], $product['quantity'], $product['option'], $product['recurring']);
								}else{
									$this->addInCart($product);
								}
							}						
							$this->xtensions_checkout->addEventActivity(array('cart_edited'),true);
							if(!empty($cart_vouchers)){
								unset($this->session->data['vouchers']);
								$this->load->language('account/voucher');
								foreach ($cart_vouchers as $voucher) {
									$this->session->data['vouchers'][mt_rand()] = array(
										'description'      => sprintf($this->language->get('text_for'), $this->currency->format($voucher['amount'], $activity_info['currency_code']), $voucher['to_name']),
										'to_name'          => $voucher['to_name'],
										'to_email'         => $voucher['to_email'],
										'from_name'        => $voucher['from_name'],
										'from_email'       => $voucher['from_email'],
										'voucher_theme_id' => $voucher['voucher_theme_id'],
										'message'          => $voucher['message'],
										'amount'           => $this->currency->convert($voucher['amount'], $activity_info['currency_code'], $this->config->get('config_currency'))
									);
								}
							}
						}
					}
				}
			}
		}
	}
	
	public function r(){		
		if(isset($this->request->get['a'])){
			if(isset($this->request->get['t'])){
				$this->module_model_object->clicked($this->request->get['t'],$this->request->get['a']);
			}
			$this->request->get['activity_session_code'] = $this->request->get['a'];			
			$this->restoreUserCart();
		}		
	}
	
	public function u(){
		if(isset($this->request->get['a'])){
			$this->request->get['activity_session_code'] = $this->request->get['a'];
			$this->unsubscribeLink();
		}		
	}

	public function restoreUserCart() {
		$this->load->model($this->config->get('xabandoned_path'));
		if (isset($this->request->get['activity_session_code'])) {
			$activity_info = $this->module_model_object->activityInfo($this->request->get['activity_session_code']);
			if($activity_info){
				$this->xtensions_checkout->addEventActivity(array('referred_from_mail'),true);
				//$this->xtensions_checkout->addActivity(array('referred_from_mail'=>array('activity_session_code'=>$this->request->get['activity_session_code'])));
				$cart_data = json_decode($activity_info['cart'], true);
				if ($cart_data) {
					$cart_product = (isset($cart_data['products']) ? json_decode($cart_data['products'], true) : array());
					$cart_vouchers = (isset($cart_data['vouchers']) ? json_decode($cart_data['vouchers'], true) : array());
					if (!empty($cart_product) && $this->cart->hasProducts()) {
						$this->cart->clear();
					}
					$this->load->model('catalog/product');
					foreach ($cart_product as $product) {
						if($activity_info['date_modified'] ==='0000-00-00 00:00:00'){
							$this->cart->add($product['product_id'], $product['quantity'], $product['option'], $product['recurring']);
						}else{
							$this->addInCart($product);
						}
					}
					if(!empty($cart_vouchers)){
						unset($this->session->data['vouchers']);
						$this->load->language('account/voucher');
						foreach ($cart_vouchers as $voucher) {
							$this->session->data['vouchers'][mt_rand()] = array(
								'description'      => sprintf($this->language->get('text_for'), $this->currency->format($voucher['amount'], $activity_info['currency_code']), $voucher['to_name']),
								'to_name'          => $voucher['to_name'],
								'to_email'         => $voucher['to_email'],
								'from_name'        => $voucher['from_name'],
								'from_email'       => $voucher['from_email'],
								'voucher_theme_id' => $voucher['voucher_theme_id'],
								'message'          => $voucher['message'],
								'amount'           => $this->currency->convert($voucher['amount'], $activity_info['currency_code'], $this->config->get('config_currency'))
							);
						}
					}
					$this->xtensions_checkout->addEventActivity(array('cart_edited'),true);
					$this->response->redirect($this->url->link('checkout/cart', '', 'SSL'));
					return ;
				}
			}
		} 
		$this->response->redirect($this->url->link('common/home'));
	}
	
	private function addInCart($product){	
		$error = false;
		$product_info = $this->model_catalog_product->getProduct($product['product_id']);
		if (isset($product['quantity']) && ((int)$product['quantity'] >= $product_info['minimum'])) {
			$quantity = (int)$product['quantity'];
		} else {
			$quantity = $product_info['minimum'] ? $product_info['minimum'] : 1;
		}
		// Nothing but just a solution for one of the opencart's bundle module - start
		if (isset($product['option_key'])) {
			$option_key = array_filter($product['option_key']);
		} else {
			$option_key = array();
		}
		// Nothing but just a solution for one of the opencart's bundle module - end
		if (isset($product['option'])) {
			$option = array_filter($product['option']);
		} else {
			$option = array();
		}

		$product_options = $this->model_catalog_product->getProductOptions($product['product_id']);

		foreach ($product_options as $product_option) {
			if ($product_option['required'] && empty($option[$product_option['product_option_id']])) {
				$error = true;
			}
		}

		if (isset($product['recurring_id'])) {
			$recurring_id = $product['recurring_id'];
		} else {
			$recurring_id = 0;
		}

		$recurrings = $this->model_catalog_product->getProfiles($product_info['product_id']);

		if ($recurrings) {
			$recurring_ids = array();

			foreach ($recurrings as $recurring) {
				$recurring_ids[] = $recurring['recurring_id'];
			}

			if (!in_array($recurring_id, $recurring_ids)) {
				$error = true;
			}
		}
		$add_options = array();
		foreach ($option as $key => $value){
			if(isset($value['type'])){
				if($value['type'] == 'select' || $value['type'] == 'radio'){
					$add_options[$key] = $value['product_option_value_id'];
				} elseif (in_array($value['type'],array('text','textarea','file','date','datetime','time'))){
					$add_options[$key] = $value['value'];
				}
			} else {
				foreach ($value as $valuecheck){
					$add_options[$key][] = $valuecheck['product_option_value_id'];
				}
			}
		}
		if(!$error){								
			$this->cart->add($product['product_id'], $quantity, array_merge($option_key,$add_options), $recurring_id);
			$this->cart->__construct($this->registry);
		}						
	}
	
	public function ignoreRoutes(){
		return array(
			'checkout/success',
			$this->config->get('xabandoned_path') . '/unsubscribeLink',
			$this->config->get('xabandoned_path') . '/u',
			$this->config->get('xabandoned_path') . '/r',
			$this->config->get('xabandoned_path') . '/cron',
			$this->config->get('xabandoned_path') . '/deleteCron',
			$this->config->get('xabandoned_path') . '/restoreUserCart',
			$this->config->get('xabandoned_path') . '/image'
		);
	}
	
	public function image(){
		if(isset($this->request->get['activity_mail_id']) && isset($this->request->get['activity_code'])){
			$this->module_model_object->opened($this->request->get['activity_mail_id'],$this->request->get['activity_code']);
		}
		$im=imagecreate(1,1);
		$white=imagecolorallocate($im,255,255,255);
  		imagesetpixel($im,1,1,$white);
  		header("content-type:image/jpg");
  		imagejpeg($im);
  		imagedestroy($im);
	}
	
	public function deleteCron(){
		$this->module_model_object->deleteActivitiesByCron();
	}
	
	public function sanitize($telephone,$country_code,$full_telephone){
		if($country_code.' '.$telephone != $full_telephone){
			$telephone_number = explode(" ",$telephone,2);
			if(count($telephone_number) >= 2){
				if(isset($telephone_number[0]) && isset($telephone_number[1])){
					if($country_code != $telephone_number[0]){
						return array();
					}
					$telephone = $telephone_number[1];				
				}
			}
		}		
		$telephone = preg_replace('/\D/', '',preg_replace('/^0+/','',$telephone));
		return array('telephone'=>$telephone,'country_code'=>$country_code, 'full_telephone' => $country_code . ' ' . $telephone);
	}
}
