<?php
class ControllerExtensionSitemapRobots extends Controller {
	public function index() {
		$this->load->model('setting/setting');
                $get_settings = $this->model_setting_setting->getSetting('robots', (int)$this->config->get('config_store_id'));
                $settings = isset($get_settings['robots_status']) ? $get_settings['robots_status'] : false;
                if ($settings and $settings['status']) {
		        $this->registry->set('cache', new Cache($settings['cache_type'], $settings['cache_expire']));
		        $rules = $this->cache->get('robots_rules_store'.(int)$this->config->get('config_store_id'));
                        if(!$rules){
			        $rules = $settings['rules'];
			        $this->cache->set('robots_rules_store'.(int)$this->config->get('config_store_id'), $rules);
			}
			$output = <<<EOR
#  Dynamic Multistore Robots.txt - Optimize SEO links budget
#
#  Web Robots (also known as Web Wanderers, Crawlers, or Spiders), are programs that
#  traverse the Web automatically. Search engines such as Google use them to index the
#  web content, spammers use them to scan for email addresses, and they have many other
#  uses.
#
#  Some useful links and materials:
#       
#       @link https://developers.google.com/webmasters/control-crawl-index/docs/robots_txt
#       @link https://help.yandex.com/webmaster/controlling-robot/robots-txt.xml
#
$rules
EOR;
			$this->response->addHeader('Content-Type: text/plain');
			$this->response->addHeader('X-Robots-Tag: noindex, nosnippet, noarchive, notranslate, noimageindex, noydir, noodp');
			$this->response->setOutput(html_entity_decode($output, ENT_QUOTES, 'UTF-8'));
		}
	}
}
