<?php
class ModelExtensionModuleGoogleEcommerce extends Model {
	public function getOrderTax($order_id){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_total WHERE code = 'tax' AND order_id = '" . (int)$order_id . "' LIMIT 1");
		if ($query->row) {
			return $query->row['value'];	
		}else{
			return '0';
		}
	}
	
	public function getOrderShipping($order_id){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_total WHERE code = 'shipping' AND order_id = '" . (int)$order_id . "' LIMIT 1");
		if ($query->row) {
			return $query->row['value'];	
		}else{
			return '0';
		}	
	}
	
	public function getOrderCoupon($order_id){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_total WHERE code = 'coupon' AND order_id = '" . (int)$order_id . "' LIMIT 1");
		if ($query->row) {
			return $query->row['title'];	
		}else{
			return '';
		}	
	}
	
	public function getOrderProducts($order_id){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int)$order_id . "'");
	
		if($query->rows){
			return $query->rows;
		} else {
			return false;	
		}
	}
	
	public function getProductSku($product_id){
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` WHERE product_id = '".(int)$product_id."' LIMIT 1");
		if ($query->row){
			if ($query->row['sku'] == '') {
				return 'Product ID: '.$product_id. ' - Model: '.$query->row['model'];
			}else {
				return $query->row['sku'];
			}
		} else {
			return $product_id;	
		}
	}

	public function getProductName($product_id, $language_id){
		$query = $this->db->query("SELECT name FROM `" . DB_PREFIX . "product_description` WHERE product_id = '".(int)$product_id."' AND language_id = '".(int)$language_id."' LIMIT 1");
		if ($query->row){
			return $query->row['name'];
		}else{
			return 'Product name not found';
		}
	}
	
	public function getProductBrand($product_id){
		$query = $this->db->query("SELECT b.name FROM `" . DB_PREFIX . "product` a, `" . DB_PREFIX . "manufacturer` b WHERE a.manufacturer_id = b.manufacturer_id AND a.product_id = '".(int)$product_id."' LIMIT 1");
		if ($query->row){
			return $query->row['name'];
		} else {
			return '';	
		}
	}
	
	public function getProductCategory($product_id, $language_id){
		$query = $this->db->query("SELECT a.name FROM `" . DB_PREFIX . "category_description` a, `" . DB_PREFIX . "product_to_category` b where a.category_id = b.category_id AND b.product_id = '".(int)$product_id."' AND a.language_id = '".(int)$language_id."' ORDER BY b.category_id DESC LIMIT 1");
		if ($query->row){
			return $query->row['name'];
		} else {
			return 'Category Not Assigned';	
		}
	}
	
	public function build_ecommerce($order_id) {
		$ga_item_data = array();
		$fb_item_data = array();
		$ga_parameters = array();
		
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($order_id);
		
		$this->load->model('setting/setting');
		$extn_info = $this->model_setting_setting->getSetting('ga_ecom', $order_info['store_id']);
		
		$ga_ecom_id 			= (isset($extn_info['ga_ecom_id']))? $extn_info['ga_ecom_id'] : 'product_id';
		$ga_ecom_currency 		= (isset($extn_info['ga_ecom_currency']))? $extn_info['ga_ecom_currency'] : $this->config->get('config_currency');
		$ga_ecom_language_id 	= (isset($extn_info['ga_ecom_language_id']))? $extn_info['ga_ecom_language_id'] : '0';
		$ga_ecom_dimensions 	= (isset($extn_info['ga_ecom_dimensions']))? $extn_info['ga_ecom_dimensions'] : array();

		if ($ga_ecom_language_id <> 0) {
			$language_id = $ga_ecom_language_id;
		}else{
			$language_id = $order_info['language_id'];
		}

		$order_total = number_format($order_info['total'], 2, '.', '');
		
		$products = $this->getOrderProducts($order_id);
		if ($products) {
			foreach ($products as $product) {
				$product_id = $product['product_id'];
				
				if (isset($this->session->data['ga_ec_listname_product_'.$product_id])){
					$list_name = $this->session->data['ga_ec_listname_product_'.$product_id];
				}else{
					$list_name = 'Checkout Success Page';
				}
				
				$ga_item_data[] = array(
						'name'			=> $this->getProductName($product['product_id'], $language_id),
						'list_name'		=> $list_name,
						'sku'			=> ($ga_ecom_id == 'sku')? $this->getProductSku($product['product_id']) : $product['product_id'],
						'brand'			=> $this->getProductBrand($product['product_id']),
						'category'		=> $this->getProductCategory($product['product_id'], $language_id),
						'price'			=> number_format($product['price'], 2, '.', ''),
						'quantity'		=> $product['quantity']
					);

				$fb_item_data[] = array(
						'id'			=> $product_id,
						'name'			=> $this->getProductName($product['product_id'], $language_id),
						'quantity'		=> $product['quantity']
					);
			}
		}
		
		$ga_parameters = array(
			'transaction_id'	=> $order_id,
			'affiliation'		=> $order_info['store_name'],
			//'email'         	=> $order_info['email'],
			'value'				=> $order_total,
			'shipping'			=> $this->getOrderShipping($order_id),
			'tax'				=> $this->getOrderTax($order_id),
			'currency'			=> $ga_ecom_currency,//$order_info['currency_code'],
			'items'				=> $ga_item_data,
			'coupon'			=> $this->getOrderCoupon($order_id)
		);

		
		foreach ($ga_ecom_dimensions as $dimension) {
			$ga_parameters[$dimension] = $order_info[$dimension];
		}
		
		
		$tracking_code = '';
		$tracking_code .= '<script type="text/javascript">';
		$tracking_code .= "gtag('event', 'purchase', ".json_encode($ga_parameters).");";
		$tracking_code .= "</script>";

		$data['google_purchase'] = $tracking_code;

		$this->addlog('CHECKOUT COMPLETE');
		$this->addlog('+ GTAG - '.$tracking_code);

		if ($this->config->get('ga_ecom_ads_conversion_status')){
			$sale_conversion_code = html_entity_decode($this->config->get('ga_ecom_sale_conversion'), ENT_QUOTES, 'UTF-8');
			$sale_conversion_code = str_replace('{total}', $order_total, $sale_conversion_code);
			$sale_conversion_code = str_replace('{order_id}', $order_id, $sale_conversion_code);
			$data['ads_sale_conversion'] = $sale_conversion_code;
			$this->addlog('+ ADS Sale Conversion - '.$sale_conversion_code);
		}else{
			$data['ads_sale_conversion'] = '';
		}

		if ($this->config->get('ga_ecom_fb_px_status')){
			$pixel_parameters = array(
				'currency'	=> $ga_ecom_currency,
				'value'		=> $order_total,
				'contents'	=> $fb_item_data,
				'content_type' => 'product'
			);	
			
			$pixel_code = '';
			$pixel_code .= '<script type="text/javascript">';
			$pixel_code .= "fbq('track', 'Purchase', ".json_encode($pixel_parameters).");";
			$pixel_code .= "</script>";

			$data['pixel_script'] = $pixel_code;
			$this->addlog('+ PIXEL - '.$pixel_code);
		}else{
			$data['pixel_script'] = '';
		}
		
		return $data;
	}
	
	public function build_begin_checkout() {
		$item_data = array();
		$ga_ecom_id = ($this->config->get('ga_ecom_id'))? $this->config->get('ga_ecom_id') : 'product_id';
		$ga_ecom_currency = ($this->config->get('ga_ecom_currency'))? $this->config->get('ga_ecom_currency') : $this->config->get('config_currency');
		$ga_ecom_language_id = ($this->config->get('ga_ecom_language_id'))? $this->config->get('ga_ecom_language_id') : '0';

		if ($ga_ecom_language_id <> 0) {
			$language_id = $ga_ecom_language_id;
		}else{
			$language_id = $this->config->get('config_language_id');
		}

		$products = $this->cart->getProducts();
		
		if ($products) {
			foreach ($products as $product) {
				$product_id = $product['product_id'];
				
				if (isset($this->session->data['ga_ec_listname_product_'.$product_id])){
					$list_name = $this->session->data['ga_ec_listname_product_'.$product_id];
				}else{
					$list_name = 'Checkout Page';
				}
				
				$item_data[] = array(
						'id'			=> ($ga_ecom_id == 'sku')? $this->getProductSku($product['product_id']) : $product['product_id'],
						'name'			=> $this->getProductName($product['product_id'], $language_id),
						'list_name'		=> $list_name,
						'brand'			=> $this->getProductBrand($product['product_id']),
						'category'		=> $this->getProductCategory($product['product_id'], $language_id),
						'quantity'		=> (float)$product['quantity'],
						'price'			=> number_format($product['price'], 2, '.', '')
					);
			}
		}
		
		$tracking_code = '';
		$tracking_code .= '<script type="text/javascript">';
		$tracking_code .= "gtag('event', 'begin_checkout', {";
		$tracking_code .= '"items": [';
		$tracking_code .= json_encode($item_data);
		$tracking_code .= "]});";
		$tracking_code .= "</script>";

		$this->addlog('CHECKOUT BEGIN');
		$this->addlog('+ GTAG - '.$tracking_code);
		
		$data['ga_script'] = $tracking_code;

		if ($this->config->get('ga_ecom_fb_px_status')){
			$px_code = '';
			$px_code .= '<script type="text/javascript">';
			$px_code .= "fbq('track', 'InitiateCheckout'); ";
			$px_code .= "</script>";
			$this->model_extension_module_google_ecommerce->addlog('+ PIXEL - '.$px_code);
			$data['px_script'] = $px_code;
		}else{
			$data['px_script']  = '';
		}

		return $data;
	}
	
	public function build_product_impression($results = array(), $page = 0, $limit = 1, $breadcrumbs = array(), $list_name = 'Unique Page') {
		$page = (int)$page;
		$index 	= 1;
		$bb 	= array();
		$ga_parameters 	= array();
		
		$ga_ecom_id = ($this->config->get('ga_ecom_id'))? $this->config->get('ga_ecom_id') : 'product_id';
		$ga_ecom_currency = ($this->config->get('ga_ecom_currency'))? $this->config->get('ga_ecom_currency') : $this->config->get('config_currency');
		$ga_ecom_language_id = ($this->config->get('ga_ecom_language_id'))? $this->config->get('ga_ecom_language_id') : '0';

		if ($ga_ecom_language_id <> 0) {
			$language_id = $ga_ecom_language_id;
		}else{
			$language_id = $this->config->get('config_language_id');
		}
		
		foreach ($breadcrumbs as $breadcrumb) {
			$bb[] = $breadcrumb['text'];
		}
		
		if (!empty($bb)) {
			array_shift($bb);
			$category = implode('/',$bb);
		}else{
			$category = false;
		}
		
		foreach ($results as $result) {
			if ($ga_ecom_id == 'sku') {
				$id = $this->getProductSku($result['product_id']);
			} else {
				$id = $result['product_id'];
			}
			$product_name = $this->getProductName($result['product_id'], $language_id);;
			$brand = $this->getProductBrand($result['product_id']);
			
			if ($category == false){
				$category = $this->getProductCategory($result['product_id'], $language_id);
			}
			
			if ($page > 1) {
				$list_position = (($page-1) * $limit) + $index;
			}else{
				$list_position = $index;
			}
			
			if ((float)$result['special']) {
				$price = $this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax'));
			} else {
				$price = $this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax'));
			}
			
			$ga_parameters[] = array(
				'id'			=> 	$id,
				'name'			=>	$product_name,
				'list_name'		=>	$list_name,
				'brand'			=>	$brand,
				'category'		=>	$category,
				'list_position' => 	$list_position,
				'price'			=>  $price
			);
			
			$index++;
		}
		
		$tracking_code = '';
		$tracking_code .= '<script type="text/javascript">';
		$tracking_code .= "gtag('event', 'view_item_list', {";
		$tracking_code .= '"items": ';
		$tracking_code .= json_encode($ga_parameters);
		$tracking_code .= "});";
		$tracking_code .= "</script>";
		
		$this->addlog('LIST VIEWED');
		$this->addlog('+ GTAG - '.$tracking_code);

		return $tracking_code;
	}
	
	public function build_product_view($product_info = array(), $breadcrumbs = array()) {
		$bb 	= array();
		$ga_parameters 	= array();
		$fb_parameters 	= array();
		
		$ga_ecom_id = ($this->config->get('ga_ecom_id'))? $this->config->get('ga_ecom_id') : 'product_id';
		$ga_ecom_currency = ($this->config->get('ga_ecom_currency'))? $this->config->get('ga_ecom_currency') : $this->config->get('config_currency');
		$ga_ecom_language_id = ($this->config->get('ga_ecom_language_id'))? $this->config->get('ga_ecom_language_id') : '0';

		if ($ga_ecom_language_id <> 0) {
			$language_id = $ga_ecom_language_id;
		}else{
			$language_id = $this->config->get('config_language_id');
		}
		
		if ($ga_ecom_id == 'sku') {
			$id = $this->getProductSku($product_info['product_id']);
		} else {
			$id = $product_info['product_id'];
		}
		$product_name = $this->getProductName($product_info['product_id'], $language_id);
		$brand = $this->getProductBrand($product_info['product_id']);
		
		foreach ($breadcrumbs as $breadcrumb) {
			$bb[] = $breadcrumb['text'];
		}
		
		if (!empty($bb)) {
			array_shift($bb);
			$category = implode('/',$bb);
		}else{
			$category = $this->getProductCategory($product_info['product_id'], $language_id);
		}
		
		if ($category == ''){
			$category = $this->getProductCategory($product_info['product_id'], $language_id);
		}
		
		if ((float)$product_info['special']) {
			$price = $this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax'));
		} else {
			$price = $this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax'));
		}
		
		$ga_parameters = array(
			'id'		=> 	$id,
			'name'		=>	$product_name,
			'list_name'	=>	'Product Page',
			'brand'		=>	$brand,
			'category'	=>	$category,
			'price'		=>  $price
		);
		
		$fb_parameters = array(
			'content_name'		=> 	$product_name,
			'content_category'	=>	$category,
			'content_ids'		=>	array($id),
			'content_type'		=>	'product',
			'currency'			=>	$ga_ecom_currency,
			'value'				=>  $price
		);

		$tracking_code = '';
		$tracking_code .= '<script type="text/javascript">';
		$tracking_code .= "gtag('event', 'view_item', {";
		$tracking_code .= '"items": ['.json_encode($ga_parameters);
		$tracking_code .= "]});";
		$tracking_code .= "</script>";
		
		$this->addlog('PRODUCT VIEWED');
		$this->addlog('+ GTAG - '.$tracking_code);
		
		$data['ga_script'] = $tracking_code;

		if ($this->config->get('ga_ecom_fb_px_status')){
			$px_code = '';
			$px_code .= '<script type="text/javascript">';
			$px_code .= "fbq('track', 'ViewContent', ";
			$px_code .= json_encode($fb_parameters);
			$px_code .= ");";
			$px_code .= "</script>";
			$this->model_extension_module_google_ecommerce->addlog('+ PIXEL - '.$px_code);
			$data['px_script'] = $px_code;
		}else{
			$data['px_script']  = '';
		}

		return $data;
	}

	public function addlog($text = ''){
		if ($this->config->get('ga_ecom_debug_logs')){
			if (!file_exists(DIR_LOGS . 'huntbee_ga_logs')) {
				mkdir(DIR_LOGS . 'huntbee_ga_logs', 0777, true);
			}

			$file = DIR_LOGS . 'huntbee_ga_logs/ga_logs.txt';

			if (file_exists($file)) {
				$size = filesize($file);
				if ($size > 5242880){
					$handle = fopen($file, 'w+');
					fclose($handle);
				}
			}

			$fp = fopen($file, 'a');
			fwrite($fp, "\r\n".date('d-M-Y G:i:s A') . ' - ' .$text);
			fclose($fp);
		}
	}

	public function pixel_base_code($pixel_id = ''){
		if ($this->config->get('ga_ecom_fb_px_status')){
			$script = "<!-- Facebook Pixel Code -->
			<script>
			!function(f,b,e,v,n,t,s)
			{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
			n.callMethod.apply(n,arguments):n.queue.push(arguments)};
			if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
			n.queue=[];t=b.createElement(e);t.async=!0;
			t.src=v;s=b.getElementsByTagName(e)[0];
			s.parentNode.insertBefore(t,s)}(window, document,'script',
			'https://connect.facebook.net/en_US/fbevents.js');
			fbq('init', '".$pixel_id."');
			fbq('track', 'PageView');
			</script>
			<noscript>
			<img height=\"1\" width=\"1\" style=\"display:none\" 
				src=\"https://www.facebook.com/tr?id=".$pixel_id."&ev=PageView&noscript=1\"/>
			</noscript>
			<!-- End Facebook Pixel Code -->";
		  }else{
			  $script = '';
		  }

		return $script;

	}
	
}