<?php
class ModelExtensionModuleXabandonedCarts extends Model {

	public function unsubscribe() {
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET unsubscribe = 1 WHERE activity_session_code = '" . $this->db->escape($this->request->get['activity_session_code']) . "'");
	}
	
	public function unsubscribePermanently($email) {
		$this->db->query("INSERT INTO `" . DB_PREFIX . "xtensions_activity_unsubscription` SET email = '" . $this->db->escape($email) . "', date_added = now()");
	}
	
	public function hasUnsubscribedPermanently($email) {
		$query = $this->db->query("SELECT count(*) as total  FROM `" . DB_PREFIX . "xtensions_activity_unsubscription` WHERE email = '" . $this->db->escape($email) . "'");
		return $query->row['total'];
	}

	public function activityInfo($activity_session_code) {
		$query = $this->db->query("SELECT * FROM  `" . DB_PREFIX . "xtensions_activity_order` WHERE activity_session_code = '" . $this->db->escape($activity_session_code) . "'");
		return $query->row;
	}

	public function isUniqueCode($randomCode) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "coupon` WHERE code='" . $this->db->escape($randomCode) . "'");
		if ($query->num_rows == 0) {
			return true;
		} else {
			return false;
		}
	}

	public function generateCouponCode() {
		$coupon = token(10);
		$coupon_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "coupon` WHERE code='" . $this->db->escape($coupon) . "'");
			
		if ($coupon_query->num_rows) {
			return $this->generateCouponCode();
		}else{
			return $coupon;
		}
	}
	
	public function getTemplate($template_id){
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "xtensions_activity_mail_template xamt WHERE xamt.template_id = '" . (int)$template_id . "'");
		if($query->num_rows){
			$data = $query->row;
			$query = $this->db->query("SELECT  xamtd.*, l.code FROM " . DB_PREFIX . "xtensions_activity_mail_template_description xamtd  LEFT JOIN `" . DB_PREFIX . "language` l ON xamtd.`language_id` = l.`language_id` WHERE xamtd.template_id = '" . (int)$template_id . "'");
			$language =  array();
			foreach ($query->rows as $row){
				if($row['code']){
					$language[$row['code']] = $row;
				}
			}
			$data = array_merge($data,array('language'=>$language));
			return $data;
		}
		return array();
	}
	
	public function getActivities($store_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "xtensions_activity_order xao WHERE xao.store_id = '" . (int)$store_id . "' AND email <> '' AND cart <> '' AND cart IS NOT NULL ORDER BY xao.date_modified DESC, xao.date_added DESC");
		return $query->rows;
	}
	
	public function getSentCoupon($activity_code,$template_id){
		$query = $this->db->query("SELECT c.* FROM `" . DB_PREFIX . "coupon` c JOIN `" . DB_PREFIX . "xtensions_activity_to_mail` xatm ON c.`coupon_id` = xatm.`coupon_id` WHERE `activity_session_code` = '" . $this->db->escape($activity_code) . "' AND `template_id` = '" . (int)$template_id . "' AND xatm.coupon_id <> '0' ORDER BY xatm.`date_added` DESC LIMIT 1");
		if($query->num_rows){
			return $query->row;
		}
		return array();
	}
	
	public function getSentCouponSMS($activity_code,$template_id){
		$query = $this->db->query("SELECT c.* FROM `" . DB_PREFIX . "coupon` c JOIN `" . DB_PREFIX . "xtensions_activity_to_telephone` xatm ON c.`coupon_id` = xatm.`coupon_id` WHERE `activity_session_code` = '" . $this->db->escape($activity_code) . "' AND `template_id` = '" . (int)$template_id . "' AND xatm.coupon_id <> '0' ORDER BY xatm.`date_added` DESC LIMIT 1");
		if($query->num_rows){
			return $query->row;
		}
		return array();
	}
	
	public function addCoupon($data) {
		$this->db->query("INSERT INTO " . DB_PREFIX . "coupon SET name = '" . $this->db->escape($data['name']) . "', code = '" . $this->db->escape($data['code']) . "', discount = '" . (float)$data['discount'] . "', type = '" . $this->db->escape($data['type']) . "', total = '" . (float)$data['total'] . "', logged = '" . (int)$data['logged'] . "', shipping = '" . (int)$data['shipping'] . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "', uses_total = '" . (int)$data['uses_total'] . "', uses_customer = '" . (int)$data['uses_customer'] . "', status = '" . (int)$data['status'] . "', date_added = NOW()");

		$coupon_id = $this->db->getLastId();

		if (isset($data['coupon_product'])) {
			foreach ($data['coupon_product'] as $product_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "coupon_product SET coupon_id = '" . (int)$coupon_id . "', product_id = '" . (int)$product_id . "'");
			}
		}
		
		if(file_exists(DIR_CONFIG.'xtensions/xlcoupon.php')){
			$check_table = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "xlcoupon'");
			if($check_table->num_rows){
				$this->db->query("SET SQL_MODE = ''");
				$this->db->query("INSERT INTO " . DB_PREFIX . "xlcoupon SET coupon_id = '" . (int)$coupon_id . "', display_checkout_list = 1, email = '" . $this->db->escape($data['email']) . "'");				
			}
			$check_table = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "xlcoupon_description'");
			if($check_table->num_rows){
				$this->load->model('localisation/language');		
				foreach ($this->model_localisation_language->getLanguages() as $language){
					$this->db->query("SET SQL_MODE = ''");
					$this->db->query("INSERT INTO " . DB_PREFIX . "xlcoupon_description SET coupon_id = '" . (int)$coupon_id . "', language_id = '" . (int)$language['language_id'] . "'");
				}
			}
		}
		
		return $coupon_id;
	}
	
	public function editCoupon($coupon_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "coupon SET name = '" . $this->db->escape($data['name']) . "', discount = '" . (float)$data['discount'] . "', type = '" . $this->db->escape($data['type']) . "', total = '" . (float)$data['total'] . "', logged = '" . (int)$data['logged'] . "', shipping = '" . (int)$data['shipping'] . "', date_start = '" . $this->db->escape($data['date_start']) . "', date_end = '" . $this->db->escape($data['date_end']) . "', uses_total = '" . (int)$data['uses_total'] . "', uses_customer = '" . (int)$data['uses_customer'] . "', status = '" . (int)$data['status'] . "', date_added = NOW() WHERE coupon_id = '" . (int)$coupon_id . "'" );

		$this->db->query("DELETE FROM " . DB_PREFIX . "coupon_product WHERE coupon_id = '" . (int)$coupon_id . "'");

		if (isset($data['coupon_product'])) {
			foreach ($data['coupon_product'] as $product_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "coupon_product SET coupon_id = '" . (int)$coupon_id . "', product_id = '" . (int)$product_id . "'");
			}
		}
		
		if(file_exists(DIR_CONFIG.'xtensions/xlcoupon.php')){
			$check_table = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "xlcoupon'");
			if($check_table->num_rows){
				$this->db->query("DELETE FROM " . DB_PREFIX . "xlcoupon WHERE coupon_id = '" . (int)$coupon_id . "'");
				$this->db->query("SET SQL_MODE = ''");
				$this->db->query("INSERT INTO " . DB_PREFIX . "xlcoupon SET coupon_id = '" . (int)$coupon_id . "', display_checkout_list = 1, email = '" . $this->db->escape($data['email']) . "'");				
			}
			$check_table = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "xlcoupon_description'");
			if($check_table->num_rows){
				$this->db->query("DELETE FROM " . DB_PREFIX . "xlcoupon_description WHERE coupon_id = '" . (int)$coupon_id . "'");
				$this->load->model('localisation/language');		
				foreach ($this->model_localisation_language->getLanguages() as $language){
					$this->db->query("SET SQL_MODE = ''");
					$this->db->query("INSERT INTO " . DB_PREFIX . "xlcoupon_description SET coupon_id = '" . (int)$coupon_id . "', language_id = '" . (int)$language['language_id'] . "'");
				}
			}
		}

		return $coupon_id;
	}
	
	public function getCurrentTime(){
		$query = $this->db->query("SELECT now() as 'current_time' FROM DUAL");
		return strtotime($query->row['current_time']);
	}
	
	public function getLastEmailTime($activity_code,$template_id){
		$query = $this->db->query("SELECT date_added FROM `" . DB_PREFIX . "xtensions_activity_to_mail` WHERE `activity_session_code` = '". $this->db->escape($activity_code) ."' AND template_id = '" . (int)$template_id . "' ORDER BY `date_added` DESC LIMIT 1");
		if($query->num_rows){
			return strtotime($query->row['date_added']);
		}
		return false;
	}
	
	public function getLastTelephoneTime($activity_code,$template_id){
		$query = $this->db->query("SELECT date_added FROM `" . DB_PREFIX . "xtensions_activity_to_telephone` WHERE `activity_session_code` = '". $this->db->escape($activity_code) ."' AND template_id = '" . (int)$template_id . "' ORDER BY `date_added` DESC LIMIT 1");
		if($query->num_rows){
			return strtotime($query->row['date_added']);
		}
		return false;
	}
	
	public function getTotalSent($activity_code,$template_id){
		$query = $this->db->query("SELECT count(*) as count FROM `" . DB_PREFIX . "xtensions_activity_to_mail` WHERE `activity_session_code` = '". $this->db->escape($activity_code) ."' AND template_id = '" . (int)$template_id . "'");
		if($query->num_rows){
			return $query->row['count'];
		}
		return 0;
	}
	
	public function getTotalSentTelephone($activity_code,$template_id){
		$query = $this->db->query("SELECT count(*) as count FROM `" . DB_PREFIX . "xtensions_activity_to_telephone` WHERE `activity_session_code` = '". $this->db->escape($activity_code) ."' AND template_id = '" . (int)$template_id . "'");
		if($query->num_rows){
			return $query->row['count'];
		}
		return 0;
	}
	
	public function deleteDailySentLogs(){
		$this->db->query("DELETE FROM `" . DB_PREFIX . "xtensions_activity_daily_email` WHERE (DATE(date_added) <= date_sub(DATE(now()), INTERVAL 4 DAY))");
		$this->db->query("DELETE FROM `" . DB_PREFIX . "xtensions_activity_daily_telephone` WHERE (DATE(date_added) <= date_sub(DATE(now()), INTERVAL 4 DAY))");
	}
	
	public function getTotalSentPerEmailToday($email,$template_id,$store_id){		
		$query = $this->db->query("SELECT count(*) AS total, max(date_added) AS last_email_today, min(date_added) AS first_email_today FROM `" . DB_PREFIX . "xtensions_activity_daily_email` WHERE `store_id` = '" . (int)$store_id . "' AND email = '" . $this->db->escape($email) ."' AND `template_id` = '" . (int)$template_id ."' AND (date_added > DATE_SUB(now(), INTERVAL 24 HOUR ))");
		if($query->num_rows){
			return $query->row;
		}
		return array();
	}
	
	public function getTotalSentPerTelephoneToday($full_telephone,$template_id,$store_id){		
		$query = $this->db->query("SELECT count(*) AS total, max(date_added) AS last_email_today, min(date_added) AS first_email_today FROM `" . DB_PREFIX . "xtensions_activity_daily_telephone` WHERE `store_id` = '" . (int)$store_id . "' AND full_telephone = '" . $this->db->escape($full_telephone) ."' AND `template_id` = '" . (int)$template_id ."' AND (date_added > DATE_SUB(now(), INTERVAL 24 HOUR ))");
		if($query->num_rows){
			return $query->row;
		}
		return array();
	}
	
	public function mail($data = array()) {
		if(!$this->config->get($data['config_pfx'].'different_mail')){
			if (version_compare(VERSION, '3.0.0.0') >= 0) {
				$mail = new Mail($this->config->get('config_mail_engine'));
			} else {
				$mail = new Mail();
				$mail->protocol = $this->config->get('config_mail_protocol');
			}
			$mail->parameter = $this->config->get('config_mail_parameter');
			$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
			$mail->smtp_username = $this->config->get('config_mail_smtp_username');
			$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
			$mail->smtp_port = $this->config->get('config_mail_smtp_port');
			$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
			$mail->setFrom($this->config->get('config_email'));
		}else{
			$config_data = $this->config->get($data['config_pfx'].'mail');
			if (version_compare(VERSION, '3.0.0.0') >= 0) {
				$mail = new Mail($config_data['protocol']);
			} else {
				$mail = new Mail();
				$mail->protocol = $config_data['protocol'];
			}
			$mail->parameter = $config_data['parameter'];
			$mail->smtp_hostname = $config_data['hostname'];
			$mail->smtp_username = $config_data['username'];
			$mail->smtp_password = html_entity_decode($config_data['password'], ENT_QUOTES, 'UTF-8');
			$mail->smtp_port = $config_data['port'];
			$mail->smtp_timeout = $config_data['timeout'];
			$mail->setFrom($config_data['email']);
		}
		$mail->setTo($data['email']);
		$mail->setSender(html_entity_decode($data['store_name'], ENT_QUOTES, 'UTF-8'));
		$mail->setSubject(html_entity_decode($data['subject'], ENT_QUOTES, 'UTF-8'));
		$mail->setHtml($data['message']);
		$mail->send();
		
		if ($mail){
			return true;			
		}
		return false;
	}
	
	public function sms($data) {		
		if(file_exists(DIR_CONFIG.'xtensions/xsmspro.php')){
			$this->load->config('xtensions/xsmspro');
			$required_fields = array('country_code','full_telephone','telephone','channel','sms','event','sms_template_id');
			$fields = array();
			foreach ($required_fields as $key){
				if(isset($data[$key]) && $data[$key]){
					$fields[$key] = $data[$key];
				}else{
					$fields[$key] = $key == 'channel'?'trasactional':'';
				}
			}						
			if(isset($fields['country_code'])){
				$ccs = $this->config->get($this->config->get('xsmspro_config_pfx').'country_code');
				if(trim($ccs)){
					$country_codes = explode(',', $ccs);
					if(!in_array($fields['country_code'], $country_codes)){
						return array('error'=>'SMS can not be sent to this country code!','country_code_not_permitted'=>true);
					}
				}
			}			
			$telephone = $fields['telephone'];
			$country_code = $fields['country_code']?str_replace('+', '', $fields['country_code']):'';
			require_once DIR_SYSTEM.'library/xtensions/xtensionssms.php';
			$platform = new XtensionsSms($this->registry);
			$channel = $this->config->get($this->config->get('xsmspro_config_pfx').$fields['channel'].'_channel');		
			$platform->setAdaptor($this->config->get($this->config->get('xsmspro_config_pfx').'gateway_'.$channel));
			$platform->setChannel($channel);
			$pd = $this->config->get($this->config->get('xsmspro_config_pfx').'gateway_'.$channel.'_param');
			$param_data = $pd[$this->config->get($this->config->get('xsmspro_config_pfx').'gateway_'.$channel)];
			if(isset($fields['sms_template_id']) && $fields['sms_template_id'] && isset($fields['event']) && $fields['event'] && !isset($param_data[$fields['event'].'_template_id'])){
				$param_data[$fields['event'].'_template_id'] = $fields['sms_template_id'];
			}
			if($platform->action('send',array('number'=>$telephone,'country_code'=>$country_code,'params'=>$param_data,'message'=>$fields['sms'],'event'=>$fields['event'],'otp'=>''))){
				return array('success'=> true);
			}else{
				array('error'=>'SMS could not be sent. Check logs!');
			}
			 
		}
		return array('error'=>'SMS plugin is not installed!');
	}
	
	public function opened($activity_mail_id,$activity_code){
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_to_mail` SET opened = opened+1 WHERE `activity_session_code` = '". $this->db->escape($activity_code) ."' AND `activity_mail_id` = '". (int)$activity_mail_id . "'");
	}
	
	public function clicked($activity_mail_id,$activity_code){
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_to_telephone` SET clicked = clicked+1 WHERE `activity_session_code` = '". $this->db->escape($activity_code) ."' AND `activity_mail_id` = '". (int)$activity_mail_id . "'");
	}
	
	public function getDeleteCronJob(){
		$data = array('delete_cron_status'=>0);
		$query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "xtensions_activity_extras` WHERE `key` = 'delete_cron_status' LIMIT 1");
		if($query->num_rows){
			$data['delete_cron_status'] = $query->row['value'];
		}
		$query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "xtensions_activity_extras` WHERE `key` = 'delete_cron' LIMIT 1");
		if($query->num_rows){
			$data = array_merge($data,json_decode($query->row['value'], true));
		}
		return $data;
	}
	
	public function deleteActivitiesByCron(){
		$data = $this->getDeleteCronJob();
		if(isset($data['delete_cron_status']) && isset($data['days']) && isset($data['criteria'])){
			$sql = "SELECT `activity_session_code` AS total FROM `" . DB_PREFIX . "xtensions_activity_order`"; 
			$where =" WHERE (DATE(date_added) < date_sub(DATE(now()), INTERVAL " . (int)$data['days'] . " DAY))";
			if($data['criteria'] == 'blank'){
				$where .= " AND ( cart IS NULL OR cart = '' OR last_step = 4 ) ";
			}
			$sql .= $where;
			$this->db->query("DELETE FROM `" . DB_PREFIX . "xtensions_activity_to_mail` WHERE `activity_session_code` IN ( " . $sql . " )");
			$this->db->query("DELETE FROM `" . DB_PREFIX . "xtensions_activity_to_telephone` WHERE `activity_session_code` IN ( " . $sql . " )");
			$this->db->query("DELETE FROM `" . DB_PREFIX . "xtensions_activity_step_by_step` WHERE `activity_session_code` IN ( " . $sql . " )");
			$this->db->query("DELETE FROM `" . DB_PREFIX . "xtensions_activity_order`".$where);
		}
		
	}
}
