<?php
/**
 * Module version: 6.20.7
 *
 * For bugs and suggestions please contact: support@drugoe.de
 *
 * CANADAPOST Smart & Flexible Shipping Module - Terms and conditions
 *
 * 1. Preamble: This Agreement governs the relationship between customer, (hereinafter: Licensee) and "Drugoe",
 *    an approved module vendor (hereinafter: Licensor). This Agreement sets the terms, rights,
 *    restrictions and obligations on using CANADAPOST Smart & Flexible Shipping Module
 *    (hereinafter: The Software) created and owned by Licensor, as detailed herein
 *
 * 2. License Grant: Licensor hereby grants Licensee a Personal, Non-assignable & non-transferable, Perpetual,
 *    Commercial, Royalty free, Including the rights to create but not distribute derivative works,
 *    Non-exclusive license, all with accordance with the terms set forth and other legal restrictions
 *    set forth in 3rd party software used while running Software.
 * 2.1. Limited: Licensee may use Software for the purpose of:
 * 2.1.1. Running Software on Licensee’s Website[s] and Server[s];
 * 2.1.2. Allowing 3rd Parties to run Software on Licensee’s Website[s] and Server[s];
 * 2.1.3. Publishing Software’s output to Licensee and 3rd Parties;
 * 2.1.4. Distribute verbatim copies of Software’s output (including compiled binaries);
 * 2.1.5. Modify Software to suit Licensee’s needs and specifications.
 * 2.2. This license is granted perpetually, as long as you do not materially breach it.
 * 2.3. Binary Restricted: Licensee may sublicense Software as a part of a larger work containing more than Software,
 *      distributed solely in Object or Binary form under a personal, non-sublicensable, limited license.
 *      Such redistribution shall be limited to unlimited codebases.
 * 2.4. Non Assignable & Non-Transferable: Licensee may not assign or transfer his rights and duties under this license.
 * 2.5. Commercial, Royalty Free: Licensee may use Software for any purpose,
 *      including paid-services, without any royalties
 * 2.6. Including the Right to Create Derivative Works: Licensee may create derivative works based on Software,
 *      including amending Software’s source code, modifying it, integrating it into a larger work or removing
 *      portions of Software, as long as no distribution of the derivative works is made
 *
 * 3. Term & Termination: The Term of this license shall be until terminated.
 *    Licensor may terminate this Agreement, including Licensee’s license in the case where Licensee :
 * 3.1. became insolvent or otherwise entered into any liquidation process; or
 * 3.2. exported The Software to any jurisdiction where licensor may not enforce his rights under this agreements in; or
 * 3.3. Licensee was in breach of any of this license's terms and conditions and such breach was not cured,
 *      immediately upon notification; or
 * 3.4. Licensee in breach of any of the terms of clause 2 to this license; or
 * 3.5. Licensee otherwise entered into any arrangement which caused Licensor to be unable to enforce his rights
 *      under this License.
 *
 * 4. Payment: In consideration of the License granted under clause 2, Licensee shall pay Licensor a fee,
 *    via Credit-Card, PayPal or any other mean which Licensor may deem adequate. Failure to perform payment
 *    shall construe as material breach of this Agreement.
 *
 * 5. Upgrades, Updates and Fixes: Licensor may provide Licensee, from time to time, with Upgrades, Updates or Fixes,
 *    as detailed herein and according to his sole discretion. Licensee hereby warrants to keep The Softwareup-to-date
 *    and install all relevant updates and fixes, and may, at his sole discretion, purchase upgrades,
 *    according to the rates set by Licensor. Licensor shall provide any update or Fix free of charge;
 *    however, nothing in this Agreement shall require Licensor to provide Updates or Fixes.
 * 5.1. Upgrades: for the purpose of this license, an Upgrade shall be a material amendment in The Software,
 *    which contains new features and or major performance improvements and shall be marked as a new version number.
 *    For example, should Licensee purchase The Software under version 1.X.X,
 *    an upgrade shall commence under number 2.0.0.
 * 5.2. Updates:  for the purpose of this license, an update shall be a minor amendment in The Software,
 *      which may contain new features or minor improvements and shall be marked as a new sub-version number.
 *      For example, should Licensee purchase The Software under version 1.1.X,
 *      an upgrade shall commence under number 1.2.0.
 * 5.3. Fix: for the purpose of this license, a fix shall be a minor amendment in The Software,
 *      intended to remove bugs or alter minor features which impair the The Software's functionality.
 *      A fix shall be marked as a new sub-sub-version number. For example, should Licensee purchase Software
 *      under version 1.1.1, an upgrade shall commence under number 1.1.2.
 *
 * 6. Support: Software is provided under an AS-IS basis and without any support, updates or maintenance.
 *    Nothing in this Agreement shall require Licensor to provide Licensee with support or fixes to any bug, failure,
 *    mis-performance or other defect in The Software.
 * 6.1. Bug Notification:  Licensee may provide Licensor of details regarding any bug, defect or failure in The Software
 *      promptly and with no delay from such event; Licensee shall comply with Licensor's request for information
 *      regarding bugs, defects or failures and furnish him with information, screenshots and try to reproduce
 *      such bugs, defects or failures.
 * 6.2. Feature Request:  Licensee may request additional features in Software, provided, however, that
 *      (i) Licensee shall waive any claim or right in such feature should feature be developed by Licensor;
 *     (ii) Licensee shall be prohibited from developing the feature, or disclose such feature request, or feature,
 *          to any 3rd party directly competing with Licensor or any 3rd party which may be,
 *          following the development of such feature, in direct competition with Licensor;
 *    (iii) Licensee warrants that feature does not infringe any 3rd party patent, trademark,
 *          trade-secret or any other intellectual property right; and
 *     (iv) Licensee developed, envisioned or created the feature solely by himself.
 *
 * 7. Liability:  To the extent permitted under Law, The Software is provided under an AS-IS basis.
 *    Licensor shall never, and without any limit, be liable for any damage, cost, expense or any other payment incurred
 *    by Licensee as a result of Software’s actions, failure, bugs and/or any other interaction between The Software
 *    and Licensee’s end-equipment, computers, other software or any 3rd party, end-equipment, computer or services.
 *    Moreover, Licensor shall never be liable for any defect in source code written by Licensee
 *    when relying on The Software or using The Software’s source code.
 *
 * 8. Warranty:
 * 8.1. Intellectual Property: Licensor hereby warrants that The Software does not violate or infringe
 *      any 3rd party claims in regards to intellectual property, patents and/or trademarks and that
 *      to the best of its knowledge no legal action has been taken against it for any infringement or violation
 *      of any 3rd party intellectual property rights.
 * 8.2. No-Warranty: The Software is provided without any warranty; Licensor hereby disclaims any warranty
 *      that The Software shall be error free, without defects or code which may cause damage to Licensee’s computers
 *      or to Licensee, and that Software shall be functional. Licensee shall be solely liable to any damage,
 *      defect or loss incurred as a result of operating software and undertake the risks contained in running
 *      The Software on License’s Server[s] and Website[s].
 * 8.3. Prior Inspection:  Licensee hereby states that he inspected The Software thoroughly and found it satisfactory
 *      and adequate to his needs, that it does not interfere with his regular operation and that it does meet
 *      the standards and scope of his computer systems and architecture. Licensee found that The Software interacts
 *      with his development, website and server environment and that it does not infringe any of End User License
 *      Agreement of any software Licensee may use in performing his services. Licensee hereby waives any claims
 *      regarding The Software's incompatibility, performance, results and features, and warrants that he inspected
 *      the The Software.
 *
 * 9. No Refunds: Licensee warrants that he inspected The Software according to clause 7(c) and that it is adequate
 *    to his needs. Accordingly, as The Software is intangible goods, Licensee shall not be, ever,
 *    entitled to any refund, rebate, compensation or restitution for any reason whatsoever, even if The Software
 *    contains material flaws.
 *
 * 10. Indemnification: Licensee hereby warrants to hold Licensor harmless and indemnify Licensor for any lawsuit
 *     brought against it in regards to Licensee’s use of The Software in means that violate, breach or otherwise
 *     circumvent this license, Licensor's intellectual property rights or Licensor's title in The Software.
 *     Licensor shall promptly notify Licensee in case of such legal action and request Licensee’s consent
 *     prior to any settlement in relation to such lawsuit or claim.
 *
 * 11. Governing Law, Jurisdiction: Licensee hereby agrees not to initiate class-action lawsuits against Licensor
 *     in relation to this license and to compensate Licensor for any legal fees, cost or attorney fees should
 *     any claim brought by Licensee against Licensor be denied, in part or in full.
 */

?><?php


namespace {



}
namespace {


// simple + shipping libaries except specific: nusoap, multi-request


}
namespace {



}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

class CoreFeatureChecker {
    /**
     * Checks that model file exists
     * @param string $modelName
     * @return bool
     * @throws CoreFeatureException
     */
    public static function hasAdminModel($modelName) {
        if (defined('_IS_DD_TEST_ENVIRONMENT')) {
            return false;
        }
        if (!defined('DIR_APPLICATION')) {
            throw new CoreFeatureException('Constant DIR_APPLICATION not defined');
        }
        if (!defined('DIR_CATALOG')) {
            throw new CoreFeatureException('Cannot use hasAdminModel from catalog');
        }
        $modelsDir = DIR_APPLICATION . 'model';
        return file_exists($modelsDir . '/' . $modelName . '.php');
    }

    /**
     * @param string $modelName
     * @return bool
     * @throws CoreFeatureException
     */
    public static function hasFrontModel($modelName) {
        if (defined('_IS_DD_TEST_ENVIRONMENT')) {
            return false;
        }
        if (!defined('DIR_APPLICATION')) {
            throw new CoreFeatureException('Constant DIR_APPLICATION not defined');
        }
        if (defined('DIR_CATALOG')) {
            throw new CoreFeatureException('Cannot use hasFrontModel from admin');
        }
        $modelsDir = DIR_APPLICATION . 'model';
        return file_exists($modelsDir . '/' . $modelName . '.php');
    }

    /**
     * Checks if modification is installed to the modification system or to VQMOD
     * @param object|null $modelModification
     * @param string $modificationName
     * @return bool
     * @throws CoreFeatureException
     */
    public static function isModificationInstalled($modelModification, $modificationName) {
        if ($modelModification) { // v2 and v3
            $mod = $modelModification->getModificationByCode($modificationName . '_mod');
            if (isset($mod['code'])) {
                return true;
            }
        }
        if (self::isVqmodInstalled()) { // v1 and vqmod on all versions
            if (!defined('DIR_SYSTEM')) {
                throw new CoreFeatureException('Constant DIR_SYSTEM not defined');
            }
            return file_exists(DIR_SYSTEM . '../vqmod/xml/'. $modificationName . '.xml');
        }
        return false;
    }

    /**
     * Checks ability to open and convert PDF files
     * @return bool
     */
    public static function isPdfConverterInstalled() {
        return (self::isImageMagickInstalled() || self::isGraphicsMagickInstalled()) && self::isGhostscriptInstalled();
    }

    /**
     * Checks that ImageMagick is installed
     * @return bool
     */
    public static function isImageMagickInstalled() {
        if (class_exists('Imagick') && class_exists('ImagickPixel')) {
            return true;
        }
        return false;
    }

    /**
     * Checks that PHP function is not disabled
     * @param string $func
     * @return bool
     */
    public static function isFunctionEnabled($func) {
        $disabledFunctions = array_map('trim', explode(',', ini_get('disable_functions')));
        return is_callable($func) && !in_array($func, $disabledFunctions, true);
    }

    /**
     * Checks that GraphicsMagick is installed
     * @return bool
     */
    public static function isGraphicsMagickInstalled() {
        if (self::isFunctionEnabled('shell_exec')) {
            if (shell_exec('which gm')) {
                return true;
            }
        }
        return false;
    }

    /**
     * Checks that Ghostscript is installed
     * @return bool
     */
    public static function isGhostscriptInstalled() {
        if (self::isFunctionEnabled('shell_exec')) {
            if (shell_exec('which gs')) {
                return true;
            }
        }
        return false;
    }

    /**
     * Checks that GD installed
     * @return bool
     */
    public static function isGdInstalled() {
        return function_exists('imagecreatefromstring');
    }

    /**
     * Checks that property exists
     * @param object $object
     * @param string $propertyName
     * @return bool
     */
    public static function hasProperty($object, $propertyName) {
        if (property_exists($object, $propertyName)) {
            return true;
        }
        if (method_exists($object, '__get')) {
            return $object->__get($propertyName) !== null;
        }
        return false;
    }

    /**
     * Checks that method exists
     * @param object $object
     * @param string $methodName
     * @return bool
     */
    public static function hasMethod($object, $methodName) {
        return method_exists($object, $methodName);
    }

    /**
     * @return bool
     */
    public static function isBrowserSupportsFramePrint() {
        if (strpos($_SERVER['HTTP_USER_AGENT'], 'Firefox') !== false) {
            return false;
        }
        return true;
    }

    /**
     * @return bool
     */
    public static function isVqmodInstalled() {
        return class_exists('VQmod');
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

class CoreFeatureException extends \Exception {
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

class VersionChecker {
    /** @var VersionChecker */
    private static $instance;
    /** @var string */
    private $version;
    /** @var int[] */
    private $supportedMajorVersions = array(1, 2, 3);
    /** @var int */
    private $major;
    /** @var int */
    private $minor;
    /** @var int */
    private $patch;

    /**
     * @throws \Exception
     */
    private function __construct() {
        $this->version = VERSION;
        list($this->major, $this->minor, $this->patch) = array_map('intval', explode('.', $this->version));
        if (!in_array($this->major, $this->supportedMajorVersions, true)) {
            throw new \Exception('Version ' . $this->version . ' is not supported');
        }
    }

    /**
     * @return VersionChecker
     * @throws \Exception
     */
    public static function get() {
        if (!self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * @return string
     */
    public function getVersion() {
        return $this->version;
    }

    /**
     * Returns version major bit
     * @return int
     */
    private function getMajor() {
        return $this->major;
    }

    /**
     * Returns version minor bit
     * @return int
     */
    private function getMinor() {
        return $this->minor;
    }

    /**
     * Checks that Version 1 running
     * @return bool
     */
    public function isVersion1() {
        return $this->getMajor() === 1;
    }

    /**
     * Checks that Version 2 running
     * @return bool
     */
    public function isVersion2() {
        return $this->getMajor() === 2;
    }

    /**
     * Checks that Version 2 is running below 2.1
     * @return bool
     */
    public function isVersion2LessThan21() {
        return $this->getMajor() === 2 && $this->getMinor() < 1;
    }

    /**
     * Checks that Version 2.3 running
     * @return bool
     */
    public function isVersion23() {
        return $this->getMajor() === 2 && $this->getMinor() === 3;
    }

    /**
     * Checks that Version 3 running
     * @return bool
     */
    public function isVersion3() {
        return $this->getMajor() === 3;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Controls {

class Tab {
    private $id;
    private $isDefault;
    private $content;
    private $titleKey;

    /**
     * @return Tab
     */
    public static function create() {
        return new self();
    }

    private function __construct() {
    }

    /**
     * @return mixed
     */
    public function getContent() {
        return $this->content;
    }

    /**
     * @param mixed $content
     * @return $this
     */
    public function setContent($content) {
        $this->content = $content;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getId() {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return $this
     */
    public function setId($id) {
        $this->id = $id;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getIsDefault() {
        return $this->isDefault;
    }

    /**
     * @param mixed $isDefault
     * @return $this
     */
    public function setIsDefault($isDefault) {
        $this->isDefault = $isDefault;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getTitleKey() {
        return $this->titleKey;
    }

    /**
     * @param mixed $titleKey
     * @return $this
     */
    public function setTitleKey($titleKey) {
        $this->titleKey = $titleKey;
        return $this;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\AccompanyingDocument;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\OrderedBoxPackedItem;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\Shipment;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginPackage;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\Configuration;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\Features;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Arrays;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Json;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;

abstract class ViewBuilder {
    protected $data;
    /** @deprecated */
    protected $isStandaloneTemplate = false;

    /**
     * @param array $data
     */
    public function __construct($data) {
        $this->data = $data;
    }

    /**
     * @param bool $b
     */
    public function setIsStandaloneTemplate($b) {
        $this->isStandaloneTemplate = (bool)$b;
    }

    /**
     * @return Locale
     */
    public function getLocale() {
        return $this->data['locale'];
    }

    /**
     * Imported from Module
     * @return string
     */
    protected function getExtensionName() {
        return call_user_func($this->data['get_extension_name']);
    }

    protected function getOcFolder() {
        return chr(111) . chr(112) . chr(101) . chr(110) . chr(99) . chr(97) . chr(114) . chr(116);
    }

    /**
     * @return string
     */
    protected function getViewPath() {
        return 'view';
    }

    /**
     * @return string
     * @since 02.05.2017 public again for PHP 5.3 compatibility, called in closure
     */
    public function getImagesPath() {
        return $this->getViewPath() . '/image/' . $this->getExtensionName();
    }

    /**
     * @return string
     */
    protected function getJavascriptPath() {
        return $this->getViewPath() . '/javascript/smart-flexible';
    }

    /**
     * @return string
     */
    protected function getStylesPath() {
        return $this->getViewPath() . '/stylesheet/smart-flexible';
    }

    /**
     * Imported from Module
     * @param string $key
     * @return string
     */
    protected function getPrefixedName($key) {
        return call_user_func($this->data['get_prefixed_name'], $key);
    }

    /**
     * @param string $feature
     * @return bool
     */
    public function hasFeature($feature) {
        return call_user_func($this->data['has_feature'], $feature);
    }

    /**
     * @return array
     */
    protected function getMethodCodesCustom() {
        if (isset($this->data['method_codes_custom'])) {
            if (is_array($this->data['method_codes_custom'])) {
                return $this->data['method_codes_custom'];
            }
        }
        return array();
    }

    /**
     * @return string
     */
    protected function getCurrentRoute() {
        return call_user_func($this->data['get_current_route']);
    }

    /**
     * @return string
     */
    protected function getEntryPoint() {
        return 'index.php?';
    }

    /**
     * Returns value of $data element by key
     * @param $key
     * @return mixed
     */
    protected function getData($key) {
        return isset($this->data[$key]) ? $this->data[$key] : '';
    }

    /**
     * Returns value of $data element by prefixed key
     * See $this->getPrefixedName()
     * @since 20.04.2017 accepts array indexes
     * @param $key
     * @return mixed
     */
    protected function getValue($key) {
        if (preg_match('/(.+)\[(.+)\]/', $key, $matches)) {
            $array = $this->getData($this->getPrefixedName($matches[1]));
            return isset($array[$matches[2]]) ? $array[$matches[2]] : '';
        }
        return $this->getData($this->getPrefixedName($key));
    }

    abstract protected function getTableCssClass($isForServices = false);
    abstract protected function getCenterCssClass();
    abstract protected function getHelpCssClass();
    abstract protected function getHeader();

    /**
     * Returns global footer
     * @return string
     */
    protected function getFooter() {
        return $this->getData('footer');
    }

    /**
     * @return string
     */
    protected function getjQuery() {
        return '<script type="text/javascript" src="https://code.jquery.com/jquery-3.1.1.min.js"></script>';
    }

    protected function getThreeJs() {
        return '<script src="https://cdnjs.cloudflare.com/ajax/libs/three.js/98/three.min.js"></script>';
    }

    protected function getLicenseLogo() {
        return sprintf('url(' . Author::LogoUrl . ')', $this->getExtensionName(), $this->getData('version'));
    }

    protected function isSimpleView() {
        return $this->getData('is_simple');
    }

    abstract protected function getInitMethod();

    /**
     * Returns view scripts
     * @return string
     */
    protected function getScripts() {
        $scripts = array();
        $scripts[] = sprintf('<script src="%s/%s.js?%s"></script>',
            $this->getJavascriptPath(), $this->getExtensionName(), $this->getData('version'));
        if ($this->isSimpleView()) {
            $config = array();
        } else {
            $methodsDependOnShipperCountry = $this->hasFeature(Features::ShipperAddress) &&
                $this->hasFeature(Features::MethodsDependOnShipperCountry);
            $methodsDependOnUserId = $this->hasFeature(Features::MethodsDependOnUserId);
            $hasWebhookApi = $this->hasFeature(Features::Webhook) && $this->hasFeature(Features::WebhookApi);
            $config = array(
                'address' => $this->getPrefixedName('address'),
                'adjustmentRules' => $this->getPrefixedName('adjustment_rules'),
                'balanceMin' => $this->getPrefixedName('balance_min'),
                'balanceInc' => $this->getPrefixedName('balance_inc'),
                'billingAddress' => $this->getPrefixedName('billing_address'),
                'billingCity' => $this->getPrefixedName('billing_city'),
                'billingCountryId' => $this->getPrefixedName('billing_country_id'),
                'billingPostcode' => $this->getPrefixedName('billing_postcode'),
                'billingSame' => $this->getPrefixedName('billing_same'),
                'billingZoneId' => $this->getPrefixedName('billing_zone_id'),
                'center' => $this->getCenterCssClass(),
                'city' => $this->getPrefixedName('city'),
                'countryId' => $this->getPrefixedName('country_id'),
                'currentRoute' => $this->getCurrentRoute(),
                'customEnvelopes' => $this->getPrefixedName('custom_envelopes'),
                'customPackages' => $this->getPrefixedName('custom_packages'),
                'entryPoint' => $this->getEntryPoint(),
                'equalConfig' => $this->getPrefixedName('equal_config'),
                'fallbackProductCountry' => $this->getPrefixedName('fallback_product_country'),
                'fallbackProductHsCode' => $this->getPrefixedName('fallback_product_hs_code'),
                'fallbackProductZone' => $this->getPrefixedName('fallback_product_zone'),
                'fallbackPacker' => $this->getPrefixedName('fallback_packer'),
                'imagesPath' => $this->getImagesPath(),
                'individualTare' => $this->getPrefixedName('individual_tare'),
                'insurance' => $this->getPrefixedName('insurance'),
                'insuranceFrom' => $this->getPrefixedName('insurance_from'),
                'insuranceDisabled' => Configuration::InsuranceDisabled,
                'invoice' => $this->getPrefixedName('invoice'),
                'label' => $this->getPrefixedName('label'),
                'labelDisabled' => Configuration::LabelDisabled,
                'labelFormat' => $this->getPrefixedName('label_format'),
                'labelManually' => Configuration::LabelManually,
                'labelOriginal' => Configuration::LabelFormatOriginal,
                'licenseCookie' => $this->getData('license_cookie'),
                'measurementSystem' => $this->getPrefixedName('measurement_system'),
                'methodsDependOnShipperCountry' => $methodsDependOnShipperCountry,
                'methodsDependOnUserId' => $methodsDependOnUserId,
                'packer' => $this->getPrefixedName('packer'),
                'packer3dPacker' => Configuration::Packer3dPacker,
                'packerIndividual' => Configuration::PackerIndividual,
                'packerWeightBased' => Configuration::PackerWeightBased,
                'packerBoxMaker' => Configuration::PackerBoxMaker,
                'paperless' => $this->getPrefixedName('paperless'),
                'pdfConverter' => $this->getPrefixedName('pdf_converter'),
                'postcode' => $this->getPrefixedName('postcode'),
                'postcodeDub' => $this->getPrefixedName('postcode_dub'),
                'processingHolidays' => $this->getPrefixedName('processing_holidays'),
                'promo' => $this->getPrefixedName('promo'),
                'senderCompany' => $this->getPrefixedName('sender_company'),
                'senderName' => $this->getPrefixedName('sender_name'),
                'senderTelephone' => $this->getPrefixedName('sender_telephone'),
                'shippingCategories' => $this->getPrefixedName('shipping_categories'),
                'standardPackages' => $this->getPrefixedName('standard_packages'),
                'storeId' => $this->getData('store_id'),
                'textRemovePackage' => $this->getData('text_remove_package'),
                'textRemovePromo' => $this->getData('text_remove_promo'),
                'textRemoveShippingCategory' => $this->getData('text_remove_shipping_category'),
                'textShippingCategoryShipTogether' => $this->getData('entry_shipping_category_ship_together'),
                'token' => $this->getData('token'),
                'tokenName' => $this->getData('token_name'),
                'tracking' => $this->getPrefixedName('tracking'),
                'trackingImmediately' => Configuration::TrackingSendImmediately,
                'userId' => $this->getPrefixedName('user_id'),
                'weightBasedFakedBox' => $this->getPrefixedName('weight_based_faked_box'),
                'weightBasedLimit' => $this->getPrefixedName('weight_based_limit'),
                'zoneId' => $this->getPrefixedName('zone_id'),
                'productsTree' => $this->getData('products_tree'),
                'extensionName' => $this->getExtensionName(),
                'faqUrl' => Author::FaqUrl,
                'signature' => $this->getPrefixedName('signature'),
                'proofOfAge' => $this->getPrefixedName('proof_of_age'),
                'hasWebhookApi' => $hasWebhookApi,
                'composedId' => $this->getComposedIdConstants(),
                'trackingNotify' => $this->getPrefixedName('tracking_notify'),
                'signatureNotRequired' => Configuration::SignatureNotRequired,
                'serviceDefault' => Configuration::ServiceDefault,
                'signatureType' => $this->getPrefixedName('signature_type'),
                'boxMakerLength' => $this->getPrefixedName('box_maker_length'),
                'boxMakerWidth' => $this->getPrefixedName('box_maker_width'),
                'boxMakerWeightLimit' => $this->getPrefixedName('box_maker_weight_limit'),
                'boxMakerMargin' => $this->getPrefixedName('box_maker_margin')
            );
        }
        $scripts[] = sprintf(
            '<script>$(function() {' . /** @noinspection BadExpressionStatementJS */
            'objSmartFlexible.init(%s); objSmartFlexible.%s(); });</script>',
            Json::encodePretty($config), $this->getInitMethod()
        );
        return implode("\n", $scripts);
    }

    /**
     * Returns view styles
     * @return string
     */
    protected function getStyles() {
        return sprintf('<link href="%s/%s.css?%s" rel="stylesheet">',
            $this->getStylesPath(), $this->getExtensionName(), $this->getData('version'));
    }

    /**
     * @return string[]
     */
    protected function getComposedIdConstants() {
        return array(
            'standard' => OriginPackage::ComposedIdStandard,
            'fixed' => OriginPackage::ComposedIdCustomFixed,
            'expandable' => OriginPackage::ComposedIdCustomExpandable,
            'separator' => OriginPackage::ComposedIdSeparator,
            'shared' => OriginPackage::ComposedIdShared,
            'any' => OriginPackage::ComposedIdAny
        );
    }

    abstract protected function renderBreadcrumbs();
    abstract protected function renderHeadingNotice();
    abstract protected function renderSubHeader();
    abstract protected function renderError($key);
    abstract public function renderContainer($content);
    abstract protected function renderTab(Controls\Tab $tab);
    abstract public function renderTabs($tabs = array());
    abstract public function renderSetting($titleKey, $helpKey, $errorKey, $isRequired, $content, $sharedKeys = null);
    abstract protected function renderDemo();
    abstract protected function renderLicense();
    abstract public function renderJsDropdown(Controls\Select $select);

    public function renderStatic($content) {
        return sprintf('<p class="form-control-static">%s</p>', $content);
    }

    public function renderSelect(Controls\Select $select) {
        $value = $this->getValue($select->getNameKey());
        $value = array_map('strval', is_array($value) ? $value : array($value));
        $result = sprintf(
            '<select class="form-control %s" name="%s"%s>',
            $select->getCssClass(),
            $this->getPrefixedName($select->getNameKey()) . ($select->getMultiple() ? '[]' : ''),
            $select->getMultiple() ? ' multiple size="5"' : ''
        );
        $source = $this->getData($select->getSourceKey());
        if (is_array($source)) {
            foreach ($source as $item) {
                $result .= sprintf('<option value="%s"%s>%s</option>',
                    $item[$select->getValueField()],
                    (in_array((string)$item[$select->getValueField()], $value, true) ? ' selected' : ''),
                    $item[$select->getCaptionField()]);
            }
        }
        $result .= '</select>';
        return $result;
    }

    public function renderOptions(Controls\Select $select) {
        $value = $this->getValue($select->getNameKey());
        $result = '<div class="btn-group" data-toggle="buttons">';
        $source = $this->getData($select->getSourceKey());
        if (is_array($source)) {
            foreach ($source as $item) {
                $isActive = (string)$value === (string)$item[$select->getValueField()];
                $result .= sprintf('<label class="btn btn-default%s">' .
                    '<input type="radio" name="%s" value="%s" autocomplete="off"%s> %s</label>',
                    $isActive ? ' active' : '',
                    $this->getPrefixedName($select->getNameKey()),
                    $item[$select->getValueField()],
                    $isActive ? ' checked' : '',
                    $item[$select->getCaptionField()]);
            }
        }
        $result .= '</div>';
        return $result;
    }

    abstract protected function isInputAddonRequiresSpacing();

    public function renderInput(Controls\Input $input) {
        $value = $this->getValue($input->getNameKey());
        if ($input->getPrerender()) {
            $value = call_user_func($input->getPrerender(), $value);
        }
        $addons = $input->getAddons();
        if ($addons['left'] || $addons['right']) {
            $result = sprintf('<div class="input-group %s">', $input->getCssClass()) .
                    ($addons['left'] ?
                        sprintf('<span class="input-group-addon">%s%s</span>',
                            $addons['left'], $this->isInputAddonRequiresSpacing() ? ' ' : ''
                        ) : ''
                    ) .
                    sprintf('<input class="form-control"%s name="%s" value="%s" />',
                        $input->getIsDisabled() ? ' disabled="disabled"' : '',
                        $this->getPrefixedName($input->getNameKey()),
                        $value) .
                    ($addons['right'] ?
                        sprintf('<span class="input-group-addon">%s%s</span>',
                            $this->isInputAddonRequiresSpacing() ? ' ' : '', $addons['right']
                        ) : ''
                    ) .
              '</div>';
        } else {
            $result = sprintf('<input class="form-control %s"%s name="%s" value="%s" />',
                $input->getCssClass(),
                $input->getIsDisabled() ? ' disabled="disabled"' : '',
                $this->getPrefixedName($input->getNameKey()),
                $value);
        }
        return $result;
    }

    public function renderHidden(Controls\Input $input) {
        $value = $this->getValue($input->getNameKey());
        if ($input->getPrerender()) {
            $value = call_user_func($input->getPrerender(), $value);
        }
        return sprintf('<input name="%s" type="hidden" value="%s" />',
            $this->getPrefixedName($input->getNameKey()), $value);
    }

    public function renderCheckbox(Controls\Input $input) {
        if ($input->getIsChecked() === null) {
            $input->setIsChecked($this->getValue($input->getNameKey()));
        }
        return sprintf('<div class="checkbox"><label><input name="%s" type="hidden" value="0" />' .
            '<input name="%s"%s type="checkbox" value="1"%s />%s</label></div>',
            $this->getPrefixedName($input->getNameKey()),
            $this->getPrefixedName($input->getNameKey()),
            $input->getIsDisabled() ? ' disabled="disabled"' : '',
            $input->getIsChecked() ? ' checked="checked"' : '',
            $input->getCaption());
    }

    public function renderTextarea(Controls\Input $input) {
        $value = $this->getValue($input->getNameKey());
        if ($input->getPrerender()) {
            $value = call_user_func($input->getPrerender(), $value);
        }
        return sprintf('<textarea class="form-control %s" name="%s">%s</textarea>',
            $input->getCssClass(),
            $this->getPrefixedName($input->getNameKey()), $value);
    }

    public function renderMeasurementSystem() {
        $result = $this->renderSetting(
            'entry_measurement_system', 'help_measurement_system', 'error_measurement_system', true,
            $this->renderSelect(Controls\Select::create()
                ->setNameKey('measurement_system')
                ->setSourceKey('measurement_systems')
                ->setCaptionField('text')
                ->setValueField('value')
            ) .
            $this->renderStatic('System currency is <strong>' . $this->getData('system_currency') .
                '</strong>, hereinafter is marked with <strong>' . $this->getData('currency_unit') . '</strong>')
        );
        return $result;
    }

    public function renderStandardPackages() {
        $scripts = array();
        $enabledBoxes = $this->getValue('standard_packages');
        foreach ($this->data['boxes'] as $box) {
            /** @var OriginPackage $box */
            $boxEnabled = isset($enabledBoxes[$box->getId()]) ? $enabledBoxes[$box->getId()] : false;
            $scripts[] = sprintf('objSmartFlexible.addStandardBox(%d, "%s", "%s", "%s", "%s", %d);',
                $box->getId(), $box->getTitle(), $box->getImage(), $box->getSizeDescription($this->getLocale()),
                $box->getWeightDescription($this->getLocale()), (int)$boxEnabled);
        }
        $result = sprintf('<div id="standard-boxes-checked"><h4>%s</h4></div>' .
            '<div id="standard-boxes-unchecked"><h4>%s</h4></div>' .
            '<script>$(function() {%s});</script>',
            $this->getData('entry_boxes_checked'),
            $this->getData('entry_boxes_unchecked'),
            implode("\n", $scripts));
        return $result;
    }

    public function prerenderLargeWeightWithEmpty($v) {
        if ($v) {
            return $this->getLocale()->renderLargeWeight($v);
        }
        return '';
    }

    public function prerenderLengthWithEmpty($v) {
        if ($v) {
            return $this->getLocale()->renderLength($v);
        }
        return '';
    }

    public function renderBoxMakerLength() {
        return sprintf('<div class="box-maker-length__holder">%s%s</div>',
            $this->renderInput(Controls\Input::create()
                ->setNameKey('box_maker_length[min]')
                ->setPrerender(Array($this, 'prerenderLengthWithEmpty'))
                ->setAddons(null, '—')),
            $this->renderInput(Controls\Input::create()
                ->setNameKey('box_maker_length[max]')
                ->setPrerender(Array($this, 'prerenderLengthWithEmpty'))
                ->setAddons(null, $this->getLocale()->renderLengthUnit()))
        );
    }

    public function renderWeightBasedFakedBox() {
        return sprintf('<div class="weight-based-faked-box__holder">%s%s%s</div>',
            $this->renderInput(
                Controls\Input::create()
                    ->setNameKey('weight_based_faked_box[length]')
                    ->setCssClass('weight-based-faked-box__dimension')
                    ->setAddons(null, '&#215;')
                    ->setPrerender(Array($this, 'prerenderLengthWithEmpty'))),
            $this->renderInput(
                Controls\Input::create()
                    ->setNameKey('weight_based_faked_box[width]')
                    ->setCssClass('weight-based-faked-box__dimension')
                    ->setAddons(null, '&#215;')
                    ->setPrerender(Array($this, 'prerenderLengthWithEmpty'))),
            $this->renderInput(
                Controls\Input::create()
                    ->setNameKey('weight_based_faked_box[height]')
                    ->setCssClass('weight-based-faked-box__dimension')
                    ->setAddons(null, $this->getLocale()->renderLengthUnit())
                    ->setPrerender(Array($this, 'prerenderLengthWithEmpty')))
            );
    }

    public function renderCustomPackagesFixed() {
        $scripts = array();
        foreach ($this->getValue('custom_packages') as $id => $package) {
            $scripts[] = sprintf('objSmartFlexible.addCustomPackage("%s", "%s", "%s", "%s", "%s", "%s");',
                isset($package['length']) ? $this->getLocale()->renderLength($package['length']) : '',
                isset($package['width']) ? $this->getLocale()->renderLength($package['width']) : '',
                isset($package['height']) ? $this->getLocale()->renderLength($package['height']) : '',
                isset($package['max_load']) ? $this->getLocale()->renderLargeWeight($package['max_load']) : '',
                isset($package['tare']) ? $this->getLocale()->renderSmallWeight($package['tare']) : '',
                $id
            );
        }
        $result = sprintf('<table class="%s" style="width: initial;"><thead><tr>' .
                '<td class="%s">%s</td>' .
                str_repeat('<td class="%s">%s, <em>%s</em></td>', 5) .
                '<td>&nbsp;</td></tr></thead><tbody id="custom_packages_holder"></tbody></table>' .
                '<script>$(function() {%s});</script>',
                $this->getTableCssClass(),
                $this->getCenterCssClass(),
                $this->getData('entry_id'),
                $this->getCenterCssClass(),
                $this->getData('entry_length'),
                $this->getLocale()->renderLengthUnit(),
                $this->getCenterCssClass(),
                $this->getData('entry_width'),
                $this->getLocale()->renderLengthUnit(),
                $this->getCenterCssClass(),
                $this->getData('entry_height'),
                $this->getLocale()->renderLengthUnit(),
                $this->getCenterCssClass(),
                $this->getData('entry_max_load'),
                $this->getLocale()->renderLargeWeightUnit(),
                $this->getCenterCssClass(),
                $this->getData('entry_tare'),
                $this->getData('custom_package_fixed_unit') === Weight::UnitTypeSmall ?
                    $this->getLocale()->renderSmallWeightUnit() : $this->getLocale()->renderLargeWeightUnit(),
                implode("\n", $scripts)) .
                sprintf('<div><a href="#" class="btn btn-primary" ' .
                'onclick=\'objSmartFlexible.addCustomPackage("", "", "", "", ""); return false;\'>%s</a></div>',
                $this->getData('text_add_package'));
        return $result;
    }

    public function renderCustomPackagesExpandable() {
        $scripts = array();
        foreach ($this->getValue('custom_envelopes') as $id => $envelope) {
            $scripts[] = sprintf('objSmartFlexible.addCustomEnvelope("%s", "%s", "%s", "%s", "%s", "%s");',
                isset($envelope['length']) ? $this->getLocale()->renderLength($envelope['length']) : '',
                isset($envelope['width']) ? $this->getLocale()->renderLength($envelope['width']) : '',
                isset($envelope['max_height']) ? $this->getLocale()->renderLength($envelope['max_height']) : '',
                isset($envelope['max_load']) ? $this->getLocale()->renderLargeWeight($envelope['max_load']) : '',
                isset($envelope['tare']) ? $this->getLocale()->renderSmallWeight($envelope['tare']) : '',
                $id
            );
        }
        $result = sprintf('<table class="%s" style="width: initial;"><thead><tr>' .
                '<td class="%s">%s</td>' .
                str_repeat('<td class="%s">%s, <em>%s</em></td>', 5) .
                '<td>&nbsp;</td></tr></thead><tbody id="custom_envelopes_holder"></tbody></table>' .
                '<script>$(function() {%s});</script>',
                $this->getTableCssClass(),
                $this->getCenterCssClass(),
                $this->getData('entry_id'),
                $this->getCenterCssClass(),
                $this->getData('entry_length'),
                $this->getLocale()->renderLengthUnit(),
                $this->getCenterCssClass(),
                $this->getData('entry_width'),
                $this->getLocale()->renderLengthUnit(),
                $this->getCenterCssClass(),
                $this->getData('entry_max_height'),
                $this->getLocale()->renderLengthUnit(),
                $this->getCenterCssClass(),
                $this->getData('entry_max_load'),
                $this->getLocale()->renderLargeWeightUnit(),
                $this->getCenterCssClass(),
                $this->getData('entry_tare'),
                $this->getData('custom_package_expandable_unit') === Weight::UnitTypeSmall ?
                    $this->getLocale()->renderSmallWeightUnit() : $this->getLocale()->renderLargeWeightUnit(),
                implode("\n", $scripts)) .
                sprintf('<div><a href="#" class="btn btn-primary" ' .
                'onclick=\'objSmartFlexible.addCustomEnvelope("", "", "", "", ""); return false;\'>%s</a></div>',
                $this->getData('text_add_envelope'));

        return $result;
    }

    public function renderShippingCategories() {
        $scripts = array();
        if (is_array($this->getValue('shipping_categories'))) {
            foreach ($this->getValue('shipping_categories') as $category) {
                $scripts[] = sprintf(
                    'objSmartFlexible.addShippingCategory(%s, %s, %s, %s, %s);',
                    isset($category['name']) ? Json::encode($category['name']) : '""',
                    isset($category['ship_together']) ? ($category['ship_together'] ? 'true' : 'false') : 'false',
                    isset($category['packages']) ? Json::encode($category['packages']) : '[]',
                    isset($category['categories']) ? Json::encode($category['categories']) : '[]',
                    isset($category['products']) ? Json::encode($category['products']) : '[]');
            }
        }
        $result = (
            '<div id="shipping-categories"></div>' .
            sprintf(
                '<div><a href="javascript:void(0)" class="btn btn-primary" ' .
                'onclick=\'objSmartFlexible.addShippingCategory("New shipping category", false, [], [], []); ' .
                'return false;\'>%s</a></div>',
                $this->getData('text_add_shipping_category')
            ) .
            sprintf('<script>$(function() {%s});</script>', implode("\n", $scripts))
        );
        return $result;
    }

    public function renderPromo() {
        $scripts = array();
        foreach ($this->getValue('promo') as $promo) {
            $scripts[] = sprintf('objSmartFlexible.addPromo("%s", "%s", "%s", "%s", "%s");',
                isset($promo['min_cost']) ? $promo['min_cost'] : '',
                isset($promo['length']) ? $this->getLocale()->renderLength($promo['length']) : '',
                isset($promo['width']) ? $this->getLocale()->renderLength($promo['width']) : '',
                isset($promo['height']) ? $this->getLocale()->renderLength($promo['height']) : '',
                isset($promo['weight']) ? $this->getLocale()->renderLargeWeight($promo['weight']) : '');
        }
        $result = sprintf('<table class="%s" style="width: initial;"><thead><tr>' .
                str_repeat('<td class="%s">%s, <em>%s</em></td>', 5) .
                '<td>&nbsp;</td></tr></thead><tbody id="promo_holder"></tbody></table>' .
                '<script>$(function() {%s});</script>',
                $this->getTableCssClass(),
                $this->getCenterCssClass(),
                $this->getData('entry_min_cost'),
                $this->getData('currency_unit'),
                $this->getCenterCssClass(),
                $this->getData('entry_length'),
                $this->getLocale()->renderLengthUnit(),
                $this->getCenterCssClass(),
                $this->getData('entry_width'),
                $this->getLocale()->renderLengthUnit(),
                $this->getCenterCssClass(),
                $this->getData('entry_height'),
                $this->getLocale()->renderLengthUnit(),
                $this->getCenterCssClass(),
                $this->getData('entry_weight'),
                $this->getLocale()->renderLargeWeightUnit(),
                implode("\n", $scripts)) .
                sprintf('<div><a href="#" class="btn btn-primary" ' .
                'onclick=\'objSmartFlexible.addPromo("", "", "", "", ""); return false;\'>%s</a></div>',
                $this->getData('text_add_promo'));
        return $result;
    }

    public function renderAdjustmentRules() {
        $scripts = array();
        if (is_array($this->getValue('adjustment_rules'))) {
            foreach ($this->getValue('adjustment_rules') as $rule) {
                $scripts[] = sprintf('objSmartFlexible.addAdjustmentRule(%s);', Json::encodePretty($rule));
            }
        }
        $result = sprintf('<a href="#" class="btn btn-primary adjustment-rule__add" ' .
            'onclick="objSmartFlexible.addAdjustmentRule({}); return false">%s</a><script>$(function() {%s});</script>',
            $this->getData('text_add_adjustment_rule'), implode("\n", $scripts));
        return $result;
    }

    public function renderProcessing() {
        $result = $this->renderInput(Controls\Input::create()
            ->setNameKey('processing_days')
            ->setAddons(null, $this->getData('text_business_days'))
            ->setCssClass('processing-days'));
        $result .= '<div>&nbsp;</div>';
        $result .= $this->renderCheckbox(Controls\Input::create()
            ->setNameKey('processing_saturdays')
            ->setCaption($this->getData('entry_processing_saturdays')));
        $result .= $this->renderCheckbox(Controls\Input::create()
            ->setNameKey('processing_sundays')
            ->setCaption($this->getData('entry_processing_sundays')));
        return $result;
    }

    public function renderHolidays() {
        $googleHolidays = $this->renderSelect(Controls\Select::create()
            ->setNameKey('google_import')
            ->setSourceKey('google_holidays')
            ->setCssClass('google-holidays')
            ->setCaptionField('text')
            ->setValueField('value'));
        $result = sprintf('<div id="holidays__controls"><span>%s</span>%s' .
            '<a href="#" class="btn btn-default" onclick="objSmartFlexible.importHolidays(); return false;">%s</a> ' .
            '<a href="#" class="btn btn-default" onclick="objSmartFlexible.clearHolidays(); return false">%s</a>' .
            '</div><div id="holidays__holder">',
            $this->getData('text_import_google_calendar'),
            $googleHolidays,
            $this->getData('text_import_holidays'),
            $this->getData('text_reset_holidays'));
        for ($m = 1; $m <= 12; $m++) {
            $month = date('F', mktime(0, 0, 0, $m, 1));
            $result .= sprintf('<div id="holidays_%s" class="holidays__month"><div>%s</div>' .
                '<div class="holidays__list"><div class="holidays_add">%s</div></div></div>',
                $m, $month, $this->getData('text_add_holiday'));
        }
        $scripts = array();
        foreach ($this->getValue('processing_holidays') as $holiday) {
            $scripts[] = sprintf('objSmartFlexible.addHoliday("%s", "%s");', $holiday[0], $holiday[1]);
        }
        $result .= sprintf('</div><script>$(function() {%s});</script>', implode("\n", $scripts));

        return $result;
    }

    public function renderAvoidDelivery() {
        if ($this->hasFeature(Features::RequestAvoidWeekendDelivery)) {
            $result = $this->renderOptions(Controls\Select::create()
                ->setNameKey('avoid_delivery_saturdays')
                ->setSourceKey('booleans'));
        } else {
            $result = $this->renderCheckbox(Controls\Input::create()
                ->setNameKey('avoid_delivery_saturdays')
                ->setCaption($this->getData('entry_avoid_delivery_saturdays')));
            $result .= $this->renderCheckbox(Controls\Input::create()
                ->setNameKey('avoid_delivery_sundays')
                ->setCaption($this->getData('entry_avoid_delivery_sundays')));
        }
        return $result;
    }

    protected function getTime() {
        return time();
    }

    public function renderCutoff() {
        $result = $this->renderSelect(Controls\Select::create()
            ->setNameKey('cutoff')
            ->setSourceKey('hours'));
        $result .= sprintf('<div class="%s">Server time: %s</div><div class="%s">%s</div>',
            $this->getHelpCssClass(),
            date('H:i', $this->getTime()),
            $this->getHelpCssClass(),
            $this->getData('entry_cutoff_help'));
        return $result;
    }

    public function renderInsurance() {
        $result = '<div class="insurance__holder">';
        $result .= $this->renderOptions(Controls\Select::create()
            ->setNameKey('insurance')
            ->setSourceKey('insurances'));
        $result .= $this->renderInput(Controls\Input::create()
            ->setNameKey('insurance_from')
            ->setCssClass('insurance__from')
            ->setAddons($this->getData('entry_insurance_from'), $this->getData('currency_unit')));
        $result .= '</div>' . sprintf('<div class="%s" id="insurance_from_help">%s</div>',
            $this->getHelpCssClass(), $this->getData('help_insurance_from'));
        return $result;
    }

    public function renderGeoZones() {
        $result = $this->renderCheckbox(Controls\Input::create()
            ->setNameKey('all_geo_zones')
            ->setCaption($this->getData('text_all_geo_zones')));
        $result .= '<div>&nbsp;</div>';
        $geoZones = $this->getValue('geo_zones');
        foreach ($this->getData('geo_zones') as $geoZone) {
            $zoneEnabled = false;
            if (isset($geoZones[$geoZone['geo_zone_id']])) {
                $zoneEnabled = $geoZones[$geoZone['geo_zone_id']];
            }
            $result .= $this->renderCheckbox(Controls\Input::create()
                ->setNameKey('geo_zones[' . $geoZone['geo_zone_id'] . ']')
                ->setCaption($geoZone['name'])
                ->setIsChecked($zoneEnabled));
        }
        return $result;
    }

    public function renderCustomerGroups() {
        $result = $this->renderCheckbox(Controls\Input::create()
            ->setNameKey('all_customer_groups')
            ->setCaption($this->getData('text_all_customer_groups')));
        $result .= '<div>&nbsp;</div>';
        $customerGroups = $this->getValue('customer_groups');
        foreach ($this->getData('customer_groups') as $customerGroup) {
            $groupEnabled = false;
            if (isset($customerGroups[$customerGroup['customer_group_id']])) {
                $groupEnabled = $customerGroups[$customerGroup['customer_group_id']];
            }
            $result .= $this->renderCheckbox(Controls\Input::create()
                ->setNameKey('customer_groups[' . $customerGroup['customer_group_id']. ']')
                ->setCaption($customerGroup['name'])
                ->setIsChecked($groupEnabled));
        }
        return $result;
    }

    public function renderStores() {
        if (count($this->getData('stores')) === 1) { // do not show when the only store
            return '';
        }
        $equalConfigSwitch = $this->renderOptions(Controls\Select::create()
            ->setNameKey('equal_config')
            ->setSourceKey('equal_config'));
        $storeSelectionControl = $this->renderJsDropdown(Controls\Select::create()
            ->setNameKey('store_id')
            ->setSourceKey('stores')
            ->setValueField('store_id')
            ->setCaptionField('name'));
        return sprintf('<div class="row" id="equal-config"><div class="col-xs-12">%s' .
            '%s%s</div></div>',
            $this->getData('entry_equal_config'),
            $equalConfigSwitch,
            $this->getValue('equal_config') ? '' : $storeSelectionControl);
    }

    private function renderGlobalServiceButtons($isWithRefresh = false) {
        $refresh = sprintf(' / <a href="#" onclick="objSmartFlexible.fetchServicesByUser(); return false;">%s</a>',
            $this->getData('text_refresh'));
        return sprintf('<div><a href="#" onclick=\'$(this).parents("td").find(":checkbox").prop("checked", true); ' .
            'return false;\'>%s</a> / ' .
            '<a href="#" onclick=\'$(this).parents("td").find(":checkbox").prop("checked", false); ' .
            'return false;\'>%s</a>%s</div>',
            $this->getData('text_select_all'), $this->getData('text_unselect_all'), $isWithRefresh ? $refresh : '');
    }

    public function renderServices() {
        $result = sprintf('<table class="%s services"><tr>', $this->getTableCssClass(true));
        if (
            $this->hasFeature(Features::MethodsDependOnShipperCountry) ||
            $this->hasFeature(Features::MethodsDependOnUserId)
        ) {
            $methodCodes = $this->getMethodCodesCustom();
        } else {
            $methodCodes = $this->data['method_codes'];
        }
        $methods = $this->getValue('methods');
        foreach (array_keys($methodCodes) as $service) {
            $checkboxes = array();
            foreach ($methodCodes[$service] as $group => $codes) {
                $checkboxes[] = sprintf('<div class="services__group">%s</div>', $this->getData('text_' . $group));
                foreach ($codes as $code) {
                    $fullKey = $service . '_' . $code;
                    $methodEnabled = false;
                    if (isset($methods[$fullKey])) {
                        $methodEnabled = $methods[$fullKey];
                    }
                    $checkboxes[] = $this->renderCheckbox(Controls\Input::create()
                        ->setNameKey('methods[' . $fullKey . ']')
                        ->setCaption($this->getData('text_' . $fullKey))
                        ->setIsChecked($methodEnabled));
                }
            }
            $result .= sprintf('<td><div class="services__service">%s</div>%s%s</td>',
                $this->getData('text_' . $service),
                $this->renderGlobalServiceButtons(),
                implode("\n", $checkboxes));
        }
        $result .= '</tr></table>';
        return $result;
    }

    public function renderServicesByUser() {
        $result = '';
        $methods = $this->getValue('methods');
        foreach ($this->getMethodCodesCustom() as $group => $codes) {
            $result .= sprintf('<div class="services__group">%s</div>', $group);
            foreach ($codes as $code => $title) {
                $methodEnabled = false;
                if (isset($methods[$code])) {
                    $methodEnabled = $methods[$code];
                }
                $result .= $this->renderCheckbox(Controls\Input::create()
                    ->setNameKey('methods[' . $code . ']')
                    ->setCaption($this->getData('text_' . $title))
                    ->setIsChecked($methodEnabled));
            }
        }
        return sprintf('<table class="%s services"><tr><td>' .
            '<div class="services__service">%s</div>%s%s</td></tr></table>',
            $this->getTableCssClass(true), $this->getData('text_services_by_user'),
            $this->renderGlobalServiceButtons(true), $result);
    }

    public function renderWebhook() {
        if ($this->hasFeature(Features::WebhookApi)) {
            return $this->renderStatic('<span id="webhook-status"></span>');
        } else {
            return $this->renderStatic(sprintf(
                '<input class="form-control" disabled="disabled" value="%s" id="webhook-url">',
                $this->getData('webhook')
            ));
        }
    }

    public function renderLabelFormatAndConverter() {
        $result = '';
        if ($this->hasFeature(Features::ShippingLabel4x6Inches)) {
            $result .= $this->renderSetting('entry_label_format', 'help_label_format', '', false,
                $this->renderSelect(Controls\Select::create()
                    ->setNameKey('label_format')
                    ->setSourceKey('label_formats')));
            if ($this->getData('label_format_pdf')) {
                $result .= $this->renderSetting('entry_pdf_converter', 'help_pdf_converter', '',
                    false, $this->renderSelect(Controls\Select::create()
                        ->setNameKey('pdf_converter')
                        ->setSourceKey('pdf_converters')));
            }
        }
        return $result;
    }

    public function renderBalance() {
        return $this->renderSetting('entry_balance_min', 'help_balance_min', 'error_balance_min', true,
            $this->renderInput(Controls\Input::create()
                ->setNameKey('balance_min')
                ->setCssClass('small-number')
                ->setAddons(null, $this->getData('currency_unit'))
            )
        ) . $this->renderSetting('entry_balance_inc', 'help_balance_inc', 'error_balance_inc', true,
            $this->renderInput(Controls\Input::create()
                ->setNameKey('balance_inc')
                ->setCssClass('small-number')
                ->setAddons(null, $this->getData('currency_unit'))
            )
        );
    }

    public function renderSignature() {
        $optionsTitle = '';
        if ($this->hasFeature(Features::SignatureTypes)) {
            $optionsTitle = $this->renderStatic($this->getData('entry_signature_type'));
        } elseif ($this->hasFeature(Features::SignatureWithProofOfAge)) {
            $optionsTitle = $this->renderStatic($this->getData('entry_proof_of_age'));
        }
        $signatureOptions = '';
        if ($this->hasFeature(Features::SignatureTypes)) {
            $signatureOptions = $this->renderOptions(Controls\Select::create()
                ->setNameKey('signature_type')
                ->setSourceKey('signature_types'));
        } elseif ($this->hasFeature(Features::SignatureWithProofOfAge)) {
            $signatureOptions = count($this->getData('proofs_of_age')) === 1 ? '' :
                $this->renderOptions(Controls\Select::create()
                    ->setNameKey('proof_of_age')
                    ->setSourceKey('proofs_of_age'));
        }
        return sprintf('<div class="signature__holder"><div>%s</div>' .
            '<div id="signature-option-text">%s</div><div>%s</div></div>',
            $this->renderOptions(Controls\Select::create()
                ->setNameKey('signature')
                ->setSourceKey('signatures')),
            $optionsTitle, $signatureOptions);
    }

    public function renderContact() {
        return $this->renderStatic(sprintf('<a href="mailto:%s">%s</a> &middot; ' .
            '<a href="' . Author::BugReportUrl . '">%s</a>',
            Author::ContactEmail,
            Author::ContactEmail,
            $this->getExtensionName(),
            $this->getData('version'),
            'OpenCart ' . VersionChecker::get()->getVersion(),
            $this->getData('text_bugreport')));
    }

    public function renderMaintenance() {
        return $this->renderStatic(sprintf('<a href="%s">%s</a> &middot; <a id="import-settings">%s</a>',
            $this->getData('export_settings_link'),
            $this->getData('text_export_settings'),
            $this->getData('text_import_settings')));
    }

    public function renderForm($content) {
        return sprintf('<form id="upload" action="%s" method="POST" enctype="multipart/form-data">
                <input name="source" type="file" style="display: none">
                <div id="upload__cancel">&times;</div>
                <div id="upload__title">%s</div>
                <div class="upload__notice">
                    Are you sure you want to replace your settings with ones from this file?
                </div>
                <div class="upload__notice text-danger">
                    Warning: This operation may cause malfunction of the extension. This operation can not be undone.
                </div>
                <div id="upload__submit">
                    <input type="submit" value="Upload">
                </div>
            </form>
            <form action="%s" method="post" enctype="multipart/form-data" id="smart_flexible" class="form-horizontal">
            %s%s</form>',
            $this->getData('import_settings_link'),
            $this->getData('text_import_settings'),
            $this->getData('action'),
            $this->renderStores(),
            $content);
    }

    abstract protected function getContentGlobalCssClass();

    public function finallyRenderModuleSettings($content) {
        $cssClasses = array($this->getContentGlobalCssClass());
        return sprintf('%s<div id="content" class="%s">%s</div>%s',
            $this->getHeader(),
            implode(' ', $cssClasses),
            $this->renderSubHeader() . $content,
            $this->getFooter());
    }

    public function finallyRenderStandalonePage($content) {
        return sprintf('%s<html class="standalone-page"><head>%s%s</head><body>%s</body></html>',
            '<!DOCTYPE html>', '<meta charset="utf-8">',
            $this->getStyles() . $this->getjQuery() . $this->getScripts(), $content);
    }

    public function finallyRenderPackagingMap($data) {
        return <<<HTML
<!DOCTYPE html>
<html lang="en">
	<head>
		<title>Packing Map Visualisation</title>
		<meta charset="utf-8">
		<meta name="generator" content="Three.js Editor">
		<meta name="viewport" content="width=device-width, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">
		{$this->getThreeJs()}{$this->getjQuery()}{$this->getScripts()}{$this->getStyles()}
	</head>
	<body ontouchstart="" class="packaging-map">
	    <div id="description"></div>
		<script>
            var app = objSmartFlexible.getPackagingMapApplication();
            var player = new app.Player();
            if (player.load({$data['scene']})) {
                player.setSize(window.innerWidth, window.innerHeight);
                player.play();
                $('body').append(player.dom);
                $(window).on('resize', function() {
                    player.setSize(window.innerWidth, window.innerHeight);
                });
            }
        </script>
	</body>
</html>
HTML;
    }

    public function renderPackagingList($data) {
        $_this = $this;
        $manage = '';
        $method = '';
        $allLabelsLink = '';
        $content = '';
        if ($data['manage']) {
            $manage = sprintf('<div class="packaging-list__manage">%s</div>',
                implode("\n", array_map(function($manage) use ($_this) {
                    return sprintf('<li><img src="%s/%s"><a href="%s">%s</a></li>',
                        $_this->getImagesPath(), $manage['icon'], $manage['link'], $manage['title']);
                }, $data['manage'])));
        }
        if ($data['method_name'] && $data['service_name']) {
            $method .= sprintf('<h2 class="packaging-list__method">Shipping method: %s (%s)</h2>',
                $data['method_name'], $data['service_name']);
        }
        if (isset($data['request_all_link'])) {
            $allLabelsLink = sprintf('<button class="packaging-list__all-labels" ' .
                'onclick="objSmartFlexible.requestLabels(\'%s\', this);">Request all labels</button>',
                $data['request_all_link']);
        } elseif (isset($data['print_all_link'])) {
            $allLabelsLink = sprintf('<button class="packaging-list__all-labels" ' .
                'onclick="window.location=\'%s\';">Print all labels</button>',
                $data['print_all_link']);
        }
        foreach ($data['list'] as $box) {
            /** @var Shipment $shipment */
            $shipment = $box['shipment'];
            /** @var Locale $locale */
            $locale = $box['locale'];
            $dimensions = $shipment->getBox()->getOriginPackage()->getSizeDescription($box['locale']);
            $image = $shipment->getBox()->getOriginPackage()->getImage();
            $mapButton = $box['map_link'] ? sprintf(
                '<button class="packaging-list__box-map" onclick="window.location = \'%s\';">Packing Map</button>',
                $box['map_link']) : '';
            $tracking = '';
            $error = '';
            $success = '';
            $buttons = '';
            if ($shipment->getTrackingNumber()) {
                $tracking = sprintf('<input readonly="readonly" class="packaging-list__box-tracking" value="%s" />',
                    $shipment->getTrackingNumber());
            }
            $products = implode("\n", array_map(function($item, $itemId) use ($box, $locale) {
                /** @var OrderedBoxPackedItem $item */
                return sprintf('<li>%s &#215; %s <span>%s</span>%s</li>',
                    $item->getQuantity(),
                    $box['product_links'][$itemId] ?
                        sprintf('<a href="%s">%s</a>',
                            $box['product_links'][$itemId],
                            $item->getDescription())
                        : $item->getDescription(),
                    $locale->renderLargeWeight($item->getWeight(), true),
                    implode("\n", array_map(function($option) {
                        return sprintf('<br /><span>%s</span>', $option);
                    }, $item->getOptions()))
                );
            }, $shipment->getBox()->getProducts(), array_keys($shipment->getBox()->getProducts())));
            if ($shipment->getErrorMessage()) {
                $error = '<pre class="packaging-list__box-error">' . $shipment->getErrorMessage() . '</pre>';
            }
            if ($shipment->getSuccessMessage()) {
                $success = '<pre class="packaging-list__box-success">' . $shipment->getSuccessMessage() . '</pre>';
            }
            if ($box['request_link'] || $box['void_link'] || $box['documents']) {
                $requestButton = '';
                $documentButtons = '';
                $voidButton = '';
                if ($box['request_link']) {
                    $requestButton = sprintf('<button class="packaging-list__box-document" onclick="%s">%s</button>',
                        sprintf('objSmartFlexible.requestLabels(\'%s\', this);', $box['request_link']),
                        'Request Label');
                }
                if ($box['documents']) {
                    foreach ($box['documents'] as $document) {
                        if (count($document['links']) === 1) {
                            $documentButtons .= sprintf(
                                '<button class="packaging-list__box-document" onclick="%s">%s</button>',
                                sprintf('window.location = \'%s\';', $document['links'][0]),
                                $document['title']
                            );
                        } else {
                            $documentButtons .= '<div class="packaging-list__box-document-title">' .
                                '<div>' . $document['title'] . ' Pages</div>';
                            foreach ($document['links'] as $k => $link) {
                                $documentButtons .= sprintf(
                                    '<button class="packaging-list__box-document _page" onclick="%s">%s</button>',
                                    sprintf('window.location = \'%s\';', $link),
                                    $k + 1
                                );
                            }
                            $documentButtons .= '</div>';
                        }
                    }
                }
                if ($box['void_link']) {
                    $voidButton = sprintf(
                        '<button class="packaging-list__box-void" onclick="window.location = \'%s\';">' .
                        'Void Label</button>', $box['void_link']);
                }
                $buttons = sprintf('<div class="packaging-list__box-controls-holder">%s%s%s%s</div>',
                    $requestButton, $documentButtons, $voidButton, $mapButton);
            }
            $content .= sprintf('<div class="packaging-list__box">' .
                '<div class="packaging-list__box-image-holder">%s</div>' .
                '<div class="packaging-list__info-holder"><h3 class="packaging-list__box-heading">' .
                '<span class="packaging-list__box-title">%s</span>&#32;' .
                '<span class="packaging-list__box-dimensions-and-weight">%s%s</span></h3>' .
                '%s<ul class="packaging-list__box-content">%s</ul>%s%s</div>%s</div>',
                $image ? sprintf('<img src="%s/%s">', $this->getImagesPath(), $image) : '',
                $shipment->getBox()->getOriginPackage()->getTitle(),
                $dimensions ? $dimensions . ', ' : '',
                $locale->renderLargeWeight($shipment->getBox()->getWeight(), true),
                $tracking, $products, $success, $error, $buttons);
        }
        return sprintf('<div class="packaging-list__wrapper">%s' .
            '<h1 class="packaging-list__title">Packing List for Order &num;%s</h1>' .
            '<h2 class="packaging-list__store">Store: %s</h2>%s%s%s</div>',
            $manage, $data['order_id'], $data['store_name'], $method, $allLabelsLink, $content);
    }

    public function renderDocumentWrapper($data) {
        $save = sprintf('<button onclick="window.location = \'%s\'">Save</button>', $data['save_link']);
        if ($data['document_format'] === AccompanyingDocument::FormatPDF) {
            return sprintf('<div class="document-wrapper"><div class="document-wrapper__controls">' .
                '<button onclick="%s">Print</button>%s</div>' .
                '<iframe id="document" class="document-wrapper__document" src="%s"></iframe></div>',
                'objSmartFlexible.printFrame(\'document\', \'' . $data['document_link'] . '\');',
                $save, $data['document_link']);
        } else {
            return sprintf('<div class="document-wrapper__controls _absolute">' .
                '<button onclick="%s">Print</button>%s</div>' .
                '<div id="document" class="document-wrapper__document _absolute"><img src="%s"></div>' .
                '<script>$(function(){objSmartFlexible.fixDocumentHeight();});</script>',
                'window.print();', $save, $data['document_link']);
        }
    }

    /**
     * @param string[] $keys
     * @return string html
     */
    protected function renderSharedSettingControl($keys) {
        if ($this->getData('is_shared_settings_extension_installed')) {
            if (Arrays::containsAllOf($keys, $this->getData('shareable_settings'))) {
                $allSharedKeys = $this->getValue('shared_settings');
                $areShared = array_reduce($keys, function($carry, $key) use ($allSharedKeys) {
                    return $carry && (isset($allSharedKeys[$key]) ? $allSharedKeys[$key] : false);
                }, true);
                $inputs = array();
                foreach ($keys as $key) {
                    $inputs[] = sprintf('<input type="hidden" name="%s" value="%s" />',
                        $this->getPrefixedName('shared_settings') . '[' . $key . ']',
                        $areShared ? 1 : 0);
                }
                return sprintf('<div class="shared-setting%s" data-keys=\'%s\'>' .
                    '<a href="javascript:void(0)"></a>%s' .
                    '<div class="shared-setting__confirm _hidden"></div></div>',
                    $areShared ? ' _shared' : '', Json::encode($keys), implode('', $inputs));
            }
        } else {
            return sprintf('<div class="%s">Shareable by &quot;Shared Settings Smart & Flexible&quot;</div>',
                $this->getHelpCssClass());
        }
        return '';
    }

    public function renderPacker() {
        $dropdown = $this->renderSelect(Controls\Select::create()
            ->setNameKey('packer')
            ->setSourceKey('packers'));
        $checkbox = $this->renderCheckbox(Controls\Input::create()
            ->setNameKey('fallback_packer')
            ->setIsChecked($this->getValue('fallback_packer') === Configuration::PackerIndividual)
            ->setCaption($this->getData('entry_fallback_packer')));
        return sprintf('%s<br>%s', $dropdown, $checkbox);
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

class ViewBuilderV1 extends ViewBuilder {
    /**
     * This method builds dropdown controlled by JS
     * Active item value will be taken by key WITHOUT prefix
     * @param Controls\Select $select
     * @return string
     */
    public function renderJsDropdown(Controls\Select $select) {
        $value = $this->getData($select->getNameKey());
        $source = $this->getData($select->getSourceKey());
        $items = array();
        if (is_array($source)) {
            foreach ($source as $item) {
                $isActive = (string)$value === (string)$item[$select->getValueField()];
                $items[] = sprintf('<option value="%s" %s>%s</option>',
                    $item[$select->getValueField()],
                    $isActive ? 'selected' : '',
                    $item[$select->getCaptionField()]);
            }
        }
        return sprintf('<select class="form-control %s">%s</select>',
            $select->getCssClass(),
            implode('', $items));
    }

    protected function renderBreadcrumbs() {
        $crumbs = array_map(function($breadcrumb) {
            return sprintf('%s<a href="%s">%s</a>', $breadcrumb['separator'], $breadcrumb['href'], $breadcrumb['text']);
        }, $this->getData('breadcrumbs'));
        return sprintf('<div class="breadcrumb">%s</div>', implode("\n", $crumbs));
    }

    protected function renderHeadingNotice() {
        if ($this->getData('error_warning')) {
            return sprintf('<div class="warning">%s</div>', $this->getData('error_warning'));
        } elseif ($this->getData('success')) {
            return sprintf('<div class="success">%s</div>', $this->getData('success'));
        }
        return '';
    }

    protected function renderDemo() {
        if ($this->data['is_demo_mode']) {
            return sprintf('<div class="attention"><div><strong>%s</strong></div><div>%s</div></div>',
                $this->getData('demo_title'), $this->getData('demo_info'));
        }
        return '';
    }

    protected function renderLicense() {
        if (!isset($_COOKIE[$this->getData('license_cookie')]) && !$this->data['is_demo_mode']) {
            return sprintf('<div id="license" class="attention" style="background-image: %s;"><div>' .
                '<strong>%s</strong></div><div>%s</div><div class="license__controls">' .
                '<a class="button" href="%s">%s</a>' .
                '<a class="button" onclick="objSmartFlexible.licenseClose();">%s</a></div></div>',
                $this->getLicenseLogo(), $this->getData('license_title'), $this->getData('license_info'),
                Author::PersonalAreaUrl, $this->getData('license_buy'), $this->getData('license_close'));
        }
        return '';
    }

    protected function renderSubHeader() {
        return $this->renderBreadcrumbs() .
            $this->renderHeadingNotice() .
            $this->renderDemo() .
            $this->renderLicense() .
            $this->getScripts() .
            $this->getStyles();
    }

    public function renderContainer($content) {
        $buttons = $this->isSimpleView() ? '' : sprintf('<div class="buttons">' .
            '<a onclick="$(\'#smart_flexible\').submit();" class="button">%s</a>' .
            '<a href="%s" class="button">%s</a></div>',
            $this->getData('button_save'),
            $this->getData('cancel'),
            $this->getData('button_cancel'));
        return sprintf('<div class="box"><div class="heading">' .
            '<h1><img src="view/image/shipping.png" alt="" /> %s</h1>%s' .
            '</div><div class="content">%s</div></div>',
            $this->getData('heading_title'),
            $buttons,
            $content
        );
    }

    protected function renderTab(Controls\Tab $tab) {
        return sprintf('<div id="%s" class="tab-pane"><table class="form">%s</table></div>',
            $tab->getId(), $tab->getContent());
    }

    public function renderTabs($tabs = array()) {
        $tabsHeaders = array();
        $tabsContent = array();
        foreach ($tabs as $tab) {
            if ($tab) {
                /** @var Controls\Tab $tab */
                $tabsHeaders[] = sprintf('<a href="#%s">%s</a>', $tab->getId(), $this->getData($tab->getTitleKey()));
                $tabsContent[] = $this->renderTab($tab);
            }
        }
        return sprintf('<div id="tabs" class="htabs">%s</div>%s',
            implode("\n", $tabsHeaders), implode("\n", $tabsContent));
    }

    /**
     * @param string $titleKey
     * @param string $helpKey
     * @param string $errorKey
     * @param bool $isRequired
     * @param string $content
     * @param null|array $sharedKeys
     * @return string
     */
    public function renderSetting($titleKey, $helpKey, $errorKey, $isRequired, $content, $sharedKeys = null) {
        $requiredHtml = $isRequired ? '<span class="required">*</span> ' : '';
        return sprintf('<tr><td valign="top"><p>%s%s</p><div class="%s">%s</div>%s</td><td>%s%s</td></tr>',
            $requiredHtml,
            $this->getData($titleKey),
            $this->getHelpCssClass(),
            $this->getData($helpKey),
            $sharedKeys ? $this->renderSharedSettingControl($sharedKeys) : '',
            $content,
            $this->renderError($errorKey));
    }

    protected function renderError($key) {
        if ($this->getData($key)) {
            return sprintf('<span class="error">%s</span>', $this->getData($key));
        }
        return '';
    }

    /**
     * @param bool $isForServices
     * @return string
     */
    protected function getTableCssClass($isForServices = false) {
        return $isForServices ? 'form' : 'list';
    }

    /**
     * @return string
     */
    protected function getCenterCssClass() {
        return 'center';
    }

    /**
     * @return string
     */
    protected function getHelpCssClass() {
        return 'help';
    }

    /**
     * Returns global header
     * @return string
     */
    protected function getHeader() {
        return $this->getData('header');
    }

    /**
     * @return string
     */
    protected function getInitMethod() {
        return 'initForVersion1';
    }

    /**
     * @return bool
     */
    protected function isInputAddonRequiresSpacing() {
        return true;
    }

    /**
     * @return string
     */
    protected function getContentGlobalCssClass() {
        return '_v1';
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

class ViewBuilderV2 extends ViewBuilder {
    /**
     * This method builds dropdown controlled by JS
     * Active item value will be taken by key WITHOUT prefix
     * @param Controls\Select $select
     * @return string
     */
    public function renderJsDropdown(Controls\Select $select) {
        $value = $this->getData($select->getNameKey());
        $source = $this->getData($select->getSourceKey());
        $caption = '';
        $items = array();
        if (is_array($source)) {
            foreach ($source as $item) {
                $isActive = (string)$value === (string)$item[$select->getValueField()];
                $items[] = sprintf('<li class="%s"><a href="#" data-value="%s">%s</a></li>',
                    $isActive ? 'active' : '',
                    $item[$select->getValueField()],
                    $item[$select->getCaptionField()]);
                if ($isActive) {
                    $caption = $item[$select->getCaptionField()];
                }
            }
        }
        return sprintf('<div class="btn-group">' .
            '<button class="btn %s dropdown-toggle" type="button" data-toggle="dropdown">' .
            '%s <span class="caret"></span></button><ul class="dropdown-menu">%s</ul></div>',
            $select->getCssClass() ?: 'btn-default',
            $caption,
            implode('', $items));
    }

    protected function renderBreadcrumbs() {
        $crumbs = array_map(function($breadcrumb) {
            return sprintf('<li><a href="%s">%s</a></li>', $breadcrumb['href'], $breadcrumb['text']);
        }, $this->getData('breadcrumbs'));
        return sprintf('<ul class="breadcrumb">%s</ul>', implode("\n", $crumbs));
    }

    protected function renderHeadingNotice() {
        if ($this->getData('error_warning')) {
            return sprintf('<div class="alert alert-danger" role="alert">%s</div>', $this->getData('error_warning'));
        } elseif ($this->getData('success')) {
            return sprintf('<div class="alert alert-success" role="alert">%s</div>', $this->getData('success'));
        }
        return '';
    }

    protected function renderDemo() {
        if ($this->data['is_demo_mode']) {
            return sprintf('<div class="row"><div class="col-xs-6 col-xs-offset-3"><div class="panel panel-warning">' .
                '<div class="panel-heading"><strong>%s</strong></div><div class="panel-body">%s</div>' .
                '</div></div></div>',
                $this->getData('demo_title'), $this->getData('demo_info'));
        }
        return '';
    }

    protected function renderLicense() {
        if (!isset($_COOKIE[$this->getData('license_cookie')]) && !$this->data['is_demo_mode']) {
            return sprintf('<div id="license" class="row"><div class="col-xs-6 col-xs-offset-3">' .
                '<div class="panel panel-info"><div class="panel-heading" ' .
                'style="background-image: %s;"><strong>%s</strong></div>' .
                '<div class="panel-body"><div>%s</div><div class="license__controls">' .
                '<a class="btn btn-primary" href="%s">%s</a>' .
                '<a class="btn btn-default" onclick="objSmartFlexible.licenseClose();">%s</a></div></div>' .
                '</div></div></div>',
                $this->getLicenseLogo(), $this->getData('license_title'), $this->getData('license_info'),
                Author::PersonalAreaUrl, $this->getData('license_buy'), $this->getData('license_close'));
        }
        return '';
    }

    protected function renderSubHeader() {
        $buttons = $this->isSimpleView() ? '' : sprintf('<div class="pull-right pad-bottom-sm">' .
            '<a onclick="$(\'#smart_flexible\').submit();" class="btn btn-primary">' .
            '<i class="fa fa-floppy-o pad-right-sm"></i> %s</a>' .
            '<a href="%s" class="btn btn-default"><i class="fa fa-reply pad-right-sm"></i> %s</a> ' .
            '</div>',
            $this->getData('button_save'),
            $this->getData('cancel'),
            $this->getData('button_cancel'));
        return sprintf('<div class="page-header"><div class="container-fluid">%s' .
            '<h1 class="panel-title">%s</h1>%s</div></div>%s',
            $buttons,
            $this->getData('heading_title'),
            $this->renderBreadcrumbs(),
            $this->renderHeadingNotice() .
            $this->renderDemo() .
            $this->renderLicense() .
            $this->getScripts() .
            $this->getStyles());
    }

    public function renderContainer($content) {
        return sprintf('<div class="container-fluid">%s</div>', $content);
    }

    protected function renderTab(Controls\Tab $tab) {
        $defaultClass = $tab->getIsDefault() ? ' active' : '';
        return sprintf('<div id="%s" class="tab-pane%s">%s</div>', $tab->getId(), $defaultClass, $tab->getContent());
    }

    public function renderTabs($tabs = array()) {
        $tabsHeaders = array();
        $tabsContent = array();
        foreach ($tabs as $tab) {
            if ($tab) {
                /** @var Controls\Tab $tab */
                $tabsHeaders[] = sprintf('<li role="presentation"%s>' .
                    '<a href="#%s" role="tab" data-toggle="tab">%s</a></li>',
                    $tab->getIsDefault() ? ' class="active"' : '',
                    $tab->getId(),
                    $this->getData($tab->getTitleKey()));
                $tabsContent[] = $this->renderTab($tab);
            }
        }
        return sprintf('<ul class="nav nav-tabs" role="tablist">%s</ul><div class="tab-content">%s</div>',
            implode("\n", $tabsHeaders), implode("\n", $tabsContent));
    }

    /**
     * @param string $titleKey
     * @param string $helpKey
     * @param string $errorKey
     * @param bool $isRequired
     * @param string $content
     * @param null|array $sharedKeys
     * @return string
     */
    public function renderSetting($titleKey, $helpKey, $errorKey, $isRequired, $content, $sharedKeys = null) {
        $requiredClass = $isRequired ? ' text-warning' : '';
        return sprintf('<div class="form-group"><div class="col-sm-4"><label class="control-label%s">%s</label>' .
            '<div class="%s">%s</div>%s</div><div class="col-sm-8">%s%s</div></div>',
            $requiredClass,
            $this->getData($titleKey),
            $this->getHelpCssClass(),
            $this->getData($helpKey),
            $sharedKeys ? $this->renderSharedSettingControl($sharedKeys) : '',
            $content,
            $this->renderError($errorKey));
    }

    protected function renderError($key) {
        if ($this->getData($key)) {
            return sprintf('<p class="text-danger">%s</p>', $this->getData($key));
        }
        return '';
    }

    /**
     * @param bool $isForServices
     * @return string
     */
    protected function getTableCssClass($isForServices = false) {
        return 'table';
    }

    /**
     * @return string
     */
    protected function getCenterCssClass() {
        return 'text-center';
    }

    /**
     * @return string
     */
    protected function getHelpCssClass() {
        return 'help-block';
    }

    /**
     * Returns global header
     * @return string
     */
    protected function getHeader() {
        return $this->getData('header') . $this->getData('column_left');
    }

    /**
     * @return string
     */
    protected function getInitMethod() {
        return 'initForVersion2';
    }

    /**
     * @return bool
     */
    protected function isInputAddonRequiresSpacing() {
        return false;
    }

    /**
     * @return string
     */
    protected function getContentGlobalCssClass() {
        return '_v2';
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

class ViewBuilderV3 extends ViewBuilderV2 {
    // same

    /**
     * @return string
     */
    protected function getInitMethod() {
        return 'initForVersion3';
    }

    /**
     * @return string
     */
    protected function getContentGlobalCssClass() {
        return '_v3';
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

class ViewLoader {
    /**
     * Required $data fields to be Callable
     * @var array
     */
    private static $requiredCallablesSimple = array('get_extension_name');
    private static $requiredCallables = array(
        'get_prefixed_name',
        'get_extension_name',
        'has_feature',
        'get_current_route'
    );

    private static function isSimpleView($data) {
        return isset($data['is_simple']) && $data['is_simple'];
    }

    /**
     * Returns ViewBuilder depending on engine version
     * @param array $data
     * @throws \Exception
     * @return ViewBuilderV1|ViewBuilderV2|ViewBuilderV3
     */
    public static function getViewBuilder($data) {
        foreach (self::isSimpleView($data) ? self::$requiredCallablesSimple : self::$requiredCallables as $field) {
            if (!isset($data[$field])) {
                throw new \Exception('Field ' . $field . ' is not defined for ViewLoader');
            }
            if (!is_callable($data[$field])) {
                throw new \Exception('Field ' . $field . ' is not callable (ViewLoader)');
            }
        }
        $versionChecker = VersionChecker::get();
        if ($versionChecker->isVersion1()) {
            return new ViewBuilderV1($data);
        } elseif ($versionChecker->isVersion2()) {
            return new ViewBuilderV2($data);
        } elseif ($versionChecker->isVersion3()) {
            return new ViewBuilderV3($data);
        } else {
            throw new \Exception('Can not load proper view builder (ViewLoader)');
        }
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

class Author {
    const Title = 'Drugoe';

    const ContactEmail = 'support@drugoe.de';

    const WebsiteUrl = 'https://drugoe.de/';

    const LicenseUrl = 'https://drugoe.de/kb/license';

    const PersonalAreaUrl = 'https://drugoe.de/personal';

    const LogoUrl = 'https://drugoe.de/logo/%s/%s/logo.png';

    const BugReportUrl = 'https://drugoe.de/bug/%s/%s/%s';

    const FaqUrl = 'https://drugoe.de/kb/faq';
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

class Json {
    /**
     * @param mixed $data
     * @return string
     */
    public static function encode($data) {
        return json_encode($data);
    }

    /**
     * @param mixed $data
     * @return string
     */
    public static function encodePretty($data) {
        return json_encode($data, defined('JSON_PRETTY_PRINT') ? JSON_PRETTY_PRINT : 0);
    }

    /**
     * @param mixed $input
     * @return bool|null|object
     */
    public static function decodeAsObject($input) {
        return json_decode($input);
    }

    /**
     * @param mixed $input
     * @return bool|null|array
     */
    public static function decodeAsArray($input) {
        return json_decode($input, true);
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\ShippingController;

class SimpleController extends \Controller {
    /** @var SimpleModule */
    protected $module;

    /**
     * @param mixed $registry
     * @param SimpleModule $module
     */
    public function __construct($registry, $module) {
        parent::__construct($registry);
        $this->module = $module;
    }

    public static function getTokenName() {
        return VersionChecker::get()->isVersion3() ? 'user_token' : 'token';
    }

    public function getCurrentRoute() {
        return $this->request->get['route'];
    }

    public function link($path, $args = '') {
        return $this->url->link(
            $path, SimpleController::getTokenName() . '=' . $this->session->data[SimpleController::getTokenName()] .
            '&' . $args, VersionChecker::get()->isVersion1() ? 'SSL' : true
        );
    }

    public function getParentRoute() {
        return implode('/', array_slice(explode('/', $this->getCurrentRoute()), 0, -1));
    }

    public function getFrontUrl() {
        return isset($this->request->server['HTTPS']) ?
            ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) : HTTP_CATALOG;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

abstract class SimpleModule {
    /** Extension Version Number */
    const Version = '6.20.7';

    /**
     * Switches extension to demo mode
     * Hides User ID setting in Admin View
     * Prevents settings update
     */
    const isDemoMode = false;

    /**
     * @return string
     */
    public function getVersion() {
        return self::Version;
    }

    /**
     * @return string
     */
    public function getContactEmail() {
        return Author::ContactEmail;
    }

    /**
     * @return bool
     */
    public function getIsDemoMode() {
        return self::isDemoMode;
    }

    /** @return string */
    abstract public function getExtensionName();
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Controls\Tab;

class SimpleView {
    public static function render($data) {
        $data['is_simple'] = true;
        $viewBuilder = ViewLoader::getViewBuilder($data);
        $html = $viewBuilder->renderStatic($data['text_content']);
        $html .= $viewBuilder->renderSetting('entry_version', '', '', false,
            $viewBuilder->renderStatic($data['version']));
        $html .= $viewBuilder->renderSetting('entry_contact', '', '', false, $viewBuilder->renderContact());
        $tab = Tab::create()
            ->setId('tab-ext-general')
            ->setTitleKey('tab_general')
            ->setIsDefault(true)
            ->setContent($html);
        $form = $viewBuilder->renderForm($viewBuilder->renderTabs(array($tab)));
        $container = $viewBuilder->renderContainer($form);
        return $viewBuilder->finallyRenderModuleSettings($container);
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log {

/**
 * Describes a logger instance.
 *
 * The message MUST be a string or object implementing __toString().
 *
 * The message MAY contain placeholders in the form: {foo} where foo
 * will be replaced by the context data in key "foo".
 *
 * The context array can contain arbitrary data. The only assumption that
 * can be made by implementors is that if an Exception instance is given
 * to produce a stack trace, it MUST be in a key named "exception".
 *
 * See https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-3-logger-interface.md
 * for the full interface specification.
 */
interface LoggerInterface
{
    /**
     * System is unusable.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function emergency($message, array $context = array());

    /**
     * Action must be taken immediately.
     *
     * Example: Entire website down, database unavailable, etc. This should
     * trigger the SMS alerts and wake you up.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function alert($message, array $context = array());

    /**
     * Critical conditions.
     *
     * Example: Application component unavailable, unexpected exception.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function critical($message, array $context = array());

    /**
     * Runtime errors that do not require immediate action but should typically
     * be logged and monitored.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function error($message, array $context = array());

    /**
     * Exceptional occurrences that are not errors.
     *
     * Example: Use of deprecated APIs, poor use of an API, undesirable things
     * that are not necessarily wrong.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function warning($message, array $context = array());

    /**
     * Normal but significant events.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function notice($message, array $context = array());

    /**
     * Interesting events.
     *
     * Example: User logs in, SQL logs.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function info($message, array $context = array());

    /**
     * Detailed debug information.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function debug($message, array $context = array());

    /**
     * Logs with an arbitrary level.
     *
     * @param mixed  $level
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function log($level, $message, array $context = array());
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log {

/**
 * Describes a logger-aware instance.
 */
interface LoggerAwareInterface
{
    /**
     * Sets a logger instance on the object.
     *
     * @param LoggerInterface $logger
     *
     * @return null
     */
    public function setLogger(LoggerInterface $logger);
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log {

/**
 * This is a simple Logger implementation that other Loggers can inherit from.
 *
 * It simply delegates all log-level-specific methods to the `log` method to
 * reduce boilerplate code that a simple Logger that does the same thing with
 * messages regardless of the error level has to implement.
 */
abstract class AbstractLogger implements LoggerInterface
{
    /**
     * System is unusable.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function emergency($message, array $context = array())
    {
        $this->log(LogLevel::EMERGENCY, $message, $context);
    }

    /**
     * Action must be taken immediately.
     *
     * Example: Entire website down, database unavailable, etc. This should
     * trigger the SMS alerts and wake you up.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function alert($message, array $context = array())
    {
        $this->log(LogLevel::ALERT, $message, $context);
    }

    /**
     * Critical conditions.
     *
     * Example: Application component unavailable, unexpected exception.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function critical($message, array $context = array())
    {
        $this->log(LogLevel::CRITICAL, $message, $context);
    }

    /**
     * Runtime errors that do not require immediate action but should typically
     * be logged and monitored.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function error($message, array $context = array())
    {
        $this->log(LogLevel::ERROR, $message, $context);
    }

    /**
     * Exceptional occurrences that are not errors.
     *
     * Example: Use of deprecated APIs, poor use of an API, undesirable things
     * that are not necessarily wrong.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function warning($message, array $context = array())
    {
        $this->log(LogLevel::WARNING, $message, $context);
    }

    /**
     * Normal but significant events.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function notice($message, array $context = array())
    {
        $this->log(LogLevel::NOTICE, $message, $context);
    }

    /**
     * Interesting events.
     *
     * Example: User logs in, SQL logs.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function info($message, array $context = array())
    {
        $this->log(LogLevel::INFO, $message, $context);
    }

    /**
     * Detailed debug information.
     *
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function debug($message, array $context = array())
    {
        $this->log(LogLevel::DEBUG, $message, $context);
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log {

/**
 * This Logger can be used to avoid conditional log calls.
 *
 * Logging should always be optional, and if no logger is provided to your
 * library creating a NullLogger instance to have something to throw logs at
 * is a good way to avoid littering your code with `if ($this->logger) { }`
 * blocks.
 */
class NullLogger extends AbstractLogger
{
    /**
     * Logs with an arbitrary level.
     *
     * @param mixed  $level
     * @param string $message
     * @param array  $context
     *
     * @return null
     */
    public function log($level, $message, array $context = array())
    {
        // noop
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log {

/**
 * Describes log levels.
 */
class LogLevel
{
    const EMERGENCY = 'emergency';
    const ALERT     = 'alert';
    const CRITICAL  = 'critical';
    const ERROR     = 'error';
    const WARNING   = 'warning';
    const NOTICE    = 'notice';
    const INFO      = 'info';
    const DEBUG     = 'debug';
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\PackagingMap {

class Map {
    /** @var string */
    protected $packer;
    /** @var Reserved[] */
    protected $reserved;

    /**
     * @param $packer
     * @param Reserved[] $reserved
     */
    public function __construct($packer, $reserved) {
        $this->packer = $packer;
        $this->reserved = $reserved;
    }

    /**
     * @return Reserved[]
     */
    public function getReservedSpace() {
        return $this->reserved;
    }

    /**
     * @param array $data
     * @return Map
     */
    public static function createFromArray($data) {
        $reserved = array_map(function($row) {
            return new Reserved(
                $row['offset_length'], $row['offset_width'], $row['offset_height'],
                $row['length'], $row['width'], $row['height'], $row['description']
            );
        }, $data['reserved']);
        return new self($data['packer'], $reserved);
    }

    /**
     * @return array
     */
    public function toArray() {
        return array(
            'packer' => $this->packer,
            'reserved' => array_map(function($reserved) {
                /** @var Reserved $reserved */
                return array(
                    'offset_length' => $reserved->getOffsetLength(),
                    'offset_width' => $reserved->getOffsetWidth(),
                    'offset_height' => $reserved->getOffsetHeight(),
                    'length' => $reserved->getLength(),
                    'width' => $reserved->getWidth(),
                    'height' => $reserved->getHeight(),
                    'description' => $reserved->getDescription()
                );
            }, $this->reserved)
        );
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\PackagingMap {

class Reserved {
    /** @var float */
    protected $offsetLength;
    /** @var float */
    protected $offsetWidth;
    /** @var float */
    protected $offsetHeight;
    /** @var float */
    protected $length;
    /** @var float */
    protected $width;
    /** @var float */
    protected $height;
    /** @var string */
    protected $description;

    public function __construct($offsetLength, $offsetWidth, $offsetHeight, $length, $width, $height, $description) {
        $this->offsetLength = $offsetLength;
        $this->offsetWidth = $offsetWidth;
        $this->offsetHeight = $offsetHeight;
        $this->length = $length;
        $this->width = $width;
        $this->height = $height;
        $this->description = $description;
    }

    /**
     * @return string
     */
    public function getDescription() {
        return $this->description;
    }

    /**
     * @return float
     */
    public function getHeight() {
        return $this->height;
    }

    /**
     * @return float
     */
    public function getLength() {
        return $this->length;
    }

    /**
     * @return float
     */
    public function getOffsetHeight() {
        return $this->offsetHeight;
    }

    /**
     * @return float
     */
    public function getOffsetLength() {
        return $this->offsetLength;
    }

    /**
     * @return float
     */
    public function getOffsetWidth() {
        return $this->offsetWidth;
    }

    /**
     * @return float
     */
    public function getWidth() {
        return $this->width;
    }


}
}

/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

/**
 * An item to be packed
 * @author Doug Wright
 * @package BoxPacker
 */
interface Item
{

    /**
     * Item SKU etc
     * @return string
     */
    public function getDescription();

    /**
     * Item width in mm
     * @return int
     */
    public function getWidth();

    /**
     * Item length in mm
     * @return int
     */
    public function getLength();

    /**
     * Item depth in mm
     * @return int
     */
    public function getDepth();

    /**
     * Item weight in g
     * @return int
     */
    public function getWeight();

    /**
     * Item volume in mm^3
     * @return int
     */
    public function getVolume();

    /**
     * Does this item need to be kept flat / packed "this way up"?
     * @return bool
     */
    public function getKeepFlat();

}

}

/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

/**
 * An item to be packed where additional constraints need to be considered. Only implement this interface if you actually
 * need this additional functionality as it will slow down the packing algorithm
 * @author Doug Wright
 * @package BoxPacker
 */
interface ConstrainedItem extends Item
{

    /**
     * Hook for user implementation of item-specific constraints, e.g. max <x> batteries per box
     *
     * @param ItemList $alreadyPackedItems
     * @param Box      $box
     *
     * @return bool
     */
    public function canBePackedInBox(ItemList $alreadyPackedItems, Box $box);

}

}

/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

/**
 * List of items to be packed, ordered by volume
 * @author Doug Wright
 * @package BoxPacker
 */
class ItemList extends \SplMaxHeap
{

    /**
     * Compare elements in order to place them correctly in the heap while sifting up.
     * @see \SplMaxHeap::compare()
     */
    public function compare($itemA, $itemB)
    {
        if ($itemA->getVolume() > $itemB->getVolume()) {
            return 1;
        } elseif ($itemA->getVolume() < $itemB->getVolume()) {
            return -1;
        } else {
            return $itemA->getWeight() - $itemB->getWeight();
        }
    }

    /**
     * Get copy of this list as a standard PHP array
     * @return array
     */
    public function asArray()
    {
        $return = array();
        foreach (clone $this as $item) {
            $return[] = $item;
        }
        return $return;
    }
}
}

/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

/**
 * A "box" (or envelope?) to pack items into
 * @author Doug Wright
 * @package BoxPacker
 */
interface Box
{

    /**
     * Reference for box type (e.g. SKU or description)
     * @return string
     */
    public function getReference();

    /**
     * Outer width in mm
     * @return int
     */
    public function getOuterWidth();

    /**
     * Outer length in mm
     * @return int
     */
    public function getOuterLength();

    /**
     * Outer depth in mm
     * @return int
     */
    public function getOuterDepth();

    /**
     * Empty weight in g
     * @return int
     */
    public function getEmptyWeight();

    /**
     * Inner width in mm
     * @return int
     */
    public function getInnerWidth();

    /**
     * Inner length in mm
     * @return int
     */
    public function getInnerLength();

    /**
     * Inner depth in mm
     * @return int
     */
    public function getInnerDepth();

    /**
     * Total inner volume of packing in mm^3
     * @return int
     */
    public function getInnerVolume();

    /**
     * Max weight the packaging can hold in g
     * @return int
     */
    public function getMaxWeight();
}
}

/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

/**
 * List of boxes available to put items into, ordered by volume
 * @author Doug Wright
 * @package BoxPacker
 */
class BoxList extends \SplMinHeap
{
    /**
     * Compare elements in order to place them correctly in the heap while sifting up.
     * @see \SplMinHeap::compare()
     */
    public function compare($boxA, $boxB)
    {
        if ($boxB->getInnerVolume() > $boxA->getInnerVolume()) {
            return 1;
        } elseif ($boxB->getInnerVolume() < $boxA->getInnerVolume()) {
            return -1;
        } else {
            return 0;
        }
    }
}
}

/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\PackagingMap\Map;

/**
 * A "box" with items
 * @author Doug Wright
 * @package BoxPacker
 */
class PackedBox
{

    /**
     * Box used
     * @var Box
     */
    protected $box;

    /**
     * Items in the box
     * @var ItemList
     */
    protected $items;

    /** @var Map|null */
    protected $_packagingMap;

    /**
     * Total weight of box
     * @var int
     */
    protected $weight;

    /**
     * Remaining width inside box for another item
     * @var int
     */
    protected $remainingWidth;

    /**
     * Remaining length inside box for another item
     * @var int
     */
    protected $remainingLength;

    /**
     * Remaining depth inside box for another item
     * @var int
     */
    protected $remainingDepth;

    /**
     * Remaining weight inside box for another item
     * @var int
     */
    protected $remainingWeight;

    /**
     * Used width inside box for packing items
     * @var int
     */
    protected $usedWidth;

    /**
     * Used length inside box for packing items
     * @var int
     */
    protected $usedLength;

    /**
     * Used depth inside box for packing items
     * @var int
     */
    protected $usedDepth;

    /**
     * Get box used
     * @return Box
     */
    public function getBox()
    {
        return $this->box;
    }

    /**
     * Get items packed
     * @return ItemList
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * Get packed weight
     * @return int weight in grams
     */
    public function getWeight()
    {

        if (!is_null($this->weight)) {
            return $this->weight;
        }

        $this->weight = $this->box->getEmptyWeight();
        $items = clone $this->items;
        foreach ($items as $item) {
            $this->weight += $item->getWeight();
        }
        return $this->weight;
    }

    /**
     * Get remaining width inside box for another item
     * @return int
     */
    public function getRemainingWidth()
    {
        return $this->remainingWidth;
    }

    /**
     * Get remaining length inside box for another item
     * @return int
     */
    public function getRemainingLength()
    {
        return $this->remainingLength;
    }

    /**
     * Get remaining depth inside box for another item
     * @return int
     */
    public function getRemainingDepth()
    {
        return $this->remainingDepth;
    }

    /**
     * Used width inside box for packing items
     * @return int
     */
    public function getUsedWidth()
    {
        return $this->usedWidth;
    }

    /**
     * Used length inside box for packing items
     * @return int
     */
    public function getUsedLength()
    {
        return $this->usedLength;
    }

    /**
     * Used depth inside box for packing items
     * @return int
     */
    public function getUsedDepth()
    {
        return $this->usedDepth;
    }

    /**
     * Get remaining weight inside box for another item
     * @return int
     */
    public function getRemainingWeight()
    {
        return $this->remainingWeight;
    }

    /**
     * Get volume utilisation of the packed box
     * @return float
     */
    public function getVolumeUtilisation()
    {
        $itemVolume = 0;

        /** @var Item $item */
        foreach (clone $this->items as $item) {
            $itemVolume += $item->getVolume();
        }

        return round($itemVolume / $this->box->getInnerVolume() * 100, 1);
    }

    /**
     * @return null|Map
     */
    public function getPackagingMap() {
        return $this->_packagingMap;
    }

    /**
     * Constructor
     *
     * @param Box      $box
     * @param ItemList $itemList
     * @param int      $remainingWidth
     * @param int      $remainingLength
     * @param int      $remainingDepth
     * @param int      $remainingWeight
     * @param int      $usedWidth
     * @param int      $usedLength
     * @param int      $usedDepth
     * @param Map      $packagingMap
     */
    public function __construct(
        Box $box,
        ItemList $itemList,
        $remainingWidth,
        $remainingLength,
        $remainingDepth,
        $remainingWeight,
        $usedWidth,
        $usedLength,
        $usedDepth,
        $packagingMap
    )
    {
        $this->box = $box;
        $this->items = $itemList;
        $this->remainingWidth = $remainingWidth;
        $this->remainingLength = $remainingLength;
        $this->remainingDepth = $remainingDepth;
        $this->remainingWeight = $remainingWeight;
        $this->usedWidth = $usedWidth;
        $this->usedLength = $usedLength;
        $this->usedDepth = $usedDepth;
        $this->_packagingMap = $packagingMap;
    }

    /**
     * This method is similar to the one introduced in v2.4.0
     * @since 17.06.2020 it calculates remaining volume and weight correctly
     * @param Box $box
     * @param ItemList $itemList
     * @param Map $map
     * @param null|float $remainingWeight
     * @return PackedBox
     */
    public static function fromPackingMap(Box $box, ItemList $itemList, Map $map, $remainingWeight = null) {
        $maxWidth = $maxLength = $maxDepth = $weight = 0;
        foreach ($map->getReservedSpace() as $reserved) {
            $maxWidth = max($maxWidth, $reserved->getOffsetWidth() + $reserved->getWidth());
            $maxLength = max($maxLength, $reserved->getOffsetLength() + $reserved->getLength());
            $maxDepth = max($maxDepth, $reserved->getOffsetHeight() + $reserved->getHeight());
        }
        if (!$remainingWeight) {
            foreach (clone $itemList as $item) {
                /** @var Item $item */
                $weight += $item->getWeight();
            }
            $remainingWeight = $box->getMaxWeight() - $box->getEmptyWeight() - $weight;
        }
        return new self(
            $box, $itemList,
            $box->getInnerWidth() - $maxWidth,
            $box->getInnerLength() - $maxLength,
            $box->getInnerDepth() - $maxDepth,
            $remainingWeight, $maxWidth, $maxLength, $maxDepth, $map
        );
    }
}
}

/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

/**
 * List of possible packed box choices, ordered by utilisation (item count, volume)
 * @author Doug Wright
 * @package BoxPacker
 */
class PackedBoxList extends \SplMinHeap
{

    /**
     * Average (mean) weight of boxes
     * @var float
     */
    protected $meanWeight;

    /**
     * Compare elements in order to place them correctly in the heap while sifting up.
     * @see \SplMinHeap::compare()
     */
    public function compare($boxA, $boxB)
    {
        $choice = $boxA->getItems()->count() - $boxB->getItems()->count();
        if ($choice === 0) {
            $choice = $boxB->getBox()->getInnerVolume() - $boxA->getBox()->getInnerVolume();
        }
        if ($choice === 0) {
            $choice = $boxA->getWeight() - $boxB->getWeight();
        }
        return $choice;
    }

    /**
     * Reversed version of compare
     * @return int
     */
    public function reverseCompare($boxA, $boxB)
    {
        $choice = $boxB->getItems()->count() - $boxA->getItems()->count();
        if ($choice === 0) {
            $choice = $boxA->getBox()->getInnerVolume() - $boxB->getBox()->getInnerVolume();
        }
        if ($choice === 0) {
            $choice = $boxB->getWeight() - $boxA->getWeight();
        }
        return $choice;
    }

    /**
     * Calculate the average (mean) weight of the boxes
     * @return float
     */
    public function getMeanWeight()
    {

        if (!is_null($this->meanWeight)) {
            return $this->meanWeight;
        }

        foreach (clone $this as $box) {
            $this->meanWeight += $box->getWeight();
        }

        return $this->meanWeight /= $this->count();

    }

    /**
     * Calculate the variance in weight between these boxes
     * @return float
     */
    public function getWeightVariance()
    {
        $mean = $this->getMeanWeight();

        $weightVariance = 0;
        foreach (clone $this as $box) {
            $weightVariance += pow($box->getWeight() - $mean, 2);
        }

        return $weightVariance / $this->count();

    }

    /**
     * Get volume utilisation of the set of packed boxes
     * @return float
     */
    public function getVolumeUtilisation()
    {
        $itemVolume = 0;
        $boxVolume = 0;

        /** @var PackedBox $box */
        foreach (clone $this as $box) {
            $boxVolume += $box->getBox()->getInnerVolume();

            /** @var Item $item */
            foreach (clone $box->getItems() as $item) {
                $itemVolume += $item->getVolume();
            }
        }

        return round($itemVolume / $boxVolume * 100, 1);
    }

    /**
     * Do a bulk insert
     * @param array $boxes
     */
    public function insertFromArray(array $boxes)
    {
        foreach ($boxes as $box) {
            $this->insert($box);
        }
    }
}
}

/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

/**
 * An item to be packed
 * @author Doug Wright
 * @package BoxPacker
 */
class OrientatedItem
{

    /**
     * @var Item
     */
    protected $item;

    /**
     * @var int
     */
    protected $width;

    /**
     * @var int
     */
    protected $length;

    /**
     * @var int
     */
    protected $depth;

    /**
     * Constructor.
     * @param Item $item
     * @param int $width
     * @param int $length
     * @param int $depth
     */
    public function __construct(Item $item, $width, $length, $depth) {
        $this->item = $item;
        $this->width = $width;
        $this->length = $length;
        $this->depth = $depth;
    }

    /**
     * Item
     *
     * @return Item
     */
    public function getItem() {
        return $this->item;
    }

    /**
     * Item width in mm in it's packed orientation
     *
     * @return int
     */
    public function getWidth() {
        return $this->width;
    }

    /**
     * Item length in mm in it's packed orientation
     *
     * @return int
     */
    public function getLength() {
        return $this->length;
    }

    /**
     * Item depth in mm in it's packed orientation
     *
     * @return int
     */
    public function getDepth() {
        return $this->depth;
    }

    /**
     * Is this orientation stable (low centre of gravity)
     * N.B. Assumes equal weight distribution
     *
     * @return bool
     */
    public function isStable() {
        return $this->getDepth() <= min($this->getLength(), $this->getWidth());
    }
}

}

/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\LoggerAwareInterface;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\LoggerInterface;

/**
 * Figure out orientations for an item and a given set of dimensions
 * @author Doug Wright
 * @package BoxPacker
 */
class OrientatedItemFactory implements LoggerAwareInterface
{
    /**
     * The logger instance.
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * This setting allows last item to be packed in an unstable orientation
     * @since 06.06.2020, by Robin
     * @var bool
     */
    protected $_isLastUnstableItemAllowed = true;

    /**
     * Sets a logger.
     * @param LoggerInterface $logger
     * @return null|void
     */
    public function setLogger(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    /**
     * Sets $_isLastUnstableItemAllowed
     * @param bool $bool
     */
    public function setLastUnstableItemAllowed($bool) {
        $this->_isLastUnstableItemAllowed = (bool)$bool;
    }

    /**
     * Get the best orientation for an item
     * @param Box $box
     * @param Item $item
     * @param OrientatedItem|null $prevItem
     * @param Item|null $nextItem
     * @param int $widthLeft
     * @param int $lengthLeft
     * @param int $depthLeft
     * @return OrientatedItem|false
     */
    public function getBestOrientation(Box $box, Item $item, OrientatedItem $prevItem = null, Item $nextItem = null, $widthLeft, $lengthLeft, $depthLeft) {

        $possibleOrientations = $this->getPossibleOrientations($item, $prevItem, $widthLeft, $lengthLeft, $depthLeft);
        $usableOrientations = $this->getUsableOrientations($possibleOrientations, $box, $item, $prevItem, $nextItem);

        $orientationFits = array();
        /** @var OrientatedItem $orientation */
        foreach ($usableOrientations as $o => $orientation) {
            $orientationFit = min($widthLeft - $orientation->getWidth(), $lengthLeft - $orientation->getLength());
            $orientationFits[$o] = $orientationFit;
        }

        if (!empty($orientationFits)) {
            asort($orientationFits);
            reset($orientationFits);
            $bestFit = $usableOrientations[key($orientationFits)];
            $this->logger->debug("Selected best fit orientation", array('orientation' => $bestFit));
            return $bestFit;
        } else {
            return false;
        }
    }

    /**
     * Find all possible orientations for an item
     * @param Item $item
     * @param OrientatedItem|null $prevItem
     * @param int $widthLeft
     * @param int $lengthLeft
     * @param int $depthLeft
     * @return OrientatedItem[]
     */
    public function getPossibleOrientations(Item $item, OrientatedItem $prevItem = null, $widthLeft, $lengthLeft, $depthLeft) {

        $orientations = array();

        //Special case items that are the same as what we just packed - keep orientation
        if ($prevItem && $prevItem->getItem() == $item) {
            $orientations[] = new OrientatedItem($item, $prevItem->getWidth(), $prevItem->getLength(), $prevItem->getDepth());
        } else {

            //simple 2D rotation
            $orientations[] = new OrientatedItem($item, $item->getWidth(), $item->getLength(), $item->getDepth());
            $orientations[] = new OrientatedItem($item, $item->getLength(), $item->getWidth(), $item->getDepth());

            //add 3D rotation if we're allowed
            if (!$item->getKeepFlat()) {
                $orientations[] = new OrientatedItem($item, $item->getWidth(), $item->getDepth(), $item->getLength());
                $orientations[] = new OrientatedItem($item, $item->getLength(), $item->getDepth(), $item->getWidth());
                $orientations[] = new OrientatedItem($item, $item->getDepth(), $item->getWidth(), $item->getLength());
                $orientations[] = new OrientatedItem($item, $item->getDepth(), $item->getLength(), $item->getWidth());
            }
        }

        //remove any that simply don't fit
        return array_filter($orientations, function(OrientatedItem $i) use ($widthLeft, $lengthLeft, $depthLeft) {
            return $i->getWidth() <= $widthLeft && $i->getLength() <= $lengthLeft && $i->getDepth() <= $depthLeft;
        });
    }

    /**
     * @param OrientatedItem[] $possibleOrientations
     * @param Box              $box
     * @param Item             $item
     * @param OrientatedItem   $prevItem
     * @param Item             $nextItem
     *
     * @return array
     */
    protected function getUsableOrientations(
        $possibleOrientations,
        Box $box,
        Item $item,
        OrientatedItem $prevItem = null,
        Item $nextItem = null
    ) {
        /*
         * Divide possible orientations into stable (low centre of gravity) and unstable (high centre of gravity)
         */
        $stableOrientations = array();
        $unstableOrientations = array();

        foreach ($possibleOrientations as $o => $orientation) {
            if ($orientation->isStable()) {
                $stableOrientations[] = $orientation;
            } else {
                $unstableOrientations[] = $orientation;
            }
        }

        $orientationsToUse = array();

        /*
         * We prefer to use stable orientations only, but allow unstable ones if either
         * the item is the last one left to pack OR
         * the item doesn't fit in the box any other way
         */
        if (count($stableOrientations) > 0) {
            $orientationsToUse = $stableOrientations;
        } else if (count($unstableOrientations) > 0) {
            $orientationsInEmptyBox = $this->getPossibleOrientations(
                $item,
                $prevItem,
                $box->getInnerWidth(),
                $box->getInnerLength(),
                $box->getInnerDepth()
            );

            $stableOrientationsInEmptyBox = array_filter(
                $orientationsInEmptyBox,
                function(OrientatedItem $orientation) {
                    return $orientation->isStable();
                }
            );

            /* original: 2.3.1, 2.3.2
            if (is_null($nextItem) || count($stableOrientationsInEmptyBox) == 0) {
                $orientationsToUse = $unstableOrientations;
            }
            */
            if (is_null($nextItem) && $this->_isLastUnstableItemAllowed) {
                $orientationsToUse = $unstableOrientations;
            } elseif (count($stableOrientationsInEmptyBox) == 0) {
                $orientationsToUse = $unstableOrientations;
            }
        }

        return $orientationsToUse;
    }
}

}


/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

/**
 * Class ItemTooLargeException
 * Exception used when an item is too large to pack
 *
 * @package \CanadapostSmartFlexibleRootNS\DVDoug\BoxPacker
 */
class ItemTooLargeException extends \RuntimeException
{

    /** @var Item */
    public $item;

    /**
     * ItemTooLargeException constructor.
     *
     * @param string $message
     * @param Item   $item
     */
    public function __construct($message, Item $item) {
        $this->item = $item;
        parent::__construct($message);
    }

    /**
     * @return Item
     */
    public function getItem() {
        return $this->item;
    }

}
}

/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\PackagingMap\Map;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\LoggerAwareInterface;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\LoggerInterface;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\NullLogger;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\PackagingMap\Reserved;

/**
 * Actual packer
 * @author Doug Wright
 * @package BoxPacker
 */
class VolumePacker implements LoggerAwareInterface
{
    /**
     * The logger instance.
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * Box to pack items into
     * @var Box
     */
    protected $box;

    /**
     * List of items to be packed
     * @var ItemList
     */
    protected $items;

    /**
     * Remaining width of the box to pack items into
     * @var int
     */
    protected $widthLeft;

    /**
     * Remaining length of the box to pack items into
     * @var int
     */
    protected $lengthLeft;

    /**
     * Remaining depth of the box to pack items into
     * @var int
     */
    protected $depthLeft;

    /**
     * Remaining weight capacity of the box
     * @var int
     */
    protected $remainingWeight;

    /**
     * Used width inside box for packing items
     * @var int
     */
    protected $usedWidth = 0;

    /**
     * Used length inside box for packing items
     * @var int
     */
    protected $usedLength = 0;

    /**
     * Used depth inside box for packing items
     * @var int
     */
    protected $usedDepth = 0;

    /** @var Reserved[] */
    protected $_reservedSpace = array();
    /** @var int */
    protected $_offsetLength, $_offsetWidth, $_offsetHeight;
    /**
     * This setting allows last item to be packed in an unstable orientation
     * @var bool
     */
    protected $_isLastUnstableItemAllowed = true;

    /**
     * @var int
     */
    protected $layerWidth = 0;

    /**
     * @var int
     */
    protected $layerLength = 0;

    /**
     * @var int
     */
    protected $layerDepth = 0;

    /**
     * Constructor
     *
     * @param Box      $box
     * @param ItemList $items
     */
    public function __construct(Box $box, ItemList $items)
    {
        $this->logger = new NullLogger();

        $this->box = $box;
        $this->items = $items;

        $this->depthLeft = $this->box->getInnerDepth();
        $this->remainingWeight = $this->box->getMaxWeight() - $this->box->getEmptyWeight();
        $this->widthLeft = $this->box->getInnerWidth();
        $this->lengthLeft = $this->box->getInnerLength();
    }

    /**
     * Sets a logger.
     * @param LoggerInterface $logger
     * @return null|void
     */
    public function setLogger(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    /**
     * @param bool $bool
     */
    public function setLastUnstableItemAllowed($bool) {
        $this->_isLastUnstableItemAllowed = (bool)$bool;
    }

    /**
     * Pack as many items as possible into specific given box
     * @return PackedBox packed box
     */
    public function pack()
    {
        $this->logger->debug("[EVALUATING BOX] {$this->box->getReference()}");

        $packedItems = new ItemList;

        $this->layerWidth = $this->layerLength = $this->layerDepth = 0;

        $prevItem = null;

        while (!$this->items->isEmpty()) {

            $itemToPack = $this->items->extract();
            $nextItem = !$this->items->isEmpty() ? $this->items->top() : null;

            //skip items that are simply too heavy or too large
            if (!$this->checkConstraints($itemToPack, $packedItems, $prevItem, $nextItem)) {
                continue;
            }

            $this->_offsetLength = $this->box->getInnerLength() - $this->lengthLeft;
            $this->_offsetWidth = $this->box->getInnerWidth() - $this->widthLeft;
            $this->_offsetHeight = $this->box->getInnerDepth() - $this->depthLeft;
            $orientatedItem = $this->getOrientationForItem($itemToPack, $prevItem, $nextItem, $this->widthLeft, $this->lengthLeft, $this->depthLeft);

            if ($orientatedItem) {

                $packedItems->insert($orientatedItem->getItem());
                $this->remainingWeight -= $orientatedItem->getItem()->getWeight();

                $this->lengthLeft -= $orientatedItem->getLength();
                $this->layerLength += $orientatedItem->getLength();
                $this->layerWidth = max($orientatedItem->getWidth(), $this->layerWidth);

                $this->layerDepth = max($this->layerDepth, $orientatedItem->getDepth()); //greater than 0, items will always be less deep

                $this->usedLength = max($this->usedLength, $this->layerLength);
                $this->usedWidth = max($this->usedWidth, $this->layerWidth);

                //allow items to be stacked in place within the same footprint up to current layerdepth
                $stackableDepth = $this->layerDepth - $orientatedItem->getDepth();
                $this->_reservedSpace[] = new Reserved(
                    $this->_offsetLength,
                    $this->_offsetWidth,
                    $this->_offsetHeight,
                    $orientatedItem->getLength(),
                    $orientatedItem->getWidth(),
                    $orientatedItem->getDepth(),
                    $itemToPack->getDescription()
                );
                $this->tryAndStackItemsIntoSpace($packedItems, $prevItem, $nextItem, $orientatedItem->getWidth(), $orientatedItem->getLength(), $stackableDepth);

                $prevItem = $orientatedItem;

                if ($this->items->isEmpty()) {
                    $this->usedDepth += $this->layerDepth;
                }
            } else {

                $prevItem = null;

                if ($this->widthLeft >= min($itemToPack->getWidth(), $itemToPack->getLength()) && $this->isLayerStarted()) {
                    $this->logger->debug("No more fit in lengthwise, resetting for new row");
                    $this->lengthLeft += $this->layerLength;
                    $this->widthLeft -= $this->layerWidth;
                    $this->layerWidth = $this->layerLength = 0;
                    $this->items->insert($itemToPack);
                    continue;
                } elseif ($this->lengthLeft < min($itemToPack->getWidth(), $itemToPack->getLength()) || $this->layerDepth == 0) {
                    $this->logger->debug("doesn't fit on layer even when empty");
                    $this->usedDepth += $this->layerDepth;
                    continue;
                }

                $this->widthLeft = $this->layerWidth ? min(floor($this->layerWidth * 1.1), $this->box->getInnerWidth()) : $this->box->getInnerWidth();
                $this->lengthLeft = $this->layerLength ? min(floor($this->layerLength * 1.1), $this->box->getInnerLength()) : $this->box->getInnerLength();
                $this->depthLeft -= $this->layerDepth;
                $this->usedDepth += $this->layerDepth;

                $this->layerWidth = $this->layerLength = $this->layerDepth = 0;
                $this->logger->debug("doesn't fit, so starting next vertical layer");
                $this->items->insert($itemToPack);
            }
        }
        $this->logger->debug("done with this box");
        return PackedBox::fromPackingMap(
            $this->box, $packedItems,
            new Map(get_class($this), $this->_reservedSpace),
            $this->remainingWeight
        );
    }

    /**
     * @param Item $itemToPack
     * @param OrientatedItem|null $prevItem
     * @param Item|null $nextItem
     * @param int $maxWidth
     * @param int $maxLength
     * @param int $maxDepth
     *
     * @return OrientatedItem|false
     */
    protected function getOrientationForItem(
        Item $itemToPack,
        OrientatedItem $prevItem = null,
        Item $nextItem = null,
        $maxWidth, $maxLength,
        $maxDepth
    ) {
        $this->logger->debug(
            "evaluating item {$itemToPack->getDescription()} for fit",
            array(
                'item' => $itemToPack,
                'space' => array(
                    'maxWidth'    => $maxWidth,
                    'maxLength'   => $maxLength,
                    'maxDepth'    => $maxDepth,
                    'layerWidth'  => $this->layerWidth,
                    'layerLength' => $this->layerLength,
                    'layerDepth'  => $this->layerDepth
                )
            )
        );

        $orientatedItemFactory = new OrientatedItemFactory();
        $orientatedItemFactory->setLogger($this->logger);
        $orientatedItemFactory->setLastUnstableItemAllowed($this->_isLastUnstableItemAllowed);
        $orientatedItem = $orientatedItemFactory->getBestOrientation($this->box, $itemToPack, $prevItem, $nextItem, $maxWidth, $maxLength, $maxDepth);

        return $orientatedItem;
    }

    /**
     * Figure out if we can stack the next item vertically on top of this rather than side by side
     * Used when we've packed a tall item, and have just put a shorter one next to it
     *
     * @param ItemList       $packedItems
     * @param OrientatedItem $prevItem
     * @param Item           $nextItem
     * @param int            $maxWidth
     * @param int            $maxLength
     * @param int            $maxDepth
     */
    protected function tryAndStackItemsIntoSpace(
        ItemList $packedItems,
        OrientatedItem $prevItem = null,
        Item $nextItem = null,
        $maxWidth,
        $maxLength,
        $maxDepth
    ) {
        while (!$this->items->isEmpty() && $this->checkNonDimensionalConstraints($this->items->top(), $packedItems)) {
            $stackedItem = $this->getOrientationForItem(
                $this->items->top(),
                $prevItem,
                $nextItem,
                $maxWidth,
                $maxLength,
                $maxDepth
            );
            if ($stackedItem) {
                $this->_reservedSpace[] = new Reserved(
                    $this->_offsetLength,
                    $this->_offsetWidth,
                    $this->_offsetHeight + $this->layerDepth - $maxDepth,
                    $stackedItem->getLength(),
                    $stackedItem->getWidth(),
                    $stackedItem->getDepth(),
                    $this->items->top()->getDescription()
                );
                $this->remainingWeight -= $this->items->top()->getWeight();
                $maxDepth -= $stackedItem->getDepth();
                $packedItems->insert($this->items->extract());
            } else {
                break;
            }
        }
    }

    /**
     * @return bool
     */
    protected function isLayerStarted()
    {
        return $this->layerWidth > 0 && $this->layerLength > 0 && $this->layerDepth > 0;
    }


    /**
     * Check item generally fits into box
     *
     * @param Item            $itemToPack
     * @param ItemList  $packedItems
     * @param OrientatedItem|null $prevItem
     * @param Item|null       $nextItem
     *
     * @return bool
     */
    protected function checkConstraints(
        Item $itemToPack,
        ItemList $packedItems,
        OrientatedItem $prevItem = null,
        Item $nextItem = null
    ) {
        return $this->checkNonDimensionalConstraints($itemToPack, $packedItems) &&
               $this->checkDimensionalConstraints($itemToPack, $prevItem, $nextItem);
    }

    /**
     * As well as purely dimensional constraints, there are other constraints that need to be met
     * e.g. weight limits or item-specific restrictions (e.g. max <x> batteries per box)
     *
     * @param Item     $itemToPack
     * @param ItemList $packedItems
     *
     * @return bool
     */
    protected function checkNonDimensionalConstraints(Item $itemToPack, ItemList $packedItems)
    {
        $weightOK = $itemToPack->getWeight() <= $this->remainingWeight;

        if ($itemToPack instanceof ConstrainedItem) {
            return $weightOK && $itemToPack->canBePackedInBox(clone $packedItems, $this->box);
        }

        return $weightOK;
    }

    /**
     * Check the item physically fits in the box (at all)
     *
     * @param Item            $itemToPack
     * @param OrientatedItem|null $prevItem
     * @param Item|null       $nextItem
     *
     * @return bool
     */
    protected function checkDimensionalConstraints(Item $itemToPack, OrientatedItem $prevItem = null, Item $nextItem = null)
    {
        return !!$this->getOrientationForItem(
            $itemToPack,
            $prevItem,
            $nextItem,
            $this->box->getInnerWidth(),
            $this->box->getInnerLength(),
            $this->box->getInnerDepth()
        );
    }
}
}

/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\LoggerAwareInterface;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\LoggerInterface;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\LogLevel;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\NullLogger;

/**
 * Actual packer
 * @author Doug Wright
 * @package BoxPacker
 */
class WeightRedistributor implements LoggerAwareInterface
{

    /**
     * The logger instance.
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * Sets a logger.
     * @param LoggerInterface $logger
     * @return null|void
     */
    public function setLogger(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    /**
     * List of box sizes available to pack items into
     * @var BoxList
     */
    protected $boxes;

    /**
     * Constructor
     */
    public function __construct(BoxList $boxList)
    {
        $this->boxes = clone $boxList;
        $this->logger = new NullLogger();
    }

    /**
     * Given a solution set of packed boxes, repack them to achieve optimum weight distribution
     *
     * @param PackedBoxList $originalBoxes
     * @return PackedBoxList
     */
    public function redistributeWeight(PackedBoxList $originalBoxes)
    {

        $targetWeight = $originalBoxes->getMeanWeight();
        $this->logger->log(LogLevel::DEBUG, "repacking for weight distribution, weight variance {$originalBoxes->getWeightVariance()}, target weight {$targetWeight}");

        $packedBoxes = new PackedBoxList;

        $overWeightBoxes = array();
        $underWeightBoxes = array();
        foreach (clone $originalBoxes as $packedBox) {
            $boxWeight = $packedBox->getWeight();
            if ($boxWeight > $targetWeight) {
                $overWeightBoxes[] = $packedBox;
            } elseif ($boxWeight < $targetWeight) {
                $underWeightBoxes[] = $packedBox;
            } else {
                $packedBoxes->insert($packedBox); //target weight, so we'll keep these
            }
        }

        do { //Keep moving items from most overweight box to most underweight box
            $tryRepack = false;
            $this->logger->log(LogLevel::DEBUG, 'boxes under/over target: ' . count($underWeightBoxes) . '/' . count($overWeightBoxes));

            foreach ($underWeightBoxes as $u => $underWeightBox) {
                $this->logger->log(LogLevel::DEBUG, 'Underweight Box ' . $u);
                foreach ($overWeightBoxes as $o => $overWeightBox) {
                    $this->logger->log(LogLevel::DEBUG, 'Overweight Box ' . $o);
                    $overWeightBoxItems = $overWeightBox->getItems()->asArray();

                    //For each item in the heavier box, try and move it to the lighter one
                    foreach ($overWeightBoxItems as $oi => $overWeightBoxItem) {
                        $this->logger->log(LogLevel::DEBUG, 'Overweight Item ' . $oi);
                        if ($underWeightBox->getWeight() + $overWeightBoxItem->getWeight() > $targetWeight) {
                            $this->logger->log(LogLevel::DEBUG, 'Skipping item for hindering weight distribution');
                            continue; //skip if moving this item would hinder rather than help weight distribution
                        }

                        $newItemsForLighterBox = clone $underWeightBox->getItems();
                        $newItemsForLighterBox->insert($overWeightBoxItem);

                        $newLighterBoxPacker = new Packer(); //we may need a bigger box
                        $newLighterBoxPacker->setBoxes($this->boxes);
                        $newLighterBoxPacker->setItems($newItemsForLighterBox);
                        $this->logger->log(LogLevel::INFO, "[ATTEMPTING TO PACK LIGHTER BOX]");
                        $newLighterBox = $newLighterBoxPacker->doVolumePacking()->extract();

                        if ($newLighterBox->getItems()->count() === $newItemsForLighterBox->count()) { //new item fits
                            $this->logger->log(LogLevel::DEBUG, 'New item fits');
                            unset($overWeightBoxItems[$oi]); //now packed in different box

                            $newHeavierBoxPacker = new Packer(); //we may be able to use a smaller box
                            $newHeavierBoxPacker->setBoxes($this->boxes);
                            $newHeavierBoxPacker->setItems($overWeightBoxItems);

                            $this->logger->log(LogLevel::INFO, "[ATTEMPTING TO PACK HEAVIER BOX]");
                            $newHeavierBoxes = $newHeavierBoxPacker->doVolumePacking();
                            if (count($newHeavierBoxes) > 1) { //found an edge case in packing algorithm that *increased* box count
                                $this->logger->log(LogLevel::INFO, "[REDISTRIBUTING WEIGHT] Abandoning redistribution, because new packing is less efficient than original");
                                return $originalBoxes;
                            }

                            $overWeightBoxes[$o] = $newHeavierBoxes->extract();
                            $underWeightBoxes[$u] = $newLighterBox;

                            $tryRepack = true; //we did some work, so see if we can do even better
                            usort($overWeightBoxes, array($packedBoxes, 'reverseCompare'));
                            usort($underWeightBoxes, array($packedBoxes, 'reverseCompare'));
                            break 3;
                        }
                    }
                }
            }
        } while ($tryRepack);

        //Combine back into a single list
        $packedBoxes->insertFromArray($overWeightBoxes);
        $packedBoxes->insertFromArray($underWeightBoxes);

        return $packedBoxes;
    }
}
}

/**
 * Box packing (3D bin packing, knapsack problem)
 * @package BoxPacker
 * @author Doug Wright
 */
namespace CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\LoggerAwareInterface;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\LoggerInterface;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\LogLevel;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Psr\Log\NullLogger;

/**
 * Actual packer
 * @author Doug Wright
 * @package BoxPacker
 */
class Packer implements LoggerAwareInterface
{
    /**
     * The logger instance.
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * This setting allows last item to be packed in an unstable orientation
     * @var bool
     */
    protected $_isLastUnstableItemAllowed = true;

    const MAX_BOXES_TO_BALANCE_WEIGHT = 12;

    /**
     * List of items to be packed
     * @var ItemList
     */
    protected $items;

    /**
     * List of box sizes available to pack items into
     * @var BoxList
     */
    protected $boxes;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->items = new ItemList();
        $this->boxes = new BoxList();

        $this->logger = new NullLogger();
    }

    /**
     * Sets a logger.
     * @param LoggerInterface $logger
     * @return null|void
     */
    public function setLogger(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    /**
     * @param bool $bool
     */
    public function setLastUnstableItemAllowed($bool) {
        $this->_isLastUnstableItemAllowed = (bool)$bool;
    }

    /**
     * Add item to be packed
     * @param Item $item
     * @param int  $qty
     */
    public function addItem(Item $item, $qty = 1)
    {
        for ($i = 0; $i < $qty; $i++) {
            $this->items->insert($item);
        }
        $this->logger->log(LogLevel::INFO, "added {$qty} x {$item->getDescription()}");
    }

    /**
     * Set a list of items all at once
     * @param \Traversable|array $items
     */
    public function setItems($items)
    {
        if ($items instanceof ItemList) {
            $this->items = clone $items;
        } else {
            $this->items = new ItemList();
            foreach ($items as $item) {
                $this->items->insert($item);
            }
        }
    }

    /**
     * Add box size
     * @param Box $box
     */
    public function addBox(Box $box)
    {
        $this->boxes->insert($box);
        $this->logger->log(LogLevel::INFO, "added box {$box->getReference()}");
    }

    /**
     * Add a pre-prepared set of boxes all at once
     * @param BoxList $boxList
     */
    public function setBoxes(BoxList $boxList)
    {
        $this->boxes = clone $boxList;
    }

    /**
     * Pack items into boxes
     *
     * @return PackedBoxList
     */
    public function pack()
    {
        $packedBoxes = $this->doVolumePacking();

        //If we have multiple boxes, try and optimise/even-out weight distribution
        if ($packedBoxes->count() > 1 && $packedBoxes->count() < static::MAX_BOXES_TO_BALANCE_WEIGHT) {
            $redistributor = new WeightRedistributor($this->boxes);
            $redistributor->setLogger($this->logger);
            $packedBoxes = $redistributor->redistributeWeight($packedBoxes);
        }

        $this->logger->log(LogLevel::INFO, "packing completed, {$packedBoxes->count()} boxes");
        return $packedBoxes;
    }

    /**
     * Pack items into boxes using the principle of largest volume item first
     *
     * @throws ItemTooLargeException
     * @return PackedBoxList
     */
    public function doVolumePacking()
    {

        $packedBoxes = new PackedBoxList;

        //Keep going until everything packed
        while ($this->items->count()) {
            $boxesToEvaluate = clone $this->boxes;
            $packedBoxesIteration = new PackedBoxList;

            //Loop through boxes starting with smallest, see what happens
            while (!$boxesToEvaluate->isEmpty()) {
                $box = $boxesToEvaluate->extract();

                $volumePacker = new VolumePacker($box, clone $this->items);
                $volumePacker->setLogger($this->logger);
                $volumePacker->setLastUnstableItemAllowed($this->_isLastUnstableItemAllowed);
                $packedBox = $volumePacker->pack();
                if ($packedBox->getItems()->count()) {
                    $packedBoxesIteration->insert($packedBox);

                    //Have we found a single box that contains everything?
                    if ($packedBox->getItems()->count() === $this->items->count()) {
                        break;
                    }
                }
            }

            //Check iteration was productive
            if ($packedBoxesIteration->isEmpty()) {
                throw new ItemTooLargeException('Item ' . $this->items->top()->getDescription() . ' is too large to fit into any box', $this->items->top());
            }

            //Find best box of iteration, and remove packed items from unpacked list
            $bestBox = $packedBoxesIteration->top();
            $unPackedItems = $this->items->asArray();
            foreach (clone $bestBox->getItems() as $packedItem) {
                foreach ($unPackedItems as $unpackedKey => $unpackedItem) {
                    if ($packedItem === $unpackedItem) {
                        unset($unPackedItems[$unpackedKey]);
                        break;
                    }
                }
            }
            $unpackedItemList = new ItemList();
            foreach ($unPackedItems as $unpackedItem) {
                $unpackedItemList->insert($unpackedItem);
            }
            $this->items = $unpackedItemList;
            $packedBoxes->insert($bestBox);

        }

        return $packedBoxes;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\BaseLabelsProvider;

class Fallback {
    /** @var string */
    protected $labelFormat;
    /** @var int|null */
    protected $originCountryId;
    /** @var int|null */
    protected $originZoneId;
    /** @var string|null */
    protected $hsCode;

    private function __construct() {
    }

    /**
     * @return Fallback
     */
    public static function create() {
        return new self();
    }

    /**
     * @param string|null $hsCode
     * @return $this
     */
    public function setHsCode($hsCode) {
        $this->hsCode = $hsCode ? $hsCode : null;
        return $this;
    }

    /**
     * @param BaseLabelsProvider|null $labelsProvider
     * @return $this
     */
    public function setLabelFormatFromProvider($labelsProvider) {
        $this->labelFormat = $labelsProvider ? $labelsProvider->getLabelFormat() : null;
        return $this;
    }

    /**
     * @param string|null $labelFormat
     * @return $this
     */
    public function setLabelFormat($labelFormat) {
        $this->labelFormat = $labelFormat;
        return $this;
    }

    /**
     * @param int|null $originCountryId
     * @return $this
     */
    public function setOriginCountryId($originCountryId) {
        $this->originCountryId = $originCountryId ? (int)$originCountryId : null;
        return $this;
    }

    /**
     * @param int|null $originZoneId
     * @return $this
     */
    public function setOriginZoneId($originZoneId) {
        $this->originZoneId = $originZoneId ? (int)$originZoneId : null;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getHsCode() {
        return $this->hsCode;
    }

    /**
     * @return string
     */
    public function getLabelFormat() {
        return $this->labelFormat;
    }

    /**
     * @return int|null
     */
    public function getOriginCountryId() {
        return $this->originCountryId;
    }

    /**
     * @return int|null
     */
    public function getOriginZoneId() {
        return $this->originZoneId;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

class Promise {
    /** @var string */
    private $id;
    /** @var array */
    private $data;

    /**
     * @param string $id
     * @param array $data
     */
    public function __construct($id, $data) {
        $this->id = $id;
        $this->data = $data;
    }

    /**
     * @param array $data
     * @return Promise
     */
    public static function createFromArray($data) {
        return new Promise($data['id'], $data['data']);
    }

    /**
     * @return array
     */
    public function toArray() {
        return array(
            'id' => $this->id,
            'data' => $this->data
        );
    }

    /**
     * @return string
     */
    public function getId() {
        return $this->id;
    }

    /**
     * @return array
     */
    public function getData() {
        return $this->data;
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\PackagingListManager;

abstract class FileManager {
    /**
     * @return string
     */
    protected static function getStorageDir() {
        if (defined('DIR_STORAGE')) { // v3
            return DIR_STORAGE . 'smart-flexible/';
        }
        return DIR_SYSTEM . 'storage/smart-flexible/';
    }

    /**
     * @return string
     */
    private static function getLegacyStorageDir() {
        return DIR_CACHE . 'smart-flexible/';
    }

    /**
     * Compatibility method to move smart-flexible storage from a legacy (cache) folder into system
     * @return bool
     */
    public static function moveStorageDir() {
        if (file_exists(self::getLegacyStorageDir())) {
            if (!file_exists(self::getStorageDir())) { // just move dir
                if (!file_exists(dirname(self::getStorageDir()))) { // for v1 - create storage dir
                    self::createFolder(dirname(self::getStorageDir()));
                }
                return rename(self::getLegacyStorageDir(), self::getStorageDir());
            } else { // move files from specific directories
                $subDirs = array(
                    PackagingListManager::ListsDir,
                    PromiseManager::PromiseDir
                );
                foreach ($subDirs as $subDir) {
                    self::createFolder(self::getStorageDir() . $subDir);
                    $files = glob(self::getLegacyStorageDir() . $subDir . '*.json');
                    foreach ($files as $file) {
                        rename(
                            $file,
                            self::getStorageDir() . $subDir . basename($file)
                        );
                    }
                }
                rename(
                    self::getLegacyStorageDir(),
                    self::getStorageDir() . '_old_storage'
                );
            }
        }
        return true;
    }

    /**
     * Creates a directory
     * @param string $path
     * @return bool
     */
    protected static function createFolder($path) {
        if (!file_exists($path)) {
            return @mkdir($path, 0755, true);
        }
        return true;
    }

    /**
     * Creates a file
     * @param string $path
     * @param mixed $data
     * @return int bytes written
     */
    protected static function createFile($path, $data) {
        return @file_put_contents($path, $data);
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Json;

class PromiseManager extends FileManager {
    const PromiseDir = 'promise/';

    private static function getSafeId($id) {
        return preg_replace('/[^a-zA-Z0-9\-\_\.]/', '_', $id);
    }

    /**
     * @param string $id
     * @return null|string
     */
    private static function readRaw($id) {
        $path = self::getStorageDir() . self::PromiseDir . self::getSafeId($id) . '.json';
        if (!file_exists($path)) {
            return null;
        }
        return file_get_contents($path);
    }

    /**
     * @param string $id
     * @return Promise|null
     */
    public static function load($id) {
        $data = self::readRaw($id);
        if ($data === null) {
            return null;
        }
        $promise = Promise::createFromArray(Json::decodeAsArray($data));
        if ($promise->getId() === $id) {
            return $promise;
        }
        return null;
    }

    /**
     * @param Promise $promise
     * @return int
     */
    public static function save($promise) {
        $old = self::load($promise->getId());
        if ($old) { // merge data if already exists
            $promise = new Promise($promise->getId(), array_merge(
                $old->getData(),
                $promise->getData()
            ));
        }
        $path = self::getStorageDir() . self::PromiseDir;
        self::createFolder($path);
        return self::createFile(
            $path . self::getSafeId($promise->getId()) . '.json',
            Json::encodePretty($promise->toArray())
        );
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\Configuration;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Length;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;

class Locale {
    /** @var bool */
    private $isMetric;

    /**
     * @param string $measurementSystem
     */
    public function __construct($measurementSystem) {
        $this->isMetric = $measurementSystem === Configuration::MetricMeasures;
    }

    /**
     * Returns inches length value for view in inches or centimeters
     * @param float $in
     * @param bool $isWithUnit
     * @return string Inches or centimeters
     */
    public function renderLength($in, $isWithUnit = false) {
        if ($this->isMetric) {
            return round(Length::convertInchesToCentimeters($in), 2) .
                ($isWithUnit ? ' ' . $this->renderLengthUnitForNumber() : '');
        }
        return round($in, 2) . ($isWithUnit ? $this->renderLengthUnitForNumber() : '');
    }

    /**
     * Returns inches length dimensions for view in inches or centimeters
     * @param float[] $dimensions
     * @return string
     */
    public function renderDimensions($dimensions) {
        $_this = $this;
        if (!array_filter($dimensions)) {
            return '';
        }
        $rounded = array_map(function($dimension) use ($_this) {
            return $_this->renderLength($dimension);
        }, $dimensions);
        return implode(' &#215; ', $rounded) . ($this->isMetric ? ' ' : '') . $this->renderLengthUnitForNumber();
    }

    /**
     * Import length value (inches or centimeters) into inches
     * @param float $value
     * @return float
     */
    public function acceptLength($value) {
        $value = (float)$value;
        if ($this->isMetric) {
            return Length::convertCentimetersToInches($value);
        }
        return $value;
    }

    /**
     * Returns length unit string (inches or centimeters)
     * @return string
     */
    public function renderLengthUnitForNumber() {
        if ($this->isMetric) {
            return Length::UnitCentimeter;
        }
        return Length::UnitInchShort;
    }

    /**
     * Returns length unit string (inches or centimeters)
     * @return string
     */
    public function renderLengthUnit() {
        if ($this->isMetric) {
            return Length::UnitCentimeter;
        }
        return Length::UnitInchLong;
    }

    /**
     * Returns ounces value for view in ounces or grams
     * @param float $oz
     * @param bool $isWithUnit
     * @return string Ounces or grams
     */
    public function renderSmallWeight($oz, $isWithUnit = false) {
        if ($this->isMetric) {
            return round(Weight::convertOuncesToGrams($oz)) .
                ($isWithUnit ? ' ' . $this->renderSmallWeightUnit() : '');
        }
        return round($oz, 2) . ($isWithUnit ? ' ' . $this->renderSmallWeightUnit() : '');
    }

    /**
     * Import small weight value (ounces or grams) into ounces
     * @param float $value
     * @return float
     */
    public function acceptSmallWeight($value) {
        $value = (float)$value;
        if ($this->isMetric) {
            return Weight::convertGramsToOunces($value);
        }
        return $value;
    }

    /**
     * Returns small weight unit value string (ounces or grams)
     * @return string
     */
    public function renderSmallWeightUnit() {
        if ($this->isMetric) {
            return Weight::UnitGram;
        }
        return Weight::UnitOunce;
    }

    /**
     * Returns pounds value for view value in pounds or kilograms
     * @param float $lb
     * @param bool $isWithUnit
     * @return string
     */
    public function renderLargeWeight($lb, $isWithUnit = false) {
        if ($this->isMetric) {
            return round(Weight::convertPoundsToKilograms($lb), 2) .
                ($isWithUnit ? ' ' . $this->renderLargeWeightUnit() : '');
        }
        return round($lb, 2) . ($isWithUnit ? ' ' . $this->renderLargeWeightUnit() : '');
    }

    /**
     * Import large weight value (pounds or kilograms) into pounds
     * @param float $value
     * @return float
     */
    public function acceptLargeWeight($value) {
        $value = (float)$value;
        if ($this->isMetric) {
            return Weight::convertKilogramsToPounds($value);
        }
        return $value;
    }

    /**
     * Returns large weight unit string (pounds or kilograms)
     * @return string
     */
    public function renderLargeWeightUnit() {
        if ($this->isMetric) {
            return Weight::UnitKilogram;
        }
        return Weight::UnitPound;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerResultBox;

class Rate {
    /**
     * This id should be unique in rate response of module.
     * This id should keep the same in number of checkout requests (like Journal 2)
     * It contains native method code (may be not unique in domestic/international/etc)
     * @var string
     */
    private $id;
    /**
     * Holds a combination of last mile options selected by customer and applied to this rate
     * Here are only selectable options (multiple values given by getLastMileOptions), not all last mile options
     * @var array
     */
    private $customerChoice = array();
    /**
     * This code is used for adjustment rules based on services.
     * This is final unique code of method in particular module
     * @since 09.04.2017
     * @var string
     */
    private $methodFullCode;
    /**
     * This code is used by EasyPost as pre-booked foreign rate id
     * It overrides id_clean in shipping model result
     * @since 06.05.2019
     * @var string
     */
    private $foreignId;
    /** @var string */
    private $title;
    /**
     * Is title provided as code and should be decoded
     * @var bool
     */
    private $isTitleEncoded;
    /** @var float */
    private $costBeforeAdjustmentInSystemCurrency;
    /** @var float */
    private $cost;
    /** @var string */
    private $currencyCode;
    /**
     * Date or number of business days to deliver
     * @var int|null
     */
    private $timeFrom;
    /**
     * Date or number of business days to deliver
     * @var int|null
     */
    private $timeTo;
    /** @var PackerResultBox[] */
    private $boxes;

    public static function create() {
        return new self();
    }

    private function __construct() {
    }

    /**
     * @return string
     */
    public function getForeignId() {
        return $this->foreignId;
    }

    /**
     * @param string $foreignId
     * @return $this
     */
    public function setForeignId($foreignId) {
        $this->foreignId = $foreignId;
        return $this;
    }

    /**
     * @return float
     */
    public function getCost() {
        return $this->cost;
    }

    /**
     * @param float $cost
     * @return $this
     */
    public function setCost($cost) {
        $this->cost = (float)$cost;
        return $this;
    }

    /**
     * @return float
     */
    public function getCostBeforeAdjustmentInSystemCurrency() {
        return $this->costBeforeAdjustmentInSystemCurrency;
    }

    /**
     * @param float $cost in system currency
     * @return $this
     */
    public function setCostBeforeAdjustmentInSystemCurrency($cost) {
        $this->costBeforeAdjustmentInSystemCurrency = (float)$cost;
        return $this;
    }

    /**
     * @return string
     */
    public function getCurrencyCode() {
        return $this->currencyCode;
    }

    /**
     * @param string $currencyCode
     * @return $this
     */
    public function setCurrencyCode($currencyCode) {
        $this->currencyCode = $currencyCode;
        return $this;
    }

    /**
     * Returns original Rate ID defined by Rates Provider
     * @return string
     */
    public function getId() {
        return $this->id;
    }

    /**
     * Returns method full code
     * @return string
     */
    public function getMethodFullCode() {
        return $this->methodFullCode;
    }

    /**
     * Returns ID prepared for E-Commerce system (prefixed with id and without dots)
     * @since 14.09.2018 id was replaced to comparison hash
     * @return string
     */
    public function getIdForEcommerceSystem() {
        return 'id' . str_replace('.', '_', $this->getComparisonIdWithHash());
    }

    /**
     * This hash used to compare rates against ID and customer choice of options
     * It may contain hash of customer choice when set
     * @return string
     */
    public function getComparisonIdWithHash() {
        if (count($this->customerChoice)) {
            return $this->id . ':' . $this->getHashOfCustomerChoice();
        }
        return $this->id;
    }

    /**
     * @return string
     */
    public function getHashOfCustomerChoice() {
        return md5(serialize($this->customerChoice));
    }

    /**
     * @param string $id
     * @return $this
     */
    public function setId($id) {
        $this->id = $id;
        return $this;
    }

    /**
     * @param string $code
     * @return $this
     */
    public function setMethodFullCode($code) {
        $this->methodFullCode = $code;
        return $this;
    }

    /**
     * Date or number of business days
     * @return int|null
     */
    public function getTimeFrom() {
        return $this->timeFrom;
    }

    /**
     * Date or number of business days
     * @param int|null $timeFrom
     * @return $this
     */
    public function setTimeFrom($timeFrom) {
        $this->timeFrom = $timeFrom ?: null;
        return $this;
    }

    /**
     * Date or number of business days
     * @return int|null
     */
    public function getTimeTo() {
        return $this->timeTo;
    }

    /**
     * Date or number of business days
     * Can be the only number of business days
     * @param int|null $timeTo
     * @return $this
     */
    public function setTimeTo($timeTo) {
        $this->timeTo = $timeTo ?: null;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle() {
        return $this->title;
    }

    /**
     * @param string $title
     * @return $this
     */
    public function setTitle($title) {
        $this->title = $title;
        return $this;
    }

    /**
     * @return boolean
     */
    public function getIsTitleEncoded() {
        return $this->isTitleEncoded;
    }

    /**
     * @param boolean $isTitleEncoded
     * @return $this
     */
    public function setIsTitleEncoded($isTitleEncoded) {
        $this->isTitleEncoded = (bool)$isTitleEncoded;
        return $this;
    }

    /**
     * @param PackerResultBox[] $boxes
     * @return $this
     */
    public function setBoxes($boxes) {
        $this->boxes = $boxes;
        return $this;
    }

    /**
     * @return PackerResultBox[]
     */
    public function getBoxes() {
        return $this->boxes;
    }

    /**
     * @return int
     */
    public function getNumberOfBoxes() {
        return count($this->boxes);
    }

    /**
     * @return float
     */
    public function getTotalBoxesWeight() {
        return array_sum(array_map(function ($box) {
            /** @var PackerResultBox $box */
            return $box->getWeight();
        }, $this->boxes));
    }

    /**
     * @return bool
     */
    public function isParticularDate() {
        return ($this->timeFrom === $this->timeTo) && ($this->timeFrom !== null);
    }

    /**
     * @return bool
     */
    public function isDateInterval() {
        return ($this->timeFrom !== $this->timeTo) && ($this->timeTo !== null);
    }

    /**
     * @return array
     */
    public function getCustomerChoice() {
        return $this->customerChoice;
    }

    /**
     * @param array $options
     * @return $this
     */
    public function setCustomerChoice($options) {
        $this->customerChoice = is_array($options) ? $options : array();
        return $this;
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

class Features {
    const Machinable = 'FEATURE_MACHINABLE'; // usps, stamps
    const StandardPackages = 'FEATURE_STANDARD_PACKAGES'; // except easypost
    const CustomPackages = 'FEATURE_CUSTOM_PACKAGES';
    const ShipperAddress = 'FEATURE_SHIPPER_ADDRESS';
    const BillingAddress = 'FEATURE_BILLING_ADDRESS'; // fedex freight
    const Insurance = 'FEATURE_INSURANCE';
    const AuthKey = 'FEATURE_AUTHORIZATION_KEY'; // fedex, freight, ups, stamps
    const AuthPassword = 'FEATURE_AUTHORIZATION_PASSWORD';
    const AuthMeter = 'FEATURE_AUTHORIZATION_METER';
    const AuthCustomerNumber = 'FEATURE_AUTHORIZATION_CUSTOMER_NUMBER'; // canada, ups
    const RequiresCustomerNumber = 'FEATURE_REQUIRES_CUSTOMER_NUMBER'; // fedex freight
    const AuthContractId = 'FEATURE_AUTHORIZATION_CONTRACT_ID'; // canada
    const HubId = 'FEATURE_HUB_ID'; // fedex
    const Dropoff = 'FEATURE_DROPOFF'; // fedex
    const AccountRates = 'FEATURE_ACCOUNT_RATES';
    const CommercialRates = 'FEATURE_COMMERCIAL_RATES'; // usps
    const ProductionMode = 'FEATURE_PRODUCTION_MODE';
    const Pickup = 'FEATURE_PICKUP'; // ups
    const MethodsDependOnShipperCountry = 'FEATURE_METHODS_DEPEND_ON_SHIPPER_COUNTRY'; // ups
    const MethodsDependOnUserId = 'FEATURE_METHODS_DEPEND_ON_USER_ID'; // easypost
    const OriginZip5Digits = 'FEATURE_ORIGIN_ZIP_5_DIGITS'; // usps
    const OriginZip6Alphanumeric = 'FEATURE_ORIGIN_ZIP_6_ALPHANUMERIC'; // canada
    const SenderTelephone10Digits = 'FEATURE_SENDER_TELEPHONE_10_DIGITS'; // usps
    const SenderTelephoneNotLonger15Digits = 'FEATURE_SENDER_TELEPHONE_NOT_LONGER_15_DIGITS'; // ups
    const ShippingLabel = 'FEATURE_SHIPPING_LABEL'; // usps, ups
    const ShippingLabel4x6Inches = 'FEATURE_SHIPPING_LABEL_4X6_INCHES'; // usps, ups
    const ShippingLabelVoid = 'FEATURE_SHIPPING_LABEL_VOID'; // ups
    const ShippingLabelRequiresCustomerNumber = 'FEATURE_SHIPPING_LABEL_REQUIRES_CUSTOMER_NUMBER'; // ups, canada
    const ExportFormatClickShip = 'FEATURE_EXPORT_FORMAT_CLICK_N_SHIP'; // usps
    const ExportFormatFedexAddressBook = 'FEATURE_EXPORT_FORMAT_FEDEX_ADDRESS_BOOK'; // fedex
    const PackerWeightBased = 'FEATURE_PACKER_WEIGHT_BASED'; // ups, auspost, canadapost, fedex, usps
    const WeightBasedFakedBox = 'FEATURE_WEIGHT_BASED_FAKED_BOX'; // usps, canada
    const FakedBoxRequiredForNonContractLabels = 'FEATURE_FAKED_BOX_REQUIRED_FOR_NON_CONTRACT_LABELS'; // canada
    const PromoCode = 'FEATURE_PROMO_CODE'; // canada
    const Webhook = 'FEATURE_WEBHOOK'; // easypost
    const WebhookApi = 'FEATURE_WEBHOOK_API'; // easypost
    const InvoiceByRequest = 'FEATURE_INVOICE_BY_REQUEST'; // ups, fedex
    const PaperlessByRequest = 'FEATURE_PAPERLESS_BY_REQUEST'; // ups, fedex
    const RecipientAddressType = 'FEATURE_RECIPIENT_ADDRESS_TYPE'; // ups, fedex, fedex freight, easypost
    const AddressValidation = 'FEATURE_ADDRESS_VALIDATION'; // ups, stamps
    const RequestAvoidWeekendDelivery = 'FEATURE_REQUEST_AVOID_WEEKEND_DELIVERY'; // stamps
    const TopUpBalance = 'FEATURE_TOP_UP_BALANCE'; // stamps
    const Signature = 'FEATURE_SIGNATURE'; // canada, ups, fedex, auspost
    const SignatureServiceDefault = 'FEATURE_SIGNATURE_SERVICE_DEFAULT'; // fedex
    const SignatureWithProofOfAge = 'FEATURE_SIGNATURE_WITH_PROOF_OF_AGE'; // canada, ups
    const ProofOfAge18 = 'FEATURE_PROOF_OF_AGE_18'; // canada
    const ProofOfAge19 = 'FEATURE_PROOF_OF_AGE_19'; // canada
    const ProofOfAgeAdult = 'FEATURE_PROOF_OF_AGE_ADULT'; // ups, fedex
    const SignatureTypes = 'FEATURE_SIGNATURE_TYPES'; // fedex
    const FreightClass = 'FEATURE_FREIGHT_CLASS'; // fedex freight
    const MinimumOrderWeight = 'FEATURE_MINIMUM_WEIGHT'; // fedex freight
    const PreferSatchels = 'FEATURE_PREFER_SATCHELS'; // auspost
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureChecker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureException;

class Debugger {
    const Trace = 'DEBUG_TYPE_TRACE';
    const Error = 'DEBUG_TYPE_ERROR';

    /** @var Configuration */
    private $configuration;
    /** @var Object */
    private $log;
    /** @var ShippingModule */
    private $module;

    /**
     * @param Configuration $configuration
     * @param Object $log
     * @param ShippingModule $module
     * @throws CoreFeatureException
     */
    public function __construct($configuration, $log, $module) {
        if (!$configuration instanceof Configuration) {
            throw new CoreFeatureException('Debug: incorrect configuration given');
        }
        if (!CoreFeatureChecker::hasMethod($log, 'write')) {
            throw new CoreFeatureException('Debug: incorrect logger given');
        }
        $this->configuration = $configuration;
        $this->log = $log;
        $this->module = $module;
    }

    /**
     * Writes to log depending on debug level
     * Argument 0 - debug type
     * Other - debug message data
     */
    public function debug() {
        $args = func_get_args();
        $debugType = array_shift($args);
        if ($this->configuration->get('debug') === Configuration::ShowNothingLogNothing) {
            return;
        }
        if (in_array(
            $this->configuration->get('debug'),
            array(Configuration::ShowNothingLogErrors, Configuration::ShowErrorsLogErrors),
            true
        )) { // log errors only
            if ($debugType !== Debugger::Error) {
                return;
            }
        }
        $result = array($this->module->getExtensionName() . ':');
        foreach ($args as $arg) {
            if (is_array($arg) or is_object($arg) or in_array($arg, array(true, false, null), true)) {
                $result[] = var_export($arg, true);
            } else {
                $result[] = $arg;
            }
        }
        $this->log->write(implode(' ', $result));
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureChecker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\FileManager;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Json;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\VersionChecker;

class Configuration {
    const DefaultStoreId = 0;
    const SharedSettingsModuleName = 'shared_settings_smart_flexible';
    const SharedSettingsModuleGroup = 'module';

    /** Value constants */
    const Packer3dPacker = 'PACKER-3D-PACKER';
    const PackerIndividual = 'PACKER-INDIVIDUAL';
    const PackerWeightBased = 'PACKER-WEIGHT-BASED';
    const PackerBoxMaker = 'PACKER-BOX-MAKER';
    const SortByPrice = 'SORT_BY_PRICE';
    const SortByTime = 'SORT_BY_TIME';
    const SortByPriceRegardlessChoices = 'SORT_BY_PRICE_REGARDLESS_CHOICES';
    const ImperialMeasures = 'IMPERIAL_MEASURES';
    const MetricMeasures = 'METRIC_MEASURES';
    const StatusEnabled = 'STATUS_ENABLED';
    const StatusDisabled = 'STATUS_DISABLED';
    const StatusOnlyForAdmin = 'STATUS_ONLY_FOR_ADMIN_REQUESTS';
    const MachinableTrue = 'MACHINABLE_TRUE';
    const MachinableFalse = 'MACHINABLE_FALSE';
    const MachinableAutomatic = 'MACHINABLE_AUTOMATIC';
    const FreightClassAutomatic = 'CLASS_AUTOMATIC';
    const DropoffBusinessServiceCenter = 'BUSINESS_SERVICE_CENTER';
    const DropoffDropBox = 'DROP_BOX';
    const DropoffRegularPickup = 'REGULAR_PICKUP';
    const DropoffRequestCourier = 'REQUEST_COURIER';
    const DropoffStation = 'STATION';
    const PickupDailyPickup = '01';
    const PickupCustomerCounter = '03';
    const PickupOneTimePickup = '06';
    const PickupLetterCenter = '19';
    const PickupAirServiceCenter = '20';
    const RetailRates = 'RETAIL_RATES';
    const CommercialRates = 'COMMERCIAL_RATES';
    const CommercialPlusRates = 'COMMERCIAL_PLUS_RATES';
    const CutoffDisabled = '';
    const SignatureRequired = 'SIGNATURE_REQUIRED';
    const SignatureNotRequired = 'SIGNATURE_NOT_REQUIRED';
    const DirectSignature = 'DIRECT_SIGNATURE';
    const IndirectSignature = 'INDIRECT_SIGNATURE';
    const ServiceDefault = 'SERVICE_DEFAULT';
    const AdultSignature = 'ADULT_SIGNATURE';
    const CustomerChooses = 'CUSTOMER_CHOOSES';
    const InsuranceEnabled = 'INSURANCE_ENABLED';
    const InsuranceDisabled = 'INSURANCE_DISABLED';
    const LabelDisabled = 'LABEL_DISABLED';
    const LabelAutomatically = 'LABEL_AUTOMATICALLY';
    const LabelManually = 'LABEL_MANUALLY';
    const TrackingNotSend = 'TRACKING-NOT-SEND';
    const TrackingSendImmediately = 'TRACKING-SEND-IMMIDIATELY';
    const TrackingSendShipped = 'TRACKING-SEND-SHIPPED';
    const LabelFormatOriginal = 'LABEL_ORIGINAL';
    const LabelFormat4x6 = 'LABEL_4x6';
    const PdfConverterImagick = 'PDF_CONVERTER_IMAGICK';
    const PdfConverterGmagick = 'PDF_CONVERTER_GMAGICK';
    const RecipientAddressTypeCommercial = 'RECIPIENT_ADDRESS_TYPE_COMMERCIAL';
    const RecipientAddressTypeResidential = 'RECIPIENT_ADDRESS_TYPE_RESIDENTIAL';
    const RecipientAddressTypeDependsOnCompany = 'RECIPIENT_ADDRESS_TYPE_DEPENDS_ON_COMPANY';
    const RecipientAddressTypeValidated = 'RECIPIENT_ADDRESS_TYPE_VALIDATED';
    const ShowNothingLogNothing = 'DEBUG_SHOW_NOTHING_LOG_NOTHING';
    const ShowNothingLogErrors = 'DEBUG_SHOW_NOTHING_LOG_ERRORS';
    const ShowNothingLogAll = 'DEBUG_SHOW_NOTHING_LOG_ALL';
    const ShowErrorsLogErrors = 'DEBUG_SHOW_ERRORS_LOG_ERRORS';
    const ShowErrorsLogAll = 'DEBUG_SHOW_ERROR_LOG_ALL';
    public static $imperialMeasuresCountries = array('US', 'MM', 'LR');
    public static $dateFormats = array('m/d/Y', 'd/m/Y', 'd.m.Y', 'j M Y');
    public static $measureSystems = array(self::ImperialMeasures, self::MetricMeasures);
    public static $signatures = array(
        self::SignatureRequired,
        self::SignatureNotRequired,
        self::CustomerChooses,
        self::ServiceDefault
    );
    public static $insurances = array(
        self::InsuranceEnabled,
        self::InsuranceDisabled,
        self::CustomerChooses
    );
    public static $signatureTypes = array(self::DirectSignature, self::IndirectSignature, self::AdultSignature);
    public static $labelOptions = array(self::LabelDisabled, self::LabelAutomatically, self::LabelManually);
    public static $labelOptionsEnabled = array(self::LabelAutomatically, self::LabelManually);
    public static $recipientAddressTypes = array(
        self::RecipientAddressTypeCommercial,
        self::RecipientAddressTypeResidential,
        self::RecipientAddressTypeDependsOnCompany,
        self::RecipientAddressTypeValidated
    );
    public static $debugLevels = array(Configuration::ShowNothingLogNothing, Configuration::ShowNothingLogErrors,
        Configuration::ShowNothingLogAll, Configuration::ShowErrorsLogErrors, Configuration::ShowErrorsLogAll);

    /** @var Object */
    private $config;
    /** @var Object model_setting_setting */
    private $modelSettingSetting;
    /** @var Object db */
    private $db;
    /** @var ShippingModule */
    private $module;
    /** @var int store id override */
    protected $storeId = null;
    /** @var bool */
    protected $isSharedSettingsInstalled = false;
    /** @var string[] All configuration keys */
    public static $keys = array('user_id', 'postcode', 'machinable', 'display_time', 'display_weight',
        'pounds_id', 'hubid', 'label', 'tax_class_id', 'inches_id', 'geo_zones', 'debug', 'status', 'sort_order',
        'minimum_rate', 'tracking', 'weight_adj_fix', 'weight_adj_per', 'dimension_adj_fix', 'rate_adj_fix',
        'rate_adj_per', 'cutoff', 'processing_days', 'prefix', 'sort_options', 'processing_saturdays',
        'processing_sundays', 'processing_holidays', 'all_geo_zones', 'custom_packages', 'promo', 'standard_packages',
        'packer', 'all_customer_groups', 'customer_groups', 'country_id', 'zone_id', 'city', 'equal_config',
        'address', 'residential', 'insurance', 'key', 'password', 'meter', 'dropoff', 'account_rates',
        'production', 'commercial_rates', 'methods', 'box_weight_adj_fix', 'date_format', 'measurement_system',
        'custom_envelopes', 'avoid_delivery_saturdays', 'avoid_delivery_sundays', 'label_format',
        'customer_number', 'contract_id', 'promo_code', 'insurance_from', 'individual_tare', 'status_for_customers',
        'weight_based_limit', 'pdf_converter', 'adjustment_rules', 'weight_based_faked_box', 'billing_same',
        'billing_country_id', 'billing_zone_id', 'billing_city', 'billing_postcode', 'billing_address',
        'product_names', 'product_countries', 'product_zones', 'product_hs_codes', 'invoice', 'paperless',
        'fallback_product_country', 'fallback_product_zone', 'fallback_product_hs_code', 'recipient_address_type',
        'balance_min', 'balance_inc', 'shipping_categories', 'shared_settings', 'signature', 'proof_of_age', 'pickup',
        'tracking_notify', 'signature_type', 'freight_class', 'minimal_order_weight', 'fallback_packer',
        'prefer_satchels', 'box_maker_weight_limit', 'box_maker_length', 'box_maker_width', 'box_maker_margin'
    );
    /** @var string[] Configuration keys that are common to all stores */
    public static $commonKeys = array('equal_config', 'product_names', 'product_countries', 'product_zones',
        'product_hs_codes');
    /** @var string[] Configuration keys that can shared among Smart and Flexible modules */
    public static $shareableKeys = array('custom_packages', 'custom_envelopes', 'shipping_categories', 'country_id',
        'zone_id', 'city', 'address', 'residential', 'postcode', 'processing_days', 'processing_saturdays',
        'processing_sundays', 'processing_holidays', 'cutoff', 'display_time', 'date_format', 'display_weight',
        'tax_class_id', 'all_geo_zones', 'geo_zones', 'all_customer_groups', 'customer_groups', 'sort_options',
        'box_weight_adj_fix', 'weight_adj_fix', 'weight_adj_per', 'dimension_adj_fix', 'rate_adj_fix', 'rate_adj_per',
        'minimum_rate', 'debug');
    /** @var array */
    private $defaultValues = array();

    /**
     * @param Object $config
     * @param Object $modelSettingSetting
     * @param Object $db
     * @param ShippingModule $module
     * @param string[] $installedModules
     * @throws ConfigurationException
     * @throws CoreFeatureException
     */
    public function __construct($config, $modelSettingSetting, $db, $module, $installedModules) {
        if (!CoreFeatureChecker::hasMethod($config, 'get')) {
            throw new CoreFeatureException('Can not find get method in config object');
        }
        if (!CoreFeatureChecker::hasMethod($config, 'set')) {
            throw new CoreFeatureException('Can not find set method in config object');
        }
        if (!($module instanceof ShippingModule)) {
            throw new ConfigurationException('Incorrect module given');
        }
        $this->config = $config;
        $this->modelSettingSetting = $modelSettingSetting;
        $this->db = $db;
        $this->module = $module;
        $this->storeId = (int)$this->config->get('config_store_id');
        $this->isSharedSettingsInstalled = in_array(self::SharedSettingsModuleName, $installedModules, true);
        $this->defaultValues = $this->module->getDefaultSettings();
        $this->applyEqualConfiguration();
        $this->applyBackwardsCompatibilityChanges();
    }

    /**
     * @return string[]
     */
    protected function getPrefixedCommonKeys() {
        return array_map(Array($this->module, 'getPrefixedName'), self::$commonKeys);
    }

    /**
     * @return string[]
     */
    protected function getPrefixedShareableKeys() {
        return array_map(Array($this->module, 'getPrefixedName'), self::$shareableKeys);
    }

    /**
     * @return string[]
     */
    protected function getPrefixedSharedKeys() {
        $result = array();
        foreach ($this->get('shared_settings') as $key => $value) {
            if ($value) {
                $result[] = $this->module->getPrefixedName($key);
            }
        }
        return $result;
    }

    /**
     * @param string $key
     * @return string
     */
    protected function changeKeyPrefixToShared($key) {
        return str_replace(
            (VersionChecker::get()->isVersion3() ? 'shipping_' : '') . $this->module->getExtensionName(),
            (VersionChecker::get()->isVersion3() ? (self::SharedSettingsModuleGroup . '_') : '') .
            self::SharedSettingsModuleName, $key
        );
    }

    /**
     * Replaces configuration values (saved in default store)
     * Used when front model loaded in non-default store
     * - for common settings only when equal_config = 0
     * - all settings when equal_config = 1
     * @since 18.07.2018 also called when changing store
     */
    protected function applyEqualConfiguration() {
        if ($this->getStoreId() === self::DefaultStoreId) {
            return;
        }
        $defaultStoreSettings = $this->modelSettingSetting->getSetting(
            (VersionChecker::get()->isVersion3() ? 'shipping_' : '') . $this->module->getExtensionName(),
            self::DefaultStoreId
        );
        if ((bool)(isset($defaultStoreSettings[$this->module->getPrefixedName('equal_config')]) ?
            $defaultStoreSettings[$this->module->getPrefixedName('equal_config')] :
            $this->defaultValues['equal_config'])
        ) {
            $keysToReplace = array_keys($defaultStoreSettings);
        } else {
            $keysToReplace = $this->getPrefixedCommonKeys();
        }
        foreach ($keysToReplace as $key) { // key is already prefixed
            $this->config->set($key, isset($defaultStoreSettings[$key]) ? $defaultStoreSettings[$key] : null);
        }
    }

    /**
     * Sets current store id and replaces config data (used in admin controller)
     * @param int $storeId
     * @return bool store was changed
     * @since 18.07.2018 also loads equal config
     */
    public function changeStore($storeId) {
        if ((int)$storeId === $this->getStoreId()) {
            return false;
        }
        $this->storeId = (int)$storeId;
        $data = $this->modelSettingSetting->getSetting(
            (VersionChecker::get()->isVersion3() ? 'shipping_' : '') . $this->module->getExtensionName(),
            $this->getStoreId()
        );
        $prefixedCommonKeys = $this->getPrefixedCommonKeys();
        foreach (self::$keys as $key) { // make empty module configuration
            if (!in_array($key, self::$commonKeys, true)) { // preserve common keys
                $this->set($key, null); // key is not prefixed
            }
        }
        foreach ($data as $key => $value) { // load configuration for particular store
            if (!in_array($key, $prefixedCommonKeys, true)) { // preserve common keys
                $this->config->set($key, $value); // key is already prefixed
            }
        }
        $this->applyEqualConfiguration();
        return true;
    }

    /**
     * Saves only equal_config master setting
     * Used in admin controller before reload
     * @param int $value
     */
    public function saveEqualConfigValue($value) {
        $group = (VersionChecker::get()->isVersion3() ? 'shipping_' : '') . $this->module->getExtensionName();
        $data = array($this->module->getPrefixedName('equal_config') => $value);
        $this->updateSettings($group, $data, self::DefaultStoreId);
    }

    /**
     * Saves only shared_settings value for current store
     * Used in admin controller before reload or save
     * @since 03.04.2018 also unset own setting value when it is shared
     * @param array $value [non-prefixed-key: bool]
     */
    public function saveSharedSettingsValue($value) {
        $group = (VersionChecker::get()->isVersion3() ? 'shipping_' : '') . $this->module->getExtensionName();
        $data = array($this->module->getPrefixedName('shared_settings') => $value);
        foreach ($value as $key => $b) {
            if ($b) {
                $data[$this->module->getPrefixedName($key)] = null;
            }
        }
        $this->updateSettings($group, $data, $this->getStoreId());
    }

    /**
     * Saves all settings for current store
     * Excludes common keys for non-default store
     * Saves shared settings when extension is installed
     * Keys must be prefixed
     * @param array $data
     */
    public function saveAll($data) {
        if ($this->getStoreId() !== self::DefaultStoreId) {
            $prefixedCommonKeys = $this->getPrefixedCommonKeys();
            foreach ($data as $key => $value) {
                if (in_array($key, $prefixedCommonKeys, true)) {
                    unset($data[$key]);
                }
            }
        }
        if ($this->getIsSharedSettingsInstalled()) {
            $prefixedShareableKeys = $this->getPrefixedShareableKeys();
            $prefixedSharedKeys = $this->getPrefixedSharedKeys();
            $sharedData = $this->modelSettingSetting->getSetting(
                (VersionChecker::get()->isVersion3() ? (self::SharedSettingsModuleGroup . '_') : '') .
                self::SharedSettingsModuleName, $this->getStoreId()
            );
            foreach ($data as $key => $value) {
                if (in_array($key, $prefixedShareableKeys, true)) {
                    if (in_array($key, $prefixedSharedKeys, true)) {
                        $data[$key] = null;
                        $sharedData[$this->changeKeyPrefixToShared($key)] = $value;
                    }
                }
            }
            $this->updateSettings(
                (VersionChecker::get()->isVersion3() ? (self::SharedSettingsModuleGroup . '_') : '') .
                self::SharedSettingsModuleName, $sharedData, $this->getStoreId()
            );
        }
        $this->updateSettings(
            (VersionChecker::get()->isVersion3() ? 'shipping_' : '') . $this->module->getExtensionName(),
            $data, $this->getStoreId()
        );
    }

    /**
     * @param string $group
     * @param array $data of updated settings
     * @param int $storeId
     * @todo delete on null?
     * @throws \Exception
     */
    public function updateSettings($group, $data, $storeId = self::DefaultStoreId) {
        $groupField = VersionChecker::get()->isVersion1() ? 'group' : 'code';
        foreach ($data as $key => $value) {
            $preparedValue = is_array($value) ? (
                VersionChecker::get()->isVersion1() || VersionChecker::get()->isVersion2LessThan21() ?
                    serialize($value) : Json::encode($value)
            ) : $value;
            $sql = 'UPDATE ' . DB_PREFIX . "setting SET `value` = '" . $this->db->escape($preparedValue) .
                "', serialized = '" . (int)is_array($value) . "' WHERE `" . $groupField . "` = '" .
                $this->db->escape($group) . "' AND `key` = '" . $this->db->escape($key) . "' AND store_id = '" .
                (int)$storeId . "'";
            $this->db->query($sql);
            $crc = $this->db->countAffected();
            if ($crc < 1) {
                $sql = 'DELETE FROM ' . DB_PREFIX . 'setting WHERE `' . $groupField . "` = '" .
                    $this->db->escape($group) . "' AND `key` = '" . $this->db->escape($key) . "' AND store_id = '" .
                    (int)$storeId . "'";
                $this->db->query($sql);
                $sql = 'INSERT INTO ' . DB_PREFIX . "setting SET store_id = '" . (int)$storeId . "', `" . $groupField .
                    "` = '" . $this->db->escape($group) . "', `key` = '" . $this->db->escape($key) . "', `value` = '" .
                    $this->db->escape($preparedValue) . "', serialized = '" . (int)is_array($value) . "'";
                $this->db->query($sql);
            }
        }
    }

    /**
     * Returns current store ID
     * @return int
     */
    public function getStoreId() {
        return $this->storeId;
    }

    /**
     * @return bool
     */
    public function getIsSharedSettingsInstalled() {
        return $this->isSharedSettingsInstalled;
    }

    /**
     * Proceeds compatibility operations
     */
    protected function applyBackwardsCompatibilityChanges() {
        $this->set('methods', $this->getShippingMethodsFromConfig());
        $this->set('processing_holidays', $this->getHolidaysFromConfig());
        $this->set('debug', $this->getDebugFromConfig());
        $this->set('label', $this->getLabelFromConfig());
        $this->set('signature', $this->getSignatureFromConfig());
        $this->set('insurance', $this->getInsuranceFromConfig());
        FileManager::moveStorageDir();
    }

    /**
     * Returns configuration value
     * Use default module settings if not defined
     * @since 15.11.2017 use default settings when default is array and empty string defined
     * @since 24.03.2018 gives priority to shared settings
     * @param string $key
     * @return mixed
     */
    public function get($key) {
        $storedValue = $this->config->get($this->module->getPrefixedName($key));
        if (
            $key !== 'shared_settings' &&
            $this->getIsSharedSettingsInstalled() &&
            in_array($key, self::$shareableKeys, true)
        ) { // enabled module and shareable key
            $sharedSettings = $this->get('shared_settings');
            if (isset($sharedSettings[$key]) && $sharedSettings[$key]) { // override
                $storedValue = $this->config->get($this->changeKeyPrefixToShared($this->module->getPrefixedName($key)));
            }
        }
        if ($storedValue === null) {
            if (isset($this->defaultValues[$key])) {
                return $this->defaultValues[$key];
            }
        }
        // fix empty string value when default setting is array
        if ($storedValue === '' && isset($this->defaultValues[$key]) && is_array($this->defaultValues[$key])) {
            return $this->defaultValues[$key];
        }
        return $storedValue;
    }

    /**
     * Set new configuration value
     * @since 13.03.2019 gives priority to shared settings
     * @param string $key
     * @param mixed $value
     */
    public function set($key, $value) {
        if (
            $key !== 'shared_settings' &&
            $this->getIsSharedSettingsInstalled() &&
            in_array($key, self::$shareableKeys, true)
        ) { // enabled module and shareable key
            $sharedSettings = $this->get('shared_settings');
            if (isset($sharedSettings[$key]) && $sharedSettings[$key]) { // override
                $this->config->set($this->changeKeyPrefixToShared($this->module->getPrefixedName($key)), $value);
                return;
            }
        }
        $this->config->set($this->module->getPrefixedName($key), $value);
    }

    /**
     * @param object $modelLocalisationCountry
     * @param null|int $overrideId Used in controller when new configuration values come
     * @return string|null
     */
    public function getOriginCountryCode($modelLocalisationCountry, $overrideId = null) {
        $countryId = $overrideId ?: $this->get('country_id');
        if ($countryId) {
            $originCountryInfo = $modelLocalisationCountry->getCountry($countryId);
            return isset($originCountryInfo['iso_code_2']) ? $originCountryInfo['iso_code_2'] : null;
        }
        return null;
    }

    /**
     * Returns configuration value of 'methods'
     * Has a backward compatibility to build array from separately stored methods
     * @return array
     */
    protected function getShippingMethodsFromConfig() {
        $storedArray = $this->get('methods');
        if (is_array($storedArray)) {
            $provider = $this->module->getRatesProvider();
            $provider->setOption('user_id', $this->get('user_id'));
            return $provider->ensureMethodsCompatibility($storedArray);
        }
        $result = array();
        foreach ($this->module->getRatesProvider()->getAllShippingMethods() as $fullKey) {
            $result[$fullKey] = $this->get($fullKey);
        }
        return $result;
    }

    /**
     * Returns configuration value of 'processing_holidays'
     * Has a backward compatibility to build array from lines of text
     * @return array
     */
    protected function getHolidaysFromConfig() {
        $storedArray = $this->get('processing_holidays');
        if (is_array($storedArray)) {
            return $storedArray;
        }
        if (trim($storedArray) === '') {
            return array();
        }
        return array_map(function($mmdd) {
            return array_map('intval', explode('/', $mmdd));
        }, explode("\n", $storedArray));
    }

    /**
     * Returns configuration value of 'debug'
     * Has a backward compatibility from integer values
     * @return string
     */
    protected function getDebugFromConfig() {
        $storedConst = $this->get('debug');
        if (in_array($storedConst, self::$debugLevels, true)) {
            return $storedConst;
        }
        $storedInteger = (int)$storedConst;
        switch ($storedInteger) {
            case 0:
                return self::ShowNothingLogNothing;
            case 1:
                return self::ShowNothingLogAll;
            case 2:
                return self::ShowErrorsLogAll;
            default:
                return isset($this->defaultValues['debug']) ? $this->defaultValues['debug'] :
                    self::ShowNothingLogErrors;
        }
    }

    /**
     * Returns configuration value for 'label'
     * Has a backward compatibility from integer values
     * @return string
     */
    protected function getLabelFromConfig() {
        $storedConst = $this->get('label');
        if (in_array($storedConst, self::$labelOptions, true)) {
            return $storedConst;
        }
        $storedInteger = (int)$storedConst;
        switch ($storedInteger) {
            case 0:
                return self::LabelDisabled;
            case 1:
                return self::LabelAutomatically;
            default:
                return isset($this->defaultValues['label']) ? $this->defaultValues['label'] :
                    self::LabelDisabled;
        }
    }

    protected function getSignatureFromConfig() {
        $storedValue = $this->get('signature');
        if (in_array($storedValue, self::$signatures, true)) {
            return $storedValue;
        }
        $storedInteger = (int)$storedValue;
        switch ($storedInteger) {
            case 0:
                return self::SignatureNotRequired;
            case 1:
                return self::SignatureRequired;
            default:
                return isset($this->defaultValues['signature']) ? $this->defaultValues['signature'] :
                    self::SignatureNotRequired;
        }
    }

    protected function getInsuranceFromConfig() {
        $storedValue = $this->get('insurance');
        if (in_array($storedValue, self::$insurances, true)) {
            return $storedValue;
        }
        $storedInteger = (int)$storedValue;
        switch ($storedInteger) {
            case 0:
                return self::InsuranceDisabled;
            case 1:
                return self::InsuranceEnabled;
            default:
                return isset($this->defaultValues['insurance']) ? $this->defaultValues['insurance'] :
                    self::InsuranceDisabled;
        }
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginPackage;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\SimpleModule;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Address;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\VersionChecker;

abstract class ShippingModule extends SimpleModule {
    /**
     * @return BaseRatesProvider
     */
    abstract public function getRatesProvider();

    /**
     * @return BaseLabelsProvider|null
     */
    abstract public function getLabelsProvider();

    /**
     * @return BaseValidationProvider|null
     */
    abstract public function getValidationProvider();

    /**
     * @return BasePaperlessProvider|null
     */
    abstract public function getPaperlessProvider();

    /**
     * @return ShippingVqmod|null
     */
    abstract public function getVqmod();

    /**
     * Returns default settings
     * Used in ShippingController and ShippingModel::getConfig()
     * @return array
     */
    public function getDefaultSettings() {
        return array(
            'equal_config' => 1,
            'status' => 1,
            'status_for_customers' => 1,
            'minimum_rate' => 1.00,
            'box_weight_adj_fix' => 0.00,
            'weight_adj_fix' => 0.00,
            'weight_adj_per' => 0.00,
            'dimension_adj_fix' => 0.00,
            'rate_adj_fix' => 0.00,
            'rate_adj_per' => 0.00,
            'processing_days' => 0,
            'cutoff' => Configuration::CutoffDisabled,
            'processing_saturdays' => 1,
            'processing_sundays' => 1,
            'processing_holidays' => array(),
            'geo_zones' => array(),
            'all_geo_zones' => 1,
            'custom_packages' => array(),
            'custom_envelopes' => array(),
            'promo' => array(),
            'standard_packages' => array(),
            'minimal_order_weight' => 0.00,
            'freight_class' => Configuration::FreightClassAutomatic,
            'debug' => Configuration::ShowErrorsLogErrors,
            'packer' => Configuration::PackerIndividual,
            'machinable' => Configuration::MachinableFalse,
            'display_time' => 1,
            'display_weight' => 1,
            'all_customer_groups' => 1,
            'customer_groups' => array(),
            'insurance' => Configuration::InsuranceDisabled,
            'dropoff' => Configuration::DropoffRegularPickup,
            'account_rates' => 0,
            'production' => 1,
            'sort_options' => Configuration::SortByPrice,
            'date_format' => Configuration::$dateFormats[0],
            'label' => Configuration::LabelDisabled,
            'label_format' => Configuration::LabelFormatOriginal,
            'pdf_converter' => Configuration::PdfConverterImagick,
            'tracking' => Configuration::TrackingSendShipped,
            'tracking_notify' => 1,
            'avoid_delivery_saturdays' => 0,
            'avoid_delivery_sundays' => 0,
            'measurement_system' => Configuration::ImperialMeasures,
            'residential' => 0,
            'individual_tare' => 1,
            'weight_based_limit' => 0,
            'product_names' => array(),
            'product_countries' => array(),
            'product_zones' => array(),
            'product_hs_codes' => array(),
            'adjustment_rules' => array(),
            'weight_based_faked_box' => array(),
            'billing_same' => 1,
            'invoice' => 0,
            'paperless' => 0,
            'recipient_address_type' => Configuration::RecipientAddressTypeDependsOnCompany,
            'balance_min' => 50,
            'balance_inc' => 50,
            'shipping_categories' => array(),
            'shared_settings' => array(),
            'signature' => Configuration::SignatureNotRequired,
            'proof_of_age' => 0,
            'signature_type' => Configuration::DirectSignature,
            'fallback_packer' => '',
            'prefer_satchels' => 0,
            'box_maker_length' => array('min' => 6, 'max' => 26),
            'box_maker_width' => 100,
            'box_maker_weight_limit' => 60,
            'box_maker_margin' => 1
        );
    }

    /** @return string */
    abstract public function getServiceName();

    /**
     * Returns argument prefixed with extension name
     * @param string $key
     * @return string
     */
    public function getPrefixedName($key) {
        return (VersionChecker::get()->isVersion3() ? 'shipping_' : '') . $this->getExtensionName() . '_' . $key;
    }

    /**
     * @param string $feature
     * @return bool
     */
    abstract public function hasFeature($feature);

    /**
     * Checks that given country requires also a zone to be defined
     * This method may be set in final module
     * default is US only
     * @param string $originCountryCode
     * @return bool
     */
    public function isCountryRequiresZone($originCountryCode) {
        return $originCountryCode === Address::UnitedStates;
    }

    /**
     * Returns currency code used to specify parcel value
     * This method can be replaced in final module
     * @since 13.10.2017 accepts origin country ISO-2 code to detect currency code (required for FedEx India)
     * @param string $originCountryCode
     * @return string
     */
    public function getValueCurrencyCode($originCountryCode) {
        return 'USD';
    }

    /**
     * Fix address (module specific)
     * @param array $address
     * @param object $modelCountry
     * @param object $modelZone
     * @return array
     * @throws ConfigurationException
     */
    public function fixAddress($address, $modelCountry, $modelZone) {
        return $address;
    }

    /**
     * @return string
     */
    public function getCustomPackageFixedType() {
        return OriginPackage::TypeBox;
    }

    /**
     * @return string
     */
    public function getCustomPackageExpandableType() {
        return OriginPackage::TypeEnvelope;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureChecker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\ItemList;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\OrientatedItem;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\PackedBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\PackedBoxList;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\Packer;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Fallback;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\OrderedBoxPacked;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\PackagingList;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\Shipment;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginExpandable;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginFixed;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginPackage;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\MultiPacker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerItem;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerItemConstrained;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerItemToPack;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerResult;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerResultBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\RotatedPacker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\SimpleSameItemPacker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\ValuableBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\WeightBasedPacker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Address;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Arrays;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\CurrencyConverter;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Number;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\PackagingData;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Square;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Time;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\VersionChecker;

class ShippingModel extends \Model {
    const AdminRequestFlagConst = 'SmartFlexible_isAdminRequest';
    /** @var ShippingModule */
    protected $module;
    /** @var BaseRatesProvider */
    protected $ratesProvider;
    /** @var null|BaseLabelsProvider */
    protected $labelsProvider;
    /** @var null|BaseValidationProvider */
    protected $validationProvider;
    /** @var null|BasePaperlessProvider */
    protected $paperlessProvider;
    /** @var Configuration */
    protected $configuration;
    /** @var Debugger */
    protected $debugger;
    /** @var CurrencyConverter */
    protected $converter;

    /**
     * @param mixed $registry
     * @param ShippingModule $module
     * @throws ConfigurationException
     * @throws CoreFeatureException
     */
    public function __construct($registry, $module) {
        parent::__construct($registry);
        $this->module = $module;
        $this->ratesProvider = $module->getRatesProvider();
        $this->labelsProvider = $module->getLabelsProvider();
        $this->validationProvider = $module->getValidationProvider();
        $this->paperlessProvider = $module->getPaperlessProvider();
        $this->load->model('setting/setting');
        if (CoreFeatureChecker::hasFrontModel('extension/extension')) { // v2
            $this->load->model('extension/extension');
            $installedModules = array_map(function ($row) {
                return $row['code'];
            }, $this->model_extension_extension->getExtensions(Configuration::SharedSettingsModuleGroup));
        } elseif (CoreFeatureChecker::hasFrontModel('setting/extension')) { // v1, v3
            $this->load->model('setting/extension');
            $installedModules = array_map(function ($row) {
                return $row['code'];
            }, $this->model_setting_extension->getExtensions(Configuration::SharedSettingsModuleGroup));
        } else {
            $installedModules = array();
        }
        $this->configuration = new Configuration(
            $this->config, $this->model_setting_setting, $this->db, $module, $installedModules
        );
        $this->debugger = new Debugger($this->configuration, $this->log, $this->module);
        $this->converter = new CurrencyConverter(Array($this->currency, 'convert'), $this->config);
    }

    /**
     * Returns customer currency code depending on engine version
     * @throws CoreFeatureException
     * @return string
     */
    protected function getCustomerCurrencyCode() {
        if (CoreFeatureChecker::hasProperty($this, 'currency') &&
            CoreFeatureChecker::hasMethod($this->currency, 'getCode')
        ) { // v1
            return $this->currency->getCode();
        } elseif (CoreFeatureChecker::hasProperty($this, 'session')) { // v2
            return $this->session->data['currency'];
        } else {
            throw new CoreFeatureException('Can not find customer currency object');
        }
    }

    /**
     * Sets options to Rates Provider from config by given array of keys
     * Keys will be prefixed
     * @param array $keys
     */
    public function setRatesProviderOptionsFromConfig($keys) {
        foreach ($keys as $key) {
            $this->ratesProvider->setOption($key, $this->configuration->get($key));
        }
    }

    /**
     * Sets options to Validation Provider from config by given array of keys
     * Keys will be prefixed
     * @param array $keys
     */
    public function setValidationProviderOptionsFromConfig($keys) {
        foreach ($keys as $key) {
            $this->validationProvider->setOption($key, $this->configuration->get($key));
        }
    }

    /**
     * Sets options to Paperless Provider from config by given array of keys
     * Keys will be prefixed
     * @param array $keys
     */
    public function setPaperlessProviderOptionsFromConfig($keys) {
        foreach ($keys as $key) {
            $this->paperlessProvider->setOption($key, $this->configuration->get($key));
        }
    }

    /**
     * Sets options to Labels Provider from config by given array of keys
     * Keys will be prefixed
     * @param array $keys
     */
    public function setLabelsProviderOptionsFromConfig($keys) {
        foreach ($keys as $key) {
            $this->labelsProvider->setOption($key, $this->configuration->get($key));
        }
    }

    /**
     * Create extension response
     * @param string $title
     * @param array $offers
     * @param string $error
     * @return array
     */
    public function createResponse($title, $offers, $error = null) {
        if (!is_array($offers)) {
            $offers = array();
        }
        if (in_array( // show empty response if debug level is ShowNothing
            $this->configuration->get('debug'), array(
                Configuration::ShowNothingLogErrors,
                Configuration::ShowNothingLogNothing,
                Configuration::ShowNothingLogAll
            ), true
        )) {
            $error = null;
        }
        if (count($offers) === 0 && !$error) {
            $this->debugger->debug(
                Debugger::Trace,
                'There were no rates and errors to show. Please check module settings.'
            );
            return array();
        }
        $offers = is_array($offers) ? $offers : array();
        return array(
            'code'       => $this->module->getExtensionName(),
            'title'      => $title,
            'quote'      => $offers,
            'sort_order' => $this->configuration->get('sort_order'),
            'error'      => (string)$error
        );
    }

    /**
     * Shorthand: Create extension response on error
     * @param string $text
     * @return array
     */
    public function createErrorResponse($text) {
        $this->debugger->debug(Debugger::Error, $text);
        return $this->createResponse($this->language->get('text_title'), array(), $text);
    }

    /**
     * @return bool
     */
    public function isModuleEnabledForCustomerRequests() {
        if (!$this->configuration->get('status_for_customers')) { // admin only
            if (defined(self::AdminRequestFlagConst)) {
                return true;
            }
            return false;
        }
        return true;
    }

    /**
     * Checks that we can ship to address
     * @param array $address
     * @return bool
     */
    public function isAddressShippable($address) {
        if ($this->configuration->get('all_geo_zones')) {
            return true;
        }
        if (is_array($this->configuration->get('geo_zones'))) {
            $allowedZones = array_keys(array_filter($this->configuration->get('geo_zones'), function ($v) {
                return (bool)$v;
            }));
            if (count($allowedZones)) {
                $query = $this->db->query('
                    SELECT * FROM ' . DB_PREFIX . 'zone_to_geo_zone
                    WHERE geo_zone_id IN (' . implode(', ', $allowedZones) . ')
                        AND country_id = \'' . (int)$address['country_id'] . '\'
                        AND (zone_id = \'' . (int)$address['zone_id'] . '\'
                        OR zone_id = \'0\')
                ');
                if ($query->num_rows) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * Checks that customer group is allowed to use this extension
     * @return bool
     */
    public function isCustomerGroupAllowed() {
        if ($this->configuration->get('all_customer_groups')) {
            return true;
        }
        $customerGroupId = $this->customer->getGroupId() ?: $this->config->get('config_customer_group_id');
        if (is_array($this->configuration->get('customer_groups'))) {
            $allowedGroups = array_keys(array_filter($this->configuration->get('customer_groups'), function ($v) {
                return (bool)$v;
            }));
            return in_array((int)$customerGroupId, $allowedGroups, true);
        }
        return false;
    }

    /**
     * @param array $products
     * @return bool
     */
    public function isOrderWeightLimitSatisfied($products) {
        if (!$this->module->hasFeature(Features::MinimumOrderWeight)) {
            return true;
        }
        $minimumOrderWeight = $this->configuration->get('minimal_order_weight');
        if (!$minimumOrderWeight) {
            return true;
        }
        $totalWeight = 0;
        foreach ($products as $product) {
            $totalWeight += $this->weight->convert(
                $product['weight'],
                $product['weight_class_id'],
                $this->configuration->get('pounds_id')
            );
        }
        return $totalWeight >= $minimumOrderWeight;
    }

    /**
     * Returns an array of custom fixed packages to attach to Packer
     * @param array $packagesData
     * @param float $maxWeight
     * @return PackerBox[]
     * @throws ConfigurationException
     */
    public function createCustomPackagesFixed($packagesData, $maxWeight) {
        $result = array();
        foreach ($packagesData as $id => $data) {
            $data['composed_id'] = OriginPackage::ComposedIdCustomFixed . OriginPackage::ComposedIdSeparator . $id;
            $data['type'] = $this->module->getCustomPackageFixedType();
            $data['title'] = 'Custom ' . OriginPackage::getCustomPackageTitle($data['type']);
            $data['code'] = $this->ratesProvider->getStandardPackageFixedDefaultCode();
            $data['dimensions_inside'] = array($data['length'], $data['width'], $data['height']);
            $data['dimensions_outside'] = $data['dimensions_inside'];
            if (isset($data['tare'])) {
                $data['tare'] = (float)$data['tare'] === 0.0 ? null : $data['tare'];
            }
            $data['density'] = OriginPackage::getCustomPackageDensity($data['type']);
            $package = OriginPackage::createFromArray($data);
            $result = array_merge($result, $package->generatePackerBoxes($maxWeight, null));
        }
        return $result;
    }

    /**
     * Returns an array of custom expandable packages to attach to Packer
     * @param array $packagesData
     * @param float $maxWeight
     * @param float|null $maxHeight
     * @return PackerBox[]
     * @throws ConfigurationException
     */
    public function createCustomPackagesExpandable($packagesData, $maxWeight, $maxHeight) {
        $result = array();
        foreach ($packagesData as $id => $data) {
            $data['composed_id'] = OriginPackage::ComposedIdCustomExpandable . OriginPackage::ComposedIdSeparator . $id;
            $data['type'] = $this->module->getCustomPackageExpandableType();
            $data['code'] = $this->ratesProvider->getStandardPackageExpandableDefaultCode();
            $data['title'] = 'Custom ' . OriginPackage::getCustomPackageTitle($data['type']);
            if (isset($data['tare'])) {
                $data['tare'] = (float)$data['tare'] === 0.0 ? null : $data['tare'];
            }
            $data['density'] = OriginPackage::getCustomPackageDensity($data['type']);
            $package = OriginPackage::createFromArray($data);
            $result = array_merge($result, $package->generatePackerBoxes($maxWeight, $maxHeight));
        }
        return $result;
    }

    /**
     * @param array $products Native array
     * @return bool
     */
    public function hasShippableItems($products) {
        foreach ($products as $product) {
            if (isset($product['shipping'])) {
                if ((bool)$product['shipping']) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * Returns cart total of shippable products only
     * @param array $products Native array
     * @return float total in system currency
     * @since 22.06.2019 ensures float zero return on empty cart
     */
    public function calculateShippableTotal($products) {
        $shippableProducts = array_filter($products, function($product) {
            return isset($product['shipping']) ? (bool)$product['shipping'] : false;
        });
        return (float)array_sum(array_map(function($product) {
            return isset($product['total']) ? $product['total'] : ($product['price'] * $product['quantity']);
        }, $shippableProducts));
    }

    /**
     * Returns products with categories
     * @param array $products Native array
     * @return array updated
     * @since 22.06.2019 handles empty cart
     * @see issue trello-127
     */
    public function getProductCategories($products) {
        if (!count($products)) {
            return $products;
        }
        $ids = array_map(function($product) {
            return (int)$product['product_id'];
        }, $products);
        $sql = 'SELECT product_id, GROUP_CONCAT(category_id SEPARATOR \',\') AS categories ' .
            'FROM ' . DB_PREFIX . 'product_to_category ' .
            'GROUP BY product_id ' .
            'HAVING product_id IN (' . implode(',', $ids) . ')';
        $rows = $this->db->query($sql)->rows;
        $categories = array();
        foreach ($rows as $row) {
            $categories[(int)$row['product_id']] = array_map('intval', explode(',', $row['categories']));
        }
        foreach ($products as $k => $product) {
            $products[$k]['categories'] = isset($categories[$product['product_id']]) ?
                $categories[$product['product_id']] : array();
        }
        return $products;
    }

    /**
     * Returns an array of products to attach to Packer
     * Warning: 'weight' - is the total weight for 'quantity' number of same items
     * Warning: 'price' - is the price for one item
     * @since 19.10.2016 product dimensions can be not defined when Packer is Weight Based
     * @since 04.08.2017 creates constrained items when max insurance value specified
     * @param array $products
     * @param float|null $maxInsuranceValue used for constrained items production
     * @param array|null $availShippingCategories from setting when pack 3d
     * @throws PackagingException
     * @throws ConfigurationException
     * @return PackerItemToPack[]
     */
    public function createItemsToPack($products, $maxInsuranceValue, $availShippingCategories) {
        $result = array();
        $constrainedItemLogic = null;
        $extensionName = $this->module->getExtensionName();
        $sharedSettings = $this->configuration->get('shared_settings');
        $areCustomPackagesShared = isset($sharedSettings['custom_packages']) ?
            $sharedSettings['custom_packages'] : false;
        $areCustomEnvelopesShared = isset($sharedSettings['custom_envelopes']) ?
            $sharedSettings['custom_envelopes'] : false;
        if ($availShippingCategories || $maxInsuranceValue) {
            $constrainedItemLogic = function (
                PackerItemConstrained $self,
                ItemList $alreadyPackedItems,
                PackerBox $box
            ) use (
                $maxInsuranceValue, $availShippingCategories, $extensionName,
                $areCustomPackagesShared, $areCustomEnvelopesShared
            ) {
                if ($maxInsuranceValue) {
                    $total = array_reduce($alreadyPackedItems->asArray(), function ($carry, PackerItem $item) {
                        return $carry + $item->getPrice();
                    }, 0);
                    if ($total + $self->getPrice() > $maxInsuranceValue) {
                        return false;
                    }
                }
                if ($availShippingCategories) {
                    $shippingCategories = $self->getShippingCategories();
                    $requiredCategories = array();
                    foreach ($shippingCategories as $id => $category) {
                        $boxComposedId = $extensionName . OriginPackage::ComposedIdSeparator .
                            $box->getOriginPackage()->getComposedId();
                        if (
                            ($areCustomPackagesShared && ($box->getOriginPackage() instanceof OriginFixed)) ||
                            ($areCustomEnvelopesShared && ($box->getOriginPackage() instanceof OriginExpandable))
                        ) {
                            $boxComposedId = OriginPackage::ComposedIdShared . OriginPackage::ComposedIdSeparator .
                                $box->getOriginPackage()->getComposedId();
                        }
                        if (isset($category['ship_together']) && $category['ship_together']) {
                            $requiredCategories[] = $id;
                        }
                        if (
                            isset($category['packages']) &&
                            !in_array(OriginPackage::ComposedIdAny, $category['packages'], true) &&
                            !in_array($boxComposedId, $category['packages'], true)
                        ) {
                            return false;
                        }
                    }
                    foreach ($alreadyPackedItems->asArray() as $packedItem) {
                        /** @var PackerItemConstrained $packedItem */
                        $packedItemShippingCategories = $packedItem->getShippingCategories();
                        if (count(array_diff($requiredCategories, array_keys($packedItemShippingCategories))) > 0) {
                            return false;
                        }
                        foreach ($packedItemShippingCategories as $id => $packedItemCategory) {
                            if (
                                isset($packedItemCategory['ship_together']) &&
                                $packedItemCategory['ship_together'] &&
                                empty($shippingCategories[$id])
                            ) {
                                return false;
                            }
                        }
                    }
                }
                return true;
            };
        }
        $customNames = $this->configuration->get('product_names');
        $originCountries = $this->configuration->get('product_countries');
        $originZones = $this->configuration->get('product_zones');
        $hsCodes = $this->configuration->get('product_hs_codes');
        $fallback = Fallback::create()
            ->setOriginCountryId($this->configuration->get('fallback_product_country'))
            ->setOriginZoneId($this->configuration->get('fallback_product_zone'))
            ->setHsCode($this->configuration->get('fallback_product_hs_code'));
        foreach ($products as $product) {
            if (!(bool)$product['shipping']) {
                continue;
            }
            if ($this->configuration->get('packer') === Configuration::PackerWeightBased) {
                $productLength = null;
                $productWidth = null;
                $productHeight = null;
            } else {
                if (!(float)$product['length']) {
                    throw new PackagingException('Length is not defined for item ' . $product['name']);
                }
                if (!(float)$product['width']) {
                    throw new PackagingException('Width is not defined for item ' . $product['name']);
                }
                if (!(float)$product['height']) {
                    throw new PackagingException('Height is not defined for item ' . $product['name']);
                }

                $dimensions = array($product['length'], $product['width'], $product['height']);
                rsort($dimensions, SORT_NUMERIC);
                list($product['length'], $product['width'], $product['height']) = $dimensions;

                $productLength = $this->length->convert(
                    $product['length'], $product['length_class_id'], $this->configuration->get('inches_id')
                );
                $productWidth = $this->length->convert(
                    $product['width'], $product['length_class_id'], $this->configuration->get('inches_id')
                );
                $productHeight = $this->length->convert(
                    $product['height'], $product['length_class_id'], $this->configuration->get('inches_id')
                );

                $productLength += $this->configuration->get('dimension_adj_fix');
                $productWidth += $this->configuration->get('dimension_adj_fix');
                $productHeight += $this->configuration->get('dimension_adj_fix');
            }

            if (!(float)$product['weight']) {
                throw new PackagingException('Weight is not defined for item ' . $product['name']);
            }

            $productWeight = $this->weight->convert(
                    $product['weight'], $product['weight_class_id'], $this->configuration->get('pounds_id')
                ) / $product['quantity'];

            $productWeight += $this->configuration->get('weight_adj_fix') +
                $productWeight * $this->configuration->get('weight_adj_per') / 100;

            $productOptions = array_map(function($option) {
                return $option['name'] . ': ' . (isset($option['value']) ? $option['value'] : $option['option_value']);
            }, isset($product['option']) ? $product['option'] : array());

            $productPrice = $this->converter->fromSystem($product['price'], $this->module->getValueCurrencyCode(
                $this->configuration->getOriginCountryCode($this->model_localisation_country)
            ));
            $shortName = isset($customNames[(int)$product['product_id']]) ?
                $customNames[(int)$product['product_id']] : null;
            $hsCode = isset($hsCodes[(int)$product['product_id']]) ?
                $hsCodes[(int)$product['product_id']] : $fallback->getHsCode();
            $originCountryId = isset($originCountries[(int)$product['product_id']]) ?
                $originCountries[(int)$product['product_id']] : $fallback->getOriginCountryId();
            $originZoneId = isset($originZones[(int)$product['product_id']]) ?
                $originZones[(int)$product['product_id']] : $fallback->getOriginZoneId();
            $shippingCategories = null;
            if ($availShippingCategories) {
                $shippingCategories = array_filter($availShippingCategories,
                    function ($shippingCategory) use ($product) {
                        return in_array((int)$product['product_id'], $shippingCategory['products'], true) ||
                        array_intersect($product['categories'], $shippingCategory['categories']);
                    }
                );
            }
            $constructorOptions = array(
                'id' => $product['product_id'],
                'description' => $product['name'],
                'short_description' => $shortName,
                'hs_code' => $hsCode,
                'origin_country_id' => $originCountryId,
                'origin_zone_id' => $originZoneId,
                'options' => $productOptions,
                'length' => $productLength,
                'width' => $productWidth,
                'height' => $productHeight,
                'weight' => $productWeight,
                'price' => $productPrice
            );
            if ($constrainedItemLogic) {
                $constructorOptions['logic'] = $constrainedItemLogic;
                $constructorOptions['shipping_categories'] = $shippingCategories;
            }
            $result[] = new PackerItemToPack(
                $constrainedItemLogic ?
                    new PackerItemConstrained($constructorOptions) : new PackerItem($constructorOptions),
                $product['quantity']
            );
        }
        return $result;
    }

    /**
     * Returns promo item to attach to Packer
     * Promo item depends on total cost
     * @param float $totalCost
     * @return PackerItemToPack[]
     */
    public function createPromoItemsToPack($totalCost) {
        $promos = array_filter($this->configuration->get('promo'), function($promo) use ($totalCost) {
            return $promo['min_cost'] <= $totalCost;
        });
        $promo = array_pop($promos);
        if ($promo) {
            $dimensions = array($promo['length'], $promo['width'], $promo['height']);
            rsort($dimensions, SORT_NUMERIC);
            list($promo['length'], $promo['width'], $promo['height']) = $dimensions;
            return array(
                new PackerItemToPack(new PackerItem(array(
                    'id' => null,
                    'description' => 'Promotional Items and Gifts',
                    'options' => array(),
                    'length' => $promo['length'],
                    'width' => $promo['width'],
                    'height' => $promo['height'],
                    'weight' => $promo['weight'],
                    'price' => 0
                )), 1)
            );
        }
        return array();
    }

    /**
     * Checks that item does not exceed service weight and insurance limits
     * @since 09.08.2017 accepts Max Insurance Value
     * @param PackerItem $item
     * @param float $maxWeight
     * @param float|null $maxInsuranceValue
     * @throws PackagingException
     * @return bool
     */
    public function checkItemExceedance($item, $maxWeight, $maxInsuranceValue) {
        if ($item->getWeight() > $maxWeight) {
            throw new PackagingException('Item ' . $item->getDescription() . ' exceeds the ' .
                'package weight limit of ' . $maxWeight . 'lb');
        }
        if ($maxInsuranceValue) {
            if ($item->getPrice() > $maxInsuranceValue) {
                throw new PackagingException('Item ' . $item->getDescription() . ' exceeds the ' .
                    'package insurance limit of ' . $maxInsuranceValue . ' ' . $this->module->getValueCurrencyCode(
                        $this->configuration->getOriginCountryCode($this->model_localisation_country)
                    ));
            }
        }
        return false;
    }

    /**
     * Use 3D Packer to pack items in available boxes
     * @since 16.11.2017 accepts products native array to prevent multiply DB queries
     * @param array $address
     * @param array $products
     * @param float $maxWeight
     * @param float|null $maxHeight
     * @param float|null $maxInsuranceValue
     * @throws PackagingException
     * @throws ConfigurationException
     * @return PackedBoxList[]
     */
    public function pack3D($address, $products, $maxWeight, $maxHeight, $maxInsuranceValue) {
        $result = array();
        $errors = array();
        $packagingVariants = $this->ratesProvider->getPackagingVariants(
            $address,
            $this->createCustomPackagesFixed($this->configuration->get('custom_packages'), $maxWeight),
            $this->createCustomPackagesExpandable($this->configuration->get('custom_envelopes'), $maxWeight, $maxHeight)
        );
        $allItems = array_merge(
            $this->createItemsToPack(
                $products, $maxInsuranceValue, $this->configuration->get('shipping_categories')
            ),
            $this->createPromoItemsToPack($this->cart->getSubTotal()) // before taxes, todo: constraint?
        );
        $totalQuantity = array_sum(array_map(function($itemToPack) {
            /** @var PackerItemToPack $itemToPack */
            return $itemToPack->getQuantity();
        }, $allItems));
        foreach ($packagingVariants as $allBoxes) {
            $packer = new MultiPacker(array(new SimpleSameItemPacker()));
            if ($totalQuantity < BaseRatesProvider::Packer3dSimplifyLimit) {
                $packer->addPackers(array(new Packer(), new RotatedPacker()));
            }
            $tareWeightInc = $this->configuration->get('box_weight_adj_fix');
            $allBoxes = array_map(function ($box) use ($tareWeightInc) {
                /** @var PackerBox $box */
                return $box->adjustTareWeight($tareWeightInc);
            }, $allBoxes);
            array_map(array($packer, 'addBox'), $allBoxes);
            /** @var PackerItemToPack $itemToPack */
            foreach ($allItems as $itemToPack) {
                $this->checkItemExceedance($itemToPack->getItem(), $maxWeight, $maxInsuranceValue);
                $packer->addItem($itemToPack->getItem(), $itemToPack->getQuantity());
            }
            try {
                $result[] = $packer->pack();
            } catch (\Exception $error) {
                $errors[] = $error;
            }
        }
        if ($result) {
            return $result;
        } else {
            $error = array_shift($errors);
            throw new PackagingException($error->getMessage(), $error->getCode(), $error);
        }
    }

    /**
     * Creates individual boxes for each item
     * Returns array with one set of packed boxes
     * @since 22.07.2016 considers tare (weight of carton)
     * @since 16.11.2017 accepts products native array to prevent multiply DB queries
     * @param array $products
     * @param float $maxWeight
     * @param float|null $maxInsuranceValue
     * @throws PackagingException
     * @throws ConfigurationException
     * @throws \Exception
     * @return PackedBoxList[]
     */
    public function packIndividual($products, $maxWeight, $maxInsuranceValue) {
        $packedBoxes = new PackedBoxList();
        $type = $this->module->getCustomPackageFixedType();
        /** @var PackerItemToPack $itemToPack */
        foreach ($this->createItemsToPack($products, $maxInsuranceValue, null) as $itemToPack) {
            $item = $itemToPack->getItem();
            $quantity = $itemToPack->getQuantity();
            $dimensions = array($item->getLength(), $item->getWidth(), $item->getHeight());
            $this->checkItemExceedance($item, $maxWeight, $maxInsuranceValue);
            for ($i = 0; $i < $quantity; $i++) {
                $originPackage = OriginPackage::createFromArray(array(
                    'id' => null,
                    'type' => $type,
                    'code' => $this->ratesProvider->getStandardPackageFixedDefaultCode(),
                    'title' => 'Individual Custom ' . OriginPackage::getCustomPackageTitle($type),
                    'image' => null,
                    'dimensions_outside' => $dimensions,
                    'dimensions_inside' => $dimensions,
                    'density' => $this->configuration->get('individual_tare') ?
                        OriginPackage::getCustomPackageDensity($type) : null,
                    'tare' => $this->configuration->get('individual_tare') ? null : 0
                ));
                /** @var PackerBox $box */
                $box = current($originPackage->generatePackerBoxes($maxWeight, null));
                $box = $box->adjustTareWeight($this->configuration->get('box_weight_adj_fix'));
                $itemsList = new ItemList();
                try {
                    $itemsList->insert($item);
                    $packedBoxes->insert(new PackedBox(
                        $box, $itemsList, 0, 0, 0, 0,
                        $item->getWidth(), $item->getLength(), $item->getDepth(), null
                    ));
                } catch (\Exception $e) {
                    throw new PackagingException('Heap internal error. ' . $e->getMessage());
                }
            }
        }
        return array($packedBoxes);
    }

    /**
     * Packs items by service weight limit only
     * This method use zero tare weight but it can be adjusted
     * @since 16.11.2017 accepts products native array to prevent multiply DB queries
     * @param array $products
     * @param float $maxWeight
     * @param float|null $maxInsuranceValue
     * @return PackedBoxList[]
     * @throws PackagingException
     * @throws ConfigurationException
     */
    public function packWeightBased($products, $maxWeight, $maxInsuranceValue) {
        $packer = new WeightBasedPacker();
        $originBox = new OriginBox(array(
            'composed_id' => OriginPackage::ComposedIdWeightBased,
            'code' => $this->ratesProvider->getStandardPackageFixedDefaultCode(),
            'title' => 'Weight-based Custom Box',
            'tare' => 0,
            'max_weight' => $this->configuration->get('weight_based_limit') ?: null
        ));
        /** @var PackerBox $box */
        $box = current($originBox->generatePackerBoxes($maxWeight, null));
        $box = $box->adjustTareWeight($this->configuration->get('box_weight_adj_fix'));
        $packer->addBox($box);
        foreach ($this->createItemsToPack($products, $maxInsuranceValue, null) as $itemToPack) {
            $item = $itemToPack->getItem();
            $quantity = $itemToPack->getQuantity();
            $this->checkItemExceedance($item, $maxWeight, $maxInsuranceValue);
            $packer->addItem($item, $quantity);
        }
        try {
            return array($packer->pack());
        } catch (\Exception $error) {
            throw new PackagingException($error->getMessage(), $error->getCode(), $error);
        }
    }

    /**
     * @param array $products
     * @param float $maxWeight
     * @param float|null $maxInsuranceValue
     * @return PackedBoxList[]
     * @throws ConfigurationException
     * @throws PackagingException
     */
    public function packBoxMaker($products, $maxWeight, $maxInsuranceValue) {
        $lengthSetting = $this->configuration->get('box_maker_length');
        $minLength = (float)$lengthSetting['min'];
        $maxLength = (float)$lengthSetting['max'];
        $widthRatio = (float)$this->configuration->get('box_maker_width') / 100;
        $margin = (float)$this->configuration->get('box_maker_margin');
        $grow = ($maxLength - $minLength) / BaseRatesProvider::BoxMakerSteps;
        $type = $this->module->getCustomPackageFixedType();
        $items = $this->createItemsToPack($products, $maxInsuranceValue, null);
        $totalQuantity = array_sum(array_map(function($itemToPack) {
            /** @var PackerItemToPack $itemToPack */
            return $itemToPack->getQuantity();
        }, $items));
        $packer = new MultiPacker(array(new SimpleSameItemPacker()));
        $packer->setCompareUsedVolume(true);
        if ($totalQuantity < BaseRatesProvider::Packer3dSimplifyLimit) {
            $packer3d = new Packer();
            $packerRotated = new RotatedPacker();
            $packer3d->setLastUnstableItemAllowed(false);
            $packerRotated->setLastUnstableItemAllowed(false);
            $packer->addPackers(array($packer3d, $packerRotated));
        }
        for ($step = 1; $step <= BaseRatesProvider::BoxMakerSteps; $step++) {
            $length = min($maxLength, $minLength + $step * $grow);
            $width = $length * $widthRatio;
            $height = $width;
            $dimensionsOutside = array($length, $width, $height);
            $dimensionsInside = array($length - 2 * $margin, $width - 2 * $margin, $height - 2 * $margin);
            $originPackage = OriginPackage::createFromArray(array(
                'id' => null,
                'type' => $type,
                'code' => $this->ratesProvider->getStandardPackageFixedDefaultCode(),
                'title' => 'Made ' . OriginPackage::getCustomPackageTitle($type),
                'image' => null,
                'dimensions_outside' => $dimensionsOutside,
                'dimensions_inside' => $dimensionsInside,
                'max_weight' => $this->configuration->get('box_maker_weight_limit') ?: null,
                'tare' => Weight::ofMaterial(Square::ofBoxSurface($dimensionsOutside), Weight::HardCartonDensity)
            ));
            $box = current($originPackage->generatePackerBoxes($maxWeight, null));
            $box = $box->adjustTareWeight($this->configuration->get('box_weight_adj_fix'));
            $packer->addBox($box);
        }
        foreach ($items as $item) {
            $packer->addItem($item->getItem(), $item->getQuantity());
        }
        try {
            $prepacked = iterator_to_array($packer->pack());
        } catch (\Exception $e) {
            throw new PackagingException($e->getMessage(), $e->getCode(), $e);
        }
        $result = new PackedBoxList();
        foreach ($prepacked as $packedBox) { // shrink down to used volume
            /**
             * @var PackedBox $packedBox
             * @var PackerBox $box
             */
            $box = $packedBox->getBox();
            $length = $packedBox->getUsedLength();
            $width = $packedBox->getUsedWidth();
            $height = $packedBox->getUsedDepth();
            $dimensionsInside = array($length, $width, $height);
            $dimensionsOutside = array($length + 2 * $margin, $width + 2 * $margin, $height + 2 * $margin);
            $originPackage = OriginPackage::createFromArray(array(
                'id' => $box->getOriginPackage()->getId(),
                'type' => $box->getOriginPackage()->getType(),
                'code' => $box->getOriginPackage()->getCode(),
                'title' => $box->getOriginPackage()->getTitle(),
                'image' => $box->getOriginPackage()->getImage(),
                'dimensions_outside' => $dimensionsOutside,
                'dimensions_inside' => $dimensionsInside,
                'max_weight' => $box->getOriginPackage()->getMaxWeight(),
                'tare' => Weight::ofMaterial(Square::ofBoxSurface($dimensionsOutside), Weight::HardCartonDensity)
            ));
            $box = new PackerBox(array(
                'dimensions_sort' => false, // important
                'dimensions_outside' => $dimensionsOutside,
                'dimensions_inside' => $dimensionsInside,
                'tare' => $originPackage->getTareWeight(),
                'max_weight' => $originPackage->getMaxWeight(),
                'origin' => $originPackage
            ));
            $box = $box->adjustTareWeight($this->configuration->get('box_weight_adj_fix'));
            try {
                $result->insert(
                    new PackedBox(
                        $box, $packedBox->getItems(),
                        0, 0, 0, 0,
                        $width, $length, $height, $packedBox->getPackagingMap()
                    )
                );
            } catch (\Exception $e) {
                throw new PackagingException($e->getMessage(), $e->getCode(), $e);
            }
        }
        return array($result);
    }

    /**
     * Packer switching method
     * @since 16.11.2017 accepts products native array to prevent multiply DB queries
     * @param array $address
     * @param array $products
     * @param float $maxWeight
     * @param float|null $maxHeight
     * @param float|null $maxInsuranceValue
     * @throws PackagingException
     * @throws ConfigurationException
     * @throws \Exception
     * @return PackedBox[][]
     * @since 10.04.2020 has optional fallback to individual packing mode
     */
    public function pack($address, $products, $maxWeight, $maxHeight, $maxInsuranceValue) {
        switch ($this->configuration->get('packer')) {
            case Configuration::Packer3dPacker:
                try {
                    $variants = $this->pack3D($address, $products, $maxWeight, $maxHeight, $maxInsuranceValue);
                } catch (\Exception $e) {
                    if ($this->configuration->get('fallback_packer') !== Configuration::PackerIndividual) {
                        throw $e;
                    }
                    $this->debugger->debug(
                        Debugger::Error,
                        'Fallback to individual packing mode due to error: ' . $e->getMessage()
                    );
                    $this->configuration->set('packer', Configuration::PackerIndividual);
                    $variants = $this->packIndividual($products, $maxWeight, $maxInsuranceValue);
                }
                break;
            case Configuration::PackerIndividual:
                $variants = $this->packIndividual($products, $maxWeight, $maxInsuranceValue);
                break;
            case Configuration::PackerWeightBased:
                $variants = $this->packWeightBased($products, $maxWeight, $maxInsuranceValue);
                break;
            case Configuration::PackerBoxMaker:
                $variants = $this->packBoxMaker($products, $maxWeight, $maxInsuranceValue);
                break;
            default:
                throw new PackagingException('Packer unknown or not defined');
        }
        // convert variants content: PackedBoxList (Heap) to Array
        return array_map('iterator_to_array', $variants);
    }

    /**
     * Prepares array of packed boxes data for further API requests
     * Calculates total weight of all boxes
     * @param PackedBox[] $packedBoxes
     * @return PackerResult
     */
    public function getPackerResult($packedBoxes) {
        $result = array();
        /** @var PackedBox $packedBox */
        foreach ($packedBoxes as $packedBox) {
            /**
             * @var PackerBox $boxType
             */
            $boxType = $packedBox->getBox();
            $itemsInTheBox = $packedBox->getItems()->asArray();
            $result[] = new PackerResultBox(
                $boxType, $packedBox->getWeight(), $itemsInTheBox, $packedBox->getPackagingMap()
            );
        }
        $this->debugger->debug(Debugger::Trace, 'Boxes:', $result);
        return new PackerResult($result);
    }

    /**
     * Checks that Rate delivery date is avoided by settings (saturday or sunday)
     * @param Rate $rate
     * @return bool
     */
    public function isRateDeliveryDateAvoided($rate) {
        if ($rate->isParticularDate()) {
            $weekday = intval(date('w', $rate->getTimeFrom()));
            if (($weekday === 6) && ($this->configuration->get('avoid_delivery_saturdays'))) {
                return true;
            }
            if (($weekday === 0) && ($this->configuration->get('avoid_delivery_sundays'))) {
                return true;
            }
        }
        return false;
    }

    /**
     * @param Rate[] $rates
     * @param array $address
     * @param PackerResult[] $packerResults
     * @return Rate[] Updated rates
     */
    public function avoidDeliveryOnWeekends($rates, $address, $packerResults) {
        $_this = $this;
        for ($iteration = 1; $iteration <= 2; $iteration++) {
            $restrictedRates = array_filter($rates, function ($rate) use ($_this) {
                return $_this->isRateDeliveryDateAvoided($rate);
            });
            if (count($restrictedRates)) {
                $shippingTime = $this->getShippingTime($this->getTime(), $iteration);
                $restrictedRatesHashes = array_map(function ($rate) {
                    /** @var Rate $rate */
                    return $rate->getComparisonIdWithHash();
                }, $restrictedRates);
                try {
                    $newRates = $this->ratesProvider->queryRates($address, $packerResults, $shippingTime);
                    $newRates = $this->applyDeliveryTimeAdjustment($newRates);
                    foreach ($newRates as $newRate) {
                        foreach ($rates as $k => $oldRate) {
                            if ($newRate->getComparisonIdWithHash() === $oldRate->getComparisonIdWithHash()) {
                                if (in_array($oldRate->getComparisonIdWithHash(), $restrictedRatesHashes, true)) {
                                    if (!$this->isRateDeliveryDateAvoided($newRate)) {
                                        $rates[$k] = $newRate;
                                    }
                                }
                            }
                        }
                    }
                } catch (\Exception $e) {
                    break; // limit reached
                }
            } else {
                break;
            }
        }
        return $rates;
    }

    /**
     * Sorts Rates
     * @param Rate[] $rates
     * @return Rate[] Sorted $rates
     */
    public function sortRates($rates) {
        $sortType = $this->configuration->get('sort_options');
        $_cache = array();
        $getMinPriceOfRatesByCode = function ($code) use ($rates, $_cache) {
            if (isset($_cache[$code])) {
                return $_cache[$code];
            }
            $filtered = array_filter($rates, function ($r) use ($code) {
                /** @var Rate $r */
                return $r->getMethodFullCode() === $code;
            });
            $result = min(array_map(function($r) {
                /** @var Rate $r */
                return $r->getCost();
            }, $filtered));
            $_cache[$code] = $result;
            return $result;
        };
        $sortFunc = function($a, $b) use ($sortType, $getMinPriceOfRatesByCode) {
            /**
             * @var Rate $a
             * @var Rate $b
             */
            switch ($sortType) {
                case Configuration::SortByPrice:
                    return $a->getCost() <= $b->getCost() ? -1 : 1;
                case Configuration::SortByTime:
                    if ($a->getTimeFrom() < $b->getTimeFrom()) {
                        if ($a->getTimeFrom() === null) {
                            return 1;
                        }
                        return -1;
                    } elseif ($a->getTimeFrom() === $b->getTimeFrom()) {
                        return $a->getTimeTo() <= $b->getTimeTo() ? -1 : 1;
                    } else {
                        if ($b->getTimeFrom() === null) {
                            return -1;
                        }
                        return 1;
                    }
                    // return (comment required by linter)
                case Configuration::SortByPriceRegardlessChoices:
                    if ($a->getMethodFullCode() === $b->getMethodFullCode()) {
                        return $a->getCost() <= $b->getCost() ? -1 : 1;
                    }
                    return $getMinPriceOfRatesByCode($a->getMethodFullCode()) <=
                        $getMinPriceOfRatesByCode($b->getMethodFullCode()) ? -1 : 1;
                default:
                    return 0;
            }
        };
        uasort($rates, $sortFunc);
        return $rates;
    }

    /**
     * For replacement in mock
     * @return int
     */
    public function getTime() {
        return time();
    }

    /**
     * @param int $now time()
     * @param int $extraDaysToAdd used for "avoid delivery on ..." options
     * @return int
     * @since 01.04.2020 takes into account max processing days. In case of shipping date exceeds service limit:
     *      - returns now
     *      - sets _delivery_time_adj_days (business days incl cutoff) to apply to all rates
     */
    public function getShippingTime($now, $extraDaysToAdd = 0) {
        $isCutOffPassed = Time::isTimePassed($now,
            $this->configuration->get('cutoff') === Configuration::CutoffDisabled ? null :
                $this->configuration->get('cutoff')
        );
        $daysToAdd = ($isCutOffPassed ? 1 : 0) + (int)$this->configuration->get('processing_days') + $extraDaysToAdd;
        $options = array(
            'date' => $now,
            'days' => $daysToAdd,
            'holidays' => $this->configuration->get('processing_holidays'),
            'skip_saturday' => $this->configuration->get('processing_saturdays'),
            'skip_sunday' => $this->configuration->get('processing_sundays')
        );
        $shippingTime = Time::addBusinessDays($options);
        $this->configuration->set('_delivery_time_adj_days', 0);
        if (($shippingTime - $now) / Time::DayLength > $this->ratesProvider->getMaxProcessingDays()) {
            $this->configuration->set('_delivery_time_adj_days', $daysToAdd);
            return $now;
        }
        return $shippingTime;
    }

    /**
     * Returns the total weight of packed boxes (may be variable)
     * @since 11.04.2020 does it based on rates instead of packing variants
     * @since 07.07.2020: do not call if $rates are empty
     * @param Rate[] $rates
     * @return string
     */
    public function getTotalWeight($rates) {
        $weights = array_map(function($rate) {
            /** @var Rate $rate */
            return $rate->getTotalBoxesWeight();
        }, $rates);
        $min = $this->weight->format(
            $this->weight->convert(
                min($weights),
                $this->configuration->get('pounds_id'),
                $this->config->get('config_weight_class_id')
            ), $this->config->get('config_weight_class_id')
        );
        $max = $this->weight->format(
            $this->weight->convert(
                max($weights),
                $this->configuration->get('pounds_id'),
                $this->config->get('config_weight_class_id')
            ), $this->config->get('config_weight_class_id')
        );
        return $min === $max ? $max : ($min . '—' . $max);
    }

    /**
     * Returns the total number of packed boxes (may be variable)
     * @since 11.04.2020 does it based on rates instead of packing variants
     * @since 07.07.2020: do not call if $rates are empty
     * @param Rate[] $rates
     * @return string
     */
    public function getBoxesCount($rates) {
        $boxesCount = array_map(function($rate) {
            /** @var Rate $rate*/
            return $rate->getNumberOfBoxes();
        }, $rates);
        $min = min($boxesCount);
        $max = max($boxesCount);
        return $min === $max ? (string)$max : ($min . '—' . $max);
    }

    /**
     * Changes adjustment settings using adjustment rules
     * @since 25.05.2017 prepares runtime configuration option for grouping rates
     * @since 16.09.2018 grouping is performed also taking into account customer choices
     * @since 16.09.2018 _grouping has format: [title:hash => [title, hashes[]]...]
     *                  where hashes — are comparison id with hashes (optional)
     * @param float $costInSystemCurrency
     * @param Rate $rate
     * @param float $totalInSystemCurrency
     */
    public function applyAdjustmentRules($costInSystemCurrency, $rate, $totalInSystemCurrency) {
        $grouping = $this->configuration->get('_grouping');
        if (!is_array($grouping)) {
            $grouping = array();
        }
        foreach ($this->configuration->get('adjustment_rules') as $rule) {
            if (($ruleCondition = $rule['condition']) && is_array($rule['actions'])) {
                if ($ruleCondition['conditions'] && is_array($ruleCondition['conditions'])) {
                    $areSatisfied = true;
                    foreach ($ruleCondition['conditions'] as $condition) {
                        $isSatisfied = true;
                        if ($condition['type'] === 'comparison') {
                            switch ($condition['argument']) {
                                case 'rate':
                                    $argument = $costInSystemCurrency;
                                    break;
                                case 'total':
                                    $argument = $totalInSystemCurrency;
                                    break;
                                default:
                                    $argument = null;
                            }
                            if ($argument) {
                                switch ($condition['operator']) {
                                    case 'gt':
                                        $isSatisfied = $argument > $condition['value'];
                                        break;
                                    case 'gte':
                                        $isSatisfied = $argument >= $condition['value'];
                                        break;
                                    case 'eq':
                                        $isSatisfied = (float)$argument === (float)$condition['value'];
                                        break;
                                    case 'lte':
                                        $isSatisfied = $argument <= $condition['value'];
                                        break;
                                    case 'lt':
                                        $isSatisfied = $argument < $condition['value'];
                                        break;
                                    default:
                                        $isSatisfied = false;
                                }
                            } else {
                                $isSatisfied = false;
                            }
                        } elseif ($condition['type'] === 'services') {
                            $isSatisfied = in_array($rate->getMethodFullCode(), $condition['services'], true) ||
                                in_array('', $condition['services'], true); // or any service
                        }
                        if ($ruleCondition['type'] === 'logical') {
                            if ($ruleCondition['operator'] === 'and') {
                                $areSatisfied = $areSatisfied && $isSatisfied;
                            } elseif ($ruleCondition['operator'] === 'or') {
                                $areSatisfied = $areSatisfied || $isSatisfied;
                            }
                        }
                    }
                    if ($areSatisfied) {
                        foreach ($rule['actions'] as $action) {
                            switch ($action['type']) {
                                case 'rateFixed':
                                    $this->configuration->set('rate_adj_fix', $action['value']);
                                    break;
                                case 'ratePercent':
                                    $this->configuration->set('rate_adj_per', $action['value']);
                                    break;
                            }
                        }
                        if (isset($rule['grouping'])) {
                            $groupCode = $rule['grouping']['title'] . ':' . $rate->getHashOfCustomerChoice();
                            if (!isset($grouping[$groupCode])) {
                                $grouping[$groupCode] = array(
                                    'title' => $rule['grouping']['title'],
                                    'hashes' => array()
                                );
                            }
                            array_push($grouping[$groupCode]['hashes'], $rate->getComparisonIdWithHash());
                        }
                    }
                }
            }
        }
        $this->configuration->set('_grouping', $grouping);
    }

    /**
     * Performs grouping rates using runtime configuration
     * @since 24.11.2017 uses cost before adjustment in system currency to detect cheapest rate
     * @param Rate[] $rates
     * @return Rate[]
     */
    public function applyGroupingRates($rates) {
        $protectedHashes = array();
        uasort($rates, function($a, $b) { // issue #318: presort rates using cost before adj in system currency
            /**
             * @var Rate $a
             * @var Rate $b
             */
            return $a->getCostBeforeAdjustmentInSystemCurrency() <= $b->getCostBeforeAdjustmentInSystemCurrency() ?
                -1 : 1;
        });
        if (is_array($this->configuration->get('_grouping'))) {
            foreach ($this->configuration->get('_grouping') as $groupCode => $groupData) {
                /** @var Rate|null $minRate */
                $minRate = null;
                foreach ($rates as $k => $rate) {
                    if (
                        in_array($rate->getComparisonIdWithHash(), $groupData['hashes'], true) &&
                        !in_array($rate->getComparisonIdWithHash(), $protectedHashes, true)
                    ) {
                        if (!$minRate) {
                            $minRate = $rate;
                        } elseif ($rate->getCost() < $minRate->getCost()) {
                            $minRate = $rate;
                        }
                        unset($rates[$k]);
                    }
                }
                if ($minRate) {
                    $minRate->setTitle($groupData['title'])->setIsTitleEncoded(false); // predefined in grouping rule
                    array_push($protectedHashes, $minRate->getComparisonIdWithHash());
                    array_push($rates, $minRate);
                }
            }
        }
        return $rates;
    }

    /**
     * Uses _delivery_time_adj_days value previously set by getShippingTime() to adjust rates
     * @param Rate[] $rates
     * @return Rate[] updated
     */
    public function applyDeliveryTimeAdjustment($rates) {
        $shiftDays = (int)$this->configuration->get('_delivery_time_adj_days');
        if ($shiftDays === 0) {
            return $rates;
        }
        foreach ($rates as $k => $rate) {
            if ($rate->isParticularDate()) {
                $options = array( // 'date' will be set below
                    'days' => $shiftDays,
                    'holidays' => $this->configuration->get('processing_holidays'),
                    'skip_saturday' => $this->configuration->get('processing_saturdays'),
                    'skip_sunday' => $this->configuration->get('processing_sundays')
                );
                $rates[$k] = $rate->setTimeFrom( // can not be null here
                    Time::addBusinessDays(array_merge(
                        $options, array('date' => $rate->getTimeFrom())
                    ))
                )->setTimeTo(
                    Time::addBusinessDays(array_merge(
                        $options, array('date' => $rate->getTimeTo())
                    ))
                );
            } elseif ($rate->isDateInterval()) {
                $rates[$k] = $rate->setTimeFrom( // can be null here
                    $rate->getTimeFrom() === null ? null : $rate->getTimeFrom() + $shiftDays
                )->setTimeTo($rate->getTimeTo() + $shiftDays);
            }
        }
        return $rates;
    }

    /**
     * Returns options, that according to configuration may be selectable by customer,
     * so being set to provider in the "last mile" of code execution.
     * Each option comes with variants of its values.
     * Selectable option has more than one value.
     * May be empty since being related to module features
     * @param bool $shouldInsuranceBeIncluded
     * @return array[] as [key => [variants]]
     * @since 12.04.2020 also operates insurance
     */
    public function getLastMileOptions($shouldInsuranceBeIncluded) {
        $options = array();
        if ($this->module->hasFeature(Features::Insurance)) {
            switch ($this->configuration->get('insurance')) {
                case Configuration::InsuranceEnabled:
                    $options['insurance'] = array($shouldInsuranceBeIncluded);
                    break;
                case Configuration::CustomerChooses:
                    $options['insurance'] = $shouldInsuranceBeIncluded ? array(true, false) : array(false);
                    break;
                case Configuration::InsuranceDisabled:
                default:
                    $options['insurance'] = array(false);
            }
        }
        if ($this->module->hasFeature(Features::Signature)) {
            switch ($this->configuration->get('signature')) {
                case Configuration::SignatureRequired:
                    $options['signature'] = array(true);
                    break;
                case Configuration::CustomerChooses:
                    $options['signature'] = array(true, false);
                    break;
                case Configuration::ServiceDefault:
                    $options['signature'] = array(null);
                    break;
                case Configuration::SignatureNotRequired:
                default:
                    $options['signature'] = array(false);
            }
        }
        return $options;
    }

    /**
     * Entry point method for rates
     * @since 22.11.2016 sets insurance option to rates provider
     * @param array $address
     * @throws \Exception
     * @return array
     */
    public function getQuote($address) {
        $this->language->load(
            (VersionChecker::get()->isVersion3() ? 'extension/' : '') .
            'shipping/' . $this->module->getExtensionName()
        );
        try {
            $address = Address::fixAddress($address, $this->session, $this->customer);
            $address = $this->module->fixAddress(
                $address, $this->model_localisation_country, $this->model_localisation_zone
            );
        } catch (\Exception $error) {
            return $this->createErrorResponse($error->getMessage());
        }

        if (!$this->isModuleEnabledForCustomerRequests()) {
            return $this->createErrorResponse('This shipping method is not enabled for customers');
        }
        if (array_sum($this->configuration->get('methods')) === 0) {
            return $this->createErrorResponse('No options enabled (configuration)');
        }
        if (!$this->isAddressShippable($address)) {
            return $this->createErrorResponse('Delivery to your Geo Zone is not enabled');
        }
        if (!$this->isCustomerGroupAllowed()) {
            return $this->createErrorResponse('This shipping method is not enabled for your group');
        }

        $maxWeight = $this->ratesProvider->getPackageMaxWeight($address);
        if (Number::floatsAreEqual($maxWeight, 0)) {
            return $this->createErrorResponse('Delivery to this address is not available (API)');
        }
        $maxHeight = $this->ratesProvider->getPackageExpandableMaxHeight();
        $products = $this->cart->getProducts(); // issue #315, prevent multiple DB queries
        if (!count($products)) { // issue trello-127
            return $this->createErrorResponse('Cart is empty');
        }
        if (!$this->isOrderWeightLimitSatisfied($products)) {
            return $this->createErrorResponse('Order weight does not satisfy minimal order weight');
        }
        $products = $this->getProductCategories($products);
        $hasShippableItems = $this->hasShippableItems($products);
        if (!$hasShippableItems) { // issue trello-127, gif vouchers
            return $this->createErrorResponse('No shippable products in cart');
        }
        $shippableTotal = $this->calculateShippableTotal($products);
        $canInsuranceBeIncluded = ValuableBox::canInsuranceBeIncluded( // using shippable total in system currency
            $shippableTotal, null, $this->configuration, null, null
        );
        $maxInsuranceValue = $canInsuranceBeIncluded ?
            $this->ratesProvider->getPackageMaxInsuranceValue($address) : null;
        $shippingTime = $this->getShippingTime($this->getTime());
        $fixedAdjustmentInitial = $this->configuration->get('rate_adj_fix');
        $percentAdjustmentInitial = $this->configuration->get('rate_adj_per');

        try {
            // get packaging variants
            $packedBoxesVariants = $this->pack($address, $products, $maxWeight, $maxHeight, $maxInsuranceValue);
            $packerResults = array_map(Array($this, 'getPackerResult'), $packedBoxesVariants);

            // recipient address type
            if ($this->module->hasFeature(Features::RecipientAddressType)) {
                if ($this->validationProvider) {
                    $this->validationProvider->setDebugger(Array($this->debugger, 'debug'));
                }
                $address['is_residential'] = Address::isAddressResidential(
                    $address, $this->configuration, $this->validationProvider
                );
                $this->debugger->debug(Debugger::Trace, 'Residential address:', $address['is_residential']);
            }

            // set up rates provider
            /** @var PackerResult $firstPackerResult */
            $this->ratesProvider->setOption('value_currency_code', $this->module->getValueCurrencyCode(
                $this->configuration->getOriginCountryCode($this->model_localisation_country)
            ));
            $this->ratesProvider->setDebugger(Array($this->debugger, 'debug'));

            // set up last mile options and query rates
            $lastMileOptions = $this->getLastMileOptions($canInsuranceBeIncluded);
            $selectableOptions = array_keys(array_filter($lastMileOptions, function($variants) {
                return count($variants) > 1;
            }));
            $combinationsOfOptions = Arrays::getCombinations($lastMileOptions); // may be empty array
            if (count($combinationsOfOptions) === 0) { // no last mile options
                $rates = $this->ratesProvider->queryRates($address, $packerResults, $shippingTime);
            } else { // with last mile options cycle
                $rates = array();
                foreach ($combinationsOfOptions as $options) {
                    foreach ($options as $key => $value) {
                        $this->ratesProvider->setOption($key, $value);
                    }
                    $fetchedRates = $this->ratesProvider->queryRates($address, $packerResults, $shippingTime);
                    foreach ($fetchedRates as $rate) { // save selectable options for this rate
                        $rates[] = $rate->setCustomerChoice(array_intersect_key(
                            $options, array_fill_keys($selectableOptions, true)
                        ));
                    }
                }
            }
            // second possible tier of shippingTime
            $rates = $this->applyDeliveryTimeAdjustment($rates);

            // check avoid delivery on saturdays/sundays, combine with additional rates requests
            // since 05.02.2018 there is a feature to disable this, when it supported by API
            if (!$this->module->hasFeature(Features::RequestAvoidWeekendDelivery)) {
                $rates = $this->avoidDeliveryOnWeekends($rates, $address, $packerResults);
            }

            $quotes = array();
            foreach ($rates as $rate) { // apply adjustment rules and collect grouping
                $costInSystemCurrency = $this->converter->toSystem($rate->getCost(), $rate->getCurrencyCode());
                $rate->setCostBeforeAdjustmentInSystemCurrency($costInSystemCurrency); // issue #318
                $this->configuration->set('rate_adj_fix', $fixedAdjustmentInitial);
                $this->configuration->set('rate_adj_per', $percentAdjustmentInitial);
                $this->applyAdjustmentRules($costInSystemCurrency, $rate, $shippableTotal);
                $costInSystemCurrency = Number::adjust(
                    $costInSystemCurrency,
                    $this->configuration->get('rate_adj_fix'),
                    $this->configuration->get('rate_adj_per')
                );
                $costInSystemCurrency = max($costInSystemCurrency, $this->configuration->get('minimum_rate'));
                $costInSystemCurrency = round($costInSystemCurrency, 2, PHP_ROUND_HALF_UP);
                $rate->setCost($costInSystemCurrency)->setCurrencyCode($this->converter->getSystemCurrency());
            }

            // apply grouping
            $rates = $this->applyGroupingRates($rates);

            // sort rates
            $rates = $this->sortRates($rates);

            foreach ($rates as $rate) { // decode titles and build quotes
                $finalId = $rate->getIdForEcommerceSystem();
                if ($rate->getIsTitleEncoded()) {
                    $decodedTitle = $this->language->get('text_' . $rate->getTitle());
                    if ($decodedTitle && $decodedTitle !== 'text_' . $rate->getTitle()) {
                        $rate->setTitle($decodedTitle);
                    }
                }
                $titleClean = $rate->getTitle();
                if (count($rate->getCustomerChoice())) {
                    $suffixes = array();
                    foreach ($rate->getCustomerChoice() as $key => $value) {
                        $suffix = $this->language->get('text_option_' . $key . '_' . (string)(int)$value);
                        if ($suffix) { // can be empty
                            $suffixes[] = $suffix;
                        }
                    }
                    if (count($suffixes)) {
                        $rate->setTitle($rate->getTitle() . ', ' . implode(', ', $suffixes));
                    }
                }
                if ($this->configuration->get('display_time')) {
                    $eta = null;
                    if ($rate->isParticularDate()) {
                        $eta = date($this->configuration->get('date_format'), $rate->getTimeFrom());
                    } elseif ($rate->isDateInterval()) {
                        $eta = ($rate->getTimeFrom() ? $rate->getTimeFrom() . ' — ' : '') . $rate->getTimeTo() . ' ' .
                            $this->language->get('text_business_days');
                    }
                    if ($eta) {
                        $rate->setTitle(
                            $rate->getTitle() . ' (' . $this->language->get('text_eta') . ' ' . $eta . ')'
                        );
                    }
                }
                $quotes[$finalId] = array( // key is important!
                    'code' => $this->module->getExtensionName() . '.' . $finalId,
                    'title' => ($this->configuration->get('prefix') ?
                            $this->configuration->get('prefix') . ' ' : '') . $rate->getTitle(),
                    'cost' => $rate->getCost(),
                    'tax_class_id' => $this->configuration->get('tax_class_id'),
                    'text' => $this->currency->format( // (and convert) using user currency
                        $this->tax->calculate( // using system currency
                            $rate->getCost(),
                            $this->configuration->get('tax_class_id'),
                            $this->config->get('config_tax')
                        ), $this->getCustomerCurrencyCode()
                    ),
                    'count' => count($rate->getBoxes()), // for debugging reasons
                    'id' => $finalId, // for debugging reasons
                    'time_from' => $rate->getTimeFrom(), // for debugging reasons
                    'time_to' => $rate->getTimeTo(), // for debugging reasons
                    'packaging_data' => PackagingData::encode(
                        array_map(
                            function($box) {
                                /** @var PackerResultBox $box */
                                return $box->toOrdered()->toArray();
                            },
                            $rate->getBoxes()
                        )
                    ),
                    'id_clean' => $rate->getForeignId() ?: $rate->getId(), // easypost
                    'title_clean' => $titleClean,
                    'customer_choice' => $rate->getCustomerChoice()
                );
            }
            $title = $this->language->get('text_title');
            if ($this->configuration->get('display_weight') && count($rates)) {
                // calculate total weight and boxes count
                $totalWeight = $this->getTotalWeight($rates);
                $boxesCount = $this->getBoxesCount($rates);
                $title .= ' (' . $this->language->get('text_weight') . ' ' .
                    $totalWeight . ', ' . $this->language->get('text_boxes') . ' ' . $boxesCount . ')';
            }
            $response = $this->createResponse($title, $quotes);
            $this->debugger->debug(Debugger::Trace, 'Quote:', $response);
        } catch (\Exception $error) {
            return $this->createErrorResponse($error->getMessage());
        }
        return $response;
    }

    /**
     * Entry point for packaging list, labels and tracking numbers
     * @param int $orderId
     * @param array $packagingData serialized OrderedBoxPacked[]. See ShippingModel::getQuote()::packaging_data
     * @param array $address
     * @param string $methodCode See ShippingModel::getQuote()::id_clean (original method code)
     * @param string $methodName See ShippingModel::getQuote()::title_clean
     * @param array $customerChoice See ShippingModel::getQuote()::customer_choice
     * @return bool
     */
    public function createPackagingList($orderId, $packagingData, $address, $methodCode, $methodName, $customerChoice) {
        $this->debugger->debug(Debugger::Trace, 'Creating Packaging List for order #' . $orderId);
        $this->debugger->debug(Debugger::Trace, 'Packing data: ', $packagingData);
        $this->debugger->debug(Debugger::Trace, 'Method: ', $methodCode, $methodName);
        $this->debugger->debug(Debugger::Trace, 'Address: ', $address);
        $this->debugger->debug(Debugger::Trace, 'Last mile customer choice: ', $customerChoice);
        $fallback = Fallback::create()
            ->setOriginCountryId($this->configuration->get('fallback_product_country'))
            ->setOriginZoneId($this->configuration->get('fallback_product_zone'))
            ->setHsCode($this->configuration->get('fallback_product_hs_code'));
        $shipments = array_map(function($box) use ($fallback) {
            return Shipment::create()->setBox(OrderedBoxPacked::createFromArray($box, $fallback));
        }, $packagingData);
        $packagingList = new PackagingList(array(
            'order_id' => $orderId,
            'service_name' => $this->module->getServiceName(),
            'version' => $this->module->getVersion(),
            'method_code' => $methodCode,
            'address' => $address,
            'method_name' => $methodName,
            'customer_choice' => $customerChoice,
            'shipments' => $shipments
        ));
        if (!PackagingListManager::save($packagingList)) {
            $this->debugger->debug(Debugger::Error, 'Packaging list: Can not save file');
            return false;
        }
        return true;
    }

    /**
     * @param int $orderId
     * @return null|PackagingList
     */
    public function requestLabels($orderId) {
        if ($this->configuration->get('label') !== Configuration::LabelAutomatically) {
            return null;
        }
        $this->debugger->debug(Debugger::Trace, 'Requesting labels for order #' . $orderId);
        try {
            return PackagingListManager::requestLabels(
                $orderId, null, $this->module, Array($this->debugger, 'debug'), $this->validationProvider,
                $this->labelsProvider, $this->paperlessProvider, $this->configuration, $this->converter,
                Array('country' => $this->model_localisation_country, 'zone' => $this->model_localisation_zone)
            );
        } catch (\Exception $error) {
            $this->debugger->debug(Debugger::Error, $error->getMessage());
            return null;
        }
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\VersionChecker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureChecker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;

class ShippingAdminModel extends \Model {
    /** @var ShippingModule */
    protected $module;
    /** @var BaseRatesProvider */
    protected $ratesProvider;
    /** @var BaseLabelsProvider */
    protected $labelsProvider;
    /** @var Configuration */
    protected $configuration;
    /** @var Debugger */
    protected $debugger;

    /**
     * @param mixed $registry
     * @param ShippingModule $module
     * @throws CoreFeatureException
     * @throws ConfigurationException
     */
    public function __construct($registry, $module) {
        parent::__construct($registry);
        $this->module = $module;
        $this->ratesProvider = $module->getRatesProvider();
        $this->labelsProvider = $module->getLabelsProvider();
        if (CoreFeatureChecker::hasAdminModel('extension/extension')) { // v2
            $this->load->model('extension/extension');
            $installedModules = $this->model_extension_extension->getInstalled(
                Configuration::SharedSettingsModuleGroup
            );
        } elseif (CoreFeatureChecker::hasAdminModel('setting/extension')) { // v1, v3
            $this->load->model('setting/extension');
            $installedModules = $this->model_setting_extension->getInstalled(Configuration::SharedSettingsModuleGroup);
        } else {
            $installedModules = array();
        }
        $this->configuration = new Configuration(
            $this->config, $this->model_setting_setting, $this->db, $module, $installedModules
        );
        $this->debugger = new Debugger($this->configuration, $this->log, $this->module);
    }

    /**
     * @return int|null
     */
    public function getProductNameMaxLength() {
        if (!$this->labelsProvider) {
            return null;
        }
        return $this->labelsProvider->getProductNameMaxLength();
    }

    protected function getProductOptionValue($optionName, $productId, $default = null) {
        $setting = $this->configuration->get($optionName);
        return $productId ? (isset($setting[$productId]) ? $setting[$productId] : $default) : $default;
    }

    protected function setProductOptionValue($optionName, $productId, $value, $empty = null) {
        $productId = (int)$productId;
        $this->load->model('setting/setting');
        $optionPath = (VersionChecker::get()->isVersion3() ? 'shipping_' : '') . $this->module->getExtensionName();
        $settings = $this->model_setting_setting->getSetting($optionPath);
        if ($value !== $empty) {
            $settings[$this->module->getPrefixedName($optionName)][$productId] = $value;
        } else {
            unset($settings[$this->module->getPrefixedName($optionName)][$productId]);
        }
        $this->configuration->updateSettings($optionPath, $settings);
        return $value;
    }

    /**
     * @param int $productId
     * @return string|null
     */
    public function getProductName($productId) {
        return $this->getProductOptionValue('product_names', $productId);
    }

    /**
     * @param int $productId
     * @param string $name
     * @return string|null
     * @throws CoreFeatureException
     */
    public function setProductName($productId, $name) {
        if (!$this->labelsProvider) {
            return null;
        }
        return $this->setProductOptionValue(
            'product_names',
            $productId,
            $this->labelsProvider->shortenProductName($name),
            ''
        );
    }

    /**
     * @param int $productId
     * @return int|null
     */
    public function getProductCountry($productId) {
        return $this->getProductOptionValue('product_countries', $productId);
    }

    /**
     * @param int $productId
     * @param int $countryId
     * @return int|null
     */
    public function setProductCountry($productId, $countryId) {
        if (!$this->labelsProvider) {
            return null;
        }
        return $this->setProductOptionValue('product_countries', $productId, $countryId, '');
    }

    /**
     * @param int $productId
     * @return int|null
     */
    public function getProductZone($productId) {
        return $this->getProductOptionValue('product_zones', $productId);
    }

    /**
     * @param int $productId
     * @param int $zoneId
     * @return int|null
     */
    public function setProductZone($productId, $zoneId) {
        if (!$this->labelsProvider) {
            return null;
        }
        return $this->setProductOptionValue('product_zones', $productId, $zoneId, '');
    }

    /**
     * @param int $productId
     * @return string|null
     */
    public function getProductHsCode($productId) {
        return $this->getProductOptionValue('product_hs_codes', $productId);
    }

    /**
     * @param int $productId
     * @param string $hsCode
     * @return string|null
     */
    public function setProductHsCode($productId, $hsCode) {
        if (!$this->labelsProvider) {
            return null;
        }
        return $this->setProductOptionValue('product_hs_codes', $productId, trim($hsCode), '');
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\ShippingController {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureChecker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\AccompanyingDocument;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginPackage;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\BaseLabelsProvider;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\BaseRatesProvider;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\Configuration;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\Features;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\ShippingModule;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\VersionChecker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Author;

class Helper {
    public static $compareOperators = array('gt', 'gte', 'eq', 'lte', 'lt');
    protected static $freightClasses = array(
        'CLASS_050',
        'CLASS_055',
        'CLASS_060',
        'CLASS_065',
        'CLASS_070',
        'CLASS_077_5',
        'CLASS_085',
        'CLASS_092_5',
        'CLASS_100',
        'CLASS_110',
        'CLASS_125',
        'CLASS_150',
        'CLASS_175',
        'CLASS_200',
        'CLASS_250',
        'CLASS_300',
        'CLASS_400',
        'CLASS_500'
    );

    /** @var string[] Translation keys to pass into view */
    public static $requiredTranslations = array(
        'heading_title', 'text_enabled', 'text_disabled', 'text_all_zones', 'text_none', 'text_yes',
        'text_no', 'text_select_all', 'text_unselect_all', 'entry_min_box_weight', 'entry_max_box_weight',
        'entry_minimum_rate', 'help_minimum_rate', 'entry_weight_adj_fix', 'help_weight_adj_fix',
        'entry_weight_adj_per', 'help_weight_adj_per', 'entry_dimension_adj_fix', 'help_dimension_adj_fix',
        'entry_rate_adj_fix', 'help_rate_adj_fix', 'entry_rate_adj_per', 'help_rate_adj_per', 'entry_user_id',
        'help_user_id', 'entry_postcode', 'entry_machinable', 'entry_insurance', 'entry_hubid', 'help_hubid',
        'help_machinable', 'entry_custom_packages', 'help_custom_packages', 'entry_display_time',
        'help_display_time', 'entry_display_weight', 'help_display_weight', 'entry_pounds', 'help_pounds',
        'entry_inches', 'help_inches', 'entry_tax', 'entry_geo_zones', 'help_geo_zones', 'entry_status',
        'entry_sort_order', 'help_sort_order', 'entry_debug', 'help_debug', 'entry_processing_days',
        'help_processing_days', 'entry_prefix', 'help_prefix', 'entry_sort_options', 'help_sort_options',
        'text_no_sorting', 'text_sort_by_price', 'text_sort_by_time', 'entry_processing_saturdays',
        'entry_processing_sundays', 'entry_processing_holidays', 'help_processing_holidays', 'text_separate_config',
        'tab_general', 'tab_package', 'tab_shipping', 'tab_services', 'tab_adjustments', 'entry_version',
        'text_all_geo_zones', 'text_add_package', 'text_remove_package', 'entry_length', 'entry_width',
        'entry_height', 'entry_max_load', 'entry_promo', 'help_promo', 'entry_min_cost', 'text_add_promo',
        'text_remove_promo', 'entry_weight', 'entry_standard_packages', 'help_standard_packages',
        'text_debug_show_nothing_log_nothing', 'text_debug_show_nothing_log_errors', 'entry_insurance_from',
        'text_debug_show_nothing_log_all', 'text_debug_show_errors_log_errors', 'text_packer_weight_based',
        'text_debug_show_errors_log_all', 'entry_boxes_checked', 'button_save', 'button_cancel',
        'entry_boxes_unchecked', 'entry_services', 'help_services', 'entry_packer', 'help_packer',
        'demo_disabled', 'demo_title', 'demo_info', 'entry_customer_groups', 'help_customer_groups',
        'text_all_customer_groups', 'entry_account_rates', 'entry_equal_config', 'text_equal_config',
        'entry_country_id', 'entry_zone_id', 'help_zone_id', 'entry_city', 'entry_address', 'entry_tare',
        'entry_residential', 'help_residential', 'entry_key', 'entry_password', 'entry_meter',
        'text_regular_pickup', 'text_business_service_center', 'text_drop_box', 'text_request_courier',
        'text_station', 'entry_dropoff', 'entry_production', 'entry_pickup', 'help_production',
        'entry_commercial_rates', 'text_retail_rates', 'text_commercial_rates', 'text_commercial_plus_rates',
        'text_production_mode', 'text_developer_mode', 'text_home', 'text_shipping', 'text_automatic',
        'text_packer_3d_packer', 'text_packer_individual', 'text_daily_pickup', 'text_customer_counter',
        'text_one_time_pickup', 'text_letter_center', 'text_air_service_center', 'entry_box_weight_adj_fix',
        'help_box_weight_adj_fix', 'entry_date_format', 'entry_label', 'entry_weight_based_limit',
        'help_label', 'entry_tracking', 'help_tracking', 'text_tracking_not_send', 'tab_labels',
        'text_tracking_send_immediately', 'text_tracking_send_shipped', 'entry_mod', 'help_postcode_dub',
        'entry_contact', 'entry_cutoff', 'entry_cutoff_help', 'help_cutoff', 'entry_max_height',
        'entry_custom_envelopes', 'help_custom_envelopes', 'text_add_envelope', 'entry_avoid_delivery',
        'help_avoid_delivery', 'entry_avoid_delivery_saturdays', 'entry_avoid_delivery_sundays',
        'entry_maintenance', 'text_export_settings', 'text_import_settings', 'text_add_holiday',
        'entry_measurement_system', 'help_measurement_system', 'entry_label_format', 'help_label_format',
        'text_original_label', 'text_4x6_label', 'entry_sender_name', 'entry_sender_company',
        'entry_sender_telephone', 'help_label_foreign_data', 'help_insurance', 'entry_customer_number',
        'help_customer_number', 'entry_contract_id', 'help_contract_id', 'entry_promo_code', 'help_promo_code',
        'entry_provider_currency', 'help_provider_currency', 'entry_individual_tare', 'help_individual_tare',
        'help_weight_based_limit', 'text_bugreport', 'text_labels_disabled', 'text_labels_automatically',
        'text_labels_manually', 'entry_webhook', 'help_webhook', 'entry_pdf_converter', 'help_pdf_converter',
        'text_pdf_converter_imagick', 'text_pdf_converter_gmagick', 'license_title', 'license_info', 'license_buy',
        'license_close', 'entry_adjustment_rules', 'help_adjustment_rules', 'text_add_adjustment_rule',
        'entry_weight_based_faked_box', 'help_weight_based_faked_box', 'entry_billing_same', 'help_billing_same',
        'entry_billing_country_id', 'entry_billing_zone_id', 'entry_billing_city', 'entry_billing_postcode',
        'entry_billing_address', 'text_only_for_admin', 'help_insurance_from', 'entry_invoice', 'help_invoice',
        'entry_paperless', 'help_paperless', 'entry_fallback_product_country', 'entry_fallback_product_zone',
        'entry_fallback_product_hs_code', 'help_fallback_product_country', 'help_fallback_product_zone',
        'help_fallback_product_hs_code', 'entry_recipient_address_type', 'help_recipient_address_type',
        'text_always_commercial', 'text_always_residential', 'text_depends_on_company', 'text_validate_address',
        'entry_balance_min', 'help_balance_min', 'entry_balance_inc', 'help_balance_inc', 'help_password', 'help_key',
        'text_add_shipping_category', 'entry_shipping_categories', 'help_shipping_categories',
        'entry_shipping_category_ship_together', 'text_remove_shipping_category', 'tab_faq',
        'entry_shipping_category_ship_together', 'entry_id', 'entry_signature', 'help_signature', 'entry_proof_of_age',
        'text_any_age', 'entry_tracking_notify', 'help_tracking_notify', 'text_customer_chooses',
        'text_adult', 'entry_signature_type', 'text_direct', 'text_indirect', 'text_service_default',
        'entry_freight_class', 'help_freight_class', 'text_freight_class', 'entry_minimal_order_weight',
        'help_minimal_order_weight', 'text_business_days', 'entry_fallback_packer', 'entry_prefer_satchels',
        'help_prefer_satchels', 'text_sort_by_price_regardless_choices', 'text_import_google_calendar',
        'text_import_holidays', 'text_reset_holidays', 'text_box_maker', 'entry_box_maker_length',
        'help_box_maker_length', 'entry_box_maker_weight_limit', 'help_box_maker_weight_limit', 'entry_box_maker_width',
        'help_box_maker_width', 'entry_box_maker_margin', 'help_box_maker_margin'
    );

    /** @var string[] these translation keys will be passed into view with Module::ServiceName parameter */
    public static $translationsWithParameter = array('help_packer', 'help_custom_packages', 'help_standard_packages');

    /** @var string[] index in ShippingView => field key assigned in array of errors (warning is a top level error) */
    public static $requiredErrors = array('error_warning' => 'warning', 'error_user_id' => 'user_id',
        'error_postcode' => 'postcode', 'error_pounds_id' => 'pounds_id', 'error_inches_id' => 'inches_id',
        'error_country_id' => 'country_id', 'error_zone_id' => 'zone_id', 'error_city' => 'city',
        'error_address' => 'address', 'error_key' => 'key', 'error_password' => 'password',
        'error_meter' => 'meter', 'error_dropoff' => 'dropoff', 'error_commercial_rates' => 'commercial_rates',
        'error_measurement_system' => 'measurement_system', 'error_sender_telephone' => 'sender_telephone',
        'error_provider_currency' => 'provider_currency', 'error_customer_number' => 'customer_number',
        'error_adjustment_rules' => 'adjustment_rules', 'error_weight_based_faked_box' => 'weight_based_faked_box',
        'error_billing_country_id' => 'billing_country_id', 'error_billing_zone_id' => 'billing_zone_id',
        'error_billing_city' => 'billing_city', 'error_billing_postcode' => 'billing_postcode',
        'error_billing_address' => 'billing_address', 'error_recipient_address_type' => 'recipient_address_type',
        'error_box_maker_length' => 'box_maker_length');

    public static $googleHolidays = array(
        array(
            'text' => 'Australian Holidays',
            'value' => 'en.australian#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Austrian Holidays',
            'value' => 'en.austrian#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Brazilian Holidays',
            'value' => 'en.brazilian#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Canadian Holidays',
            'value' => 'en.canadian#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'China Holidays',
            'value' => 'en.china#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Christian Holidays',
            'value' => 'en.christian#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Danish Holidays',
            'value' => 'en.danish#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Dutch Holidays',
            'value' => 'en.dutch#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Finnish Holidays',
            'value' => 'en.finnish#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'French Holidays',
            'value' => 'en.french#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'German Holidays',
            'value' => 'en.german#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Greek Holidays',
            'value' => 'en.greek#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Hong Kong (C) Holidays',
            'value' => 'en.hong_kong_c#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Hong Kong Holidays',
            'value' => 'en.hong_kong#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Indian Holidays',
            'value' => 'en.indian#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Indonesian Holidays',
            'value' => 'en.indonesian#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Iranian Holidays',
            'value' => 'en.iranian#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Irish Holidays',
            'value' => 'en.irish#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Islamic Holidays',
            'value' => 'en.islamic#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Italian Holidays',
            'value' => 'en.italian#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Japanese Holidays',
            'value' => 'en.japanese#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Jewish Holidays',
            'value' => 'en.jewish#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Malaysian Holidays',
            'value' => 'en.malaysia#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Mexican Holidays',
            'value' => 'en.mexican#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'New Zealand Holidays',
            'value' => 'en.new_zealand#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Norwegian Holidays',
            'value' => 'en.norwegian#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Philippines Holidays',
            'value' => 'en.philippines#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Polish Holidays',
            'value' => 'en.polish#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Portuguese Holidays',
            'value' => 'en.portuguese#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Russian Holidays',
            'value' => 'en.russian#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Singapore Holidays',
            'value' => 'en.singapore#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'South Africa Holidays',
            'value' => 'en.sa#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'South Korean Holidays',
            'value' => 'en.south_korea#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Spain Holidays',
            'value' => 'en.spain#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Swedish Holidays',
            'value' => 'en.swedish#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Taiwan Holidays',
            'value' => 'en.taiwan#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Thai Holidays',
            'value' => 'en.thai#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'UK Holidays',
            'value' => 'en.uk#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'US Holidays',
            'value' => 'en.usa#holiday@group.v.calendar.google.com'
        ),
        array(
            'text' => 'Vietnamese Holidays',
            'value' => 'en.vietnamese#holiday@group.v.calendar.google.com'
        )
    );

    public static $measurementSystems = array(
        array(
            'text' => 'Imperial (inches and pounds)',
            'value' => Configuration::ImperialMeasures
        ),
        array(
            'text' => 'Metric (centimeters and kilograms)',
            'value' => Configuration::MetricMeasures
        )
    );

    public static function getDisplayedStatuses($data) {
        $result = array(
            array(
                'text' => $data['text_enabled'],
                'value' => Configuration::StatusEnabled
            ),
            array(
                'text' => $data['text_disabled'],
                'value' => Configuration::StatusDisabled
            )
        );
        if (CoreFeatureChecker::hasAdminModel('user/api')) { // v2
            $result[] = array(
                'text' => $data['text_only_for_admin'],
                'value' => Configuration::StatusOnlyForAdmin
            );
        }
        return $result;
    }

    public static function getBooleans($data) {
        return array(
            array(
                'text' => $data['text_yes'],
                'value' => 1
            ),
            array(
                'text' => $data['text_no'],
                'value' => 0
            )
        );
    }

    public static function getModes($data) {
        return array(
            array(
                'text' => $data['text_production_mode'],
                'value' => 1
            ),
            array(
                'text' => $data['text_developer_mode'],
                'value' => 0
            )
        );
    }

    public static function getMachinables($data) {
        return array(
            array(
                'text' => $data['text_yes'],
                'value' => Configuration::MachinableTrue
            ),
            array(
                'text' => $data['text_no'],
                'value' => Configuration::MachinableFalse
            ),
            array(
                'text' => $data['text_automatic'],
                'value' => Configuration::MachinableAutomatic
            )
        );
    }

    public static function getDebugLevels($data) {
        return array(
            array(
                'text' => $data['text_debug_show_nothing_log_nothing'],
                'value' => Configuration::ShowNothingLogNothing
            ),
            array(
                'text' => $data['text_debug_show_nothing_log_errors'],
                'value' => Configuration::ShowNothingLogErrors
            ),
            array(
                'text' => $data['text_debug_show_nothing_log_all'],
                'value' => Configuration::ShowNothingLogAll
            ),
            array(
                'text' => $data['text_debug_show_errors_log_errors'],
                'value' => Configuration::ShowErrorsLogErrors
            ),
            array(
                'text' => $data['text_debug_show_errors_log_all'],
                'value' => Configuration::ShowErrorsLogAll
            )
        );
    }

    public static function getSortings($data) {
        return array(
            array(
                'text'  => $data['text_no_sorting'],
                'value' => ''
            ),
            array(
                'text'  => $data['text_sort_by_price'],
                'value' => Configuration::SortByPrice
            ),
            array(
                'text' => $data['text_sort_by_price_regardless_choices'],
                'value' => Configuration::SortByPriceRegardlessChoices
            ),
            array(
                'text'  => $data['text_sort_by_time'],
                'value' => Configuration::SortByTime
            )
        );
    }

    /**
     * @param array $data
     * @param ShippingModule $module
     * @return array
     */
    public static function getPackers($data, $module) {
        $result = array(
            array(
                'text' => $data['text_packer_3d_packer'],
                'value' => Configuration::Packer3dPacker
            ),
            array(
                'text' => $data['text_packer_individual'],
                'value' => Configuration::PackerIndividual
            ),
            array(
                'text' => $data['text_box_maker'],
                'value' => Configuration::PackerBoxMaker
            )
        );
        if ($module->hasFeature(Features::PackerWeightBased)) {
            array_push($result, array(
                'text' => $data['text_packer_weight_based'],
                'value' => Configuration::PackerWeightBased
            ));
        }
        return $result;
    }

    public static function getDropoffs($data) {
        return array(
            array(
                'text' => $data['text_regular_pickup'],
                'value' => Configuration::DropoffRegularPickup
            ),
            array(
                'text' => $data['text_business_service_center'],
                'value' => Configuration::DropoffBusinessServiceCenter
            ),
            array(
                'text' => $data['text_drop_box'],
                'value' => Configuration::DropoffDropBox
            ),
            array(
                'text' => $data['text_request_courier'],
                'value' => Configuration::DropoffRequestCourier
            ),
            array(
                'text' => $data['text_station'],
                'value' => Configuration::DropoffStation
            )
        );
    }

    public static function getPickups($data) {
        return array(
            array(
                'text' => $data['text_daily_pickup'],
                'value' => Configuration::PickupDailyPickup
            ),
            array(
                'text' => $data['text_customer_counter'],
                'value' => Configuration::PickupCustomerCounter
            ),
            array(
                'text' => $data['text_one_time_pickup'],
                'value' => Configuration::PickupOneTimePickup
            ),
            array(
                'text' => $data['text_letter_center'],
                'value' => Configuration::PickupLetterCenter
            ),
            array(
                'text' => $data['text_air_service_center'],
                'value' => Configuration::PickupAirServiceCenter
            )
        );
    }

    public static function getCommercialRates($data) {
        return array(
            array(
                'text' => $data['text_retail_rates'],
                'value' => Configuration::RetailRates
            ),
            array(
                'text' => $data['text_commercial_rates'],
                'value' => Configuration::CommercialRates
            ),
            array(
                'text' => $data['text_commercial_plus_rates'],
                'value' => Configuration::CommercialPlusRates
            )
        );
    }

    public static function getLabels($data) {
        return array(
            array(
                'text' => $data['text_labels_disabled'],
                'value' => Configuration::LabelDisabled
            ),
            array(
                'text' => $data['text_labels_automatically'],
                'value' => Configuration::LabelAutomatically
            ),
            array(
                'text' => $data['text_labels_manually'],
                'value' => Configuration::LabelManually
            )
        );
    }

    public static function getTrackings($data) {
        return array(
            array(
                'text' => $data['text_tracking_not_send'],
                'value' => Configuration::TrackingNotSend
            ),
            array(
                'text' => $data['text_tracking_send_immediately'],
                'value' => Configuration::TrackingSendImmediately
            ),
            array(
                'text' => $data['text_tracking_send_shipped'],
                'value' => Configuration::TrackingSendShipped
            )
        );
    }

    /**
     * @param array $data
     * @param ShippingModule $module
     * @return array
     */
    public static function getRecipientAddressTypes($data, $module) {
        $result = array(
            array(
                'text' => $data['text_always_commercial'],
                'value' => Configuration::RecipientAddressTypeCommercial
            ),
            array(
                'text' => $data['text_always_residential'],
                'value' => Configuration::RecipientAddressTypeResidential
            ),
            array(
                'text' => $data['text_depends_on_company'],
                'value' => Configuration::RecipientAddressTypeDependsOnCompany
            )
        );
        if ($module->hasFeature(Features::AddressValidation)) {
            $result[] = array(
                'text' => $data['text_validate_address'],
                'value' => Configuration::RecipientAddressTypeValidated
            );
        }
        return $result;
    }

    public static function getDateFormats() {
        $result = array();
        foreach (Configuration::$dateFormats as $dateFormat) {
            $result[] = array(
                'text' => date($dateFormat, time()),
                'value' => $dateFormat
            );
        }
        return $result;
    }

    public static function getHours($data) {
        return array_merge(
            array(
                array(
                    'text' => $data['text_none'],
                    'value' => Configuration::CutoffDisabled
                )
            ),
            array_map(function($value){
                $value = str_pad($value, 2, '0', STR_PAD_LEFT) . ':00';
                return array(
                    'text' => $value,
                    'value' => $value
                );
            }, range(0, 23))
        );
    }

    public static function getFreightClasses($data) {
        $result = array(
            array(
                'text' => $data['text_automatic'],
                'value' => Configuration::FreightClassAutomatic
            )
        );

        foreach (self::$freightClasses as $freightClass) {
            $result[] = array(
                'text' => str_replace(
                    '_',
                    '.',
                    str_replace(
                        'CLASS_',
                        $data['text_freight_class'] . ' ',
                        $freightClass
                    )
                ),
                'value' => $freightClass
            );
        }

        return $result;
    }

    /**
     * @param array $data
     * @param ShippingModule $module
     * @param BaseLabelsProvider $labelsProvider
     * @return array
     */
    public static function getLabelFormats($data, $module, $labelsProvider) {
        $result = array(
            array(
                'text' => $data['text_original_label'],
                'value' => Configuration::LabelFormatOriginal
            )
        );
        if ($module->hasFeature(Features::ShippingLabel4x6Inches)) {
            if (($labelsProvider->getLabelFormat() === AccompanyingDocument::FormatPDF &&
                    CoreFeatureChecker::isPdfConverterInstalled()
                ) || ($labelsProvider->getLabelFormat() === AccompanyingDocument::FormatPNG)
            ) {
                array_push($result, array(
                    'text' => $data['text_4x6_label'],
                    'value' => Configuration::LabelFormat4x6
                ));
            }
        }
        return $result;
    }

    /**
     * @param array $data
     * @param ShippingModule $module
     * @param BaseLabelsProvider $labelsProvider
     * @return array
     */
    public static function getPdfConverters($data, $module, $labelsProvider) {
        $result = array();
        if ($module->hasFeature(Features::ShippingLabel4x6Inches)) {
            if ($labelsProvider->getLabelFormat() === AccompanyingDocument::FormatPDF) {
                if (CoreFeatureChecker::isImageMagickInstalled()) {
                    array_push($result, array(
                        'text' => $data['text_pdf_converter_imagick'],
                        'value' => Configuration::PdfConverterImagick
                    ));
                }
                if (CoreFeatureChecker::isGraphicsMagickInstalled()) {
                    array_push($result, array(
                        'text' => $data['text_pdf_converter_gmagick'],
                        'value' => Configuration::PdfConverterGmagick
                    ));
                }
            }
        }
        return $result;
    }

    /**
     * @param BaseRatesProvider $ratesProvider
     * @param callable $filterFunction
     * @return array
     */
    public static function getBoxes($ratesProvider, $filterFunction) {
        $result = array_filter(
            $ratesProvider->getStandardPackages(), $filterFunction
        );
        usort($result, function($a, $b) {
            /** @var OriginPackage $a */
            /** @var OriginPackage $b */
            if ($a->getTitle() < $b->getTitle()) {
                return -1;
            }
            return 1;
        });
        return $result;
    }

    /**
     * @param array $data
     * @return array
     */
    public static function getEqualConfig($data) {
        return array(
            array(
                'text' => $data['text_equal_config'],
                'value' => 1
            ),
            array(
                'text' => $data['text_separate_config'],
                'value' => 0
            )
        );
    }

    /**
     * @param object $modelStore
     * @param object $config
     * @return array
     */
    public static function getStores($modelStore, $config) {
        $result = array(
            array(
                'store_id' => 0,
                'name' => $config->get('config_name')
            )
        );
        $result = array_merge($result, $modelStore->getStores());
        return $result;
    }

    public static function getTaxClasses($data, $modelTaxClass) {
        return array_merge(array(array(
            'tax_class_id' => 0,
            'title' => $data['text_none']
        )), $modelTaxClass->getTaxClasses());
    }

    /**
     * @param ShippingModule $module
     * @param array $data
     * @return array
     */
    public static function getSignatures($module, $data) {
        return array_merge(array(
            array(
                'text' => $data['text_yes'],
                'value' => Configuration::SignatureRequired
            ),
            array(
                'text' => $data['text_no'],
                'value' => Configuration::SignatureNotRequired
            ),
            array(
                'text' => $data['text_customer_chooses'],
                'value' => Configuration::CustomerChooses
            )
        ), $module->hasFeature(Features::SignatureServiceDefault) ? array(
            array(
                'text' => $data['text_service_default'],
                'value' => Configuration::ServiceDefault
            )
        ) : array());
    }

    /**
     * @param array $data
     * @return array
     */
    public static function getInsurances($data) {
        return array(
            array(
                'text' => $data['text_yes'],
                'value' => Configuration::InsuranceEnabled
            ),
            array(
                'text' => $data['text_no'],
                'value' => Configuration::InsuranceDisabled
            ),
            array(
                'text' => $data['text_customer_chooses'],
                'value' => Configuration::CustomerChooses
            )
        );
    }

    public static function getSignatureTypes($data) {
        return array(
            array(
                'text' => $data['text_direct'],
                'value' => Configuration::DirectSignature
            ),
            array(
                'text' => $data['text_indirect'],
                'value' => Configuration::IndirectSignature
            ),
            array(
                'text' => $data['text_adult'],
                'value' => Configuration::AdultSignature
            )
        );
    }

    /**
     * @param ShippingModule $module
     * @param array $data
     * @return array
     */
    public static function getProofsOfAge($module, $data) {
        return array_merge(array(
            array(
                'text' => $data['text_any_age'],
                'value' => 0
            )
        ), $module->hasFeature(Features::ProofOfAge18) ? array(
            array(
                'text' => '18',
                'value' => 18
            )
        ) : array(), $module->hasFeature(Features::ProofOfAge19) ? array(
            array(
                'text' => '19',
                'value' => 19
            )
        ) : array(), $module->hasFeature(Features::ProofOfAgeAdult) ? array(
            array(
                'text' => $data['text_adult'],
                'value' => 99
            )
        ) : array());
    }

    /**
     * @param array $data
     * @param object $modelLocalisationWeightClass
     * @return array
     */
    public static function getWeightClasses($data, $modelLocalisationWeightClass) {
        return array_merge(
            array(
                array(
                    'weight_class_id' => 0,
                    'title' => $data['text_none'],
                    'unit' => ''
                )
            ),
            $modelLocalisationWeightClass->getWeightClasses()
        );
    }

    /**
     * @param array $data
     * @param object $modelLocalisationLengthClass
     * @return array
     */
    public static function getLengthClasses($data, $modelLocalisationLengthClass) {
        return array_merge(
            array(
                array(
                    'length_class_id' => 0,
                    'title' => $data['text_none'],
                    'unit' => ''
                )
            ),
            $modelLocalisationLengthClass->getLengthClasses()
        );
    }

    /**
     * @param array $data
     * @param ShippingModule $module
     */
    public static function findPounds(&$data, $module) {
        $data['pounds_found'] = false;
        $searchPounds = array_filter($data['weight_classes'], function ($weightClass) {
            if (
                stripos($weightClass['title'], 'pound') !== false &&
                stripos($weightClass['unit'], 'lb') !== false
            ) {
                return true;
            }
            return false;
        });
        if (count($searchPounds) === 1) {
            $data['pounds_found'] = true;
            $pounds = array_pop($searchPounds);
            $data[$module->getPrefixedName('pounds_id')] = $pounds['weight_class_id'];
        }
    }

    /**
     * @param array $data
     * @param ShippingModule $module
     */
    public static function findInches(&$data, $module) {
        $data['inches_found'] = false;
        $searchInches = array_filter($data['length_classes'], function ($lengthClass) {
            if (
                stripos($lengthClass['title'], 'inch') !== false &&
                stripos($lengthClass['unit'], 'in') !== false
            ) {
                return true;
            }
            return false;
        });
        if (count($searchInches) === 1) {
            $data['inches_found'] = true;
            $inches = array_pop($searchInches);
            $data[$module->getPrefixedName('inches_id')] = $inches['length_class_id'];
        }
    }

    public static function buildNavControls(&$data, $linkFunction, $currentRoute, $storeId) {
        if (VersionChecker::get()->isVersion23()) {
            $backLink = call_user_func($linkFunction, 'extension/extension', 'type=shipping');
        } elseif (VersionChecker::get()->isVersion3()) {
            $backLink = call_user_func($linkFunction, 'marketplace/extension', 'type=shipping');
        } else {
            $backLink = call_user_func($linkFunction, 'extension/shipping');
        }
        $data['breadcrumbs'] = array(
            array(
                'text'      => $data['text_home'],
                'href'      => call_user_func($linkFunction, VersionChecker::get()->isVersion1() ?
                    'common/home' : 'common/dashboard'),
                'separator' => false
            ),
            array(
                'text'      => $data['text_shipping'],
                'href'      => $backLink,
                'separator' => ' :: '
            ),
            array(
                'text'      => $data['heading_title'],
                'href'      => call_user_func($linkFunction, $currentRoute),
                'separator' => ' :: '
            )
        );
        $data['action'] = call_user_func($linkFunction, $currentRoute, 'store_id=' . $storeId);
        $data['cancel'] = $backLink;
    }

    public static function buildProductsTree($db, $config) {
        $sql = 'select cat.category_id, cat.parent_id, de.name as `title` ' .
            'from ' . DB_PREFIX . 'category as cat ' .
            'inner join ' . DB_PREFIX . 'category_description as de on (cat.category_id=de.category_id) ' .
            'where de.language_id=' . (int)$config->get('config_language_id') . ' ' .
            'order by cat.parent_id, cat.sort_order';
        $categories = $db->query($sql)->rows;
        $sql = 'select p.product_id, d.name as `title`, c.category_id ' .
            'from ' . DB_PREFIX . 'product as p ' .
            'inner join ' . DB_PREFIX . 'product_description as d on (p.product_id=d.product_id) ' .
            'inner join ' . DB_PREFIX . 'product_to_category as c on (p.product_id=c.product_id) ' .
            'where d.language_id=' . (int)$config->get('config_language_id') . ' ' .
            'order by d.name';
        $products = $db->query($sql)->rows;
        $categoriesByParent = array();
        $categoriesById = array();
        foreach ($categories as $k => $category) {
            $categoriesByParent[$category['parent_id']][] = &$categories[$k];
            $categoriesById[$category['category_id']] = &$categories[$k];
            unset($categories[$k]['parent_id']);
        }
        foreach ($categories as $k => $category) {
            $categoryId = $category['category_id'];
            $categories[$k]['products'] = array();
            $categories[$k]['category_id'] = (int)$category['category_id'];
            $categories[$k]['categories'] = isset($categoriesByParent[$categoryId]) ?
                $categoriesByParent[$categoryId] : array();
        }
        foreach ($products as $product) {
            $categoryId = $product['category_id'];
            if (isset($categoriesById[$categoryId])) {
                $product['category_id'] = (int)$product['category_id'];
                $product['product_id'] = (int)$product['product_id'];
                $categoriesById[$categoryId]['products'][] = $product;
            }
        }
        return $categoriesByParent[0];
    }

    public static function buildModificationStatus(&$data, $isModeEnabled, $isModInstalled) {
        $data['mod_file_enabled'] = $isModeEnabled;
        if ($isModeEnabled) {
            $data['mod_status'] = 'Modification is installed. Module is fully operational.';
        } else {
            if ($isModInstalled) {
                $data['mod_status'] = (
                    'Modification is installed, but not activated. Please follow to
                    <code>Admin / Extensions / Modifications</code> and click <code>Refresh</code> on the top right.'
                );
            } else {
                if (VersionChecker::get()->isVersion1()) {
                    if (CoreFeatureChecker::isVqmodInstalled()) {
                        $data['mod_status'] = (
                            'vQmod is installed but modification was not loaded. Make sure you copied
                            <code>vqmod</code> directory to your website. Please contact us
                            at ' . Author::ContactEmail . ' if you cannot fix this problem yourself.'
                        );
                    } else {
                        $data['mod_status'] = (
                            'vQmod is not installed. <a href="https://github.com/vqmod/vqmod/releases">Download
                            the latest release</a> and
                            <a href="https://drugoe.de/kb/ocmod-vqmod">follow this manual</a>
                            to install it on top of your E-Commerce Shop setup.'
                        );
                    }
                } elseif (VersionChecker::get()->isVersion2()) {
                    $data['mod_status'] = (
                        'Modification was not loaded. Make sure to install the module using
                        <code>Extension Installer</code> and then open <code>Admin / Extensions / Modifications</code>
                        and click <code>Refresh</code> button on top right. Installing the module via FTP will not add
                        the required modification. Please contact us at ' . Author::ContactEmail . ' if you have
                        already followed these steps and still see this error message.'
                    );
                } elseif (VersionChecker::get()->isVersion3()) {
                    $data['mod_status'] = (
                        'Modification was not loaded. Make sure to install the module using
                        <code>Extension Installer</code> and then open <code>Admin / Extensions / Modifications</code>
                        and click <code>Refresh</code> button on top right. Please also proceed to
                        <code>Dashboard</code>, click the <code>Gear</code> button on the top right and click
                        <code>Refresh</code> button next to <code>Theme</code>. Installing the module via FTP will not
                        add the required modification. Please contact us at ' . Author::ContactEmail . ' if you have
                        already followed these steps and still see this error message.'
                    );
                }

            }
        }
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Author;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureChecker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Fallback;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Locale;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\AccompanyingDocument;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\OrderedBoxPackedItem;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\PackagingList;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\Shipment;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginPackage;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\ShippingController\Helper;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\SimpleController;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Address;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Arrays;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\CurrencyConverter;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Json;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Label;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Scene;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\VersionChecker;

abstract class ShippingController extends SimpleController {
    /** @var Configuration */
    protected $configuration;
    /** @var BaseRatesProvider */
    protected $ratesProvider;
    /** @var null|BaseLabelsProvider */
    protected $labelsProvider;
    /** @var null|BaseValidationProvider */
    protected $validationProvider;
    /** @var null|BasePaperlessProvider */
    protected $paperlessProvider;
    /** @var ShippingModule extend with shipping */
    protected $module;
    /** @var Debugger */
    protected $debugger;
    /** @var CurrencyConverter */
    protected $converter;
    protected $error = array();
    protected $data = array();
    protected $storesConfig = array();
    protected $isModInstalled = false;

    /**
     * @param mixed $registry
     * @param ShippingModule $module
     * @throws CoreFeatureException
     * @throws ConfigurationException
     */
    public function __construct($registry, $module) {
        parent::__construct($registry, $module);
        $this->ratesProvider = $module->getRatesProvider();
        $this->labelsProvider = $module->getLabelsProvider();
        $this->validationProvider = $module->getValidationProvider();
        $this->load->model('setting/setting');
        if (CoreFeatureChecker::hasAdminModel('extension/extension')) { // v2
            $this->load->model('extension/extension');
            $installedModules = $this->model_extension_extension->getInstalled(
                Configuration::SharedSettingsModuleGroup
            );
        } elseif (CoreFeatureChecker::hasAdminModel('setting/extension')) { // v1, v3
            $this->load->model('setting/extension');
            $installedModules = $this->model_setting_extension->getInstalled(Configuration::SharedSettingsModuleGroup);
        } else {
            $installedModules = array();
        }
        $this->load->model('setting/store');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');
        if (CoreFeatureChecker::hasAdminModel('extension/modification')) {
            $this->load->model('extension/modification');
            $this->isModInstalled = CoreFeatureChecker::isModificationInstalled(
                $this->model_extension_modification, $this->module->getExtensionName()
            );
        } elseif (CoreFeatureChecker::hasAdminModel('setting/modification')) {
            $this->load->model('setting/modification');
            $this->isModInstalled = CoreFeatureChecker::isModificationInstalled(
                $this->model_setting_modification, $this->module->getExtensionName()
            );
        } else {
            $this->isModInstalled = CoreFeatureChecker::isModificationInstalled(
                null, $this->module->getExtensionName()
            );
        }
        $this->configuration = new Configuration(
            $this->config, $this->model_setting_setting, $this->db, $module, $installedModules
        );
        $this->paperlessProvider = $module->getPaperlessProvider();
        $this->debugger = new Debugger($this->configuration, $this->log, $this->module);
        $this->converter = new CurrencyConverter(Array($this->currency, 'convert'), $this->config);
        $this->language->load(
            (VersionChecker::get()->isVersion3() ? 'extension/' : '') .
            'shipping/' . $this->module->getExtensionName()
        );
        $this->document->setTitle($this->language->get('heading_title'));
    }

    abstract protected function setUpProviders();

    public function getWebhookUrl() {
        return $this->getFrontUrl() . 'index.php?route=' . (VersionChecker::get()->isVersion3() ? 'extension/' : '') .
            'shipping/' . $this->module->getExtensionName();
    }

    public function isModEnabled() {
        return $this->module->getVqmod() ? $this->module->getVqmod()->isEnabled() : false;
    }

    /**
     * Sets options to Labels Provider from config by given array of keys
     * Keys will be prefixed
     * @param array $keys
     */
    public function setLabelsProviderOptionsFromConfig($keys) {
        foreach ($keys as $key) {
            $this->labelsProvider->setOption($key, $this->configuration->get($key));
        }
    }

    /**
     * Sets options to Labels Provider from config by given array of keys
     * Keys will be prefixed
     * @param array $keys
     */
    public function setValidationProviderOptionsFromConfig($keys) {
        foreach ($keys as $key) {
            $this->validationProvider->setOption($key, $this->configuration->get($key));
        }
    }

    /**
     * Sets options to Paperless Provider from config by given array of keys
     * Keys will be prefixed
     * @param array $keys
     */
    public function setPaperlessProviderOptionsFromConfig($keys) {
        foreach ($keys as $key) {
            $this->paperlessProvider->setOption($key, $this->configuration->get($key));
        }
    }

    /**
     * Returns POST value
     * @param string $key
     * @return array|string|null
     */
    public function getPost($key) {
        return isset($this->request->post[$this->module->getPrefixedName($key)]) ?
            $this->request->post[$this->module->getPrefixedName($key)] : null;
    }

    /**
     * Sets POST value
     * @param string $key
     * @param mixed $value
     */
    public function setPost($key, $value) {
        $this->request->post[$this->module->getPrefixedName($key)] = $value;
    }

    /**
     * Returns 1 or 0 depending on boolean conversion of argument
     * @param mixed $value
     * @return int
     */
    public function toConfigBool($value) {
        return (bool)$value ? 1 : 0;
    }

    /**
     * Function to filter only those standard boxes, that should be shown for selection
     * @param OriginPackage $box
     * @return bool
     */
    public function filterStandardPackages($box) {
        $hiddenIds = $this->ratesProvider->getHiddenStandardPackagesIds();
        return !in_array($box->getId(), $hiddenIds, true);
    }

    /**
     * Do the common job for methods: zone(), billingZone(), fallbackProductZone()
     * @since 23.11.2017 requires store_id to be set
     */
    protected function fetchZones() {
        if (!isset($this->request->get['country_id'])) {
            $this->respondWithError('Required: country_id', 400);
        }
        if (!isset($this->request->get['store_id'])) {
            $this->respondWithError('Required: store_id', 400);
        }
        $this->configuration->changeStore($this->request->get['store_id']);
        $this->data['zones'] = $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']);
        if (!count($this->data['zones'])) {
            $this->data['zones'][] = array('zone_id' => 0, 'name' => $this->language->get('text_none'));
        }
        $this->data['get_prefixed_name'] = Array($this->module, 'getPrefixedName');
        $this->data['get_extension_name'] = Array($this->module, 'getExtensionName');
        $this->data['has_feature'] = Array($this->module, 'hasFeature');
        $this->data['get_current_route'] = Array($this, 'getCurrentRoute');
    }

    /**
     * Returns render of zones select for defined country
     */
    public function zone() {
        $this->fetchZones();
        $this->data[$this->module->getPrefixedName('zone_id')] = (int)$this->configuration->get('zone_id');
        echo ShippingView::replyZones($this->data);
        exit;
    }

    public function fallbackProductZone() {
        $this->fetchZones();
        $this->data[$this->module->getPrefixedName('fallback_product_zone')] =
            (int)$this->configuration->get('fallback_product_zone');
        echo ShippingView::replyFallbackProductZones($this->data);
        exit;
    }

    /**
     * Returns render of billing zones select for defined country
     */
    public function billingZone() {
        $this->fetchZones();
        $this->data[$this->module->getPrefixedName('billing_zone_id')] =
            (int)$this->configuration->get('billing_zone_id');
        echo ShippingView::replyBillingZones($this->data);
        exit;
    }

    /**
     * Returns render of services select for defined country or user
     * @since 23.11.2017 requires store_id to be set
     */
    public function services() {
        if (!isset($this->request->get['store_id'])) {
            $this->respondWithError('Required: store_id', 400);
        }
        $this->configuration->changeStore($this->request->get['store_id']);
        $result = array();
        if ($this->module->hasFeature(Features::MethodsDependOnShipperCountry)) {
            if (!isset($this->request->get['country_id'])) {
                $this->respondWithError('Required: country_id', 400);
            }
            $countryData = $this->model_localisation_country->getCountry($this->request->get['country_id']);
            $countryCode = $countryData['iso_code_2'];
            $result = call_user_func(Array($this->ratesProvider, 'getMethodCodesByCountryCode'), $countryCode);
        } elseif ($this->module->hasFeature(Features::MethodsDependOnUserId)) {
            if (!isset($this->request->get['user_id'])) {
                if ($this->module->getIsDemoMode()) {
                    $this->request->get['user_id'] = $this->configuration->get('user_id');
                } else {
                    $this->respondWithError('Required: user_id', 400);
                }
            }
            try {
                $result = call_user_func(
                    Array($this->ratesProvider, 'getMethodCodesByUserId'),
                    $this->request->get['user_id']
                );
            } catch (\Exception $e) {
                $this->respondWithError($e->getMessage(), 400);
            }
        } else {
            $this->respondWithError('Feature is not supported', 400);
        }
        $requiredTranslations = array_merge(
            $this->ratesProvider->getAllShippingMethodGroups('text'),
            $this->ratesProvider->getAllShippingMethods('text'),
            array('text_select_all', 'text_unselect_all', 'text_refresh', 'text_services_by_user', 'text_any'));
        foreach ($requiredTranslations as $key) {
            $this->data[$key] = $this->language->get($key);
        }
        $this->data[$this->module->getPrefixedName('methods')] = $this->configuration->get('methods');
        $this->data['get_prefixed_name'] = Array($this->module, 'getPrefixedName');
        $this->data['get_extension_name'] = Array($this->module, 'getExtensionName');
        $this->data['has_feature'] = Array($this->module, 'hasFeature');
        $this->data['get_current_route'] = Array($this, 'getCurrentRoute');
        $this->data['method_codes_custom'] = $result;
        if ($this->module->hasFeature(Features::MethodsDependOnUserId)) {
            echo ShippingView::replyServicesByUser($this->data);
        } else {
            echo ShippingView::replyServices($this->data);
        }
        exit;
    }

    /**
     * Shows the packaging list for order
     */
    public function packagingList() {
        $orderId = intval($this->request->get['order_id']);
        if (!$orderId) {
            $this->respondWithError('Order Id not specified', 400);
        }
        $orderInfo = $this->getOrderInformation($orderId);
        $this->configuration->changeStore($orderInfo['store_id']);
        $fallback = Fallback::create()->setLabelFormatFromProvider($this->labelsProvider);
        $packagingList = PackagingListManager::load($orderId, $fallback);
        if (!$packagingList) {
            $this->respondWithError('Packing list not found or not compatible', 404);
        }
        $_this = $this;
        $locale = new Locale($this->configuration->get('measurement_system'));
        foreach ($packagingList->getShipments() as $shipmentId => $shipment) {
            $this->data['list'][] = array(
                'shipment' => $shipment,
                'locale' => $locale,
                'documents' => !$this->module->hasFeature(Features::ShippingLabel) ? null :
                    array_map(function($document, $documentId) use ($_this, $orderId, $shipmentId) {
                        /** @var AccompanyingDocument $document */
                        return array(
                            'title' => $document->getTypeDescription(),
                            'links' => $document->getNumberOfPages() > 0 ?
                                array_map(function($page) use ($documentId, $_this, $orderId, $shipmentId) {
                                    return $_this->link(
                                        $_this->getParentRoute() .
                                        (CoreFeatureChecker::isBrowserSupportsFramePrint() ?
                                            '/documentwrapper' : '/document'),
                                        'order_id=' . $orderId . '&box_id=' . $shipmentId .
                                        '&document_id=' . $documentId . '&page=' . $page
                                    );
                                }, range(0, $document->getNumberOfPages() - 1)) : array()
                        );
                    }, $shipment->getDocuments(), array_keys($shipment->getDocuments())),
                'request_link' => ($this->module->hasFeature(Features::ShippingLabel) && !$shipment->hasLabel()) ?
                    $this->link(
                        $this->getParentRoute() . '/requestlabel',
                        'order_id=' . $orderId . '&box_id=' . $shipmentId
                    ) : null,
                'void_link' => ($this->module->hasFeature(Features::ShippingLabelVoid) && $shipment->hasLabel()) ?
                    $this->link(
                        $this->getParentRoute() . '/voidlabel', 'order_id=' . $orderId . '&box_id=' . $shipmentId
                    ) : null,
                'map_link' => $shipment->getBox()->getPackagingMap() ? $this->link(
                    $this->getParentRoute() . '/packingmap', 'order_id=' . $orderId . '&box_id=' . $shipmentId
                ) : null,
                'product_links' => array_map(function($item) use ($_this) {
                    /** @var OrderedBoxPackedItem $item */
                    if (!$item->getId()) {
                        return null;
                    }
                    return $item->link = $_this->link('catalog/product/edit', 'product_id=' . $item->getId());
                }, $shipment->getBox()->getProducts())
            );
        }
        $hasLabels = array_reduce($packagingList->getShipments(), function ($b, $shipment) {
            /** @var Shipment $shipment */
            return $b || $shipment->hasLabel();
        }, false);
        if ($this->module->hasFeature(Features::ShippingLabel)) {
            if ($hasLabels) {
                $this->data['print_all_link'] = $this->link($this->getParentRoute() .
                    (CoreFeatureChecker::isBrowserSupportsFramePrint() ? '/documentwrapper' : '/mergelabels'),
                    'order_id=' . $orderId . '&box_id=-1');
            } else {
                $this->data['request_all_link'] = $this->link($this->getParentRoute() . '/requestlabel',
                    'order_id=' . $orderId . '&box_id=-1');
            }
        }
        $this->data['order_id'] = $orderId;
        $this->data['store_name'] = $orderInfo['store_name'];
        $this->data['service_name'] = $packagingList->getServiceName();
        $this->data['method_name'] = $packagingList->getMethodName();
        $this->data['get_prefixed_name'] = Array($this->module, 'getPrefixedName');
        $this->data['get_extension_name'] = Array($this->module, 'getExtensionName');
        $this->data['has_feature'] = Array($this->module, 'hasFeature');
        $this->data['get_current_route'] = Array($this, 'getCurrentRoute');
        $this->data['manage'] = array(array(
            'title' => 'JSON',
            'icon' => 'share.svg',
            'link' => $this->link($this->getParentRoute() . '/exportorders', 'order_id=' . $orderId . '&format=json')
        ));
        if ($this->module->hasFeature(Features::ExportFormatClickShip)) {
            $this->data['manage'][] = array(
                'title' => 'Click-n-ship address book',
                'icon' => 'share.svg',
                'link' => $this->link(
                    $this->getParentRoute() . '/exportorders', 'order_id=' . $orderId . '&format=clicknship'
                )
            );
        }
        if ($this->module->hasFeature(Features::ExportFormatFedexAddressBook)) {
            $this->data['manage'][] = array(
                'title' => 'FedEx address book',
                'icon' => 'share.svg',
                'link' => $this->link(
                    $this->getParentRoute() . '/exportorders', 'order_id=' . $orderId . '&format=fedexaddressbook'
                )
            );
        }
        $this->data['manage'][] = array(
            'title' => 'Update products info',
            'icon' => 'sync.svg',
            'link' => $this->link($this->getParentRoute() . '/rebuildproducts', 'order_id=' . $orderId)
        );
        $this->data['version'] = $this->module->getVersion();
        echo ShippingView::replyPackagingList($this->data);
        exit;
    }

    /**
     * @since 15.11.2018 accepts `save` argument
     * @throws CoreFeatureException
     */
    public function mergeLabels() {
        $orderId = intval($this->request->get['order_id']);
        if (!$orderId) {
            $this->respondWithError('Order Id not specified', 400);
        }
        if (!CoreFeatureChecker::isGhostscriptInstalled()) {
            $this->respondWithError('Ghostscript is not installed', 404);
        }
        $orderInfo = $this->getOrderInformation($orderId);
        $this->configuration->changeStore($orderInfo['store_id']);
        $fallback = Fallback::create()->setLabelFormatFromProvider($this->labelsProvider);
        $shipments = PackagingListManager::load($orderId, $fallback)->getShipments();
        $labels = array();
        foreach ($shipments as $shipment) {
            foreach ($shipment->getDocuments() as $document) {
                if ($document->isLabel()) {
                    $labels[] = $document;
                }
            }
        }
        $filename = isset($this->request->get['save']) ? 'mergedlabels-' . $orderId . '.pdf' : null;
        try {
            $this->respondWithText(Label::merge($labels), AccompanyingDocument::FormatPDF, $filename ?: null);
        } catch (\Exception $e) {
            $this->respondWithError($e->getMessage(), 400);
        }
    }

    public function rebuildProducts() {
        $orderId = intval($this->request->get['order_id']);
        if (!$orderId) {
            $this->respondWithError('Order Id not specified', 400);
        }
        try {
            PackagingListManager::rebuildProducts($orderId, $this->configuration, $this->labelsProvider);
        } catch (\Exception $e) {
            $this->respondWithError($e->getMessage());
        }
        $this->smartRedirect($this->getParentRoute() . '/packaginglist', 'order_id=' . $orderId);
    }

    public function exportOrders() {
        $orderId = intval($this->request->get['order_id']);
        if (!$orderId) {
            $this->respondWithError('Order Id not specified', 400);
        }
        $format = $this->request->get['format'];
        if (!$format) {
            $this->respondWithError('Format not specified', 400);
        }
        $order = $this->getOrderInformation($orderId);
        if ($format === 'json') {
            $this->respondWithText(
                PackagingListManager::readRaw($orderId),
                'application/json',
                'order-' . $orderId . '.json'
            );
        } elseif ($format === 'clicknship') {
            $data = array(
                array(
                    'First Name' => $order['shipping_firstname'],
                    'MI' => '',
                    'Last Name' => $order['shipping_lastname'],
                    'Company' => $order['shipping_company'],
                    'Address 1' => $order['shipping_address_1'],
                    'Address 2' => $order['shipping_address_2'],
                    'Address 3' => '',
                    'City' => $order['shipping_city'],
                    'State/Province' => $order['shipping_zone'],
                    'ZIP/Postal Code' => $order['shipping_postcode'],
                    'Country' => $order['shipping_country'],
                    'Urbanization' => '',
                    'Phone Number' => $order['telephone'],
                    'Fax Number' => isset($order['fax']) ? $order['fax'] : '',
                    'E Mail' => $order['email'],
                    'Reference Number' => $order['order_id'],
                    'Nickname' => ''
                )
            );
            $output = Arrays::toCsv($data);
            $this->respondWithText($output, 'text/csv', 'order-' . $orderId . '.csv');
        } elseif ($format === 'fedexaddressbook') {
            $data = array(
                array(
                    'Nickname' => '',
                    'FullName' => $order['shipping_firstname'] . ' ' . $order['shipping_lastname'],
                    'FirstName' => $order['shipping_firstname'],
                    'LastName' => $order['shipping_lastname'],
                    'Title' => '',
                    'Company' => $order['shipping_company'],
                    'Department' => '',
                    'AddressOne' => $order['shipping_address_1'],
                    'AddressTwo' => $order['shipping_address_2'],
                    'City' => $order['shipping_city'],
                    'State' => $order['shipping_zone_code'],
                    'Zip' => $order['shipping_postcode'],
                    'PhoneNumber' => $order['telephone'],
                    'ExtensionNumber' => '',
                    'FAXNumber' => isset($order['fax']) ? $order['fax'] : '',
                    'PagerNumber' => '',
                    'MobilePhoneNumber' => '',
                    'CountryCode' => $order['shipping_iso_code_2'], // iso-2 code in sample
                    'EmailAddress' => $order['email'],
                    'VerifiedFlag' => 'Y',
                    'AcceptedFlag' => 'Y',
                    'ValidFlag' => 'Y',
                    'ResidentialFlag' => $order['shipping_company'] ? '' : 'R'
                )
            );
            $output = Arrays::toCsv($data);
            $this->respondWithText($output, 'text/csv', 'order-' . $orderId . '.csv');
        } else {
            $this->respondWithError('Unknown format ' . $format, 404);
        }
    }

    /**
     * Export settings to file
     * @since 22.11.2017 exports settings separately by store id
     * @since 20.05.2018 exports shared settings
     */
    public function exportSettings() {
        if ($this->module->getIsDemoMode()) {
            $this->respondWithError('Can not export settings in demo mode', 403);
        }
        $allStoresSettings = array();
        $sharedSettings = array();
        foreach (Helper::getStores($this->model_setting_store, $this->config) as $store) {
            $allStoresSettings[$store['store_id']] = $this->model_setting_setting->getSetting(
                (VersionChecker::get()->isVersion3() ? 'shipping_' : '') . $this->module->getExtensionName(),
                $store['store_id']
            );
            $sharedSettings[$store['store_id']] = $this->model_setting_setting->getSetting(
                (VersionChecker::get()->isVersion3() ? (Configuration::SharedSettingsModuleGroup . '_') : '') .
                Configuration::SharedSettingsModuleName,
                $store['store_id']
            );
        }
        $result = array(
            'extension' => $this->module->getExtensionName(),
            'version' => $this->module->getVersion(),
            'date' => date('d.m.Y h:i:s'),
            'is_modification_installed' => $this->isModInstalled,
            'is_modification_enabled' => $this->isModEnabled(),
            'php' => phpversion(),
            'ecommerce_version' => VersionChecker::get()->getVersion(),
            'host' => gethostname(),
            'settings_by_store' => $allStoresSettings,
            'shared_settings' => $sharedSettings
        );
        $this->respondWithText(
            Json::encodePretty($result),
            'application/json',
            $this->module->getExtensionName() . '.json'
        );
    }

    /**
     * Imports settings from file
     * @since 22.11.2017 accepts separated module configuration for each store with backward compatibility
     * @throws CoreFeatureException
     */
    public function importSettings() {
        if (!isset($this->request->files['source'])) {
            $this->respondWithError('Required file: source', 400);
        }
        $data = @file_get_contents($this->request->files['source']['tmp_name']);
        if (!$data) {
            $this->respondWithError('Can not read file', 404);
        }
        $json = Json::decodeAsArray($data);
        if ($json === null) {
            $this->respondWithError('Invalid JSON file', 400);
        }
        if (!isset($json['extension'])) {
            $this->respondWithError('Can not find extension name in file', 404);
        }
        if ($json['extension'] !== $this->module->getExtensionName()) {
            $this->respondWithError('These settings are not compatible with this extension', 400);
        }
        if (!isset($json['settings_by_store'])) {
            if (!isset($json['settings'])) {
                $this->respondWithError('Can not find settings in file', 404);
            }
            $json['settings_by_store'][0] = $json['settings']; // backward compatibility
        }
        if ($this->module->getIsDemoMode()) {
            $this->respondWithError('Can not change settings in demo mode', 403);
        }
        if (!$this->user->hasPermission('modify', $this->getParentRoute())) {
            $this->respondWithError('You do not have permissions to change settings', 403);
        }
        if (VersionChecker::get()->isVersion3()) { // add prefix to settings for oc3
            foreach ($json['settings_by_store'] as $storeId => $settings) {
                foreach ($settings as $k => $v) {
                    if (strpos($k, 'shipping') !== 0) {
                        $json['settings_by_store'][$storeId]['shipping_' . $k] = $v;
                        unset($json['settings_by_store'][$storeId][$k]);
                    }
                }
            }
            foreach ($json['shared_settings'] as $storeId => $settings) {
                foreach ($settings as $k => $v) {
                    if (strpos($k, Configuration::SharedSettingsModuleGroup) !== 0) {
                        $json['shared_settings'][$storeId][Configuration::SharedSettingsModuleGroup . '_' . $k] = $v;
                        unset($json['shared_settings'][$storeId][$k]);
                    }
                }
            }
        } else { // drop settings prefix for not oc3
            foreach ($json['settings_by_store'] as $storeId => $settings) {
                foreach ($settings as $k => $v) {
                    if (strpos($k, 'shipping') === 0) {
                        $json['settings_by_store'][$storeId][preg_replace('/^shipping_(.*)/', '$1', $k)] = $v;
                        unset($json['settings_by_store'][$storeId][$k]);
                    }
                }
            }
            foreach ($json['shared_settings'] as $storeId => $settings) {
                foreach ($settings as $k => $v) {
                    if (strpos($k, Configuration::SharedSettingsModuleGroup) === 0) {
                        $json['shared_settings'][$storeId][preg_replace(
                            '/^' . Configuration::SharedSettingsModuleGroup . '(.*)/',
                            '$1',
                            $k
                        )] = $v;
                        unset($json['shared_settings'][$storeId][$k]);
                    }
                }
            }
        }
        foreach ($json['settings_by_store'] as $storeId => $settings) {
            $this->configuration->updateSettings(
                (VersionChecker::get()->isVersion3() ? 'shipping_' : '') . $this->module->getExtensionName(),
                $settings, $storeId
            );
        }
        foreach ($json['shared_settings'] as $storeId => $settings) {
            $this->configuration->updateSettings(
                (VersionChecker::get()->isVersion3() ? (Configuration::SharedSettingsModuleGroup . '_') : '') .
                Configuration::SharedSettingsModuleName,
                $settings, $storeId
            );
        }
        $this->smartRedirect($this->getParentRoute());
    }


    /**
     * Requests label(s) for the order
     * @since 05.01.2017 responses with JSON: next[redirect,ajax],error,api...
     */
    public function requestLabel() {
        $orderId = intval($this->request->get['order_id']);
        $orderInfo = $this->getOrderInformation($orderId);
        $this->configuration->changeStore($orderInfo['store_id']);
        $boxId = intval($this->request->get['box_id']);
        if (!$orderId) {
            $this->respondWithError('Can not find this order', 404);
        }
        if ($boxId === -1) { // all boxes
            $boxId = null;
        }
        if ($this->configuration->get('label') === Configuration::LabelDisabled) {
            $this->respondWithError('This feature is disabled in module settings');
        }
        $this->debugger->debug(Debugger::Trace, 'Requesting labels for order #' . $orderId . ' and ' .
            ($boxId === null ? 'all boxes' : 'box # ' . $boxId));
        try {
            $this->setUpProviders(); // issue #317
            $packagingList = PackagingListManager::requestLabels(
                $orderId, $boxId, $this->module, Array($this->debugger, 'debug'), $this->validationProvider,
                $this->labelsProvider, $this->paperlessProvider, $this->configuration, $this->converter,
                Array('country' => $this->model_localisation_country, 'zone' => $this->model_localisation_zone)
            );
            $history = array(
                'order_status_id' => $orderInfo['order_status_id'],
                'notify' => 0,
                'comment' => 'Shipping labels have been requested:' . "\n" . $packagingList->getStatusText(),
                'override' => 0
            );
            if (CoreFeatureChecker::hasMethod($this->model_sale_order, 'addOrderHistory')) { // v1
                $this->model_sale_order->addOrderHistory($orderId, $history);
                $this->respondWithText(Json::encodePretty(array(
                    'next' => 'redirect',
                    'error' => null,
                )), 'application/json');
            } elseif (CoreFeatureChecker::hasAdminModel('user/api')) { // v2 or v3
                $this->load->model('user/api');
                $apiInfo = $this->model_user_api->getApi($this->config->get('config_api_id'));
                if (VersionChecker::get()->isVersion3()) {
                    $session = new \Session($this->config->get('session_engine'), $this->registry);
                    $session->start();
                    $this->model_user_api->deleteApiSessionBySessonId($session->getId());
                    $this->model_user_api->addApiSession(
                        $apiInfo['api_id'], $session->getId(), $this->request->server['REMOTE_ADDR']
                    );
                    $session->data['api_id'] = $apiInfo['api_id'];
                    $apiInfo['api_token'] = $session->getId();
                }
                $this->respondWithText(Json::encodePretty(array(
                    'next' => 'ajax',
                    'error' => null,
                    'entry' => $this->getFrontUrl() . 'index.php?',
                    'api_id' => $apiInfo['api_id'],
                    'api_key' => isset($apiInfo['key']) ? $apiInfo['key'] : null,
                    'api_username' => isset($apiInfo['username']) ? $apiInfo['username'] : null,
                    'api_password' => isset($apiInfo['password']) ? $apiInfo['password'] : null,
                    'api_ip' => $this->request->server['REMOTE_ADDR'],
                    'api_token' => isset($apiInfo['api_token']) ? $apiInfo['api_token'] : null, // v3
                    'order_id' => $orderId,
                    'history' => $history
                )), 'application/json');
            } else {
                $this->respondWithText(Json::encodePretty(array(
                    'next' => 'redirect',
                    'error' => 'Can not find model to write order history'
                )), 'application/json');
            }
        } catch (\Exception $error) {
            $this->debugger->debug(Debugger::Error, $error->getMessage());
            $this->respondWithText(
                Json::encodePretty(array('error' => $error->getMessage())),
                'application/json'
            );
        }
    }

    /**
     * Shows document wrapper
     * @since 23.11.2017 uses module configuration for order store
     * @since 15.11.2018 accepts boxId=-1 to wrap merged labels
     */
    public function documentWrapper() {
        $orderId = intval($this->request->get['order_id']);
        $boxId = intval($this->request->get['box_id']);
        $documentId = isset($this->request->get['document_id']) ? (int)$this->request->get['document_id'] : null;
        $page = isset($this->request->get['page']) ? (int)$this->request->get['page'] : null;
        if (!$orderId) {
            $this->respondWithError('Can not find this order', 404);
        }
        $orderInfo = $this->getOrderInformation($orderId);
        $this->configuration->changeStore($orderInfo['store_id']);
        $fallback = Fallback::create()->setLabelFormatFromProvider($this->labelsProvider);
        $shipments = PackagingListManager::load($orderId, $fallback)->getShipments();
        if ($boxId === -1) { // wrap merged labels
            $this->data['document_link'] = $this->link($this->getParentRoute() . '/mergelabels',
                'order_id=' . $orderId);
            $this->data['document_format'] = AccompanyingDocument::FormatPDF;
        } else {
            if (!isset($shipments[$boxId])) {
                $this->respondWithError('Can not find this box in this order', 404);
            }
            $document = $shipments[$boxId]->getDocument($documentId);
            if (!$document) {
                $this->respondWithError('Can not find this document', 404);
            }
            $this->data['document_link'] = $this->link($this->getParentRoute() . '/document',
                'order_id=' . $orderId . '&box_id=' . $boxId . '&document_id=' . $documentId . '&page=' . $page);
            $this->data['document_format'] = (
                $this->configuration->get('label_format') === Configuration::LabelFormat4x6 &&
                $document->isLabel()
            ) ? AccompanyingDocument::FormatPNG : $document->getFormat();
        }
        $this->data['save_link'] = $this->data['document_link'] . '&save=1';
        $this->data['get_prefixed_name'] = Array($this->module, 'getPrefixedName');
        $this->data['get_extension_name'] = Array($this->module, 'getExtensionName');
        $this->data['has_feature'] = Array($this->module, 'hasFeature');
        $this->data['get_current_route'] = Array($this, 'getCurrentRoute');
        $this->data['version'] = $this->module->getVersion();
        echo ShippingView::replyDocumentWrapper($this->data);
        exit;
    }

    /**
     * Shows the label or some other document
     * @since 23.11.2017 uses module configuration for order store
     */
    public function document() {
        $orderId = intval($this->request->get['order_id']);
        $boxId = intval($this->request->get['box_id']);
        $documentId = intval($this->request->get['document_id']);
        $page = intval($this->request->get['page']);
        if (!$orderId) {
            $this->respondWithError('Can not find this order', 404);
        }
        $orderInfo = $this->getOrderInformation($orderId);
        $this->configuration->changeStore($orderInfo['store_id']);
        $fallback = Fallback::create()->setLabelFormatFromProvider($this->labelsProvider);
        $packagingList = PackagingListManager::load($orderId, $fallback);
        $address = $packagingList->getAddress();
        $shipments = $packagingList->getShipments();
        if (!isset($shipments[$boxId])) {
            $this->respondWithError('Can not find this box in this order', 404);
        }
        $document = $shipments[$boxId]->getDocument($documentId);
        if (!$document) {
            $this->respondWithError('Can not find this document', 404);
        }
        $data = base64_decode($document->getPage($page));
        $filename = isset($this->request->get['save']) ? strtolower($document->getType()) . '-' .
            $orderId . '-' . $boxId . '-'. $page . '.' : null;
        if (
            $this->configuration->get('label_format') === Configuration::LabelFormat4x6 &&
            $this->module->hasFeature(Features::ShippingLabel4x6Inches) &&
            $document->isLabel()
        ) { // requires 4x6 resizing
            $cutting = $this->labelsProvider->getLabelPosition($address);
            if ($document->getFormat() === AccompanyingDocument::FormatPDF) {
                try {
                    if ($this->configuration->get('pdf_converter') === Configuration::PdfConverterImagick) {
                        $data = Label::make4x6FromPdfImagick($data, $cutting);
                    } elseif ($this->configuration->get('pdf_converter') === Configuration::PdfConverterGmagick) {
                        $data = Label::make4x6FromPdfGmagick($data, $cutting);
                    } else {
                        $this->respondWithError('Unknown PDF converter selected', 404);
                    }
                } catch (\Exception $e) {
                    $this->respondWithError('Can not convert label. ' . $e->getMessage(), 500);
                }
            } elseif ($document->getFormat() === AccompanyingDocument::FormatPNG) {
                try {
                    $data = Label::make4x6FromPng($data, $cutting);
                } catch (\Exception $e) {
                    $this->respondWithError('Can not process label. ' . $e->getMessage(), 500);
                }
            } else {
                $this->respondWithError('Unknown labels format: ' . $document->getFormat(), 404);
            }
            $this->respondWithText($data, 'image/png', $filename ? $filename . 'png' : null);
            return;
        }
        $this->respondWithText(
            $data, $document->getFormat(),
            $filename ? $filename . $document->getExtension() : null
        );
    }

    /**
     * Voids shipping label
     * @since 23.11.2017 sets up providers according to store settings of module
     * @throws CoreFeatureException
     */
    public function voidLabel() {
        if (!$this->module->hasFeature(Features::ShippingLabelVoid)) {
            $this->respondWithError('Feature is not supported', 404);
        }
        $orderId = intval($this->request->get['order_id']);
        $boxId = intval($this->request->get['box_id']);
        if (!$orderId) {
            $this->respondWithError('Required: order_id', 400);
        }
        $orderInfo = $this->getOrderInformation($orderId);
        $this->configuration->changeStore($orderInfo['store_id']);
        $this->setUpProviders(); // issue #317
        $packagingList = PackagingListManager::load($orderId, Fallback::create()); // empty fallback
        $shipments = $packagingList->getShipments();
        if (!isset($shipments[$boxId])) {
            $this->respondWithError('Can not find this box in this order', 404);
        }
        $this->labelsProvider->setDebugger(Array($this->debugger, 'debug'));
        $shipments[$boxId] = $this->labelsProvider->voidLabel($orderId, $shipments[$boxId]);
        $packagingList = new PackagingList(array(
            'order_id' => $packagingList->getOrderId(),
            'service_name' => $packagingList->getServiceName(),
            'version' => $packagingList->getVersion(),
            'method_code' => $packagingList->getMethodCode(),
            'address' => $packagingList->getAddress(),
            'method_name' => $packagingList->getMethodName(),
            'customer_choice' => $packagingList->getCustomerChoice(),
            'shipments' => $shipments
        ));
        PackagingListManager::save($packagingList);
        $this->smartRedirect($this->getParentRoute() . '/packaginglist', 'order_id=' . $orderId);
    }

    public function packingMap() {
        $orderId = intval($this->request->get['order_id']);
        $boxId = intval($this->request->get['box_id']);
        if (!$orderId) {
            $this->respondWithError('Required: order_id', 400);
        }
        $packagingList = PackagingListManager::load($orderId, Fallback::create()); // empty fallback
        $shipments = $packagingList->getShipments();
        if (!isset($shipments[$boxId])) {
            $this->respondWithError('Can not find this box in this order', 404);
        }
        if (!$shipments[$boxId]->getBox()->getPackagingMap()) {
            $this->respondWithError('Can not find packing map for this box', 404);
        }
        $reservedSpace = $shipments[$boxId]->getBox()->getPackagingMap()->getReservedSpace();
        $this->data['get_prefixed_name'] = Array($this->module, 'getPrefixedName');
        $this->data['get_extension_name'] = Array($this->module, 'getExtensionName');
        $this->data['has_feature'] = Array($this->module, 'hasFeature');
        $this->data['get_current_route'] = Array($this, 'getCurrentRoute');
        $this->data['version'] = $this->module->getVersion();
        $texture = base64_encode(file_get_contents(
            DIR_APPLICATION . 'view/image/' . $this->module->getExtensionName() . '/carton.jpeg'
        ));
        $this->data['scene'] = Scene::generate(
            $shipments[$boxId]->getBox()->getInnerLength(),
            $shipments[$boxId]->getBox()->getInnerWidth(),
            $shipments[$boxId]->getBox()->getInnerHeight(),
            $reservedSpace, $texture
        );
        echo ShippingView::replyPackagingMap($this->data);
        exit;
    }

    /**
     * Returns the javascript to insert tracking number into order comment
     */
    public function tracking() {
        $orderId = intval($this->request->get['order_id']);
        if (!$orderId) {
            $this->respondWithError('Required: order_id', 400);
        }
        $orderInfo = $this->getOrderInformation($orderId);
        $this->configuration->changeStore($orderInfo['store_id']);
        if ($this->configuration->get('tracking') !== Configuration::TrackingSendShipped) {
            $this->respondWithError('Feature is not enabled', 404);
        }
        $packagingList = PackagingListManager::load($orderId, Fallback::create());
        if (!$packagingList) {
            $this->respondWithError('Packaging list not found', 404);
        }
        $trackingNumbers = array_filter(array_map(function($box) {
            /** @var Shipment $box */
            if ($box->hasLabel()) {
                return $box->getTrackingNumber() .
                    ($box->getTrackingUrl() ? "\nTrack online: " . $box->getTrackingUrl() : '');
            }
            return null;
        }, $packagingList->getShipments()));
        if (!$trackingNumbers) {
            $this->respondWithError('Tracking numbers not found', 404);
        }
        $result = 'Tracking numbers: ' . "\n\n" . implode("\n\n", $trackingNumbers);
        $this->respondWithText($result);
    }

    /**
     * Returns the tare weight of custom package
     * @see OriginFixed
     */
    public function tareOfCustomPackageFixed() {
        if (!(
            isset($this->request->get['length']) &&
            isset($this->request->get['width']) &&
            isset($this->request->get['height']) &&
            isset($this->request->get['measurement_system'])
        )) {
            $this->respondWithError('Required: length, width, height, measurement_system', 400);
        }
        $locale = new Locale($this->request->get['measurement_system']);
        $dimensions = array(
            $locale->acceptLength($this->request->get['length']),
            $locale->acceptLength($this->request->get['width']),
            $locale->acceptLength($this->request->get['height'])
        );
        if (array_filter($dimensions, function ($dim) {
            return $dim <= 0;
        })) {
            $this->respondWithError('All dimensions must be greater than zero', 400);
        }
        try {
            $weight = OriginPackage::createFromArray(array(
                'type' => $this->module->getCustomPackageFixedType(),
                'title' => '',
                'dimensions_outside' => $dimensions,
                'dimensions_inside' => $dimensions,
                'density' => OriginPackage::getCustomPackageDensity($this->module->getCustomPackageFixedType())
            ))->getTareWeightWithLocale($locale);
            $this->respondWithText($weight);
        } catch (\Exception $e) {
            $this->respondWithError($e->getMessage(), 400);
        }
    }

    /**
     * Returns the tare weight of custom package
     * @see OriginExpandable
     */
    public function tareOfCustomPackageExpandable() {
        if (!(
            isset($this->request->get['length']) &&
            isset($this->request->get['width']) &&
            isset($this->request->get['measurement_system'])
        )) {
            $this->respondWithError('Required: length, width, measurement_system', 400);
        }
        $locale = new Locale($this->request->get['measurement_system']);
        $length = $locale->acceptLength($this->request->get['length']);
        $width = $locale->acceptLength($this->request->get['width']);
        if ($length <= 0 || $width <= 0) {
            $this->respondWithError('Length and width must be greater than zero', 400);
        }
        try {
            $weight = OriginPackage::createFromArray(array(
                'type' => $this->module->getCustomPackageExpandableType(),
                'title' => '',
                'length' => $length,
                'width' => $width,
                'density' => OriginPackage::getCustomPackageDensity($this->module->getCustomPackageExpandableType())
            ))->getTareWeightWithLocale($locale);
            $this->respondWithText($weight);
        } catch (\Exception $e) {
            $this->respondWithError($e->getMessage(), 400);
        }

    }

    public function shareSetting() {
        if (!isset($this->request->get['keys'])) {
            $this->respondWithError('Required: keys', 400);
        }
        $keys = $this->request->get['keys'];
        if (!Arrays::containsAllOf($keys, Configuration::$shareableKeys)) {
            $this->respondWithError('Not allowed key used', 400);
        }
        if (!isset($this->request->get['value'])) {
            $this->respondWithError('Required: value');
        }
        $value = $this->toConfigBool($this->request->get['value']);
        if (!isset($this->request->get['store_id'])) {
            $this->respondWithError('Required: store_id');
        };
        $newValue = array_merge($this->configuration->get('shared_settings'), array_fill_keys($keys, $value));
        $this->configuration->changeStore($this->request->get['store_id']);
        $this->configuration->saveSharedSettingsValue($newValue);
        $this->respondWithText(Json::encodePretty($value), 'application/json');
    }

    public function mountWebhook() {
        if (!isset($this->request->get['user_id'])) {
            if ($this->module->getIsDemoMode()) {
                $this->request->get['user_id'] = $this->configuration->get('user_id');
            } else {
                $this->respondWithError('Required: user_id', 400);
            }
        }
        if (!$this->labelsProvider || !$this->module->hasFeature(Features::WebhookApi)) {
            $this->respondWithError('this feature is not supported');
        }
        $this->labelsProvider->setOption('user_id', $this->request->get['user_id']);
        $error = null;
        $hookIdProduction = null;
        $hookIdDeveloper = null;
        try {
            $hookIdProduction = $this->labelsProvider->mountWebhook($this->getWebhookUrl(), true);
            $hookIdDeveloper = $this->labelsProvider->mountWebhook($this->getWebhookUrl(), false);
        } catch (\Exception $e) {
            $error = $e->getMessage();
        }
        $this->respondWithText(
            Json::encode(array(
                'error' => (bool)$error,
                'message' => $error ?: 'Operational',
                'hookIdProduction' => $hookIdProduction,
                'hookIdDeveloper' => $hookIdDeveloper
            )),
            'application/json'
        );
    }

    /**
     * Controller entry method: data preparation and saving
     */
    public function index() {
        if (isset($this->session->data['success'])) {
            $this->data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        }

        $isPostMethod = $this->request->server['REQUEST_METHOD'] === 'POST';
        if ($isStoreDefined = isset($this->request->get['store_id'])) {
            $this->configuration->changeStore($this->request->get['store_id']);
        }

        $isLocaleChanged = isset($this->request->post['measurement_system_changed']);
        $isEqualConfigChanged = isset($this->request->post['equal_config_changed']);
        if ($isLocaleChanged) {
            $locale = new Locale($this->request->post['measurement_system_old']);
            $this->validateLocaleDepended($locale);
            $this->validateShippingCategories();
            $this->data['success'] = $this->language->get('text_measurement_system_changed');
        } elseif ($isEqualConfigChanged) {
            $newValue = $this->toConfigBool($this->getPost('equal_config'));
            $this->configuration->saveEqualConfigValue($newValue);
            $this->session->data['success'] = $this->language->get('text_equal_config_changed_' . $newValue);
            $this->smartRedirect($this->getCurrentRoute());
        } elseif ($isStoreDefined && !$isPostMethod) {
            $this->data['success'] = $this->language->get('text_store_changed');
        } elseif ($isPostMethod) {
            if ($this->validate()) {
                $this->configuration->saveAll($this->request->post);
                /**
                 * @since 22.11.2017 no redirects after save due to multiple store setting feature, issue #317
                 */
                $this->data['success'] = sprintf(
                    $this->language->get('text_success_modified'),
                    $this->module->getServiceName(),
                    $this->getCurrentStoreName()
                );
            } elseif (!isset($this->error['warning'])) {
                $this->error['warning'] = $this->language->get('error_save');
            }
        }
        $this->prepareData();
        $this->outputModuleSettings();
    }

    protected function prepareData() {
        // default translations
        $requiredTranslations = array_merge(
            $this->ratesProvider->getAllShippingMethodGroups('text'),
            $this->ratesProvider->getAllShippingMethods('text'),
            Helper::$requiredTranslations
        );

        foreach ($requiredTranslations as $key) {
            $this->data[$key] = $this->language->get($key);
        }

        // translations with parameter
        foreach (Helper::$translationsWithParameter as $key) {
            $this->data[$key] = sprintf($this->data[$key], $this->module->getServiceName());
        }
        $this->data['help_label_foreign_data'] = sprintf(
            $this->data['help_label_foreign_data'],
            $this->link('setting/store')
        );
        $this->data['license_info'] = sprintf($this->data['license_info'], $this->data['heading_title'],
            Author::WebsiteUrl, Author::WebsiteUrl, Author::LicenseUrl);

        // store data
        $this->data[$this->module->getPrefixedName('sender_name')] = $this->getStoreConfig('config_owner');
        $this->data[$this->module->getPrefixedName('sender_company')] = $this->getStoreConfig('config_name');
        $this->data[$this->module->getPrefixedName('sender_telephone')] = $this->getStoreConfig('config_telephone');
        if ($this->module->hasFeature(Features::SenderTelephone10Digits)) {
            if (strlen(
                preg_replace('/[^\d]/', '', $this->data[$this->module->getPrefixedName('sender_telephone')])
            ) !== 10) {
                $this->error['sender_telephone'] = $this->language->get('error_sender_telephone_10_digits');
            }
        }
        if ($this->module->hasFeature(Features::SenderTelephoneNotLonger15Digits)) {
            if (strlen(
                preg_replace('/[^\d]/', '', $this->data[$this->module->getPrefixedName('sender_telephone')])
            ) > 15) {
                $this->error['sender_telephone'] = $this->language->get('error_sender_telephone_not_longer_15_digits');
            }
        }

        foreach (Helper::$requiredErrors as $baseViewKey => $fieldKey) {
            $this->data[$baseViewKey] = isset($this->error[$fieldKey]) ? $this->error[$fieldKey] : '';
        }

        // nav controls
        Helper::buildNavControls(
            $this->data, Array($this, 'link'), $this->getCurrentRoute(), $this->configuration->getStoreId()
        );

        // input
        foreach (Configuration::$keys as $key) {
            $this->data[$this->module->getPrefixedName($key)] =
                isset($this->request->post[$this->module->getPrefixedName($key)]) ? // if post
                    $this->request->post[$this->module->getPrefixedName($key)] : // use post, else
                    $this->configuration->get($key); // use config (or default)
        }

        // models
        $this->load->model('localisation/weight_class');
        $this->load->model('localisation/length_class');
        $this->load->model('localisation/tax_class');
        $this->load->model('localisation/geo_zone');
        $this->load->model('catalog/category');
        $this->load->model('catalog/product');

        // selectors
        $this->data['displayed_statuses'] = Helper::getDisplayedStatuses($this->data);
        $this->data[$this->module->getPrefixedName('displayed_status')] =
            $this->data[$this->module->getPrefixedName('status_for_customers')] ?
                ($this->data[$this->module->getPrefixedName('status')] ?
                    Configuration::StatusEnabled : Configuration::StatusDisabled
                ) : Configuration::StatusOnlyForAdmin;
        $this->data['booleans'] = Helper::getBooleans($this->data);
        $this->data['modes'] = Helper::getModes($this->data);
        $this->data['machinables'] = Helper::getMachinables($this->data);
        $this->data['freight_classes'] = Helper::getFreightClasses($this->data);
        $this->data['debug_levels'] = Helper::getDebugLevels($this->data);
        $this->data['sortings'] = Helper::getSortings($this->data);
        $this->data['packers'] = Helper::getPackers($this->data, $this->module);
        $this->data['dropoffs'] = Helper::getDropoffs($this->data);
        $this->data['pickups'] = Helper::getPickups($this->data);
        $this->data['commercial_rates'] = Helper::getCommercialRates($this->data);
        $this->data['labels'] = Helper::getLabels($this->data);
        $this->data['trackings'] = Helper::getTrackings($this->data);
        $this->data['date_formats'] = Helper::getDateFormats();
        $this->data['recipient_address_types'] = Helper::getRecipientAddressTypes($this->data, $this->module);
        $this->data['hours'] = Helper::getHours($this->data);
        $this->data['google_holidays'] = Helper::$googleHolidays;
        $this->data[$this->module->getPrefixedName('google_import')] = 'en.usa#holiday@group.v.calendar.google.com';
        $this->data['measurement_systems'] = Helper::$measurementSystems;
        $this->data['label_formats'] = Helper::getLabelFormats($this->data, $this->module, $this->labelsProvider);
        $this->data['label_format_pdf'] = $this->module->hasFeature(Features::ShippingLabel) ?
            $this->labelsProvider->getLabelFormat() === AccompanyingDocument::FormatPDF : null;
        $this->data['pdf_converters'] = Helper::getPdfConverters($this->data, $this->module, $this->labelsProvider);
        $this->data['boxes'] = Helper::getBoxes($this->ratesProvider, Array($this, 'filterStandardPackages'));
        $this->data['weight_classes'] = Helper::getWeightClasses($this->data, $this->model_localisation_weight_class);
        $this->data['length_classes'] = Helper::getLengthClasses($this->data, $this->model_localisation_length_class);
        $this->data['tax_classes'] = Helper::getTaxClasses($this->data, $this->model_localisation_tax_class);
        $this->data['countries'] = $this->model_localisation_country->getCountries();
        $this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
        $this->data['customer_groups'] = $this->getCustomerGroups();
        $this->data['equal_config'] = Helper::getEqualConfig($this->data);
        $this->data['stores'] = Helper::getStores($this->model_setting_store, $this->config);
        $this->data['signatures'] = Helper::getSignatures($this->module, $this->data);
        $this->data['insurances'] = Helper::getInsurances($this->data);
        $this->data['signature_types'] = Helper::getSignatureTypes($this->data);
        $this->data['proofs_of_age'] = Helper::getProofsOfAge($this->module, $this->data);

        Helper::findPounds($this->data, $this->module);
        Helper::findInches($this->data, $this->module);
        Helper::buildModificationStatus($this->data, $this->isModEnabled(), $this->isModInstalled);

        $this->data['provider_currency'] = $this->module->getValueCurrencyCode(
            $this->configuration->getOriginCountryCode($this->model_localisation_country, $this->getPost('country_id'))
        );
        $this->data['provider_currency_found'] = $this->currency->has($this->data['provider_currency']);

        $systemCurrency = $this->getStoreConfig('config_currency');
        $this->data['system_currency'] = $systemCurrency;
        $this->data['currency_unit'] = $this->currency->getSymbolLeft($systemCurrency) ?:
            $this->currency->getSymbolRight($systemCurrency);

        // catalog
        $this->data['products_tree'] = Helper::buildProductsTree($this->db, $this->config);

        // shared settings
        $this->data['shareable_settings'] = Configuration::$shareableKeys;
        $this->data['is_shared_settings_extension_installed'] = $this->configuration->getIsSharedSettingsInstalled();

        $this->data['locale'] = new Locale($this->data[$this->module->getPrefixedName('measurement_system')]);
        $this->data['token'] = $this->session->data[self::getTokenName()];
        $this->data['token_name'] = self::getTokenName();
        $this->data['store_id'] = $this->configuration->getStoreId();
        $this->data['version'] = $this->module->getVersion();
        $this->data['is_demo_mode'] = $this->module->getIsDemoMode();
        $this->data['method_codes'] = $this->ratesProvider->getMethodCodes();
        $this->data['max_weight'] = $this->ratesProvider->getPackageMaxWeight(Address::inUnitedStates());
        $this->data['get_prefixed_name'] = Array($this->module, 'getPrefixedName');
        $this->data['get_extension_name'] = Array($this->module, 'getExtensionName');
        $this->data['get_current_route'] = Array($this, 'getCurrentRoute');
        $this->data['has_feature'] = Array($this->module, 'hasFeature');
        $this->data['export_settings_link'] = $this->link($this->getCurrentRoute() . '/exportsettings');
        $this->data['import_settings_link'] = $this->link($this->getCurrentRoute() . '/importsettings');
        $this->data['webhook'] = $this->getWebhookUrl();
        $this->data['license_cookie'] = $this->module->getPrefixedName('license_close');
        $this->data['custom_package_fixed_unit'] =
            OriginPackage::getCustomPackageTareUnitType($this->module->getCustomPackageFixedType());
        $this->data['custom_package_expandable_unit'] =
            OriginPackage::getCustomPackageTareUnitType($this->module->getCustomPackageExpandableType());
    }

    /**
     * Validates the input data before saving new settings
     * @return bool
     */
    protected function validate() {
        // required
        if ($this->module->getIsDemoMode()) {
            $this->error['warning'] = $this->language->get('error_demo');
            return false;
        }
        if (!$this->user->hasPermission('modify', $this->getCurrentRoute())) {
            $this->error['warning'] = sprintf(
                $this->language->get('error_permission'),
                $this->module->getServiceName()
            );
        }
        if (!in_array($this->getPost('measurement_system'), Configuration::$measureSystems, true)) {
            $this->error['measurement_system'] = $this->language->get('error_measurement_system');
        }
        $locale = new Locale($this->getPost('measurement_system'));
        if (!$this->getPost('user_id')) {
            $this->error['user_id'] = $this->language->get('error_user_id');
        }
        if (!$this->getPost('postcode')) {
            $this->error['postcode'] = $this->language->get('error_postcode');
        }
        if (!$this->getPost('pounds_id')) {
            $this->error['pounds_id'] = $this->language->get('error_required');
        }
        $this->setPost('pounds_id', (int)$this->getPost('pounds_id'));
        if (!$this->getPost('inches_id')) {
            $this->error['inches_id'] = $this->language->get('error_required');
        }
        $this->setPost('inches_id', (int)$this->getPost('inches_id'));
        if (!$this->currency->has(
            $this->module->getValueCurrencyCode($this->configuration->getOriginCountryCode(
                $this->model_localisation_country, $this->getPost('country_id')
            ))
        )) {
            $this->error['provider_currency'] = $this->language->get('error_provider_currency');
        }

        // shipping methods codes (bool)
        $methods = $this->getPost('methods');
        if (is_array($methods)) {
            foreach ($methods as $fullKey => $b) {
                $methods[$fullKey] = $this->toConfigBool($b);
            }
        } else {
            $this->setPost('methods', array());
        }
        $this->setPost('methods', $methods);

        // status
        $this->setPost('status', $this->toConfigBool(in_array(
            $this->getPost('displayed_status'),
            array(Configuration::StatusEnabled, Configuration::StatusOnlyForAdmin), true
        )));
        $this->setPost('status_for_customers', $this->toConfigBool(
            $this->getPost('displayed_status') !== Configuration::StatusOnlyForAdmin
        ));

        // boolean
        $this->setPost('display_time', $this->toConfigBool($this->getPost('display_time')));
        $this->setPost('display_weight', $this->toConfigBool($this->getPost('display_weight')));
        $this->setPost('processing_saturdays', $this->toConfigBool($this->getPost('processing_saturdays')));
        $this->setPost('processing_sundays', $this->toConfigBool($this->getPost('processing_sundays')));
        $this->setPost('all_geo_zones', $this->toConfigBool($this->getPost('all_geo_zones')));
        $this->setPost('all_customer_groups', $this->toConfigBool($this->getPost('all_customer_groups')));
        $this->setPost('avoid_delivery_saturdays', $this->toConfigBool($this->getPost('avoid_delivery_saturdays')));
        $this->setPost('avoid_delivery_sundays', $this->toConfigBool($this->getPost('avoid_delivery_sundays')));
        $this->setPost('individual_tare', $this->toConfigBool($this->getPost('individual_tare')));
        $this->setPost('equal_config', $this->toConfigBool($this->getPost('equal_config')));
        $this->setPost('invoice', $this->toConfigBool($this->getPost('invoice')));
        $this->setPost('paperless', $this->toConfigBool($this->getPost('paperless')));
        $this->setPost('prefer_satchels', $this->toConfigBool($this->getPost('prefer_satchels')));

        // signature
        if (!in_array($this->getPost('signature'), Configuration::$signatures, true)) {
            $this->setPost('signature', Configuration::SignatureNotRequired);
        }

        // signature type
        if (!in_array($this->getPost('signature_type'), Configuration::$signatureTypes, true)) {
            $this->setPost('signature_type', Configuration::DirectSignature);
        }

        // date format
        if (!in_array($this->getPost('date_format'), Configuration::$dateFormats, true)) {
            $this->setPost('date_format', Configuration::$dateFormats[0]);
        }

        // recipient address type
        if (!in_array($this->getPost('recipient_address_type'), Configuration::$recipientAddressTypes, true)) {
            $this->setPost('recipient_address_type', Configuration::RecipientAddressTypeDependsOnCompany);
        }

        // integer
        $this->setPost('tax_class_id', (int)$this->getPost('tax_class_id'));
        $this->setPost('sort_order', (int)$this->getPost('sort_order'));
        $this->setPost('proof_of_age', (int)$this->getPost('proof_of_age'));

        // processing days, int >= 0
        $this->setPost('processing_days', max(0, (int)$this->getPost('processing_days')));

        // fallback packer
        $this->setPost(
            'fallback_packer',
            $this->toConfigBool($this->getPost('fallback_packer')) ? Configuration::PackerIndividual : ''
        );

        // cutoff
        $cutoff = $this->getPost('cutoff');
        if ($cutoff !== Configuration::CutoffDisabled) {
            if (!preg_match('/\d{2}:\d{2}/', $cutoff)) {
                $cutoff = Configuration::CutoffDisabled;
            }
        }
        $this->setPost('cutoff', $cutoff);

        // debug level
        if (!in_array($this->getPost('debug'), Configuration::$debugLevels, true)) {
            $this->setPost('debug', Configuration::ShowNothingLogErrors);
        }

        // float
        $this->setPost('minimum_rate', (float)$this->getPost('minimum_rate'));
        $this->setPost('weight_adj_per', (float)$this->getPost('weight_adj_per'));
        $this->setPost('rate_adj_fix', (float)$this->getPost('rate_adj_fix'));
        $this->setPost('rate_adj_per', (float)$this->getPost('rate_adj_per'));
        $this->setPost('insurance_from', (float)$this->getPost('insurance_from'));
        $this->setPost('balance_min', (float)$this->getPost('balance_min'));
        $this->setPost('balance_inc', (float)$this->getPost('balance_inc'));

        // box maker width - float in range
        $boxMakerWidth = (float)$this->getPost('box_maker_width');
        $this->setPost('box_maker_width',
            (($boxMakerWidth >= 1) && ($boxMakerWidth <= 100)) ? $boxMakerWidth : 100
        );

        // holidays list
        $holidays = $this->getPost('processing_holidays');
        if (is_array($holidays)) {
            foreach ($holidays as $k => $holiday) {
                unset($holidays[$k]);
                if (is_array($holiday)) {
                    if (isset($holiday[0]) && isset($holiday[1])) {
                        $month = (int)$holiday[0];
                        $day = (int)$holiday[1];
                        if (in_array($month, range(1, 12), true) && in_array($day, range(1, 31), true)) {
                            $holidays[$k] = array($month, $day);
                        }
                    }
                }
            }
        } else {
            $holidays = array();
        }
        $this->setPost('processing_holidays', array_values($holidays));

        // geo zones
        $geoZones = $this->getPost('geo_zones');
        if (is_array($geoZones)) {
            foreach ($geoZones as $zone => $b) {
                unset($geoZones[$zone]);
                if ((int)$zone) {
                    $geoZones[(int)$zone] = (int)$b;
                }
            }
        } else {
            $geoZones = array();
        }
        $this->setPost('geo_zones', $geoZones);

        // customer groups
        $customerGroups = $this->getPost('customer_groups');
        if (is_array($customerGroups)) {
            foreach ($customerGroups as $group => $b) {
                unset($customerGroups[$group]);
                if ((int)$group) {
                    $customerGroups[(int)$group] = (int)$b;
                }
            }
        } else {
            $customerGroups = array();
        }
        $this->setPost('customer_groups', $customerGroups);

        // standard packages
        $standardPackages = $this->getPost('standard_packages');
        if (is_array($standardPackages)) {
            foreach ($standardPackages as $box => $b) {
                unset($standardPackages[$box]);
                if ((int)$box) {
                    $standardPackages[(int)$box] = (int)$b;
                }
            }
        } else {
            $this->setPost('standard_packages', array());
        }
        $this->setPost('standard_packages', $standardPackages);

        // adjustment rules
        $this->validateAdjustmentRules();

        // shipping categories
        $this->validateShippingCategories();

        // locale depended
        $this->validateLocaleDepended($locale);

        // features validation
        $this->validateFeatures();

        // custom product extended information
        $this->setPost('product_names', $this->configuration->get('product_names'));
        $this->setPost('product_countries', $this->configuration->get('product_countries'));
        $this->setPost('product_zones', $this->configuration->get('product_zones'));
        $this->setPost('product_hs_codes', $this->configuration->get('product_hs_codes'));

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    protected function validateShippingCategories() {
        $result = array();
        if (is_array($this->getPost('shipping_categories'))) {
            foreach ($this->getPost('shipping_categories') as $category) {
                if (isset($category['name']) && $category['name']) {
                    $result[] = array(
                        'name' => $category['name'],
                        'ship_together' => $this->toConfigBool(
                            isset($category['ship_together']) ? $category['ship_together'] : false
                        ),
                        'packages' => isset($category['packages']) && is_array($category['packages']) ?
                            $category['packages'] : array(),
                        'products' => isset($category['products']) ? array_unique(
                            array_filter(array_map('intval', explode(',', $category['products'])))
                        ) : array(),
                        'categories' => isset($category['categories']) ? array_unique(
                            array_filter(array_map('intval', explode(',', $category['categories'])))
                        ) : array()
                    );
                }
            }
        }
        $this->setPost('shipping_categories', $result);
    }

    protected function validateAdjustmentRules() {
        $result = array();
        if (is_array($this->getPost('adjustment_rules'))) {
            foreach ($this->getPost('adjustment_rules') as $rule) {
                $rule['rate_operator'] = in_array($rule['rate_operator'], Helper::$compareOperators, true) ?
                    $rule['rate_operator'] : null;
                $rule['total_operator'] = in_array($rule['total_operator'], Helper::$compareOperators, true) ?
                    $rule['total_operator'] : null;
                $rule['rate'] = $rule['rate'] === '' ? null : (float)$rule['rate'];
                $rule['total'] = $rule['total'] === '' ? null : (float)$rule['total'];
                $rule['fixed'] = $rule['fixed'] === '' ? null : (float)$rule['fixed'];
                $rule['percent'] = $rule['percent'] === '' ? null : (float)$rule['percent'];
                $rule['group'] = $rule['group'] === '' ? null : $rule['group'];
                $services = array();
                if (is_array($rule['services'])) {
                    $services = array_map('strval', $rule['services']);
                }
                $conditions = array();
                $actions = array();
                $grouping = null;
                if ($rule['rate_operator'] !== null && $rule['rate'] !== null) {
                    $conditions[] = array(
                        'type' => 'comparison',
                        'argument' => 'rate',
                        'operator' => $rule['rate_operator'],
                        'value' => $rule['rate']
                    );
                }
                if ($rule['total_operator'] !== null && $rule['total'] !== null) {
                    $conditions[] = array(
                        'type' => 'comparison',
                        'argument' => 'total',
                        'operator' => $rule['total_operator'],
                        'value' => $rule['total']
                    );
                }
                if ($services) {
                    $conditions[] = array(
                        'type' => 'services',
                        'services' => $services
                    );
                }
                if ($rule['fixed'] !== null) {
                    $actions[] = array(
                        'type' => 'rateFixed',
                        'value' => $rule['fixed']
                    );
                }
                if ($rule['percent'] !== null) {
                    $actions[] = array(
                        'type' => 'ratePercent',
                        'value' => $rule['percent']
                    );
                }
                if ($rule['group'] !== null) {
                    $grouping = array(
                        'title' => $rule['group']
                    );
                }
                $result[] = array(
                    'condition' => array(
                        'type' => 'logical',
                        'operator' => 'and',
                        'conditions' => $conditions,
                    ),
                    'actions' => $actions,
                    'grouping' => $grouping
                );
            }
        }
        $this->setPost('adjustment_rules', $result);
    }

    /**
     * @param Locale $locale
     */
    protected function validateLocaleDepended($locale) {
        // float
        $this->setPost('box_weight_adj_fix', $locale->acceptLargeWeight($this->getPost('box_weight_adj_fix')));
        $this->setPost('weight_adj_fix', $locale->acceptLargeWeight($this->getPost('weight_adj_fix')));
        $this->setPost('dimension_adj_fix', $locale->acceptLength($this->getPost('dimension_adj_fix')));
        $this->setPost('weight_based_limit', $locale->acceptLargeWeight($this->getPost('weight_based_limit')));
        $boxMakerLength = $this->getPost('box_maker_length');
        $this->setPost('box_maker_length', array(
            'min' => max(0, $locale->acceptLength(isset($boxMakerLength['min']) ? $boxMakerLength['min'] : 0)),
            'max' => max(0, $locale->acceptLength(isset($boxMakerLength['max']) ? $boxMakerLength['max'] : 0))
        ));
        $this->setPost('box_maker_weight_limit',
            max(0, $locale->acceptLargeWeight($this->getPost('box_maker_weight_limit')))
        );
        $this->setPost('box_maker_margin',
            max(0, $locale->acceptLength($this->getPost('box_maker_margin')))
        );

        // weight based faked box
        if ($this->module->hasFeature(Features::WeightBasedFakedBox) &&
            $this->getPost('packer') === Configuration::PackerWeightBased
        ) {
            if (( // canada: labels enabled but no contract id:
                $this->module->hasFeature(Features::FakedBoxRequiredForNonContractLabels) &&
                $this->module->hasFeature(Features::ShippingLabel) &&
                ($this->getPost('label') !== Configuration::LabelDisabled) &&
                !$this->getPost('contract_id')
            ) || !$this->module->hasFeature(Features::FakedBoxRequiredForNonContractLabels)) {
                $fakedBox = $this->getPost('weight_based_faked_box');
                $this->setPost('weight_based_faked_box', array(
                    'length' => $locale->acceptLength($fakedBox['length']),
                    'width' => $locale->acceptLength($fakedBox['width']),
                    'height' => $locale->acceptLength($fakedBox['height'])
                ));
                foreach ($this->getPost('weight_based_faked_box') as $v) {
                    if (!$v) {
                        $this->error['weight_based_faked_box'] = $this->language->get('error_weight_based_faked_box');
                    }
                }
            }
        }

        if ($this->getPost('packer') === Configuration::PackerBoxMaker) {
            $boxMakerLength = $this->getPost('box_maker_length');
            if ($boxMakerLength['min'] >= $boxMakerLength['max']) {
                $this->error['box_maker_length'] = $this->language->get('error_box_maker_length');
            }
        }

        if ($this->module->hasFeature(Features::MinimumOrderWeight)) {
            $this->setPost('minimal_order_weight', $locale->acceptLargeWeight($this->getPost('minimal_order_weight')));
        }

        // custom packages
        $customPackages = $this->getPost('custom_packages');
        if (!is_array($customPackages)) {
            $customPackages = array();
        }
        foreach ($customPackages as $k => $package) {
            unset($customPackages[$k]['package_id']);
            $customPackages[$k]['length'] = isset($package['length']) ? $locale->acceptLength($package['length']) : 0;
            $customPackages[$k]['width'] = isset($package['width']) ? $locale->acceptLength($package['width']) : 0;
            $customPackages[$k]['height'] = isset($package['height']) ? $locale->acceptLength($package['height']) : 0;
            $customPackages[$k]['max_load'] = isset($package['max_load']) ?
                $locale->acceptLargeWeight($package['max_load']) : 0;
            $customPackages[$k]['tare'] = isset($package['tare']) ? $locale->acceptSmallWeight($package['tare']) : 0;
            if (!($customPackages[$k]['length'] && $customPackages[$k]['width'] && $customPackages[$k]['height'])) {
                unset($customPackages[$k]);
            }
        }
        $this->setPost('custom_packages', $customPackages);

        // custom envelopes
        $customEnvelopes = $this->getPost('custom_envelopes');
        if (!is_array($customEnvelopes)) {
            $customEnvelopes = array();
        }
        foreach ($customEnvelopes as $k => $envelope) {
            unset($customEnvelopes[$k]['envelope_id']);
            $customEnvelopes[$k]['length'] = isset($envelope['length']) ?
                $locale->acceptLength($envelope['length']) : 0;
            $customEnvelopes[$k]['width'] = isset($envelope['width']) ? $locale->acceptLength($envelope['width']) : 0;
            $customEnvelopes[$k]['max_height'] = isset($envelope['max_height']) ?
                $locale->acceptLength($envelope['max_height']) : 0;
            $customEnvelopes[$k]['max_load'] = isset($envelope['max_load']) ?
                $locale->acceptLargeWeight($envelope['max_load']) : 0;
            $customEnvelopes[$k]['tare'] = isset($envelope['tare']) ? $locale->acceptSmallWeight($envelope['tare']) : 0;
            if (!($customEnvelopes[$k]['length'] && $customEnvelopes[$k]['width'])) {
                unset($customEnvelopes[$k]);
            }
        }
        $this->setPost('custom_envelopes', $customEnvelopes);

        // promo
        $promos = $this->getPost('promo');
        if (!is_array($promos)) {
            $promos = array();
        }
        foreach ($promos as $k => $promo) {
            unset($promos[$k]['promo_id']);
            $promos[$k]['length'] = isset($promo['length']) ? $locale->acceptLength($promo['length']) : 0;
            $promos[$k]['width'] = isset($promo['width']) ? $locale->acceptLength($promo['width']) : 0;
            $promos[$k]['height'] = isset($promo['height']) ? $locale->acceptLength($promo['height']) : 0;
            $promos[$k]['weight'] = isset($promo['weight']) ? $locale->acceptLargeWeight($promo['weight']) : 0;
            $promos[$k]['min_cost'] = isset($promo['min_cost']) ? (float)$promo['min_cost'] : 0;
            if (!($promos[$k]['length'] && $promos[$k]['width'] && $promos[$k]['height'] &&
                $promos[$k]['weight'] && $promos[$k]['min_cost'])
            ) {
                unset($promos[$k]);
            }
        }
        usort($promos, function($a, $b) {
            if ($a['min_cost'] < $b['min_cost']) {
                return -1;
            }
            return 1;
        });
        $this->setPost('promo', $promos);
    }

    protected function validateFeatures() {
        if ($this->module->hasFeature(Features::ShippingLabel)) {
            $this->setPost('label', in_array($this->getPost('label'), Configuration::$labelOptions, true) ?
                $this->getPost('label') : Configuration::LabelDisabled);
        }

        if ($this->module->hasFeature(Features::ShipperAddress) ||
            (
                $this->module->hasFeature(Features::ShippingLabel) &&
                $this->isModEnabled() &&
                in_array($this->getPost('label'), Configuration::$labelOptionsEnabled, true)
            )
        ) {
            if (!$this->getPost('country_id')) {
                $this->error['country_id'] = $this->language->get('error_country_id');
            }
            $shipperCountryInfo = $this->model_localisation_country->getCountry($this->getPost('country_id'));
            if ($this->module->isCountryRequiresZone($shipperCountryInfo['iso_code_2'])) {
                if (!$this->getPost('zone_id')) {
                    $this->error['zone_id'] = $this->language->get('error_zone_id');
                }
            }
            if (!$this->getPost('city')) {
                $this->error['city'] = $this->language->get('error_city');
            }
            if (!$this->getPost('address')) {
                $this->error['address'] = $this->language->get('error_address');
            }
            $this->setPost('country_id', (int)$this->getPost('country_id'));
            $this->setPost('zone_id', (int)$this->getPost('zone_id'));
            $this->setPost('residential', $this->toConfigBool($this->getPost('residential')));
        }

        if ($this->module->hasFeature(Features::ShippingLabelRequiresCustomerNumber) &&
            $this->module->hasFeature(Features::AuthCustomerNumber) &&
            $this->isModEnabled() &&
            $this->getPost('label') !== Configuration::LabelDisabled &&
            !$this->getPost('customer_number')
        ) {
            $this->error['customer_number'] = $this->language->get('error_customer_number');
        }

        if ($this->module->hasFeature(Features::RequiresCustomerNumber) && !$this->getPost('customer_number')) {
            $this->error['customer_number'] = $this->language->get('error_customer_number');
        }

        if ($this->module->hasFeature(Features::Insurance)) {
            $this->setPost('insurance', in_array($this->getPost('insurance'), Configuration::$insurances, true) ?
                $this->getPost('insurance') : Configuration::InsuranceDisabled);
        }

        if ($this->module->hasFeature(Features::AuthKey)) {
            if (!$this->getPost('key')) {
                $this->error['key'] = $this->language->get('error_key');
            }
        }

        if ($this->module->hasFeature(Features::AuthPassword)) {
            if (!$this->getPost('password')) {
                $this->error['password'] = $this->language->get('error_password');
            }
        }

        if ($this->module->hasFeature(Features::AuthMeter)) {
            if (!$this->getPost('meter')) {
                $this->error['meter'] = $this->language->get('error_meter');
            }
        }

        if ($this->module->hasFeature(Features::Dropoff)) {
            if (!$this->getPost('dropoff')) {
                $this->error['dropoff'] = $this->language->get('error_dropoff');
            }
        }

        if ($this->module->hasFeature(Features::Pickup)) {
            if (!$this->getPost('pickup')) {
                $this->error['pickup'] = $this->language->get('error_pickup');
            }
        }

        if ($this->module->hasFeature(Features::AccountRates)) {
            $this->setPost('account_rates', $this->toConfigBool($this->getPost('account_rates')));
        }

        if ($this->module->hasFeature(Features::ProductionMode)) {
            $this->setPost('production', $this->toConfigBool($this->getPost('production')));
        }

        if ($this->module->hasFeature(Features::CommercialRates)) {
            if (!$this->getPost('commercial_rates')) {
                $this->error['commercial_rates'] = $this->language->get('error_required');
            }
        }

        if ($this->module->hasFeature(Features::OriginZip5Digits)) {
            $postCodeFiltered = substr(preg_replace('/[^\d]/', '', $this->getPost('postcode')), 0, 5);
            if (strlen($postCodeFiltered) < 5) {
                $this->error['postcode'] = $this->language->get('error_postcode');
            }
            $this->setPost('postcode', $postCodeFiltered);
        }

        if ($this->module->hasFeature(Features::OriginZip6Alphanumeric)) {
            $postCodeFiltered = substr(preg_replace('/[^A-Z0-9]/', '', strtoupper($this->getPost('postcode'))), 0, 6);
            if (strlen($postCodeFiltered) < 6) {
                $this->error['postcode'] = $this->language->get('error_postcode');
            }
            $this->setPost('postcode', $postCodeFiltered);
        }

        if ($this->module->hasFeature(Features::BillingAddress) && !$this->getPost('billing_same')) {
            if (!$this->getPost('billing_country_id')) {
                $this->error['billing_country_id'] = $this->language->get('error_billing_country_id');
            }
            if (!$this->getPost('billing_zone_id')) {
                $this->error['billing_zone_id'] = $this->language->get('error_billing_zone_id');
            }
            if (!$this->getPost('billing_city')) {
                $this->error['billing_city'] = $this->language->get('error_billing_city');
            }
            if (!$this->getPost('billing_postcode')) {
                $this->error['billing_postcode'] = $this->language->get('error_billing_postcode');
            }
            if (!$this->getPost('billing_address')) {
                $this->error['billing_address'] = $this->language->get('error_billing_address');
            }
            $this->setPost('billing_country_id', (int)$this->getPost('billing_country_id'));
            $this->setPost('billing_zone_id', (int)$this->getPost('billing_zone_id'));
        }

        if (!$this->module->hasFeature(Features::AddressValidation)) {
            if ($this->getPost('recipient_address_type') === Configuration::RecipientAddressTypeValidated) {
                $this->setPost('recipient_address_type', Configuration::RecipientAddressTypeDependsOnCompany);
            }
        }
    }

    /**
     * Performs module settings View render
     * @throws CoreFeatureException
     */
    protected function outputModuleSettings() {
        if (property_exists($this, 'template') &&
            property_exists($this, 'children') &&
            CoreFeatureChecker::hasMethod($this, 'render')
        ) { // v1
            $headerStrings = array('direction', 'lang', 'title', 'base', 'description', 'keywords', 'text_confirm',
                'home', 'logged');
            $headerArrays = array('links', 'styles', 'scripts');
            foreach ($headerStrings as $key) {
                $this->data[$key] = isset($this->data[$key]) ? $this->data[$key] : '';
            }
            foreach ($headerArrays as $key) {
                $this->data[$key] = isset($this->data[$key]) ? $this->data[$key] : array();
            }
            $this->template = 'common/header.tpl'; // first render other template to prefetch children
            $this->children = array(
                'common/header',
                'common/footer',
            );
            $this->render();
        } elseif (CoreFeatureChecker::hasProperty($this, 'load')) { // v2 or v3
            $this->data['header'] = $this->load->controller('common/header');
            $this->data['column_left'] = $this->load->controller('common/column_left');
            $this->data['footer'] = $this->load->controller('common/footer');
        } else {
            throw new CoreFeatureException('Can not find render method');
        }
        echo ShippingView::renderModuleSettings($this->data);
        exit;
    }

    /**
     * @param string $text
     * @param string $contentType
     * @param null|string $downloadFilename Force to download with this filename
     */
    protected function respondWithText($text, $contentType = 'text/plain', $downloadFilename = null) {
        header('Content-Type: ' . $contentType);
        if ($downloadFilename) {
            header('Content-Disposition: attachment; filename=' . $downloadFilename);
            header('Pragma: no-cache');
        }
        echo $text;
        exit;
    }

    /**
     * @param string $errorMessage
     * @param int $code HTTP Error Code
     */
    protected function respondWithError($errorMessage = '', $code = 404) {
        switch ($code) {
            // @codingStandardsIgnoreStart
            case 100: $text = 'Continue'; break;
            case 101: $text = 'Switching Protocols'; break;
            case 200: $text = 'OK'; break;
            case 201: $text = 'Created'; break;
            case 202: $text = 'Accepted'; break;
            case 203: $text = 'Non-Authoritative Information'; break;
            case 204: $text = 'No Content'; break;
            case 205: $text = 'Reset Content'; break;
            case 206: $text = 'Partial Content'; break;
            case 300: $text = 'Multiple Choices'; break;
            case 301: $text = 'Moved Permanently'; break;
            case 302: $text = 'Moved Temporarily'; break;
            case 303: $text = 'See Other'; break;
            case 304: $text = 'Not Modified'; break;
            case 305: $text = 'Use Proxy'; break;
            case 400: $text = 'Bad Request'; break;
            case 401: $text = 'Unauthorized'; break;
            case 402: $text = 'Payment Required'; break;
            case 403: $text = 'Forbidden'; break;
            case 404: $text = 'Not Found'; break;
            case 405: $text = 'Method Not Allowed'; break;
            case 406: $text = 'Not Acceptable'; break;
            case 407: $text = 'Proxy Authentication Required'; break;
            case 408: $text = 'Request Time-out'; break;
            case 409: $text = 'Conflict'; break;
            case 410: $text = 'Gone'; break;
            case 411: $text = 'Length Required'; break;
            case 412: $text = 'Precondition Failed'; break;
            case 413: $text = 'Request Entity Too Large'; break;
            case 414: $text = 'Request-URI Too Large'; break;
            case 415: $text = 'Unsupported Media Type'; break;
            case 500: $text = 'Internal Server Error'; break;
            case 501: $text = 'Not Implemented'; break;
            case 502: $text = 'Bad Gateway'; break;
            case 503: $text = 'Service Unavailable'; break;
            case 504: $text = 'Gateway Time-out'; break;
            case 505: $text = 'HTTP Version not supported'; break;
            // @codingStandardsIgnoreEnd
            default:
                $code = 500;
                $text = 'Internal Server Error';
        }
        $protocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');
        header($protocol . ' ' . $code . ' ' . $text);
        $this->respondWithText($errorMessage);
    }

    /**
     * Performs redirect to menu of shipping extensions depending on engine version
     * @param string $path
     * @param string $args
     * @throws CoreFeatureException
     */
    protected function smartRedirect($path, $args = '') {
        $args = $args ? '&' . $args : '';
        if (CoreFeatureChecker::hasMethod($this, 'redirect')) { // v1
            $this->redirect($this->link($path, $args));
        } elseif (CoreFeatureChecker::hasProperty($this, 'response')) { // v2
            $this->response->redirect($this->link($path, $args));
        } else {
            throw new CoreFeatureException('Can not find redirect method');
        }
    }

    /**
     * Returns customer groups depending on engine version
     * @return array
     * @throws CoreFeatureException
     */
    protected function getCustomerGroups() {
        if (CoreFeatureChecker::hasAdminModel('customer/customer_group')) { // v2
            $this->load->model('customer/customer_group');
            return $this->model_customer_customer_group->getCustomerGroups();
        } elseif (CoreFeatureChecker::hasAdminModel('sale/customer_group')) { // v1
            $this->load->model('sale/customer_group');
            return $this->model_sale_customer_group->getCustomerGroups();
        } else {
            throw new CoreFeatureException('Can not load customer group model');
        }
    }

    /**
     * Returns current store name
     * @return string
     */
    protected function getCurrentStoreName() {
        foreach (Helper::getStores($this->model_setting_store, $this->config) as $store) {
            if ((int)$store['store_id'] === $this->configuration->getStoreId()) {
                return $store['name'];
            }
        }
        return '';
    }

    /**
     * @param string $key
     * @return mixed|null
     */
    protected function getStoreConfig($key) {
        if (!isset($this->storesConfig[$this->configuration->getStoreId()])) {
            $this->storesConfig[$this->configuration->getStoreId()] =
                $this->model_setting_setting->getSetting('config', $this->configuration->getStoreId());
        }
        return isset($this->storesConfig[$this->configuration->getStoreId()][$key]) ?
            $this->storesConfig[$this->configuration->getStoreId()][$key] : null;
    }

    /**
     * Returns information about order
     * @param int $orderId
     * @throws CoreFeatureException
     * @return array
     * @since 23.11.2017 fixed model name to sale/order
     */
    protected function getOrderInformation($orderId) {
        if (CoreFeatureChecker::hasAdminModel('sale/order')) {
            $this->load->model('sale/order');
            return $this->model_sale_order->getOrder($orderId);
        } else {
            throw new CoreFeatureException('Can not load order model');
        }
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Controls\Tab;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Controls\Select;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Controls\Input;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\ViewLoader;

class ShippingView {
    public static function renderModuleSettings($data) {
        $viewBuilder = ViewLoader::getViewBuilder($data);

        /**
         * Shipper Address is an array of rendered controls
         * 0 - Controls to show before Origin Postcode (default control)
         * 1 - Controls to show after Origin Postcode
         * 2 - Optional controls (Residential)
         * @var string[] $shipperAddressHtml
         */
        $shipperAddressHtml[0] = $viewBuilder->renderSetting('entry_country_id', '', 'error_country_id', true,
            $viewBuilder->renderSelect(Select::create()
                ->setNameKey('country_id')
                ->setSourceKey('countries')
                ->setValueField('country_id')
                ->setCaptionField('name')),
            array('country_id'));
        $shipperAddressHtml[0] .= $viewBuilder->renderSetting('entry_zone_id', 'help_zone_id', 'error_zone_id', true,
            $viewBuilder->renderSelect(Select::create()
                ->setNameKey('zone_id')),
            array('zone_id'));
        $shipperAddressHtml[0] .= $viewBuilder->renderSetting('entry_city', '', 'error_city', true,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('city')),
            array('city'));
        $shipperAddressHtml[1] = $viewBuilder->renderSetting('entry_address', '', 'error_address', true,
            $viewBuilder->renderTextarea(Input::create()
                ->setNameKey('address')),
            array('address'));
        $shipperAddressHtml[2] = $viewBuilder->renderSetting('entry_residential', 'help_residential', '', true,
            $viewBuilder->renderOptions(Select::create()
                ->setNameKey('residential')
                ->setSourceKey('booleans')),
            array('residential'));

        /**
         * Tab General
         */
        $tabGeneralHtml = $viewBuilder->renderSetting('entry_mod', '', '', false,
            $viewBuilder->renderStatic($data['mod_status'])
        );
        $tabGeneralHtml .= $viewBuilder->renderSetting('entry_status', '', '', false,
            $viewBuilder->renderOptions(Select::create()
                ->setNameKey('displayed_status')
                ->setSourceKey('displayed_statuses')));
        $tabGeneralHtml .= $viewBuilder->renderMeasurementSystem();
        $tabGeneralHtml .= $viewBuilder->renderSetting('entry_user_id', 'help_user_id', 'error_user_id', true,
            $data['is_demo_mode'] ?
                $viewBuilder->renderStatic($data['demo_disabled']) :
                $viewBuilder->renderInput(Input::create()
                    ->setNameKey('user_id')));
        if ($viewBuilder->hasFeature(Features::AuthKey)) {
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_key', 'help_key', 'error_key', true,
                $data['is_demo_mode'] ?
                    $viewBuilder->renderStatic($data['demo_disabled']) :
                    $viewBuilder->renderInput(Input::create()
                        ->setNameKey('key')));
        }
        if ($viewBuilder->hasFeature(Features::AuthPassword)) {
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_password', '', 'error_password', true,
                $data['is_demo_mode'] ?
                    $viewBuilder->renderStatic($data['demo_disabled']) :
                    $viewBuilder->renderInput(Input::create()
                        ->setNameKey('password')));
        }
        if ($viewBuilder->hasFeature(Features::AuthMeter)) {
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_meter', '', 'error_meter', true,
                $data['is_demo_mode'] ?
                    $viewBuilder->renderStatic($data['demo_disabled']) :
                    $viewBuilder->renderInput(Input::create()
                        ->setNameKey('meter')));
        }
        if ($viewBuilder->hasFeature(Features::AuthCustomerNumber)) {
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_customer_number', 'help_customer_number',
                'error_customer_number', $viewBuilder->hasFeature(Features::RequiresCustomerNumber),
                $data['is_demo_mode'] ? $viewBuilder->renderStatic($data['demo_disabled']) :
                    $viewBuilder->renderInput(Input::create()
                        ->setNameKey('customer_number')));
        }
        if ($viewBuilder->hasFeature(Features::AuthContractId)) {
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_contract_id', 'help_contract_id', '', false,
                $data['is_demo_mode'] ?
                    $viewBuilder->renderStatic($data['demo_disabled']) :
                    $viewBuilder->renderInput(Input::create()
                        ->setNameKey('contract_id')));
        }
        if ($viewBuilder->hasFeature(Features::PromoCode)) {
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_promo_code', 'help_promo_code', '', false,
                $viewBuilder->renderInput(Input::create()
                    ->setNameKey('promo_code')));
        }
        if ($viewBuilder->hasFeature(Features::ProductionMode)) {
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_production', 'help_production', '', true,
                $viewBuilder->renderSelect(Select::create()
                    ->setNameKey('production')
                    ->setSourceKey('modes')));
        }
        if ($viewBuilder->hasFeature(Features::HubId)) {
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_hubid', 'help_hubid', '', false,
                $viewBuilder->renderInput(Input::create()
                    ->setNameKey('hubid')));
        }
        if ($viewBuilder->hasFeature(Features::ShipperAddress)) {
            $tabGeneralHtml .= $shipperAddressHtml[0]; // before origin postcode
        }
        $tabGeneralHtml .= $viewBuilder->renderSetting('entry_postcode', '', 'error_postcode', true,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('postcode')),
            array('postcode'));
        if ($viewBuilder->hasFeature(Features::ShipperAddress)) { // after origin postcode + optional
            $tabGeneralHtml .= $shipperAddressHtml[1] . $shipperAddressHtml[2];
        }
        if ($viewBuilder->hasFeature(Features::BillingAddress)) {
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_billing_same', 'help_billing_same', '', false,
                $viewBuilder->renderOptions(Select::create()
                    ->setNameKey('billing_same')
                    ->setSourceKey('booleans')));
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_billing_country_id', '', 'error_billing_country_id',
                true, $viewBuilder->renderSelect(Select::create()
                    ->setNameKey('billing_country_id')
                    ->setSourceKey('countries')
                    ->setValueField('country_id')
                    ->setCaptionField('name')));
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_billing_zone_id', '', 'error_billing_zone_id', true,
                $viewBuilder->renderSelect(Select::create()
                    ->setNameKey('billing_zone_id')));
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_billing_city', '', 'error_billing_city', true,
                $viewBuilder->renderInput(Input::create()
                    ->setNameKey('billing_city')));
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_billing_postcode', '', 'error_billing_postcode', true,
                $viewBuilder->renderInput(Input::create()
                    ->setNameKey('billing_postcode')));
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_billing_address', '', 'error_billing_address', true,
                $viewBuilder->renderTextarea(Input::create()
                    ->setNameKey('billing_address')));
        }
        $tabGeneralHtml .= $viewBuilder->renderSetting('entry_sort_order', 'help_sort_order', '', false,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('sort_order')));
        if ($data['pounds_found']) {
            $tabGeneralHtml .= $viewBuilder->renderHidden(Input::create()
                ->setNameKey('pounds_id'));
        } else {
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_pounds', 'help_pounds', 'error_pounds_id', true,
                $viewBuilder->renderSelect(Select::create()
                    ->setNameKey('pounds_id')
                    ->setSourceKey('weight_classes')
                    ->setValueField('weight_class_id')
                    ->setCaptionField('title')));
        }
        if ($data['inches_found']) {
            $tabGeneralHtml .= $viewBuilder->renderHidden(Input::create()
                ->setNameKey('inches_id'));
        } else {
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_inches', 'help_inches', 'error_inches_id', true,
                $viewBuilder->renderSelect(Select::create()
                    ->setNameKey('inches_id')
                    ->setSourceKey('length_classes')
                    ->setValueField('length_class_id')
                    ->setCaptionField('title')));
        }
        if (!$data['provider_currency_found']) {
            $tabGeneralHtml .= $viewBuilder->renderSetting('entry_provider_currency', 'help_provider_currency',
                'error_provider_currency', true, $viewBuilder->renderStatic('Currency with ISO code <code>' .
                $data['provider_currency'] . '</code> is required for this extension to convert prices'));
        }
        $tabGeneralHtml .= $viewBuilder->renderSetting('entry_debug', 'help_debug', '', false,
            $viewBuilder->renderSelect(Select::create()
                ->setNameKey('debug')
                ->setSourceKey('debug_levels')), array('debug'));
        $tabGeneralHtml .= $viewBuilder->renderSetting('entry_version', '', '', false,
            $viewBuilder->renderStatic($data['version']));
        $tabGeneralHtml .= $viewBuilder->renderSetting('entry_contact', '', '', false, $viewBuilder->renderContact());
        $tabGeneralHtml .= $viewBuilder->renderSetting('entry_maintenance', '', '', false,
            $viewBuilder->renderMaintenance());
        $tabGeneral = Tab::create()
            ->setId('tab-ext-general')
            ->setTitleKey('tab_general')
            ->setIsDefault(true)
            ->setContent($tabGeneralHtml);

        /**
         * Tab Package
         */
        $tabPackageHtml = '';
        if ($viewBuilder->hasFeature(Features::Machinable)) {
            $tabPackageHtml = $viewBuilder->renderSetting('entry_machinable', 'help_machinable', '', false,
                $viewBuilder->renderOptions(Select::create()
                    ->setNameKey('machinable')
                    ->setSourceKey('machinables')));
        }
        $tabPackageHtml .= $viewBuilder->renderSetting('entry_packer', 'help_packer', '', false,
            $viewBuilder->renderPacker());
        $tabPackageHtml .= $viewBuilder->renderSetting('entry_individual_tare', 'help_individual_tare', '', false,
            $viewBuilder->renderOptions(Select::create()
                ->setNameKey('individual_tare')
                ->setSourceKey('booleans')));
        if ($viewBuilder->hasFeature(Features::WeightBasedFakedBox)) {
            $tabPackageHtml .= $viewBuilder->renderSetting('entry_weight_based_faked_box',
                'help_weight_based_faked_box', 'error_weight_based_faked_box',
                // FakedBoxRequiredForNonContractLabels - specific case to handle by controller, canada
                !$viewBuilder->hasFeature(Features::FakedBoxRequiredForNonContractLabels),
                $viewBuilder->renderWeightBasedFakedBox());
        }
        $tabPackageHtml .= $viewBuilder->renderSetting('entry_weight_based_limit', 'help_weight_based_limit', '', false,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('weight_based_limit')
                ->setCssClass('small-number')
                ->setPrerender(Array($viewBuilder, 'prerenderLargeWeightWithEmpty'))
                ->setAddons(null, $viewBuilder->getLocale()->renderLargeWeightUnit())
            ));
        $tabPackageHtml .= $viewBuilder->renderSetting('entry_box_maker_length', 'help_box_maker_length',
            'error_box_maker_length', true, $viewBuilder->renderBoxMakerLength());
        $tabPackageHtml .= $viewBuilder->renderSetting('entry_box_maker_width', 'help_box_maker_width', '', false,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('box_maker_width')
                ->setCssClass('small-number')
                ->setAddons(null, '%')));
        $tabPackageHtml .= $viewBuilder->renderSetting('entry_box_maker_weight_limit', 'help_box_maker_weight_limit',
            '', false, $viewBuilder->renderInput(Input::create()
                ->setNameKey('box_maker_weight_limit')
                ->setCssClass('small-number')
                ->setPrerender(Array($viewBuilder, 'prerenderLargeWeightWithEmpty'))
                ->setAddons(null, $viewBuilder->getLocale()->renderLargeWeightUnit())
            ));
        $tabPackageHtml .= $viewBuilder->renderSetting('entry_box_maker_margin', 'help_box_maker_margin', '', false,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('box_maker_margin')
                ->setCssClass('small-number')
                ->setPrerender(Array($viewBuilder, 'prerenderLengthWithEmpty'))
                ->setAddons(null, $viewBuilder->getLocale()->renderLengthUnit())
            ));
        if ($viewBuilder->hasFeature(Features::StandardPackages)) {
            $tabPackageHtml .= $viewBuilder->renderSetting(
                'entry_standard_packages', 'help_standard_packages', '', false, $viewBuilder->renderStandardPackages()
            );
        }
        if ($viewBuilder->hasFeature(Features::CustomPackages)) {
            $tabPackageHtml .= $viewBuilder->renderSetting('entry_custom_packages', 'help_custom_packages', '', false,
                $viewBuilder->renderCustomPackagesFixed(), array('custom_packages'));
            $tabPackageHtml .= $viewBuilder->renderSetting('entry_custom_envelopes', 'help_custom_envelopes', '', false,
                $viewBuilder->renderCustomPackagesExpandable(), array('custom_envelopes'));
        }
        if (
            $viewBuilder->hasFeature(Features::StandardPackages) ||
            $viewBuilder->hasFeature(Features::CustomPackages)
        ) {
            $tabPackageHtml .= $viewBuilder->renderSetting(
                'entry_shipping_categories', 'help_shipping_categories', '', false,
                $viewBuilder->renderShippingCategories(), array('shipping_categories')
            );
        }
        $tabPackageHtml .= $viewBuilder->renderSetting(
            'entry_promo', 'help_promo', '', false, $viewBuilder->renderPromo()
        );
        $tabPackage = Tab::create()
            ->setId('tab-ext-package')
            ->setTitleKey('tab_package')
            ->setContent($tabPackageHtml);

        /**
         * Tab Shipping
         */
        $tabShippingHtml = $viewBuilder->renderSetting(
            'entry_processing_days', 'help_processing_days', '', false, $viewBuilder->renderProcessing(),
            array('processing_days', 'processing_saturdays', 'processing_sundays')
        );
        $tabShippingHtml .= $viewBuilder->renderSetting(
            'entry_processing_holidays', 'help_processing_holidays', '', false, $viewBuilder->renderHolidays(),
            array('processing_holidays')
        );
        $tabShippingHtml .= $viewBuilder->renderSetting(
            'entry_cutoff', 'help_cutoff', '', false, $viewBuilder->renderCutoff(), array('cutoff')
        );
        $tabShippingHtml .= $viewBuilder->renderSetting(
            'entry_avoid_delivery', 'help_avoid_delivery', '', false, $viewBuilder->renderAvoidDelivery()
        );
        if ($viewBuilder->hasFeature(Features::AccountRates)) {
            $tabShippingHtml .= $viewBuilder->renderSetting('entry_account_rates', '', '', false,
                $viewBuilder->renderOptions(Select::create()
                    ->setNameKey('account_rates')
                    ->setSourceKey('booleans')));
        }
        if ($viewBuilder->hasFeature(Features::CommercialRates)) {
            $tabShippingHtml .= $viewBuilder->renderSetting('entry_commercial_rates', '', 'error_commercial_rates',
                true, $viewBuilder->renderSelect(Select::create()
                    ->setNameKey('commercial_rates')
                    ->setSourceKey('commercial_rates')));
        }
        if ($viewBuilder->hasFeature(Features::Insurance)) {
            $tabShippingHtml .= $viewBuilder->renderSetting('entry_insurance', 'help_insurance', '', false,
                $viewBuilder->renderInsurance());
        }
        if ($viewBuilder->hasFeature(Features::Dropoff)) {
            $tabShippingHtml .= $viewBuilder->renderSetting('entry_dropoff', '', 'error_dropoff', true,
                $viewBuilder->renderSelect(Select::create()
                    ->setNameKey('dropoff')
                    ->setSourceKey('dropoffs')));
        }
        if ($viewBuilder->hasFeature(Features::Pickup)) {
            $tabShippingHtml .= $viewBuilder->renderSetting('entry_pickup', '', 'error_pickup', true,
                $viewBuilder->renderSelect(Select::create()
                    ->setNameKey('pickup')
                    ->setSourceKey('pickups')));
        }
        if ($viewBuilder->hasFeature(Features::RecipientAddressType)) {
            $tabShippingHtml .= $viewBuilder->renderSetting('entry_recipient_address_type',
                'help_recipient_address_type', 'error_recipient_address_type', true,
                $viewBuilder->renderSelect(Select::create()
                    ->setNameKey('recipient_address_type')
                    ->setSourceKey('recipient_address_types')));
        }
        if ($viewBuilder->hasFeature(Features::Signature)) {
            $tabShippingHtml .= $viewBuilder->renderSetting('entry_signature', 'help_signature', '', false,
                $viewBuilder->renderSignature());
        }
        $tabShippingHtml .= $viewBuilder->renderSetting('entry_display_time', 'help_display_time', '', false,
            $viewBuilder->renderOptions(Select::create()
                    ->setNameKey('display_time')
                    ->setSourceKey('booleans')),
            array('display_time'));
        $tabShippingHtml .= $viewBuilder->renderSetting('entry_date_format', '', '', false,
            $viewBuilder->renderSelect(
                Select::create()
                    ->setNameKey('date_format')
                    ->setSourceKey('date_formats')),
            array('date_format'));
        $tabShippingHtml .= $viewBuilder->renderSetting('entry_display_weight', 'help_display_weight', '', false,
            $viewBuilder->renderOptions(Select::create()
                    ->setNameKey('display_weight')
                    ->setSourceKey('booleans')),
            array('display_weight'));
        $tabShippingHtml .= $viewBuilder->renderSetting('entry_tax', '', '', false,
            $viewBuilder->renderSelect(
                Select::create()
                    ->setNameKey('tax_class_id')
                    ->setSourceKey('tax_classes')
                    ->setValueField('tax_class_id')
                    ->setCaptionField('title')),
            array('tax_class_id'));
        if ($viewBuilder->hasFeature(Features::FreightClass)) {
            $tabShippingHtml .= $viewBuilder->renderSetting('entry_freight_class', 'help_freight_class', '', false,
                $viewBuilder->renderSelect(Select::create()
                    ->setNameKey('freight_class')
                    ->setSourceKey('freight_classes')));
        }
        if ($viewBuilder->hasFeature(Features::MinimumOrderWeight)) {
            $tabShippingHtml .= $viewBuilder->renderSetting('entry_minimal_order_weight', 'help_minimal_order_weight',
                '', false, $viewBuilder->renderInput(Input::create()
                    ->setNameKey('minimal_order_weight')
                    ->setCssClass('small-number')
                    ->setAddons(null, $viewBuilder->getLocale()->renderLargeWeightUnit())
                    ->setPrerender(Array($viewBuilder->getLocale(), 'renderLargeWeight'))));
        }
        $tabShippingHtml .= $viewBuilder->renderSetting('entry_geo_zones', 'help_geo_zones', '', false,
            $viewBuilder->renderGeoZones(),
            array('all_geo_zones', 'geo_zones'));
        $tabShippingHtml .= $viewBuilder->renderSetting('entry_customer_groups', 'help_customer_groups', '', false,
            $viewBuilder->renderCustomerGroups(),
            array('all_customer_groups', 'customer_groups'));
        $tabShippingHtml .= $viewBuilder->renderSetting('entry_prefix', 'help_prefix', '', false,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('prefix')));
        $tabShippingHtml .= $viewBuilder->renderSetting('entry_sort_options', 'help_sort_options', '', false,
            $viewBuilder->renderSelect(Select::create()
                ->setNameKey('sort_options')
                ->setSourceKey('sortings')),
            array('sort_options'));
        $tabShipping = Tab::create()
            ->setId('tab-ext-shipping')
            ->setTitleKey('tab_shipping')
            ->setContent($tabShippingHtml);

        /**
         * Tab Labels
         */
        if ($viewBuilder->hasFeature(Features::ShippingLabel)) {
            if ($data['mod_file_enabled']) {
                $tabLabelsHtml = $viewBuilder->renderSetting('entry_label', 'help_label', '', false,
                    $viewBuilder->renderOptions(Select::create()
                        ->setNameKey('label')
                        ->setSourceKey('labels')));
                if ($viewBuilder->hasFeature(Features::TopUpBalance)) {
                    $tabLabelsHtml .= $viewBuilder->renderBalance();
                }
                $tabLabelsHtml .= $viewBuilder->renderLabelFormatAndConverter();
                if ($viewBuilder->hasFeature(Features::Webhook)) {
                    $tabLabelsHtml .= $viewBuilder->renderSetting('entry_webhook', 'help_webhook', '', false,
                        $viewBuilder->renderWebhook());
                }
                $tabLabelsHtml .= $viewBuilder->renderSetting('entry_tracking', 'help_tracking', '', false,
                    $viewBuilder->renderSelect(Select::create()
                        ->setNameKey('tracking')
                        ->setSourceKey('trackings')));
                if ($viewBuilder->hasFeature(Features::Webhook)) {
                    $tabLabelsHtml .= $viewBuilder->renderSetting('entry_tracking_notify', 'help_tracking_notify', '',
                        false, $viewBuilder->renderOptions(Select::create()
                            ->setNameKey('tracking_notify')
                            ->setSourceKey('booleans')));
                }
                if ($viewBuilder->hasFeature(Features::InvoiceByRequest)) {
                    $tabLabelsHtml .= $viewBuilder->renderSetting('entry_invoice', 'help_invoice', '', false,
                        $viewBuilder->renderOptions(Select::create()
                            ->setNameKey('invoice')
                            ->setSourceKey('booleans')));
                } else {
                    $tabLabelsHtml .= $viewBuilder->renderHidden(Input::create()->setNameKey('invoice'));
                }
                if ($viewBuilder->hasFeature(Features::PaperlessByRequest)) {
                    $tabLabelsHtml .= $viewBuilder->renderSetting('entry_paperless', 'help_paperless', '', false,
                        $viewBuilder->renderOptions(Select::create()
                            ->setNameKey('paperless')
                            ->setSourceKey('booleans')));
                } else {
                    $tabLabelsHtml .= $viewBuilder->renderHidden(Input::create()->setNameKey('paperless'));
                }
                $tabLabelsHtml .= $viewBuilder->renderSetting('entry_fallback_product_country',
                    'help_fallback_product_country', '', false, $viewBuilder->renderSelect(Select::create()
                        ->setNameKey('fallback_product_country')
                        ->setSourceKey('countries')
                        ->setValueField('country_id')
                        ->setCaptionField('name')));
                $tabLabelsHtml .= $viewBuilder->renderSetting('entry_fallback_product_zone',
                    'help_fallback_product_zone', '', false, $viewBuilder->renderSelect(Select::create()
                        ->setNameKey('fallback_product_zone')));
                $tabLabelsHtml .= $viewBuilder->renderSetting('entry_fallback_product_hs_code',
                    'help_fallback_product_hs_code', '', false, $viewBuilder->renderInput(Input::create()
                        ->setNameKey('fallback_product_hs_code')));
                if (!$viewBuilder->hasFeature(Features::ShipperAddress)) {
                    $tabLabelsHtml .= $shipperAddressHtml[0]; // before origin postcode
                    $tabLabelsHtml .= $viewBuilder->renderSetting('entry_postcode', 'help_postcode_dub', '', true,
                        $viewBuilder->renderInput(Input::create()
                            ->setNameKey('postcode_dub')
                            ->setIsDisabled(true)));
                    $tabLabelsHtml .= $shipperAddressHtml[1]; // after origin postcode
                }
                $tabLabelsHtml .= $viewBuilder->renderSetting('entry_sender_name', 'help_label_foreign_data', '', true,
                    $viewBuilder->renderInput(Input::create()
                        ->setNameKey('sender_name')
                        ->setIsDisabled(true)));
                $tabLabelsHtml .= $viewBuilder->renderSetting('entry_sender_company', 'help_label_foreign_data', '',
                    true, $viewBuilder->renderInput(Input::create()
                        ->setNameKey('sender_company')
                        ->setIsDisabled(true)));
                $tabLabelsHtml .= $viewBuilder->renderSetting('entry_sender_telephone', 'help_label_foreign_data',
                    'error_sender_telephone', true, $viewBuilder->renderInput(Input::create()
                        ->setNameKey('sender_telephone')
                        ->setIsDisabled(true)));
            } else {
                $tabLabelsHtml = $viewBuilder->renderSetting('entry_mod', '', '', false,
                    $viewBuilder->renderStatic(
                        'Modification file should be enabled to use this
                        feature. Follow instructions on the General Tab.'
                    )
                );
            }
            $tabLabels = Tab::create()
                ->setId('tab-ext-labels')
                ->setTitleKey('tab_labels')
                ->setContent($tabLabelsHtml);
        } else {
            $tabLabels = null;
        }

        /**
         * Tab Services
         */
        $tabServicesHtml = $viewBuilder->renderSetting(
            'entry_services', 'help_services', '', false, $viewBuilder->renderServices()
        );
        if ($viewBuilder->hasFeature(Features::PreferSatchels)) {
            $tabServicesHtml .= $viewBuilder->renderSetting('entry_prefer_satchels', 'help_prefer_satchels', '', false,
                $viewBuilder->renderOptions(Select::create()
                ->setNameKey('prefer_satchels')
                ->setSourceKey('booleans')));
        }
        $tabServices = Tab::create()
            ->setId('tab-ext-services')
            ->setTitleKey('tab_services')
            ->setContent($tabServicesHtml);

        /**
         * Tab Adjustment
         */
        $tabAdjustmentsHtml = $viewBuilder->renderSetting('entry_box_weight_adj_fix', 'help_box_weight_adj_fix', '',
            false, $viewBuilder->renderInput(Input::create()
                ->setNameKey('box_weight_adj_fix')
                ->setCssClass('small-number')
                ->setAddons(null, $viewBuilder->getLocale()->renderLargeWeightUnit())
                ->setPrerender(Array($viewBuilder->getLocale(), 'renderLargeWeight'))),
            array('box_weight_adj_fix'));
        $tabAdjustmentsHtml .= $viewBuilder->renderSetting('entry_weight_adj_fix', 'help_weight_adj_fix', '', false,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('weight_adj_fix')
                ->setCssClass('small-number')
                ->setAddons(null, $viewBuilder->getLocale()->renderLargeWeightUnit())
                ->setPrerender(Array($viewBuilder->getLocale(), 'renderLargeWeight'))),
            array('weight_adj_fix'));
        $tabAdjustmentsHtml .= $viewBuilder->renderSetting('entry_weight_adj_per', 'help_weight_adj_per', '', false,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('weight_adj_per')
                ->setCssClass('small-number')
                ->setAddons(null, '%')),
            array('weight_adj_per'));
        $tabAdjustmentsHtml .= $viewBuilder->renderSetting(
            'entry_dimension_adj_fix', 'help_dimension_adj_fix', '', false,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('dimension_adj_fix')
                ->setCssClass('small-number')
                ->setAddons(null, $viewBuilder->getLocale()->renderLengthUnit())
                ->setPrerender(Array($viewBuilder->getLocale(), 'renderLength'))),
            array('dimension_adj_fix'));
        $tabAdjustmentsHtml .= $viewBuilder->renderSetting('entry_rate_adj_fix', 'help_rate_adj_fix', '', false,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('rate_adj_fix')
                ->setCssClass('small-number')
                ->setAddons(null, $data['currency_unit'])),
            array('rate_adj_fix'));
        $tabAdjustmentsHtml .= $viewBuilder->renderSetting('entry_rate_adj_per', 'help_rate_adj_per', '', false,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('rate_adj_per')
                ->setCssClass('small-number')
                ->setAddons(null, '%')),
            array('rate_adj_per'));
        $tabAdjustmentsHtml .= $viewBuilder->renderSetting('entry_minimum_rate', 'help_minimum_rate', '', false,
            $viewBuilder->renderInput(Input::create()
                ->setNameKey('minimum_rate')
                ->setCssClass('small-number')
                ->setAddons(null, $data['currency_unit'])),
            array('minimum_rate'));
        $tabAdjustmentsHtml .= $viewBuilder->renderSetting('entry_adjustment_rules', 'help_adjustment_rules', '',
            false, $viewBuilder->renderAdjustmentRules());
        $tabAdjustments = Tab::create()
            ->setId('tab-ext-adjustments')
            ->setTitleKey('tab_adjustments')
            ->setContent($tabAdjustmentsHtml);

        /**
         * Tab FAQ
         */
        $tabFaq = Tab::create()
            ->setId('tab-faq')
            ->setTitleKey('tab_faq');

        /**
         * Assembly
         */
        $tabs = $viewBuilder->renderTabs(array(
            $tabGeneral, $tabPackage, $tabShipping, $tabLabels, $tabServices, $tabAdjustments, $tabFaq
        ));
        $form = $viewBuilder->renderForm($tabs);
        $container = $viewBuilder->renderContainer($form);
        return $viewBuilder->finallyRenderModuleSettings($container);
    }

    public static function replyZones($data) {
        $viewBuilder = ViewLoader::getViewBuilder($data);
        return $viewBuilder->renderSelect(Select::create()
            ->setNameKey('zone_id')
            ->setSourceKey('zones')
            ->setValueField('zone_id')
            ->setCaptionField('name'));
    }

    public static function replyFallbackProductZones($data) {
        $viewBuilder = ViewLoader::getViewBuilder($data);
        return $viewBuilder->renderSelect(Select::create()
            ->setNameKey('fallback_product_zone')
            ->setSourceKey('zones')
            ->setValueField('zone_id')
            ->setCaptionField('name'));
    }

    public static function replyBillingZones($data) {
        $viewBuilder = ViewLoader::getViewBuilder($data);
        return $viewBuilder->renderSelect(Select::create()
            ->setNameKey('billing_zone_id')
            ->setSourceKey('zones')
            ->setValueField('zone_id')
            ->setCaptionField('name'));
    }

    public static function replyServices($data) {
        $viewBuilder = ViewLoader::getViewBuilder($data);
        return $viewBuilder->renderServices();
    }

    public static function replyServicesByUser($data) {
        $viewBuilder = ViewLoader::getViewBuilder($data);
        return $viewBuilder->renderServicesByUser();
    }

    public static function replyPackagingList($data) {
        $viewBuilder = ViewLoader::getViewBuilder($data);
        $viewBuilder->setIsStandaloneTemplate(true);
        $packagingList = $viewBuilder->renderPackagingList($data);
        return $viewBuilder->finallyRenderStandalonePage($packagingList);
    }

    public static function replyDocumentWrapper($data) {
        $viewBuilder = ViewLoader::getViewBuilder($data);
        $viewBuilder->setIsStandaloneTemplate(true);
        $wrapper = $viewBuilder->renderDocumentWrapper($data);
        return $viewBuilder->finallyRenderStandalonePage($wrapper);
    }

    public static function replyPackagingMap($data) {
        $viewBuilder = ViewLoader::getViewBuilder($data);
        $viewBuilder->setIsStandaloneTemplate(true);
        return $viewBuilder->finallyRenderPackagingMap($data);
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Controls\Select;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureChecker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\PackagingList;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\Shipment;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\VersionChecker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\ViewLoader;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\PackagingData;

abstract class ShippingVqmod {
    /** @var ShippingVqmod[] */
    protected static $instances = array();
    /** @var ShippingModule */
    protected $module;

    /**
     * @return ShippingVqmod
     */
    public static function get() {
        $className = get_called_class();
        if (empty(static::$instances[$className])) {
            static::$instances[$className] = new $className();
        }
        return static::$instances[$className];
    }

    protected function __construct($module) {
        $this->module = $module;
    }

    /**
     * Loads an admin or front Smart & Flexible Model
     * @param object $controllerOrModel
     * @param string|null $extName from ShippingModule::getExtensionName
     * @return ShippingAdminModel|ShippingModel
     */
    protected function getSmartFlexibleModel($controllerOrModel, $extName = null) {
        $smartFlexibleModel = 'model_' . (VersionChecker::get()->isVersion3() ? 'extension_' : '') .
            'shipping_' . ($extName ? $extName : $this->module->getExtensionName());
        if (!CoreFeatureChecker::hasProperty($controllerOrModel, $smartFlexibleModel)) {
            $controllerOrModel->load->model(
                (VersionChecker::get()->isVersion3() ? 'extension/' : '') .
                'shipping/' . ($extName ? $extName : $this->module->getExtensionName())
            );
        }
        return $controllerOrModel->$smartFlexibleModel;
    }

    /** @var bool */
    protected $isEnabled = false;

    public function isEnabled() {
        return $this->isEnabled;
    }

    public function setEnabled() {
        $this->isEnabled = true;
    }

    public function addPackagingListButtonLink($orderInfo, &$data, $controller) {
        $extName = $this->module->getExtensionName();
        $route = (VersionChecker::get()->isVersion23() || VersionChecker::get()->isVersion3() ? 'extension/' : '') .
            'shipping/' . $extName;
        if (preg_match('/^' . $extName. '\./', $orderInfo['shipping_code'])) {
            $data[$this->module->getPrefixedName('packaging_list')] = $controller->url->link(
                $route . '/packaginglist',
                (VersionChecker::get()->isVersion3() ? 'user_token' : 'token') . '=' .
                $controller->session->data[VersionChecker::get()->isVersion3() ? 'user_token' : 'token'] .
                '&order_id=' . (int)$controller->request->get['order_id'],
                VersionChecker::get()->isVersion1() ? 'SSL' : true
            );
            $data[$this->module->getPrefixedName('tracking')] = $controller->url->link(
                $route . '/tracking',
                (VersionChecker::get()->isVersion3() ? 'user_token' : 'token') . '=' .
                $controller->session->data[VersionChecker::get()->isVersion3() ? 'user_token' : 'token'] .
                '&order_id=' . (int)$controller->request->get['order_id'],
                VersionChecker::get()->isVersion1() ? 'SSL' : true
            );
        }
    }


    public function addPackagingListButton($packagingListLink, $trackingLink) {
        $trackingLink = html_entity_decode($trackingLink);
        $script = <<<JS
            $(function() {
                $('#input-order-status, select[name="order_status_id"]').on('change', function() {
                    if ($(this).find('option:selected').text() == 'Shipped') {
                        var handlerSuccess = function(text) {
                            $('#input-comment, textarea[name="comment"]').val(text);
                        };
                        $.ajax({
                            url: "{$trackingLink}",
                            success: handlerSuccess,
                            dataType: 'text'
                        });
                    }
                });
            });
JS;
        if (VersionChecker::get()->isVersion2() || VersionChecker::get()->isVersion3()) {
            $result = '<a href="' . $packagingListLink . '" target="_blank" data-toggle="tooltip" ' .
                'title="Packing list and shipping labels" class="btn btn-success"><i class="fa fa-tag"></i></a>' .
                '<script>' . $script . '</script>';
            return $result;
        } elseif (VersionChecker::get()->isVersion1()) {
            return '<a href="' . $packagingListLink . '" target="_blank" class="button">' .
                'Packing list and shipping labels</i></a><script>' . $script . '</script>';
        }
    }

    /**
     * @param object $controller
     * @param array $orderData
     */
    public function createPackagingList($controller, $orderData) {
        $extName = $this->module->getExtensionName();
        if (
            isset($controller->session->data['shipping_method']) &&
            is_array($controller->session->data['shipping_method']) &&
            isset($controller->session->data['shipping_method']['code']) &&
            (strpos($controller->session->data['shipping_method']['code'], '.') !== false)
        ) {
            list($service, $id) = explode('.', $controller->session->data['shipping_method']['code']);
            if ($service === $extName) {
                $addressDetails = array();
                foreach ($orderData as $key => $value) {
                    if (strpos($key, 'shipping_') !== false) {
                        $addressKey = str_replace('shipping_', '', $key);
                        $addressDetails[$addressKey] = $value;
                    }
                }
                if (isset($addressDetails['zone_id'])) {
                    $controller->load->model('localisation/zone');
                    $zone_info = $controller->model_localisation_zone->getZone($addressDetails['zone_id']);
                    if ($zone_info) {
                        $addressDetails['zone_code'] = $zone_info['code'];
                    }
                }
                if (isset($addressDetails['country_id'])) {
                    $controller->load->model('localisation/country');
                    $country_info = $controller->model_localisation_country->getCountry($addressDetails['country_id']);
                    if ($country_info) {
                        $addressDetails['iso_code_2'] = $country_info['iso_code_2'];
                        $addressDetails['iso_code_3'] = $country_info['iso_code_3'];
                    }
                }
                if (empty($controller->session->data['shipping_address'])) {
                    $controller->session->data['shipping_address'] = array();
                }
                $controller->session->data['shipping_address'] += $addressDetails;
                $controller->session->data['shipping_address']['email'] = $orderData['email'];
                $controller->session->data['shipping_address']['telephone'] = $orderData['telephone'];
                $offer = $controller->session->data['shipping_methods'][$extName]['quote'][$id];
                $this->getSmartFlexibleModel($controller, $extName)->createPackagingList(
                    $controller->session->data['order_id'],
                    PackagingData::decode($offer['packaging_data']),
                    $controller->session->data['shipping_address'],
                    $offer['id_clean'],
                    $offer['title_clean'],
                    $offer['customer_choice']
                );
            }
        }
    }

    public function defineAdminRequest() {
        if (!defined(ShippingModel::AdminRequestFlagConst)) {
            define(ShippingModel::AdminRequestFlagConst, true);
        }
    }

    /**
     * @param mixed $model
     * @param int $orderId
     * @param array $orderInfo
     * @param int $orderStatusId
     * @return array[]|null arrays of tracking_number, tracking_url
     */
    public function getTrackingInfo($model, $orderId, $orderInfo, $orderStatusId) {
        $extName = $this->module->getExtensionName();
        if (preg_match('/^' . $extName . '\./', $orderInfo['shipping_code'])) {
            /** @var PackagingList $packagingList */
            $packagingList = $this->getSmartFlexibleModel($model, $extName)->requestLabels($orderId);
            if ($packagingList) {
                $comment = 'Shipping labels have been requested:' . "\n" . $packagingList->getStatusText();
                if (CoreFeatureChecker::hasMethod($model, 'update')) { // v1
                    $model->update($orderId, $orderStatusId, $comment, false);
                } elseif (CoreFeatureChecker::hasMethod($model, 'addOrderHistory')) { // v2
                    $model->addOrderHistory($orderId, $orderStatusId, $comment, false);
                }
            }
            if ($model->config->get($this->module->getPrefixedName('tracking')) ===
                Configuration::TrackingSendImmediately
            ) {
                if ($packagingList) {
                    return array_filter(array_map(function ($shipment) {
                        /** @var Shipment $shipment */
                        return array(
                            'tracking_number' => $shipment->getTrackingNumber(),
                            'tracking_url' => $shipment->getTrackingUrl()
                        );
                    }, $packagingList->getShipments()));
                }
            }
        }
        return null;
    }

    public function addTrackingInfoForHtmlMail($trackingInfo, &$data) {
        if ($trackingInfo && is_array($trackingInfo) && count($trackingInfo)) {
            $data[$this->module->getPrefixedName('tracking_info')] = $trackingInfo;
        }
    }


    public function addTrackingInfoForTextMail($trackingInfo, &$text) {
        if ($trackingInfo && is_array($trackingInfo) && count($trackingInfo)) {
            $text .= 'Tracking numbers: ' . "\n\n" . implode("\n", array_map(function($row) {
                return $row['tracking_number'] .
                    ($row['tracking_url'] ? "\n" . 'Track online: ' . $row['tracking_url'] : '');
            }, $trackingInfo)) . "\n\n";
        }
    }

    public function addTrackingInfoInHtmlTemplate($trackingInfo) {
        if ($trackingInfo && is_array($trackingInfo) && count($trackingInfo)) {
            $result = '<table style="border-collapse: collapse; width: 100%; border-top: 1px solid #DDDDDD; ' .
                    'border-left: 1px solid #DDDDDD; margin-bottom: 20px;">' .
                    '<thead>' .
                        '<tr>' .
                            '<td style="font-size: 12px; border-right: 1px solid #DDDDDD; ' .
                                'border-bottom: 1px solid #DDDDDD; background-color: #EFEFEF; font-weight: bold; ' .
                                'text-align: left; padding: 7px; color: #222222;">' .
                                'Tracking numbers' .
                            '</td>' .
                        '</tr>' .
                    '</thead>' .
                    '<tbody>';
            foreach ($trackingInfo as $row) {
                $number = $row['tracking_url'] ? '<a href="' . $row['tracking_url'] . '">' .
                    $row['tracking_number'] . '</a>' : $row['tracking_number'];
                $result .=
                    '<tr>' .
                        '<td style="font-size: 12px; border-right: 1px solid #DDDDDD; ' .
                            'border-bottom: 1px solid #DDDDDD; text-align: left; padding: 7px;">' .
                            $number .
                        '</td>' .
                    '</tr>';
            }
            $result .=
                    '</tbody>' .
                '</table>';
            return $result;
        }
    }

    /**
     * @param object $controller
     * @return int|null
     */
    public function getProductNameMaxLength($controller) {
        return $this->getSmartFlexibleModel($controller)->getProductNameMaxLength();
    }

    /**
     * @param object $controller
     * @since 03.05.2017 does not require productId as an argument
     * @return string|null
     */
    public function getProductName($controller) {
        if (isset($controller->request->post[$this->module->getPrefixedName('product_name')])) {
            return $controller->request->post[$this->module->getPrefixedName('product_name')];
        } elseif (isset($controller->request->get['product_id'])) {
            return $this->getSmartFlexibleModel($controller)->getProductName($controller->request->get['product_id']);
        }
        return null;
    }

    /**
     * @param object $controller
     * @return string|null
     */
    public function getProductHsCode($controller) {
        if (isset($controller->request->post[$this->module->getPrefixedName('product_hs_code')])) {
            return $controller->request->post[$this->module->getPrefixedName('product_hs_code')];
        } elseif (isset($controller->request->get['product_id'])) {
            return $this->getSmartFlexibleModel($controller)->getProductHsCode($controller->request->get['product_id']);
        }
        return null;
    }

    protected function getProductOptionViewBuilder($controller, $additionalOptions, $optionName, $getOptionValue) {
        $prefixedOption = $this->module->getPrefixedName($optionName);
        $get = $controller->request->get;
        $post = $controller->request->post;
        return ViewLoader::getViewBuilder($additionalOptions + array(
            'get_prefixed_name' => Array($this->module, 'getPrefixedName'),
            'get_extension_name' => Array($this->module, 'getExtensionName'),
            'has_feature' => Array($this->module, 'hasFeature'),
            'get_current_route' => function() use ($controller) {
                return $controller->request->get['route'];
            },
            $prefixedOption => (isset($post[$prefixedOption]) ? $post[$prefixedOption] : (
                isset($get['product_id']) ? $getOptionValue($get['product_id']) : null
            ))
        ));
    }

    /**
     * @param object $controller
     * @return string html select
     */
    public function getProductCountries($controller) {
        $controller->load->model('localisation/country');
        $model = $this->getSmartFlexibleModel($controller);
        $viewBuilder = $this->getProductOptionViewBuilder(
            $controller,
            array(
                'countries' => array_merge(array(
                    array(
                        'country_id' => null,
                        'name' => '—'
                    )
                ), $controller->model_localisation_country->getCountries())
            ),
            'product_country',
            function($productId) use ($model) {
                return $model->getProductCountry($productId);
            }
        );
        return $viewBuilder->renderSelect(Select::create()
            ->setNameKey('product_country')
            ->setCaptionField('name')
            ->setValueField('country_id')
            ->setSourceKey('countries'));
    }

    /**
     * @param object $controller
     * @return string html select
     */
    public function getProductZones($controller) {
        $controller->load->model('localisation/zone');
        $model = $this->getSmartFlexibleModel($controller);
        $viewBuilder = $this->getProductOptionViewBuilder(
            $controller,
            array(
                'zones' => array_merge(array(
                    array(
                        'zone_id' => null,
                        'name' => '—'
                    )
                ), $controller->model_localisation_zone->getZonesByCountryId(
                    isset($controller->request->post[$this->module->getPrefixedName('product_country')]) ?
                        $controller->request->post[$this->module->getPrefixedName('product_country')] : (
                    isset($controller->request->get['product_id']) ?
                        $this->getSmartFlexibleModel($controller)->getProductCountry(
                            $controller->request->get['product_id']
                        ) : null
                    )
                ))
            ),
            'product_zone',
            function($productId) use ($model) {
                return $model->getProductZone($productId);
            }
        );
        return $viewBuilder->renderSelect(Select::create()
            ->setNameKey('product_zone')
            ->setCaptionField('name')
            ->setValueField('zone_id')
            ->setSourceKey('zones'));
    }

    /**
     * @param object $controller
     * @param int $productId
     * @param string $name
     * @return string|null
     */
    public function setProductName($controller, $productId, $name) {
        return $this->getSmartFlexibleModel($controller)->setProductName($productId, $name);
    }

    /**
     * @param object $controller
     * @param int $productId
     * @param int $countryId
     * @return int|null
     */
    public function setProductCountry($controller, $productId, $countryId) {
        return $this->getSmartFlexibleModel($controller)->setProductCountry($productId, $countryId);
    }

    /**
     * @param object $controller
     * @param int $productId
     * @param int $zoneId
     * @return int|null
     */
    public function setProductZone($controller, $productId, $zoneId) {
        return $this->getSmartFlexibleModel($controller)->setProductZone($productId, $zoneId);
    }

    /**
     * @param object $controller
     * @param int $productId
     * @param string $hsCode
     * @return string|null
     */
    public function setProductHsCode($controller, $productId, $hsCode) {
        return $this->getSmartFlexibleModel($controller)->setProductHsCode($productId, $hsCode);
    }

    /**
     * @param string $html
     * @return string
     */
    protected function escapeHtmlForJs($html) {
        return addcslashes($html, '\'');
    }

    public function getProductLabelOptions($controller) {
        $data = array();
        $data['product_name_max_length'] = $this->getProductNameMaxLength($controller);
        $data['product_name'] = $this->getProductName($controller);
        $data['product_countries'] = $this->escapeHtmlForJs($this->getProductCountries($controller));
        $data['product_zones'] = $this->escapeHtmlForJs($this->getProductZones($controller));
        $data['product_hs_code'] = $this->getProductHsCode($controller);
        return array_combine(
            array_map(array($this->module, 'getPrefixedName'), array_keys($data)),
            $data
        );
    }

    public function setProductLabelOptions($controller, $productId) {
        $module = $this->module;
        $getPostOption = function($optionName) use ($controller, $module) {
            $key = $module->getPrefixedName($optionName);
            return isset($controller->request->post[$key]) ? $controller->request->post[$key] : null;
        };
        $this->setProductName($controller, $productId, $getPostOption('product_name'));
        $this->setProductCountry($controller, $productId, $getPostOption('product_country'));
        $this->setProductZone($controller, $productId, $getPostOption('product_zone'));
        $this->setProductHsCode($controller, $productId, $getPostOption('product_hs_code'));
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ApiException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\FileManager;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\PackagingList;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\Shipment;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Arrays;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Address;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Json;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\ValuableBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\CurrencyConverter;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Fallback;

class PackagingListManager extends FileManager {

    const ListsDir = 'packaging-lists/';

    /**
     * @param PackagingList $packagingList
     * @return int bytes written
     */
    public static function save($packagingList) {
        $path = self::getStorageDir() . self::ListsDir;
        self::createFolder($path);
        $json = Json::encodePretty($packagingList->toArray());
        return self::createFile($path . $packagingList->getOrderId() . '.json', $json);
    }

    /**
     * @param $orderId
     * @return null|string
     */
    public static function readRaw($orderId) {
        $file = self::getStorageDir() . self::ListsDir . $orderId . '.json';
        if (!file_exists($file)) {
            return null;
        }
        return file_get_contents($file);
    }

    /**
     * @since 15.01.2018 accepts fallback
     * @param int $orderId
     * @param Fallback $fallback
     * @return PackagingList|null
     */
    public static function load($orderId, $fallback) {
        $data = self::readRaw($orderId);
        if ($data === null) {
            return null;
        }
        try {
            $data = Json::decodeAsArray($data);
            if (Arrays::isAssoc($data)) {
                return PackagingList::createFromArray($data, $fallback);
            } else {
                // backward compatibility - only shipments stored
                return new PackagingList(array(
                    'order_id' => $orderId,
                    'service_name' => null,
                    'version' => null,
                    'method_code' => null,
                    'address' => array(),
                    'method_name' => null,
                    'customer_choice' => array(),
                    'shipments' => array_map(function ($shipment) use ($fallback) {
                        return Shipment::createFromArray($shipment, $fallback);
                    }, $data)
                ));
            }
        } catch (\Exception $e) {
            return null;
        }
    }

    /**
     * @param int $orderId
     * @param Configuration $configuration
     * @param BaseLabelsProvider $labelsProvider
     * @throws ConfigurationException
     * @return int of save method
     * @notice Configuration does not require store to be selected because using common keys only
     */
    public static function rebuildProducts($orderId, $configuration, $labelsProvider) {
        $productNames = $configuration->get('product_names');
        $productCountries = $configuration->get('product_countries');
        $productZones = $configuration->get('product_zones');
        $productHsCodes = $configuration->get('product_hs_codes');
        $fallback = Fallback::create()
            ->setLabelFormatFromProvider($labelsProvider)
            ->setOriginCountryId($configuration->get('fallback_product_country'))
            ->setOriginZoneId($configuration->get('fallback_product_zone'))
            ->setHsCode($configuration->get('fallback_product_hs_code'));
        $packagingList = self::load($orderId, $fallback);
        if (!$packagingList) {
            throw new ConfigurationException('Packaging list not found for order N' . $orderId);
        }
        $packagingListData = $packagingList->toArray();
        foreach ($packagingListData['shipments'] as $s => $shipmentData) {
            foreach ($shipmentData['box']['products'] as $p => $productData) {
                $packagingListData['shipments'][$s]['box']['products'][$p]['short_description'] =
                    isset($productNames[$productData['id']]) ?
                        $productNames[$productData['id']] : $productData['short_description'];
                $packagingListData['shipments'][$s]['box']['products'][$p]['origin_country_id'] =
                    isset($productCountries[$productData['id']]) ?
                        $productCountries[$productData['id']] : $productData['origin_country_id'];
                $packagingListData['shipments'][$s]['box']['products'][$p]['origin_zone_id'] =
                    isset($productZones[$productData['id']]) ?
                        $productZones[$productData['id']] : $productData['origin_zone_id'];
                $packagingListData['shipments'][$s]['box']['products'][$p]['hs_code'] =
                    isset($productHsCodes[$productData['id']]) ?
                        $productHsCodes[$productData['id']] : $productData['hs_code'];
            }
            $packagingListData['shipments'][$s]['success_message'] =
                'Products information updated. You can repeat your request again.';
        }
        return self::save(PackagingList::createFromArray($packagingListData, $fallback));
    }

    /**
     * @param int $orderId
     * @param int|null $shipmentId Use null to request all labels
     * @param ShippingModule $module
     * @param callable $debugger
     * @param null|BaseValidationProvider $validationProvider
     * @param BaseLabelsProvider $labelsProvider
     * @param null|BasePaperlessProvider $paperlessProvider
     * @param Configuration $configuration
     * @param CurrencyConverter $converter
     * @param object[] $models Array of models with indexes: country, zone
     * @throws ConfigurationException
     * @throws ApiException
     * @since 31.10.2017 accepts debugger to forward it to providers
     * @since 15.01.2018 produces internal fallback
     * @since 16.09.2018 sets last mile options as customer choices
     * @return null|PackagingList
     */
    public static function requestLabels(
        $orderId, $shipmentId, $module, $debugger, $validationProvider, $labelsProvider,
        $paperlessProvider, $configuration, $converter, $models
    ) {
        if (!($module->hasFeature(Features::ShippingLabel) && $labelsProvider)) {
            throw new ConfigurationException('Feature is not enabled');
        }
        $fallback = Fallback::create()
            ->setLabelFormatFromProvider($labelsProvider)
            ->setOriginCountryId($configuration->get('fallback_product_country'))
            ->setOriginZoneId($configuration->get('fallback_product_zone'))
            ->setHsCode($configuration->get('fallback_product_hs_code'));
        $packagingList = self::load($orderId, $fallback);
        if (!$packagingList) {
            throw new ConfigurationException('Can not read packaging list');
        }
        $address = Address::fixAddress($packagingList->getAddress());
        $address = $module->fixAddress($address, $models['country'], $models['zone']);

        // recipient address type and address validation
        $validationData = null;
        if ($validationProvider) {
            $validationProvider->setDebugger($debugger);
        }
        if ($module->hasFeature(Features::RecipientAddressType)) {
            $address['is_residential'] = Address::isAddressResidential($address, $configuration, $validationProvider);
        } elseif ($validationProvider) {
            try {
                $validationData = $validationProvider->validateAddress($address);
            } catch (\Exception $e) {
                throw new ApiException($e->getMessage());
            }
        }
        // set up provider
        $boxes = array_map(function($shipment) {
            /** @var Shipment $shipment */
            return $shipment->getBox();
        }, $packagingList->getShipments());
        $labelsProvider->setDebugger($debugger);
        $canInsuranceBeIncluded = ValuableBox::canInsuranceBeIncluded(
            null, $boxes, $configuration, $converter, $module->getValueCurrencyCode(
                $configuration->getOriginCountryCode($models['country'])
            )
        );
        $labelsProvider->setOption('value_currency_code', $module->getValueCurrencyCode(
            $configuration->getOriginCountryCode($models['country'])
        ));
        $labelsProvider->setOption('get_country_code', function ($countryId) use ($models) {
            if (!$countryId) {
                return null;
            }
            $countryData = $models['country']->getCountry($countryId);
            return $countryData['iso_code_2'];
        });
        $labelsProvider->setOption('get_zone_code', function ($zoneId) use ($models) {
            if (!$zoneId) {
                return null;
            }
            $zoneData = $models['zone']->getZone($zoneId);
            return $zoneData['code'];
        });
        // last mile options and customer choice
        switch ($configuration->get('insurance')) {
            case Configuration::InsuranceEnabled:
                $labelsProvider->setOption('insurance', $canInsuranceBeIncluded);
                break;
            case Configuration::CustomerChooses:
                $labelsProvider->setOption('insurance',
                    $packagingList->getSpecificCustomerOption('insurance') ?: false);
                break;
            case Configuration::InsuranceDisabled:
            default:
                $labelsProvider->setOption('insurance', false);
        }
        switch ($configuration->get('signature')) {
            case Configuration::SignatureRequired:
                $labelsProvider->setOption('signature', true);
                break;
            case Configuration::CustomerChooses:
                $labelsProvider->setOption('signature',
                    $packagingList->getSpecificCustomerOption('signature') ?: false);
                break;
            case Configuration::SignatureNotRequired:
            default:
                $labelsProvider->setOption('signature', false);
        }

        $shipments = array();
        foreach ($packagingList->getShipments() as $k => $shipment) {
            if (!$shipment->hasLabel()) {
                if ($shipmentId !== null) {
                    if ($shipmentId === $k) {
                        $shipments[$k] = $shipment;
                    }
                } else {
                    $shipments[$k] = $shipment;
                }
            }
        }

        $newShipments = $labelsProvider->queryLabelsAndTracking(
            $orderId, $shipments, $address, $packagingList->getMethodCode(), $validationData
        );

        // paperless
        if ($paperlessProvider && $configuration->get('paperless')) {
            $paperlessProvider->setDebugger($debugger);
            $newShipments = $paperlessProvider->queryDocumentsUpload($orderId, $newShipments);
        }

        $shipments = $newShipments + $packagingList->getShipments();
        ksort($shipments);

        $packagingList = new PackagingList(array(
            'order_id' => $orderId,
            'service_name' => $packagingList->getServiceName(),
            'version' => $packagingList->getVersion(),
            'method_code' => $packagingList->getMethodCode(),
            'address' => $address,
            'method_name' => $packagingList->getMethodName(),
            'customer_choice' => $packagingList->getCustomerChoice(),
            'shipments' => $shipments
        ));
        PackagingListManager::save($packagingList);
        return $packagingList;
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

class BaseProvider {
    /** @var array */
    protected $options = array();
    /** @var callable */
    protected $debugger = null;

    /**
     * @param string $key
     * @param mixed $value
     */
    public function setOption($key, $value) {
        $this->options[$key] = $value;
    }

    /**
     * @param string $key
     * @return mixed
     */
    public function getOption($key) {
        return isset($this->options[$key]) ? $this->options[$key] : null;
    }

    /**
     * Unescapes string options to use them in JSON requests
     * @param string $key
     * @return mixed
     * @todo: incoming request data should be unescaped in v7.x adapter and escaped in views and xml
     */
    public function getOptionForJson($key) {
        $originalValue = $this->getOption($key);
        return is_string($originalValue) ? // opposite to request::clean()
            htmlspecialchars_decode($originalValue, ENT_COMPAT) : $originalValue;
    }

    /**
     * @param callable $debugger
     */
    public function setDebugger($debugger) {
        if (is_callable($debugger)) {
            $this->debugger = $debugger;
        }
    }

    public function debug() {
        if (!empty($this->debugger)) {
            call_user_func_array($this->debugger, func_get_args());
        }
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginPackage;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerResult;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerResultBox;

abstract class BaseRatesProvider extends BaseProvider {
    const Packer3dSimplifyLimit = 250;
    const BoxMakerSteps = 10;

    /**
     * Returns a value of 'methods' option element
     * @param string $fullKey
     * @return bool
     */
    public function isMethodEnabled($fullKey) {
        $methods = $this->getOption('methods');
        return isset($methods[$fullKey]) ? (bool)$methods[$fullKey] : false;
    }

    /**
     * @return int
     */
    abstract public function getMaxProcessingDays();

    /**
     * @param array $address
     * @return float
     * @since 26.08.2017 can return 0 (USPS) when delivery to this country is not available
     */
    abstract public function getPackageMaxWeight($address);

    /**
     * This method can be replaced in final provider
     * @param array $address
     * @return null|float in currency from Module::getValueCurrencyCode()
     */
    public function getPackageMaxInsuranceValue($address) {
        return null;
    }

    /**
     * Used for pallets
     * This method can be replaced in final provider
     * @return float|null
     */
    public function getPackageExpandableMaxHeight() {
        return null;
    }

    /**
     * This method can be replaced in final provider
     * @return null|string
     */
    public function getStandardPackageFixedDefaultCode() {
        return null;
    }

    /**
     * This method can be replaced in final provider
     * @return null|string
     */
    public function getStandardPackageExpandableDefaultCode() {
        return null;
    }

    /**
     * @return OriginPackage[]
     */
    abstract public function getStandardPackages();

    /**
     * Returns a structure of method codes
     * This method MUST be replaced in final provider
     * @return array
     */
    public static function getMethodCodes() {
        return array();
    }

    /**
     * Returns an array of hidden standard packages IDs
     * This method can be replaced in final provider
     * @return int[]
     */
    public function getHiddenStandardPackagesIds() {
        return array();
    }

    /**
     * Returns an array of standard boxes to attach to Packer
     * @param OriginPackage[] $boxes
     * @param array $address
     * @return PackerBox[]
     */
    public function createStandardPackages($boxes, $address) {
        $result = array();
        $maxWeight = $this->getPackageMaxWeight($address);
        $maxHeight = $this->getPackageExpandableMaxHeight();
        foreach ($boxes as $box) {
            $result = array_merge($result, $box->generatePackerBoxes($maxWeight, $maxHeight));
        }
        return $result;
    }

    /**
     * Returns variants of packaging
     * By default: 1) all enabled standard and custom packages
     * This method can be replaced in final provider
     * @param array $address
     * @param PackerBox[] $customPackagesFixed
     * @param PackerBox[] $customPackagesExpandable
     * @return PackerBox[][] variants of boxes sets
     */
    public function getPackagingVariants($address, $customPackagesFixed, $customPackagesExpandable) {
        $variants = array();
        /**
         * Filter standard packages
         * @param PackerBox[] $standardPackages
         * @param array $enabledPackages config array: [id => bool]
         * @return PackerBox[]
         */
        $filterBoxesFunc = function($standardPackages, $enabledPackages) {
            // array_values drops keys
            return array_values(array_filter($standardPackages,
                function($box) use ($enabledPackages) {
                    /** @var PackerBox $box */
                    if (isset($enabledPackages[$box->getOriginPackage()->getId()])) {
                        return (bool)$enabledPackages[$box->getOriginPackage()->getId()];
                    }
                    return false;
                }
            ));
        };
        $variants[] = array_merge(
            $filterBoxesFunc(
                $this->createStandardPackages($this->getStandardPackages(), $address),
                $this->getOption('standard_packages')
            ),
            $customPackagesFixed,
            $customPackagesExpandable
        );
        return $variants;
    }

    /**
     * Returns a list of shipping method groups keys prefixed with argument
     * @param bool|string $prefix Use 'text' for translations
     * @return string[]
     */
    public function getAllShippingMethodGroups($prefix) {
        $result = array();
        foreach ($this->getMethodCodes() as $service => $groups) {
            $result[] = ($prefix ? $prefix . '_' : '') . $service;
            foreach ($groups as $group => $codes) {
                $result[] = ($prefix ? $prefix . '_' : '') . $group;
            }
        }
        return $result;
    }

    /**
     * Returns a list of shipping method keys prefixed with argument
     * @param bool|string $prefix
     * @return string[]
     */
    public function getAllShippingMethods($prefix = false) {
        $result = array();
        foreach ($this->getMethodCodes() as $service => $groups) {
            foreach ($groups as $codes) {
                foreach ($codes as $code) {
                    $result[] = ($prefix ? $prefix . '_' : '') . $service . '_' . $code;
                }
            }
        }
        return $result;
    }

    /**
     * Module specific methods compatibility
     * @param int[] $methods
     * @return int[]
     */
    public function ensureMethodsCompatibility($methods) {
        return $methods;
    }

    /**
     * @param array $address
     * @param PackerResult[] $packerResults
     * @param int $shippingTime
     * @return Rate[]
     */
    abstract public function queryRates($address, $packerResults, $shippingTime);

    /**
     * Combines rates from flat array using Id
     * Controls CRC of the boxes
     * @param Rate[] $rates
     * @param PackerResultBox[] $boxes
     * @return Rate[]
     */
    public function combineRates($rates, $boxes) {
        /** @var Rate[] $result */
        $result = array();
        $crc = array();
        foreach ($rates as $rate) {
            /** @var Rate $rate */
            if (isset($result[$rate->getId()])) {
                $result[$rate->getId()]->setCost($result[$rate->getId()]->getCost() + $rate->getCost());
                $crc[$rate->getId()]++;
            } else {
                $result[$rate->getId()] = $rate;
                $crc[$rate->getId()] = 1;
            }
        }
        $validCrc = array_filter($crc, function ($count) use ($boxes) {
            return $count === count($boxes);
        });
        return array_intersect_key($result, $validCrc);
    }

    /**
     * Combine rates from variants into a flat array.
     * Chooses less price for the same method Id
     * @param Rate[][] $rateVariants
     * @return Rate[]
     */
    public function combineRatesFromVariants($rateVariants) {
        $result = array();
        foreach ($rateVariants as $rates) {
            foreach ($rates as $rate) {
                if (isset($result[$rate->getId()])) {
                    /** @var Rate $testRate */
                    $testRate = $result[$rate->getId()];
                    if ($testRate->getCost() <= $rate->getCost()) {
                        continue;
                    }
                }
                $result[$rate->getId()] = $rate;
            }
        }
        return $result;
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\AccompanyingDocument;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\Shipment;

abstract class BaseLabelsProvider extends BaseProvider {
    /**
     * Returns mime type of original label
     * this method can be replaced
     * @return string
     */
    public function getLabelFormat() {
        return AccompanyingDocument::FormatPDF;
    }

    /**
     * @param array $address
     * @since 06.12.2018 requires address since different label formats depend on directions
     * @return array [top,left,height,rotate,resolution]
     * @todo: need some class
     */
    abstract public function getLabelPosition($address);

    /**
     * Returns length of product name to write on shipping label
     * this method MUST be replaced
     * @return int
     */
    public function getProductNameMaxLength() {
        return 255;
    }

    /**
     * @param string $name
     * @since 09.02.2017 uses iconv/mbstring from utf8
     * @return string
     * @throws CoreFeatureException
     */
    public function shortenProductName($name) {
        $substrFunc = null;
        if (extension_loaded('mbstring')) {
            $substrFunc = function($string, $offset, $length) {
                return mb_substr($string, $offset, $length);
            };
        } elseif (function_exists('iconv')) {
            $substrFunc = function($string, $offset, $length) {
                return iconv_substr($string, $offset, $length, 'UTF-8');
            };
        } else {
            throw new CoreFeatureException('iconv or mbstring required to be installed');
        }
        return (string)$substrFunc(trim((string)$name), 0, $this->getProductNameMaxLength());
    }

    /**
     * @param int $orderId
     * @param Shipment[] $shipments
     * @param array $address
     * @param string $methodCode
     * @param mixed $validationData native
     * @return Shipment[]
     */
    abstract public function queryLabelsAndTracking($orderId, $shipments, $address, $methodCode, $validationData);

    /**
     * @param int $orderId
     * @param Shipment $shipment
     * @return Shipment
     */
    abstract public function voidLabel($orderId, $shipment);

    /**
     * @param string $url
     * @param bool $isProduction
     * @return string id
     */
    abstract public function mountWebhook($url, $isProduction);
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ApiException;

abstract class BaseValidationProvider extends BaseProvider {
    /**
     * @param array $address
     * @return bool|null
     */
    abstract public function isAddressResidential($address);

    /**
     * @param array $address
     * @return mixed|null native
     * @throws ApiException
     */
    abstract public function validateAddress($address);

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\Shipment;

abstract class BasePaperlessProvider extends BaseProvider {
    /**
     * @param int $orderId
     * @param Shipment[] $shipments
     * @return Shipment[] updated
     */
    abstract public function queryDocumentsUpload($orderId, $shipments);
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Origin {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Locale;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;

abstract class OriginPackage {
    const TypeBox = 'box';
    const TypeEnvelope = 'envelope';
    const TypeBag = 'bag';
    const TypePallet = 'pallet';
    const TypeCrate = 'crate';
    const ComposedIdStandard = 'standard';
    const ComposedIdCustomFixed = 'custom_package';
    const ComposedIdCustomExpandable = 'custom_envelope';
    const ComposedIdSeparator = ':';
    const ComposedIdWeightBased = 'weight_based';
    const ComposedIdShared = 'shared';
    const ComposedIdAny = 'any';

    /**
     * Id in provider. Null defines a custom box
     * @var int|null
     */
    protected $id;

    /**
     * Id across all boxes.
     * @var string
     */
    protected $composedId;
    /**
     * Shipping service (foreign) code for API requests.
     * @var string|null
     */
    protected $code;
    /** @var string */
    protected $title;
    /** @var string */
    protected $image;
    /** @var float */
    protected $tareWeight;
    /** @var bool */
    protected $isTareCalculated = false;
    /** @var float|null */
    protected $maxWeight;

    /**
     * @return int|null
     */
    final public function getId() {
        return $this->id;
    }

    /**
     * @return string
     */
    final public function getComposedId() {
        return $this->composedId;
    }

    /**
     * @return null|string
     */
    final public function getCode() {
        return $this->code;
    }

    /**
     * @return float
     */
    final public function getTareWeight() {
        return $this->tareWeight;
    }

    /**
     * @return string
     */
    final public function getImage() {
        return $this->image;
    }

    /**
     * @return string
     */
    final public function getTitle() {
        return $this->title;
    }

    /**
     * @return float|null
     */
    final public function getMaxWeight() {
        return $this->maxWeight;
    }


    /** @return string */
    abstract public function getType();

    /**
     * @param Locale $locale
     * @return string
     */
    abstract public function getSizeDescription($locale);

    /**
     * @param Locale $locale
     * @return string
     */
    final public function getWeightDescription($locale) {
        return ($this->isTareCalculated ? '&asymp;' : '') . $this->getTareWeightWithLocale($locale, true) .
        ($this->getMaxWeight() ? (', ' . $locale->renderLargeWeight($this->getMaxWeight(), true) . ' max') : '');
    }


    /**
     * This method MUST be defined in final class
     * @throws ConfigurationException
     * @return string
     */
    protected static function getTareUnitType() {
        throw new ConfigurationException('Can not be called from abstract class');
    }

    /**
     * This method MUST be defined in final class
     * @throws ConfigurationException
     */
    protected static function getDefaultDensity() {
        throw new ConfigurationException('Can not be called from abstract class');
    }

    /**
     * @param Locale $locale
     * @param bool $isWithUnit
     * @throws ConfigurationException
     * @return string
     */
    final public function getTareWeightWithLocale($locale, $isWithUnit = false) {
        switch ($this->getTareUnitType()) {
            case Weight::UnitTypeLarge:
                return $locale->renderLargeWeight($this->getTareWeight(), $isWithUnit);
            case Weight::UnitTypeSmall:
                return $locale->renderSmallWeight(Weight::convertPoundsToOunces($this->getTareWeight()), $isWithUnit);
            default:
                throw new ConfigurationException('Unknown tare weight unit type ' . $this->getTareUnitType());
        }
    }

    /**
     * @param float $maxWeight
     * @param float $maxHeight for Pallets
     * @return PackerBox[]
     */
    abstract public function generatePackerBoxes($maxWeight, $maxHeight);

    /** @return array */
    abstract public function toArray();

    /**
     * @param array $data
     * @throws ConfigurationException
     * @return OriginPackage
     */
    final public static function createFromArray($data) {
        switch ($data['type']) {
            case self::TypeBox:
                return new OriginBox($data);
            case self::TypeEnvelope:
                return new OriginEnvelope($data);
            case self::TypeBag:
                return new OriginBag($data);
            case self::TypePallet:
                return new OriginPallet($data);
            case self::TypeCrate:
                return new OriginCrate($data);
            default:
                throw new ConfigurationException('Unknown Origin Package type: ' . $data['type']);
        }
    }

    /**
     * @param string $type
     * @return float
     * @throws ConfigurationException
     */
    final public static function getCustomPackageDensity($type) {
        switch ($type) {
            case self::TypeBox:
                return OriginBox::getDefaultDensity();
            case self::TypeEnvelope:
                return OriginEnvelope::getDefaultDensity();
            case self::TypeBag:
                return OriginBag::getDefaultDensity();
            case self::TypePallet:
                return OriginPallet::getDefaultDensity();
            case self::TypeCrate:
                return OriginCrate::getDefaultDensity();
            default:
                throw new ConfigurationException('Unknown Origin Package type: '. $type);
        }
    }

    /**
     * @param string $type
     * @return string
     * @throws ConfigurationException
     */
    final public static function getCustomPackageTareUnitType($type) {
        switch ($type) {
            case self::TypeBox:
                return OriginBox::getTareUnitType();
            case self::TypeEnvelope:
                return OriginEnvelope::getTareUnitType();
            case self::TypeBag:
                return OriginBag::getTareUnitType();
            case self::TypePallet:
                return OriginPallet::getTareUnitType();
            case self::TypeCrate:
                return OriginCrate::getTareUnitType();
            default:
                throw new ConfigurationException('Unknown Origin Package type: '. $type);
        }
    }

    final public static function getCustomPackageTitle($type) {
        return ucfirst($type);
    }


}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Origin {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Length;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Locale;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerBox;

abstract class OriginFixed extends OriginPackage {
    /** @var float[]|null[] */
    protected $dimensionsOutside;
    /** @var float[]|null[] */
    protected $dimensionsInside;

    final public static function createFromMetric($data) {
        $class = get_called_class();
        if (isset($data['tare'])) {
            $data['tare'] = call_user_func(Array($class, 'getTareUnitType')) === Weight::UnitTypeSmall ?
                Weight::convertGramsToOunces($data['tare']) : Weight::convertKilogramsToPounds($data['tare']);
        }
        if (isset($data['max_load'])) {
            $data['max_load'] = Weight::convertKilogramsToPounds($data['max_load']);
        }
        if (isset($data['max_weight'])) {
            $data['max_weight'] = Weight::convertKilogramsToPounds($data['max_weight']);
        }
        $cmToIn = function($v) {
            return Length::convertCentimetersToInches($v);
        };
        $data['dimensions_outside'] = array_map($cmToIn, $data['dimensions_outside']);
        $data['dimensions_inside'] = array_map($cmToIn, $data['dimensions_inside']);
        return new $class($data);
    }

    /**
     * @param Locale $locale
     * @return string
     */
    final public function getSizeDescription($locale) {
        return $locale->renderDimensions($this->dimensionsOutside);
    }

    /**
     * @return array
     */
    final public function toArray() {
        return array(
            'type' => $this->getType(),
            'id' => $this->id,
            'composed_id' => $this->composedId,
            'code' => $this->code,
            'title' => $this->title,
            'image' => $this->image,
            'tare' => $this->getTareUnitType() === Weight::UnitTypeSmall ?
                Weight::convertPoundsToOunces($this->tareWeight) : $this->tareWeight,
            'max_weight' => $this->maxWeight,
            'dimensions_outside' => $this->dimensionsOutside,
            'dimensions_inside' => $this->dimensionsInside
        );
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Origin {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Length;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Locale;

abstract class OriginExpandable extends OriginPackage {
    /** @var float */
    protected $length;
    /** @var float */
    protected $width;
    /** @var float|null */
    protected $maxHeight;

    /**
     * @param $data
     * @return self
     */
    final public static function createFromMetric($data) {
        $class = get_called_class();
        if (isset($data['tare'])) {
            $data['tare'] = call_user_func(Array($class, 'getTareUnitType')) === Weight::UnitTypeSmall ?
                Weight::convertGramsToOunces($data['tare']) : Weight::convertKilogramsToPounds($data['tare']);
        }
        if (isset($data['max_load'])) {
            $data['max_load'] = Weight::convertKilogramsToPounds($data['max_load']);
        }
        if (isset($data['max_weight'])) {
            $data['max_weight'] = Weight::convertKilogramsToPounds($data['max_weight']);
        }
        $data['length'] = Length::convertCentimetersToInches($data['length']);
        $data['width'] = Length::convertCentimetersToInches($data['width']);
        if (isset($data['max_height'])) {
            $data['max_height'] = Length::convertCentimetersToInches($data['max_height']);
        }
        return new $class($data);
    }

    /**
     * @param Locale $locale
     * @return string
     */
    final public function getSizeDescription($locale) {
        return $locale->renderDimensions(array($this->length, $this->width)) .
        ($this->maxHeight ? ' (x ' . $locale->renderLength($this->maxHeight, true) . ' max)' : '');
    }

    final public function toArray() {
        return array(
            'type' => $this->getType(),
            'id' => $this->id,
            'composed_id' => $this->composedId,
            'code' => $this->code,
            'title' => $this->title,
            'image' => $this->image,
            'tare' => $this->getTareUnitType() === Weight::UnitTypeSmall ?
                Weight::convertPoundsToOunces($this->tareWeight) : $this->tareWeight,
            'max_weight' => $this->maxWeight,
            'length' => $this->length,
            'width' => $this->width,
            'max_height' => $this->maxHeight
        );
    }


}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Origin {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Square;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerBox;

class OriginBox extends OriginFixed {
    const CustomBoxImage = 'custom-box.png';

    /**
     * tare - predefined weight of the box (oz)
     * density - Weight material density constant
     * max_load - load limit for custom boxes (lb)
     * max_weight - brutto weight limit (lb)
     * dimensions_outside, dimensions_inside - (in)
     * @since 18.10.2016 tare can be zero and dimensions can be null
     * @param array $data
     * @throws ConfigurationException
     */
    public function __construct($data) {
        if (!isset($data['tare'])) {
            if (!isset($data['density'])) {
                throw new ConfigurationException('Tare or Density must be specified for OriginBox');
            }
            $this->isTareCalculated = true;
        }
        $data['max_load'] = isset($data['max_load']) ? $data['max_load'] : 0;
        $this->dimensionsOutside = isset($data['dimensions_outside']) ? $data['dimensions_outside'] :
            array(null, null, null);
        $this->dimensionsInside = isset($data['dimensions_inside']) ? $data['dimensions_inside'] :
            array(null, null, null);
        $this->id = isset($data['id']) ? $data['id'] : null;
        $this->composedId = isset($data['composed_id']) ? $data['composed_id'] : (
            isset($data['id']) ? self::ComposedIdStandard . self::ComposedIdSeparator . $data['id'] : null
        );
        $this->code = isset($data['code']) ? $data['code'] : null;
        $this->title = $data['title'];
        $this->image = isset($data['image']) ? $data['image'] : self::CustomBoxImage;
        $this->tareWeight = isset($data['tare']) ? Weight::convertOuncesToPounds($data['tare']) :
            Weight::ofMaterial(Square::ofBoxSurface($this->dimensionsOutside), $data['density']);
        $this->maxWeight = isset($data['max_weight']) ? $data['max_weight'] :
            ($data['max_load'] ? $data['max_load'] + $this->tareWeight : null);
    }

    public function getType() {
        return self::TypeBox;
    }

    public static function getTareUnitType() {
        return Weight::UnitTypeSmall;
    }

    public static function getDefaultDensity() {
        return Weight::SoftCartonDensity;
    }

    /**
     * @param float $maxWeight
     * @param float $maxHeight not used
     * @return PackerBox[]
     */
    final public function generatePackerBoxes($maxWeight, $maxHeight) {
        return array(new PackerBox(array(
            'tare' => $this->tareWeight,
            'max_weight' => $this->maxWeight ? min($this->maxWeight, $maxWeight) : $maxWeight,
            'dimensions_outside' => $this->dimensionsOutside,
            'dimensions_inside' => $this->dimensionsInside,
            'origin' => $this
        )));
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Origin {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Square;

class OriginEnvelope extends OriginExpandable {
    const CustomEnvelopeImage = 'custom-envelope.png';

    /**
     * Length and Width dimensions being reduced depending on Height dimension grows and using this value
     * X(z) = Xo - 1.95 * Z
     */
    const DimensionsRatio = 1.95;

    /** Used to calculate number of steps (initial step size, in) */
    const StepsRatio = 0.5;
    const MinSteps = 2;
    const MinGrow = 0.05;

    /**
     * tare - predefined weight of the envelope (oz)
     * density - Weight material density constant
     * max_load - load limit for custom envelopes (lb)
     * max_weight - brutto weight limit (lb)
     * max_height - expandable height limit (in)
     * length, width - (in)
     * @since 18.10.2016 tare can be zero
     * @param $data
     * @throws ConfigurationException
     */
    public function __construct($data) {
        if (!isset($data['tare'])) {
            if (!isset($data['density'])) {
                throw new ConfigurationException('Tare or Density must be specified for OriginEnvelope');
            }
            $this->isTareCalculated = true;
        }
        $data['max_load'] = isset($data['max_load']) ? $data['max_load'] : 0;
        $data['max_height'] = isset($data['max_height']) ? $data['max_height'] : 0;
        $this->length = $data['length'];
        $this->width = $data['width'];
        $this->id = isset($data['id']) ? $data['id'] : null;
        $this->composedId = isset($data['composed_id']) ? $data['composed_id'] : (
            isset($data['id']) ? self::ComposedIdStandard . self::ComposedIdSeparator .$data['id'] : null
        );
        $this->code = isset($data['code']) ? $data['code'] : null;
        $this->title = $data['title'];
        $this->image = isset($data['image']) ? $data['image'] : self::CustomEnvelopeImage;
        $this->tareWeight = isset($data['tare']) ? Weight::convertOuncesToPounds($data['tare']) :
            Weight::ofMaterial(Square::ofFlatSurface($this->length, $this->width), $data['density']);
        $this->maxWeight = isset($data['max_weight']) ? $data['max_weight'] :
            ($data['max_load'] ? $data['max_load'] + $this->tareWeight : null);
        $this->maxHeight = $data['max_height'] ?: null;
    }

    public function getType() {
        return self::TypeEnvelope;
    }

    public static function getTareUnitType() {
        return Weight::UnitTypeSmall;
    }

    public static function getDefaultDensity() {
        return Weight::PaperDensity;
    }

    /**
     * @param float $maxWeight
     * @param float $maxHeight not used
     * @return PackerBox[]
     */
    public function generatePackerBoxes($maxWeight, $maxHeight) {
        $result = array();
        $minDimension = min($this->length, $this->width);

        // less than predefined limit or width
        $heightLimit = $this->maxHeight ?: $minDimension;
        $steps = max(round($heightLimit / static::StepsRatio), static::MinSteps);
        $stepGrow = max($heightLimit / $steps, static::MinGrow);
        for ($height = $stepGrow; $height <= $heightLimit; $height += $stepGrow) {
            $dimensionReducer = static::DimensionsRatio * $height;
            if ($height >= $minDimension - $dimensionReducer) {
                // less than calculated width
                break;
            }
            $dimensions = array(
                $this->length - $dimensionReducer,
                $this->width - $dimensionReducer,
                $height
            );
            $result[] = new PackerBox(array(
                'tare' => $this->tareWeight,
                'max_weight' => ($this->maxWeight ? min($this->maxWeight, $maxWeight) : $maxWeight),
                'dimensions_outside' => $dimensions,
                'dimensions_inside' => $dimensions,
                'origin' => $this
            ));
        }
        return $result;
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Origin {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Square;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;

/**
 * Class OriginBag
 * Implementation of "If it packs it posts" for plastic bags that allow deformation
 * @package \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin
 */
class OriginBag extends OriginExpandable {
    const CustomBagImage = 'custom-bag.png'; // todo btw
    const StepsRatio = 0.2; // 5mm, initial step size
    const MinSteps = 4;
    const MaxSteps = 50;
    const MinGrow = 0.05;
    const Tolerance = 15; // %, safety gap for real life conditions
    /**
     * less deformation from outside
     * @todo made for AusPost and actually should not be here
     */
    const OutsideDimensionsRatio = 1.4;

    public function getType() {
        return self::TypeBag;
    }

    public static function getDefaultDensity() {
        return Weight::PlasticDensity;
    }

    public static function getTareUnitType() {
        return Weight::UnitTypeSmall;
    }

    /**
     * tare - predefined weight of the bag (oz)
     * density - Weight material density constant
     * max_load - load limit for custom bag (lb)
     * max_weight - brutto weight limit (lb)
     * max_height - expandable height limit (in)
     * length, width - (in)
     * @since 18.10.2016 tare can be zero
     * @param $data
     * @throws ConfigurationException
     */
    public function __construct($data) {
        if (!isset($data['tare'])) {
            if (!isset($data['density'])) {
                throw new ConfigurationException('Tare or Density must be specified for OriginBag');
            }
            $this->isTareCalculated = true;
        }
        $data['max_load'] = isset($data['max_load']) ? $data['max_load'] : 0;
        $data['max_height'] = isset($data['max_height']) ? $data['max_height'] : 0;
        $this->length = $data['length'];
        $this->width = $data['width'];
        $this->id = isset($data['id']) ? $data['id'] : null;
        $this->composedId = isset($data['composed_id']) ? $data['composed_id'] : (
        isset($data['id']) ? self::ComposedIdStandard . self::ComposedIdSeparator .$data['id'] : null
        );
        $this->code = isset($data['code']) ? $data['code'] : null;
        $this->title = $data['title'];
        $this->image = isset($data['image']) ? $data['image'] : self::CustomBagImage;
        $this->tareWeight = isset($data['tare']) ? Weight::convertOuncesToPounds($data['tare']) :
            Weight::ofMaterial(Square::ofFlatSurface($this->length, $this->width), $data['density']);
        $this->maxWeight = isset($data['max_weight']) ? $data['max_weight'] :
            ($data['max_load'] ? $data['max_load'] + $this->tareWeight : null);
        $this->maxHeight = $data['max_height'] ?: null;
    }

    /**
     * Generates boxes and ensures that their surfaces are equal to the surface of flat bag
     * 2 * ((L-x)*(W-x) + (L-x)*H + (W-x)*H) = L*W*2
     * @param float $maxWeight
     * @param float $maxHeight not used
     * @return PackerBox[]
     */
    public function generatePackerBoxes($maxWeight, $maxHeight) {
        $result = array();
        $length = max($this->length, $this->width);
        $width = min($this->length, $this->width);
        $heightLimit = $this->maxHeight ?: $width;
        $steps = min(max(round($heightLimit / static::StepsRatio), static::MinSteps), static::MaxSteps);
        $stepGrow = max($heightLimit / $steps, static::MinGrow);
        for ($height = $stepGrow; $height <= $heightLimit; $height += $stepGrow) {
            $a = 2;
            $b = -4 * $height - 2 * $length - 2 * $width;
            $c = 2 * $height * $length + 2 * $height * $width;
            $D = pow($b, 2) - 4 * $a * $c;
            $sqD = sqrt($D);
            $xArr = array(
                (-$b + $sqD) / (2 * $a),
                (-$b - $sqD) / (2 * $a)
            );
            $xArr = array_filter($xArr, function($x) use ($width) { // this is our reducer
                return ($x > 0) && ($x < $width);
            });
            if (count($xArr) === 0) {
                continue;
            }
            $x = (100 + self::Tolerance) * min($xArr) / 100;
            if ($height >= $width - $x) { // less than calculated width
                break;
            }
            // todo auspost specific, outer grow check, reorganize
            if ($height >= $width - static::OutsideDimensionsRatio * $height) {
                break;
            }
            $insideDim = array(
                $this->length - $x,
                $this->width - $x,
                $height
            );
            // todo auspost specific, outer grow check, change constant to argument
            $outsideDim = array(
                $this->length - static::OutsideDimensionsRatio * $height,
                $this->width - static::OutsideDimensionsRatio * $height,
                $height
            );
            $result[] = new PackerBox(array(
                'tare' => $this->tareWeight,
                'max_weight' => ($this->maxWeight ? min($this->maxWeight, $maxWeight) : $maxWeight),
                'dimensions_outside' => $outsideDim,
                'dimensions_inside' => $insideDim,
                'origin' => $this
            ));
        }
        return $result;
    }


}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Origin {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Square;

class OriginPallet extends OriginExpandable {
    const CustomPalletImage = 'custom-pallet.png';

    /** Used to calculate number of steps */
    const StepsRatio = 1.0;
    const MinSteps = 2;
    const MinGrow = 0.25;
    /** Height of wood */
    const PalletHeight = 5.67;

    /**
     * tare - predefined weight of the pallet (LB!)
     * density - Weight material density constant
     * max_load - load limit for custom pallet (lb)
     * max_weight - brutto weight limit (lb)
     * max_height - expandable height limit (in)
     * length, width, height - (in)
     * @since 18.10.2016 tare can be zero
     * @param $data
     * @throws ConfigurationException
     */
    public function __construct($data) {
        if (!isset($data['tare'])) {
            if (!isset($data['density'])) {
                throw new ConfigurationException('Tare or Density must be specified for OriginPallet');
            }
            $this->isTareCalculated = true;
        }
        $data['max_load'] = isset($data['max_load']) ? $data['max_load'] : 0;
        $this->length = $data['length'];
        $this->width = $data['width'];
        $this->maxHeight = isset($data['max_height']) ? $data['max_height'] : null;
        $this->id = isset($data['id']) ? $data['id'] : null;
        $this->composedId = isset($data['composed_id']) ? $data['composed_id'] : (
            isset($data['id']) ? self::ComposedIdStandard . self::ComposedIdSeparator .$data['id'] : null
        );
        $this->code = isset($data['code']) ? $data['code'] : null;
        $this->title = $data['title'];
        $this->image = isset($data['image']) ? $data['image'] : self::CustomPalletImage;
        $this->tareWeight = isset($data['tare']) ? $data['tare'] :
            Weight::ofMaterial(Square::ofFlatSurface($this->length, $this->width), $data['density']);
        $this->maxWeight = isset($data['max_weight']) ? $data['max_weight'] :
            ($data['max_load'] ? $data['max_load'] + $this->tareWeight : null);
    }

    public function getType() {
        return self::TypePallet;
    }

    public static function getTareUnitType() {
        return Weight::UnitTypeLarge;
    }

    public static function getDefaultDensity() {
        return Weight::WoodDensity;
    }

    /**
     * @param float $maxWeight
     * @param float $maxHeight
     * @return PackerBox[]
     */
    public function generatePackerBoxes($maxWeight, $maxHeight) {
        $result = array();
        $finalMaxHeight = $this->maxHeight ? min($this->maxHeight, $maxHeight) : $maxHeight;
        $steps = max(round($finalMaxHeight / self::StepsRatio), self::MinSteps);
        $stepGrow = max($finalMaxHeight / $steps, self::MinGrow);
        for ($height = $stepGrow; $height <= $finalMaxHeight; $height += $stepGrow) {
            if ($height < self::PalletHeight) {
                continue;
            }
            $dimensionsOutside = array($this->length, $this->width, $height);
            $dimensionsInside = array($this->length, $this->width, $height - self::PalletHeight);
            $result[] = new PackerBox(array(
                'tare' => $this->tareWeight,
                'max_weight' => ($this->maxWeight ? min($this->maxWeight, $maxWeight) : $maxWeight),
                'dimensions_outside' => $dimensionsOutside,
                'dimensions_inside' => $dimensionsInside,
                'dimensions_sort' => false,
                'origin' => $this
            ));
        }
        return $result;
    }

}
}

namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Origin {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Square;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerBox;

class OriginCrate extends OriginFixed {
    const CustomCrateImage = 'custom-crate.png';
    const CrateSideThickness = 0.25;
    /** Height of wood in the bottom */
    const CratePalletHeight = 5.67;

    /**
     * tare - predefined weight of the crate (LB!)
     * density - Weight material density constant
     * max_load - load limit for custom crate (lb)
     * max_weight - brutto weight limit (lb)
     * dimensions_outside, dimensions_inside - (in)
     * @since 18.10.2016 tare can be zero and dimensions can be null
     * @param array $data
     * @throws ConfigurationException
     */
    public function __construct($data) {
        if (!isset($data['tare'])) {
            if (!isset($data['density'])) {
                throw new ConfigurationException('Tare or Density must be specified for OriginCrate');
            }
            $this->isTareCalculated = true;
        }
        $data['max_load'] = isset($data['max_load']) ? $data['max_load'] : 0;
        $this->dimensionsInside = $data['dimensions_inside'];
        $this->dimensionsOutside = isset($data['id']) ? $data['dimensions_outside'] : array( // when custom
            $data['dimensions_outside'][0] + 2 * self::CrateSideThickness,
            $data['dimensions_outside'][1] + 2 * self::CrateSideThickness,
            $data['dimensions_outside'][2] + self::CratePalletHeight + self::CrateSideThickness
        );
        $this->id = isset($data['id']) ? $data['id'] : null;
        $this->composedId = isset($data['composed_id']) ? $data['composed_id'] : (
            isset($data['id']) ? self::ComposedIdStandard . self::ComposedIdSeparator .$data['id'] : null
        );
        $this->code = isset($data['code']) ? $data['code'] : null;
        $this->title = $data['title'];
        $this->image = isset($data['image']) ? $data['image'] : self::CustomCrateImage;
        $this->tareWeight = isset($data['tare']) ? $data['tare'] :
            Weight::ofMaterial(Square::ofBoxSurface($this->dimensionsOutside), $data['density']);
        $this->maxWeight = isset($data['max_weight']) ? $data['max_weight'] :
            ($data['max_load'] ? $data['max_load'] + $this->tareWeight : null);
    }

    public function getType() {
        return self::TypeCrate;
    }

    public static function getTareUnitType() {
        return Weight::UnitTypeLarge;
    }

    public static function getDefaultDensity() {
        return Weight::WoodDensity;
    }

    /**
     * @param float $maxWeight
     * @param float $maxHeight not used
     * @return PackerBox[]
     */
    public function generatePackerBoxes($maxWeight, $maxHeight) {
        return array(new PackerBox(array(
            'tare' => $this->tareWeight,
            'max_weight' => $this->maxWeight ? min($this->maxWeight, $maxWeight) : $maxWeight,
            'dimensions_outside' => $this->dimensionsOutside,
            'dimensions_inside' => $this->dimensionsInside,
            'dimensions_sort' => false,
            'origin' => $this
        )));
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Packer {

interface PackerInterface {
    public function addBox($box);
    public function addItem($item, $quantity);
    public function pack();
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Packer {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\Configuration;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\CurrencyConverter;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Length;

abstract class ValuableBox {
    /**
     * @return float|null
     */
    abstract public function getOuterHeight();

    /**
     * @return float|null
     */
    abstract public function getInnerHeight();

    /**
     * @return float|null
     */
    abstract public function getOuterLength();

    /**
     * @return float|null
     */
    abstract public function getInnerLength();

    /**
     * @return float
     */
    abstract public function getValue();

    /**
     * @return float
     */
    abstract public function getWeight();

    /**
     * @return float|null
     */
    abstract public function getOuterWidth();

    /**
     * @return float|null
     */
    abstract public function getInnerWidth();

    /**
     * Checks that box has dimensions (not weight based box)
     * @return bool
     */
    public function hasDimensions() {
        return $this->getOuterLength() && $this->getOuterWidth() && $this->getOuterHeight() &&
            $this->getInnerLength() && $this->getInnerWidth() && $this->getInnerHeight();
    }

    /**
     * @return float|null in cubic feet
     */
    public function getOuterVolumeInCubicFeet() {
        return Length::convertInchesToFeet($this->getOuterLength()) *
            Length::convertInchesToFeet($this->getOuterWidth()) *
            Length::convertInchesToFeet($this->getOuterHeight());
    }

    /**
     * @return float|null in cubic meters
     */
    public function getOuterVolumeInCubicMeters() {
        return Length::convertInchesToMeters($this->getOuterLength()) *
            Length::convertInchesToMeters($this->getOuterWidth()) *
            Length::convertInchesToMeters($this->getOuterHeight());
    }

    /**
     * @return string
     */
    abstract public function getCode();

    /**
     * @return string
     */
    abstract public function getType();

    /**
     * Returns that insurance is NOT disabled and total value is above the limit
     * @since 03.08.2017 accepts $total in system currency
     * @param float|null $total in system currency, Null forces to use $boxes
     * @param ValuableBox[]|null $boxes
     * @param Configuration $configuration
     * @param CurrencyConverter|null $converter, not required when using total
     * @param string|null $boxCurrency Boxes value currency, not required when using total
     * @return bool
     */
    public static function canInsuranceBeIncluded($total, $boxes, $configuration, $converter, $boxCurrency) {
        if ($configuration->get('insurance') === Configuration::InsuranceDisabled) {
            return false;
        }
        $min = (float)$configuration->get('insurance_from');
        if ($min > 0) {
            if ($total) {
                return (float)$total >= $min; // in system currency
            } elseif (is_array($boxes)) {
                try {
                    $total = array_sum(array_map(function ($box) {
                        /** @var ValuableBox $box */
                        if (!method_exists($box, 'getValue')) {
                            throw new ConfigurationException('invalid argument - boxes');
                        }
                        return $box->getValue();
                    }, $boxes));
                } catch (\Exception $e) {
                    return true;
                }
                return $converter->toSystem($total, $boxCurrency) >= $min; // back to system currency
            }
        }
        return true;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Packer {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\PackedBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\PackedBoxList;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\PackagingException;

class MultiPacker {
    /** @var PackerInterface[] */
    protected $packers = array();

    /**
     * false: compare boxes by volume
     * true: compare boxes by used volume
     * @var bool
     */
    protected $compareUsedVolume = false;

    /**
     * @param PackerInterface[] $packers
     */
    public function __construct($packers) {
        $this->packers = $packers;
    }

    public function setCompareUsedVolume($bool) {
        $this->compareUsedVolume = (bool)$bool;
    }

    /**
     * @param PackerInterface[] $packers
     */
    public function addPackers($packers) {
        $this->packers = array_merge($this->packers, $packers);
    }

    /**
     * @param PackerItem $item
     * @param int $quantity
     */
    public function addItem($item, $quantity) {
        foreach ($this->packers as $packer) {
            $packer->addItem($item, $quantity);
        }
    }

    /**
     * @param PackerBox $box
     */
    public function addBox($box) {
        foreach ($this->packers as $packer) {
            $packer->addBox($box);
        }
    }

    /**
     * @throws \Exception
     * @return PackedBoxList
     */
    public function pack() {
        $results = array();
        $errorMessages = array();
        foreach ($this->packers as $packer) {
            try {
                $packedResult = $packer->pack();
                $results[] = $packedResult;
            } catch (\Exception $e) {
                $packerName = current(array_reverse(explode('\\', get_class($packer))));
                $errorMessages[] = $packerName . ': ' . $e->getMessage();
            }
        }

        /**
         * @param PackedBoxList $res
         * @return float
         */
        $calculateTotalVolume = function($res) {
            $res = clone $res;
            $volume = 0;
            foreach ($res as $packedBox) {
                /** @var PackedBox $packedBox */
                $volume += $packedBox->getBox()->getInnerVolume();
            }
            return $volume;
        };

        /**
         * @param PackedBoxList $res
         * @return float
         */
        $calculateUsedVolume = function($res) {
            $res = clone $res;
            $volume = 0;
            foreach ($res as $packedBox) {
                /** @var PackedBox $packedBox */
                $volume += $packedBox->getUsedLength() * $packedBox->getUsedWidth() * $packedBox->getUsedDepth();
            }
            return $volume;
        };

        $bestResult = null;
        $bestCount = null;
        $bestVolume = null;
        /** @var PackedBoxList $result */
        foreach ($results as $result) {
            $calculatedVolume = $this->compareUsedVolume ?
                $calculateUsedVolume($result) : $calculateTotalVolume($result);
            if (
                $bestCount === null ||
                $result->count() < $bestCount ||
                ($result->count() === $bestCount && $calculatedVolume < $bestVolume)
            ) {
                $bestCount = $result->count();
                $bestVolume = $calculatedVolume;
                $bestResult = $result;
            }
        }

        if ($bestResult) {
            return $bestResult;
        } else {
            throw new PackagingException(implode(".\n", $errorMessages));
        }
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Packer {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\PackedBoxList;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\PackedBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\ItemList;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\PackagingMap\Map;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\PackagingMap\Reserved;

class SimplePacked {
    const AveragedItemText = 'Averaged item';
    /** @var int */
    private $quantity;
    /** @var Reserved[] */
    private $reserved;

    public function __construct($quantity, $reserved) {
        $this->quantity = $quantity;
        $this->reserved = $reserved;
    }

    /**
     * @return int
     */
    public function getQuantity() {
        return $this->quantity;
    }

    /**
     * @return Reserved[]
     */
    public function getReserved() {
        return $this->reserved;
    }
}

class SimpleSameItemPacker implements PackerInterface {
    /** @var PackerBox[] */
    protected $boxes = array();
    /** @var PackerItem[] */
    protected $items = array();

    /**
     * @param PackerBox $box
     */
    public function addBox($box) {
        $this->boxes[] = $box;
    }

    /**
     * @param PackerItem $item
     * @param int $quantity
     */
    public function addItem($item, $quantity) {
        for ($i = 0; $i < $quantity; $i++) {
            $this->items[] = $item;
        }
    }

    /**
     * @since 18.10.2016 this packing method uses box tare weight
     * @throws \Exception
     * @return PackedBoxList
     */
    public function pack() {
        if (count($this->items) === 0) {
            throw new \Exception('Items are not specified');
        }

        if (count($this->boxes) === 0) {
            throw new \Exception('Boxes are not specified');
        }

        $itemsToPack = $this->items;
        $itemLength = 0;
        $itemWidth = 0;
        $itemDepth = 0;
        $itemWeight = 0;
        foreach ($this->items as $item) {
            /** @var PackerItem $item */
            $itemLength = max($itemLength, $item->getLength());
            $itemWidth = max($itemWidth, $item->getWidth());
            $itemDepth = max($itemDepth, $item->getDepth());
            $itemWeight = max($itemWeight, $item->getWeight());
        }

        $itemQuantity = count($itemsToPack);

        $boxResults = array();
        /** @var PackerBox $box */
        foreach ($this->boxes as $box) {
            $packed = $this->packIntoBox(array($itemLength, $itemWidth, $itemDepth), $box, $itemQuantity);
            $boxItemQuantity = min(
                $packed->getQuantity(),
                (int)(($box->getMaxWeight() - $box->getEmptyWeight()) / $itemWeight)
            );
            if ($boxItemQuantity > 0) {
                $boxInnerVolume = $box->getInnerVolume();
                if (
                    empty($boxResults[$boxItemQuantity]) ||
                    $boxResults[$boxItemQuantity]['boxVolume'] > $boxInnerVolume
                ) {
                    $boxResults[$boxItemQuantity] = array(
                        'box' => $box,
                        'boxVolume' => $boxInnerVolume,
                        'boxItemQuantity' => $boxItemQuantity,
                        'reserved' => array_slice($packed->getReserved(), 0, $boxItemQuantity)
                    );
                }
            }
        }

        if (count($boxResults) > 0) {
            ksort($boxResults);

            $result = new PackedBoxList();

            $remainingItemCount = $itemQuantity;
            while ($remainingItemCount > 0) {
                $matchingBox = null;
                foreach ($boxResults as $boxResult) {
                    if ($boxResult['boxItemQuantity'] >= $remainingItemCount) {
                        $matchingBox = $boxResult;
                        break;
                    }
                }

                if (!$matchingBox) {
                    $matchingBox = end($boxResults);
                }

                /** @var PackerBox $matchingBoxObj */
                $matchingBoxObj = $matchingBox['box'];

                $items = new ItemList();
                $itemCountToPut = min($remainingItemCount, $matchingBox['boxItemQuantity']);
                $matchingBox['reserved'] = array_slice($matchingBox['reserved'], 0, $itemCountToPut);

                $nextItemsToPack = array();
                while ($itemCountToPut > 0) {
                    /** @var PackerItem|PackerItemConstrained $item */
                    $item = array_shift($itemsToPack);
                    if (!$item) {
                        break;
                    }
                    if ($item instanceof PackerItemConstrained) {
                        if (!$item->canBePackedInBox($items, $matchingBoxObj)) {
                            $nextItemsToPack[] = $item;
                            continue;
                        }
                    }
                    $items->insert($item);
                    $remainingItemCount--;
                    $itemCountToPut--;
                }
                $itemsToPack = array_merge($itemsToPack, $nextItemsToPack);

                if ($items->isEmpty()) {
                    throw new \Exception('Cannot fit items to any box');
                }

                $map = new Map(get_class($this), $matchingBox['reserved']);
                $result->insert(PackedBox::fromPackingMap($matchingBoxObj, $items, $map));
            }

            return $result;
        }

        throw new \Exception('Cannot fit items to any box');
    }

    /**
     * @param float[] $itemDimensions
     * @param PackerBox $box
     * @param int $mappingLimit max quantity to put into box packaging map
     * @return SimplePacked
     */
    private function packIntoBox($itemDimensions, $box, $mappingLimit) {
        return $this->packIntoRect(
            $this->permuteDimensions($itemDimensions),
            array($box->getInnerLength(), $box->getInnerWidth(), $box->getInnerDepth()),
            $mappingLimit
        );
    }

    /**
     * @param float[][] $itemPositions
     * @param float[] $rect
     * @param int $mappingLimit max quantity to put into packaging map
     * @param float[] $rectOrigin
     * @return SimplePacked
     */
    private function packIntoRect($itemPositions, $rect, $mappingLimit, $rectOrigin = array(0, 0, 0)) {
        list($boxLength, $boxWidth, $boxDepth) = $rect;
        list($offsetLength, $offsetWidth, $offsetDepth) = $rectOrigin;
        $quantities = array();
        $reserved = array();
        foreach ($itemPositions as $itemPos) {
            list($itemLength, $itemWidth, $itemDepth) = $itemPos;
            $lengthRowCount = (int)($boxLength / $itemLength);
            $depthRowCount = (int)($boxDepth / $itemDepth);
            $widthRowCount = (int)($boxWidth / $itemWidth);

            if ($lengthRowCount === 0 || $widthRowCount === 0 || $depthRowCount === 0) {
                continue;
            }

            $remainingLength = $boxLength - $itemLength * $lengthRowCount;
            $remainingWidth = $boxWidth - $itemWidth * $widthRowCount;
            $remainingDepth = $boxDepth - $itemDepth * $depthRowCount;

            for ($d = 0; $d < $depthRowCount; $d++) {
                for ($l = 0; $l < $lengthRowCount; $l++) {
                    for ($w = 0; $w < $widthRowCount; $w++) {
                        $reserved[] = new Reserved(
                            $offsetLength + $itemLength * $l,
                            $offsetWidth + $itemWidth * $w,
                            $offsetDepth + $itemDepth * $d,
                            $itemLength, $itemWidth, $itemDepth,
                            SimplePacked::AveragedItemText
                        );
                        if (count($reserved) >= $mappingLimit) { // prevent memory leak
                            break 3;
                        }
                    }
                }
            }

            $remainingSpaceRects = array(
                array($remainingLength, $boxWidth, $boxDepth),
                array($boxLength, $remainingWidth, $boxDepth),
                array($boxLength, $boxWidth, $remainingDepth)
            );

            $remainingOrigins = array(
                array($offsetLength + $itemLength * $lengthRowCount, $offsetWidth, $offsetDepth),
                array($offsetLength, $offsetWidth + $itemWidth * $widthRowCount, $offsetDepth),
                array($offsetLength, $offsetWidth, $offsetDepth + $itemDepth * $depthRowCount)
            );

            $mainQuantity = $lengthRowCount * $widthRowCount * $depthRowCount;
            foreach ($remainingSpaceRects as $k => $remainingRect) {
                $subPack = $this->packIntoRect(
                    $itemPositions, $remainingRect,
                    $mappingLimit - $mainQuantity, $remainingOrigins[$k]
                );
                $quantities[] = $mainQuantity + $subPack->getQuantity();
                $reserved = array_merge($reserved, $subPack->getReserved());
            }

        }

        $maxPacked = array_reduce($quantities, 'max', 0);
        return new SimplePacked($maxPacked, array_slice($reserved, 0, $maxPacked));
    }

    /**
     * @param float[] $items
     * @param float[] $perms
     * @param float[][] $ret
     * @return float[][]
     */
    private function permuteDimensions($items, $perms = array(), &$ret = array()) {
        if (empty($items)) {
            $ret[] = $perms;
        } else {
            for ($i = count($items) - 1; $i >= 0; --$i) {
                $newItems = $items;
                $newPermutations = $perms;
                list($foo) = array_splice($newItems, $i, 1);
                array_unshift($newPermutations, $foo);
                $this->permuteDimensions($newItems, $newPermutations, $ret);
            }
        }
        return $ret;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Packer {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\PackedBoxList;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\PackedBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\ItemList;

class WeightBasedPacker implements PackerInterface {
    /** @var PackerBox[] */
    protected $boxes = array();
    /** @var PackerItem[] */
    protected $items = array();

    /**
     * @param PackerBox $box
     */
    public function addBox($box) {
        $this->boxes[] = $box;
    }

    /**
     * @param PackerItem $item
     * @param int $quantity
     */
    public function addItem($item, $quantity) {
        for ($i = 0; $i < $quantity; $i++) {
            $this->items[] = $item;
        }
    }

    /**
     * @throws \Exception
     * @return PackedBoxList
     */
    public function pack() {
        if (count($this->items) === 0) {
            throw new \Exception('Items are not specified');
        }

        if (count($this->boxes) === 0) {
            throw new \Exception('Boxes are not specified');
        }

        $itemsToPack = $this->items;
        usort($this->boxes, function ($a, $b) {
            /** @var $a PackerBox */
            /** @var $b PackerBox */
            if ($a->getMaxWeight() < $b->getMaxWeight()) {
                return -1;
            } elseif ($a->getMaxWeight() > $b->getMaxWeight()) {
                return 1;
            }
            return 0;
        });

        $result = new PackedBoxList();

        do {
            $totalRemainingWeight = array_sum(array_map(function ($item) {
                /** @var $item PackerItem */
                return $item->getWeight();
            }, $itemsToPack));

            /** @var $matchingBox PackerBox */
            $matchingBox = current(array_filter($this->boxes, function ($box) use ($totalRemainingWeight) {
                /** @var $box PackerBox */
                if ($box->getMaxWeight() >= $totalRemainingWeight) {
                    return true;
                }
                return false;
            }));

            if (!$matchingBox) {
                $matchingBox = end($this->boxes);
                reset($this->boxes);
            }

            $boxRemainingWeight = $matchingBox->getMaxWeight() - $matchingBox->getEmptyWeight();
            $packed = new ItemList();
            foreach ($itemsToPack as $k => $item) {
                if ($item->getWeight() <= $boxRemainingWeight) {
                    $packed->insert($item);
                    $boxRemainingWeight -= $item->getWeight();
                    unset($itemsToPack[$k]);
                }
            }

            if (count($packed)) {
                $result->insert(new PackedBox(
                    $matchingBox,
                    $packed,
                    0, 0, 0, $boxRemainingWeight,
                    $matchingBox->getInnerWidth(), $matchingBox->getInnerLength(), $matchingBox->getInnerDepth(),
                    null
                ));
            } else {
                throw new \Exception('Can not fit items in weight-based boxes');
            }

            $theRest = count($itemsToPack);
        } while ($theRest > 0);

        return $result;
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Packer {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\ConstrainedItem;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\Packer;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\Item;

class RotatedPacker extends Packer {
    /**
     * Add rotated item (replace length and width)
     * @since 07.08.2017 takes into account constrained items
     * @param Item $item actually: PackerItem
     * @param int $qty
     */
    public function addItem(Item $item, $qty = 1) {
        /** @var PackerItem|PackerItemConstrained $item */
        $constructorOptions = array(
            'id' => $item->getId(),
            'description' => $item->getDescription(),
            'options' => $item->getOptions(),
            'length' => $item->getWidth(),
            'width' => $item->getLength(),
            'height' => $item->getHeight(),
            'weight' => $item->getWeight(),
            'price' => $item->getPrice()
        );
        if ($item instanceof ConstrainedItem) {
            $constructorOptions['logic'] = $item->getLogic();
            $constructorOptions['shipping_categories'] = $item->getShippingCategories();
            $rotatedItem = new PackerItemConstrained($constructorOptions);
        } else {
            $rotatedItem = new PackerItem($constructorOptions);
        }
        parent::addItem($rotatedItem, $qty);
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Packer {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginPackage;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Number;

class PackerBox implements \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\Box {
    /** Logic-fix constant. Helps to fix floating point failure to completely fill box */
    const MaxBoxWeightCorrection = 0.000000001;

    /**
     * Can be changed by adjustTareWeight()
     * @var float
     */
    private $tareWeight;
    /**
     * Not equals OriginPackage::$maxWeight
     * @var float
     */
    private $maxWeight;
    /** @var float[]|null[] */
    private $dimensionsOutside;
    /** @var float[]|null[] */
    private $dimensionsInside;
    /** @var OriginPackage */
    private $originPackage;

    public function __construct($data) {
        if (!isset($data['dimensions_sort'])) {
            $data['dimensions_sort'] = true;
        }
        if ($data['dimensions_sort']) { // specific option for OriginPallet and OriginCrate
            rsort($data['dimensions_outside'], SORT_NUMERIC);
            rsort($data['dimensions_inside'], SORT_NUMERIC);
        }
        $this->tareWeight = $data['tare'];
        $this->maxWeight = $data['max_weight'] + self::MaxBoxWeightCorrection;
        $this->dimensionsOutside = $data['dimensions_outside'];
        $this->dimensionsInside = $data['dimensions_inside'];
        $this->originPackage = $data['origin'];
    }

    /**
     * Increases box tare weight. Actually returns the new box object with increased tare weight
     * @param float $incTareWeight
     * @return PackerBox
     */
    public function adjustTareWeight($incTareWeight) {
        if (Number::floatsAreEqual($incTareWeight, 0)) {
            return $this;
        }
        $newBox = clone($this);
        $newBox->tareWeight += $incTareWeight;
        return $newBox;
    }

    public function getReference() {
        // for packer use
        return $this->originPackage->getTitle();
    }

    public function getEmptyWeight() {
        return $this->tareWeight;
    }

    public function getMaxWeight() {
        return $this->maxWeight;
    }

    public function getOuterLength() {
        return $this->dimensionsOutside[0];
    }

    public function getOuterWidth() {
        return $this->dimensionsOutside[1];
    }

    public function getOuterDepth() {
        return $this->dimensionsOutside[2];
    }

    public function getInnerLength() {
        return $this->dimensionsInside[0];
    }

    public function getInnerWidth() {
        return $this->dimensionsInside[1];
    }

    public function getInnerDepth() {
        return $this->dimensionsInside[2];
    }

    public function getInnerVolume() {
        return array_product($this->dimensionsInside);
    }

    public function getDimensionsOutside() {
        return $this->dimensionsOutside;
    }

    public function getDimensionsInside() {
        return $this->dimensionsInside;
    }

    /**
     * @return OriginPackage
     */
    public function getOriginPackage() {
        return $this->originPackage;
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Packer {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\Item;

class PackerItem implements Item {
    /**
     * E-Commerce system product id
     * @var int|null
     */
    private $id;
    /** @var string */
    private $description;
    /** @var null|string */
    private $shortDescription;
    /** @var null|int Country of Origin */
    private $originCountryId;
    /** @var null|int Zone of Origin */
    private $originZoneId;
    /** @var null|string Harmonised System code */
    private $hsCode;
    /** @var string[] */
    private $options;
    /** @var float|null */
    private $width;
    /** @var float|null */
    private $length;
    /** @var float|null */
    private $height;
    /** @var float */
    private $weight;
    /**
     * In providers currency
     * @var float
     */
    private $price;
    /** @var bool */
    private $rotatable = true;

    public function __construct($data) {
        $this->id = isset($data['id']) ? $data['id'] : null;
        $this->description = $data['description'];
        $this->shortDescription = isset($data['short_description']) ? $data['short_description'] : null;
        $this->originCountryId = isset($data['origin_country_id']) ? $data['origin_country_id'] : null;
        $this->originZoneId = isset($data['origin_zone_id']) ? $data['origin_zone_id'] : null;
        $this->hsCode = isset($data['hs_code']) ? $data['hs_code'] : null;
        $this->options = isset($data['options']) ? (
            is_array($data['options']) ? $data['options'] : array()
        ) : array();
        $this->length = $data['length'];
        $this->width = $data['width'];
        $this->height = $data['height'];
        $this->weight = isset($data['weight']) ? $data['weight'] : 0;
        $this->price = isset($data['price']) ? $data['price'] : 0;
        $this->rotatable = isset($data['$rotatable']) ? (bool)$data['$rotatable'] : true;
    }

    public function getId() {
        return $this->id;
    }

    /**
     * Checks that Item is equals to another (by id and options)
     * @param PackerItem $otherItem
     * @return bool
     */
    public function isEqualTo($otherItem) {
        $thisHash = $this->getId() . serialize($this->getOptions());
        $otherHash = $otherItem->getId() . serialize($otherItem->getOptions());
        return $thisHash === $otherHash;
    }

    public function getDescription() {
        return $this->description;
    }

    public function getShortDescription() {
        return $this->shortDescription;
    }

    public function getOriginCountryId() {
        return $this->originCountryId;
    }

    public function getOriginZoneId() {
        return $this->originZoneId;
    }

    public function getHsCode() {
        return $this->hsCode;
    }

    public function getOptions() {
        return $this->options;
    }

    public function getWidth() {
        return $this->width;
    }

    public function getLength() {
        return $this->length;
    }

    public function getDepth() {
        return $this->height;
    }

    public function getHeight() {
        return $this->height;
    }

    public function getWeight() {
        return $this->weight;
    }

    public function getVolume() {
        return $this->width * $this->length * $this->height;
    }

    /**
     * In providers currency
     * @return float
     */
    public function getPrice() {
        return $this->price;
    }

    public function getKeepFlat() {
        return !$this->rotatable;
    }

    public function isRotatable() {
        return $this->rotatable;
    }

    public static function getSample() {
        return new self(array(
            'id' => null,
            'description' => 'test',
            'options' => array(),
            'length' => 10,
            'width' => 20,
            'height' => 30,
            'weight' => 5,
            'price' => 100
        ));
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Packer {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\Box;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\ConstrainedItem;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\DVDoug\BoxPacker\ItemList;

class PackerItemConstrained extends PackerItem implements ConstrainedItem {
    /** @var callable with args: this item, packed items, box. Returns bool */
    private $logic;

    /** @var array */
    private $shippingCategories;

    public function __construct($data) {
        parent::__construct($data);
        if (!isset($data['logic'])) {
            throw new ConfigurationException('Constrained item logic missing');
        }
        if (!is_callable($data['logic'])) {
            throw new ConfigurationException('Constrained item logic is not callable');
        }
        $this->logic = $data['logic'];
        $this->shippingCategories = $data['shipping_categories'];
    }

    /**
     * @param ItemList $alreadyPackedItems
     * @param Box $box
     * @return bool
     */
    public function canBePackedInBox(ItemList $alreadyPackedItems, Box $box) {
        return (bool)call_user_func($this->logic, $this, $alreadyPackedItems, $box);
    }

    /**
     * @return callable
     */
    public function getLogic() {
        return $this->logic;
    }

    /**
     * @return array
     */
    public function getShippingCategories() {
        return $this->shippingCategories;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Packer {

class PackerItemToPack {
    /** @var PackerItem */
    private $item;
    /** @var int */
    private $quantity;

    /**
     * @param PackerItem $item
     * @param int $quantity
     */
    public function __construct($item, $quantity) {
        $this->item = $item;
        $this->quantity = $quantity;
    }

    /**
     * @return PackerItem
     */
    public function getItem() {
        return $this->item;
    }

    /**
     * @return int
     */
    public function getQuantity() {
        return $this->quantity;
    }


}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Packer {

class PackerResult {
    /** @var PackerResultBox[] */
    private $boxes;

    /**
     * @param PackerResultBox[] $boxes
     */
    public function __construct($boxes) {
        $this->boxes = $boxes;
    }

    /**
     * @return PackerResultBox[]
     */
    public function getBoxes() {
        return $this->boxes;
    }

    /**
     * @return float
     */
    public function getTotalWeight() {
        return array_sum(array_map(function($box) {
            /** @var PackerResultBox $box */
            return $box->getWeight();
        }, $this->boxes));
    }

    /**
     * Returns total value of all boxes
     * @return float In providers currency
     */
    public function getTotalValue() {
        return array_sum(array_map(function($box) {
            /** @var PackerResultBox $box */
            return $box->getValue();
        }, $this->boxes));
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Packer {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\OrderedBoxPacked;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\OrderedBoxPackedItem;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\PackagingMap\Map;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Length;

class PackerResultBox extends ValuableBox {
    /** @var PackerBox */
    private $box;
    /** @var float */
    private $weight;
    /** @var PackerItem[] */
    private $products;
    /** @var Map|null */
    private $packagingMap;

    /**
     * @param PackerBox $box
     * @param float $weight
     * @param PackerItem[] $products
     * @param Map|null $packagingMap
     */
    public function __construct($box, $weight, $products, $packagingMap) {
        $this->box = $box;
        $this->weight = $weight;
        $this->products = $products;
        $this->packagingMap = $packagingMap;
    }

    /**
     * @return int|null
     */
    public function getId() {
        return $this->box->getOriginPackage()->getId();
    }

    /**
     * @return string
     */
    public function getCode() {
        return $this->box->getOriginPackage()->getCode();
    }

    /**
     * @return string
     */
    public function getType() {
        return $this->box->getOriginPackage()->getType();
    }

    /**
     * @return float|null
     */
    public function getOuterHeight() {
        return $this->box->getOuterDepth();
    }

    /**
     * @return float|null
     */
    public function getInnerHeight() {
        return $this->box->getInnerDepth();
    }

    /**
     * @return float|null
     */
    public function getOuterLength() {
        return $this->box->getOuterLength();
    }

    /**
     * @return float|null
     */
    public function getInnerLength() {
        return $this->box->getInnerLength();
    }

    /**
     * @return int
     */
    public function getProductCount() {
        return count($this->products);
    }

    /**
     * @return PackerItem[]
     */
    public function getProducts() {
        return $this->products;
    }

    /**
     * Returns value of all items in the box
     * @return float In providers currency
     */
    public function getValue() {
        return array_sum(array_map(function($item) {
            /** @var PackerItem $item */
            return $item->getPrice();
        }, $this->products));
    }

    /**
     * @return float
     */
    public function getWeight() {
        return $this->weight;
    }

    /**
     * @return float|null
     */
    public function getOuterWidth() {
        return $this->box->getOuterWidth();
    }

    /**
     * @return float|null
     */
    public function getInnerWidth() {
        return $this->box->getInnerWidth();
    }

    public function getPackagingMap() {
        return $this->packagingMap;
    }

    /**
     * @return OrderedBoxPacked
     */
    public function toOrdered() {
        $groups = array();
        foreach ($this->getProducts() as $item) {
            $groupFound = false;
            foreach ($groups as $k => $group) {
                if ($item->isEqualTo($group['item'])) {
                    $groups[$k]['quantity']++;
                    $groupFound = true;
                    break;
                }
            }
            if (!$groupFound) {
                $groups[] = array('item' => $item, 'quantity' => 1);
            }
        }
        $products = array();
        foreach ($groups as $group) {
            /** @var PackerItem $item */
            $item = $group['item'];
            $products[] = new OrderedBoxPackedItem(array(
                'id' => $item->getId(),
                'description' => $item->getDescription(),
                'short_description' => $item->getShortDescription(),
                'origin_country_id' => $item->getOriginCountryId(),
                'origin_zone_id' => $item->getOriginZoneId(),
                'hs_code' => $item->getHsCode(),
                'weight' => $item->getWeight(),
                'price' => $item->getPrice(),
                'options' => $item->getOptions(),
                'quantity' => $group['quantity']
            ));
        }
        return new OrderedBoxPacked(array(
            'weight' => $this->getWeight(),
            'value' => $this->getValue(),
            'outer_length' => $this->getOuterLength(),
            'outer_width' => $this->getOuterWidth(),
            'outer_height' => $this->getOuterHeight(),
            'inner_length' => $this->getInnerLength(),
            'inner_width' => $this->getInnerWidth(),
            'inner_height' => $this->getInnerHeight(),
            'products' => $products,
            'origin' => $this->box->getOriginPackage(),
            'packaging_map' => $this->getPackagingMap()
        ));
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginPackage;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\ValuableBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\PackagingMap\Map;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Fallback;

class OrderedBoxPacked extends ValuableBox {
    /** @var float */
    private $weight;
    /** @var float */
    private $value;
    /** @var float|null */
    private $outerLength;
    /** @var float|null */
    private $innerLength;
    /** @var float|null */
    private $outerWidth;
    /** @var float|null */
    private $innerWidth;
    /** @var float|null */
    private $outerHeight;
    /** @var float|null */
    private $innerHeight;
    /** @var OrderedBoxPackedItem[] */
    private $products;
    /** @var OriginPackage */
    private $originPackage;
    /** @var Map|null */
    private $packagingMap;

    /**
     * @param array $data
     */
    public function __construct($data) {
        $this->weight = $data['weight'];
        $this->value = $data['value'];
        $this->outerLength = $data['outer_length'];
        $this->outerWidth = $data['outer_width'];
        $this->outerHeight = $data['outer_height'];
        $this->innerLength = $data['inner_length'];
        $this->innerWidth = $data['inner_width'];
        $this->innerHeight = $data['inner_height'];
        $this->products = $data['products'];
        $this->originPackage = $data['origin'];
        $this->packagingMap = isset($data['packaging_map']) ? $data['packaging_map'] : null;
    }

    /**
     * @since 18.10.2016 dimensions can be null when weight-based packed
     * @since 15.01.2018 accepts fallback
     * @param array $data
     * @param Fallback $fallback
     * @throws ConfigurationException
     * @return OrderedBoxPacked
     */
    public static function createFromArray($data, $fallback) {
        // backward compatibility for dimensions
        if (!array_key_exists('outer_length', $data)) {
            $data['outer_length'] = isset($data['length']) ? $data['length'] : null;
        }
        if (!array_key_exists('inner_length', $data)) {
            $data['inner_length'] = isset($data['length']) ? $data['length'] : null;
        }
        if (!array_key_exists('outer_width', $data)) {
            $data['outer_width'] = isset($data['width']) ? $data['width'] : null;
        }
        if (!array_key_exists('inner_width', $data)) {
            $data['inner_width'] = isset($data['width']) ? $data['width'] : null;
        }
        if (!array_key_exists('outer_height', $data)) {
            $data['outer_height'] = isset($data['height']) ? $data['height'] : null;
        }
        if (!array_key_exists('inner_height', $data)) {
            $data['inner_height'] = isset($data['height']) ? $data['height'] : null;
        }

        $data['products'] = array_map(function($product) use ($fallback) {
            return new OrderedBoxPackedItem($product, $fallback);
        }, $data['products']);
        if (!isset($data['origin'])) {
            throw new ConfigurationException('Origin Box is not specified for Ordered Box Packed');
        }
        $data['origin'] = OriginPackage::createFromArray($data['origin']);
        $data['packaging_map'] = isset($data['packaging_map']) ? Map::createFromArray($data['packaging_map']) : null;
        return new OrderedBoxPacked($data);
    }

    /**
     * @return array
     */
    public function toArray() {
        return array(
            'weight' => $this->weight,
            'value' => $this->value,
            'outer_length' => $this->outerLength,
            'outer_width' => $this->outerWidth,
            'outer_height' => $this->outerHeight,
            'inner_length' => $this->innerLength,
            'inner_width' => $this->innerWidth,
            'inner_height' => $this->innerHeight,
            'products' => array_map(function($item) {
                /** @var OrderedBoxPackedItem $item */
                return $item->toArray();
            }, $this->products),
            'origin' => $this->originPackage->toArray(),
            'packaging_map' => $this->packagingMap ? $this->packagingMap->toArray() : null
        );
    }

    /**
     * @return float|null
     */
    public function getOuterHeight() {
        return $this->outerHeight;
    }

    /**
     * @return float|null
     */
    public function getInnerHeight() {
        return $this->innerHeight;
    }

    /**
     * @return float|null
     */
    public function getOuterLength() {
        return $this->outerLength;
    }

    /**
     * @return float|null
     */
    public function getInnerLength() {
        return $this->innerLength;
    }

    /**
     * @return OrderedBoxPackedItem[]
     */
    public function getProducts() {
        return $this->products;
    }

    /**
     * @return float
     */
    public function getValue() {
        return $this->value;
    }

    /**
     * @return float
     */
    public function getWeight() {
        return $this->weight;
    }

    /**
     * @return float|null
     */
    public function getOuterWidth() {
        return $this->outerWidth;
    }

    /**
     * @return float|null
     */
    public function getInnerWidth() {
        return $this->innerWidth;
    }

    /**
     * @return OriginPackage
     */
    public function getOriginPackage() {
        return $this->originPackage;
    }

    /**
     * @return string
     */
    public function getCode() {
        return $this->getOriginPackage()->getCode();
    }

    /**
     * @return string
     */
    public function getType() {
        return $this->getOriginPackage()->getType();
    }


    /**
     * @return null|Map
     */
    public function getPackagingMap() {
        return $this->packagingMap;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Fallback;

class OrderedBoxPackedItem {
    /** @var int */
    private $id;
    /** @var string */
    private $description;
    /** @var string|null */
    private $shortDescription;
    /** @var int|null */
    private $originCountryId;
    /** @var int|null */
    private $originZoneId;
    /** @var string|null */
    private $hsCode;
    /** @var float */
    private $weight;
    /** @var float */
    private $price;
    /** @var int */
    private $quantity = 1;
    /** @var string[] */
    private $options = array();

    /**
     * @param array $data
     * @param Fallback $fallback
     * @since 15.01.2018 accepts fallback
     */
    public function __construct($data, $fallback = null) {
        $this->id = $data['id'];
        $this->description = $data['description'];
        $this->shortDescription = isset($data['short_description']) ? $data['short_description'] : null;
        $this->originCountryId = isset($data['origin_country_id']) ? $data['origin_country_id'] :
            ($fallback ? $fallback->getOriginCountryId() : null);
        $this->originZoneId = isset($data['origin_zone_id']) ? $data['origin_zone_id'] :
            ($fallback ? $fallback->getOriginZoneId() : null);
        $this->hsCode = isset($data['hs_code']) ? $data['hs_code'] :
            ($fallback ? $fallback->getHsCode() : null);
        $this->weight = $data['weight'];
        $this->price = $data['price'];
        $this->options = $data['options'];
        $this->quantity = $data['quantity'];

    }

    /**
     * @return array
     */
    public function toArray() {
        return array(
            'id' => $this->id,
            'description' => $this->description,
            'short_description' => $this->shortDescription,
            'origin_country_id' => $this->originCountryId,
            'origin_zone_id' => $this->originZoneId,
            'hs_code' => $this->hsCode,
            'weight' => $this->weight,
            'price' => $this->price,
            'options' => $this->options,
            'quantity' => $this->quantity
        );
    }

    /**
     * @return string
     */
    public function getDescription() {
        return $this->description;
    }

    /**
     * @return null|string
     */
    public function getShortDescription() {
        return $this->shortDescription;
    }

    /**
     * @return int|null
     */
    public function getOriginCountryId() {
        return $this->originCountryId;
    }

    /**
     * @return int|null
     */
    public function getOriginZoneId() {
        return $this->originZoneId;
    }

    /**
     * @return null|string
     */
    public function getHsCode() {
        return $this->hsCode;
    }

    /**
     * @param null|int $numberOfDigits
     * @return string
     */
    public function getHsCodeAsNumeric($numberOfDigits = null) {
        $digits = preg_replace('/[^\d]/', '', $this->getHsCode());
        if ($numberOfDigits) {
            return substr($digits, 0, $numberOfDigits);
        }
        return $digits;
    }

    /**
     * @return int
     */
    public function getId() {
        return $this->id;
    }

    /**
     * @return string[]
     */
    public function getOptions() {
        return $this->options;
    }

    /**
     * @return float
     */
    public function getPrice() {
        return $this->price;
    }

    /**
     * @return int
     */
    public function getQuantity() {
        return $this->quantity;
    }

    /**
     * @return float
     */
    public function getWeight() {
        return $this->weight;
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\MultiRequest;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Fallback;

class AccompanyingDocument {
    const TypeLabel = 'LABEL';
    const TypeInvoice = 'INVOICE';
    const FormatPDF = 'application/pdf';
    const FormatPNG = 'image/png';

    /** @var string */
    protected $type;
    /** @var string MIME type of document */
    protected $format;
    /** @var string[] base64 encoded binary data */
    protected $pages = array();

    /**
     * @param string $type
     * @param string $format
     * @param string[] $pages base64 encoded binary data
     */
    public function __construct($type, $format, $pages) {
        $this->type = $type;
        $this->format = $format;
        $this->pages = is_array($pages) ? $pages : array();
    }

    /**
     * @return int
     */
    public function getNumberOfPages() {
        return count($this->pages);
    }

    /**
     * @param int $pageNumber
     * @return string base64 encoded binary data
     */
    public function getPage($pageNumber) {
        return isset($this->pages[$pageNumber]) ? $this->pages[$pageNumber] : null;
    }

    /**
     * @return string label, invoice, etc
     */
    public function getType() {
        return $this->type;
    }

    /**
     * @return string const: pdf, png, etc
     */
    public function getFormat() {
        return $this->format;
    }

    /**
     * @return string pdf, png, etc
     * @throws ConfigurationException
     */
    public function getExtension() {
        switch ($this->getFormat()) {
            case AccompanyingDocument::FormatPDF:
                return 'pdf';
            case AccompanyingDocument::FormatPNG:
                return 'png';
            default:
                throw new ConfigurationException('Can not convert mime type to extension');
        }
    }


    /**
     * @return string
     */
    public function getTypeDescription() {
        switch ($this->type) {
            case self::TypeLabel:
                return 'Shipping Label';
            case self::TypeInvoice:
                return 'Invoice';
        }
        return null;
    }

    /**
     * @return bool
     */
    public function isLabel() {
        return $this->type === self::TypeLabel;
    }

    /**
     * @return array
     */
    public function toArray() {
        return array(
            'type' => $this->type,
            'format' => $this->format,
            'pages' => $this->pages
        );
    }

    /**
     * @param array $data
     * @param Fallback $fallback for backward compatibility
     * @return AccompanyingDocument
     */
    public static function createFromArray($data, $fallback) {
        $fallbackLabelFormat = self::FormatPDF;
        if ($fallback) {
            if ($fallback->getLabelFormat()) {
                $fallbackLabelFormat = $fallback->getLabelFormat();
            }
        }
        return new self(
            $data['type'],
            isset($data['format']) ? $data['format'] :
                ($data['type'] === self::TypeLabel ? $fallbackLabelFormat : self::FormatPDF),
            $data['pages']
        );
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Fallback;

class Shipment {
    /** @var OrderedBoxPacked */
    private $box;
    /** @var string|null */
    private $trackingNumber = null;
    /** @var string|null */
    private $transactionNumber = null;
    /** @var string|null */
    private $trackingUrl = null;
    /** @var string|null */
    private $errorMessage = null;
    /** @var string|null */
    private $successMessage = null;
    /** @var AccompanyingDocument[] */
    private $documents = array();

    private function __construct() {
    }

    /**
     * @return Shipment
     */
    public static function create() {
        return new self();
    }

    /**
     * This method is used to restore serialized data
     * @since 15.01.2018 accepts fallback
     * @param array $data
     * @param Fallback $fallback
     * @throws ConfigurationException
     * @return Shipment
     */
    public static function createFromArray($data, $fallback) {
        $data['box'] = OrderedBoxPacked::createFromArray($data['box'], $fallback);
        // backward compatibility of labels
        if (!isset($data['documents'])) {
            $data['documents'] = array();
        }
        $data['documents'] = array_map(function($array) use ($fallback) {
            return AccompanyingDocument::createFromArray($array, $fallback);
        }, $data['documents']);
        if (isset($data['label']) && $data['label']) { // backward compatibility
            $data['documents'][] = new AccompanyingDocument(
                AccompanyingDocument::TypeLabel, $fallback->getLabelFormat(), array($data['label'])
            );
        }
        return self::create()->setBox($data['box'])
            ->setTrackingNumber($data['tracking_number'])
            ->setTrackingUrl(isset($data['tracking_url']) ? $data['tracking_url'] : null)
            ->setTransactionNumber(isset($data['transaction_number']) ? $data['transaction_number'] : null)
            ->setErrorMessage(isset($data['error_message']) ? $data['error_message'] : null)
            ->setSuccessMessage(isset($data['success_message']) ? $data['success_message'] : null)
            ->setDocuments($data['documents']);
    }

    /**
     * @return array
     */
    public function toArray() {
        return array(
            'box' => $this->box->toArray(),
            'tracking_number' => $this->trackingNumber,
            'tracking_url' => $this->trackingUrl,
            'transaction_number' => $this->transactionNumber,
            'error_message' => $this->errorMessage,
            'success_message' => $this->successMessage,
            'documents' => array_map(function($document) {
                /** @var AccompanyingDocument $document */
                return $document->toArray();
            }, $this->documents)
        );
    }

    /**
     * @return OrderedBoxPacked
     */
    public function getBox() {
        return $this->box;
    }

    /**
     * @return null|string
     */
    public function getErrorMessage() {
        return $this->errorMessage;
    }

    /**
     * @return null|string
     */
    public function getSuccessMessage() {
        return $this->successMessage;
    }

    /**
     * @return null|string
     */
    public function getTrackingNumber() {
        return $this->trackingNumber;
    }

    /**
     * @return null|string
     */
    public function getTrackingUrl() {
        return $this->trackingUrl;
    }

    /**
     * @return null|string
     */
    public function getTransactionNumber() {
        return $this->transactionNumber;
    }

    /**
     * @return AccompanyingDocument[]
     */
    public function getDocuments() {
        return $this->documents;
    }

    /**
     * @param int $documentId
     * @return null|AccompanyingDocument
     */
    public function getDocument($documentId) {
        return isset($this->documents[$documentId]) ? $this->documents[$documentId] : null;
    }

    /**
     * @return bool
     */
    public function hasLabel() {
        foreach ($this->documents as $document) {
            if ($document->isLabel()) {
                return true;
            }
        }
        return false;
    }

    /**
     * @return $this
     */
    public function voidLabel() {
        $this->documents = array();
        $this->trackingNumber = null;
        $this->transactionNumber = null;
        $this->trackingUrl = null;
        return $this;
    }

    /**
     * @param string|null $text
     * @return $this
     */
    public function setSuccessMessage($text) {
        $this->successMessage = $text;
        return $this;
    }

    /**
     * @return $this
     */
    public function clearSuccessMessage() {
        return $this->setSuccessMessage(null);
    }

    /**
     * @param string|null $text
     * @return $this
     */
    public function setErrorMessage($text) {
        $this->errorMessage = $text;
        return $this;
    }

    /**
     * @return $this
     */
    public function clearErrorMessage() {
        return $this->setErrorMessage(null);
    }

    /**
     * @param AccompanyingDocument $document
     * @return $this
     */
    public function addDocument($document) {
        $this->documents[] = $document;
        return $this;
    }

    /**
     * @param AccompanyingDocument[] $documents
     * @return $this
     */
    public function setDocuments($documents) {
        $this->documents = $documents;
        return $this;
    }

    /**
     * @param string|null $number
     * @return $this
     */
    public function setTrackingNumber($number) {
        $this->trackingNumber = $number;
        return $this;
    }

    /**
     * @param string|null $number
     * @return $this
     */
    public function setTransactionNumber($number) {
        $this->transactionNumber = $number;
        return $this;
    }

    /**
     * @param OrderedBoxPacked $box
     * @return $this
     */
    public function setBox($box) {
        $this->box = $box;
        return $this;
    }

    /**
     * @param string|null $url
     * @return $this
     */
    public function setTrackingUrl($url) {
        $this->trackingUrl = $url;
        return $this;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Fallback;

class PackagingList {
    /** @var int */
    private $orderId;
    /** @var string */
    private $serviceName;
    /**
     * Module version that created this list
     * @var string
     */
    private $version;
    /**
     * Clean rate ID (not full method code)
     * @var string
     */
    private $methodCode;
    /** @var array */
    private $address;
    /** @var string */
    private $methodName;
    /**
     * Customer choice of last mile selectable options (not all last mile options)
     * @var array
     */
    private $customerChoice = array();
    /** @var Shipment[] */
    private $shipments;

    /**
     * @param array $data
     */
    public function __construct($data) {
        $this->orderId = $data['order_id'];
        $this->serviceName = $data['service_name'];
        $this->version = $data['version'];
        $this->methodCode = isset($data['method_code']) ? $data['method_code'] : null;
        $this->address = isset($data['address']) ? $data['address'] : array();
        $this->methodName = $data['method_name'];
        $this->customerChoice = isset($data['customer_choice']) && is_array($data['customer_choice']) ?
            $data['customer_choice'] : array();
        $this->shipments = $data['shipments'];
    }

    /**
     * @since 15.01.2018 accepts fallback
     * @param array $data
     * @param Fallback $fallback
     * @return PackagingList
     */
    public static function createFromArray($data, $fallback) {
        $data['shipments'] = array_map(function($shipment) use ($fallback) {
            return Shipment::createFromArray($shipment, $fallback);
        }, $data['shipments']);
        return new PackagingList($data);
    }

    /**
     * @return array
     */
    public function toArray() {
        return array(
            'order_id' => $this->orderId,
            'service_name' => $this->serviceName,
            'version' => $this->version,
            'method_code' => $this->methodCode,
            'address' => $this->address,
            'method_name' => $this->methodName,
            'customer_choice' => $this->customerChoice,
            'shipments' => array_map(function($shipment) {
                /** @var Shipment $shipment */
                return $shipment->toArray();
            }, $this->shipments)
        );
    }

    /**
     * @return string
     */
    public function getMethodCode() {
        return $this->methodCode;
    }

    /**
     * @return array
     */
    public function getAddress() {
        return $this->address;
    }

    /**
     * @return string
     */
    public function getMethodName() {
        return $this->methodName;
    }

    /**
     * @return int
     */
    public function getOrderId() {
        return $this->orderId;
    }

    /**
     * @return string
     */
    public function getServiceName() {
        return $this->serviceName;
    }

    /**
     * @return Shipment[]
     */
    public function getShipments() {
        return $this->shipments;
    }

    /**
     * @return string
     */
    public function getVersion() {
        return $this->version;
    }

    /**
     * @return array
     */
    public function getCustomerChoice() {
        return $this->customerChoice;
    }

    /**
     * @param string $key
     * @return null|mixed
     */
    public function getSpecificCustomerOption($key) {
        return isset($this->customerChoice[$key]) ? $this->customerChoice[$key] : null;
    }

    /**
     * Used as comment for admin when attempting to purchase label, no customer notification
     * @return string
     */
    public function getStatusText() {
        $count = count($this->getShipments());
        return implode("\n\n", array_map(function($shipment, $k) use ($count) {
            /** @var Shipment $shipment */
            return 'Box ' . ($k + 1) . ' of ' . $count . ': ' . (
                $shipment->hasLabel() ? 'label purchased' :
                    ($shipment->getErrorMessage() ? 'error' : 'waiting')
            ) . (
                $shipment->getTrackingNumber() ? "\n" . 'Tracking number: ' . $shipment->getTrackingNumber() : ''
            ) . (
                $shipment->getTrackingUrl() ? "\n" . 'Track online: ' . $shipment->getTrackingUrl() : ''
            );
        }, $this->getShipments(), array_keys($this->getShipments())));
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

class ConfigurationException extends \Exception {
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping {

class PackagingException extends \Exception {
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

class ApiException extends \Exception {
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

class ImperialWeight {
    private $pounds;
    private $ounces;

    /**
     * @param float $pounds
     * @param float $ounces
     */
    public function __construct($pounds, $ounces) {
        $this->pounds = $pounds;
        $this->ounces = $ounces;
    }

    /**
     * @return float
     */
    public function getOunces() {
        return $this->ounces;
    }

    /**
     * @return float
     */
    public function getPounds() {
        return $this->pounds;
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

class Time {
    /** Day length is seconds */
    const DayLength = 86400;

    /**
     * Checks that time (in date) passed the specified time (in time)
     * @param int $date
     * @param string|null $time 'HH:MM'
     * @return bool
     * @since 02.04.2020 is boolean method
     */
    public static function isTimePassed($date, $time) {
        if ($time === null) {
            return false;
        }
        if ($date >= strtotime($time . date(' d.m.Y', $date))) {
            return true;
        }
        return false;
    }

    /**
     * Add business days to date
     * @param array $data Options:
     *      date Day to start (int)
     *      days Number of business days (int)
     *      limit Maximum quantity of days to add (int|null)
     *      holidays Holidays to skip in array(M,D) format (array)
     *      skip_saturday Saturdays are business days (bool|int)
     *      skip_sunday Sundays are business days (bool|int)
     * @return int New date
     */
    public static function addBusinessDays($data) {
        $dateFinish = $data['date'] + $data['days'] * self::DayLength;
        $periodStart = $data['date'];
        do {
            $daysOff = self::countDaysOff(
                $periodStart, $dateFinish, $data['holidays'],
                $data['skip_saturday'], $data['skip_sunday']
            );
            if ($daysOff > 0) {
                $periodStart = $dateFinish + self::DayLength;
                $dateFinish += $daysOff * self::DayLength;
            }
        } while ($daysOff > 0);
        if (isset($data['limit'])) {
            if ((($dateFinish - $data['date']) / self::DayLength) > $data['limit']) {
                $dateFinish = $data['date'] + $data['limit'] * self::DayLength;
            }
        }
        return $dateFinish;
    }

    /**
     * Returns quantity of non-business days in period
     * @param int $dateStart
     * @param int $dateFinish
     * @param array $holidays Holidays to include in array(M,D) format
     * @param bool|int $skipSat Saturdays are business days
     * @param bool|int $skipSun Sundays are business days
     * @return int
     */
    public static function countDaysOff($dateStart, $dateFinish, $holidays, $skipSat, $skipSun) {
        $counter = 0;
        for ($day = $dateStart; $day <= $dateFinish; $day += self::DayLength) {
            $weekDay = intval(date('w', $day));
            $dayAsArray = array(intval(date('n', $day)), intval(date('j', $day)));
            if ($weekDay === 6) {
                if (intval($skipSat) === 0) {
                    $counter++;
                    continue;
                }
            }
            if ($weekDay === 0) {
                if (intval($skipSun) === 0) {
                    $counter++;
                    continue;
                }
            }
            if (in_array($dayAsArray, $holidays, true)) {
                $counter++;
                continue;
            }
        }
        return $counter;
    }

    /**
     * @param float $since from microtime(true) call associated with previous request
     * @param int $ratePerMinute number of requests per minute
     * @return float
     */
    public static function waitThrottleLimit($since, $ratePerMinute) {
        $until = $since + 60 / $ratePerMinute;
        while (microtime(true) <= $until) {
            usleep(1);
        }
        return microtime(true);
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

class Length {
    const InchesInFoot = 12;
    const CentimetersInInch = 2.54;
    const CentimetersInMeter = 100;
    const MillimetersInCentimeter = 10;
    const UnitInchShort = '&quot;';
    const UnitInchLong = 'in';
    const UnitCentimeter = 'cm';

    /**
     * Converts centimeters to inches
     * @param float $cm
     * @return float
     */
    public static function convertCentimetersToInches($cm) {
        return $cm / self::CentimetersInInch;
    }

    /**
     * Converts inches to centimeters
     * @param float $in
     * @return float
     */
    public static function convertInchesToCentimeters($in) {
        return $in * self::CentimetersInInch;
    }

    /**
     * Converts inches to meters
     * @param float $in
     * @return float
     */
    public static function convertInchesToMeters($in) {
        return $in * self::CentimetersInInch / self::CentimetersInMeter;
    }

    /**
     * Converts centimeters to millimeters
     * @param float $cm
     * @return float
     */
    public static function convertCentimetersToMillimeters($cm) {
        return $cm * self::MillimetersInCentimeter;
    }

    /**
     * Converts inches to feet
     * @param float $in
     * @return float
     */
    public static function convertInchesToFeet($in) {
        return $in / self::InchesInFoot;
    }

    /**
     * Coverts feet to inches
     * @param float $ft
     * @return float
     */
    public static function convertFeetToInches($ft) {
        return $ft * self::InchesInFoot;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

class Weight {
    /** Average Density of materials (Pounds per square Inch) */
    const HardCartonDensity = 0.00130;
    const SoftCartonDensity = 0.00092;
    const PaperDensity = 0.00022;
    const PlasticDensity = 0.00012;
    const WoodDensity = 0.012;

    /** convertion constants */
    const OuncesInGram = 0.035274;
    const PoundsInKilogram = 2.20462;
    const OuncesInPound = 16;
    const GramsInKilogram = 1000;

    /** unit constants */
    const UnitOunce = 'oz';
    const UnitPound = 'lb';
    const UnitGram = 'g';
    const UnitKilogram = 'Kg';

    /** unit type constants */
    const UnitTypeSmall = 'SMALL';
    const UnitTypeLarge = 'LARGE';

    /**
     * Divide weight to pounds and ounces
     * @param float $weight
     * @return ImperialWeight
     */
    public static function calculateImperialWeight($weight) {
        $pounds = floor($weight);
        $ounces = round(16 * ($weight - $pounds), 2); // max 5 digits
        return new ImperialWeight($pounds, $ounces);
    }

    /**
     * Returns material weight using square and density
     * @param float $square square inch
     * @param float $density One of density constants
     * @return float lb
     */
    public static function ofMaterial($square, $density) {
        return $square * $density;
    }

    /**
     * Converts pounds to ounces
     * @param float $lb lbs
     * @return float oz
     */
    public static function convertPoundsToOunces($lb) {
        return $lb * self::OuncesInPound;
    }

    /**
     * Convert ounces to pounds
     * @param float $oz
     * @return float Weight in pounds
     */
    public static function convertOuncesToPounds($oz) {
        return $oz / self::OuncesInPound;
    }

    /**
     * Convert grams to kilograms
     * @param float $g
     * @return float Weight in kilograms
     */
    public static function convertGramsToKilograms($g) {
        return $g / self::GramsInKilogram;
    }

    /**
     * Convert kilograms to grams
     * @param float $kg
     * @return float Weight in grams
     */
    public static function convertKilogramsToGrams($kg) {
        return $kg * self::GramsInKilogram;
    }

    /**
     * Converts grams to ounces
     * @param float $g
     * @return float
     */
    public static function convertGramsToOunces($g) {
        return $g * self::OuncesInGram;
    }

    /**
     * Converts ounces to grams
     * @param float $oz
     * @return float
     */
    public static function convertOuncesToGrams($oz) {
        return $oz / self::OuncesInGram;
    }

    /**
     * Converts kilograms to pounds
     * @param float $kg
     * @return float
     */
    public static function convertKilogramsToPounds($kg) {
        return $kg * self::PoundsInKilogram;
    }

    /**
     * Converts pounds to kilograms
     * @param float $lb
     * @return float
     */
    public static function convertPoundsToKilograms($lb) {
        return $lb / self::PoundsInKilogram;
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

class Number {
    const Epsilon = 0.00000001;

    /**
     * @param float $a
     * @param float $b
     * @return bool
     */
    public static function floatsAreEqual($a, $b) {
        return abs($a - $b) < self::Epsilon;
    }

    /**
     * Returns adjusted number by fix and percent
     * @param float $number
     * @param float $adjustFix
     * @param float $adjustPercent
     * @return float
     */
    public static function adjust($number, $adjustFix, $adjustPercent) {
        return $adjustFix + ($number * ((100.00 + $adjustPercent) / 100.00));
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

class Square {
    /**
     * Returns square of box surface
     * @param float[3] $dimensions
     * @return float square inch
     */
    public static function ofBoxSurface($dimensions) {
        return 2 * (
            $dimensions[0] * $dimensions[1] +
            $dimensions[0] * $dimensions[2] +
            $dimensions[1] * $dimensions[2]
        );
    }

    /**
     * Returns square of flat object surface (two sides actually)
     * @param float $length
     * @param float $width
     * @return float
     */
    public static function ofFlatSurface($length, $width) {
        return 2 * $length * $width;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

class Arrays {
    private static $spaces = '    ';

    private static function padding($offset) {
        return str_repeat(self::$spaces, $offset);
    }

    /**
     * @param array $array to walk through
     * @param array $keys chain of keys
     * @param null|mixed $default default value
     * @return null|mixed value of found element or default value
     */
    public static function getInDepth($array, $keys, $default = null) {
        if (!is_array($keys)) {
            return $default;
        }
        $tmp = $array;
        foreach ($keys as $key) {
            if (!is_array($tmp)) {
                return $default;
            }
            if (!isset($tmp[$key])) {
                return $default;
            }
            $tmp = $tmp[$key];
        }
        return $tmp;
    }

    /**
     * Just safely gets an element of array
     * @param array $array
     * @param string $key
     * @param null|mixed $default
     * @return null|mixed
     */
    public static function get($array, $key, $default = null) {
        if (!is_array($array)) {
            return $default;
        }
        return isset($array[$key]) ? $array[$key] : $default;
    }

    /**
     * Checks that haystack contains all elements from needle
     * @param array $needle
     * @param array $haystack
     * @return bool
     */
    public static function containsAllOf($needle, $haystack) {
        return count(array_intersect($needle, $haystack)) === count($needle);
    }

    /**
     * Returns array of elements of child arrays
     * @param array $arr
     * @param bool $isPreserveNumericKeys
     * @return array
     */
    public static function flatten($arr, $isPreserveNumericKeys) {
        if ($isPreserveNumericKeys) {
            $function = function ($carry, $subarr) {
                return $subarr + $carry;
            };
        } else {
            $function = 'array_merge';
        }
        return array_reduce($arr, $function, array());
    }

    /**
     * Checks that array does not have numeric keys
     * @param $arr
     * @return bool
     */
    public static function isAssoc($arr) {
        $numericKeysCount = count(array_filter(array_keys($arr), function($key) {
            return is_numeric($key);
        }));
        return !(bool)$numericKeysCount;
    }

    /**
     * Save 2-dimensional array to CSV string
     * @param array $arr
     * @return string
     */
    public static function toCsv($arr) {
        $csv = fopen('php://temp/maxmemory:'. (5 * 1024 * 1024), 'r+');
        foreach ($arr as $k => $row) {
            if ($k === 0) {
                fputcsv($csv, array_keys($row));
            }
            fputcsv($csv, array_values($row));
        }
        rewind($csv);
        $result = stream_get_contents($csv);
        fclose($csv);
        return $result;
    }

    /**
     * Returns more reusable dump of array
     * @param array $arr
     * @param int $offset
     * @return string
     */
    public static function dump($arr, $offset = 0) {
        $result = '';
        if (is_array($arr)) {
            $result .= "array(\n";
            foreach ($arr as $k => $entry) {
                $result .= self::padding($offset + 1) . (is_numeric($k) ? $k : '\'' . $k . '\'') . ' => ' .
                    self::dump($entry, $offset + 1);
            }
            $result .= self::padding($offset) . "),\n";
        } elseif (is_object($arr)) {
            $result .= self::padding($offset) . var_export($arr, true) . ",\n";
        } else {
            $result .= (is_int($arr) || is_float($arr) ? $arr :
                    (is_bool($arr) ? ($arr ? 'true' : 'false') : ('\'' . $arr . '\''))) . ",\n";
        }
        if ($offset === 0) {
            echo '<pre>' . $result . '</pre>';
        } else {
            return $result;
        }
    }

    /**
     * @param array[] $options as [key => [variants...], ...]
     * @return array[] as [[key => variant,...], ...]
     */
    public static function getCombinations($options) {
        if (count($options) === 0) {
            return array();
        }
        $key = current(array_keys($options));
        $a = array_shift($options);
        $c = self::getCombinations($options);
        $r = array();
        foreach ($a as $v) {
            if (count($c) === 0) {
                $r[] = array_combine(array($key), array($v));
            } else {
                foreach ($c as $p) {
                    $r[] = array_merge(array_combine(array($key), array($v)), $p);
                }
            }
        }
        return $r;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureChecker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\BaseValidationProvider;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\Configuration;

class Address {
    const UnitedStates = 'US';
    const Australia = 'AU';
    const Canada = 'CA';
    const Netherlands = 'NL';
    const India = 'IN';
    const PuertoRico = 'PR';
    const Mexico = 'MX';
    private static $armedForcesZones = array('AA', 'AC', 'AE', 'AF', 'AM', 'AP');
    private static $armedForcesCities = array('APO', 'FPO', 'DPO');
    private static $requiredFields = array('country_id', 'zone_id', 'zone_code', 'city', 'address_1',
        'address_2', 'firstname', 'lastname', 'company', 'telephone', 'email');

    /**
     * Get faked address in United States
     * @return array
     */
    public static function inUnitedStates() {
        return array(
            'iso_code_2' => self::UnitedStates,
            'postcode' => '94040'
        );
    }

    public static function inAustralia() {
        return array(
            'iso_code_2' => self::Australia,
            'postcode' => '2000'
        );
    }

    public static function inCanada() {
        return array(
            'iso_code_2' => self::Canada,
            'postcode' => 'M4A1R2'
        );
    }

    public static function inIndia() {
        return array(
            'iso_code_2' => self::India,
            'postcode' => '390005'
        );
    }

    /**
     * Checks that address is in US
     * @param array $address
     * @return bool
     */
    public static function isUnitedStates($address) {
        if (isset($address['iso_code_2'])) {
            return $address['iso_code_2'] === self::UnitedStates;
        }
        return false;
    }

    /**
     * Checks that address is in Mexico
     * @param array $address
     * @return bool
     */
    public static function isMexico($address) {
        if (isset($address['iso_code_2'])) {
            return $address['iso_code_2'] === self::Mexico;
        }
        return false;
    }

    /**
     * Checks that address is in Australia
     * @param array $address
     * @return bool
     */
    public static function isAustralia($address) {
        if (isset($address['iso_code_2'])) {
            return $address['iso_code_2'] === self::Australia;
        }
        return false;
    }

    /**
     * Checks that address is in Canada
     * @param array $address
     * @return bool
     */
    public static function isCanada($address) {
        if (isset($address['iso_code_2'])) {
            return $address['iso_code_2'] === self::Canada;
        }
        return false;
    }

    /**
     * Checks that address is in India
     * @param array $address
     * @return bool
     */
    public static function isIndia($address) {
        if (isset($address['iso_code_2'])) {
            return $address['iso_code_2'] === self::India;
        }
        return false;
    }

    /**
     * Checks that address is in PuertoRico
     * @param array $address
     * @return bool
     */
    public static function isPuertoRico($address) {
        if (isset($address['iso_code_2'])) {
            return $address['iso_code_2'] === self::PuertoRico;
        }
        return false;
    }

    /**
     * Checks that address is in Netherlands
     * @param array $address
     * @return bool
     */
    public static function isNetherlands($address) {
        if (isset($address['iso_code_2'])) {
            return $address['iso_code_2'] === self::Netherlands;
        }
        return false;
    }

    /**
     * Checks that address is US APO/FPO/DPO
     * @param array $address
     * @return bool
     */
    public static function isArmedForces($address) {
        if (self::isUnitedStates($address)) {
            if (isset($address['zone_code']) && isset($address['city'])) {
                if (in_array($address['zone_code'], self::$armedForcesZones, true)) {
                    if (in_array(trim(strtoupper($address['city'])), self::$armedForcesCities, true)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /**
     * Checks that all required address fields are set
     * @since 21.01.2017 tries to fetch telephone and email from session and customer objects (for EasyPost)
     * @param array $address
     * @param object $session
     * @param object $customer
     * @throws ConfigurationException
     * @return array
     */
    public static function fixAddress($address, $session = null, $customer = null) {
        if (!array_key_exists('iso_code_2', $address)) {
            throw new ConfigurationException('Country field must be set');
        }
        if (!$address['iso_code_2']) {
            throw new ConfigurationException('Country field is empty');
        }
        if (!array_key_exists('postcode', $address)) {
            throw new ConfigurationException('Postcode field must be set');
        }
        if (!$address['postcode']) {
            throw new ConfigurationException('Postcode is empty');
        }
        foreach (self::$requiredFields as $fld) {
            if (!array_key_exists($fld, $address)) {
                $address[$fld] = null;
            }
        }
        if ($address['telephone'] === null && $session) {
            if (CoreFeatureChecker::hasProperty($session, 'data')) {
                if (is_array($session->data)) {
                    if (isset($session->data['guest'])) {
                        if (isset($session->data['guest']['telephone'])) {
                            $address['telephone'] = $session->data['guest']['telephone'];
                        }
                    }
                }
            }
        }
        if ($address['telephone'] === null && $customer) {
            if (CoreFeatureChecker::hasMethod($customer, 'getTelephone')) {
                $address['telephone'] = $customer->getTelephone();
            }
        }
        if ($address['email'] === null && $session) {
            if (CoreFeatureChecker::hasProperty($session, 'data')) {
                if (is_array($session->data)) {
                    if (isset($session->data['guest'])) {
                        if (isset($session->data['guest']['email'])) {
                            $address['email'] = $session->data['guest']['email'];
                        }
                    }
                }
            }
        }
        if ($address['email'] === null && $customer) {
            if (CoreFeatureChecker::hasMethod($customer, 'getEmail')) {
                $address['email'] = $customer->getEmail();
            }
        }
        return $address;
    }

    /**
     * Checks that address is residential. Returns null when unknown
     * @param array $address
     * @param Configuration $configuration
     * @param BaseValidationProvider $validationProvider
     * @return bool|null
     */
    public static function isAddressResidential($address, $configuration, $validationProvider) {
        $default = isset($address['company']) ? !(bool)$address['company'] : true;
        switch ($configuration->get('recipient_address_type')) {
            case Configuration::RecipientAddressTypeResidential:
                return true;
            case Configuration::RecipientAddressTypeCommercial:
                return false;
            case Configuration::RecipientAddressTypeValidated:
                $result = null;
                if ($validationProvider) {
                    $result = $validationProvider->isAddressResidential($address);
                    if ($result !== null) {
                        return $result;
                    }
                }
                return $default;
            case Configuration::RecipientAddressTypeDependsOnCompany:
            default:
                return $default;
        }
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ApiException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Json;

if (!function_exists('json_last_error_msg')) {
    function json_last_error_msg() { // @codingStandardsIgnoreLine
        static $errors = array(
            JSON_ERROR_NONE => 'No error',
            JSON_ERROR_DEPTH => 'Maximum stack depth exceeded',
            JSON_ERROR_STATE_MISMATCH => 'State mismatch (invalid or malformed JSON)',
            JSON_ERROR_CTRL_CHAR => 'Control character error, possibly incorrectly encoded',
            JSON_ERROR_SYNTAX => 'Syntax error',
            JSON_ERROR_UTF8 => 'Malformed UTF-8 characters, possibly incorrectly encoded'
        );
        $code = json_last_error();
        return isset($errors[$code]) ? $errors[$code] : 'Unknown error';
    }
}

class Response {
    const ErrorEmpty = 'Error fetching data from API';
    const ErrorInvalid = 'Invalid API response';

    /**
     * @param string $response
     * @throws ApiException
     * @return \DOMDocument
     */
    public static function fromXml($response) {
        if (!$response) {
            throw new ApiException(self::ErrorEmpty);
        }
        $dom = new \DOMDocument('1.0', 'UTF-8');
        try {
            $dom->loadXml($response);
        } catch (\Exception $error) {
            throw new ApiException(self::ErrorInvalid);
        }
        return $dom;
    }

    /**
     * @param string $response
     * @throws ApiException
     * @return array|null
     */
    public static function fromJson($response) {
        if (!$response) {
            throw new ApiException(self::ErrorEmpty);
        }
        $json = Json::decodeAsArray($response);
        if (!$json) {
            throw new ApiException(self::ErrorInvalid . ': ' . json_last_error_msg());
        }
        return $json;
    }


}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureChecker;

class Shell {

    /**
     * Argument 0 - command
     * Other - arguments
     * @return string Output
     * @throws ConfigurationException
     */
    public static function exec() {
        if (!CoreFeatureChecker::isFunctionEnabled('exec')) {
            throw new ConfigurationException('exec() function is not enabled');
        }
        $args = func_get_args();
        $cmd = array_shift($args);
        $args = array_map('escapeshellarg', $args);
        $finalCmd = $cmd . ' ' . implode(' ', $args);
        exec($finalCmd . ' 2>&1', $output, $err);
        $output = implode("\n", $output);
        if ($err) {
            throw new ConfigurationException('Error while executing command' . "\n" . $finalCmd . "\n" . $output);
        }
        return $output;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\ConfigurationException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureChecker;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureException;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Shell;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\AccompanyingDocument;

class Label {
    /**
     * @param string $data
     * @param array $position
     * @throws ConfigurationException
     * @throws CoreFeatureException
     * @return string
     */
    public static function make4x6FromPdfImagick($data, $position) {
        if (!CoreFeatureChecker::isImageMagickInstalled()) {
            throw new CoreFeatureException('ImageMagick is not installed on your server.');
        }
        if (!CoreFeatureChecker::isGhostscriptInstalled()) {
            throw new CoreFeatureException('Ghostscript is not installed on your server.');
        }
        $imagick = new \Imagick();
        $resolution = $position['resolution'];
        $imagick->setResolution($resolution, $resolution);
        if ($imagick->readImageBlob($data)) {
            $imagick->setIteratorIndex(0);
            $size = $imagick->getImageGeometry();
            $imagick->cropImage(
                $size['width'], $position['height'] * $resolution,
                $position['left'] * $resolution, $position['top'] * $resolution
            );
            $imagick->setImagePage(0, 0, 0, 0);
            $imagick->trimImage(0.3);
            $imagick->setImagePage(0, 0, 0, 0);
            $imagick->rotateImage(new \ImagickPixel('#FFF'), $position['rotate']);
            $size = $imagick->getImageGeometry();
            if (($size['width'] < 4 * $resolution) && ($size['height'] < 6 * $resolution)) {
                $imagick->resizeImage(4 * $resolution, 6 * $resolution, \Imagick::FILTER_POINT, 0, true);
            } else {
                $imagick->cropImage(
                    4 * $resolution, 6 * $resolution,
                    max(0, ($size['width'] - 4 * $resolution) / 2),
                    max(0, ($size['height'] - 6 * $resolution) / 2)
                );
            }
            $imagick->setImageFormat('png');
            $data = $imagick->getImageBlob();
            $imagick->clear();
            unset($imagick);
            return $data;
        }
        throw new ConfigurationException('Can not read label data');
    }

    /**
     * @param $data
     * @param $position
     * @throws ConfigurationException
     * @throws CoreFeatureException
     * @return string
     */
    public static function make4x6FromPdfGmagick($data, $position) {
        if (!CoreFeatureChecker::isGraphicsMagickInstalled()) {
            throw new CoreFeatureException('GraphicsMagick is not installed on your server.');
        }
        if (!CoreFeatureChecker::isGhostscriptInstalled()) {
            throw new CoreFeatureException('Ghostscript is not installed on your server.');
        }
        $resolution = $position['resolution'];
        $pdfFile = tempnam(sys_get_temp_dir(), 'label-');
        $pngFile = $pdfFile . '.png';
        $pdfHandler = fopen($pdfFile, 'w');
        fwrite($pdfHandler, $data);
        fclose($pdfHandler);
        Shell::exec('gm', 'convert', '-density', $resolution . 'x' . $resolution, $pdfFile . '[0]', $pngFile);
        unlink($pdfFile);
        $size = self::gmagickGetPngSize($pngFile);
        Shell::exec('gm', 'convert', $pngFile,
            '-crop', $size['width'] . 'x' . $position['height'] * $resolution . '+' . $position['left'] * $resolution .
            '+' . $position['top'] * $resolution,
            '-fuzz', '3%', '-trim',
            '-rotate', $position['rotate'], $pngFile
        );
        $size = self::gmagickGetPngSize($pngFile);
        if (($size['width'] < 4 * $resolution) && ($size['height'] < 6 * $resolution)) {
            Shell::exec('gm', 'convert', $pngFile,
                '-resize', 4 * $resolution . 'x' . 6 * $resolution, $pngFile);
        } else {
            Shell::exec('gm', 'convert', $pngFile,
                '-crop', 4 * $resolution . 'x' . 6 * $resolution . '+' .
                max(0, ($size['width'] - 4 * $resolution) / 2) . '+' . max(0, ($size['height'] - 6 * $resolution) / 2),
                $pngFile
            );
        }
        $result = file_get_contents($pngFile);
        unlink($pngFile);
        return $result;
    }

    /**
     * @param string $data
     * @param array $position
     * @throws ConfigurationException
     * @throws CoreFeatureException
     * @return string
     */
    public static function make4x6FromPng($data, $position) {
        if (!CoreFeatureChecker::isGdInstalled()) {
            throw new CoreFeatureException('GD is not installed on your server.');
        }
        if ($image = imagecreatefromstring($data)) {
            $resolution = $position['resolution'];
            $width = $position['rotate'] ? round(6 * $position['height'] * $resolution / 4) :
                round(4 * $position['height'] * $resolution / 6);
            $image = self::imageCrop(
                $image, $position['left'] * $resolution, $position['top'] * $resolution,
                $width, round($position['height'] * $resolution)
            );
            $image = imagerotate($image, -$position['rotate'], imagecolorallocate($image, 255, 255, 255));
            return self::imagePng($image);
        }
        throw new ConfigurationException('Can not read label data');
    }

    /**
     * @param AccompanyingDocument[] $labels
     * @return string merged pdf, binary
     * @throws CoreFeatureException
     */
    public static function merge($labels) {
        $tempFiles = array();
        foreach ($labels as $document) {
            for ($i = 0; $i < $document->getNumberOfPages(); $i++) {
                $isConversionRequired = $document->getFormat() !== AccompanyingDocument::FormatPDF;
                $filename = tempnam(sys_get_temp_dir(), 'label-');
                $handle = fopen($filename, 'w');
                $data = base64_decode($document->getPage($i));
                if ($isConversionRequired && CoreFeatureChecker::isImageMagickInstalled()) {
                    // pre-conversion to pdf using ImageMagick
                    $imagick = new \Imagick();
                    $imagick->readImageBlob($data);
                    $imagick->setFormat('pdf');
                    $data = $imagick->getImageBlob();
                    $isConversionRequired = false;
                }
                fwrite($handle, $data);
                fclose($handle);
                if ($isConversionRequired) {
                    if (CoreFeatureChecker::isGraphicsMagickInstalled()) {
                        // post-conversion to pdf using GraphicsMagick
                        Shell::exec('gm', 'convert', $document->getExtension() . ':' . $filename, 'pdf:' . $filename);
                    } else {
                        throw new CoreFeatureException('Can not find ImageMagick or GraphicsMagick');
                    }
                }
                $tempFiles[] = $filename;
            }
        }
        $outputName = tempnam(sys_get_temp_dir(), 'merged-'); // merging using ghostscript
        $cmd = 'gs -q -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -sOutputFile=' . $outputName . ' ' . implode(' ', $tempFiles);
        shell_exec($cmd);
        array_map('unlink', $tempFiles);
        $result = file_get_contents($outputName);
        unlink($outputName);
        return $result;
    }

    /**
     * @param resource $image
     * @param int $x
     * @param int $y
     * @param int $width
     * @param int $height
     * @return resource
     */
    private static function imageCrop($image, $x, $y, $width, $height) {
        $newImage = imagecreatetruecolor($width, $height);
        imagecopyresampled($newImage, $image, 0, 0, $x, $y, $width, $height, $width, $height);
        imagedestroy($image);
        return $newImage;
    }

    /**
     * @param resource $image
     * @return string
     */
    private static function imagePng(&$image) {
        ob_start();
        imagepng($image);
        $data = ob_get_contents();
        ob_end_clean();
        imagedestroy($image);
        return $data;
    }

    private static function gmagickGetPngSize($filename) {
        $output = Shell::exec('gm', 'identify', $filename);
        if (!preg_match('/\w+\.png PNG (\d+)x(\d+).*/', $output, $matches)) {
            throw new ConfigurationException('Can not parse PNG size: ' . $output);
        }
        return array(
            'width' => $matches[1],
            'height' => $matches[2]
        );
    }

}
}


/**
 * Carton texture: https://pixnio.com/textures-and-patterns/paper-texure/cardboard-carton-paper-texture
 * License: Public Domain CC0
 * Author: PPD
 */

namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\PackagingMap\Reserved;

class Scene {
    const ZFightOffset = 0.1;
    const Spacing = 0.1;
    const CameraDistance = 1.2;
    const ColorMin = 150;
    const ColorMax = 220;
    const BackgroundColor = 11184810;
    private static $zeroMatrix = array(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);

    /**
     * @return int
     */
    private static function getRandomColor() {
        return array_sum(array(
            mt_rand(self::ColorMin, self::ColorMax) * 256 * 256,
            mt_rand(self::ColorMin, self::ColorMax) * 256,
            mt_rand(self::ColorMin, self::ColorMax)
        ));
    }

    /**
     * @param float $boxLength
     * @param float $boxWidth
     * @param float $boxHeight
     * @param Reserved $reserved
     * @return array Matrix
     */
    private static function calculateRelativePosition($boxLength, $boxWidth, $boxHeight, $reserved) {
        return array(
            1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0,
            $reserved->getOffsetLength() - $boxLength / 2 + $reserved->getLength() / 2,
            $reserved->getOffsetHeight() - $boxHeight / 2 + $reserved->getHeight() / 2,
            $reserved->getOffsetWidth() - $boxWidth / 2 + $reserved->getWidth() / 2,
            1
        );
    }

    /**
     * @param int $id
     * @param float $x
     * @param float $y
     * @param float $z
     * @return array Structure
     */
    private static function generateSpotlight($id, $x, $y, $z) {
        return array(
            'uuid' => 'Light' . $id,
            'type' => 'PointLight',
            'name' => 'PointLight ' . $id,
            'matrix' => array(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, $x, $y, $z, 1),
            'color' => 0xFFFFC2,
            'intensity' => 0.6,
            'distance' => 0,
            'decay' => 1,
            'shadow' => array(
                'camera' => array(
                    'uuid' => 'LightDirection' . $id,
                    'type' => 'PerspectiveCamera',
                    'fov' => 90,
                    'zoom' => 1,
                    'near' => 0.5,
                    'far' => 500,
                    'focus' => 10,
                    'aspect' => 1,
                    'filmGauge' => 35,
                    'filmOffset' => 0
                )
            )
        );
    }

    /**
     * @param float $boxLength
     * @param float $boxWidth
     * @param float $boxHeight
     * @param Reserved[] $reservedSpace
     * @param $cartonTexture
     * @return string JSON
     */
    public static function generate($boxLength, $boxWidth, $boxHeight, $reservedSpace, $cartonTexture) {
        $spotlightPosition = max($boxLength, $boxWidth, $boxHeight);
        $cameraPosition = max($boxLength, $boxWidth, $boxHeight) * self::CameraDistance;
        $geometries = array(
            array(
                'uuid' => 'BoxGeometry',
                'type' => 'BoxBufferGeometry',
                'width' => $boxLength + self::ZFightOffset,
                'height' => $boxHeight + self::ZFightOffset,
                'depth' => $boxWidth + self::ZFightOffset,
                'widthSegments' => 0,
                'heightSegments' => 0,
                'depthSegments' => 0
            )
        );
        foreach ($reservedSpace as $k => $reserved) {
            /** @var Reserved $reserved */
            $geometries[] = array(
                'uuid' => 'ProductGeometry' . $k,
                'type' => 'BoxBufferGeometry',
                'width' => max(self::Spacing, $reserved->getLength() - self::Spacing),
                'height' => max(self::Spacing, $reserved->getHeight() - self::Spacing),
                'depth' => max(self::Spacing, $reserved->getWidth() - self::Spacing),
                'widthSegments' => 0,
                'heightSegments' => 0,
                'depthSegments' => 0
            );
        }
        $materials = array(
            array(
                'uuid' => 'BoxMaterial',
                'type' => 'MeshPhongMaterial',
                'color' => 9591811,
                'emissive' => 0,
                'specular' => 1118481,
                'shininess' => 30,
                'opacity' => 0.45,
                'transparent' => true,
                'depthFunc' => 3,
                'depthTest' => true,
                'depthWrite' => true,
                'skinning' => false,
                'morphTargets' => false,
                'dithering' => false,
                'map' => 'CartonTexture'
            )
        );
        $textures = array(
            array(
                'uuid' => 'CartonTexture',
                'name' => '',
                'mapping' => 300,
                'repeat' => array(1, 1),
                'offset' => array(0, 0),
                'center' => array(0, 0),
                'rotation' => 0,
                'wrap' => array(1001, 1001),
                'format' => 1022,
                'minFilter' => 1008,
                'magFilter' => 1006,
                'anisotropy' => 1,
                'flipY' => true,
                'image' => 'CartonImage'
            )
        );
        $images = array(
            array(
                'uuid' => 'CartonImage',
                'url' => 'data:image/png;base64,' . $cartonTexture
            )
        );
        foreach ($reservedSpace as $k => $reserved) {
            $materials[] = array(
                'uuid' => 'ProductMaterial' . $k,
                'type' => 'MeshPhongMaterial',
                'color' => self::getRandomColor(),
                'emissive' => 0,
                'specular' => 1118481,
                'shininess' => 30,
                'depthFunc' => 3,
                'depthTest' => true,
                'depthWrite' => true,
                'skinning' => false,
                'morphTargets' => false,
                'dithering' => false
            );
        }
        $products = array();
        foreach ($reservedSpace as $k => $reserved) {
            $products[] = array(
                'uuid' => 'Product' . $k,
                'type' => 'Mesh',
                'name' => 'Product',
                'matrix' => self::calculateRelativePosition($boxLength, $boxWidth, $boxHeight, $reserved),
                'geometry' => 'ProductGeometry' . $k,
                'material' => 'ProductMaterial' . $k,
                'userData' => array(
                    'description' => $reserved->getDescription(),
                )
            );
        }
        $result = array(
            'metadata' => array('type' => 'App'),
            'project' => array(
                'gammaInput' => false,
                'gammaOutput' => false,
                'shadows' => true,
                'vr' => false
            ),
            'camera' => array(
                'metadata' => array(
                    'version' => 4.5,
                    'type' => 'Object',
                    'generator' => 'Object3D.toJSON'
                ),
                'object' => array(
                    'uuid' => 'InitialCamera',
                    'type' => 'PerspectiveCamera',
                    'name' => 'Camera',
                    'matrix' => array(0.167786, 0, -0.985823, 0, -0.476808, 0.875253, -0.081152, 0, 0.862845, 0.483665,
                        0.146855, 0, $cameraPosition, $cameraPosition, $cameraPosition, 1),
                    'fov' => 50,
                    'zoom' => 1,
                    'near' => 0.1,
                    'far' => 10000,
                    'focus' => 10,
                    'aspect' => 1.616482,
                    'filmGauge' => 35,
                    'filmOffset' => 0
                )
            ),
            'scene' => array(
                'metadata' => array(
                    'version' => 4.5,
                    'type' => 'Object',
                    'generator' => 'Object3D.toJSON'
                ),
                'geometries' => $geometries,
                'materials' => $materials,
                'textures' => $textures,
                'images' => $images,
                'object' => array(
                    'uuid' => 'Scene',
                    'type' => 'Scene',
                    'name' => 'Scene',
                    'matrix' => self::$zeroMatrix,
                    'children' => array(
                        array(
                            'uuid' => 'Box',
                            'type' => 'Mesh',
                            'name' => 'Box',
                            'matrix' => self::$zeroMatrix,
                            'geometry' => 'BoxGeometry',
                            'material' => 'BoxMaterial',
                            'children' => $products
                        ),
                        self::generateSpotlight(3, -$spotlightPosition, $spotlightPosition, $spotlightPosition),
                        self::generateSpotlight(4, $spotlightPosition, $spotlightPosition, $spotlightPosition),
                        self::generateSpotlight(5, $spotlightPosition, $spotlightPosition, -$spotlightPosition),
                        self::generateSpotlight(6, -$spotlightPosition, $spotlightPosition, -$spotlightPosition)
                    ),
                    'background' => self::BackgroundColor
                )
            )
        );
        return Json::encode($result);
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\CoreFeatureException;

class CurrencyConverter {
    /** @var callable */
    private $converter;
    /** @var object */
    private $config;
    /** @var string[] */
    private static $nationalCurrencies = array(
        Address::UnitedStates => 'USD',
        Address::Canada => 'CAD',
        Address::India => 'INR'
    );
    const DefaultFallbackCurrency = 'USD';

    /**
     * @param callable $converter
     * @param object $config
     * @throws CoreFeatureException
     */
    public function __construct($converter, $config) {
        if (!is_callable($converter)) {
            throw new CoreFeatureException('Invalid converter');
        }
        $this->converter = $converter;
        if (!method_exists($config, 'get')) {
            throw new CoreFeatureException('Invalid config');
        }
        $this->config = $config;
    }

    /**
     * Returns national currency ISO code 3 by country ISO code 2
     * @param string $countryCode ISO CODE 2
     * @param string $fallbackCurrency ISO CODE 3
     * @return string ISO CODE 3
     */
    public static function getNationalCurrency($countryCode, $fallbackCurrency = self::DefaultFallbackCurrency) {
        if (isset(self::$nationalCurrencies[$countryCode])) {
            return self::$nationalCurrencies[$countryCode];
        }
        return $fallbackCurrency;
    }

    /**
     * @return string
     */
    public function getSystemCurrency() {
        return $this->config->get('config_currency');
    }

    /**
     * @param float $value
     * @param string $fromCurrency
     * @return float
     */
    public function toSystem($value, $fromCurrency) {
        return call_user_func($this->converter, $value, $fromCurrency, $this->getSystemCurrency());
    }

    /**
     * @param float $value
     * @param string $toCurrency
     * @return float
     */
    public function fromSystem($value, $toCurrency) {
        return call_user_func($this->converter, $value, $this->getSystemCurrency(), $toCurrency);
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Utils {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\VersionChecker;

/**
 * OpenCart 3 has 65KB session size limit. This class compresses packaging data from shipping rates
 * in order to fit the session.
 *
 * Why is it implemented in this specific way:
 * 1. `serialize` is safer and more compact way to serialize any PHP data.
 * 2. gzip is a built-in PHP compression function. But it should also be enabled during the build process.
 *    The output of gzip is a piece of binary data. OpenCart uses `json_encode` on session data
 *    before storing it. `json_encode` fails for a number of characters (broken unicode sequences).
 * 3. `base64` is used due to the reasons described above. We need to turn binary data into a more
 *    "transmittable" base64 format so that `json_encode` doesn't fail.
 *
 * TODO: This is yet a hack and a proper solution is required.
 */
class PackagingData {
    /**
     * Encodes packaging data for session storage purposes.
     *
     * @param $packagingData array
     * @return mixed
     */
    public static function encode($packagingData) {
        if (!self::shouldCompressData()) {
            return $packagingData;
        }
        return base64_encode(gzcompress(serialize($packagingData)));
    }

    /**
     * Decodes packaging data from session.
     *
     * @param $serializedPackagingData mixed
     * @return array
     */
    public static function decode($serializedPackagingData) {
        if (!self::shouldCompressData()) {
            return $serializedPackagingData;
        }
        return unserialize(gzuncompress(base64_decode($serializedPackagingData)));
    }

    /**
     * We should not compress data if zlib is not enabled or OC version is below 3.
     *
     * @return bool
     */
    protected static function shouldCompressData() {
        return (
            function_exists('gzcompress') &&
            !VersionChecker::get()->isVersion1() &&
            !VersionChecker::get()->isVersion2()
        );
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Controls {

class Select {
    private $nameKey;
    private $sourceKey;
    private $valueField = 'value';
    private $captionField = 'text';
    private $cssClass;
    private $multiple = false;

    /**
     * @return Select
     */
    public static function create() {
        return new self();
    }

    private function __construct() {
    }

    /**
     * @return mixed
     */
    public function getCaptionField() {
        return $this->captionField;
    }

    /**
     * @param mixed $captionField
     * @return $this
     */
    public function setCaptionField($captionField) {
        $this->captionField = $captionField;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getSourceKey() {
        return $this->sourceKey;
    }

    /**
     * @param mixed $sourceKey
     * @return $this
     */
    public function setSourceKey($sourceKey) {
        $this->sourceKey = $sourceKey;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getNameKey() {
        return $this->nameKey;
    }

    /**
     * @param mixed $nameKey
     * @return $this
     */
    public function setNameKey($nameKey) {
        $this->nameKey = $nameKey;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getValueField() {
        return $this->valueField;
    }

    /**
     * @param mixed $valueField
     * @return $this
     */
    public function setValueField($valueField) {
        $this->valueField = $valueField;
        return $this;
    }

    /**
     * @return string
     */
    public function getCssClass() {
        return $this->cssClass;
    }

    /**
     * @param string $cssClass
     * @return $this
     */
    public function setCssClass($cssClass) {
        $this->cssClass = $cssClass;
        return $this;
    }

    /**
     * @param bool $multiple
     * @return $this
     */
    public function setMultiple($multiple) {
        $this->multiple = $multiple;
        return $this;
    }

    /**
     * @return bool
     */
    public function getMultiple() {
        return $this->multiple;
    }
}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible\Controls {

class Input {
    private $nameKey;
    private $isChecked = null;
    private $isDisabled = null;
    private $caption;
    private $cssClass;
    private $addons = array('left' => null, 'right' => null);
    /** @var callable */
    private $prerender;

    /**
     * @return Input
     */
    public static function create() {
        return new self();
    }

    private function __construct() {
    }

    /**
     * @return bool|null
     */
    public function getIsChecked() {
        return $this->isChecked;
    }

    /**
     * @param bool $isChecked
     * @return $this
     */
    public function setIsChecked($isChecked) {
        $this->isChecked = (bool)$isChecked;
        return $this;
    }

    /**
     * @return string
     */
    public function getNameKey() {
        return $this->nameKey;
    }

    /**
     * @param string $nameKey
     * @return $this
     */
    public function setNameKey($nameKey) {
        $this->nameKey = $nameKey;
        return $this;
    }

    /**
     * @return string
     */
    public function getCaption() {
        return $this->caption;
    }

    /**
     * @param string $caption
     * @return $this
     */
    public function setCaption($caption) {
        $this->caption = $caption;
        return $this;
    }

    /**
     * @return string
     */
    public function getCssClass() {
        return $this->cssClass;
    }

    /**
     * @param string $cssClass
     * @return $this
     */
    public function setCssClass($cssClass) {
        $this->cssClass = $cssClass;
        return $this;
    }

    /**
     * @return array
     */
    public function getAddons() {
        return $this->addons;
    }

    /**
     * @param string $left
     * @param string $right
     * @return $this
     */
    public function setAddons($left, $right) {
        $this->addons = array('left' => $left, 'right' => $right);
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getIsDisabled() {
        return $this->isDisabled;
    }

    /**
     * @param bool $isDisabled
     * @return $this
     */
    public function setIsDisabled($isDisabled) {
        $this->isDisabled = (bool)$isDisabled;
        return $this;
    }

    /**
     * @return callable
     */
    public function getPrerender() {
        return $this->prerender;
    }

    /**
     * @param callable $prerender
     * @return $this
     */
    public function setPrerender($prerender) {
        $this->prerender = $prerender;
        return $this;
    }


}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\Configuration;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\Features;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\ShippingModule;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Address;

class CanadapostModule extends ShippingModule {

    /**
     * @return CanadapostRatesProvider
     */
    public function getRatesProvider() {
        return new CanadapostRatesProvider();
    }

    /**
     * @return CanadapostLabelsProvider
     */
    public function getLabelsProvider() {
        return new CanadapostLabelsProvider();
    }

    /**
     * @return null
     */
    public function getValidationProvider() {
        return null;
    }

    /**
     * @return null
     */
    public function getPaperlessProvider() {
        return null;
    }

    /**
     * @return null
     */
    public function getVqmod() {
        return \CanadapostSmartFlexibleVqmod::get();
    }

    /** Extension Name */
    const Name = 'canadapost_smart_flexible';

    /**
     * @return string
     */
    public function getExtensionName() {
        return self::Name;
    }

    /**
     * @return string
     */
    public function getServiceName() {
        return 'Canada Post';
    }

    /**
     * Enabled features array
     * @var array
     */
    private static $features = array(
        Features::AuthPassword,
        Features::AuthCustomerNumber,
        Features::AuthContractId,
        Features::StandardPackages,
        Features::CustomPackages,
        Features::ProductionMode,
        Features::Insurance,
        Features::PackerWeightBased,
        Features::WeightBasedFakedBox,
        Features::FakedBoxRequiredForNonContractLabels,
        Features::OriginZip6Alphanumeric,
        Features::PromoCode,
        Features::ShippingLabel,
        Features::ShippingLabel4x6Inches,
        Features::ShippingLabelRequiresCustomerNumber,
        Features::ShippingLabelVoid,
        Features::Signature,
        Features::SignatureWithProofOfAge,
        Features::ProofOfAge18,
        Features::ProofOfAge19
    );

    /**
     * Metric system is default for Canada Post module
     * @return array
     */
    public function getDefaultSettings() {
        $baseSettings = parent::getDefaultSettings();
        $baseSettings['measurement_system'] = Configuration::MetricMeasures;
        return $baseSettings;
    }

    /**
     * @param string $feature
     * @return bool
     */
    public function hasFeature($feature) {
        return in_array($feature, self::$features, true);
    }

    /**
     * @param string $originCountryCode
     * @return bool
     */
    public function isCountryRequiresZone($originCountryCode) {
        return $originCountryCode === Address::Canada;
    }


    /**
     * This method replaces default currency with CAD
     * @param string $originCountryCode
     * @return string
     */
    public function getValueCurrencyCode($originCountryCode) {
        return 'CAD';
    }

}
}

namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

class MultiRequestHandler {
    /** @var int|string */
    private $id;
    /** @var resource */
    private $resource;
    /** @var string */
    private $hash;

    /**
     * MultiRequestHandler constructor.
     * @param int|string $id
     * @param resource $resource
     * @param string $hash
     */
    public function __construct($id, $resource, $hash) {
        $this->id = $id;
        $this->resource = $resource;
        $this->hash = $hash;
    }

    /**
     * @return int|string
     */
    public function getId() {
        return $this->id;
    }

    /**
     * @return resource
     */
    public function getResource() {
        return $this->resource;
    }

    /**
     * @return string
     */
    public function getHash() {
        return $this->hash;
    }
}

class MultiRequest {
    const MaxRetry = 5;
    /** @var resource */
    private $multiResource;
    /** @var MultiRequestHandler[] */
    private $handlers = array();
    /** @var array[] key - hash, value - array of handlers ids */
    private $sameRequests = array();
    /** @var string[] */
    private $results = array();
    /** @var bool */
    private $shouldRetryOnEmpty;
    /** @var int */
    private $depth = 0;

    public function __construct($shouldRetryOnEmpty = false) {
        $this->multiResource = curl_multi_init();
        $this->shouldRetryOnEmpty = $shouldRetryOnEmpty;
    }

    /**
     * @param int $depth
     */
    protected function setDepth($depth) {
        $this->depth = $depth;
    }

    /**
     * @param int|string $id
     * @param resource $resource
     * @param string $hash of request, in order to detect same requests
     */
    public function addHandler($id, $resource, $hash) {
        if (isset($this->sameRequests[$hash])) {
            array_push($this->sameRequests[$hash], $id); // reduce the number of requests in fact
        } else {
            array_push($this->handlers, new MultiRequestHandler($id, $resource, $hash));
            $this->sameRequests[$hash] = array($id); // first is prototype
            curl_multi_add_handle($this->multiResource, $resource);
        }
    }

    /**
     * Used to add previously cached result instead of actual request
     * @param int|string $id
     * @param string $result
     */
    public function addCachedResult($id, $result) {
        $this->results[$id] = $result;
    }

    /**
     * Returns an array of results preserving ids of requests
     * @return string[]
     */
    public function execute() {
        $running = null;
        do {
            curl_multi_exec($this->multiResource, $running);
            curl_multi_select($this->multiResource);
        } while ($running);
        $failIds = array();
        foreach ($this->handlers as $handler) {
            $this->results[$handler->getId()] = curl_multi_getcontent($handler->getResource());
            if (!$this->results[$handler->getId()]) {
                $failIds[] = $handler->getId();
            }
            curl_multi_remove_handle($this->multiResource, $handler->getResource());
        };
        curl_multi_close($this->multiResource);
        if (count($failIds) && $this->shouldRetryOnEmpty && $this->depth < self::MaxRetry) {
            $retry = new self($this->shouldRetryOnEmpty);
            $retry->setDepth($this->depth + 1);
            foreach ($failIds as $id) {
                $retry->addHandler(
                    $id,
                    curl_copy_handle($this->handlers[$id]->getResource()),
                    $this->handlers[$id]->getHash()
                );
            }
            $subResults = $retry->execute();
            $this->results = $subResults + $this->results;
        }
        foreach ($this->sameRequests as $sameRequestsIds) {
            if (count($sameRequestsIds) > 1) {
                $protoId = array_shift($sameRequestsIds); // first element is prototype
                foreach ($sameRequestsIds as $copyId) {
                    $this->results[$copyId] = $this->results[$protoId];
                }
            }
        }
        return $this->results;
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginEnvelope;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Origin\OriginPackage;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerResult;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Packer\PackerResultBox;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\Debugger;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\BaseRatesProvider;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\Rate;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Length;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Address;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Time;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Response;

class CanadapostRatesProvider extends BaseRatesProvider {
    const ApiDeveloperHost = 'https://ct.soa-gw.canadapost.ca/rs/ship/price';
    const ApiProductionHost = 'https://soa-gw.canadapost.ca/rs/ship/price';
    const MaxProcessingDays = 14;
    const MaxBoxWeight = 66; // https://www.canadapost.ca/tools/pg/prices/SBParcels-e.pdf
    const GeneralMethodGroup = 'general';
    const CurrencyCode = 'CAD';
    const MaxPackageInsuranceValue = 1000;
    const ThrottleLimit = 60;
    private $_lastRequestTime = 0;

    /**
     * @return int
     */
    public function getMaxProcessingDays() {
        return self::MaxProcessingDays;
    }

    /**
     * @param array $address
     * @return float
     */
    public function getPackageMaxWeight($address) {
        return self::MaxBoxWeight;
    }

    /**
     * @param array $address
     * @return float in CAD
     */
    public function getPackageMaxInsuranceValue($address) {
        return self::MaxPackageInsuranceValue;
    }

    private static $methodCodes = array(
        'domestic' => array(
            self::GeneralMethodGroup => array('DOM.RP', 'DOM.EP', 'DOM.PC', 'DOM.DT', 'DOM.LIB'),
            'xpress' => array('DOM.XP', 'DOM.XP.CERT')
        ),
        'usa' => array(
            self::GeneralMethodGroup => array('USA.EP', 'USA.SP.AIR', 'USA.XP'),
            'priority' => array('USA.PW.ENV', 'USA.PW.PAK', 'USA.PW.PARCEL'),
            'tracked' => array('USA.TP', 'USA.TP.LVM')
        ),
        'international' => array(
            self::GeneralMethodGroup => array('INT.XP', 'INT.TP'),
            'parcel' => array('INT.IP.AIR', 'INT.IP.SURF'),
            'priority' => array('INT.PW.ENV', 'INT.PW.PAK', 'INT.PW.PARCEL'),
            'smallpacket' => array('INT.SP.AIR', 'INT.SP.SURF')
        )
    );

    /**
     * @return array
     */
    public static function getMethodCodes() {
        return self::$methodCodes;
    }

    /**
     * @return OriginPackage[]
     * @throws ConfigurationException
     */
    public function getStandardPackages() {
        return array(
            OriginBox::createFromMetric(array(
                'id' => 1,
                'title' => 'Mailing Box XS',
                'image' => 'mailing-box.jpg',
                'dimensions_outside' => array(14, 14, 14),
                'dimensions_inside' => array(14, 14, 14),
                'density' => Weight::SoftCartonDensity
            )),
            OriginBox::createFromMetric(array(
                'id' => 2,
                'title' => 'Mailing Box S',
                'image' => 'mailing-box.jpg',
                'dimensions_outside' => array(28.6, 22.9, 6.4),
                'dimensions_inside' => array(28.6, 22.9, 6.4),
                'density' => Weight::SoftCartonDensity
            )),
            OriginBox::createFromMetric(array(
                'id' => 3,
                'title' => 'Mailing Box M',
                'image' => 'mailing-box.jpg',
                'dimensions_outside' => array(31.1, 23.5, 13.3),
                'dimensions_inside' => array(31.1, 23.5, 13.3),
                'density' => Weight::SoftCartonDensity
            )),
            OriginBox::createFromMetric(array(
                'id' => 4,
                'title' => 'Mailing Box L',
                'image' => 'mailing-box.jpg',
                'dimensions_outside' => array(38.1, 30.5, 9.5),
                'dimensions_inside' => array(38.1, 30.5, 9.5),
                'density' => Weight::SoftCartonDensity
            )),
            OriginBox::createFromMetric(array(
                'id' => 5,
                'title' => 'Mailing Box XL',
                'image' => 'mailing-box.jpg',
                'dimensions_outside' => array(40, 30.5, 21.6),
                'dimensions_inside' => array(40, 30.5, 21.6),
                'density' => Weight::SoftCartonDensity
            )),
            new OriginBox(array(
                'id' => 6,
                'title' => 'Moving Box 3.1 ft³',
                'image' => 'moving-box-31.jpg',
                'dimensions_outside' => array(18, 18, 16),
                'dimensions_inside' => array(18, 18, 16),
                'density' => Weight::SoftCartonDensity
            )),
            new OriginBox(array(
                'id' => 7,
                'title' => 'Moving Box 2 ft³',
                'image' => 'moving-box-2.jpg',
                'dimensions_outside' => array(18, 15, 12.5),
                'dimensions_inside' => array(18, 15, 12.5),
                'density' => Weight::SoftCartonDensity
            )),
            new OriginBox(array(
                'id' => 8,
                'title' => 'Moving Box 1.5 ft³',
                'image' => 'moving-box-15.jpg',
                'dimensions_outside' => array(16, 13, 13),
                'dimensions_inside' => array(16, 13, 13),
                'density' => Weight::SoftCartonDensity
            )),
            new OriginEnvelope(array(
                'id' => 9,
                'title' => 'Bubble Mailer XS',
                'image' => 'bubble-mailer-0.jpg',
                'length' => 6,
                'width' => 9,
                'density' => Weight::PlasticDensity
            )),
            new OriginEnvelope(array(
                'id' => 10,
                'title' => 'Bubble Mailer ML',
                'image' => 'bubble-mailer-4.jpg',
                'length' => 9.5,
                'width' => 13,
                'density' => Weight::PlasticDensity
            )),
            new OriginEnvelope(array(
                'id' => 11,
                'title' => 'Bubble Mailer L',
                'image' => 'bubble-mailer-5.jpg',
                'length' => 10.5,
                'width' => 16,
                'density' => Weight::PlasticDensity
            )),
            new OriginEnvelope(array(
                'id' => 12,
                'title' => 'Bubble Mailer XL',
                'image' => 'bubble-mailer-7.jpg',
                'length' => 14.5,
                'width' => 19,
                'density' => Weight::PlasticDensity
            )),
            new OriginEnvelope(array(
                'id' => 13,
                'title' => 'Bubble Mailer CD',
                'image' => 'bubble-mailer-cd.jpg',
                'length' => 6.5,
                'width' => 7.5,
                'density' => Weight::PlasticDensity
            )),
            new OriginEnvelope(array(
                'id' => 14,
                'title' => 'Bubble Mailer M',
                'image' => 'bubble-mailer-2.jpg',
                'length' => 8.5,
                'width' => 11,
                'density' => Weight::PlasticDensity
            )),
            new OriginEnvelope(array(
                'id' => 15,
                'title' => 'Kraft Envelope 6x9',
                'image' => 'kraft-69.jpg',
                'length' => 5.75,
                'width' => 9.5,
                'density' => Weight::PaperDensity
            )),
            new OriginEnvelope(array(
                'id' => 16,
                'title' => 'Kraft Envelope 10x13',
                'image' => 'kraft-1013.jpg',
                'length' => 10,
                'width' => 13,
                'density' => Weight::PaperDensity
            )),
            new OriginEnvelope(array(
                'id' => 17,
                'title' => 'Photo Mailer 6x8',
                'image' => 'photo-68.jpg',
                'length' => 6,
                'width' => 8,
                'density' => Weight::SoftCartonDensity
            )),
            new OriginEnvelope(array(
                'id' => 17,
                'title' => 'Photo Mailer 9x12',
                'image' => 'photo-912.jpg',
                'length' => 9,
                'width' => 12,
                'density' => Weight::SoftCartonDensity
            )),
        );
    }

    /**
     * @param string[] $requests
     * @return string[]
     * @since 08.07.2020 does NOT use MultiRequest since there is a throttle limit on CanadaPost API
     * @since 08.07.2020 uses cache for same requests
     */
    public function queryApi($requests) {
        $sameRequests = array(); // hash => [ids]
        $results = array();
        foreach ($requests as $k => $request) {
            $hash = sha1($request);
            if (isset($sameRequests[$hash])) {
                array_push($sameRequests[$hash], $k);
            } else {
                $sameRequests[$hash] = array($k);
                $curl = curl_init($this->getOption('production') ? self::ApiProductionHost : self::ApiDeveloperHost);
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
                curl_setopt($curl, CURLOPT_CAINFO, __DIR__ . '/cacert.pem');
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, $request);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                curl_setopt($curl, CURLOPT_USERPWD, $this->getOption('user_id') . ':' . $this->getOption('password'));
                curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                        'Content-Type: application/vnd.cpc.ship.rate-v3+xml',
                        'Accept: application/vnd.cpc.ship.rate-v3+xml')
                );
                $this->debug(Debugger::Trace, 'DATA SENT:', $request);
                $this->_lastRequestTime = Time::waitThrottleLimit($this->_lastRequestTime, self::ThrottleLimit);
                $results[$k] = curl_exec($curl);
            }
        }
        foreach ($sameRequests as $requestIds) {
            if (count($requestIds) > 1) {
                $protoId = array_shift($requestIds);
                foreach ($requestIds as $copyId) {
                    $results[$copyId] = $results[$protoId];
                }
            }
        }
        return $results;
    }

    /**
     * Prepares API Request strings
     * @param array $address
     * @param PackerResultBox[] $boxes
     * @param int $shippingTime
     * @return string[]
     */
    public function prepareApiRequests($address, $boxes, $shippingTime) {
        $requests = array();
        foreach ($boxes as $box) {
            $customerNumber = $this->getOption('customer_number') ?
                '<customer-number>' . $this->getOption('customer_number') . '</customer-number>' : '';
            $contractId = $this->getOption('contract_id') ?
                '<contract-id>' . $this->getOption('contract_id') . '</contract-id>' : '';
            $promoCode = $this->getOption('promo_code') ?
                '<promo-code>' . $this->getOption('promo_code') . '</promo-code>' : '';
            $quoteType = $customerNumber ? 'commercial' : 'counter';
            $shippingDate = date('Y-m-d', $shippingTime);
            $insurance = '';
            if ($this->getOption('insurance')) {
                $insuranceValue = round($box->getValue(), 2);
                $insurance = <<<XML

                        <option>
                            <option-code>COV</option-code>
                            <option-amount>{$insuranceValue}</option-amount>
                        </option>
XML;
            }
            $signature = '';
            if ($this->getOption('signature') && $address['iso_code_2'] === 'CA') {
                $signature = <<<XML
                        <option>
                            <option-code>SO</option-code>
                        </option>
XML;
                if ($this->getOption('proof_of_age')) {
                    $signature .= <<<XML
                        <option>
                            <option-code>PA{$this->getOption('proof_of_age')}</option-code>
                        </option>
XML;
                }
            }
            $options = '';
            if ($insurance || $signature) {
                $options = <<<XML
                    <options>{$insurance}{$signature}
                    </options>
XML;
            }
            $weight = round(Weight::convertPoundsToKilograms($box->getWeight()), 3);
            if ($box->hasDimensions()) {
                $length = round(Length::convertInchesToCentimeters($box->getOuterLength()), 1);
                $width = round(Length::convertInchesToCentimeters($box->getOuterWidth()), 1);
                $height = round(Length::convertInchesToCentimeters($box->getOuterHeight()), 1);
                $dimensions = <<<XML
                    <dimensions>
                        <length>{$length}</length>
                        <width>{$width}</width>
                        <height>{$height}</height>
                    </dimensions>
XML;
            } else {
                $dimensions = '';
            }
            if (Address::isCanada($address)) {
                $postcode = strtoupper(preg_replace('/[^A-Z0-9]/i', '', $address['postcode']));
                $destination = <<<XML
                    <domestic>
                        <postal-code>{$postcode}</postal-code>
                    </domestic>
XML;
            } elseif (Address::isUnitedStates($address)) {
                $postcode = preg_replace('/[^\d\-]/', '', $address['postcode']);
                if (strlen($postcode) !== 10) {
                    $postcode = substr($postcode, 0, 5);
                }
                $destination = <<<XML
                    <united-states>
                        <zip-code>{$postcode}</zip-code>
                    </united-states>
XML;
            } else {
                $destination = <<<XML
                    <international>
                        <country-code>{$address['iso_code_2']}</country-code>
                    </international>
XML;
            }
            $requests[] = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
                <mailing-scenario xmlns="http://www.canadapost.ca/ws/ship/rate-v3">
                    {$customerNumber}
                    {$contractId}
                    {$promoCode}
                    <quote-type>{$quoteType}</quote-type>
                    <expected-mailing-date>{$shippingDate}</expected-mailing-date>
                    {$options}
                    <parcel-characteristics>
                        <weight>{$weight}</weight>
                        {$dimensions}
                    </parcel-characteristics>
                    <origin-postal-code>{$this->getOption('postcode')}</origin-postal-code>
                    <destination>
                        {$destination}
                    </destination>
                </mailing-scenario>
XML;
        }
        return $requests;
    }

    /**
     * @param string $response
     * @param array $address
     * @param PackerResultBox[] $boxes
     * @return Rate[]
     * @throws ApiException
     */
    public function parseApiResponse($response, $address, $boxes) {
        $this->debug(Debugger::Trace, 'DATA RECV:', $response);
        $dom = Response::fromXml($response);
        /** @var \DomElement $messagesNode */
        $messagesNode = $dom->getElementsByTagName('messages')->item(0);
        if ($messagesNode) {
            $errorMessages = array_map(function($messageNode) {
                /** @var \DomElement $messageNode */
                return $messageNode->getElementsByTagName('description')->item(0)->nodeValue;
            }, iterator_to_array($messagesNode->getElementsByTagName('message')));
            throw new ApiException(implode('; ', $errorMessages));
        }
        $result = array();
        foreach ($dom->getElementsByTagName('price-quote') as $priceNode) {
            /** @var \DomElement $priceNode */
            $methodCode = $priceNode->getElementsByTagName('service-code')->item(0)->nodeValue;
            $methodFullCode = (Address::isCanada($address) ? 'domestic_' :
                (Address::isUnitedStates($address) ? 'usa_' : 'international_')) . $methodCode;
            if ($this->isMethodEnabled($methodFullCode)) {
                $methodName = $priceNode->getElementsByTagName('service-name')->item(0)->nodeValue;
                $cost = $priceNode->getElementsByTagName('due')->item(0)->nodeValue;
                $expectedNode = $priceNode->getElementsByTagName('expected-delivery-date')->item(0);
                $expectedTime = $expectedNode ? strtotime($expectedNode->nodeValue) : null;
                $result[] = Rate::create()
                    ->setId($methodCode)
                    ->setMethodFullCode($methodFullCode)
                    ->setTitle($methodName)
                    ->setCost($cost)
                    ->setCurrencyCode('CAD')
                    ->setTimeFrom($expectedTime)
                    ->setTimeTo($expectedTime)
                    ->setBoxes($boxes); // placed here for consistency
            }
        }
        return $result;
    }

    /**
     * @param array $address
     * @param PackerResult[] $packerResults
     * @param int $shippingTime
     * @return Rate[]
     * @throws ApiException
     */
    public function queryRates($address, $packerResults, $shippingTime) {
        /** @var PackerResult $packerResult */
        $packerResult = current($packerResults);
        $boxes = $packerResult->getBoxes();
        $requests = $this->prepareApiRequests($address, $boxes, $shippingTime);
        $responses = $this->queryApi($requests);
        $rates = array();
        foreach ($responses as $response) {
            $rates = array_merge($rates, $this->parseApiResponse($response, $address, $boxes));
        }
        return $this->combineRates($rates, $boxes);
    }

}
}


namespace CanadapostSmartFlexibleRootNS\SmartFlexible {

use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\AccompanyingDocument;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\BaseLabelsProvider;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\Debugger;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\Shipment;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Ordered\OrderedBoxPackedItem;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Response;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Time;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Weight;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\Utils\Length;

class CanadapostLabelsProvider extends BaseLabelsProvider {
    /** Api urls with places for customer numbers */
    const ContractShipmentDeveloperApi = 'https://ct.soa-gw.canadapost.ca/rs/%s/%s/shipment';
    const ContractShipmentProductionApi = 'https://soa-gw.canadapost.ca/rs/%s/%s/shipment';
    const NonContractShipmentDeveloperApi = 'https://ct.soa-gw.canadapost.ca/rs/%s/ncshipment';
    const NonContractShipmentProductionApi = 'https://soa-gw.canadapost.ca/rs/%s/ncshipment';
    const ServiceDeveloperApi = 'https://ct.soa-gw.canadapost.ca/rs/ship/service/%s?country=%s';
    const ServiceProductionApi = 'https://soa-gw.canadapost.ca/rs/ship/service/%s?country=%s';
    const ThrottleLimit = 60;
    private $_lastRequestTime = 0;

    /** @var bool Use contract shipment */
    private $isContractShipment = true;

    /** @var string[] One of these options used in label request */
    private static $nonDeliveryOptions = array('RASE', 'RTS', 'ABAN');

    /**
     * @param $address
     * @return array [top,left,height,rotate,resolution]
     */
    public function getLabelPosition($address) {
        return array(
            'top' => 0 / 300,
            'left' => 0 / 300,
            'height' => 1800 / 300,
            'rotate' => 0,
            'resolution' => 300
        );
    }

    /**
     * @return int
     */
    public function getProductNameMaxLength() {
        return 45;
    }

    public function setContractShipment() {
        $this->isContractShipment = $this->getOption('contract_id');
    }

    /**
     * Returns the code of non-delivery option for requested shipping method
     * Or returns null when non-delivery options are not available for this method
     * @param string $response
     * @return string|null
     */
    public function parseServiceNonDeliveryOptionsResponse($response) {
        $this->debug(Debugger::Trace, 'SERVICE INFO RESPONSE:', $response);
        try {
            $dom = Response::fromXml($response);
            $options = $dom->getElementsByTagName('option-code');
        } catch (\Exception $e) {
            return null;
        }
        for ($i = 0; $i < $options->length; $i++) {
            if (in_array($options->item($i)->nodeValue, self::$nonDeliveryOptions, true)) {
                return $options->item($i)->nodeValue;
            }
        }
        return null;
    }

    /**
     * Generates requests body to create shipping labels
     * @param Shipment[] $shipments
     * @param array $address
     * @param string $methodCode
     * @param string|null $nonDeliveryOption
     * @internal param int $orderId
     * @return string[]
     */
    public function prepareShipmentRequests($shipments, $address, $methodCode, $nonDeliveryOption) {
        $requests = array();
        $nonDelivery = '';
        $_this = $this;
        if ($nonDeliveryOption) {
            $nonDelivery = <<<XML
            <option>
                <option-code>{$nonDeliveryOption}</option-code>
            </option>
XML;
        }
        foreach ($shipments as $k => $shipment) {
            $box = $shipment->getBox();
            $weight = round(Weight::convertPoundsToKilograms($box->getWeight()), 3);
            $dimensions = '';
            if ($box->hasDimensions()) {
                $length = round(Length::convertInchesToCentimeters($box->getOuterLength()), 1);
                $width = round(Length::convertInchesToCentimeters($box->getOuterWidth()), 1);
                $height = round(Length::convertInchesToCentimeters($box->getOuterHeight()), 1);
                $dimensions = <<<XML

            <dimensions>
                <length>{$length}</length>
                <width>{$width}</width>
                <height>{$height}</height>
            </dimensions>
XML;
            } elseif (!$this->getOption('contract_id')) { // faked box for non-contract shipping required
                $fakedBox = $this->getOption('weight_based_faked_box');
                $length = round((float)$fakedBox['length'], 1);
                $width = round((float)$fakedBox['width'], 1);
                $height = round((float)$fakedBox['height'], 1);
                $dimensions = <<<XML
                    <dimensions>
                        <length>{$length}</length>
                        <width>{$width}</width>
                        <height>{$height}</height>
                    </dimensions>
XML;
            }
            $insuranceValue = 0;
            $sku = implode("\r\n", array_map(function ($product) use (&$insuranceValue, $_this) {
                /** @var OrderedBoxPackedItem $product */
                $weight = round(Weight::convertPoundsToKilograms($product->getWeight()), 3);
                $price = round($product->getPrice(), 2);
                $insuranceValue += $price * $product->getQuantity();
                $description = $_this->shortenProductName(
                    $product->getShortDescription() ?: $product->getDescription()
                );
                $hsCode = '';
                if ($product->getHsCode()) {
                    $hsCode = '<hs-tariff-code>' . $product->getHsCode() .'</hs-tariff-code>';
                }
                $originCountry = '';
                $originZone = '';
                if ($product->getOriginCountryId() && is_callable($_this->getOption('get_country_code'))) {
                    $originCountry = '<country-of-origin>' .
                        call_user_func($_this->getOption('get_country_code'), $product->getOriginCountryId()) .
                        '</country-of-origin>';
                    if ($product->getOriginZoneId() && is_callable($_this->getOption('get_zone_code'))) {
                        $originZone = '<province-of-origin>' .
                            call_user_func($_this->getOption('get_zone_code'), $product->getOriginZoneId()) .
                            '</province-of-origin>';
                    }
                }
                return <<<XML

                <item>
                    <customs-number-of-units>{$product->getQuantity()}</customs-number-of-units>
                    <customs-unit-of-measure>PCE</customs-unit-of-measure>
                    <customs-description>{$description}</customs-description>
                    {$hsCode}
                    <unit-weight>{$weight}</unit-weight>
                    <customs-value-per-unit>{$price}</customs-value-per-unit>
                    {$originCountry}
                    {$originZone}
                </item>
XML;
            }, $box->getProducts()));
            $insurance = '';
            if ($this->getOption('insurance')) {
                // issue #195: CRC required
                // $insuranceValue = round($box->getValue(), 2);
                $insuranceValue = round($insuranceValue, 2);
                $insurance = <<<XML

            <option>
                <option-code>COV</option-code>
                <option-amount>{$insuranceValue}</option-amount>
            </option>

XML;
            }
            $signature = '';
            if ($this->getOption('signature') && $address['iso_code_2'] === 'CA') {
                $signature = <<<XML
                        <option>
                            <option-code>SO</option-code>
                        </option>
XML;
                if ($this->getOption('proof_of_age')) {
                    $signature .= <<<XML
                        <option>
                            <option-code>PA{$this->getOption('proof_of_age')}</option-code>
                        </option>
XML;
                }
            }
            $options = '';
            if ($nonDeliveryOption || $insurance || $signature) {
                $options = '<options>' . $nonDelivery . $insurance . $signature . '        </options>';
            }
            $stateTo = '';
            if ($address['zone_code']) {
                $stateTo = '<prov-state>' . $address['zone_code'] . '</prov-state>';
            }

            if ($this->isContractShipment) {
                $labelFormat = '4x6';
                if (preg_match('/^(INT|USA)\.PW\..+$/si', $methodCode)) { // all priority worldwide methods
                    $labelFormat = '8.5x11';
                }
                $requests[$k] = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<shipment xmlns="http://www.canadapost.ca/ws/shipment-v8">
    <transmit-shipment>true</transmit-shipment>
    <requested-shipping-point>{$this->getOption('postcode')}</requested-shipping-point>
    <delivery-spec>
        <service-code>{$methodCode}</service-code>
        <sender>
            <name>{$this->getOption('owner')}</name>
            <company>{$this->getOption('store')}</company>
            <contact-phone>{$this->getOption('telephone')}</contact-phone>
            <address-details>
                <address-line-1>{$this->getOption('shipper_address')}</address-line-1>
                <city>{$this->getOption('shipper_city')}</city>
                <prov-state>{$this->getOption('shipper_state')}</prov-state>
                <country-code>{$this->getOption('shipper_country')}</country-code>
                <postal-zip-code>{$this->getOption('postcode')}</postal-zip-code>
            </address-details>
        </sender>
        <destination>
            <name>{$address['firstname']} {$address['lastname']}</name>
            <company>{$address['company']}</company>
            <client-voice-number>{$address['telephone']}</client-voice-number>
            <address-details>
                <address-line-1>{$address['address_1']}</address-line-1>
                <address-line-2>{$address['address_2']}</address-line-2>
                <city>{$address['city']}</city>
                {$stateTo}
                <country-code>{$address['iso_code_2']}</country-code>
                <postal-zip-code>{$address['postcode']}</postal-zip-code>
            </address-details>
        </destination>
        {$options}
        <parcel-characteristics>
            <weight>{$weight}</weight>{$dimensions}
            <mailing-tube>false</mailing-tube>
        </parcel-characteristics>
        <print-preferences>
            <output-format>{$labelFormat}</output-format>
        </print-preferences>
        <preferences>
            <show-packing-instructions>false</show-packing-instructions>
            <show-postage-rate>true</show-postage-rate>
            <show-insured-value>true</show-insured-value>
        </preferences>
        <customs>
            <currency>{$this->getOption('value_currency_code')}</currency>
            <reason-for-export>SOG</reason-for-export>
            <sku-list>{$sku}
            </sku-list>
        </customs>
        <settlement-info>
            <contract-id>{$this->getOption('contract_id')}</contract-id>
            <intended-method-of-payment>Account</intended-method-of-payment>
        </settlement-info>
    </delivery-spec>
</shipment>
XML;
            } else { // only from Canada
                $requests[$k] = <<<XML
<?xml version="1.0" encoding="UTF-8"?>
<non-contract-shipment xmlns="http://www.canadapost.ca/ws/ncshipment-v4">
    <delivery-spec>
        <service-code>{$methodCode}</service-code>
        <sender>
            <name>{$this->getOption('owner')}</name>
            <company>{$this->getOption('store')}</company>
            <contact-phone>{$this->getOption('telephone')}</contact-phone>
            <address-details>
                <address-line-1>{$this->getOption('shipper_address')}</address-line-1>
                <city>{$this->getOption('shipper_city')}</city>
                <prov-state>{$this->getOption('shipper_state')}</prov-state>
                <postal-zip-code>{$this->getOption('postcode')}</postal-zip-code>
            </address-details>
        </sender>
        <destination>
            <name>{$address['firstname']} {$address['lastname']}</name>
            <company>{$address['company']}</company>
            <client-voice-number>{$address['telephone']}</client-voice-number>
            <address-details>
                <address-line-1>{$address['address_1']}</address-line-1>
                <address-line-2>{$address['address_2']}</address-line-2>
                <city>{$address['city']}</city>
                {$stateTo}
                <country-code>{$address['iso_code_2']}</country-code>
                <postal-zip-code>{$address['postcode']}</postal-zip-code>
            </address-details>
        </destination>
        {$options}
        <parcel-characteristics>
            <weight>{$weight}</weight>{$dimensions}
        </parcel-characteristics>
        <preferences>
            <show-packing-instructions>false</show-packing-instructions>
            <show-postage-rate>true</show-postage-rate>
            <show-insured-value>true</show-insured-value>
        </preferences>
        <customs>
            <currency>{$this->getOption('value_currency_code')}</currency>
            <reason-for-export>SOG</reason-for-export>
            <sku-list>{$sku}
            </sku-list>
        </customs>
    </delivery-spec>
</non-contract-shipment>
XML;

            }
        }
        return $requests;
    }

    /**
     * Analyze result of shipping label creation
     * @param Shipment $shipment
     * @param string $response
     * @return Shipment
     */
    public function parseShipmentResponse($shipment, $response) {
        $info = null;
        $messages = null;
        $errorMessage = null;
        $tracking = null;
        $selfUrl = null;
        $voidUrl = null;
        $documents = array();
        $labelUrls = array();
        $invoiceUrls = array();
        $this->debug(Debugger::Trace, 'LABEL DATA RECV:', $response);
        try {
            $dom = Response::fromXml($response);
            /** @var \DomElement $info */
            $info = $dom->getElementsByTagName('shipment-info')->item(0);
            if (!$info) {
                $info = $dom->getElementsByTagName('non-contract-shipment-info')->item(0);
            }
            /** @var \DomElement $messages */
            $messages = $dom->getElementsByTagName('messages')->item(0);
        } catch (\Exception $e) {
            $errorMessage = $e->getMessage();
        }
        if ($messages) {
            $errorMessage = implode('; ', array_map(function($messageNode) {
                /** @var \DomElement $messageNode */
                $message = $messageNode->getElementsByTagName('description')->item(0)->nodeValue;
                return $message;
            }, iterator_to_array($messages->getElementsByTagName('message'))));
        }
        if ($info) {
            $tracking = $info->getElementsByTagName('tracking-pin')->item(0);
            $links = $info->getElementsByTagName('link');
            for ($i = 0; $i < $links->length; $i++) {
                if ($links->item($i)->getAttribute('rel') === 'label') {
                    $labelUrls[] = $links->item($i)->getAttribute('href');
                }
                if ($links->item($i)->getAttribute('rel') === 'commercialInvoice') {
                    $invoiceUrls[] = $links->item($i)->getAttribute('href');
                }
                if ($links->item($i)->getAttribute('rel') === 'refund') {
                    $voidUrl = $links->item($i)->getAttribute('href');
                }
                if ($links->item($i)->getAttribute('rel') === 'self') {
                    $selfUrl = $links->item($i)->getAttribute('href');
                }
            }
            if (count($labelUrls)) {
                $documents[] = new AccompanyingDocument(
                    AccompanyingDocument::TypeLabel,
                    self::getLabelFormat(),
                    $this->queryDocumentPages($labelUrls)
                );
            }
            if (count($invoiceUrls)) {
                $documents[] = new AccompanyingDocument(
                    AccompanyingDocument::TypeInvoice,
                    AccompanyingDocument::FormatPDF,
                    $this->queryDocumentPages($invoiceUrls)
                );
            }
        }
        if (!$voidUrl) {
            $voidUrl = $selfUrl ? ($selfUrl . '/refund') : null;
        }
        return $shipment->setTransactionNumber($voidUrl)
            ->setTrackingNumber($tracking ? $tracking->nodeValue : null) // may be no tracking number
            ->setTrackingUrl(
                $tracking ? 'https://www.canadapost.ca/trackweb/en#/search?searchFor=' . $tracking->nodeValue : null
            )
            ->setDocuments($documents)
            ->setErrorMessage($errorMessage);
    }

    /**
     * Generates request body to void label
     * @return string
     */
    public function prepareVoidRequest() {
        if ($this->isContractShipment) {
            return <<<XML
<?xml version="1.0" encoding="utf-8"?>
<shipment-refund-request xmlns="http://www.canadapost.ca/ws/shipment-v8">
<email>{$this->getOption('email')}</email>
</shipment-refund-request>
XML;
        } else {
            return <<<XML
<?xml version="1.0" encoding="utf-8"?>
<non-contract-shipment-refund-request xmlns="http://www.canadapost.ca/ws/ncshipment-v4">
<email>{$this->getOption('email')}</email>
</non-contract-shipment-refund-request>
XML;
        }
    }

    /**
     * Analyze result of voiding label
     * @param string $response
     * @throws ApiException
     * @return bool
     */
    public function parseVoidResponse($response) {
        $this->debug(Debugger::Trace, 'LABEL VOID RESPONSE:', $response);
        $errorMessage = null;
        $dom = Response::fromXml($response);
        /** @var \DomElement $ticket */
        $ticket = $dom->getElementsByTagName('service-ticket-id')->item(0);
        if ($ticket) {
            return true;
        }
        /** @var \DomElement $messages */
        $messages = $dom->getElementsByTagName('messages')->item(0);
        if ($messages) {
            $errorMessage = implode('; ', array_map(function($messageNode) {
                /** @var \DomElement $messageNode */
                return $messageNode->getElementsByTagName('description')->item(0)->nodeValue;
            }, iterator_to_array($messages->getElementsByTagName('message'))));
            throw new ApiException($errorMessage);
        }
        return false;
    }

    /**
     * Sends request to get service information
     * @param string $methodCode
     * @param array $address
     * @return string
     */
    public function queryServiceInformation($methodCode, $address) {
        $url = sprintf(
            $this->getOption('production') ? self::ServiceProductionApi : self::ServiceDeveloperApi,
            $methodCode, $address['iso_code_2']
        );
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($curl, CURLOPT_CAINFO, __DIR__ . '/cacert.pem');
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($curl, CURLOPT_USERPWD, $this->getOption('user_id') . ':' . $this->getOption('password'));
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Accept: application/vnd.cpc.ship.rate-v3+xml'
        ));
        $this->debug(Debugger::Trace, 'SERVICE INFO REQUEST:', $url);
        $result = curl_exec($curl);
        curl_close($curl);
        return $result;
    }

    /**
     * Sends requests to create shipping labels
     * @param string[] $requests
     * @return string[]
     * @since 08.07.2020 does NOT use MultiRequest since there is a throttle limit on CanadaPost API
     */
    public function queryShipmentApi($requests) {
        $results = array();
        if ($this->getOption('production')) {
            if ($this->isContractShipment) {
                $url = sprintf(
                    self::ContractShipmentProductionApi,
                    $this->getOption('customer_number'),
                    $this->getOption('customer_number')
                );
            } else {
                $url = sprintf(self::NonContractShipmentProductionApi, $this->getOption('customer_number'));
            }
        } else {
            if ($this->isContractShipment) {
                $url = sprintf(
                    self::ContractShipmentDeveloperApi,
                    $this->getOption('customer_number'),
                    $this->getOption('customer_number')
                );
            } else {
                $url = sprintf(self::NonContractShipmentDeveloperApi, $this->getOption('customer_number'));
            }
        }
        if ($this->isContractShipment) {
            $contentType = 'application/vnd.cpc.shipment-v8+xml';
        } else {
            $contentType = 'application/vnd.cpc.ncshipment-v4+xml';
        }
        $this->debug(Debugger::Trace, 'LABEL API USED:', $url);
        foreach ($requests as $k => $request) {
            $curl = curl_init($url);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
            curl_setopt($curl, CURLOPT_CAINFO, __DIR__ . '/cacert.pem');
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $request);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($curl, CURLOPT_USERPWD, $this->getOption('user_id') . ':' . $this->getOption('password'));
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Content-Type: ' . $contentType,
                'Accept: ' . $contentType
            ));
            $this->debug(Debugger::Trace, 'LABEL DATA SENT:', $request);
            $this->_lastRequestTime = Time::waitThrottleLimit($this->_lastRequestTime, self::ThrottleLimit);
            $results[$k] = curl_exec($curl);
        }
        return $results;
    }

    /**
     * Sends requests to get document binary data
     * @param string[] $urls or pages
     * @return string[] base64 encoded pages
     */
    public function queryDocumentPages($urls) {
        $pages = array();
        foreach ($urls as $i => $url) {
            $curl = curl_init($url);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
            curl_setopt($curl, CURLOPT_CAINFO, __DIR__ . '/cacert.pem');
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($curl, CURLOPT_USERPWD, $this->getOption('user_id') . ':' . $this->getOption('password'));
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Accept: application/pdf'
            ));
            $this->debug(Debugger::Trace, 'LABEL URL USED:', $url);
            $this->_lastRequestTime = Time::waitThrottleLimit($this->_lastRequestTime, self::ThrottleLimit);
            $pages[$i] = base64_encode(curl_exec($curl));
        }
        return $pages;
    }

    /**
     * Sends request to void API
     * @param string $url
     * @param string $request
     * @return string
     */
    public function queryVoidApi($url, $request) {
        $curl = curl_init($url);
        if ($this->isContractShipment) {
            $contentType = 'application/vnd.cpc.shipment-v8+xml';
        } else {
            $contentType = 'application/vnd.cpc.ncshipment-v4+xml';
        }
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($curl, CURLOPT_CAINFO, __DIR__ . '/cacert.pem');
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $request);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($curl, CURLOPT_USERPWD, $this->getOption('user_id') . ':' . $this->getOption('password'));
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: ' . $contentType,
            'Accept: ' . $contentType
        ));
        $this->debug(Debugger::Trace, 'LABEL VOID REQUEST:', $url, $request);
        $result = curl_exec($curl);
        curl_close($curl);
        return $result;
    }

    /**
     * Entry point to request labels and tracking numbers
     * @param int $orderId
     * @param Shipment[] $shipments
     * @param array $address
     * @param string $methodCode
     * @param $validationData
     * @return Shipment[] updated shipments with numbers, labels and messages
     */
    public function queryLabelsAndTracking($orderId, $shipments, $address, $methodCode, $validationData) {
        $this->setContractShipment();
        $response = $this->queryServiceInformation($methodCode, $address);
        $nonDeliveryOption = $this->parseServiceNonDeliveryOptionsResponse($response);
        $requests = $this->prepareShipmentRequests($shipments, $address, $methodCode, $nonDeliveryOption);
        $responses = $this->queryShipmentApi($requests);
        foreach ($shipments as $k => $shipment) {
            $shipments[$k] = $this->parseShipmentResponse($shipment, $responses[$k]);
        }
        return $shipments;
    }

    /**
     * Entry point to void label
     * @param int $orderId
     * @param Shipment $shipment
     * @return Shipment updated shipment with message
     */
    public function voidLabel($orderId, $shipment) {
        $this->setContractShipment();
        if ($shipment->getTransactionNumber()) {
            $request = $this->prepareVoidRequest();
            $response = $this->queryVoidApi($shipment->getTransactionNumber(), $request);
            try {
                $result = $this->parseVoidResponse($response);
            } catch (\Exception $e) {
                return $shipment->setErrorMessage('Void failed: ' . $e->getMessage());
            }
            if ($result) {
                return $shipment->voidLabel()->clearErrorMessage()->setSuccessMessage('Label has been voided');
            } else {
                return $shipment->clearSuccessMessage()->setErrorMessage('Failed to void label');
            }
        } else {
            return $shipment->setErrorMessage('This label can not be voided (no voiding url stored)');
        }
    }

    /**
     * @param string $url
     * @param bool $isProduction
     * @throws ApiException
     * @return string id
     */
    public function mountWebhook($url, $isProduction) {
        throw new ApiException('Not supported');
    }


}
}
namespace {


use \CanadapostSmartFlexibleRootNS\SmartFlexible\Shipping\ShippingVqmod;
use \CanadapostSmartFlexibleRootNS\SmartFlexible\CanadapostModule;

class CanadapostSmartFlexibleVqmod extends ShippingVqmod {
    public function __construct() {
        parent::__construct(new CanadapostModule());
    }
}

}
