<?php


namespace Sezzle;

/**
 * Class Config
 * @package Sezzle
 */
class Config
{
    const SANDBOX = "sandbox";
    const PRODUCTION = "production";

    const API_V1 = "v1";
    const API_V2 = "v2";

    const HTTP_POST = "POST";
    const HTTP_GET = "GET";
    const HTTP_PATCH = "PATCH";
    const HTTP_DELETE = "DELETE";
    const HTTP_PUT = "PUT";

    const AUTHENTICATION_RESOURCE = 'authentication';

    const SESSION_RESOURCE = 'session/%s';

    const REFUND_RESOURCE = 'order/%s/refund';
    const RELEASE_RESOURCE = 'order/%s/release';
    const CAPTURE_RESOURCE = 'order/%s/capture';
    const ORDER_RESOURCE = 'order/%s';
    const CUSTOMER_RESOURCE = 'customer/%s';

    const CONFIG_RESOURCE = 'configuration';

    const CUSTOMER_ORDER_RESOURCE = 'customer/%s/order';

    const TOKENIZE_RESOURCE = 'token/%s/session';

    const GATEWAY_URL = "https://%sgateway.%s/";
    const SEZZLE_DOMAIN = "%ssezzle.com";
    public static $supportedRegions = ['US/CA', 'EU'];

    /**
     * Get Sezzle Domain
     *
     * @param string $gatewayRegion
     * @return string
     */
    public static function getSezzleDomain($gatewayRegion = '')
    {
        switch ($gatewayRegion) {
            case self::$supportedRegions[1]:
                return sprintf(Config::SEZZLE_DOMAIN, 'eu.');
            case self::$supportedRegions[0]:
            default:
                return sprintf(Config::SEZZLE_DOMAIN, '');
        }
    }

    /**
     * Get Gateway URL
     *
     * @param string $apiMode
     * @param string $gatewayRegion
     * @return string
     */
    public static function getGatewayUrl($apiMode, $gatewayRegion = '')
    {
        $sezzleDomain = self::getSezzleDomain($gatewayRegion);
        if ($apiMode === Config::SANDBOX) {
            return sprintf(Config::GATEWAY_URL, 'sandbox.', $sezzleDomain);
        }
        return sprintf(Config::GATEWAY_URL, "", $sezzleDomain);
    }
}
