<?php

namespace Sezzle\Services;

use Sezzle\Config;
use Sezzle\HttpClient\ClientService;
use Sezzle\HttpClient\Exception\InvalidRequest;
use Sezzle\Model\Customer;

/**
 * Class CustomerService
 * @package Sezzle\Services
 */
class CustomerService
{
    /**
     * @var ClientService
     */
    private $clientService;

    public function __construct(
        ClientService $clientService
    ) {
        $this->clientService = $clientService;
    }

    /**
     * Get Customer
     *
     * @param string $customer_uuid
     * @return Customer
     * @throws InvalidRequest
     */
    public function getCustomer($customer_uuid)
    {
        $response = $this->clientService->sendRequest(
            Config::HTTP_GET,
            sprintf(Config::CUSTOMER_RESOURCE, $customer_uuid)
        );
        return Customer::fromArray($response["body"]);
    }
    
}
