<?php

namespace Sezzle\Services;

use Sezzle\Config;
use Sezzle\HttpClient\ClientService;
use Sezzle\HttpClient\Exception\InvalidRequest;
use Sezzle\Model\Order;

/**
 * Class OrderService
 * @package Sezzle\Services
 */
class OrderService
{
    /**
     * @var ClientService
     */
    private $clientService;

    public function __construct(
        ClientService $clientService
    ) {
        $this->clientService = $clientService;
    }

    /**
     * Get Order
     *
     * @param string $orderUUID
     * @return Order
     * @throws InvalidRequest
     */
    public function getOrder($orderUUID)
    {
        $response = $this->clientService->sendRequest(
            Config::HTTP_GET,
            sprintf(Config::ORDER_RESOURCE, $orderUUID)
        );
        return Order::fromArray($response["body"]);
    }

    /**
     * Update Order
     *
     * @param string $orderUUID
     * @param array $payload
     * @return bool
     * @throws InvalidRequest
     */
    public function updateOrder($orderUUID, array $payload)
    {
        $response = $this->clientService->sendRequest(
            Config::HTTP_PATCH,
            sprintf(Config::ORDER_RESOURCE, $orderUUID),
            $payload
        );

        return isset($response['status_code']) && $response['status_code'] === strval(http_response_code(204));
    }
}
