<?php

namespace Sezzle\Services;

use Sezzle\Config;
use Sezzle\HttpClient\ClientService;
use Sezzle\HttpClient\Exception\InvalidRequest;
use Sezzle\Model\Order\Release;

/**
 * Class ReleaseService
 * @package Sezzle\Services
 */
class ReleaseService
{
    /**
     * @var ClientService
     */
    private $clientService;

    public function __construct(
        ClientService $clientService
    ) {
        $this->clientService = $clientService;
    }

    /**
     * Release Payment
     *
     * @param string $orderUUID
     * @param array $payload
     * @return Release
     * @throws InvalidRequest
     */
    public function releasePayment($orderUUID, array $payload)
    {
        $response = $this->clientService->sendRequest(
            Config::HTTP_POST,
            sprintf(Config::RELEASE_RESOURCE, $orderUUID),
            $payload
        );
        return Release::fromArray($response["body"]);
    }
}
