<?php

namespace Sezzle\Services;

use Sezzle\Config;
use Sezzle\HttpClient\ClientService;
use Sezzle\HttpClient\Exception\InvalidRequest;
use Sezzle\Model\Session;

/**
 * Class SessionService
 * @package Sezzle\Services
 */
class SessionService
{
    /**
     * @var ClientService
     */
    private $clientService;

    public function __construct(
        ClientService $clientService
    )
    {
        $this->clientService = $clientService;
    }

    /**
     * Create Session
     *
     * @param array $payload
     * @return Session
     * @throws InvalidRequest
     */
    public function createSession(array $payload)
    {
        $response = $this->clientService->sendRequest(
            Config::HTTP_POST,
            sprintf(Config::SESSION_RESOURCE, ""),
            $payload
        );
        return Session::fromArray($response["body"]);
    }

    /**
     * Get Session
     *
     * @param string $orderUUID
     * @return Session
     * @throws InvalidRequest
     */
    public function getSession($orderUUID)
    {
        $response = $this->clientService->sendRequest(
            Config::HTTP_POST,
            sprintf(Config::SESSION_RESOURCE, $orderUUID)
        );
        return Session::fromArray($response["body"]);
    }
}
