<?php

namespace Sezzle\Services;

use Sezzle\Config;
use Sezzle\HttpClient\ClientService;
use Sezzle\HttpClient\Exception\InvalidRequest;
use Sezzle\Model\CustomerOrder;
use Sezzle\Model\Tokenize;

/**
 * Class TokenizationService
 * @package Sezzle\Services
 */
class TokenizationService
{
    /**
     * @var ClientService
     */
    private $clientService;

    public function __construct(
        ClientService $clientService
    ) {
        $this->clientService = $clientService;
    }

    /**
     * Get Token Details
     *
     * @param string $tokenizeToken
     * @return Tokenize
     * @throws InvalidRequest
     */
    public function getTokenDetails($tokenizeToken)
    {
        $response = $this->clientService->sendRequest(
            Config::HTTP_GET,
            sprintf(Config::TOKENIZE_RESOURCE, $tokenizeToken)
        );
        return Tokenize::fromArray($response["body"]);
    }

    /**
     * Create Order by Customer UUID
     *
     * @param string $customerUUID
     * @param array $payload
     * @return CustomerOrder
     * @throws InvalidRequest
     */
    public function createOrder($customerUUID, array $payload)
    {
        $response = $this->clientService->sendRequest(
            Config::HTTP_POST,
            sprintf(Config::CUSTOMER_ORDER_RESOURCE, $customerUUID),
            $payload
        );
        return CustomerOrder::fromArray($response["body"]);
    }
}
