<?php
class XtensionsActivity {
	
	private $page = '';
	private $referer = '';
	private $activitySessionCode;
	private $cookie_name = 'xtensions_activity_session_code';
	private $enabled;
	private $customer_data = array();
	
	public function __construct($registry) {
		$this->registry = $registry;
		$this->db = $registry->get('db');
		$this->session = $registry->get('session');
		$this->cart = $registry->get('cart');
		$this->customer = $registry->get('customer');
		$this->request = $registry->get('request');
		$this->config = $registry->get('config');
		$this->load = $registry->get('load');
		$this->currency = $registry->get('currency');
		$this->tax = $registry->get('tax');
		$this->log = $registry->get('log');
		$this->config->load('xtensions/xabandoned');		
		$this->xabandoned_config_pfx = $this->config->get('xabandoned_config_pfx');
		$this->cookie_name .= $this->config->get($this->xabandoned_config_pfx .'cookie_name');
		$this->enabled();
		$this->activitySessionCode = $this->getActivitySession();
		$this->version_two_point_one = false;
		if(version_compare(VERSION, '2.2.0.0')<0){
			$this->version_two_point_one = true;
		}
	}
	
	public function getCookieName(){
		return $this->cookie_name;	
	}
	
	public function addActivity($methods,$outside=''){
		//set_error_handler(array($this, 'handler'));
		$this->setPage();
		$this->addPage();
		if($this->enabled){
			foreach ($methods as $method => $value){
				if($value && !is_array($value)){
					if(method_exists($this,$value)){
						$this->$value();			
					}
				}else{
					if(method_exists($this,$method)){
						$this->$method($value);			
					}
				}
			}
		}
		/*if($this->version_two_point_one){
			set_error_handler(array($this, 'default_handler'));
		}else{
			$this->load->controller('startup/error');
		}*/
	}
	
	public function addEventActivity($methods,$outside=''){
		//handle all errors at own logs and never display to user so that checkout processing is not stopped in an event of an error!
		//set_error_handler(array($this, 'handler'));
		if($this->enabled){
			$this->setPage();
			if($this->config->get($this->xabandoned_config_pfx .'minute')){
				foreach ($methods as $method => $value){
					if($method){
						$this->addEvent($method,$value);
					}else{
						$this->addEvent($value);
					}
				}
			} else{
				foreach ($methods as $method => $value){
					if($method){
						$this->getActivityFromLittle($method);
					}else{
						$this->getActivityFromLittle($value);
					}
				}
				$this->setPage();
			}
		}
		//switch back to opencart system error handling so that it can work on settings defined by opencart!	
		/*if($this->version_two_point_one){
			set_error_handler(array($this, 'default_handler'));
		}else{
			$this->load->controller('startup/error');
		}*/
	}
	
	public function default_handler($code, $message, $file, $line){

		// error suppressed with @
		if (error_reporting() === 0) {
			return false;
		}
	
		switch ($code) {
			case E_NOTICE:
			case E_USER_NOTICE:
				$error = 'Notice';
				break;
			case E_WARNING:
			case E_USER_WARNING:
				$error = 'Warning';
				break;
			case E_ERROR:
			case E_USER_ERROR:
				$error = 'Fatal Error';
				break;
			default:
				$error = 'Unknown';
				break;
		}
	
		if ($this->config->get('config_error_display')) {
			echo '<b>' . $error . '</b>: ' . $message . ' in <b>' . $file . '</b> on line <b>' . $line . '</b>';
		}
	
		if ($this->config->get('config_error_log')) {
			$this->log->write('PHP ' . $error . ':  ' . $message . ' in ' . $file . ' on line ' . $line);
		}
	
		return true;

	}
	
	public function handler($code, $message, $file, $line) {
		// error suppressed with @
		if (error_reporting() === 0) {
			return false;
		}
	
		switch ($code) {
			case E_NOTICE:
			case E_USER_NOTICE:
				$error = 'Notice';
				break;
			case E_WARNING:
			case E_USER_WARNING:
				$error = 'Warning';
				break;
			case E_ERROR:
			case E_USER_ERROR:
				$error = 'Fatal Error';
				break;
			default:
				$error = 'Unknown';
				break;
		}
	
		if ($this->config->get('config_error_display') || $this->config->get('config_error_log')) {
			$this->log->write('PHP ' . $error . ':  ' . $message . ' in ' . $file . ' on line ' . $line);
		}
	
		return true;
	}

	public function getAllMainActivity(){
		if($this->enabled){
			return array('order','cart','currency','language','name','telephone','email','store','payment_method','shipping_method','user_agent','ip','date_modified');
		}
		return array();
	}
	
	private function getCustomer() {
		// @formatter:off
		if(empty($this->customer_data)){
			if($this->customer->isLogged()){
				$this->customer_data = array('firstname' => $this->customer->getFirstName(),'lastname'=>$this->customer->getLastName(),'name' => $this->customer->getFirstName().' '. $this->customer->getLastName(),'email'=>$this->customer->getEmail(),'telephone'=>$this->customer->getTelephone(),'customer_id' => $this->customer->getId(),'country_code'=>$this->getCountryCode($this->customer->getId()),'full_telephone'=>$this->getFullTelephone($this->customer->getId()));
			}else{
				// Do not wipe out the personal data if user session is lost and cookie still exists
				$saved_data = $this->getActivityData();
				foreach (array('firstname','lastname','email','customer_id','telephone','country_code','full_telephone') as $key){
					if (isset($this->session->data['guest'][$key]) && $this->session->data['guest'][$key]) {
						$this->customer_data[$key] = $this->session->data['guest'][$key];
					} else if(isset($saved_data[$key])){
						$this->customer_data[$key] = $saved_data[$key];
					} else {
						$this->customer_data[$key] = '';
					}				
				}
				$this->customer_data['name'] = $this->customer_data['firstname'] . ' ' . $this->customer_data['lastname'];
			}
		}
		// @formatter:on
		return $this->customer_data;
	}
	
	private function getCountryCode($customer_id){
		$query = $this->db->query("SELECT telephone_country_code FROM " . DB_PREFIX . "xcustomer_data WHERE customer_id = '" . (int)$customer_id . "'");
		if($query->num_rows)
			return $query->row['telephone_country_code'];
		else 
			return '';
	}
	
	private function getFullTelephone($customer_id){
		$query = $this->db->query("SELECT full_telephone FROM " . DB_PREFIX . "xcustomer_data WHERE customer_id = '" . (int)$customer_id . "'");
		if($query->num_rows)
			return $query->row['full_telephone'];
		else 
			return '';
	}

	/*public function getActivitySession() {
		if (!isset($this->session->data[$this->cookie_name])) {
			$token = token(32);
			$token_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "xtensions_activity_step_by_step` WHERE activity_session_code = '" . $this->db->escape($token) . "'");
			if ($token_query->num_rows) {
				return $this->getActivitySession();
			} else {
				$this->session->data[$this->cookie_name] = $token;
				$this->db->query("INSERT INTO `" . DB_PREFIX . "xtensions_activity_order` SET `activity_session_code` = '" . $this->db->escape($token) . "', `date_added` = NOW()");
			}
		}
		return $this->session->data[$this->cookie_name];
	}*/
	
	private function getActivityData(){
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "xtensions_activity_order` WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
		if($query->num_rows){
			return $query->row;
		}
		return array();
	}
	
	private function enabled(){
		if(!$this->config->get($this->xabandoned_config_pfx .'status')){
			$this->enabled = false;
			return ;
		}		
		if (trim($this->config->get($this->xabandoned_config_pfx .'disabled_user_agents')) && !empty($user_agents = explode("\n", trim($this->config->get($this->xabandoned_config_pfx .'disabled_user_agents')))) && isset($this->request->server['HTTP_USER_AGENT']) && trim($this->request->server['HTTP_USER_AGENT'])) {
			if(is_array($user_agents)){
				foreach ($user_agents as $user_agent){
					if(trim($user_agent) && strpos(trim($this->request->server['HTTP_USER_AGENT']), $user_agent) !== false){
						$this->enabled = false;
						return;
					}
				}	
			}
		}
		if (trim($this->config->get($this->xabandoned_config_pfx .'disabled_ips')) && !empty($disabled_ips = explode("\n", trim($this->config->get($this->xabandoned_config_pfx .'disabled_ips')))) && isset($this->request->server['REMOTE_ADDR']) && trim($this->request->server['REMOTE_ADDR'])) {
			if(is_array($disabled_ips) && in_array(trim($this->request->server['REMOTE_ADDR']), $disabled_ips)){
				$this->enabled = false;
				return;
			}
		}
		$this->enabled = (isset($this->request->server['HTTP_USER_AGENT']) && $this->request->server['HTTP_USER_AGENT']);
	}
	
	public function getActivitySession() {
		if($this->enabled){
			if($this->config->get($this->xabandoned_config_pfx .'session_option') == 'cookie'){
				$code = '';
			
				if (isset($this->session->data[$this->cookie_name])) {
					$code = $this->session->data[$this->cookie_name];
				}
			
				if (isset($this->request->cookie[$this->cookie_name])) {
					$code = $this->request->cookie[$this->cookie_name];
				}
				
				if (!isset($this->session->data[$this->cookie_name]) || $this->session->data[$this->cookie_name] != $code) {
					if($code){
						$token_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "xtensions_activity_order` WHERE activity_session_code = '" . $this->db->escape($code) . "' AND last_step <> '4'");
						if ($token_query->num_rows) {
							$this->session->data[$this->cookie_name] = $code;
						}else{
							unset($this->session->data[$this->cookie_name]);
						}
					}
				}
			}
			
			if (!isset($this->session->data[$this->cookie_name])) {
				$token = token(32);
				$token_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "xtensions_activity_order` WHERE activity_session_code = '" . $this->db->escape($token) . "'");
				if ($token_query->num_rows) {
					return $this->getActivitySession();
				} else {
					$this->session->data[$this->cookie_name] = $token;
					if($this->config->get($this->xabandoned_config_pfx .'session_option') == 'cookie'){
						$this->request->cookie[$this->cookie_name] = $token;
						setcookie($this->cookie_name, $this->session->data[$this->cookie_name], time() + 60 * 60 * 24 * $this->config->get($this->xabandoned_config_pfx .'cookie_days'), '/', $this->request->server['HTTP_HOST']);
					}
					$this->db->query("INSERT INTO `" . DB_PREFIX . "xtensions_activity_order` SET `activity_session_code` = '" . $this->db->escape($token) . "', `date_added` = NOW()");
					$this->activitySessionCode = $token;
					$this->user_agent();
				}
			} else {
				$token_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "xtensions_activity_order` WHERE activity_session_code = '" . $this->db->escape($this->session->data[$this->cookie_name]) . "'");
				if (!$token_query->num_rows) {
					unset($this->session->data[$this->cookie_name]);
					return $this->getActivitySession();
				}
			}
			if($this->config->get($this->xabandoned_config_pfx .'session_option') == 'cookie'){
				if (!isset($this->request->cookie[$this->cookie_name]) || $this->request->cookie[$this->cookie_name] != $this->session->data[$this->cookie_name]) {
					setcookie($this->cookie_name, $this->session->data[$this->cookie_name], time() + 60 * 60 * 24 * $this->config->get($this->xabandoned_config_pfx .'cookie_days'), '/', $this->request->server['HTTP_HOST']);
				}
			}
			return $this->session->data[$this->cookie_name];
		}
		return '';
	}
	
	private function setPage(){
		if(!$this->page){
			$this->page = (isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : (isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : ""));
			$arr = explode("&_=", $this->page);
			$this->page  = $arr[0];
		}
		if(!$this->referer){
			$this->referer = (isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : (isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : ""));
			$arr = explode("&_=", $this->referer);
			$this->referer  = $arr[0];
		}
	}
	
	private function addPage(){
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET page = '" . $this->db->escape($this->page) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET referer = '" . $this->db->escape($this->referer) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
	}

	private function cart() {
		//$this->load->language('checkout/checkout');
		$products = array();

		foreach ($this->cart->getProducts() as $product) {
			$option_data = array();
			// Nothing but just a solution for one of the opencart's bundle module - start
			$option_key_data = array();
			$cart_key_query = $this->db->query("SELECT `option` FROM " . DB_PREFIX . "cart WHERE cart_id = '" . $this->db->escape($product['cart_id']) . "'");
			if($cart_key_query->num_rows){
				$option_keys = json_decode($cart_key_query->row['option'],true);
				if(isset($option_keys['cart_key'])){
					$option_key_data['cart_key'] = $option_keys['cart_key'];
				}
			}
			// Nothing but just a solution for one of the opencart's bundle module - end

			foreach ($product['option'] as $option) {
				if($option['type'] == 'checkbox'){
					$option_data[$option['product_option_id']][$option['product_option_value_id']] = array(
						'product_option_id'       => $option['product_option_id'],
						'product_option_value_id' => $option['product_option_value_id'],
						'option_id'               => $option['option_id'],
						'option_value_id'         => $option['option_value_id'],
						'name'                    => $option['name'],
						'value'                   => $option['value'],
						'type'                    => $option['type']
					);
				}else{
					$option_data[$option['product_option_id']] = array(
						'product_option_id'       => $option['product_option_id'],
						'product_option_value_id' => $option['product_option_value_id'],
						'option_id'               => $option['option_id'],
						'option_value_id'         => $option['option_value_id'],
						'name'                    => $option['name'],
						'value'                   => $option['value'],
						'type'                    => $option['type']
					);
				}
			}

			$products[] = array(
				'product_id' => $product['product_id'],
				'recurring'	=> $product['recurring'],
				'name'       => $product['name'],
				'model'      => $product['model'],
				'option'     => $option_data,
				// Nothing but just a solution for one of the opencart's bundle module - start
				'option_key'     => $option_key_data,
				// Nothing but just a solution for one of the opencart's bundle module - end
				'download'   => $product['download'],
				'quantity'   => $product['quantity'],
				'subtract'   => $product['subtract'],
				'price_formatted'      => $this->currency->format($product['price'], $this->session->data['currency']),
				'price'      => $product['price'],
				'total_formatted'      => $this->currency->format($product['total'], $this->session->data['currency']),
				'total'      => $product['total'],
				'tax'        => $this->tax->getTax($product['price'], $product['tax_class_id']),
				'reward'     => $product['reward']
			);
		}

		// Gift Voucher
		$vouchers = array();

		if (!empty($this->session->data['vouchers'])) {
			foreach ($this->session->data['vouchers'] as $voucher) {
				$vouchers[] = array(
					'description'      => $voucher['description'],
					'code'             => token(10),
					'to_name'          => $voucher['to_name'],
					'to_email'         => $voucher['to_email'],
					'from_name'        => $voucher['from_name'],
					'from_email'       => $voucher['from_email'],
					'voucher_theme_id' => $voucher['voucher_theme_id'],
					'message'          => $voucher['message'],
					'amount_formatted' => $this->currency->format($voucher['amount'], $this->session->data['currency']),
					'amount'           => $this->currency->convert($voucher['amount'], $this->config->get('config_currency'), $this->session->data['currency'])
				);
			}
		}
		$this->cart_data = (!empty($products) || !empty($vouchers))?array('products'=>json_encode($products),'vouchers'=>json_encode($vouchers)):array();
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET cart = '" . $this->db->escape(!empty($this->cart_data)?json_encode($this->cart_data):'') . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
	}

	private function store() {
		if ($this->config->get('config_store_id')) {
				$store_url = $this->config->get('config_url');
		} else {
			if ($this->request->server['HTTPS']) {
				$store_url = HTTPS_SERVER;
			} else {
				$store_url = HTTP_SERVER;
			}
		}
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET store_id = '" . (int)$this->config->get('config_store_id') . "', store_name = '" . $this->db->escape($this->config->get('config_name')) . "', store_url = '" . $this->db->escape($store_url) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
	}	
	
	private function ip() {
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
	}	
	
	private function total() {
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET order_total = '" . (isset($this->session->data['xtensions_total_price']) ? $this->db->escape($this->session->data['xtensions_total_price']) : 0) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
	}
	
	private function date_modified() {
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET date_modified = now() WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
	}
	
	private function totals($totals=array()) {
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET totals = '" . $this->db->escape(json_encode($totals)) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
	}

	private function step($step = 0) {
		if(!$step){
			$step = $this->session->data['xtensions_checkout_step'];
		}
		$activity = $this->getActivityData();
		if(!empty($activity) && $activity['last_step']=='4'){
			return ;
		}
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET last_step = '" . (int)$step . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
	}
	
	private function unsubscribe($email){
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET unsubscribe = '1' WHERE email = '" . $this->db->escape($email) . "'");
	}
	
	private function order_success(){
		$this->step(4);
		$this->addEvent('order_success');
		if(isset($this->session->data['xtensions_abandoned_email'])){
			$this->delete($this->session->data['xtensions_abandoned_email']);
			unset($this->session->data['xtensions_abandoned_email']);
		}
		$this->session->data['xtensions_activity_order_placed'] = true;
		$this->unsetActivity();
	}
	
	private function delete($email){
		if(isset($this->session->data[$this->cookie_name])){
			$query = $this->db->query("SELECT activity_session_code FROM `" . DB_PREFIX . "xtensions_activity_order` WHERE email = '" . $this->db->escape($email) . "' AND activity_session_code <> '" . $this->db->escape($this->session->data[$this->cookie_name]) . "' AND last_step <> 4 AND store_id = '" . (int)$this->config->get('config_store_id') . "'");
			foreach ($query->rows as $row){
				$this->deleteActivity($row['activity_session_code']);
			}
		}
	}
	
	private function deleteActivity($activity_code){
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_to_mail WHERE activity_session_code = '" . $this->db->escape($activity_code) . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_step_by_step WHERE activity_session_code = '" . $this->db->escape($activity_code) . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "xtensions_activity_order WHERE activity_session_code = '" . $this->db->escape($activity_code) . "'");
	}

	private function unsetActivity(){
		if($this->config->get($this->xabandoned_config_pfx .'session_option') == 'cookie'){
			if(isset($this->request->cookie[$this->cookie_name])){
				setcookie($this->cookie_name, '', time() - 3600, '/', $this->request->server['HTTP_HOST']);
			}
		}
		if(isset($this->session->data[$this->cookie_name])){
			unset($this->session->data[$this->cookie_name]);
		}
	}
	
	private function order() {
		if(isset($this->session->data['order_id'])){
			$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET order_id = '" . (int)$this->session->data['order_id'] . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
		}
	}

	private function language() {
		if(isset($this->session->data['language'])){
			$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET language_code = '" . $this->db->escape($this->session->data['language']) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
		}
	}

	private function currency() {
		if(isset($this->session->data['currency'])){
			$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET currency_code = '" . $this->db->escape($this->session->data['currency']) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
		}
	}
	
	private function payment_method(){
		if(isset($this->session->data['payment_method']) && isset($this->session->data['payment_method']['title'])){
			$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET payment_method = '" . $this->db->escape($this->session->data['payment_method']['title']) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
		}
	}
	
	private function clear($event){
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET ". $event ." = '' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
	}
	
	private function shipping_method(){
		if(isset($this->session->data['shipping_method']) && isset($this->session->data['shipping_method']['title'])){
			$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET shipping_method = '" . $this->db->escape($this->session->data['shipping_method']['title']) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
		}
	}
	
	private function user_agent(){
		if(isset($this->request->server['HTTP_USER_AGENT'])){
			$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET user_agent = '" . $this->db->escape($this->request->server['HTTP_USER_AGENT']) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
		}
	}
	private function name(){
		$customer_data = $this->getCustomer();
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET customer_id = '" . (int)($customer_data['customer_id']) . "', name = '" . $this->db->escape($customer_data['name']) . "', firstname = '" . $this->db->escape($customer_data['firstname']) . "', lastname = '" . $this->db->escape($customer_data['lastname']) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
	}
	
	private function payment_address(){
		if(isset($this->session->data['payment_address']) && isset($this->session->data['payment_address']['formatted_address'])){
			$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET payment_address = '" . $this->db->escape($this->session->data['payment_address']['formatted_address']) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
		}
	}
	
	private function shipping_address(){
		if(isset($this->session->data['shipping_address']) && isset($this->session->data['shipping_address']['formatted_address'])){
			$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET shipping_address = '" . $this->db->escape($this->session->data['shipping_address']['formatted_address']) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
		}
	}

	private function email(){
		$customer_data = $this->getCustomer();
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET email = '" . $this->db->escape($customer_data['email']) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
	}
	
	private function telephone(){
		$customer_data = $this->getCustomer();
		$this->db->query("UPDATE `" . DB_PREFIX . "xtensions_activity_order` SET telephone = '" . $this->db->escape($customer_data['telephone']) . "', country_code = '" . $this->db->escape($customer_data['country_code']) . "', full_telephone = '" . $this->db->escape($customer_data['full_telephone']) . "' WHERE activity_session_code = '" . $this->db->escape($this->activitySessionCode) . "'");
	}
	
	private function getActivityFromLittle($event){
		switch ($event) {
			case 'currency_changed':
				$this->currency();
				break;
			case 'language_changed':
				$this->language();
				break;
			case 'cart_added':	
			case 'cart_edited':
			case 'cart_product_removed':
			case 'cart_product_moved_to_wishlist':	
				$this->cart();
				break;
			case 'entered_step_1':
				$this->step(1);
				break;
			case 'entered_step_2':
			case 'entered_guest_step_2':
				$this->step(2);
				break;
			case 'entered_step_3':
				$this->step(3);
				break;
			case 'order_success':
				$this->step(4);
				break;		
			case 'shipping_method_changed':
				$this->shipping_method();
				break;
			case 'payment_method_changed':
				$this->payment_method();
				break;
			case 'address_changed':
			case 'saddress_changed':			
			case 'address_deleted':
			case 'address_same':
			case 'address_different':	
				$this->payment_address();
				$this->shipping_address();
				break;
			case 'no_shipping_method':
				$this->clear('shipping_method');
				break;
			case 'no_payment_method';	
				$this->clear('payment_method');
				break;
			default:	
				null;	
		}
	}

	private function addEvent($event,$additional=array()) {
		$customer_data = $this->getCustomer();
		$is_event = true;
		$data = array();
		switch ($event) {
			case 'referred_from_mail':
				$data[$event] = $this->request->get['activity_session_code'];
				break;	
			case 'coupon_success':
			case 'coupon_invalid':
				$data[$event] = $this->request->post['coupon'];
				break;	
			case 'voucher_success':
			case 'voucher_invalid':
				$data[$event] = $this->request->post['voucher'];
				break;
			case 'reward_success':
			case 'reward_more_than_products':
			case 'reward_more_than_capacity':
				$data[$event] = $this->request->post['reward'];
				break;
			case 'currency_changed':
				$data[$event] = $this->session->data['currency'];
				$this->currency();
				break;
			case 'language_changed':
				$data[$event] = $this->session->data['language'];
				$this->language();
				break;	
			case 'cart_added':		
			case 'cart_edited':
			case 'cart_product_removed':
			case 'cart_product_moved_to_wishlist':	
				$this->cart();
				$data[$event] = $this->cart_data;				
				break;
			case 'order_comment_added':
				$data[$event] = (isset($this->session->data['comment'])?$this->session->data['comment']:'');
				break;
			case 'entered_step_1':
				$data[$event] = 1;
				$this->step(1);
				break;
			case 'entered_step_2':
			case 'entered_guest_step_2':
				$data[$event] = 2;
				$this->step(2);
				break;
			case 'entered_step_3':
				$data[$event] = 3;
				$this->step(3);
				break;
			case 'order_success':
				$data[$event] = 4;
				$this->step(4);
				break;	
			case 'login_attempt_unsuccessful':				
			case 'add_address_unsuccessful':
			case 'add_guest_payment_address_unsuccessful':
			case 'add_guest_shipping_address_unsuccessful':
			case 'add_address_successful':
			case 'add_guest_payment_address_successful':
			case 'add_guest_shipping_address_successful':
			case 'edit_address_unsuccessful':
			case 'edit_address_successful':
			case 'social_login_registration_unsuccesful':	
				$data[$event] = '';
				$data = array_merge($data,$additional,array('post'=>$this->formatData($this->request->post)));
				break;	
			case 'social_login_registration_successful':	
			case 'registration_unsuccessful':
			case 'guest_step1_unsuccessful':	
				$data[$event] = $this->request->post['email'];
				$data = array_merge($data,$additional,array('post'=>$this->formatData($this->request->post)));
				break;
			case 'registration_successful':			
			case 'guest_step1_successful':		
				$data[$event] = $this->request->post['email'];
				$data = array_merge($data,$customer_data,array('post'=>$this->formatData($this->request->post)));
				break;
			case 'registration_successful_pending_approval':
			case 'social_login_registration_successful_pending_approval':	
				$data[$event] = $this->request->post['email'];
				break;
			case 'address_changed':
			case 'saddress_changed':			
			case 'address_deleted':
				$this->payment_address();
				$this->shipping_address();
				$data[$event] = $this->formatData($this->request->post);
				$data = array_merge($data,$additional);
				break;	
			case 'social_login':
			case 'social_login_logged_in':	
				$data[$event] = $this->formatData($this->request->post);
				$data = array_merge($data,$additional);
				break;		
			case 'coupon_blank':
			case 'coupon_removed':				
			case 'voucher_blank':
			case 'voucher_removed':	
			case 'reward_blank':
			case 'reward_removed':
			case 'login_attempt_successful':
			case 'persistent_cart':
				$data[$event] = '';
				break;
			case 'address_same':
			case 'address_different':	
				$this->payment_address();
				$this->shipping_address();
				$data[$event] = '';
				break;
			case 'error_stock_warning':
				if(!isset($this->session->data['xtensions_error_stock_warning'])){
					$this->session->data['xtensions_error_stock_warning'] = true;
					$data[$event] = '';
				}
				break;
			case 'no_error_stock_warning':
				if(isset($this->session->data['xtensions_error_stock_warning'])){
					unset($this->session->data['xtensions_error_stock_warning']);
				}
				break;
			case 'error_minimum_warning':
				if(!isset($this->session->data['xtensions_error_minimum_warning'])){
					$this->session->data['xtensions_error_minimum_warning'] = true;
					$data[$event] = '';
				}
				break;
			case 'no_error_minimum_warning':
				if(isset($this->session->data['xtensions_error_minimum_warning'])){
					unset($this->session->data['xtensions_error_minimum_warning']);
				}
				break;	
			case 'no_shipping_method':
				$this->clear('shipping_method');
				if(!isset($this->session->data['no_shipping_method'])){
					$this->session->data['no_shipping_method'] = true;
					$data[$event] = '';
				}
				break;
			case 'shipping_method_changed':
				if(isset($this->session->data['no_shipping_method'])){
					unset($this->session->data['no_shipping_method']);
				}
				$this->shipping_method();
				$shipping_method = (isset($this->session->data['shipping_method'])?$this->session->data['shipping_method']:array());
				if(!isset($this->session->data['xtensions_activity_shipping']) || (isset($shipping_method['code']) && isset($this->session->data['xtensions_activity_shipping']) && $this->session->data['xtensions_activity_shipping'] != $shipping_method['code']) ){
					$data[$event] = (isset($this->session->data['shipping_method'])?$this->session->data['shipping_method']:'');	
				}
				if(isset($shipping_method['code'])){
					$this->session->data['xtensions_activity_shipping'] = $shipping_method['code'];
				}
				break;
			case 'no_payment_method';	
				$this->clear('payment_method');
				if(!isset($this->session->data['no_payment_method'])){
					$this->session->data['no_payment_method'] = true;
					$data[$event] = '';
				}
				break;	
			case 'payment_method_changed':
				if(isset($this->session->data['no_payment_method'])){
					unset($this->session->data['no_payment_method']);
				}
				$this->payment_method();
				$data[$event] = (isset($this->session->data['payment_method'])?$this->session->data['payment_method']:'');
				break;	
			case 'persistent_logged_in':
				$data[$event] = $this->customer->getEmail();
				break;
			default:	
				$is_event = false;
		}
		if($is_event && $data){
			$this->db->query("INSERT INTO `" . DB_PREFIX . "xtensions_activity_step_by_step` SET `customer_id` = '" . (int)$customer_data['customer_id'] . "', `key` = '" . $this->db->escape($event) . "', `data` = '" . $this->db->escape(json_encode($data)) . "',`activity_session_code` = '" . $this->db->escape($this->activitySessionCode) . "', `ip` = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "', `page` = '" . $this->db->escape($this->page) . "', `referer` = '" . $this->db->escape($this->referer) . "', `date_added` = NOW()");
		}
	}
	
	private function formatData($data){
		if(isset($data['password'])){
			$data['password'] = str_repeat("*", strlen($data['password'])); 
		}
		if(isset($data['confirm'])){
			$data['confirm'] = str_repeat("*", strlen($data['confirm'])); 
		}
		return $data;
	}
	
	public function install() {
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_order` (
						  `activity_session_code` varchar(64) NOT NULL,
						  `order_id` int(11) DEFAULT '0',
						  `firstname` varchar(32) NOT NULL,
						  `lastname` varchar(32) NOT NULL,
						  `name` varchar(96) NOT NULL,
						  `email` varchar(96) NOT NULL,
						  `telephone` varchar(32) NOT NULL DEFAULT '',
						  `cart` text,
						  `last_step` tinyint(3) NOT NULL,
						  `currency_code` varchar(3) NOT NULL,
						  `language_code` varchar(5) NOT NULL,
						  `order_total` varchar(32) NOT NULL DEFAULT '',
						  `date_added` datetime NOT NULL,
						  `customer_id` int(11) NOT NULL DEFAULT '0',
						  `ip` varchar(40) NOT NULL,
						  `store_id` int(11) NOT NULL DEFAULT '0',
						  `store_name` varchar(255) NOT NULL DEFAULT '',
						  `store_url` varchar(255) NOT NULL DEFAULT '',
						  `totals` text,
						  `payment_method` varchar(128) NOT NULL,
						  `shipping_method` varchar(128) NOT NULL,
						  `user_agent` varchar(255) NOT NULL,
						  `payment_address` text NOT NULL,
						  `shipping_address` text NOT NULL,
						  `last_mail_sent` datetime NOT NULL,
						  `unsubscribe` tinyint(1) NOT NULL DEFAULT '0',
						  `page` text,
						  PRIMARY KEY (`activity_session_code`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_step_by_step` (
						  `xcustomer_activity_id` int(11) NOT NULL AUTO_INCREMENT,
						  `customer_id` int(11) NOT NULL,
						  `key` varchar(64) NOT NULL,
						  `data` text NOT NULL,
						  `ip` varchar(40) NOT NULL,
						  `page` text,
						  `date_added` datetime NOT NULL,
						  `activity_session_code` varchar(64) NOT NULL,
						  `referer` text,
						  PRIMARY KEY (`xcustomer_activity_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_mail_template` (
						  `template_id` int(11) NOT NULL AUTO_INCREMENT,
						  `status` tinyint(1) NOT NULL,
						  `title` varchar(225) NOT NULL,
						  `first_mail` int(11) NOT NULL,
						  `next_mails` int(11) NOT NULL,
						  `maximum_mails` int(11) NOT NULL,
						  `first_mail_duration` int(11) NOT NULL,
						  `next_mail_duration` int(11) NOT NULL,
						  `shipping` tinyint(1) NOT NULL,
						  `customer_login` tinyint(1) NOT NULL,
						  `discount_type` char(1) NOT NULL,
						  `discount` int(11) NOT NULL,
						  `amount` int(11) NOT NULL,
						  `validity` int(11) NOT NULL,
						  `discount_product` tinyint(1) NOT NULL,
						  `width` int(11) NOT NULL,
						  `height` int(11) NOT NULL,
						  PRIMARY KEY (`template_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_mail_template_description` (
						  `template_id` int(11) NOT NULL,
						  `language_id` int(11) NOT NULL,
						  `subject_title` varchar(255) NOT NULL,
						  `subject_description` text NOT NULL,
						  PRIMARY KEY (`template_id`,`language_id`),
						  KEY `subject_title` (`subject_title`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_mail_to_cron` (
						  `template_cron_id` int(11) NOT NULL AUTO_INCREMENT,
						  `template_id` int(11) NOT NULL,
						  `sort_order` int(3) NOT NULL DEFAULT '0',
						  `value` varchar(64) DEFAULT NULL,
						  `store_id` int(11) NOT NULL DEFAULT '0',
						  PRIMARY KEY (`template_cron_id`),
						  KEY `template_id` (`template_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_to_mail` (
						  `activity_mail_id` int(11) NOT NULL AUTO_INCREMENT,
						  `activity_session_code` varchar(64) NOT NULL,
						  `template_id` int(11) NOT NULL,
						  `coupon_id` int(11) NOT NULL DEFAULT '0',
						  `coupon_code` varchar(20) NOT NULL,
						  `opened` int(11) NOT NULL DEFAULT '0',
						  `date_added` datetime NOT NULL,
						  PRIMARY KEY (`activity_mail_id`),
						  KEY `activity_session_code` (`activity_session_code`),
						  KEY `template_id` (`template_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_unsubscription` (
						  `email_id` int(11) NOT NULL AUTO_INCREMENT,
						  `email` varchar(96) NOT NULL,
						  `date_added` datetime NOT NULL,
						  PRIMARY KEY (`email_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_extras` (
						  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
						  `store_id` INT(11) NOT NULL DEFAULT '0',
						  `key` VARCHAR(64) NOT NULL,
						  `value` LONGTEXT NOT NULL,
						  `serialized` TINYINT(4) NOT NULL,
						  PRIMARY KEY (`setting_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_daily_email` (
						  `activity_mail_id` int(11) NOT NULL AUTO_INCREMENT,
						  `activity_session_code` varchar(64) NOT NULL,
						  `store_id` int(11) NOT NULL,
						  `email` varchar(96) NOT NULL,
						  `template_id` int(11) NOT NULL,
						  `date_added` datetime NOT NULL,
						  PRIMARY KEY (`activity_mail_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_daily_telephone` (
						  `activity_mail_id` INT(11) NOT NULL AUTO_INCREMENT,
						  `activity_session_code` VARCHAR(64) NOT NULL,
						  `store_id` INT(11) NOT NULL,
						  `telephone` VARCHAR(96) NOT NULL,
						  `country_code` VARCHAR(10) NOT NULL,
						  `full_telephone` VARCHAR(40) NOT NULL,
						  `template_id` INT(11) NOT NULL,
						  `date_added` DATETIME NOT NULL,
						  PRIMARY KEY (`activity_mail_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "xtensions_activity_to_telephone` (
						  `activity_mail_id` int(11) NOT NULL AUTO_INCREMENT,
						  `activity_session_code` varchar(64) NOT NULL,
						  `template_id` int(11) NOT NULL,
						  `coupon_id` int(11) NOT NULL DEFAULT '0',
						  `coupon_code` varchar(20) NOT NULL,
						  `date_added` datetime NOT NULL,
						  `clicked` int(11) NOT NULL DEFAULT '0',
						  PRIMARY KEY (`activity_mail_id`),
						  KEY `activity_session_code` (`activity_session_code`),
						  KEY `template_id` (`template_id`)
						) ENGINE=MyISAM DEFAULT CHARSET=utf8;
					");
		$this->upgrade();
	}
	
	public function upgrade(){	
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_order' AND COLUMN_NAME = 'date_modified'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_order` ADD COLUMN (`date_modified` datetime NOT NULL)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_order' AND COLUMN_NAME = 'referer'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_order` ADD COLUMN (`referer` TEXT)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_mail_template' AND COLUMN_NAME = 'maximum_time'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_mail_template` ADD COLUMN (`maximum_time` INT(11) NOT NULL)");
		}	
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_mail_template' AND COLUMN_NAME = 'maximum_time_duration'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_mail_template` ADD COLUMN (`maximum_time_duration` INT(11) NOT NULL)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_mail_template' AND COLUMN_NAME = 'max_mail_per_day_per_email'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_mail_template` ADD COLUMN (`max_mail_per_day_per_email` INT(11) NOT NULL DEFAULT 1)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_order' AND COLUMN_NAME = 'country_code'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_order` ADD COLUMN (`country_code` varchar(10) NOT NULL)");
		}		
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_order' AND COLUMN_NAME = 'full_telephone'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_order` ADD COLUMN (`full_telephone` varchar(40) NOT NULL)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_mail_template' AND COLUMN_NAME = 'is_sms'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_mail_template` ADD COLUMN (`is_sms` tinyint(1) NOT NULL)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_mail_template_description' AND COLUMN_NAME = 'sms_body'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_mail_template_description` ADD COLUMN (`sms_body` text NOT NULL)");
		}
		$query = $this->db->query("SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '".DB_DATABASE."' AND TABLE_NAME = '".DB_PREFIX."xtensions_activity_mail_template_description' AND COLUMN_NAME = 'sms_template_id'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `". DB_PREFIX ."xtensions_activity_mail_template_description` ADD COLUMN (`sms_template_id` VARCHAR(128) NOT NULL)");
		}
	}
}
