<?php
class ControllerCommonHeader extends Controller {
	public function index() {
		// Analytics
		$this->load->model('setting/extension');

		$data['analytics'] = array();

		$analytics = $this->model_setting_extension->getExtensions('analytics');

		foreach ($analytics as $analytic) {
			if ($this->config->get('analytics_' . $analytic['code'] . '_status')) {
				$data['analytics'][] = $this->load->controller('extension/analytics/' . $analytic['code'], $this->config->get('analytics_' . $analytic['code'] . '_status'));
			}
		}

		if ($this->request->server['HTTPS']) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}

		if (is_file(DIR_IMAGE . $this->config->get('config_icon'))) {
			$this->document->addLink($server . 'image/' . $this->config->get('config_icon'), 'icon');
		}

		$data['title'] = $this->document->getTitle();

		$data['base'] = $server;
		$data['description'] = $this->document->getDescription();
		$data['keywords'] = $this->document->getKeywords();
		$data['links'] = $this->document->getLinks();
		$data['styles'] = $this->document->getStyles();
		$data['scripts'] = $this->document->getScripts('header');
		$data['lang'] = $this->language->get('code');
		$data['direction'] = $this->language->get('direction');

		$data['name'] = $this->config->get('config_name');

		if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
			$data['logo'] = $server . 'image/' . $this->config->get('config_logo');
		} else {
			$data['logo'] = '';
		}


			    $ga_customer_id = false;
			    
			    if ($this->customer->isLogged()) {
			        $ga_customer_id =  (int)$this->customer->getId();
			    }elseif ($this->config->get('ga_ecom_ip_match')) {
			        if (isset($_SERVER['REMOTE_ADDR'])) {
			            $ip = $_SERVER['REMOTE_ADDR'];
			            $customer_ip = $this->db->query("SELECT customer_id FROM ".DB_PREFIX."customer_ip WHERE `ip` = '".$this->db->escape($ip)."' LIMIT 1");
			            if ($customer_ip->row) {
			                $ga_customer_id = $customer_ip->row['customer_id'];
			            }
			        }
			    }
			    
			    if ($ga_customer_id && $this->config->get('ga_ecom_user_tracking')) {
			        $data['ga_user_tracking_script'] = "<script>gtag('set', {'user_id': '".$ga_customer_id."'});</script>";
			    }else{
			        $data['ga_user_tracking_script'] = '';
			    }
			    
				$this->load->model('extension/module/google_ecommerce');
			    
			    if ($this->config->get('ga_ecom_tracking_code')){ 
			        $data['google_analytics_script'] = html_entity_decode($this->config->get('ga_ecom_tracking_code'), ENT_QUOTES, 'UTF-8');
			    }else{
			        $data['google_analytics_script'] = '';
			    }
			    
			    if ($this->config->get('ga_ecom_fb_px_id')){ 
			        $data['fb_pixel_script'] = $this->model_extension_module_google_ecommerce->pixel_base_code($this->config->get('ga_ecom_fb_px_id'));
			    }else{
			        $data['fb_pixel_script'] = '';
			    }
			    
			    if ($this->config->get('ga_ecom_event_language')){ 
			        $data['event_lang_script'] = true;
			    }else{
			        $data['event_lang_script'] = false;
			    }
			
		$this->load->language('common/header');

		// Wishlist
		if ($this->customer->isLogged()) {
			$this->load->model('account/wishlist');

			$data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), $this->model_account_wishlist->getTotalWishlist());
		} else {
			$data['text_wishlist'] = sprintf($this->language->get('text_wishlist'), (isset($this->session->data['wishlist']) ? count($this->session->data['wishlist']) : 0));
		}

		$data['text_logged'] = sprintf($this->language->get('text_logged'), $this->url->link('account/account', '', true), $this->customer->getFirstName(), $this->url->link('account/logout', '', true));
		
		$data['home'] = $this->url->link('common/home');
		$data['wishlist'] = $this->url->link('account/wishlist', '', true);
		$data['logged'] = $this->customer->isLogged();
		$data['account'] = $this->url->link('account/account', '', true);
		$data['register'] = $this->url->link('account/register', '', true);
		$data['login'] = $this->url->link('account/login', '', true);
		$data['order'] = $this->url->link('account/order', '', true);
		$data['transaction'] = $this->url->link('account/transaction', '', true);
		$data['download'] = $this->url->link('account/download', '', true);
		$data['logout'] = $this->url->link('account/logout', '', true);
		$data['shopping_cart'] = $this->url->link('checkout/cart');
		$data['checkout'] = $this->url->link('checkout/checkout', '', true);
		$data['contact'] = $this->url->link('information/contact');
		$data['telephone'] = $this->config->get('config_telephone');
		
		$data['language'] = $this->load->controller('common/language');
		$data['currency'] = $this->load->controller('common/currency');
		$data['search'] = $this->load->controller('common/search');
		$data['cart'] = $this->load->controller('common/cart');
		$data['menu'] = $this->load->controller('common/menu');

		return $this->load->view('common/header', $data);
	}
}
